/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.ClientProcessingPlan;
import org.apache.phoenix.execute.visitor.AvgRowWidthVisitor;
import org.apache.phoenix.execute.visitor.ByteCountVisitor;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.execute.visitor.RowCountVisitor;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.expression.aggregator.ClientAggregators;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.BaseGroupedAggregatingResultIterator;
import org.apache.phoenix.iterate.ClientHashAggregatingResultIterator;
import org.apache.phoenix.iterate.DistinctAggregatingResultIterator;
import org.apache.phoenix.iterate.FilterAggregatingResultIterator;
import org.apache.phoenix.iterate.FilterResultIterator;
import org.apache.phoenix.iterate.GroupedAggregatingResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.OffsetResultIterator;
import org.apache.phoenix.iterate.OrderedAggregatingResultIterator;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.UngroupedAggregatingResultIterator;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.CostUtil;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.TupleUtil;

public class ClientAggregatePlan
extends ClientProcessingPlan {
    private final GroupByCompiler.GroupBy groupBy;
    private final Expression having;
    private final ServerAggregators serverAggregators;
    private final ClientAggregators clientAggregators;
    private final boolean useHashAgg;
    private OrderByCompiler.OrderBy actualOutputOrderBy;

    public ClientAggregatePlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, Integer offset, Expression where, OrderByCompiler.OrderBy orderBy, GroupByCompiler.GroupBy groupBy, Expression having, QueryPlan delegate) {
        super(context, statement, table, projector, limit, offset, where, orderBy, delegate);
        this.groupBy = groupBy;
        this.having = having;
        this.clientAggregators = context.getAggregationManager().getAggregators();
        this.serverAggregators = ServerAggregators.deserialize(context.getScan().getAttribute("_Aggs"), context.getConnection().getQueryServices().getConfiguration(), null);
        HintNode hints = statement.getHint();
        this.useHashAgg = hints != null && hints.hasHint(HintNode.Hint.HASH_AGGREGATE);
        this.actualOutputOrderBy = this.convertActualOutputOrderBy(orderBy, groupBy, context);
    }

    @Override
    public Cost getCost() {
        Double outputBytes = this.accept(new ByteCountVisitor());
        Double inputRows = this.getDelegate().accept(new RowCountVisitor());
        Double rowWidth = this.accept(new AvgRowWidthVisitor());
        if (inputRows == null || outputBytes == null || rowWidth == null) {
            return Cost.UNKNOWN;
        }
        double inputBytes = inputRows * rowWidth;
        double rowsBeforeHaving = RowCountVisitor.aggregate(RowCountVisitor.filter((double)inputRows, RowCountVisitor.stripSkipScanFilter(this.context.getScan().getFilter())), this.groupBy);
        double rowsAfterHaving = RowCountVisitor.filter(rowsBeforeHaving, this.having);
        double bytesBeforeHaving = rowWidth * rowsBeforeHaving;
        double bytesAfterHaving = rowWidth * rowsAfterHaving;
        int parallelLevel = CostUtil.estimateParallelLevel(false, this.context.getConnection().getQueryServices());
        Cost cost = CostUtil.estimateAggregateCost(inputBytes, bytesBeforeHaving, this.groupBy, parallelLevel);
        if (!this.orderBy.getOrderByExpressions().isEmpty()) {
            Cost orderByCost = CostUtil.estimateOrderByCost(bytesAfterHaving, outputBytes, parallelLevel);
            cost = cost.plus(orderByCost);
        }
        return super.getCost().plus(cost);
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        boolean spoolingEnabled;
        long thresholdBytes;
        AggregatingResultIterator aggResultIterator;
        ResultIterator iterator = this.delegate.iterator(scanGrouper, scan);
        if (this.where != null) {
            iterator = new FilterResultIterator(iterator, this.where);
        }
        if (this.groupBy.isEmpty()) {
            aggResultIterator = new ClientUngroupedAggregatingResultIterator(LookAheadResultIterator.wrap(iterator), this.serverAggregators);
            aggResultIterator = new UngroupedAggregatingResultIterator(LookAheadResultIterator.wrap(aggResultIterator), this.clientAggregators);
        } else {
            List<Expression> keyExpressions = this.groupBy.getKeyExpressions();
            if (this.groupBy.isOrderPreserving()) {
                aggResultIterator = new ClientGroupedAggregatingResultIterator(LookAheadResultIterator.wrap(iterator), this.serverAggregators, keyExpressions);
            } else {
                thresholdBytes = this.context.getConnection().getQueryServices().getProps().getLongBytes("phoenix.query.client.spoolThresholdBytes", 0x1400000L);
                spoolingEnabled = this.context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.client.orderBy.spooling.enabled", true);
                ArrayList keyExpressionOrderBy = Lists.newArrayListWithExpectedSize((int)keyExpressions.size());
                for (Expression keyExpression : keyExpressions) {
                    keyExpressionOrderBy.add(OrderByExpression.createByCheckIfOrderByReverse(keyExpression, false, true, false));
                }
                if (this.useHashAgg) {
                    aggResultIterator = new ClientHashAggregatingResultIterator(this.context, iterator, this.serverAggregators, keyExpressions, this.orderBy);
                } else {
                    iterator = new OrderedResultIterator(iterator, keyExpressionOrderBy, spoolingEnabled, thresholdBytes, null, null, this.projector.getEstimatedRowByteSize());
                    aggResultIterator = new ClientGroupedAggregatingResultIterator(LookAheadResultIterator.wrap(iterator), this.serverAggregators, keyExpressions);
                }
            }
            aggResultIterator = new GroupedAggregatingResultIterator(LookAheadResultIterator.wrap(aggResultIterator), this.clientAggregators);
        }
        if (this.having != null) {
            aggResultIterator = new FilterAggregatingResultIterator(aggResultIterator, this.having);
        }
        if (this.statement.isDistinct() && this.statement.isAggregate()) {
            aggResultIterator = new DistinctAggregatingResultIterator(aggResultIterator, this.getProjector());
        }
        ResultIterator resultScanner = aggResultIterator;
        if (this.orderBy.getOrderByExpressions().isEmpty()) {
            if (this.offset != null) {
                resultScanner = new OffsetResultIterator(resultScanner, this.offset);
            }
            if (this.limit != null) {
                resultScanner = new LimitingResultIterator(resultScanner, this.limit);
            }
        } else {
            thresholdBytes = this.context.getConnection().getQueryServices().getProps().getLongBytes("phoenix.query.client.spoolThresholdBytes", 0x1400000L);
            spoolingEnabled = this.context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.client.orderBy.spooling.enabled", true);
            resultScanner = new OrderedAggregatingResultIterator(aggResultIterator, this.orderBy.getOrderByExpressions(), spoolingEnabled, thresholdBytes, this.limit, this.offset);
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            resultScanner = new SequenceResultIterator(resultScanner, this.context.getSequenceManager());
        }
        return resultScanner;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ExplainPlan explainPlan = this.delegate.getExplainPlan();
        ArrayList planSteps = Lists.newArrayList(explainPlan.getPlanSteps());
        ExplainPlanAttributes explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
        ExplainPlanAttributes.ExplainPlanAttributesBuilder newBuilder = new ExplainPlanAttributes.ExplainPlanAttributesBuilder(explainPlanAttributes);
        if (this.where != null) {
            planSteps.add("CLIENT FILTER BY " + this.where.toString());
            newBuilder.setClientFilterBy(this.where.toString());
        }
        if (this.groupBy.isEmpty()) {
            planSteps.add("CLIENT AGGREGATE INTO SINGLE ROW");
            newBuilder.setClientAggregate("CLIENT AGGREGATE INTO SINGLE ROW");
        } else if (this.groupBy.isOrderPreserving()) {
            planSteps.add("CLIENT AGGREGATE INTO ORDERED DISTINCT ROWS BY " + this.groupBy.getExpressions().toString());
            newBuilder.setClientAggregate("CLIENT AGGREGATE INTO ORDERED DISTINCT ROWS BY " + this.groupBy.getExpressions().toString());
        } else if (this.useHashAgg) {
            planSteps.add("CLIENT HASH AGGREGATE INTO DISTINCT ROWS BY " + this.groupBy.getExpressions().toString());
            newBuilder.setClientAggregate("CLIENT HASH AGGREGATE INTO DISTINCT ROWS BY " + this.groupBy.getExpressions().toString());
            if (this.orderBy == OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY || this.orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY) {
                planSteps.add("CLIENT SORTED BY " + this.groupBy.getKeyExpressions().toString());
                newBuilder.setClientSortedBy(this.groupBy.getKeyExpressions().toString());
            }
        } else {
            planSteps.add("CLIENT SORTED BY " + this.groupBy.getKeyExpressions().toString());
            planSteps.add("CLIENT AGGREGATE INTO DISTINCT ROWS BY " + this.groupBy.getExpressions().toString());
            newBuilder.setClientSortedBy(this.groupBy.getKeyExpressions().toString());
            newBuilder.setClientAggregate("CLIENT AGGREGATE INTO DISTINCT ROWS BY " + this.groupBy.getExpressions().toString());
        }
        if (this.having != null) {
            planSteps.add("CLIENT AFTER-AGGREGATION FILTER BY " + this.having.toString());
            newBuilder.setClientAfterAggregate("CLIENT AFTER-AGGREGATION FILTER BY " + this.having.toString());
        }
        if (this.statement.isDistinct() && this.statement.isAggregate()) {
            planSteps.add("CLIENT DISTINCT ON " + this.projector.toString());
            newBuilder.setClientDistinctFilter(this.projector.toString());
        }
        if (this.offset != null) {
            planSteps.add("CLIENT OFFSET " + this.offset);
            newBuilder.setClientOffset(this.offset);
        }
        if (this.orderBy.getOrderByExpressions().isEmpty()) {
            if (this.limit != null) {
                planSteps.add("CLIENT " + this.limit + " ROW LIMIT");
                newBuilder.setClientRowLimit(this.limit);
            }
        } else {
            planSteps.add("CLIENT" + (String)(this.limit == null ? "" : " TOP " + this.limit + " ROW" + (this.limit == 1 ? "" : "S")) + " SORTED BY " + this.orderBy.getOrderByExpressions().toString());
            newBuilder.setClientRowLimit(this.limit);
            newBuilder.setClientSortedBy(this.orderBy.getOrderByExpressions().toString());
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            int nSequences;
            planSteps.add("CLIENT RESERVE VALUES FROM " + nSequences + " SEQUENCE" + ((nSequences = this.context.getSequenceManager().getSequenceCount()) == 1 ? "" : "S"));
            newBuilder.setClientSequenceCount(nSequences);
        }
        return new ExplainPlan(planSteps, newBuilder.build());
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return this.groupBy;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Expression getHaving() {
        return this.having;
    }

    private OrderByCompiler.OrderBy convertActualOutputOrderBy(OrderByCompiler.OrderBy orderBy, GroupByCompiler.GroupBy groupBy, StatementContext statementContext) {
        if (!orderBy.isEmpty()) {
            return OrderByCompiler.OrderBy.convertCompiledOrderByToOutputOrderBy(orderBy);
        }
        if (this.useHashAgg && !groupBy.isEmpty() && !groupBy.isOrderPreserving() && orderBy != OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY && orderBy != OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY) {
            return OrderByCompiler.OrderBy.EMPTY_ORDER_BY;
        }
        return ExpressionUtil.convertGroupByToOrderBy(groupBy, orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY);
    }

    @Override
    public List<OrderByCompiler.OrderBy> getOutputOrderBys() {
        return OrderByCompiler.OrderBy.wrapForOutputOrderBys(this.actualOutputOrderBy);
    }

    private static class ClientUngroupedAggregatingResultIterator
    extends BaseGroupedAggregatingResultIterator {
        public ClientUngroupedAggregatingResultIterator(PeekingResultIterator iterator, Aggregators aggregators) {
            super(iterator, aggregators);
        }

        @Override
        protected ImmutableBytesWritable getGroupingKey(Tuple tuple, ImmutableBytesWritable ptr) throws SQLException {
            ptr.set(QueryConstants.UNGROUPED_AGG_ROW_KEY);
            return ptr;
        }

        @Override
        protected Tuple wrapKeyValueAsResult(Cell keyValue) throws SQLException {
            return new MultiKeyValueTuple(Collections.singletonList(keyValue));
        }

        public String toString() {
            return "ClientUngroupedAggregatingResultIterator [resultIterator=" + this.resultIterator + ", aggregators=" + this.aggregators + "]";
        }
    }

    private static class ClientGroupedAggregatingResultIterator
    extends BaseGroupedAggregatingResultIterator {
        private final List<Expression> groupByExpressions;

        public ClientGroupedAggregatingResultIterator(PeekingResultIterator iterator, Aggregators aggregators, List<Expression> groupByExpressions) {
            super(iterator, aggregators);
            this.groupByExpressions = groupByExpressions;
        }

        @Override
        protected ImmutableBytesWritable getGroupingKey(Tuple tuple, ImmutableBytesWritable ptr) throws SQLException {
            try {
                ImmutableBytesPtr key = TupleUtil.getConcatenatedValue(tuple, this.groupByExpressions);
                ptr.set(key.get(), key.getOffset(), key.getLength());
                return ptr;
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }

        @Override
        protected Tuple wrapKeyValueAsResult(Cell keyValue) {
            return new MultiKeyValueTuple(Collections.singletonList(keyValue));
        }

        public String toString() {
            return "ClientGroupedAggregatingResultIterator [resultIterator=" + this.resultIterator + ", aggregators=" + this.aggregators + ", groupByExpressions=" + this.groupByExpressions + "]";
        }
    }
}

