/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.exception;

import java.sql.SQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.SchemaUtil;

public class SQLExceptionInfo {
    public static final String SCHEMA_NAME = "schemaName";
    public static final String TABLE_NAME = "tableName";
    public static final String TABLE_TYPE = "tableType";
    public static final String FAMILY_NAME = "familyName";
    public static final String COLUMN_NAME = "columnName";
    public static final String FUNCTION_NAME = "functionName";
    public static final String MAX_MUTATION_SIZE = "maxMutationSize";
    public static final String MUTATION_SIZE = "mutationSize";
    public static final String MAX_MUTATION_SIZE_BYTES = "maxMutationSizeBytes";
    public static final String MUTATION_SIZE_BYTES = "mutationSizeBytes";
    public static final String MAX_PHOENIX_COLUMN_SIZE_BYTES = "maxPhoenixColumnSizeBytes";
    public static final String PHOENIX_COLUMN_SIZE_BYTES = "phoenixColumnSizeBytes";
    public static final String HA_GROUP_INFO = "haGroupInfo";
    private final Throwable rootCause;
    private final SQLExceptionCode code;
    private final String message;
    private final String schemaName;
    private final String tableName;
    private final PTableType tableType;
    private final String familyName;
    private final String columnName;
    private final String functionName;
    private final int maxMutationSize;
    private final int mutationSize;
    private final long maxMutationSizeBytes;
    private final long mutationSizeBytes;
    private final int phoenixColumnSizeBytes;
    private final int maxPhoenixColumnSizeBytes;
    private final String haGroupInfo;
    private final String cdcChangeScope;

    private SQLExceptionInfo(Builder builder) {
        this.code = builder.code;
        this.rootCause = builder.rootCause;
        this.message = builder.message;
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.tableType = builder.tableType;
        this.familyName = builder.familyName;
        this.columnName = builder.columnName;
        this.functionName = builder.functionName;
        this.maxMutationSize = builder.maxMutationSize;
        this.mutationSize = builder.mutationSize;
        this.maxMutationSizeBytes = builder.maxMutationSizeBytes;
        this.mutationSizeBytes = builder.mutationSizeBytes;
        this.maxPhoenixColumnSizeBytes = builder.maxPhoenixColumnSizeBytes;
        this.phoenixColumnSizeBytes = builder.phoenixColumnSizeBytes;
        this.haGroupInfo = builder.haGroupInfo;
        this.cdcChangeScope = builder.cdcChangeScope;
    }

    public String toString() {
        String baseMessage = this.code.toString();
        StringBuilder builder = new StringBuilder(baseMessage);
        if (this.message != null) {
            if (this.message.startsWith(baseMessage)) {
                builder.append(this.message.substring(baseMessage.length()));
            } else {
                builder.append(" ").append(this.message);
            }
        }
        if (this.functionName != null) {
            builder.append(" ").append(FUNCTION_NAME).append("=").append(this.functionName);
            return builder.toString();
        }
        String columnDisplayName = SchemaUtil.getMetaDataEntityName(this.schemaName, this.tableName, this.familyName, this.columnName);
        if (this.columnName != null) {
            builder.append(" ").append(COLUMN_NAME).append("=").append(columnDisplayName);
        } else if (this.familyName != null) {
            builder.append(" ").append(FAMILY_NAME).append("=").append(columnDisplayName);
        } else if (this.tableName != null) {
            builder.append(" ").append(TABLE_NAME).append("=").append(columnDisplayName);
        } else if (this.schemaName != null) {
            builder.append(" ").append(SCHEMA_NAME).append("=").append(columnDisplayName);
        }
        if (this.tableType != null) {
            builder.append(" ").append(TABLE_TYPE).append("=").append((Object)this.tableType);
        }
        if (this.maxMutationSize != 0) {
            builder.append(" ").append(MAX_MUTATION_SIZE).append("=").append(this.maxMutationSize);
            builder.append(" ").append(MUTATION_SIZE).append("=").append(this.mutationSize);
        } else if (this.maxMutationSizeBytes != 0L) {
            builder.append(" ").append(MAX_MUTATION_SIZE_BYTES).append("=").append(this.maxMutationSizeBytes);
            builder.append(" ").append(MUTATION_SIZE_BYTES).append("=").append(this.mutationSizeBytes);
        }
        if (this.maxPhoenixColumnSizeBytes != 0) {
            builder.append(" ").append(MAX_PHOENIX_COLUMN_SIZE_BYTES).append("=").append(this.maxPhoenixColumnSizeBytes);
            builder.append(" ").append(PHOENIX_COLUMN_SIZE_BYTES).append("=").append(this.phoenixColumnSizeBytes);
        }
        if (this.haGroupInfo != null) {
            builder.append(" ").append(HA_GROUP_INFO).append("=").append(this.haGroupInfo);
        }
        if (this.cdcChangeScope != null) {
            builder.append(": ").append(this.cdcChangeScope);
        }
        return builder.toString();
    }

    public SQLException buildException() {
        return this.code.getExceptionFactory().newException(this);
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public PTableType getTableType() {
        return this.tableType;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public SQLExceptionCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public int getMaxMutationSize() {
        return this.maxMutationSize;
    }

    public int getMutationSize() {
        return this.mutationSize;
    }

    public long getMaxMutationSizeBytes() {
        return this.maxMutationSizeBytes;
    }

    public long getMutationSizeBytes() {
        return this.mutationSizeBytes;
    }

    public int getMaxPhoenixColumnSizeBytes() {
        return this.maxPhoenixColumnSizeBytes;
    }

    public int getPhoenixColumnSizeBytes() {
        return this.phoenixColumnSizeBytes;
    }

    public String getHaGroupInfo() {
        return this.haGroupInfo;
    }

    public String getCdcChangeScope() {
        return this.cdcChangeScope;
    }

    public static class Builder {
        private Throwable rootCause;
        private SQLExceptionCode code;
        private String message;
        private String schemaName;
        private String tableName;
        private String familyName;
        private String columnName;
        private String functionName;
        private int maxMutationSize;
        private int mutationSize;
        private long maxMutationSizeBytes;
        private long mutationSizeBytes;
        private int phoenixColumnSizeBytes;
        private int maxPhoenixColumnSizeBytes;
        private String haGroupInfo;
        private PTableType tableType;
        private String cdcChangeScope;

        public Builder(SQLExceptionCode code) {
            this.code = code;
        }

        public Builder setRootCause(Throwable t) {
            this.rootCause = t;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setTableType(PTableType tableType) {
            this.tableType = tableType;
            return this;
        }

        public Builder setFamilyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder setFunctionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder setMaxMutationSize(int maxMutationSize) {
            this.maxMutationSize = maxMutationSize;
            return this;
        }

        public Builder setMutationSize(int mutationSize) {
            this.mutationSize = mutationSize;
            return this;
        }

        public Builder setMaxMutationSizeBytes(long maxMutationSizeBytes) {
            this.maxMutationSizeBytes = maxMutationSizeBytes;
            return this;
        }

        public Builder setMutationSizeBytes(long mutationSizeBytes) {
            this.mutationSizeBytes = mutationSizeBytes;
            return this;
        }

        public Builder setPhoenixColumnSizeBytes(int phoenixColumnSizeBytes) {
            this.phoenixColumnSizeBytes = phoenixColumnSizeBytes;
            return this;
        }

        public Builder setMaxPhoenixColumnSizeBytes(int maxPhoenixColumnSizeBytes) {
            this.maxPhoenixColumnSizeBytes = maxPhoenixColumnSizeBytes;
            return this;
        }

        public Builder setHaGroupInfo(String haGroupInfo) {
            this.haGroupInfo = haGroupInfo;
            return this;
        }

        public Builder setCdcChangeScope(String cdcChangeScope) {
            this.cdcChangeScope = cdcChangeScope;
            return this;
        }

        public SQLExceptionInfo build() {
            return new SQLExceptionInfo(this);
        }

        public String toString() {
            return this.code.toString();
        }
    }
}

