/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessorclient;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;

public class TableTTLInfo
implements Comparable {
    private final byte[] physicalTableName;
    private final byte[] tenantId;
    private final byte[] entityName;
    private final byte[] matchPattern;
    private final CompiledTTLExpression ttl;

    @VisibleForTesting
    public TableTTLInfo(String physicalTableName, String tenantId, String entityName, String matchPattern, int ttl) {
        this.physicalTableName = physicalTableName.getBytes(StandardCharsets.UTF_8);
        this.tenantId = tenantId.getBytes(StandardCharsets.UTF_8);
        this.entityName = entityName.getBytes(StandardCharsets.UTF_8);
        this.matchPattern = matchPattern.getBytes(StandardCharsets.UTF_8);
        this.ttl = TTLExpressionFactory.create(ttl);
    }

    @VisibleForTesting
    public TableTTLInfo(byte[] physicalTableName, byte[] tenantId, byte[] entityName, byte[] matchPattern, int ttl) {
        this.physicalTableName = physicalTableName;
        this.tenantId = tenantId;
        this.matchPattern = matchPattern;
        this.entityName = entityName;
        this.ttl = TTLExpressionFactory.create(ttl);
    }

    public TableTTLInfo(String physicalTableName, String tenantId, String entityName, String matchPattern, CompiledTTLExpression ttl) {
        this.physicalTableName = physicalTableName.getBytes(StandardCharsets.UTF_8);
        this.tenantId = tenantId.getBytes(StandardCharsets.UTF_8);
        this.entityName = entityName.getBytes(StandardCharsets.UTF_8);
        this.matchPattern = matchPattern.getBytes(StandardCharsets.UTF_8);
        this.ttl = ttl;
    }

    public TableTTLInfo(byte[] physicalTableName, byte[] tenantId, byte[] entityName, byte[] matchPattern, CompiledTTLExpression ttl) {
        this.physicalTableName = physicalTableName;
        this.tenantId = tenantId;
        this.matchPattern = matchPattern;
        this.entityName = entityName;
        this.ttl = ttl;
    }

    public CompiledTTLExpression getTTL() {
        return this.ttl;
    }

    public byte[] getTenantId() {
        return this.tenantId;
    }

    public byte[] getEntityName() {
        return this.entityName;
    }

    public byte[] getMatchPattern() {
        return this.matchPattern;
    }

    public byte[] getPhysicalTableName() {
        return this.physicalTableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableTTLInfo that = (TableTTLInfo)o;
        return Arrays.equals(this.physicalTableName, that.physicalTableName) && Arrays.equals(this.tenantId, that.tenantId) && Arrays.equals(this.entityName, that.entityName);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tenantId) + Arrays.hashCode(this.entityName);
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        if (obj == null) {
            throw new NullPointerException();
        }
        TableTTLInfo other = (TableTTLInfo)obj;
        int result = Bytes.BYTES_COMPARATOR.compare(this.physicalTableName, other.physicalTableName);
        if (result == 0) {
            result = Bytes.BYTES_COMPARATOR.compare(this.entityName, other.entityName);
        }
        if (result == 0) {
            result = Bytes.BYTES_COMPARATOR.compare(this.tenantId, other.tenantId);
        }
        return result;
    }

    public String toString() {
        return "TableTTLInfo { physicalTableName=" + Bytes.toString((byte[])this.physicalTableName) + ", tenantId=" + Bytes.toString((byte[])this.tenantId) + ", entityName=" + Bytes.toString((byte[])this.entityName) + ", matchPattern=" + Bytes.toStringBinary((byte[])this.matchPattern) + ", ttl=" + this.ttl + " }";
    }
}

