/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessorclient;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowKeyMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowKeyMatcher.class);
    public static final int R = 256;
    private TrieNode root = new TrieNode();
    private final AtomicInteger numEntries = new AtomicInteger(0);

    public int getNumEntries() {
        return this.numEntries.get();
    }

    public Integer match(byte[] rowkey, int offset) {
        return this.get(rowkey, offset);
    }

    public Integer get(byte[] key, int offset) {
        TrieNode node = this.get(this.root, key, offset);
        if (node == null) {
            return null;
        }
        return node.tableId;
    }

    private TrieNode get(TrieNode node, byte[] key, int depth) {
        if (node == null) {
            return null;
        }
        if (node.tableId != null) {
            return node;
        }
        if (key.length == depth) {
            return node;
        }
        int index = key[depth] & 0xFF;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("depth = %d, index = %d", depth, index));
        }
        return this.get(node.tryOptimisticGet(index), key, depth + 1);
    }

    public void put(byte[] key, int tableId) {
        this.root = this.put(this.root, key, tableId, 0, false);
    }

    private TrieNode put(TrieNode node, byte[] key, int tableId, int depth, boolean isLocked) {
        if (node == null) {
            node = new TrieNode();
        }
        if (key.length == depth) {
            node.registerTableId(tableId);
            return node;
        }
        int index = key[depth] & 0xFF;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("depth = %d, index = %d", depth, index));
        }
        if (!isLocked && node.next[index] == null) {
            node.put(index, key, tableId, depth + 1);
        } else {
            node.next[index] = this.put(node.next[index], key, tableId, depth + 1, isLocked);
        }
        return node;
    }

    class TrieNode {
        private Integer tableId = null;
        TrieNode[] next = new TrieNode[256];
        private final StampedLock sl = new StampedLock();

        TrieNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TrieNode tryOptimisticGet(int pos) {
            long stamp = this.sl.tryOptimisticRead();
            TrieNode nextNode = this.next[pos];
            if (!this.sl.validate(stamp)) {
                stamp = this.sl.readLock();
                try {
                    nextNode = this.next[pos];
                }
                finally {
                    this.sl.unlockRead(stamp);
                }
            }
            return nextNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void put(int pos, byte[] key, int val, int depth) {
            long stamp = this.sl.writeLock();
            try {
                this.next[pos] = RowKeyMatcher.this.put(this.next[pos], key, val, depth, true);
            }
            finally {
                this.sl.unlock(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerTableId(int tableId) {
            long stamp = this.sl.writeLock();
            try {
                if (this.tableId == null) {
                    this.tableId = tableId;
                    RowKeyMatcher.this.numEntries.incrementAndGet();
                }
            }
            finally {
                this.sl.unlock(stamp);
            }
        }
    }
}

