/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.SequenceValueExpression;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereOptimizer;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.AddExpression;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.ArrayConstructorExpression;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.CaseExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.CorrelateVariableFieldAccessExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.DivideExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.InListExpression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LikeExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.ModulusExpression;
import org.apache.phoenix.expression.MultiplyExpression;
import org.apache.phoenix.expression.NotExpression;
import org.apache.phoenix.expression.OrExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.SingleCellConstructorExpression;
import org.apache.phoenix.expression.StringConcatExpression;
import org.apache.phoenix.expression.SubtractExpression;
import org.apache.phoenix.expression.function.ArrayAnyComparisonExpression;
import org.apache.phoenix.expression.function.ArrayElemRefExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.function.ScanEndKeyFunction;
import org.apache.phoenix.expression.function.ScanStartKeyFunction;
import org.apache.phoenix.expression.function.SingleAggregateFunction;
import org.apache.phoenix.expression.function.TotalSegmentsFunction;
import org.apache.phoenix.expression.visitor.CloneExpressionVisitor;
import org.apache.phoenix.expression.visitor.KeyValueExpressionVisitor;
import org.apache.phoenix.expression.visitor.TraverseAllExpressionVisitor;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.filter.MultiCFCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.MultiCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.MultiEncodedCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.RowKeyComparisonFilter;
import org.apache.phoenix.filter.SingleCFCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.SingleCQKeyValueComparisonFilter;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.SubqueryParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class WhereCompiler {
    protected static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();

    private WhereCompiler() {
    }

    public static Expression compile(StatementContext context, FilterableStatement statement) throws SQLException {
        return WhereCompiler.compile(context, statement, null, null, (Optional<byte[]>)Optional.absent());
    }

    public static Expression compile(StatementContext context, ParseNode whereNode) throws SQLException {
        WhereExpressionCompiler viewWhereCompiler = new WhereExpressionCompiler(context, true);
        return whereNode.accept(viewWhereCompiler);
    }

    public static Expression compile(StatementContext context, FilterableStatement statement, ParseNode viewWhere, Set<SubqueryParseNode> subqueryNodes, Optional<byte[]> minOffset) throws SQLException {
        return WhereCompiler.compile(context, statement, viewWhere, Collections.emptyList(), subqueryNodes, minOffset);
    }

    public static Expression compile(StatementContext context, FilterableStatement statement, ParseNode viewWhere, List<Expression> dynamicFilters, Set<SubqueryParseNode> subqueryNodes, Optional<byte[]> minOffset) throws SQLException {
        ScanBoundaryRemovalVisitor removalVisitor;
        Expression expression;
        ParseNode where = statement.getWhere();
        if (subqueryNodes != null) {
            SubqueryParseNodeVisitor subqueryVisitor = new SubqueryParseNodeVisitor(context, subqueryNodes);
            if (where != null) {
                where.accept(subqueryVisitor);
            }
            if (viewWhere != null) {
                viewWhere.accept(subqueryVisitor);
            }
            if (!subqueryNodes.isEmpty()) {
                return null;
            }
        }
        HashSet extractedNodes = Sets.newHashSet();
        ScanBoundaryExtractingCompiler whereCompiler = new ScanBoundaryExtractingCompiler(context);
        Expression expression2 = expression = where == null ? LiteralExpression.newConstant((Object)true, (PDataType)PBoolean.INSTANCE, Determinism.ALWAYS) : where.accept(whereCompiler);
        if (whereCompiler.getScanStartKey() != null || whereCompiler.getScanEndKey() != null) {
            removalVisitor = new ScanBoundaryRemovalVisitor();
            expression = expression.accept(removalVisitor);
        }
        if (whereCompiler.hasTotalSegments()) {
            context.setTotalSegmentsFunction(true);
            context.setTotalSegmentsValue(whereCompiler.getTotalSegmentsValue());
            removalVisitor = new ScanBoundaryRemovalVisitor();
            expression = expression.accept(removalVisitor);
        }
        if (whereCompiler.isAggregate()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATE_IN_WHERE).build().buildException();
        }
        if (expression.getDataType() != PBoolean.INSTANCE) {
            throw TypeMismatchException.newException(PBoolean.INSTANCE, expression.getDataType(), expression.toString());
        }
        if (viewWhere != null) {
            WhereExpressionCompiler viewWhereCompiler = new WhereExpressionCompiler(context, true);
            Expression viewExpression = viewWhere.accept(viewWhereCompiler);
            expression = AndExpression.create(Lists.newArrayList((Object[])new Expression[]{expression, viewExpression}));
        }
        if (!dynamicFilters.isEmpty()) {
            ArrayList filters = Lists.newArrayList((Object[])new Expression[]{expression});
            filters.addAll(dynamicFilters);
            expression = AndExpression.create(filters);
        }
        if (context.getCurrentTable().getTable().getType() != PTableType.PROJECTED && context.getCurrentTable().getTable().getType() != PTableType.SUBQUERY) {
            Set<HintNode.Hint> hints = null;
            if (statement.getHint() != null) {
                hints = statement.getHint().getHints();
            }
            expression = WhereOptimizer.pushKeyExpressionsToScan(context, hints, expression, extractedNodes, minOffset);
        }
        if (whereCompiler.getScanStartKey() != null || whereCompiler.getScanEndKey() != null) {
            Scan scan = context.getScan();
            if (scan.getStartRow().length == 0 && whereCompiler.getScanStartKey() != null) {
                scan.withStartRow(whereCompiler.getScanStartKey());
            }
            if (scan.getStopRow().length == 0 && whereCompiler.getScanEndKey() != null) {
                scan.withStopRow(whereCompiler.getScanEndKey());
            }
        }
        WhereCompiler.setScanFilter(context, statement, expression, whereCompiler.disambiguateWithFamily);
        return expression;
    }

    private static void setScanFilter(StatementContext context, FilterableStatement statement, Expression whereClause, boolean disambiguateWithFamily) {
        Scan scan = context.getScan();
        if (LiteralExpression.isBooleanFalseOrNull(whereClause)) {
            context.setScanRanges(ScanRanges.NOTHING);
        } else if (context.getCurrentTable().getTable().getIndexType() == PTable.IndexType.LOCAL || IndexUtil.isGlobalIndex(context.getCurrentTable().getTable()) && context.isUncoveredIndex()) {
            if (whereClause != null && !ExpressionUtil.evaluatesToTrue(whereClause)) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                try {
                    DataOutputStream output = new DataOutputStream(stream);
                    WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(whereClause).ordinal());
                    whereClause.write(output);
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                scan.setAttribute("_IndexFilter", stream.toByteArray());
                scan.setAttribute("_IndexFilterStr", Bytes.toBytes((String)whereClause.toString()));
            }
        } else if (whereClause != null && !ExpressionUtil.evaluatesToTrue(whereClause)) {
            BooleanExpressionFilter filter = null;
            final Counter counter = new Counter();
            whereClause.accept(new KeyValueExpressionVisitor(){

                @Override
                public Iterator<Expression> defaultIterator(Expression node) {
                    if (counter.getCount() == Counter.Count.MULTIPLE) {
                        return Collections.emptyIterator();
                    }
                    return super.defaultIterator(node);
                }

                @Override
                public Void visit(KeyValueColumnExpression expression) {
                    counter.increment(expression);
                    return null;
                }
            });
            PTable table = context.getCurrentTable().getTable();
            PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
            PTable.ImmutableStorageScheme storageScheme = table.getImmutableStorageScheme();
            Counter.Count count = counter.getCount();
            boolean allCFs = false;
            byte[] essentialCF = null;
            if (counter.getCount() == Counter.Count.SINGLE && whereClause.requiresFinalEvaluation()) {
                if (table.getViewType() == PTable.ViewType.MAPPED) {
                    allCFs = true;
                } else {
                    byte[] emptyCF = SchemaUtil.getEmptyColumnFamily(table);
                    if (Bytes.compareTo((byte[])emptyCF, (byte[])counter.getColumn().getColumnFamily()) != 0) {
                        essentialCF = emptyCF;
                        count = Counter.Count.MULTIPLE;
                    }
                }
            }
            switch (count) {
                case NONE: {
                    essentialCF = table.getType() == PTableType.VIEW ? ByteUtil.EMPTY_BYTE_ARRAY : SchemaUtil.getEmptyColumnFamily(table);
                    filter = new RowKeyComparisonFilter(whereClause, essentialCF);
                    break;
                }
                case SINGLE: {
                    filter = disambiguateWithFamily ? new SingleCFCQKeyValueComparisonFilter(whereClause) : new SingleCQKeyValueComparisonFilter(whereClause);
                    break;
                }
                case MULTIPLE: {
                    filter = EncodedColumnsUtil.isPossibleToUseEncodedCQFilter(encodingScheme, storageScheme) ? new MultiEncodedCQKeyValueComparisonFilter(whereClause, encodingScheme, allCFs, essentialCF) : (disambiguateWithFamily ? new MultiCFCQKeyValueComparisonFilter(whereClause, allCFs, essentialCF) : new MultiCQKeyValueComparisonFilter(whereClause, allCFs, essentialCF));
                }
            }
            scan.setFilter(filter);
        }
        ScanRanges scanRanges = context.getScanRanges();
        if (scanRanges.useSkipScanFilter()) {
            ScanUtil.andFilterAtBeginning(scan, (Filter)scanRanges.getSkipScanFilter());
        }
    }

    public static Expression transformDNF(ParseNode where, StatementContext statementContext) throws SQLException {
        if (where == null) {
            return null;
        }
        StatementContext context = new StatementContext(statementContext);
        context.setResolver(FromCompiler.getResolver(context.getCurrentTable()));
        Expression expression = where.accept(new WhereExpressionCompiler(context));
        Expression dnf = expression.accept(new DNFExpressionRewriter());
        return dnf;
    }

    public static LiteralExpression getLiteralExpression(Expression node) {
        while (!node.getChildren().isEmpty()) {
            node = node.getChildren().get(0);
        }
        if (node instanceof LiteralExpression) {
            return (LiteralExpression)node;
        }
        throw new IllegalArgumentException("Unexpected instance type for " + node);
    }

    public static BaseTerminalExpression getBaseTerminalExpression(Expression node) {
        while (!node.getChildren().isEmpty()) {
            node = node.getChildren().get(0);
        }
        if (node instanceof BaseTerminalExpression) {
            return (BaseTerminalExpression)node;
        }
        throw new IllegalArgumentException("Unexpected instance type for " + node);
    }

    private static boolean contained(Expression nodeA, Expression nodeB) {
        if (nodeB instanceof AndExpression) {
            for (Expression childB : nodeB.getChildren()) {
                if (nodeA instanceof AndExpression) {
                    boolean contains = false;
                    for (Expression childA : nodeA.getChildren()) {
                        if (!childB.contains(childA)) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    return false;
                }
                if (childB.contains(nodeA)) continue;
                return false;
            }
        } else if (nodeA instanceof AndExpression) {
            boolean contains = false;
            for (Expression childA : nodeA.getChildren()) {
                if (!nodeB.contains(childA)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                return false;
            }
        } else if (!nodeB.contains(nodeA)) {
            return false;
        }
        return true;
    }

    private static boolean contained(Expression node, List<Expression> l) {
        for (Expression e : l) {
            if (!WhereCompiler.contained(node, e)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsDisjunct(Expression nodeA, Expression nodeB) throws SQLException {
        return !(nodeA instanceof OrExpression ? !WhereCompiler.contained(nodeB, nodeA.getChildren()) : !WhereCompiler.contained(nodeB, nodeA));
    }

    public static boolean contains(Expression nodeA, Expression nodeB) throws SQLException {
        if (nodeA == null) {
            return true;
        }
        if (nodeB == null) {
            return false;
        }
        if (nodeB instanceof OrExpression) {
            for (Expression childB : nodeB.getChildren()) {
                if (WhereCompiler.containsDisjunct(nodeA, childB)) continue;
                return false;
            }
            return true;
        }
        return WhereCompiler.containsDisjunct(nodeA, nodeB);
    }

    public static class WhereExpressionCompiler
    extends ExpressionCompiler {
        protected boolean disambiguateWithFamily;

        public WhereExpressionCompiler(StatementContext context) {
            super(context, true);
        }

        WhereExpressionCompiler(StatementContext context, boolean resolveViewConstants) {
            super(context, resolveViewConstants);
        }

        @Override
        public Expression visit(ColumnParseNode node) throws SQLException {
            ColumnRef ref = this.resolveColumn(node);
            TableRef tableRef = ref.getTableRef();
            Expression newColumnExpression = ref.newColumnExpression(node.isTableNameCaseSensitive(), node.isCaseSensitive());
            if (tableRef.equals(this.context.getCurrentTable()) && !SchemaUtil.isPKColumn(ref.getColumn())) {
                byte[] cq = tableRef.getTable().getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS ? QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES : ref.getColumn().getColumnQualifierBytes();
                this.context.addWhereConditionColumn(ref.getColumn().getFamilyName().getBytes(), cq);
            }
            return newColumnExpression;
        }

        @Override
        protected ColumnRef resolveColumn(ColumnParseNode node) throws SQLException {
            ColumnRef ref = super.resolveColumn(node);
            if (this.disambiguateWithFamily) {
                return ref;
            }
            PTable table = ref.getTable();
            if (!SchemaUtil.isPKColumn(ref.getColumn())) {
                if (!EncodedColumnsUtil.usesEncodedColumnNames(table) || ref.getColumn().isDynamic()) {
                    try {
                        table.getColumnForColumnName(ref.getColumn().getName().getString());
                    }
                    catch (AmbiguousColumnException e) {
                        this.disambiguateWithFamily = true;
                    }
                } else {
                    for (PColumnFamily columnFamily : table.getColumnFamilies()) {
                        if (columnFamily.getName().equals(ref.getColumn().getFamilyName())) continue;
                        try {
                            table.getColumnForColumnQualifier(columnFamily.getName().getBytes(), ref.getColumn().getColumnQualifierBytes());
                            this.disambiguateWithFamily = true;
                            break;
                        }
                        catch (ColumnNotFoundException columnNotFoundException) {
                        }
                    }
                }
            }
            return ref;
        }
    }

    private static class SubqueryParseNodeVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private final StatementContext context;
        private final Set<SubqueryParseNode> subqueryNodes;

        SubqueryParseNodeVisitor(StatementContext context, Set<SubqueryParseNode> subqueryNodes) {
            this.context = context;
            this.subqueryNodes = subqueryNodes;
        }

        @Override
        public Void visit(SubqueryParseNode node) throws SQLException {
            SelectStatement select = node.getSelectNode();
            if (!this.context.isSubqueryResultAvailable(select)) {
                this.subqueryNodes.add(node);
            }
            return null;
        }
    }

    private static final class ScanBoundaryExtractingCompiler
    extends WhereExpressionCompiler {
        private byte[] scanStartKey;
        private byte[] scanEndKey;
        private boolean hasTotalSegments = false;
        private Integer totalSegmentsValue;

        private ScanBoundaryExtractingCompiler(StatementContext context) {
            super(context);
        }

        @Override
        public Expression visitLeave(ComparisonParseNode node, List<Expression> children) throws SQLException {
            boolean hasScanFunctionWithEquals = false;
            if (node.getFilterOp() == CompareOperator.EQUAL && children.size() == 2) {
                Expression lhs = children.get(0);
                Expression rhs = children.get(1);
                if (lhs instanceof ScanStartKeyFunction && rhs instanceof LiteralExpression) {
                    this.scanStartKey = this.extractBytes((LiteralExpression)rhs);
                    hasScanFunctionWithEquals = true;
                } else if (rhs instanceof ScanStartKeyFunction && lhs instanceof LiteralExpression) {
                    this.scanStartKey = this.extractBytes((LiteralExpression)lhs);
                    hasScanFunctionWithEquals = true;
                }
                if (lhs instanceof ScanEndKeyFunction && rhs instanceof LiteralExpression) {
                    this.scanEndKey = this.extractBytes((LiteralExpression)rhs);
                    hasScanFunctionWithEquals = true;
                } else if (rhs instanceof ScanEndKeyFunction && lhs instanceof LiteralExpression) {
                    this.scanEndKey = this.extractBytes((LiteralExpression)lhs);
                    hasScanFunctionWithEquals = true;
                }
                if (lhs instanceof TotalSegmentsFunction && rhs instanceof LiteralExpression) {
                    this.hasTotalSegments = true;
                    this.totalSegmentsValue = this.getTotalSegmentsVal((LiteralExpression)rhs);
                } else if (rhs instanceof TotalSegmentsFunction && lhs instanceof LiteralExpression) {
                    this.hasTotalSegments = true;
                    this.totalSegmentsValue = this.getTotalSegmentsVal((LiteralExpression)lhs);
                }
            }
            if (hasScanFunctionWithEquals) {
                Object expression = super.visitLeave(node, (List)children);
                if (expression instanceof LiteralExpression && LiteralExpression.isBooleanNull((Expression)expression)) {
                    return LiteralExpression.newConstant((Object)true, (PDataType)PBoolean.INSTANCE, Determinism.ALWAYS);
                }
                return expression;
            }
            return super.visitLeave(node, (List)children);
        }

        private byte[] extractBytes(LiteralExpression literal) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            if (literal.evaluate(null, ptr)) {
                return ptr.copyBytes();
            }
            return null;
        }

        private Integer getTotalSegmentsVal(LiteralExpression literal) throws SQLException {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            if (literal.evaluate(null, ptr)) {
                Integer value = (Integer)PInteger.INSTANCE.toObject(ptr);
                if (value != null && value <= 0) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_TOTAL_SEGMENTS_VALUE).build().buildException();
                }
                return value;
            }
            return null;
        }

        public byte[] getScanStartKey() {
            return this.scanStartKey;
        }

        public byte[] getScanEndKey() {
            return this.scanEndKey;
        }

        public boolean hasTotalSegments() {
            return this.hasTotalSegments;
        }

        public Integer getTotalSegmentsValue() {
            return this.totalSegmentsValue;
        }
    }

    private static class ScanBoundaryRemovalVisitor
    extends CloneExpressionVisitor {
        private ScanBoundaryRemovalVisitor() {
        }

        @Override
        public Expression visitLeave(ComparisonExpression node, List<Expression> children) {
            Expression lhs = children.get(0);
            Expression rhs = children.get(1);
            if (node.getFilterOp() == CompareOperator.EQUAL && (lhs instanceof ScanStartKeyFunction || rhs instanceof ScanStartKeyFunction || lhs instanceof ScanEndKeyFunction || rhs instanceof ScanEndKeyFunction || lhs instanceof TotalSegmentsFunction || rhs instanceof TotalSegmentsFunction)) {
                try {
                    return LiteralExpression.newConstant((Object)true, (PDataType)PBoolean.INSTANCE, Determinism.ALWAYS);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.visitLeave(node, (List)children);
        }

        @Override
        public Expression visitLeave(AndExpression node, List<Expression> children) {
            ArrayList filteredChildren = Lists.newArrayListWithCapacity((int)children.size());
            for (Expression child : children) {
                if (LiteralExpression.isTrue(child)) continue;
                filteredChildren.add(child);
            }
            if (filteredChildren.isEmpty()) {
                try {
                    return LiteralExpression.newConstant((Object)true, (PDataType)PBoolean.INSTANCE, Determinism.ALWAYS);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                return AndExpression.create(filteredChildren);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class Counter {
        private Count count = Count.NONE;
        private KeyValueColumnExpression column;

        private Counter() {
        }

        public void increment(KeyValueColumnExpression column) {
            switch (this.count) {
                case NONE: {
                    this.count = Count.SINGLE;
                    this.column = column;
                    break;
                }
                case SINGLE: {
                    this.count = column.equals(this.column) ? Count.SINGLE : Count.MULTIPLE;
                    break;
                }
            }
        }

        public Count getCount() {
            return this.count;
        }

        public KeyValueColumnExpression getColumn() {
            return this.column;
        }

        public static enum Count {
            NONE,
            SINGLE,
            MULTIPLE;

        }
    }

    public static class DNFExpressionRewriter
    extends TraverseAllExpressionVisitor<Expression> {
        private static AndExpression flattenAnd(List<Expression> l) {
            for (Expression e : l) {
                if (!(e instanceof AndExpression)) continue;
                ArrayList<Expression> flattenedList = new ArrayList<Expression>(l.size() + e.getChildren().size());
                for (Expression child : l) {
                    if (child instanceof AndExpression) {
                        flattenedList.addAll(child.getChildren());
                        continue;
                    }
                    flattenedList.add(child);
                }
                return new AndExpression(flattenedList);
            }
            return new AndExpression(l);
        }

        private static OrExpression flattenOr(List<Expression> l) {
            for (Expression e : l) {
                if (!(e instanceof OrExpression)) continue;
                ArrayList<Expression> flattenedList = new ArrayList<Expression>(l.size() + e.getChildren().size());
                for (Expression child : l) {
                    if (child instanceof OrExpression) {
                        flattenedList.addAll(child.getChildren());
                        continue;
                    }
                    flattenedList.add(child);
                }
                return new OrExpression(flattenedList);
            }
            return new OrExpression(l);
        }

        @Override
        public Expression visitLeave(AndExpression node, List<Expression> l) {
            int i;
            AndExpression andExpression = DNFExpressionRewriter.flattenAnd(l);
            boolean foundOrChild = false;
            Expression child = null;
            List<Expression> andChildren = andExpression.getChildren();
            for (i = 0; i < andChildren.size(); ++i) {
                child = andChildren.get(i);
                if (!(child instanceof OrExpression)) continue;
                foundOrChild = true;
                break;
            }
            if (foundOrChild) {
                ArrayList<Expression> flattenedList = new ArrayList<Expression>(andChildren.size() - 1);
                for (int j = 0; j < andChildren.size(); ++j) {
                    if (i == j) continue;
                    flattenedList.add(andChildren.get(j));
                }
                ArrayList<Expression> orList = new ArrayList<Expression>(child.getChildren().size());
                for (Expression grandChild : child.getChildren()) {
                    ArrayList<Expression> andList = new ArrayList<Expression>(l.size());
                    andList.addAll(flattenedList);
                    andList.add(grandChild);
                    orList.add((Expression)this.visitLeave(new AndExpression(andList), (List)andList));
                }
                return this.visitLeave(new OrExpression(orList), (List)orList);
            }
            return andExpression;
        }

        @Override
        public Expression visitLeave(OrExpression node, List<Expression> l) {
            return DNFExpressionRewriter.flattenOr(l);
        }

        @Override
        public Expression visitLeave(ScalarFunction node, List<Expression> l) {
            return node;
        }

        private static ComparisonExpression createComparisonExpression(CompareOperator op, Expression lhs, Expression rhs) {
            ArrayList<Expression> children = new ArrayList<Expression>(2);
            children.add(lhs);
            children.add(rhs);
            return new ComparisonExpression(children, op);
        }

        @Override
        public Expression visitLeave(ComparisonExpression node, List<Expression> l) {
            if (l == null || l.isEmpty()) {
                return node;
            }
            Expression lhs = l.get(0);
            Expression rhs = l.get(1);
            if (!(lhs instanceof RowValueConstructorExpression) || !(rhs instanceof RowValueConstructorExpression)) {
                return new ComparisonExpression(l, node.getFilterOp());
            }
            int childCount = lhs.getChildren().size();
            if (node.getFilterOp() == CompareOperator.EQUAL || node.getFilterOp() == CompareOperator.NOT_EQUAL) {
                ArrayList<Expression> andList = new ArrayList<Expression>(childCount);
                for (int i = 0; i < childCount; ++i) {
                    andList.add(DNFExpressionRewriter.createComparisonExpression(node.getFilterOp(), lhs.getChildren().get(i), rhs.getChildren().get(i)));
                }
                return new AndExpression(andList);
            }
            ArrayList<Expression> orList = new ArrayList<Expression>(childCount);
            for (int i = 0; i < childCount; ++i) {
                int j;
                ArrayList<Expression> andList = new ArrayList<Expression>(childCount);
                for (j = 0; j < childCount - i - 1; ++j) {
                    andList.add(DNFExpressionRewriter.createComparisonExpression(CompareOperator.EQUAL, lhs.getChildren().get(j), rhs.getChildren().get(j)));
                }
                andList.add(DNFExpressionRewriter.createComparisonExpression(node.getFilterOp(), lhs.getChildren().get(j), rhs.getChildren().get(j)));
                orList.add(new AndExpression(andList));
            }
            return new OrExpression(orList);
        }

        @Override
        public Expression visitLeave(LikeExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(SingleAggregateFunction node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(CaseExpression node, List<Expression> l) {
            return node;
        }

        private static Expression negate(ComparisonExpression node) {
            CompareOperator op = node.getFilterOp();
            Expression lhs = node.getChildren().get(0);
            Expression rhs = node.getChildren().get(1);
            switch (op) {
                case LESS: {
                    return DNFExpressionRewriter.createComparisonExpression(CompareOperator.GREATER_OR_EQUAL, lhs, rhs);
                }
                case LESS_OR_EQUAL: {
                    return DNFExpressionRewriter.createComparisonExpression(CompareOperator.GREATER, lhs, rhs);
                }
                case EQUAL: {
                    return DNFExpressionRewriter.createComparisonExpression(CompareOperator.NOT_EQUAL, lhs, rhs);
                }
                case NOT_EQUAL: {
                    return DNFExpressionRewriter.createComparisonExpression(CompareOperator.EQUAL, lhs, rhs);
                }
                case GREATER_OR_EQUAL: {
                    return DNFExpressionRewriter.createComparisonExpression(CompareOperator.LESS, lhs, rhs);
                }
                case GREATER: {
                    return DNFExpressionRewriter.createComparisonExpression(CompareOperator.LESS_OR_EQUAL, lhs, rhs);
                }
            }
            throw new IllegalArgumentException("Unexpected CompareOp of " + op);
        }

        private static List<Expression> negateChildren(List<Expression> children) {
            ArrayList<Expression> list = new ArrayList<Expression>(children.size());
            for (Expression child : children) {
                if (child instanceof ComparisonExpression) {
                    list.add(DNFExpressionRewriter.negate((ComparisonExpression)child));
                    continue;
                }
                if (child instanceof OrExpression) {
                    list.add(DNFExpressionRewriter.negate((OrExpression)child));
                    continue;
                }
                if (child instanceof AndExpression) {
                    list.add(DNFExpressionRewriter.negate((AndExpression)child));
                    continue;
                }
                if (child instanceof ColumnExpression) {
                    list.add(new NotExpression(child));
                    continue;
                }
                if (child instanceof NotExpression) {
                    list.add(child.getChildren().get(0));
                    continue;
                }
                throw new IllegalArgumentException("Unexpected Instance of " + child);
            }
            return list;
        }

        private static Expression negate(OrExpression node) {
            return new AndExpression(DNFExpressionRewriter.negateChildren(node.getChildren()));
        }

        private static Expression negate(AndExpression node) {
            return new OrExpression(DNFExpressionRewriter.negateChildren(node.getChildren()));
        }

        @Override
        public Expression visitLeave(NotExpression node, List<Expression> l) {
            Expression child = l.get(0);
            if (child instanceof OrExpression) {
                return DNFExpressionRewriter.negate((OrExpression)child);
            }
            if (child instanceof AndExpression) {
                return DNFExpressionRewriter.negate((AndExpression)child);
            }
            if (child instanceof ComparisonExpression) {
                return DNFExpressionRewriter.negate((ComparisonExpression)child);
            }
            if (child instanceof NotExpression) {
                return child.getChildren().get(0);
            }
            if (child instanceof IsNullExpression) {
                return new IsNullExpression((List<Expression>)ImmutableList.of((Object)l.get(0).getChildren().get(0)), !((IsNullExpression)child).isNegate());
            }
            return new NotExpression(child);
        }

        private Expression transformInList(InListExpression node, boolean negate, List<Expression> l) {
            ArrayList<Expression> list = new ArrayList<Expression>(node.getKeyExpressions().size());
            for (Expression element : node.getKeyExpressions()) {
                if (negate) {
                    list.add(DNFExpressionRewriter.createComparisonExpression(CompareOperator.NOT_EQUAL, l.get(0), element));
                    continue;
                }
                list.add(DNFExpressionRewriter.createComparisonExpression(CompareOperator.EQUAL, l.get(0), element));
            }
            if (negate) {
                return new AndExpression(list);
            }
            return new OrExpression(list);
        }

        @Override
        public Expression visitLeave(InListExpression node, List<Expression> l) {
            Expression inList = this.transformInList(node, false, l);
            Expression firstElement = inList.getChildren().get(0);
            if (firstElement instanceof ComparisonExpression && firstElement.getChildren().get(0) instanceof RowValueConstructorExpression) {
                ArrayList<Expression> list = new ArrayList<Expression>(node.getKeyExpressions().size());
                for (Expression e : inList.getChildren()) {
                    list.add((Expression)this.visitLeave((ComparisonExpression)e, (List)e.getChildren()));
                }
                if (inList instanceof OrExpression) {
                    return this.visitLeave(new OrExpression(list), (List)list);
                }
                return this.visitLeave(new AndExpression(list), (List)list);
            }
            return inList;
        }

        @Override
        public Expression visitLeave(IsNullExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(SubtractExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(MultiplyExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(AddExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(DivideExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(CoerceExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(ArrayConstructorExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(SingleCellConstructorExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visit(CorrelateVariableFieldAccessExpression node) {
            return node;
        }

        @Override
        public Expression visit(LiteralExpression node) {
            return node;
        }

        @Override
        public Expression visit(RowKeyColumnExpression node) {
            return node;
        }

        @Override
        public Expression visit(KeyValueColumnExpression node) {
            return node;
        }

        @Override
        public Expression visit(SingleCellColumnExpression node) {
            return node;
        }

        @Override
        public Expression visit(ProjectedColumnExpression node) {
            return node;
        }

        @Override
        public Expression visit(SequenceValueExpression node) {
            return node;
        }

        @Override
        public Expression visitLeave(StringConcatExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(RowValueConstructorExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(ModulusExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(ArrayAnyComparisonExpression node, List<Expression> l) {
            return node;
        }

        @Override
        public Expression visitLeave(ArrayElemRefExpression node, List<Expression> l) {
            return node;
        }
    }
}

