/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.CompiledOffset;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.HavingCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.TupleProjectionPlan;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.execute.UnionPlan;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.SchemaUtil;

public class UnionCompiler {
    private static final PName UNION_FAMILY_NAME = PNameFactory.newName("unionFamilyName");
    private static final PName UNION_SCHEMA_NAME = PNameFactory.newName("unionSchemaName");
    private static final PName UNION_TABLE_NAME = PNameFactory.newName("unionTableName");

    private static List<TargetDataExpression> checkProjectionNumAndExpressions(List<QueryPlan> selectPlans) throws SQLException {
        int columnCount = selectPlans.get(0).getProjector().getColumnCount();
        ArrayList<TargetDataExpression> targetTypes = new ArrayList<TargetDataExpression>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            for (QueryPlan plan : selectPlans) {
                if (columnCount != plan.getProjector().getColumnCount()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SELECT_COLUMN_NUM_IN_UNIONALL_DIFFS).setMessage("1st query has " + columnCount + " columns whereas 2nd query has " + plan.getProjector().getColumnCount()).build().buildException();
                }
                ColumnProjector colproj = plan.getProjector().getColumnProjector(i);
                if (targetTypes.size() < i + 1) {
                    targetTypes.add(new TargetDataExpression(colproj.getExpression()));
                    continue;
                }
                UnionCompiler.compareExperssions(i, colproj.getExpression(), targetTypes);
            }
        }
        return targetTypes;
    }

    public static TableRef contructSchemaTable(PhoenixStatement statement, List<QueryPlan> plans, List<AliasedNode> selectNodes) throws SQLException {
        List<TargetDataExpression> targetTypes = UnionCompiler.checkProjectionNumAndExpressions(plans);
        QueryPlan plan = plans.get(0);
        ArrayList<PColumn> projectedColumns = new ArrayList<PColumn>();
        for (int i = 0; i < plan.getProjector().getColumnCount(); ++i) {
            ColumnProjector colProj = plan.getProjector().getColumnProjector(i);
            String name = selectNodes == null ? colProj.getLabel() : selectNodes.get(i).getAlias();
            PName colName = PNameFactory.newName(name);
            PColumnImpl projectedColumn = new PColumnImpl(PNameFactory.newName(name), UNION_FAMILY_NAME, targetTypes.get(i).getType(), targetTypes.get(i).getMaxLength(), targetTypes.get(i).getScale(), colProj.getExpression().isNullable(), i, targetTypes.get(i).getSortOrder(), 500, null, false, colProj.getExpression().toString(), false, false, colName.getBytes(), Long.MAX_VALUE);
            projectedColumns.add(projectedColumn);
        }
        Long scn = statement.getConnection().getSCN();
        PTableImpl tempTable = new PTableImpl.Builder().setType(PTableType.SUBQUERY).setTimeStamp(Long.MAX_VALUE).setIndexDisableTimestamp(0L).setSequenceNumber(scn == null ? Long.MAX_VALUE : scn).setImmutableRows(true).setDisableWAL(true).setMultiTenant(true).setStoreNulls(true).setUpdateCacheFrequency(0L).setNamespaceMapped(SchemaUtil.isNamespaceMappingEnabled(PTableType.SUBQUERY, statement.getConnection().getQueryServices().getProps())).setAppendOnlySchema(false).setImmutableStorageScheme(PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN).setQualifierEncodingScheme(PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS).setBaseColumnCount(-1).setEncodedCQCounter(PTable.EncodedCQCounter.NULL_COUNTER).setUseStatsForParallelization(true).setExcludedColumns((List<PColumn>)ImmutableList.of()).setTenantId(statement.getConnection().getTenantId()).setSchemaName(UNION_SCHEMA_NAME).setTableName(UNION_TABLE_NAME).setRowKeyOrderOptimizable(false).setIndexes(Collections.emptyList()).setPhysicalNames((List<PName>)ImmutableList.of()).setColumns(projectedColumns).build();
        return new TableRef(null, tempTable, 0L, false);
    }

    private static void compareExperssions(int i, Expression expression, List<TargetDataExpression> targetTypes) throws SQLException {
        SortOrder sortOrder;
        Integer scale;
        Integer len;
        PDataType type = expression.getDataType();
        if (type == null || !type.isCoercibleTo(targetTypes.get(i).getType())) {
            if (targetTypes.get(i).getType() == null || targetTypes.get(i).getType().isCoercibleTo(type)) {
                targetTypes.get(i).setType(type);
            } else {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.SELECT_COLUMN_TYPE_IN_UNIONALL_DIFFS).setMessage("Column # " + i + " is " + targetTypes.get(i).getType().getSqlTypeName() + " in 1st query where as it is " + type.getSqlTypeName() + " in 2nd query").build().buildException();
            }
        }
        if ((len = expression.getMaxLength()) != null && (targetTypes.get(i).getMaxLength() == null || len > targetTypes.get(i).getMaxLength())) {
            targetTypes.get(i).setMaxLength(len);
        }
        if ((scale = expression.getScale()) != null && (targetTypes.get(i).getScale() == null || scale > targetTypes.get(i).getScale())) {
            targetTypes.get(i).setScale(scale);
        }
        if ((sortOrder = expression.getSortOrder()) != null && !sortOrder.equals((Object)targetTypes.get(i).getSortOrder())) {
            targetTypes.get(i).setSortOrder(SortOrder.getDefault());
        }
    }

    private static TupleProjector getTupleProjector(RowProjector rowProj, List<PColumn> columns) throws SQLException {
        Expression[] exprs = new Expression[columns.size()];
        int i = 0;
        for (ColumnProjector columnProjector : rowProj.getColumnProjectors()) {
            exprs[i] = CoerceExpression.create(columnProjector.getExpression(), columns.get(i).getDataType(), columns.get(i).getSortOrder(), columns.get(i).getMaxLength());
            ++i;
        }
        return new TupleProjector(exprs);
    }

    static List<QueryPlan> convertToTupleProjectionPlan(List<QueryPlan> plans, TableRef tableRef, StatementContext statementContext) throws SQLException {
        List<PColumn> columns = tableRef.getTable().getColumns();
        for (int i = 0; i < plans.size(); ++i) {
            QueryPlan subPlan = plans.get(i);
            TupleProjector projector = UnionCompiler.getTupleProjector(subPlan.getProjector(), columns);
            subPlan = new TupleProjectionPlan(subPlan, projector, statementContext, null);
            plans.set(i, subPlan);
        }
        return plans;
    }

    static void optimizeUnionOrderByIfPossible(UnionPlan innerUnionPlan, SelectStatement outerSelectStatement, Supplier<StatementContext> statementContextCreator) throws SQLException {
        innerUnionPlan.enableCheckSupportOrderByOptimize();
        if (!innerUnionPlan.isSupportOrderByOptimize()) {
            return;
        }
        if (!UnionCompiler.isOptimizeUnionOrderByDeserved(innerUnionPlan, outerSelectStatement, statementContextCreator)) {
            innerUnionPlan.disableSupportOrderByOptimize();
        }
    }

    private static boolean isOptimizeUnionOrderByDeserved(UnionPlan innerUnionPlan, SelectStatement outerSelectStatement, Supplier<StatementContext> statementContextCreator) throws SQLException {
        if (!outerSelectStatement.haveGroupBy() && !outerSelectStatement.haveOrderBy()) {
            return false;
        }
        if (!outerSelectStatement.haveGroupBy() && outerSelectStatement.getOrderBy().stream().anyMatch(OrderByNode::isIntegerLiteral)) {
            return false;
        }
        StatementContext statementContext = statementContextCreator.get();
        ColumnResolver columResover = innerUnionPlan.getContext().getResolver();
        TableRef tableRef = innerUnionPlan.getTableRef();
        statementContext.setResolver(columResover);
        statementContext.setCurrentTable(tableRef);
        if (outerSelectStatement.haveGroupBy()) {
            GroupByCompiler.GroupBy groupBy = GroupByCompiler.compile(statementContext, outerSelectStatement);
            outerSelectStatement = HavingCompiler.rewrite(statementContext, outerSelectStatement, groupBy);
            Expression where = WhereCompiler.compile(statementContext, outerSelectStatement, null, null, CompiledOffset.EMPTY_COMPILED_OFFSET.getByteOffset());
            groupBy = groupBy.compile(statementContext, innerUnionPlan, where);
            return groupBy.isOrderPreserving();
        }
        assert (outerSelectStatement.haveOrderBy());
        Expression where = WhereCompiler.compile(statementContext, outerSelectStatement, null, null, CompiledOffset.EMPTY_COMPILED_OFFSET.getByteOffset());
        OrderByCompiler.OrderBy orderBy = OrderByCompiler.compile(statementContext, outerSelectStatement, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, null, CompiledOffset.EMPTY_COMPILED_OFFSET, null, innerUnionPlan, where);
        return orderBy == OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY;
    }

    private static class TargetDataExpression {
        private PDataType type;
        private Integer maxLength;
        private Integer scale;
        private SortOrder sortOrder;

        public TargetDataExpression(Expression expr) {
            this.type = expr.getDataType();
            this.maxLength = expr.getMaxLength();
            this.scale = expr.getScale();
            this.sortOrder = expr.getSortOrder();
        }

        public PDataType getType() {
            return this.type;
        }

        public void setType(PDataType type) {
            this.type = type;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        public Integer getScale() {
            return this.scale;
        }

        public void setScale(Integer scale) {
            this.scale = scale;
        }

        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        public void setSortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }
    }
}

