/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.htrace.Sampler;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.iterate.DefaultParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.metrics.MetricInfo;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.TraceStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PhoenixKeyValueUtil;

public class TraceQueryPlan
implements QueryPlan {
    private TraceStatement traceStatement = null;
    private PhoenixStatement stmt = null;
    private StatementContext context = null;
    private boolean first = true;
    private static final RowProjector TRACE_PROJECTOR;

    public TraceQueryPlan(TraceStatement traceStatement, PhoenixStatement stmt) {
        this.traceStatement = traceStatement;
        this.stmt = stmt;
        this.context = new StatementContext(stmt);
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return this.traceStatement.getOperation();
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return this.context.getBindManager().getParameterMetaData();
    }

    @Override
    public ResultIterator iterator() throws SQLException {
        return this.iterator(DefaultParallelScanGrouper.getInstance());
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        return this.iterator(scanGrouper);
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
        PhoenixConnection conn = this.stmt.getConnection();
        if (conn.getTraceScope() == null && !this.traceStatement.isTraceOn()) {
            return ResultIterator.EMPTY_ITERATOR;
        }
        return new TraceQueryResultIterator(conn);
    }

    @Override
    public long getEstimatedSize() {
        return PLong.INSTANCE.getByteSize().intValue();
    }

    @Override
    public Cost getCost() {
        return Cost.ZERO;
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        return Collections.emptySet();
    }

    @Override
    public TableRef getTableRef() {
        return null;
    }

    @Override
    public RowProjector getProjector() {
        return TRACE_PROJECTOR;
    }

    @Override
    public Integer getLimit() {
        return null;
    }

    @Override
    public Integer getOffset() {
        return null;
    }

    @Override
    public OrderByCompiler.OrderBy getOrderBy() {
        return OrderByCompiler.OrderBy.EMPTY_ORDER_BY;
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return GroupByCompiler.GroupBy.EMPTY_GROUP_BY;
    }

    @Override
    public List<KeyRange> getSplits() {
        return Collections.emptyList();
    }

    @Override
    public List<List<Scan>> getScans() {
        return Collections.emptyList();
    }

    @Override
    public FilterableStatement getStatement() {
        return null;
    }

    @Override
    public boolean isDegenerate() {
        return false;
    }

    @Override
    public boolean isRowKeyOrdered() {
        return false;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        return ExplainPlan.EMPTY_PLAN;
    }

    @Override
    public boolean useRoundRobinIterator() {
        return false;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Long getEstimatedRowsToScan() {
        return 0L;
    }

    @Override
    public Long getEstimatedBytesToScan() {
        return 0L;
    }

    @Override
    public Long getEstimateInfoTimestamp() throws SQLException {
        return 0L;
    }

    @Override
    public List<OrderByCompiler.OrderBy> getOutputOrderBys() {
        return Collections.emptyList();
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    static {
        ArrayList<ExpressionProjector> projectedColumns = new ArrayList<ExpressionProjector>();
        PName colName = PNameFactory.newName(MetricInfo.TRACE.columnName);
        PColumnImpl column = new PColumnImpl(PNameFactory.newName(MetricInfo.TRACE.columnName), null, PLong.INSTANCE, null, null, false, 0, SortOrder.getDefault(), 0, null, false, null, false, false, colName.getBytes(), Long.MAX_VALUE);
        ArrayList<PColumnImpl> columns = new ArrayList<PColumnImpl>();
        columns.add(column);
        RowKeyColumnExpression expression = new RowKeyColumnExpression(column, new RowKeyValueAccessor(columns, 0));
        projectedColumns.add(new ExpressionProjector(MetricInfo.TRACE.columnName, MetricInfo.TRACE.columnName, "", expression, true));
        int estimatedByteSize = 64 + PLong.INSTANCE.getByteSize();
        TRACE_PROJECTOR = new RowProjector(projectedColumns, estimatedByteSize, false);
    }

    private class TraceQueryResultIterator
    implements ResultIterator {
        private final PhoenixConnection conn;

        public TraceQueryResultIterator(PhoenixConnection conn) {
            this.conn = conn;
        }

        @Override
        public void close() throws SQLException {
        }

        @Override
        public Tuple next() throws SQLException {
            if (!TraceQueryPlan.this.first) {
                return null;
            }
            TraceScope traceScope = this.conn.getTraceScope();
            if (TraceQueryPlan.this.traceStatement.isTraceOn()) {
                this.conn.setSampler(Tracing.getConfiguredSampler(TraceQueryPlan.this.traceStatement));
                if (this.conn.getSampler() == Sampler.NEVER) {
                    this.closeTraceScope(this.conn);
                }
                if (traceScope == null && !this.conn.getSampler().equals((Object)Sampler.NEVER)) {
                    traceScope = Tracing.startNewSpan(this.conn, "Enabling trace");
                    if (traceScope.getSpan() != null) {
                        this.conn.setTraceScope(traceScope);
                    } else {
                        this.closeTraceScope(this.conn);
                    }
                }
            } else {
                this.closeTraceScope(this.conn);
                this.conn.setSampler(Sampler.NEVER);
            }
            if (traceScope == null || traceScope.getSpan() == null) {
                return null;
            }
            TraceQueryPlan.this.first = false;
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            ParseNodeFactory factory = new ParseNodeFactory();
            LiteralParseNode literal = factory.literal(traceScope.getSpan().getTraceId());
            LiteralExpression expression = LiteralExpression.newConstant(literal.getValue(), (PDataType)PLong.INSTANCE, Determinism.ALWAYS);
            expression.evaluate(null, ptr);
            byte[] rowKey = ByteUtil.copyKeyBytesIfNecessary(ptr);
            Cell cell = PhoenixKeyValueUtil.newKeyValue(rowKey, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, EnvironmentEdgeManager.currentTimeMillis(), HConstants.EMPTY_BYTE_ARRAY);
            ArrayList<Cell> cells = new ArrayList<Cell>(1);
            cells.add(cell);
            return new ResultTuple(Result.create(cells));
        }

        private void closeTraceScope(PhoenixConnection conn) {
            if (conn.getTraceScope() != null) {
                conn.getTraceScope().close();
                conn.setTraceScope(null);
            }
        }

        @Override
        public void explain(List<String> planSteps) {
        }

        @Override
        public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        }
    }
}

