/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.Date;
import java.sql.SQLException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.AggregationManager;
import org.apache.phoenix.compile.BindManager;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionManager;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.log.QueryLogger;
import org.apache.phoenix.monitoring.OverAllQueryMetrics;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.ReadOnlyProps;

public class StatementContext {
    private ColumnResolver resolver;
    private final PhoenixConnection connection;
    private final BindManager binds;
    private final Scan scan;
    private final ExpressionManager expressions;
    private final AggregationManager aggregates;
    private final String numberFormat;
    private final ImmutableBytesWritable tempPtr;
    private final PhoenixStatement statement;
    private final Map<PColumn, Integer> dataColumns;
    private Map<Long, Boolean> retryingPersistentCache;
    private long currentTime = -1L;
    private ScanRanges scanRanges = ScanRanges.EVERYTHING;
    private final SequenceManager sequences;
    private TableRef currentTable;
    private List<Pair<byte[], byte[]>> whereConditionColumns;
    private Map<SelectStatement, Object> subqueryResults;
    private final ReadMetricQueue readMetricsQueue;
    private final OverAllQueryMetrics overAllQueryMetrics;
    private QueryLogger queryLogger;
    private boolean isClientSideUpsertSelect;
    private boolean isUncoveredIndex;
    private String cdcIncludeScopes;
    private TableRef cdcTableRef;
    private TableRef cdcDataTableRef;
    private AtomicBoolean hasFirstValidResult;
    private Set<StatementContext> subStatementContexts;
    private boolean totalSegmentsFunction = false;
    private Integer totalSegmentsValue;

    public StatementContext(PhoenixStatement statement) {
        this(statement, new Scan());
    }

    public StatementContext(StatementContext context) {
        this.resolver = context.resolver;
        this.connection = context.connection;
        this.binds = context.binds;
        this.scan = context.scan;
        this.expressions = context.expressions;
        this.aggregates = context.aggregates;
        this.numberFormat = context.numberFormat;
        this.tempPtr = context.tempPtr;
        this.statement = context.statement;
        this.dataColumns = context.dataColumns;
        this.retryingPersistentCache = context.retryingPersistentCache;
        this.currentTime = context.currentTime;
        this.scanRanges = context.scanRanges;
        this.sequences = context.sequences;
        this.currentTable = context.currentTable;
        this.whereConditionColumns = context.whereConditionColumns;
        this.subqueryResults = context.subqueryResults;
        this.readMetricsQueue = context.readMetricsQueue;
        this.overAllQueryMetrics = context.overAllQueryMetrics;
        this.queryLogger = context.queryLogger;
        this.isClientSideUpsertSelect = context.isClientSideUpsertSelect;
        this.isUncoveredIndex = context.isUncoveredIndex;
        this.hasFirstValidResult = new AtomicBoolean(context.getHasFirstValidResult());
        this.subStatementContexts = Sets.newHashSet();
        this.totalSegmentsFunction = context.totalSegmentsFunction;
        this.totalSegmentsValue = context.totalSegmentsValue;
    }

    public StatementContext(PhoenixStatement statement, boolean collectRequestLevelMetrics) {
        this(statement, FromCompiler.EMPTY_TABLE_RESOLVER, new BindManager(statement.getParameters()), new Scan(), new SequenceManager(statement), collectRequestLevelMetrics);
    }

    public StatementContext(PhoenixStatement statement, Scan scan) {
        this(statement, FromCompiler.EMPTY_TABLE_RESOLVER, new BindManager(statement.getParameters()), scan, new SequenceManager(statement));
    }

    public StatementContext(PhoenixStatement statement, ColumnResolver resolver) {
        this(statement, resolver, new BindManager(statement.getParameters()), new Scan(), new SequenceManager(statement));
    }

    public StatementContext(PhoenixStatement statement, ColumnResolver resolver, Scan scan, SequenceManager seqManager) {
        this(statement, resolver, new BindManager(statement.getParameters()), scan, seqManager);
    }

    public StatementContext(PhoenixStatement statement, ColumnResolver resolver, BindManager binds, Scan scan, SequenceManager seqManager) {
        this(statement, resolver, binds, scan, seqManager, statement.getConnection().isRequestLevelMetricsEnabled());
    }

    public StatementContext(PhoenixStatement statement, ColumnResolver resolver, BindManager binds, Scan scan, SequenceManager seqManager, boolean isRequestMetricsEnabled) {
        this.statement = statement;
        this.resolver = resolver;
        this.scan = scan;
        this.sequences = seqManager;
        this.binds = binds;
        this.aggregates = new AggregationManager();
        this.expressions = new ExpressionManager();
        this.connection = statement.getConnection();
        ReadOnlyProps props = this.connection.getQueryServices().getProps();
        this.numberFormat = props.get("phoenix.query.numberFormat", "#,##0.###");
        this.tempPtr = new ImmutableBytesWritable();
        this.currentTable = resolver != null && !resolver.getTables().isEmpty() ? resolver.getTables().get(0) : null;
        this.whereConditionColumns = new ArrayList<Pair<byte[], byte[]>>();
        this.dataColumns = this.currentTable == null ? Collections.emptyMap() : Maps.newLinkedHashMap();
        this.subqueryResults = Maps.newConcurrentMap();
        this.readMetricsQueue = new ReadMetricQueue(isRequestMetricsEnabled, this.connection.getLogLevel());
        this.overAllQueryMetrics = new OverAllQueryMetrics(isRequestMetricsEnabled, this.connection.getLogLevel());
        this.retryingPersistentCache = Maps.newHashMap();
        this.hasFirstValidResult = new AtomicBoolean(false);
        this.subStatementContexts = Sets.newHashSet();
    }

    public int getDataColumnPosition(PColumn column) {
        Integer pos = this.dataColumns.get(column);
        if (pos == null) {
            pos = this.dataColumns.size();
            this.dataColumns.put(column, pos);
        }
        return pos;
    }

    public Set<PColumn> getDataColumns() {
        return this.dataColumns.keySet();
    }

    public Map<PColumn, Integer> getDataColumnsMap() {
        return this.dataColumns;
    }

    public String getDateFormatTimeZoneId() {
        return this.connection.getDateFormatTimeZoneId();
    }

    public String getDateFormat() {
        return this.connection.getDatePattern();
    }

    public Format getDateFormatter() {
        return this.connection.getFormatter(PDate.INSTANCE);
    }

    public String getTimeFormat() {
        return this.connection.getTimePattern();
    }

    public Format getTimeFormatter() {
        return this.connection.getFormatter(PTime.INSTANCE);
    }

    public String getTimestampFormat() {
        return this.connection.getTimestampPattern();
    }

    public Format getTimestampFormatter() {
        return this.connection.getFormatter(PTimestamp.INSTANCE);
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public Scan getScan() {
        return this.scan;
    }

    public BindManager getBindManager() {
        return this.binds;
    }

    public TableRef getCurrentTable() {
        return this.currentTable;
    }

    public boolean getHasFirstValidResult() {
        return this.hasFirstValidResult.get();
    }

    public void setHasFirstValidResult(boolean hasValidResult) {
        this.hasFirstValidResult.set(hasValidResult);
    }

    public void setCurrentTable(TableRef table) {
        this.currentTable = table;
    }

    public AggregationManager getAggregationManager() {
        return this.aggregates;
    }

    public ColumnResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ColumnResolver resolver) {
        this.resolver = resolver;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressions;
    }

    public ImmutableBytesWritable getTempPtr() {
        return this.tempPtr;
    }

    public ScanRanges getScanRanges() {
        return this.scanRanges;
    }

    public void setScanRanges(ScanRanges scanRanges) {
        this.scanRanges = scanRanges;
        scanRanges.initializeScan(this.scan);
    }

    public PhoenixConnection getConnection() {
        return this.connection;
    }

    public PhoenixStatement getStatement() {
        return this.statement;
    }

    public long getCurrentTime() throws SQLException {
        long ts = this.getCurrentTable().getTimeStamp();
        if (this.getCurrentTable().getTable().getType() != PTableType.SUBQUERY && this.getCurrentTable().getTable().getType() != PTableType.PROJECTED && !this.getCurrentTable().getTable().isTransactional() && ts != -1L) {
            return ts;
        }
        if (this.currentTime != -1L) {
            return this.currentTime;
        }
        PTable table = this.getCurrentTable().getTable();
        MetaDataClient client = new MetaDataClient(this.connection);
        this.currentTime = client.getCurrentTime(table.getSchemaName().getString(), table.getTableName().getString());
        return this.currentTime;
    }

    public long getCurrentTimeWithDisplacement() throws SQLException {
        if (this.connection.isApplyTimeZoneDisplacement()) {
            return DateUtil.applyInputDisplacement(new Date(this.getCurrentTime()), this.statement.getLocalCalendar().getTimeZone()).getTime();
        }
        return this.getCurrentTime();
    }

    public SequenceManager getSequenceManager() {
        return this.sequences;
    }

    public void addWhereConditionColumn(byte[] cf, byte[] q) {
        this.whereConditionColumns.add((Pair<byte[], byte[]>)new Pair((Object)cf, (Object)q));
    }

    public List<Pair<byte[], byte[]>> getWhereConditionColumns() {
        return this.whereConditionColumns;
    }

    public boolean isSubqueryResultAvailable(SelectStatement select) {
        return this.subqueryResults.containsKey(select);
    }

    public Object getSubqueryResult(SelectStatement select) {
        return this.subqueryResults.get(select);
    }

    public void setSubqueryResult(SelectStatement select, Object result) {
        this.subqueryResults.put(select, result);
    }

    public ReadMetricQueue getReadMetricsQueue() {
        return this.readMetricsQueue;
    }

    public OverAllQueryMetrics getOverallQueryMetrics() {
        return this.overAllQueryMetrics;
    }

    public void setQueryLogger(QueryLogger queryLogger) {
        this.queryLogger = queryLogger;
    }

    public QueryLogger getQueryLogger() {
        return this.queryLogger;
    }

    public boolean isClientSideUpsertSelect() {
        return this.isClientSideUpsertSelect;
    }

    public void setClientSideUpsertSelect(boolean isClientSideUpsertSelect) {
        this.isClientSideUpsertSelect = isClientSideUpsertSelect;
    }

    public boolean isUncoveredIndex() {
        return this.isUncoveredIndex;
    }

    public void setUncoveredIndex(boolean isUncoveredIndex) {
        this.isUncoveredIndex = isUncoveredIndex;
    }

    public void setRetryingPersistentCache(long cacheId) {
        this.retryingPersistentCache.put(cacheId, true);
    }

    public boolean getRetryingPersistentCache(long cacheId) {
        Boolean retrying = this.retryingPersistentCache.get(cacheId);
        if (retrying == null) {
            return false;
        }
        return retrying;
    }

    public String getEncodedCdcIncludeScopes() {
        return this.cdcIncludeScopes;
    }

    public void setCDCIncludeScopes(Set<PTable.CDCChangeScope> cdcIncludeScopes) {
        this.cdcIncludeScopes = CDCUtil.makeChangeScopeStringFromEnums(cdcIncludeScopes);
    }

    public TableRef getCDCDataTableRef() {
        return this.cdcDataTableRef;
    }

    public void setCDCDataTableRef(TableRef cdcDataTableRef) {
        this.cdcDataTableRef = cdcDataTableRef;
    }

    public TableRef getCDCTableRef() {
        return this.cdcTableRef;
    }

    public void setCDCTableRef(TableRef cdcTableRef) {
        this.cdcTableRef = cdcTableRef;
    }

    public void addSubStatementContext(StatementContext sub) {
        this.subStatementContexts.add(sub);
    }

    public Set<StatementContext> getSubStatementContexts() {
        return this.subStatementContexts;
    }

    public boolean hasTotalSegmentsFunction() {
        return this.totalSegmentsFunction;
    }

    public void setTotalSegmentsFunction(boolean totalSegmentsFunction) {
        this.totalSegmentsFunction = totalSegmentsFunction;
    }

    public Integer getTotalSegmentsValue() {
        return this.totalSegmentsValue;
    }

    public void setTotalSegmentsValue(Integer totalSegmentsValue) {
        this.totalSegmentsValue = totalSegmentsValue;
    }
}

