/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;

public class ServerBuildIndexCompiler {
    protected final PhoenixConnection connection;
    protected final String tableName;
    protected PTable dataTable;
    protected QueryPlan plan;

    public ServerBuildIndexCompiler(PhoenixConnection connection, String tableName) {
        this.connection = connection;
        this.tableName = tableName;
    }

    private static void addColumnsToScan(Set<ColumnReference> columns, Scan scan, PTable index) {
        for (ColumnReference columnRef : columns) {
            if (index.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
                scan.addFamily(columnRef.getFamily());
                continue;
            }
            scan.addColumn(columnRef.getFamily(), columnRef.getQualifier());
        }
    }

    public MutationPlan compile(PTable index) throws SQLException {
        try (PhoenixStatement statement = new PhoenixStatement(this.connection);){
            String query = "SELECT /*+ NO_INDEX */ count(*) FROM " + this.tableName;
            this.plan = statement.compileQuery(query);
            TableRef tableRef = this.plan.getTableRef();
            Scan scan = this.plan.getContext().getScan();
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            this.dataTable = tableRef.getTable();
            if (IndexUtil.isGlobalIndex(index) && this.dataTable.isTransactional()) {
                throw new IllegalArgumentException("ServerBuildIndexCompiler does not support global indexes on transactional tables");
            }
            IndexMaintainer indexMaintainer = index.getIndexMaintainer(this.dataTable, this.connection);
            ServerBuildIndexCompiler.addColumnsToScan(indexMaintainer.getAllColumns(), scan, index);
            if (indexMaintainer.getIndexWhereColumns() != null) {
                ServerBuildIndexCompiler.addColumnsToScan(indexMaintainer.getIndexWhereColumns(), scan, index);
            }
            IndexMaintainer.serialize(this.dataTable, ptr, Collections.singletonList(index), this.plan.getContext().getConnection());
            scan.setAttribute("INDEX_IDX_MAINTAINER", index.getTableName().getBytes());
            ScanUtil.annotateScanWithMetadataAttributes(this.dataTable, scan);
            if (index.getIndexType() == PTable.IndexType.LOCAL) {
                scan.setAttribute("_LocalIndexBuild", ByteUtil.copyKeyBytesIfNecessary(ptr));
            } else {
                scan.setAttribute("IdxProtoMD", ByteUtil.copyKeyBytesIfNecessary(ptr));
                scan.setAttribute("_RebuildIndexes", PDataType.TRUE_BYTES);
                ScanUtil.setClientVersion(scan, MetaDataProtocol.PHOENIX_VERSION);
                scan.setAttribute("_IndexRebuildPaging", PDataType.TRUE_BYTES);
                String rebuildPageRowSize = this.connection.getQueryServices().getProps().get("phoenix.index.rebuild_page_size_in_rows");
                if (rebuildPageRowSize != null) {
                    scan.setAttribute("_IndexRebuildPageRows", Bytes.toBytes((long)Long.parseLong(rebuildPageRowSize)));
                }
                BaseQueryPlan.serializeViewConstantsIntoScan(scan, this.dataTable);
                ScanUtil.addEmptyColumnToScan(scan, indexMaintainer.getDataEmptyKeyValueCF(), indexMaintainer.getEmptyKeyValueQualifier());
            }
            if (this.dataTable.isTransactional()) {
                scan.setAttribute("_TxState", this.connection.getMutationState().encodeTransaction());
            }
            RowCountMutationPlan rowCountMutationPlan = new RowCountMutationPlan(this.plan.getContext(), PhoenixStatement.Operation.UPSERT);
            return rowCountMutationPlan;
        }
    }

    protected class RowCountMutationPlan
    extends BaseMutationPlan {
        protected RowCountMutationPlan(StatementContext context, PhoenixStatement.Operation operation) {
            super(context, operation);
        }

        @Override
        public MutationState execute() throws SQLException {
            ServerBuildIndexCompiler.this.connection.getMutationState().commitDDLFence(ServerBuildIndexCompiler.this.dataTable);
            Tuple tuple = ServerBuildIndexCompiler.this.plan.iterator().next();
            long rowCount = 0L;
            if (tuple != null) {
                Cell kv = tuple.getValue(0);
                ImmutableBytesWritable tmpPtr = new ImmutableBytesWritable(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
                rowCount = PLong.INSTANCE.getCodec().decodeLong(tmpPtr, SortOrder.getDefault());
            }
            return new MutationState(0, 0L, ServerBuildIndexCompiler.this.connection, rowCount);
        }

        @Override
        public QueryPlan getQueryPlan() {
            return ServerBuildIndexCompiler.this.plan;
        }
    }
}

