/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ScanRanges {
    private static final List<List<KeyRange>> EVERYTHING_RANGES = Collections.emptyList();
    private static final List<List<KeyRange>> NOTHING_RANGES = Collections.singletonList(Collections.singletonList(KeyRange.EMPTY_RANGE));
    public static final ScanRanges EVERYTHING = new ScanRanges(null, ScanUtil.SINGLE_COLUMN_SLOT_SPAN, EVERYTHING_RANGES, KeyRange.EVERYTHING_RANGE, false, false, null, null);
    public static final ScanRanges NOTHING = new ScanRanges(null, ScanUtil.SINGLE_COLUMN_SLOT_SPAN, NOTHING_RANGES, KeyRange.EMPTY_RANGE, false, false, null, null);
    private static final Scan HAS_INTERSECTION = new Scan();
    private SkipScanFilter filter;
    private final List<List<KeyRange>> ranges;
    private final int[] slotSpan;
    private final RowKeySchema schema;
    private final boolean isPointLookup;
    private final boolean isSalted;
    private final boolean useSkipScanFilter;
    private final KeyRange scanRange;
    private final TimeRange rowTimestampRange;

    public static ScanRanges createPointLookup(List<KeyRange> keys) {
        return ScanRanges.create(SchemaUtil.VAR_BINARY_SCHEMA, Collections.singletonList(keys), ScanUtil.SINGLE_COLUMN_SLOT_SPAN, null, true, -1);
    }

    public static ScanRanges createSingleSpan(RowKeySchema schema, List<List<KeyRange>> ranges) {
        return ScanRanges.create(schema, ranges, ScanUtil.getDefaultSlotSpans(ranges.size()), null, true, -1);
    }

    public static ScanRanges createSingleSpan(RowKeySchema schema, List<List<KeyRange>> ranges, Integer nBuckets, boolean useSkipSan) {
        return ScanRanges.create(schema, ranges, ScanUtil.getDefaultSlotSpans(ranges.size()), nBuckets, useSkipSan, -1);
    }

    public static ScanRanges create(RowKeySchema schema, List<List<KeyRange>> ranges, int[] slotSpan, Integer nBuckets, boolean useSkipScan, int rowTimestampColIndex) {
        return ScanRanges.create(schema, ranges, slotSpan, nBuckets, useSkipScan, rowTimestampColIndex, (Optional<byte[]>)Optional.absent());
    }

    public static ScanRanges create(RowKeySchema schema, List<List<KeyRange>> ranges, int[] slotSpan, Integer nBuckets, boolean useSkipScan, int rowTimestampColIndex, Optional<byte[]> scanMinOffset) {
        int offset = nBuckets == null ? 0 : 1;
        int nSlots = ranges.size();
        if (nSlots == offset && !scanMinOffset.isPresent()) {
            return EVERYTHING;
        }
        if (nSlots == 1 + offset && ranges.get(offset).size() == 1 && ranges.get(offset).get(0) == KeyRange.EMPTY_RANGE) {
            return NOTHING;
        }
        TimeRange rowTimestampRange = ScanRanges.getRowTimestampColumnRange(ranges, schema, rowTimestampColIndex);
        boolean isPointLookup = ScanRanges.isPointLookup(schema, ranges, slotSpan, useSkipScan);
        if (isPointLookup) {
            List<byte[]> keys = ScanRanges.getPointKeys(ranges, slotSpan, schema, nBuckets);
            ArrayList keyRanges = Lists.newArrayListWithExpectedSize((int)keys.size());
            for (byte[] key : keys) {
                keyRanges.add(KeyRange.getKeyRange(key));
            }
            if (keyRanges.isEmpty()) {
                return NOTHING;
            }
            ranges = Collections.singletonList(keyRanges);
            boolean bl = useSkipScan = keyRanges.size() > 1;
            if (keys.size() > 1 || ScanRanges.hasTrailingDescSeparatorByte(schema)) {
                schema = SchemaUtil.VAR_BINARY_SCHEMA;
                slotSpan = ScanUtil.SINGLE_COLUMN_SLOT_SPAN;
            } else {
                slotSpan = new int[]{schema.getMaxFields() - 1};
            }
        }
        ArrayList sortedRanges = Lists.newArrayListWithExpectedSize((int)ranges.size());
        for (int i = 0; i < ranges.size(); ++i) {
            ValueSchema.Field f = schema.getField(i);
            ArrayList sorted = Lists.newArrayList((Iterable)ranges.get(i));
            Collections.sort(sorted, f.getSortOrder() == SortOrder.ASC ? KeyRange.COMPARATOR : KeyRange.DESC_COMPARATOR);
            sortedRanges.add(ImmutableList.copyOf((Collection)sorted));
        }
        KeyRange scanRange = KeyRange.EVERYTHING_RANGE;
        if (nBuckets == null || !isPointLookup || !useSkipScan) {
            byte[] minKey = ScanUtil.getMinKey(schema, sortedRanges, slotSpan);
            byte[] maxKey = ScanUtil.getMaxKey(schema, sortedRanges, slotSpan);
            if (ScanUtil.crossesPrefixBoundary(maxKey, ScanUtil.getPrefix(minKey, offset), offset)) {
                maxKey = KeyRange.UNBOUND;
            }
            if (minKey.length <= offset) {
                minKey = KeyRange.UNBOUND;
            }
            if (scanMinOffset.isPresent()) {
                byte[] minOffset = (byte[])scanMinOffset.get();
                if (nBuckets != null && nBuckets > 0) {
                    minOffset[0] = 0;
                }
                if (Bytes.BYTES_COMPARATOR.compare(minOffset, minKey) > 0) {
                    minKey = minOffset;
                }
            }
            scanRange = KeyRange.getKeyRange(minKey, maxKey);
        }
        if (scanRange == KeyRange.EMPTY_RANGE) {
            return NOTHING;
        }
        return new ScanRanges(schema, slotSpan, sortedRanges, scanRange, useSkipScan, isPointLookup, nBuckets, rowTimestampRange);
    }

    private static boolean hasTrailingDescSeparatorByte(RowKeySchema schema) {
        return schema.getField(schema.getFieldCount() - 1).getDataType() != PVarbinaryEncoded.INSTANCE && SchemaUtil.getSeparatorByte(schema.rowKeyOrderOptimizable(), false, schema.getField(schema.getFieldCount() - 1)) == QueryConstants.DESC_SEPARATOR_BYTE || schema.getField(schema.getFieldCount() - 1).getDataType() == PVarbinaryEncoded.INSTANCE && SchemaUtil.getSeparatorBytesForVarBinaryEncoded(schema.rowKeyOrderOptimizable(), false, schema.getField(schema.getFieldCount() - 1).getSortOrder()) == QueryConstants.DESC_VARBINARY_ENCODED_SEPARATOR_BYTES;
    }

    private ScanRanges(RowKeySchema schema, int[] slotSpan, List<List<KeyRange>> ranges, KeyRange scanRange, boolean useSkipScanFilter, boolean isPointLookup, Integer bucketNum, TimeRange rowTimestampRange) {
        this.isPointLookup = isPointLookup;
        this.isSalted = bucketNum != null;
        this.useSkipScanFilter = useSkipScanFilter;
        this.scanRange = scanRange;
        this.rowTimestampRange = rowTimestampRange;
        if (this.isSalted && !isPointLookup) {
            ranges.set(0, SaltingUtil.generateAllSaltingRanges(bucketNum));
        }
        this.ranges = ImmutableList.copyOf(ranges);
        this.slotSpan = slotSpan;
        this.schema = schema;
        if (schema != null && !ranges.isEmpty()) {
            if (!this.useSkipScanFilter) {
                int boundSlotCount = this.getBoundSlotCount();
                ranges = ranges.subList(0, boundSlotCount);
                slotSpan = Arrays.copyOf(slotSpan, boundSlotCount);
            }
            this.filter = new SkipScanFilter(ranges, slotSpan, this.schema, isPointLookup);
        }
    }

    public void initializeScan(Scan scan) {
        scan.withStartRow(this.scanRange.getLowerRange());
        scan.withStopRow(this.scanRange.getUpperRange());
    }

    public static byte[] prefixKey(byte[] key, int keyOffset, byte[] prefixKey, int prefixKeyOffset) {
        return ScanRanges.prefixKey(key, keyOffset, key.length, prefixKey, prefixKeyOffset);
    }

    public static byte[] prefixKey(byte[] key, int keyOffset, int keyLength, byte[] prefixKey, int prefixKeyOffset) {
        if (keyLength > 0) {
            byte[] newKey = new byte[keyLength + prefixKeyOffset];
            int totalKeyOffset = keyOffset + prefixKeyOffset;
            if (prefixKey.length >= totalKeyOffset) {
                System.arraycopy(prefixKey, 0, newKey, 0, totalKeyOffset);
            }
            System.arraycopy(key, keyOffset, newKey, totalKeyOffset, keyLength - keyOffset);
            return newKey;
        }
        return key;
    }

    private static byte[] replaceSaltByte(byte[] key, byte[] saltKey) {
        if (key.length == 0) {
            return key;
        }
        byte[] temp = new byte[key.length];
        if (saltKey.length >= 1) {
            System.arraycopy(saltKey, 0, temp, 0, 1);
        }
        System.arraycopy(key, 1, temp, 1, key.length - 1);
        return temp;
    }

    public static byte[] stripPrefix(byte[] key, int keyOffset) {
        if (key.length == 0) {
            return key;
        }
        byte[] temp = new byte[key.length - keyOffset];
        System.arraycopy(key, keyOffset, temp, 0, key.length - keyOffset);
        return temp;
    }

    public List<Scan> intersectScan(Scan scan, byte[] originalStartKey, byte[] originalStopKey, int keyOffset, byte[] splitPostfix, Integer buckets, boolean crossesRegionBoundary) {
        ArrayList<Scan> newScans;
        block5: {
            newScans = new ArrayList<Scan>();
            if (buckets != null && buckets > 0) {
                byte[] wrkStartKey = originalStartKey;
                while (true) {
                    boolean lastBucket = false;
                    byte[] nextBucketStart = null;
                    byte[] nextBucketByte = null;
                    if (wrkStartKey.length > 0 && Byte.toUnsignedInt(wrkStartKey[0]) >= buckets - 1) {
                        lastBucket = true;
                    } else {
                        nextBucketStart = this.bucketEnd(wrkStartKey, splitPostfix);
                        nextBucketByte = new byte[]{nextBucketStart[0]};
                    }
                    if (lastBucket || originalStopKey.length > 0 && Bytes.compareTo((byte[])originalStopKey, (byte[])nextBucketStart) <= 0) {
                        this.addIfNotNull(newScans, this.intersectScan(scan, wrkStartKey, originalStopKey, keyOffset, crossesRegionBoundary));
                        break block5;
                    }
                    this.addIfNotNull(newScans, this.intersectScan(scan, wrkStartKey, nextBucketByte, keyOffset, false));
                    wrkStartKey = nextBucketStart;
                }
            }
            this.addIfNotNull(newScans, this.intersectScan(scan, originalStartKey, originalStopKey, keyOffset, crossesRegionBoundary));
        }
        return newScans;
    }

    private void addIfNotNull(List<Scan> scans, Scan newScan) {
        if (newScan != null) {
            scans.add(newScan);
        }
    }

    private byte[] bucketEnd(byte[] key, byte[] splitPostfix) {
        byte startByte = key.length > 0 ? key[0] : (byte)0;
        int nextBucket = Byte.toUnsignedInt(startByte) + 1;
        byte[] bucketEnd = new byte[splitPostfix.length + 1];
        bucketEnd[0] = (byte)nextBucket;
        System.arraycopy(splitPostfix, 0, bucketEnd, 1, splitPostfix.length);
        return bucketEnd;
    }

    public Scan intersectScan(Scan scan, byte[] originalStartKey, byte[] originalStopKey, int keyOffset, boolean crossesRegionBoundary) {
        byte[] scanStopKey;
        byte[] scanStartKey;
        int scanKeyOffset;
        byte[] startKey = originalStartKey;
        byte[] stopKey = originalStopKey;
        if (stopKey.length > 0 && Bytes.compareTo((byte[])startKey, (byte[])stopKey) >= 0) {
            return null;
        }
        int n = scanKeyOffset = this.isSalted && !this.isPointLookup ? 1 : 0;
        assert (scanKeyOffset == 0 || keyOffset == 0);
        int totalKeyOffset = scanKeyOffset + keyOffset;
        byte[] prefixBytes = ByteUtil.EMPTY_BYTE_ARRAY;
        if (totalKeyOffset > 0) {
            prefixBytes = ScanUtil.getPrefix(startKey, totalKeyOffset);
            if (crossesRegionBoundary) {
                stopKey = ByteUtil.EMPTY_BYTE_ARRAY;
            }
        }
        int scanStartKeyOffset = scanKeyOffset;
        byte[] byArray = scanStartKey = scan == null ? this.scanRange.getLowerRange() : scan.getStartRow();
        if (scanStartKey.length - scanKeyOffset > 0) {
            if (startKey.length - totalKeyOffset > 0 && Bytes.compareTo((byte[])scanStartKey, (int)scanKeyOffset, (int)(scanStartKey.length - scanKeyOffset), (byte[])startKey, (int)totalKeyOffset, (int)(startKey.length - totalKeyOffset)) < 0) {
                scanStartKey = startKey;
                scanStartKeyOffset = totalKeyOffset;
            }
        } else {
            scanStartKey = startKey;
            scanStartKeyOffset = totalKeyOffset;
        }
        int scanStopKeyOffset = scanKeyOffset;
        byte[] byArray2 = scanStopKey = scan == null ? this.scanRange.getUpperRange() : scan.getStopRow();
        if (scanStopKey.length - scanKeyOffset > 0) {
            if (stopKey.length - totalKeyOffset > 0 && Bytes.compareTo((byte[])scanStopKey, (int)scanKeyOffset, (int)(scanStopKey.length - scanKeyOffset), (byte[])stopKey, (int)totalKeyOffset, (int)(stopKey.length - totalKeyOffset)) > 0) {
                scanStopKey = stopKey;
                scanStopKeyOffset = totalKeyOffset;
            }
        } else {
            scanStopKey = stopKey;
            scanStopKeyOffset = totalKeyOffset;
        }
        if (scanStopKey.length - scanStopKeyOffset > 0 && Bytes.compareTo((byte[])scanStartKey, (int)scanStartKeyOffset, (int)(scanStartKey.length - scanStartKeyOffset), (byte[])scanStopKey, (int)scanStopKeyOffset, (int)(scanStopKey.length - scanStopKeyOffset)) >= 0) {
            return null;
        }
        if (originalStopKey.length != 0 && scanStopKey.length == 0) {
            scanStopKey = originalStopKey;
        }
        Object newFilter = null;
        if (this.useSkipScanFilter()) {
            byte[] skipScanStartKey = scanStartKey;
            byte[] skipScanStopKey = scanStopKey;
            if (scanKeyOffset > 0) {
                if (skipScanStartKey != originalStartKey) {
                    skipScanStartKey = ScanRanges.replaceSaltByte(skipScanStartKey, prefixBytes);
                }
                if (skipScanStopKey != originalStopKey) {
                    skipScanStopKey = ScanRanges.replaceSaltByte(skipScanStopKey, prefixBytes);
                }
            } else if (keyOffset > 0) {
                if (skipScanStartKey == originalStartKey) {
                    skipScanStartKey = ScanRanges.stripPrefix(skipScanStartKey, keyOffset);
                }
                if (skipScanStopKey == originalStopKey) {
                    skipScanStopKey = ScanRanges.stripPrefix(skipScanStopKey, keyOffset);
                }
            }
            if (scan == null) {
                return this.filter.hasIntersect(skipScanStartKey, skipScanStopKey) ? HAS_INTERSECTION : null;
            }
            Filter filter = scan.getFilter();
            SkipScanFilter newSkipScanFilter = null;
            if (filter instanceof SkipScanFilter) {
                SkipScanFilter oldSkipScanFilter = (SkipScanFilter)filter;
                newSkipScanFilter = oldSkipScanFilter.intersect(skipScanStartKey, skipScanStopKey);
                newFilter = newSkipScanFilter;
                if (newFilter == null) {
                    return null;
                }
            } else if (filter instanceof FilterList) {
                FilterList oldList = (FilterList)filter;
                FilterList newList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                newFilter = newList;
                for (Filter f : oldList.getFilters()) {
                    if (f instanceof SkipScanFilter) {
                        newSkipScanFilter = ((SkipScanFilter)f).intersect(skipScanStartKey, skipScanStopKey);
                        if (newSkipScanFilter == null) {
                            return null;
                        }
                        newList.addFilter((Filter)newSkipScanFilter);
                        continue;
                    }
                    newList.addFilter(f);
                }
            }
            if (this.isPointLookup) {
                scanStartKey = ScanUtil.getMinKey(this.schema, newSkipScanFilter.getSlots(), this.slotSpan);
                scanStopKey = ScanUtil.getMaxKey(this.schema, newSkipScanFilter.getSlots(), this.slotSpan);
            }
        }
        if (scan == null) {
            return HAS_INTERSECTION;
        }
        if (newFilter == null) {
            newFilter = scan.getFilter();
        }
        Scan newScan = ScanUtil.newScan(scan);
        newScan.setFilter(newFilter);
        if (totalKeyOffset > 0) {
            if (scanStartKey != originalStartKey) {
                scanStartKey = ScanRanges.prefixKey(scanStartKey, scanKeyOffset, prefixBytes, keyOffset);
            }
            if (scanStopKey != originalStopKey) {
                scanStopKey = ScanRanges.prefixKey(scanStopKey, scanKeyOffset, prefixBytes, keyOffset);
            }
        }
        if (originalStopKey.length > 0 && Bytes.compareTo((byte[])scanStopKey, (byte[])originalStopKey) > 0) {
            scanStopKey = originalStopKey;
        }
        if (scanStopKey.length > 0 && Bytes.compareTo((byte[])scanStartKey, (byte[])scanStopKey) >= 0) {
            return null;
        }
        newScan.setAttribute("_ScanActualStartRow", scanStartKey);
        newScan.withStartRow(scanStartKey);
        newScan.withStopRow(scanStopKey);
        return newScan;
    }

    public boolean intersectRegion(byte[] regionStartKey, byte[] regionEndKey, boolean isLocalIndex) {
        if (this.isEverything()) {
            return true;
        }
        if (this.isDegenerate()) {
            return false;
        }
        if (isLocalIndex) {
            return true;
        }
        boolean crossesSaltBoundary = this.isSalted && ScanUtil.crossesPrefixBoundary(regionEndKey, ScanUtil.getPrefix(regionStartKey, 1), 1);
        return this.intersectScan(null, regionStartKey, regionEndKey, 0, crossesSaltBoundary) == HAS_INTERSECTION;
    }

    public SkipScanFilter getSkipScanFilter() {
        return this.filter;
    }

    public List<List<KeyRange>> getRanges() {
        return this.ranges;
    }

    public List<List<KeyRange>> getBoundRanges() {
        return this.ranges.subList(0, this.getBoundSlotCount());
    }

    public RowKeySchema getSchema() {
        return this.schema;
    }

    public boolean isEverything() {
        return this == EVERYTHING || !this.ranges.isEmpty() && this.ranges.get(0).get(0) == KeyRange.EVERYTHING_RANGE;
    }

    public boolean isDegenerate() {
        return this == NOTHING;
    }

    public boolean useSkipScanFilter() {
        return this.useSkipScanFilter;
    }

    private static int getBoundPkSpan(List<List<KeyRange>> ranges, int[] slotSpan) {
        int count = 0;
        boolean hasUnbound = false;
        int nRanges = ranges.size();
        for (int i = 0; i < nRanges && !hasUnbound; ++i) {
            List<KeyRange> orRanges = ranges.get(i);
            for (KeyRange range : orRanges) {
                if (range == KeyRange.EVERYTHING_RANGE) {
                    return count;
                }
                if (!range.isUnbound()) continue;
                hasUnbound = true;
            }
            count += slotSpan[i] + 1;
        }
        return count;
    }

    private static boolean isFullyQualified(RowKeySchema schema, List<List<KeyRange>> ranges, int[] slotSpan) {
        return ScanRanges.getBoundPkSpan(ranges, slotSpan) == schema.getMaxFields();
    }

    private static boolean isPointLookup(RowKeySchema schema, List<List<KeyRange>> ranges, int[] slotSpan, boolean useSkipScan) {
        int lastIndex;
        if (!ScanRanges.isFullyQualified(schema, ranges, slotSpan)) {
            return false;
        }
        for (int i = lastIndex = ranges.size() - 1; i >= 0; --i) {
            List<KeyRange> orRanges = ranges.get(i);
            if (!useSkipScan && orRanges.size() > 1) {
                return false;
            }
            for (KeyRange keyRange : orRanges) {
                if (keyRange.isSingleKey() && (i != lastIndex || keyRange != KeyRange.IS_NULL_RANGE)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean incrementKey(List<List<KeyRange>> slots, int[] position) {
        int idx;
        for (idx = slots.size() - 1; idx >= 0 && (position[idx] = (position[idx] + 1) % slots.get(idx).size()) == 0; --idx) {
        }
        return idx >= 0;
    }

    private static List<byte[]> getPointKeys(List<List<KeyRange>> ranges, int[] slotSpan, RowKeySchema schema, Integer bucketNum) {
        int offset;
        if (ranges == null || ranges.isEmpty()) {
            return Collections.emptyList();
        }
        boolean isSalted = bucketNum != null;
        int count = 1;
        for (int i = offset = isSalted ? 1 : 0; i < ranges.size(); ++i) {
            count *= ranges.get(i).size();
        }
        ArrayList keys = Lists.newArrayListWithExpectedSize((int)count);
        int[] position = new int[ranges.size()];
        int maxKeyLength = SchemaUtil.getMaxKeyLength(schema, ranges);
        byte[] key = new byte[maxKeyLength];
        do {
            int length = ScanUtil.setKey(schema, ranges, slotSpan, position, KeyRange.Bound.LOWER, key, offset, offset, ranges.size(), offset);
            if (isSalted) {
                key[0] = SaltingUtil.getSaltingByte(key, offset, length, bucketNum);
            }
            keys.add(Arrays.copyOf(key, length + offset));
        } while (ScanRanges.incrementKey(ranges, position));
        return keys;
    }

    public boolean isPointLookup() {
        return this.isPointLookup;
    }

    public boolean isSalted() {
        return this.isSalted;
    }

    public int getPointLookupCount() {
        return ScanRanges.getPointLookupCount(this.isPointLookup, this.ranges);
    }

    private static int getPointLookupCount(boolean isPointLookup, List<List<KeyRange>> ranges) {
        return isPointLookup ? ranges.get(0).size() : 0;
    }

    public Iterator<KeyRange> getPointLookupKeyIterator() {
        return this.isPointLookup ? this.ranges.get(0).iterator() : Collections.emptyIterator();
    }

    public int getBoundPkColumnCount() {
        return ScanRanges.getBoundPkSpan(this.ranges, this.slotSpan);
    }

    public int getBoundSlotCount() {
        int count = 0;
        boolean hasUnbound = false;
        int nRanges = this.ranges.size();
        for (int i = 0; i < nRanges && !hasUnbound; ++i) {
            List<KeyRange> orRanges = this.ranges.get(i);
            for (KeyRange range : orRanges) {
                if (range == KeyRange.EVERYTHING_RANGE) {
                    return count;
                }
                if (!range.isUnbound()) continue;
                hasUnbound = true;
            }
            ++count;
        }
        return count;
    }

    public String toString() {
        return "ScanRanges[" + this.ranges.toString() + "]";
    }

    public int[] getSlotSpans() {
        return this.slotSpan;
    }

    public KeyRange getScanRange() {
        return this.scanRange;
    }

    public boolean hasEqualityConstraint(int pkPosition) {
        int pkOffset = 0;
        int nRanges = this.ranges.size();
        for (int i = 0; i < nRanges; ++i) {
            if (pkOffset + this.slotSpan[i] >= pkPosition) {
                List<KeyRange> range = this.ranges.get(i);
                return range.size() == 1 && range.get(0).isSingleKey();
            }
            pkOffset += this.slotSpan[i] + 1;
        }
        return false;
    }

    private static TimeRange getRowTimestampColumnRange(List<List<KeyRange>> ranges, RowKeySchema schema, int rowTimestampColPos) {
        try {
            if (rowTimestampColPos != -1 && ranges != null && ranges.size() > rowTimestampColPos) {
                List<KeyRange> rowTimestampColRange = ranges.get(rowTimestampColPos);
                ArrayList<KeyRange> sortedRange = new ArrayList<KeyRange>(rowTimestampColRange);
                ValueSchema.Field f = schema.getField(rowTimestampColPos);
                Collections.sort(sortedRange, f.getSortOrder() == SortOrder.ASC ? KeyRange.COMPARATOR : KeyRange.DESC_COMPARATOR);
                SortOrder order = f.getSortOrder();
                KeyRange lowestRange = (KeyRange)sortedRange.get(0);
                KeyRange highestRange = (KeyRange)sortedRange.get(rowTimestampColRange.size() - 1);
                if (order == SortOrder.DESC) {
                    return ScanRanges.getDescTimeRange(lowestRange, highestRange, f);
                }
                return ScanRanges.getAscTimeRange(lowestRange, highestRange, f);
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return null;
    }

    private static TimeRange getAscTimeRange(KeyRange lowestRange, KeyRange highestRange, ValueSchema.Field f) throws IOException {
        long high;
        long low;
        PDataType.PDataCodec codec = PLong.INSTANCE.getCodec();
        if (lowestRange.lowerUnbound()) {
            low = 0L;
        } else {
            long lowerRange = codec.decodeLong(lowestRange.getLowerRange(), 0, SortOrder.ASC);
            long l = low = lowestRange.isLowerInclusive() ? lowerRange : ScanRanges.safelyIncrement(lowerRange);
        }
        if (highestRange.upperUnbound()) {
            high = Long.MAX_VALUE;
        } else {
            long upperRange = codec.decodeLong(highestRange.getUpperRange(), 0, SortOrder.ASC);
            high = highestRange.isUpperInclusive() ? ScanRanges.safelyIncrement(upperRange) : upperRange;
        }
        return TimeRange.between((long)low, (long)high);
    }

    public static TimeRange getDescTimeRange(KeyRange lowestKeyRange, KeyRange highestKeyRange, ValueSchema.Field f) throws IOException {
        long high;
        boolean lowerUnbound = lowestKeyRange.lowerUnbound();
        boolean lowerInclusive = lowestKeyRange.isLowerInclusive();
        boolean upperUnbound = highestKeyRange.upperUnbound();
        boolean upperInclusive = highestKeyRange.isUpperInclusive();
        PDataType.PDataCodec codec = PLong.INSTANCE.getCodec();
        long low = lowerUnbound ? -1L : codec.decodeLong(lowestKeyRange.getLowerRange(), 0, SortOrder.DESC);
        long l = high = upperUnbound ? -1L : codec.decodeLong(highestKeyRange.getUpperRange(), 0, SortOrder.DESC);
        if (!lowerUnbound && !upperUnbound) {
            long newHigh = lowerInclusive ? ScanRanges.safelyIncrement(low) : low;
            long newLow = upperInclusive ? high : ScanRanges.safelyIncrement(high);
            return TimeRange.between((long)newLow, (long)newHigh);
        }
        if (!lowerUnbound && upperUnbound) {
            long newHigh = lowerInclusive ? ScanRanges.safelyIncrement(low) : low;
            long newLow = 0L;
            return TimeRange.between((long)newLow, (long)newHigh);
        }
        if (lowerUnbound && !upperUnbound) {
            long newLow = upperInclusive ? high : ScanRanges.safelyIncrement(high);
            long newHigh = Long.MAX_VALUE;
            return TimeRange.between((long)newLow, (long)newHigh);
        }
        long newLow = 0L;
        long newHigh = Long.MAX_VALUE;
        return TimeRange.between((long)newLow, (long)newHigh);
    }

    private static long safelyIncrement(long value) {
        return value < Long.MAX_VALUE ? value + 1L : Long.MAX_VALUE;
    }

    public TimeRange getRowTimestampRange() {
        return this.rowTimestampRange;
    }
}

