/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.function.ArrayIndexFunction;
import org.apache.phoenix.expression.function.BsonValueFunction;
import org.apache.phoenix.expression.function.JsonQueryFunction;
import org.apache.phoenix.expression.function.JsonValueFunction;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.expression.visitor.ProjectedColumnExpressionVisitor;
import org.apache.phoenix.expression.visitor.ReplaceArrayFunctionExpressionVisitor;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.PhoenixRowTimestampParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ArgumentTypeMismatchException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.IndexUncoveredDataColumnRef;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ProjectedColumn;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBson;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PJson;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ProjectionCompiler {
    private static final Expression NULL_EXPRESSION = LiteralExpression.newConstant(null);

    private ProjectionCompiler() {
    }

    private static void projectColumnFamily(PTable table, Scan scan, byte[] family) {
        scan.addFamily(family);
    }

    public static RowProjector compile(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy) throws SQLException {
        boolean wildcardIncludesDynamicCols = context.getConnection().getQueryServices().getConfiguration().getBoolean("phoenix.query.wildcard.dynamicColumns", false);
        return ProjectionCompiler.compile(context, statement, groupBy, Collections.emptyList(), NULL_EXPRESSION, wildcardIncludesDynamicCols);
    }

    private static int getMinPKOffset(PTable table, PName tenantId) {
        int posOffset;
        int n = posOffset = table.getBucketNum() == null ? 0 : 1;
        if (table.isMultiTenant() && tenantId != null) {
            ++posOffset;
        }
        if (table.getViewIndexId() != null) {
            ++posOffset;
        }
        return posOffset;
    }

    private static void projectAllTableColumns(StatementContext context, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns, List<? extends PDatum> targetColumns) throws SQLException {
        ColumnResolver resolver = context.getResolver();
        PTable table = tableRef.getTable();
        int projectedOffset = projectedExpressions.size();
        int posOffset = table.getBucketNum() == null ? 0 : 1;
        int minPKOffset = ProjectionCompiler.getMinPKOffset(table, context.getConnection().getTenantId());
        int j = posOffset;
        for (int i = posOffset; i < table.getColumns().size(); ++i) {
            PColumn column = table.getColumns().get(i);
            if (SchemaUtil.isPKColumn(column) && j++ < minPKOffset) {
                ++posOffset;
                continue;
            }
            ColumnRef ref = new ColumnRef(tableRef, i);
            String colName = ref.getColumn().getName().getString();
            String tableAlias = tableRef.getTableAlias();
            if (resolveColumn) {
                try {
                    String schemaName;
                    ref = tableAlias != null ? resolver.resolveColumn(null, tableAlias, colName) : resolver.resolveColumn((schemaName = table.getSchemaName().getString()).length() == 0 ? null : schemaName, table.getTableName().getString(), colName);
                    if (column.getFamilyName() != null && !column.getFamilyName().equals(ref.getColumn().getFamilyName())) {
                        throw new AmbiguousColumnException();
                    }
                }
                catch (AmbiguousColumnException e) {
                    if (column.getFamilyName() != null) {
                        ref = resolver.resolveColumn(tableAlias != null ? tableAlias : table.getTableName().getString(), column.getFamilyName().getString(), colName);
                    }
                    throw e;
                }
            }
            Expression expression = ref.newColumnExpression();
            expression = ProjectionCompiler.coerceIfNecessary(i - posOffset + projectedOffset, targetColumns, expression);
            ImmutableBytesWritable ptr = context.getTempPtr();
            if (IndexUtil.getViewConstantValue(column, ptr)) {
                expression = LiteralExpression.newConstant(column.getDataType().toObject(ptr, column.getSortOrder()), expression.getDataType(), column.getSortOrder());
            }
            projectedExpressions.add(expression);
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            projectedColumns.add(new ExpressionProjector(colName, colName, tableRef.getTableAlias() == null ? table.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive));
        }
    }

    private static void projectAllIndexColumns(StatementContext context, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns, List<? extends PDatum> targetColumns) throws SQLException {
        ColumnResolver resolver = context.getResolver();
        PTable index = tableRef.getTable();
        int projectedOffset = projectedExpressions.size();
        PhoenixConnection conn = context.getConnection();
        PName tenantId = conn.getTenantId();
        String dataTableName = index.getParentName().getString();
        PTable dataTable = conn.getTable(dataTableName);
        int tableOffset = dataTable.getBucketNum() == null ? 0 : 1;
        int minTablePKOffset = ProjectionCompiler.getMinPKOffset(dataTable, tenantId);
        int minIndexPKOffset = ProjectionCompiler.getMinPKOffset(index, tenantId);
        if (!IndexUtil.shouldIndexBeUsedForUncoveredQuery(tableRef) && index.getColumns().size() - minIndexPKOffset != dataTable.getColumns().size() - minTablePKOffset) {
            String schemaNameStr = dataTable.getSchemaName() == null ? null : dataTable.getSchemaName().getString();
            String tableNameStr = dataTable.getTableName() == null ? null : dataTable.getTableName().getString();
            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, WildcardParseNode.INSTANCE.toString());
        }
        TableRef projectedTableRef = new TableRef(resolver.getTables().get(0), tableRef.getTableAlias());
        int j = tableOffset;
        for (int i = tableOffset; i < dataTable.getColumns().size(); ++i) {
            PColumn column = dataTable.getColumns().get(i);
            if (SchemaUtil.isPKColumn(column) && j++ < minTablePKOffset) {
                ++tableOffset;
                continue;
            }
            PColumn dataTableColumn = dataTable.getColumns().get(i);
            String indexColName = IndexUtil.getIndexColumnName(dataTableColumn);
            PColumn indexColumn = null;
            ColumnRef ref = null;
            try {
                indexColumn = index.getColumnForColumnName(indexColName);
            }
            catch (ColumnNotFoundException e) {
                if (IndexUtil.shouldIndexBeUsedForUncoveredQuery(tableRef)) {
                    String familyName = dataTableColumn.getFamilyName() == null ? null : dataTableColumn.getFamilyName().getString();
                    ref = resolver.resolveColumn(familyName, tableRef.getTableAlias() == null ? tableRef.getTable().getName().getString() : tableRef.getTableAlias(), indexColName);
                    indexColumn = ref.getColumn();
                }
                throw e;
            }
            ref = new ColumnRef(projectedTableRef, indexColumn.getPosition());
            String colName = dataTableColumn.getName().getString();
            String tableAlias = tableRef.getTableAlias();
            if (resolveColumn) {
                try {
                    String schemaName;
                    ref = tableAlias != null ? resolver.resolveColumn(null, tableAlias, indexColName) : resolver.resolveColumn((schemaName = index.getSchemaName().getString()).length() == 0 ? null : schemaName, index.getTableName().getString(), indexColName);
                }
                catch (AmbiguousColumnException e) {
                    if (indexColumn.getFamilyName() != null) {
                        ref = resolver.resolveColumn(tableAlias != null ? tableAlias : index.getTableName().getString(), indexColumn.getFamilyName().getString(), indexColName);
                    }
                    throw e;
                }
            }
            Expression expression = ref.newColumnExpression();
            expression = ProjectionCompiler.coerceIfNecessary(i - tableOffset + projectedOffset, targetColumns, expression);
            projectedExpressions.add(expression);
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            ExpressionProjector projector = new ExpressionProjector(colName, colName, tableRef.getTableAlias() == null ? dataTable.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive);
            projectedColumns.add(projector);
        }
    }

    private static void projectTableColumnFamily(StatementContext context, String cfName, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns) throws SQLException {
        PTable table = tableRef.getTable();
        PColumnFamily pfamily = table.getColumnFamily(cfName);
        for (PColumn column : pfamily.getColumns()) {
            ColumnRef ref = new ColumnRef(tableRef, column.getPosition());
            if (resolveColumn) {
                ref = context.getResolver().resolveColumn(table.getTableName().getString(), cfName, column.getName().getString());
            }
            Expression expression = ref.newColumnExpression();
            projectedExpressions.add(expression);
            String colName = column.getName().toString();
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            projectedColumns.add(new ExpressionProjector(colName, colName, tableRef.getTableAlias() == null ? table.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive));
        }
    }

    private static void projectIndexColumnFamily(StatementContext context, String cfName, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns) throws SQLException {
        ColumnResolver resolver = context.getResolver();
        PTable index = tableRef.getTable();
        PhoenixConnection conn = context.getConnection();
        String dataTableName = index.getParentName().getString();
        PTable dataTable = conn.getTable(dataTableName);
        PColumnFamily pfamily = dataTable.getColumnFamily(cfName);
        TableRef projectedTableRef = new TableRef(resolver.getTables().get(0), tableRef.getTableAlias());
        PTable projectedIndex = projectedTableRef.getTable();
        for (PColumn column : pfamily.getColumns()) {
            String colName;
            String indexColName = IndexUtil.getIndexColumnName(column);
            PColumn indexColumn = null;
            ColumnRef ref = null;
            String indexColumnFamily = null;
            try {
                indexColumn = index.getColumnForColumnName(indexColName);
                ref = new ColumnRef(projectedTableRef, indexColumn.getPosition());
                indexColumnFamily = indexColumn.getFamilyName() == null ? null : indexColumn.getFamilyName().getString();
            }
            catch (ColumnNotFoundException e) {
                if (IndexUtil.shouldIndexBeUsedForUncoveredQuery(tableRef)) {
                    try {
                        colName = column.getName().getString();
                        String familyName = column.getFamilyName() == null ? null : column.getFamilyName().getString();
                        resolver.resolveColumn(familyName, tableRef.getTableAlias() == null ? tableRef.getTable().getName().getString() : tableRef.getTableAlias(), indexColName);
                        indexColumn = projectedIndex.getColumnForColumnName(colName);
                    }
                    catch (ColumnFamilyNotFoundException c) {
                        throw e;
                    }
                }
                throw e;
            }
            if (resolveColumn) {
                ref = resolver.resolveColumn(index.getTableName().getString(), indexColumnFamily, indexColName);
            }
            Expression expression = ref.newColumnExpression();
            projectedExpressions.add(expression);
            colName = column.getName().toString();
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            projectedColumns.add(new ExpressionProjector(colName, colName, tableRef.getTableAlias() == null ? dataTable.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive));
        }
    }

    private static Expression coerceIfNecessary(int index, List<? extends PDatum> targetColumns, Expression expression) throws SQLException {
        PDatum targetColumn;
        if (index < targetColumns.size() && (targetColumn = targetColumns.get(index)).getDataType() != expression.getDataType()) {
            PDataType targetType = targetColumn.getDataType();
            if (expression.getDataType() != null && !expression.getDataType().isCastableTo(targetType)) {
                throw new ArgumentTypeMismatchException(targetType, expression.getDataType(), "column: " + targetColumn);
            }
            expression = CoerceExpression.create(expression, targetType, targetColumn.getSortOrder(), targetColumn.getMaxLength());
        }
        return expression;
    }

    /*
     * WARNING - void declaration
     */
    public static RowProjector compile(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy, List<? extends PDatum> targetColumns, Expression where, boolean wildcardIncludesDynamicCols) throws SQLException {
        Object name;
        ArrayList<KeyValueColumnExpression> serverParsedKVRefs = new ArrayList<KeyValueColumnExpression>();
        ArrayList<ProjectedColumnExpression> serverParsedProjectedColumnRefs = new ArrayList<ProjectedColumnExpression>();
        ArrayList<Expression> serverParsedKVFuncs = new ArrayList<Expression>();
        ArrayList<Expression> serverParsedOldFuncs = new ArrayList<Expression>();
        HashMap<Expression, Integer> serverParsedExpressionCounts = new HashMap<Expression, Integer>();
        List<AliasedNode> aliasedNodes = statement.getSelect();
        SelectClauseVisitor selectVisitor = new SelectClauseVisitor(context, groupBy, serverParsedKVRefs, serverParsedKVFuncs, serverParsedExpressionCounts, serverParsedProjectedColumnRefs, serverParsedOldFuncs, statement);
        ArrayList<ExpressionProjector> projectedColumns = new ArrayList<ExpressionProjector>();
        ColumnResolver resolver = context.getResolver();
        TableRef tableRef = context.getCurrentTable();
        PTable table = tableRef.getTable();
        boolean resolveColumn = !tableRef.equals(resolver.getTables().get(0));
        boolean isWildcard = false;
        Scan scan = context.getScan();
        int index = 0;
        ArrayList projectedExpressions = Lists.newArrayListWithExpectedSize((int)aliasedNodes.size());
        ArrayList projectedFamilies = Lists.newArrayListWithExpectedSize((int)aliasedNodes.size());
        for (AliasedNode aliasedNode : aliasedNodes) {
            ParseNode node = aliasedNode.getNode();
            if (node instanceof WildcardParseNode) {
                if (statement.isAggregate()) {
                    ExpressionCompiler.throwNonAggExpressionInAggException(node.toString());
                }
                if (tableRef == TableRef.EMPTY_TABLE_REF) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_TABLE_SPECIFIED_FOR_WILDCARD_SELECT).build().buildException();
                }
                isWildcard = true;
                if (tableRef.getTable().getType() == PTableType.INDEX && ((WildcardParseNode)node).isRewrite()) {
                    ProjectionCompiler.projectAllIndexColumns(context, tableRef, resolveColumn, projectedExpressions, projectedColumns, targetColumns);
                } else {
                    ProjectionCompiler.projectAllTableColumns(context, tableRef, resolveColumn, projectedExpressions, projectedColumns, targetColumns);
                }
            } else if (node instanceof TableWildcardParseNode) {
                TableName tName = ((TableWildcardParseNode)node).getTableName();
                TableRef tRef = resolver.resolveTable(tName.getSchemaName(), tName.getTableName());
                if (tRef.equals(tableRef)) {
                    isWildcard = true;
                }
                if (tRef.getTable().getType() == PTableType.INDEX && ((TableWildcardParseNode)node).isRewrite()) {
                    ProjectionCompiler.projectAllIndexColumns(context, tRef, true, projectedExpressions, projectedColumns, targetColumns);
                } else {
                    ProjectionCompiler.projectAllTableColumns(context, tRef, true, projectedExpressions, projectedColumns, targetColumns);
                }
            } else if (node instanceof FamilyWildcardParseNode) {
                if (tableRef == TableRef.EMPTY_TABLE_REF) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_TABLE_SPECIFIED_FOR_WILDCARD_SELECT).build().buildException();
                }
                String cfName = ((FamilyWildcardParseNode)node).getName();
                projectedFamilies.add(Bytes.toBytes((String)cfName));
                if (tableRef.getTable().getType() == PTableType.INDEX && ((FamilyWildcardParseNode)node).isRewrite()) {
                    ProjectionCompiler.projectIndexColumnFamily(context, cfName, tableRef, resolveColumn, projectedExpressions, projectedColumns);
                } else {
                    ProjectionCompiler.projectTableColumnFamily(context, cfName, tableRef, resolveColumn, projectedExpressions, projectedColumns);
                }
            } else {
                boolean bl;
                if (node instanceof PhoenixRowTimestampParseNode && statement.isAggregate()) {
                    ExpressionCompiler.throwNonAggExpressionInAggException(node.toString());
                }
                Expression expression = node.accept(selectVisitor);
                projectedExpressions.add(expression);
                expression = ProjectionCompiler.coerceIfNecessary(index, targetColumns, expression);
                if (node instanceof BindParseNode) {
                    context.getBindManager().addParamMetaData((BindParseNode)node, expression);
                }
                if (!node.isStateless() && !selectVisitor.isAggregate() && statement.isAggregate()) {
                    ExpressionCompiler.throwNonAggExpressionInAggException(expression.toString());
                }
                String tableName = tableRef.getTableAlias() == null ? (table.getName() == null ? "" : table.getName().getString()) : tableRef.getTableAlias();
                String[] colName = SchemaUtil.normalizeIdentifier(aliasedNode.getNode().getAlias());
                Object object = name = colName == null ? expression.toString() : colName;
                boolean bl2 = aliasedNode.getAlias() != null ? aliasedNode.isCaseSensitve() : (bl = colName != null ? SchemaUtil.isCaseSensitive(aliasedNode.getNode().getAlias()) : selectVisitor.isCaseSensitive);
                if (null != aliasedNode.getAlias()) {
                    projectedColumns.add(new ExpressionProjector((String)name, aliasedNode.getAlias(), tableName, expression, bl));
                } else {
                    projectedColumns.add(new ExpressionProjector((String)name, (String)name, tableName, expression, bl));
                }
            }
            selectVisitor.reset();
            ++index;
        }
        for (int i = serverParsedProjectedColumnRefs.size() - 1; i >= 0; --i) {
            Expression expression = (Expression)serverParsedProjectedColumnRefs.get(i);
            Integer count = (Integer)serverParsedExpressionCounts.get(expression);
            if (count == 0) continue;
            serverParsedKVRefs.remove(i);
            serverParsedKVFuncs.remove(i);
            serverParsedOldFuncs.remove(i);
        }
        if (serverParsedKVFuncs.size() > 0 && serverParsedKVRefs.size() > 0) {
            void var31_47;
            final String[] scanAttributes = new String[]{"_SpecificArrayIndex", "_JsonValueFunction", "_JsonQueryFunction", "_BsonValueFunction"};
            final HashMap<String, Class> attributeToFunctionMap = new HashMap<String, Class>(){
                {
                    this.put(scanAttributes[0], ArrayIndexFunction.class);
                    this.put(scanAttributes[1], JsonValueFunction.class);
                    this.put(scanAttributes[2], JsonQueryFunction.class);
                    this.put(scanAttributes[3], BsonValueFunction.class);
                }
            };
            HashMap<Integer, Integer> initialToShuffledPositionMap = new HashMap<Integer, Integer>();
            HashMap<String, List<Expression>> serverAttributeToFuncExpressionMap = new HashMap<String, List<Expression>>(){
                {
                    for (String attribute : attributeToFunctionMap.keySet()) {
                        this.put(attribute, new ArrayList());
                    }
                }
            };
            HashMap<String, List<KeyValueColumnExpression>> serverAttributeToKVExpressionMap = new HashMap<String, List<KeyValueColumnExpression>>(){
                {
                    for (String attribute : attributeToFunctionMap.keySet()) {
                        this.put(attribute, new ArrayList());
                    }
                }
            };
            int counter = 0;
            name = scanAttributes;
            int n = ((String[])name).length;
            boolean bl = false;
            while (var31_47 < n) {
                String attribute = name[var31_47];
                for (int i = 0; i < serverParsedKVFuncs.size(); ++i) {
                    if (!((Class)attributeToFunctionMap.get(attribute)).isInstance(serverParsedKVFuncs.get(i))) continue;
                    initialToShuffledPositionMap.put(i, counter++);
                    ((List)serverAttributeToFuncExpressionMap.get(attribute)).add((Expression)serverParsedKVFuncs.get(i));
                    ((List)serverAttributeToKVExpressionMap.get(attribute)).add((KeyValueColumnExpression)serverParsedKVRefs.get(i));
                }
                ++var31_47;
            }
            for (Map.Entry entry : attributeToFunctionMap.entrySet()) {
                if (((List)serverAttributeToFuncExpressionMap.get(entry.getKey())).size() <= 0) continue;
                ProjectionCompiler.serializeServerParsedExpressionInformationAndSetInScan(context, (String)entry.getKey(), (List)serverAttributeToFuncExpressionMap.get(entry.getKey()), (List)serverAttributeToKVExpressionMap.get(entry.getKey()));
            }
            KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
            for (Expression expression : serverParsedKVRefs) {
                builder.addField(expression);
            }
            KeyValueSchema keyValueSchema = builder.build();
            ValueBitSet valueBitSet = ValueBitSet.newInstance(keyValueSchema);
            builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
            for (Expression expression : serverParsedKVFuncs) {
                builder.addField(expression);
            }
            KeyValueSchema arrayIndexesSchema = builder.build();
            HashMap<Expression, Expression> replacementMap = new HashMap<Expression, Expression>();
            for (int i = 0; i < serverParsedOldFuncs.size(); ++i) {
                Expression function = (Expression)serverParsedKVFuncs.get(i);
                replacementMap.put((Expression)serverParsedOldFuncs.get(i), new ArrayIndexExpression((Integer)initialToShuffledPositionMap.get(i), function.getDataType(), valueBitSet, arrayIndexesSchema));
            }
            ReplaceArrayFunctionExpressionVisitor visitor = new ReplaceArrayFunctionExpressionVisitor(replacementMap);
            for (int i = 0; i < projectedColumns.size(); ++i) {
                ExpressionProjector projector = (ExpressionProjector)projectedColumns.get(i);
                projectedColumns.set(i, new ExpressionProjector(projector.getName(), projector.getLabel(), tableRef.getTableAlias() == null ? (table.getName() == null ? "" : table.getName().getString()) : tableRef.getTableAlias(), projector.getExpression().accept(visitor), projector.isCaseSensitive()));
            }
        }
        boolean isProjectEmptyKeyValue = false;
        if (isWildcard && !wildcardIncludesDynamicCols) {
            ProjectionCompiler.projectAllColumnFamilies(table, scan);
        } else {
            isProjectEmptyKeyValue = where == null || LiteralExpression.isTrue(where) || where.requiresFinalEvaluation();
            for (byte[] family : projectedFamilies) {
                try {
                    if (table.getColumnFamily(family) == null) continue;
                    ProjectionCompiler.projectColumnFamily(table, scan, family);
                }
                catch (ColumnFamilyNotFoundException e) {
                    if (IndexUtil.shouldIndexBeUsedForUncoveredQuery(tableRef)) continue;
                    throw e;
                }
            }
        }
        int estimatedKeySize = table.getRowKeySchema().getEstimatedValueLength();
        int estimatedByteSize = 0;
        for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
            try {
                PColumnFamily family = table.getColumnFamily((byte[])entry.getKey());
                if (entry.getValue() == null) {
                    for (PColumn pColumn : family.getColumns()) {
                        Integer n = pColumn.getMaxLength();
                        int byteSize = pColumn.getDataType().isFixedWidth() ? (n == null ? pColumn.getDataType().getByteSize() : n) : 10;
                        estimatedByteSize += 64 + estimatedKeySize + byteSize;
                    }
                    continue;
                }
                for (byte[] byArray : (NavigableSet)entry.getValue()) {
                    PColumn pColumn = family.getPColumnForColumnQualifier(byArray);
                    if (pColumn == null) continue;
                    Integer maxLength = pColumn.getMaxLength();
                    int byteSize = pColumn.getDataType().isFixedWidth() ? (maxLength == null ? pColumn.getDataType().getByteSize() : maxLength) : 10;
                    estimatedByteSize += 64 + estimatedKeySize + byteSize;
                }
            }
            catch (ColumnFamilyNotFoundException columnFamilyNotFoundException) {
            }
        }
        return new RowProjector(projectedColumns, Math.max(estimatedKeySize, estimatedByteSize), isProjectEmptyKeyValue, resolver.hasUDFs(), isWildcard, wildcardIncludesDynamicCols);
    }

    private static void projectAllColumnFamilies(PTable table, Scan scan) {
        scan.getFamilyMap().clear();
        for (PColumnFamily family : table.getColumnFamilies()) {
            scan.addFamily(family.getName().getBytes());
        }
    }

    private static void serializeServerParsedExpressionInformationAndSetInScan(StatementContext context, String serverParsedExpressionAttribute, List<Expression> serverParsedKVFuncs, List<KeyValueColumnExpression> serverParsedKVRefs) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)serverParsedKVRefs.size());
            for (Expression expression : serverParsedKVRefs) {
                expression.write(output);
            }
            WritableUtils.writeVInt((DataOutput)output, (int)serverParsedKVFuncs.size());
            for (Expression expression : serverParsedKVFuncs) {
                expression.write(output);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        context.getScan().setAttribute(serverParsedExpressionAttribute, stream.toByteArray());
    }

    private static boolean isJsonFunction(FunctionParseNode node) {
        return "JSON_VALUE".equals(node.getName()) || "JSON_QUERY".equals(node.getName());
    }

    private static boolean isBsonFunction(FunctionParseNode node) {
        return "BSON_VALUE".equals(node.getName());
    }

    private static class SelectClauseVisitor
    extends ExpressionCompiler {
        private boolean isCaseSensitive;
        private int elementCount;
        private List<KeyValueColumnExpression> serverParsedKVRefs;
        private List<Expression> serverParsedKVFuncs;
        private List<Expression> serverParsedOldFuncs;
        private List<ProjectedColumnExpression> serverParsedProjectedColumnRefs;
        private Map<Expression, Integer> serverParsedExpressionCounts;
        private SelectStatement statement;

        private SelectClauseVisitor(StatementContext context, GroupByCompiler.GroupBy groupBy, List<KeyValueColumnExpression> serverParsedKVRefs, List<Expression> serverParsedKVFuncs, Map<Expression, Integer> serverParsedExpressionCounts, List<ProjectedColumnExpression> serverParsedProjectedColumnRefs, List<Expression> serverParsedOldFuncs, SelectStatement statement) {
            super(context, groupBy);
            this.serverParsedKVRefs = serverParsedKVRefs;
            this.serverParsedKVFuncs = serverParsedKVFuncs;
            this.serverParsedOldFuncs = serverParsedOldFuncs;
            this.serverParsedExpressionCounts = serverParsedExpressionCounts;
            this.serverParsedProjectedColumnRefs = serverParsedProjectedColumnRefs;
            this.statement = statement;
            this.reset();
        }

        @Override
        public void reset() {
            super.reset();
            this.elementCount = 0;
            this.isCaseSensitive = true;
        }

        @Override
        protected ColumnRef resolveColumn(ColumnParseNode node) throws SQLException {
            ColumnRef ref = super.resolveColumn(node);
            this.isCaseSensitive = this.isCaseSensitive && node.isCaseSensitive();
            return ref;
        }

        @Override
        public Expression visit(ColumnParseNode node) throws SQLException {
            Expression expression = super.visit(node);
            if (SelectClauseVisitor.parseOnServer(expression)) {
                Integer count = this.serverParsedExpressionCounts.get(expression);
                this.serverParsedExpressionCounts.put(expression, count != null ? count + 1 : 1);
            }
            return expression;
        }

        private static boolean parseOnServer(Expression expression) {
            return expression.getDataType().isArrayType() || expression.getDataType().equals(PJson.INSTANCE) || expression.getDataType().equals(PBson.INSTANCE);
        }

        @Override
        public void addElement(List<Expression> l, Expression element) {
            ++this.elementCount;
            this.isCaseSensitive &= this.elementCount == 1;
            super.addElement(l, element);
        }

        @Override
        public Expression visit(SequenceValueParseNode node) throws SQLException {
            if (this.aggregateFunction != null) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_USE_OF_NEXT_VALUE_FOR).setSchemaName(node.getTableName().getSchemaName()).setTableName(node.getTableName().getTableName()).build().buildException();
            }
            return this.context.getSequenceManager().newSequenceReference(node);
        }

        @Override
        public Expression visitLeave(FunctionParseNode node, List<Expression> children) throws SQLException {
            if (!this.statement.isAggregate() && ("ARRAY_ELEM".equals(node.getName()) || ProjectionCompiler.isJsonFunction(node) || ProjectionCompiler.isBsonFunction(node)) && children.get(0) instanceof ProjectedColumnExpression) {
                final ArrayList indexKVs = Lists.newArrayList();
                final ArrayList indexProjectedColumns = Lists.newArrayList();
                final ArrayList<Expression> copyOfChildren = new ArrayList<Expression>(children);
                children.get(0).accept(new ProjectedColumnExpressionVisitor(){

                    @Override
                    public Void visit(ProjectedColumnExpression expression) {
                        if (expression.getDataType().isArrayType() || expression.getDataType().equals(PJson.INSTANCE) || expression.getDataType().equals(PBson.INSTANCE)) {
                            indexProjectedColumns.add(expression);
                            PColumn col = expression.getColumn();
                            if (col instanceof ProjectedColumn && ((ProjectedColumn)col).getSourceColumnRef() instanceof IndexUncoveredDataColumnRef) {
                                return null;
                            }
                            PTable table = context.getCurrentTable().getTable();
                            KeyValueColumnExpression keyValueColumnExpression = table.getImmutableStorageScheme() != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN ? new SingleCellColumnExpression(col, col.getName().getString(), table.getEncodingScheme(), table.getImmutableStorageScheme()) : new KeyValueColumnExpression(col);
                            indexKVs.add(keyValueColumnExpression);
                            copyOfChildren.set(0, keyValueColumnExpression);
                            Integer count = serverParsedExpressionCounts.get(expression);
                            serverParsedExpressionCounts.put(expression, count != null ? count - 1 : -1);
                        }
                        return null;
                    }
                });
                Object func = super.visitLeave(node, (List)children);
                if (!indexKVs.isEmpty()) {
                    this.serverParsedKVRefs.addAll(indexKVs);
                    this.serverParsedProjectedColumnRefs.addAll(indexProjectedColumns);
                    Object funcModified = super.visitLeave(node, (List)copyOfChildren);
                    this.serverParsedKVFuncs.add((Expression)funcModified);
                    this.serverParsedOldFuncs.add((Expression)func);
                }
                return func;
            }
            return super.visitLeave(node, (List)children);
        }
    }

    static class ArrayIndexExpression
    extends BaseTerminalExpression {
        private final int position;
        private final PDataType type;
        private final ValueBitSet arrayIndexesBitSet;
        private final KeyValueSchema arrayIndexesSchema;

        public ArrayIndexExpression(int position, PDataType type, ValueBitSet arrayIndexesBitSet, KeyValueSchema arrayIndexesSchema) {
            this.position = position;
            this.type = type;
            this.arrayIndexesBitSet = arrayIndexesBitSet;
            this.arrayIndexesSchema = arrayIndexesSchema;
        }

        @Override
        public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
            if (!tuple.getValue(QueryConstants.ARRAY_VALUE_COLUMN_FAMILY, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER, ptr)) {
                return false;
            }
            int maxOffset = ptr.getOffset() + ptr.getLength();
            this.arrayIndexesBitSet.or(ptr);
            this.arrayIndexesSchema.iterator(ptr, this.position, this.arrayIndexesBitSet);
            Boolean hasValue = this.arrayIndexesSchema.next(ptr, this.position, maxOffset, this.arrayIndexesBitSet);
            this.arrayIndexesBitSet.clear();
            if (hasValue == null) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            }
            return true;
        }

        @Override
        public PDataType getDataType() {
            return this.type;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> visitor) {
            return null;
        }
    }
}

