/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.expression.visitor.StatelessTraverseNoExpressionVisitor;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterators;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ExpressionUtil;

public class OrderPreservingTracker {
    private final StatementContext context;
    private final GroupByCompiler.GroupBy groupBy;
    private final Ordering ordering;
    private final int pkPositionOffset;
    private Expression whereExpression;
    private List<TrackingOrderByExpression> trackingOrderByExpressions = new LinkedList<TrackingOrderByExpression>();
    private final List<TrackOrderByContext> trackOrderByContexts;
    private TrackOrderByContext selectedTrackOrderByContext = null;
    private final List<OrderByCompiler.OrderBy> inputOrderBys;

    public OrderPreservingTracker(StatementContext context, GroupByCompiler.GroupBy groupBy, Ordering ordering, int nNodes) throws SQLException {
        this(context, groupBy, ordering, nNodes, null, null, null);
    }

    public OrderPreservingTracker(StatementContext context, GroupByCompiler.GroupBy groupBy, Ordering ordering, int nNodes, List<OrderByCompiler.OrderBy> inputOrderBys, QueryPlan innerQueryPlan, Expression whereExpression) throws SQLException {
        this.context = context;
        this.groupBy = groupBy;
        this.ordering = ordering;
        this.whereExpression = whereExpression;
        if (inputOrderBys != null) {
            this.inputOrderBys = inputOrderBys;
            this.pkPositionOffset = 0;
        } else {
            Pair<List<OrderByCompiler.OrderBy>, Integer> orderBysAndRowKeyColumnOffset = OrderPreservingTracker.getInputOrderBys(innerQueryPlan, groupBy, context);
            this.inputOrderBys = (List)orderBysAndRowKeyColumnOffset.getFirst();
            this.pkPositionOffset = (Integer)orderBysAndRowKeyColumnOffset.getSecond();
        }
        if (this.inputOrderBys.isEmpty()) {
            this.trackOrderByContexts = Collections.emptyList();
            return;
        }
        this.trackOrderByContexts = new ArrayList<TrackOrderByContext>(this.inputOrderBys.size());
        for (OrderByCompiler.OrderBy inputOrderBy : this.inputOrderBys) {
            this.trackOrderByContexts.add(new TrackOrderByContext(nNodes, inputOrderBy));
        }
    }

    private static Pair<List<OrderByCompiler.OrderBy>, Integer> getInputOrderBys(QueryPlan innerQueryPlan, GroupByCompiler.GroupBy groupBy, StatementContext statementContext) throws SQLException {
        if (!groupBy.isEmpty()) {
            return Pair.newPair(Collections.singletonList(ExpressionUtil.convertGroupByToOrderBy(groupBy, false)), (Object)0);
        }
        if (innerQueryPlan != null) {
            return Pair.newPair(innerQueryPlan.getOutputOrderBys(), (Object)0);
        }
        TableRef tableRef = statementContext.getResolver().getTables().get(0);
        if (!tableRef.getTable().rowKeyOrderOptimizable()) {
            return Pair.newPair(Collections.emptyList(), (Object)0);
        }
        PhoenixConnection phoenixConnection = statementContext.getConnection();
        Pair<OrderByCompiler.OrderBy, Integer> orderByAndRowKeyColumnOffset = ExpressionUtil.getOrderByFromTable(tableRef, phoenixConnection, false);
        OrderByCompiler.OrderBy orderBy = (OrderByCompiler.OrderBy)orderByAndRowKeyColumnOffset.getFirst();
        Integer rowKeyColumnOffset = (Integer)orderByAndRowKeyColumnOffset.getSecond();
        return Pair.newPair(orderBy != OrderByCompiler.OrderBy.EMPTY_ORDER_BY ? Collections.singletonList(orderBy) : Collections.emptyList(), (Object)rowKeyColumnOffset);
    }

    public void track(Expression expression) {
        this.track(expression, null, null);
    }

    public void track(Expression expression, Boolean isAscending, Boolean isNullsLast) {
        TrackingOrderByExpression trackingOrderByExpression = new TrackingOrderByExpression(expression, isAscending, isNullsLast);
        this.trackingOrderByExpressions.add(trackingOrderByExpression);
    }

    public int getOrderPreservingColumnCount() {
        if (this.selectedTrackOrderByContext == null) {
            return 0;
        }
        return this.selectedTrackOrderByContext.getOrderPreservingColumnCount();
    }

    public List<Info> getOrderPreservingTrackInfos() {
        if (this.selectedTrackOrderByContext == null) {
            return Collections.emptyList();
        }
        return this.selectedTrackOrderByContext.getOrderPreservingTrackInfos();
    }

    public boolean isOrderPreserving() {
        if (this.selectedTrackOrderByContext != null) {
            return this.selectedTrackOrderByContext.isOrderPreserving();
        }
        if (this.trackOrderByContexts.isEmpty()) {
            return false;
        }
        if (this.trackingOrderByExpressions.isEmpty()) {
            return false;
        }
        for (TrackOrderByContext trackOrderByContext : this.trackOrderByContexts) {
            trackOrderByContext.track(this.trackingOrderByExpressions);
            if (trackOrderByContext.isOrderPreserving()) {
                this.selectedTrackOrderByContext = trackOrderByContext;
                break;
            }
            if (this.selectedTrackOrderByContext != null) continue;
            this.selectedTrackOrderByContext = trackOrderByContext;
        }
        return this.selectedTrackOrderByContext.isOrderPreserving();
    }

    public boolean isReverse() {
        if (this.selectedTrackOrderByContext == null) {
            throw new IllegalStateException("isReverse should only be called when isOrderPreserving is true!");
        }
        return this.selectedTrackOrderByContext.isReverse();
    }

    public static enum Ordering {
        ORDERED,
        UNORDERED;

    }

    private class TrackOrderByContext {
        private final List<Info> orderPreservingTrackedInfos;
        private boolean isOrderPreserving = true;
        private Boolean isReverse = null;
        private int orderPreservingColumnCount = 0;
        private int orderedTrackedInfosCount = 0;
        private final TrackOrderPreservingExpressionVisitor trackOrderPreservingExpressionVisitor;
        private final OrderByCompiler.OrderBy inputOrderBy;
        private int trackingOrderByExpressionCount = 0;
        private boolean isOrderPreservingCalled = false;

        TrackOrderByContext(int orderByNodeCount, OrderByCompiler.OrderBy inputOrderBy) {
            this.trackOrderPreservingExpressionVisitor = new TrackOrderPreservingExpressionVisitor(inputOrderBy);
            this.orderPreservingTrackedInfos = Lists.newArrayListWithExpectedSize((int)orderByNodeCount);
            this.inputOrderBy = inputOrderBy;
        }

        public void track(List<TrackingOrderByExpression> trackingOrderByExpressions) {
            this.trackingOrderByExpressionCount = trackingOrderByExpressions.size();
            trackingOrderByExpressions.forEach(trackingOrderByExpression -> {
                Expression expression = trackingOrderByExpression.expression;
                Info trackedInfo = expression.accept(this.trackOrderPreservingExpressionVisitor);
                if (trackedInfo != null) {
                    trackedInfo.trackingOrderByExpression = trackingOrderByExpression;
                    this.orderPreservingTrackedInfos.add(trackedInfo);
                }
            });
        }

        private void checkAscendingAndNullsLast(Info trackedInfo) {
            TrackingOrderByExpression trackingOrderByExpression = trackedInfo.trackingOrderByExpression;
            Expression expression = trackingOrderByExpression.expression;
            Boolean isAscending = trackingOrderByExpression.isAscending;
            Boolean isNullsLast = trackingOrderByExpression.isNullsLast;
            if (isAscending != null && trackedInfo.ascending != isAscending) {
                if (this.isReverse == null) {
                    this.isReverse = true;
                } else if (!this.isReverse.booleanValue()) {
                    this.isOrderPreserving = false;
                    this.isReverse = false;
                    return;
                }
            } else if (this.isReverse == null) {
                this.isReverse = false;
            } else if (this.isReverse.booleanValue()) {
                this.isOrderPreserving = false;
                this.isReverse = false;
                return;
            }
            assert (this.isReverse != null);
            if (isNullsLast != null && expression.isNullable() && (trackedInfo.nullsLast == isNullsLast && this.isReverse.booleanValue() || trackedInfo.nullsLast != isNullsLast && !this.isReverse.booleanValue())) {
                this.isOrderPreserving = false;
                this.isReverse = false;
                return;
            }
        }

        public int getOrderPreservingColumnCount() {
            if (!this.isOrderPreservingCalled) {
                throw new IllegalStateException("getOrderPreservingColumnCount must be called after isOrderPreserving is called!");
            }
            return this.orderPreservingColumnCount;
        }

        public List<Info> getOrderPreservingTrackInfos() {
            if (!this.isOrderPreservingCalled) {
                throw new IllegalStateException("getOrderPreservingTrackInfos must be called after isOrderPreserving is called!");
            }
            if (this.isOrderPreserving) {
                return ImmutableList.copyOf(this.orderPreservingTrackedInfos);
            }
            if (this.orderedTrackedInfosCount <= 0) {
                return Collections.emptyList();
            }
            return ImmutableList.copyOf(this.orderPreservingTrackedInfos.subList(0, this.orderedTrackedInfosCount));
        }

        public boolean isOrderPreserving() {
            if (this.isOrderPreservingCalled) {
                return this.isOrderPreserving;
            }
            if (OrderPreservingTracker.this.ordering == Ordering.UNORDERED) {
                Collections.sort(this.orderPreservingTrackedInfos, new Comparator<Info>(){

                    @Override
                    public int compare(Info o1, Info o2) {
                        int cmp = o1.pkPosition - o2.pkPosition;
                        if (cmp != 0) {
                            return cmp;
                        }
                        return o2.orderPreserving.ordinal() - o1.orderPreserving.ordinal();
                    }
                });
            }
            int prevSlotSpan = 1;
            int prevPos = -1;
            FunctionExpression.OrderPreserving prevOrderPreserving = FunctionExpression.OrderPreserving.YES;
            this.orderedTrackedInfosCount = 0;
            for (int i = 0; i < this.orderPreservingTrackedInfos.size(); ++i) {
                Info entry = this.orderPreservingTrackedInfos.get(i);
                int pos = entry.pkPosition;
                this.checkAscendingAndNullsLast(entry);
                boolean bl = this.isOrderPreserving = this.isOrderPreserving && entry.orderPreserving != FunctionExpression.OrderPreserving.NO && prevOrderPreserving == FunctionExpression.OrderPreserving.YES && (pos == prevPos || pos - prevSlotSpan == prevPos || this.hasEqualityConstraints(prevPos + prevSlotSpan, pos));
                if (!this.isOrderPreserving) break;
                ++this.orderedTrackedInfosCount;
                prevPos = pos;
                prevSlotSpan = entry.slotSpan;
                prevOrderPreserving = entry.orderPreserving;
            }
            this.isOrderPreserving = this.isOrderPreserving && this.orderPreservingTrackedInfos.size() == this.trackingOrderByExpressionCount;
            this.orderPreservingColumnCount = prevPos + prevSlotSpan + OrderPreservingTracker.this.pkPositionOffset;
            this.isOrderPreservingCalled = true;
            return this.isOrderPreserving;
        }

        private boolean hasEqualityConstraints(int startPos, int endPos) {
            ScanRanges ranges = OrderPreservingTracker.this.context.getScanRanges();
            for (int pos = startPos; pos < endPos; ++pos) {
                IsConstantVisitor visitor;
                Expression expressionToCheckConstant = this.getExpressionToCheckConstant(pos);
                Boolean isConstant = expressionToCheckConstant.accept(visitor = new IsConstantVisitor(ranges, OrderPreservingTracker.this.whereExpression));
                if (Boolean.TRUE.equals(isConstant)) continue;
                return false;
            }
            return true;
        }

        public boolean isReverse() {
            if (!this.isOrderPreservingCalled) {
                throw new IllegalStateException("isReverse must be called after isOrderPreserving is called!");
            }
            if (!this.isOrderPreserving) {
                throw new IllegalStateException("isReverse should only be called when isOrderPreserving is true!");
            }
            return Boolean.TRUE.equals(this.isReverse);
        }

        private Expression getExpressionToCheckConstant(int columnIndex) {
            if (!OrderPreservingTracker.this.groupBy.isEmpty()) {
                List<Expression> groupByExpressions = OrderPreservingTracker.this.groupBy.getExpressions();
                assert (columnIndex < groupByExpressions.size());
                return groupByExpressions.get(columnIndex);
            }
            assert (columnIndex < this.inputOrderBy.getOrderByExpressions().size());
            return this.inputOrderBy.getOrderByExpressions().get(columnIndex).getExpression();
        }
    }

    private static class TrackingOrderByExpression {
        private Expression expression;
        private Boolean isAscending;
        private Boolean isNullsLast;

        TrackingOrderByExpression(Expression expression, Boolean isAscending, Boolean isNullsLast) {
            this.expression = expression;
            this.isAscending = isAscending;
            this.isNullsLast = isNullsLast;
        }
    }

    private static class TrackOrderPreservingExpressionVisitor
    extends StatelessTraverseNoExpressionVisitor<Info> {
        private Map<Expression, Pair<Integer, OrderByExpression>> expressionToPositionAndOrderByExpression;

        public TrackOrderPreservingExpressionVisitor(OrderByCompiler.OrderBy orderBy) {
            if (orderBy.isEmpty()) {
                this.expressionToPositionAndOrderByExpression = Collections.emptyMap();
                return;
            }
            List<OrderByExpression> orderByExpressions = orderBy.getOrderByExpressions();
            this.expressionToPositionAndOrderByExpression = new HashMap<Expression, Pair<Integer, OrderByExpression>>(orderByExpressions.size());
            int index = 0;
            for (OrderByExpression orderByExpression : orderByExpressions) {
                this.expressionToPositionAndOrderByExpression.put(orderByExpression.getExpression(), (Pair<Integer, OrderByExpression>)new Pair((Object)index++, (Object)orderByExpression));
            }
        }

        @Override
        public Info defaultReturn(Expression expression, List<Info> childInfos) {
            return this.match(expression);
        }

        @Override
        public Info visit(RowKeyColumnExpression rowKeyColumnExpression) {
            return this.match(rowKeyColumnExpression);
        }

        @Override
        public Info visit(KeyValueColumnExpression keyValueColumnExpression) {
            return this.match(keyValueColumnExpression);
        }

        @Override
        public Info visit(ProjectedColumnExpression projectedColumnExpression) {
            return this.match(projectedColumnExpression);
        }

        private Info match(Expression expression) {
            Pair<Integer, OrderByExpression> positionAndOrderByExpression = this.expressionToPositionAndOrderByExpression.get(expression);
            if (positionAndOrderByExpression == null) {
                return null;
            }
            return new Info((Integer)positionAndOrderByExpression.getFirst(), ((OrderByExpression)positionAndOrderByExpression.getSecond()).isAscending(), ((OrderByExpression)positionAndOrderByExpression.getSecond()).isNullsLast());
        }

        @Override
        public Iterator<Expression> visitEnter(ScalarFunction node) {
            return node.preservesOrder() == FunctionExpression.OrderPreserving.NO ? Collections.emptyIterator() : Iterators.singletonIterator((Object)node.getChildren().get(node.getKeyFormationTraversalIndex()));
        }

        @Override
        public Info visitLeave(ScalarFunction node, List<Info> l) {
            boolean sortOrderIsSame;
            if (l.isEmpty()) {
                return null;
            }
            Info info = l.get(0);
            FunctionExpression.OrderPreserving orderPreserving = FunctionExpression.OrderPreserving.values()[Math.min(node.preservesOrder().ordinal(), info.orderPreserving.ordinal())];
            Expression childExpression = node.getChildren().get(node.getKeyFormationTraversalIndex());
            boolean bl = sortOrderIsSame = node.getSortOrder() == childExpression.getSortOrder();
            if (orderPreserving == info.orderPreserving && sortOrderIsSame) {
                return info;
            }
            return new Info(info.pkPosition, info.slotSpan, orderPreserving, sortOrderIsSame ? info.ascending : !info.ascending, info.nullsLast);
        }

        @Override
        public Iterator<Expression> visitEnter(CoerceExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Info visitLeave(CoerceExpression node, List<Info> l) {
            if (l.isEmpty()) {
                return null;
            }
            return l.get(0);
        }

        @Override
        public Iterator<Expression> visitEnter(RowValueConstructorExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Info visitLeave(RowValueConstructorExpression node, List<Info> l) {
            Info firstInfo;
            if (l.size() != node.getChildren().size()) {
                return null;
            }
            Info lastInfo = firstInfo = l.get(0);
            for (int i = 1; i < l.size(); ++i) {
                if (lastInfo.orderPreserving == FunctionExpression.OrderPreserving.YES_IF_LAST) {
                    return null;
                }
                Info info = l.get(i);
                if (info.pkPosition != lastInfo.pkPosition + 1) {
                    return null;
                }
                if (info.ascending != lastInfo.ascending) {
                    return null;
                }
                if (info.nullsLast != lastInfo.nullsLast) {
                    return null;
                }
                lastInfo = info;
            }
            return new Info(firstInfo.pkPosition, l.size(), lastInfo.orderPreserving, lastInfo.ascending, lastInfo.nullsLast);
        }
    }

    private static class IsConstantVisitor
    extends StatelessTraverseAllExpressionVisitor<Boolean> {
        private final ScanRanges scanRanges;
        private final Expression whereExpression;

        public IsConstantVisitor(ScanRanges scanRanges, Expression whereExpression) {
            this.scanRanges = scanRanges;
            this.whereExpression = whereExpression;
        }

        @Override
        public Boolean defaultReturn(Expression node, List<Boolean> returnValues) {
            if (!ExpressionUtil.isContantForStatement(node) || returnValues.size() < node.getChildren().size()) {
                return Boolean.FALSE;
            }
            for (Boolean returnValue : returnValues) {
                if (returnValue.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(RowKeyColumnExpression node) {
            return this.scanRanges.hasEqualityConstraint(node.getPosition());
        }

        @Override
        public Boolean visit(LiteralExpression node) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(KeyValueColumnExpression keyValueColumnExpression) {
            return ExpressionUtil.isColumnExpressionConstant(keyValueColumnExpression, this.whereExpression);
        }

        @Override
        public Boolean visit(ProjectedColumnExpression projectedColumnExpression) {
            return ExpressionUtil.isColumnExpressionConstant(projectedColumnExpression, this.whereExpression);
        }
    }

    public static class Info {
        private final FunctionExpression.OrderPreserving orderPreserving;
        private final int pkPosition;
        private final int slotSpan;
        private final boolean ascending;
        private final boolean nullsLast;
        private TrackingOrderByExpression trackingOrderByExpression;

        public Info(int pkPosition, boolean ascending, boolean nullsLast) {
            this.pkPosition = pkPosition;
            this.orderPreserving = FunctionExpression.OrderPreserving.YES;
            this.slotSpan = 1;
            this.ascending = ascending;
            this.nullsLast = nullsLast;
        }

        public Info(int rowKeyColumnPosition, int rowKeySlotSpan, FunctionExpression.OrderPreserving orderPreserving, boolean ascending, boolean nullsLast) {
            this.pkPosition = rowKeyColumnPosition;
            this.slotSpan = rowKeySlotSpan;
            this.orderPreserving = orderPreserving;
            this.ascending = ascending;
            this.nullsLast = nullsLast;
        }

        public static List<Expression> extractExpressions(List<Info> orderPreservingTrackInfos) {
            ArrayList<Expression> newExpressions = new ArrayList<Expression>(orderPreservingTrackInfos.size());
            for (Info trackInfo : orderPreservingTrackInfos) {
                newExpressions.add(trackInfo.getExpression());
            }
            return newExpressions;
        }

        public Expression getExpression() {
            return this.trackingOrderByExpression.expression;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public boolean isNullsLast() {
            return this.nullsLast;
        }
    }
}

