/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.phoenix.compile.CompiledOffset;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderPreservingTracker;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatelessExpressionCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowValueConstructorOffsetNotAllowedInQueryException;
import org.apache.phoenix.schema.RowValueConstructorOffsetNotCoercibleException;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;

public class OrderByCompiler {
    public static OrderBy compile(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy, Integer limit, CompiledOffset offset, RowProjector rowProjector, QueryPlan innerQueryPlan, Expression whereExpression) throws SQLException {
        List<OrderByNode> orderByNodes = statement.getOrderBy();
        if (orderByNodes.isEmpty()) {
            return OrderBy.EMPTY_ORDER_BY;
        }
        ExpressionCompiler compiler = groupBy.isUngroupedAggregate() ? new StatelessExpressionCompiler(context, GroupByCompiler.GroupBy.EMPTY_GROUP_BY) : new ExpressionCompiler(context, groupBy);
        OrderPreservingTracker tracker = null;
        if (OrderByCompiler.isTrackOrderByPreserving(statement)) {
            tracker = new OrderPreservingTracker(context, groupBy, OrderPreservingTracker.Ordering.ORDERED, orderByNodes.size(), null, innerQueryPlan, whereExpression);
        }
        LinkedHashSet orderByExpressions = Sets.newLinkedHashSetWithExpectedSize((int)orderByNodes.size());
        for (OrderByNode node : orderByNodes) {
            Expression expression = null;
            if (node.isIntegerLiteral()) {
                if (rowProjector == null) {
                    throw new IllegalStateException("rowProjector is null when there is LiteralParseNode in orderByNodes");
                }
                Integer index = node.getValueIfIntegerLiteral();
                assert (index != null);
                int size = rowProjector.getColumnProjectors().size();
                if (index > size || index <= 0) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PARAM_INDEX_OUT_OF_BOUND).build().buildException();
                }
                expression = rowProjector.getColumnProjector(index - 1).getExpression();
            } else {
                expression = node.getNode().accept(compiler);
                if (!expression.isStateless() && !compiler.isAggregate() && (statement.isAggregate() || statement.isDistinct())) {
                    if (statement.isDistinct()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.ORDER_BY_NOT_IN_SELECT_DISTINCT).setMessage(expression.toString()).build().buildException();
                    }
                    ExpressionCompiler.throwNonAggExpressionInAggException(expression.toString());
                }
            }
            if (!expression.isStateless()) {
                boolean isAscending = node.isAscending();
                boolean isNullsLast = node.isNullsLast();
                if (tracker != null) {
                    tracker.track(expression, isAscending, isNullsLast);
                }
                OrderByExpression orderByExpression = OrderByExpression.createByCheckIfExpressionSortOrderDesc(expression, isNullsLast, isAscending);
                orderByExpressions.add(orderByExpression);
            }
            compiler.reset();
        }
        if (offset.getByteOffset().isPresent() && orderByExpressions.isEmpty()) {
            throw new RowValueConstructorOffsetNotAllowedInQueryException("RVC OFFSET requires either forceRowKeyOrder or explict ORDERBY with row key order");
        }
        if (orderByExpressions.isEmpty() || groupBy.isUngroupedAggregate()) {
            return OrderBy.EMPTY_ORDER_BY;
        }
        if (tracker != null && tracker.isOrderPreserving()) {
            if (tracker.isReverse()) {
                if (context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.useReverseScan", true) && !context.getScanRanges().useSkipScanFilter() && context.getCurrentTable().getTable().getType() != PTableType.PROJECTED && context.getCurrentTable().getTable().getType() != PTableType.SUBQUERY && !statement.getHint().hasHint(HintNode.Hint.FORWARD_SCAN)) {
                    if (offset.getByteOffset().isPresent()) {
                        throw new SQLException("Do not allow non-pk ORDER BY with RVC OFFSET");
                    }
                    return OrderBy.REV_ROW_KEY_ORDER_BY;
                }
            } else {
                return OrderBy.FWD_ROW_KEY_ORDER_BY;
            }
        }
        if (offset.getByteOffset().isPresent()) {
            throw new RowValueConstructorOffsetNotCoercibleException("Do not allow non-pk ORDER BY with RVC OFFSET");
        }
        return new OrderBy(Lists.newArrayList(orderByExpressions.iterator()));
    }

    public static boolean isTrackOrderByPreserving(SelectStatement selectStatement) {
        return !selectStatement.isUnion();
    }

    private OrderByCompiler() {
    }

    public static class OrderBy {
        public static final OrderBy EMPTY_ORDER_BY = new OrderBy(Collections.emptyList());
        public static final OrderBy FWD_ROW_KEY_ORDER_BY = new OrderBy(Collections.emptyList());
        public static final OrderBy REV_ROW_KEY_ORDER_BY = new OrderBy(Collections.emptyList());
        private final List<OrderByExpression> orderByExpressions;

        public OrderBy(List<OrderByExpression> orderByExpressions) {
            this.orderByExpressions = ImmutableList.copyOf(orderByExpressions);
        }

        public List<OrderByExpression> getOrderByExpressions() {
            return this.orderByExpressions;
        }

        public boolean isEmpty() {
            return this.orderByExpressions == null || this.orderByExpressions.isEmpty();
        }

        public static List<OrderBy> wrapForOutputOrderBys(OrderBy orderBy) {
            assert (orderBy != FWD_ROW_KEY_ORDER_BY && orderBy != REV_ROW_KEY_ORDER_BY);
            if (orderBy == null || orderBy == EMPTY_ORDER_BY) {
                return Collections.emptyList();
            }
            return Collections.singletonList(orderBy);
        }

        public static OrderBy convertCompiledOrderByToOutputOrderBy(OrderBy orderBy) {
            if (orderBy.isEmpty()) {
                return orderBy;
            }
            List<OrderByExpression> orderByExpressions = orderBy.getOrderByExpressions();
            ArrayList<OrderByExpression> newOrderByExpressions = new ArrayList<OrderByExpression>(orderByExpressions.size());
            for (OrderByExpression orderByExpression : orderByExpressions) {
                OrderByExpression newOrderByExpression = OrderByExpression.convertIfExpressionSortOrderDesc(orderByExpression);
                newOrderByExpressions.add(newOrderByExpression);
            }
            return new OrderBy(newOrderByExpressions);
        }

        public static boolean equalsForOutputOrderBy(OrderBy orderBy1, OrderBy orderBy2) {
            return Objects.equals(orderBy1.orderByExpressions, orderBy2.orderByExpressions);
        }
    }
}

