/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.WhereOptimizer;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.visitor.StatelessTraverseNoExpressionVisitor;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionlessQueryServicesImpl;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterators;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTableCompiler.class);
    private static final PDatum VARBINARY_DATUM = new VarbinaryDatum();
    private final PhoenixStatement statement;
    private final PhoenixStatement.Operation operation;

    public CreateTableCompiler(PhoenixStatement statement, PhoenixStatement.Operation operation) {
        this.statement = statement;
        this.operation = operation;
    }

    public MutationPlan compile(CreateTableStatement create) throws SQLException {
        PhoenixConnection connection = this.statement.getConnection();
        ColumnResolver resolver = FromCompiler.getResolverForCreation(create, connection);
        PTableType type = create.getTableType();
        PTable parentToBe = null;
        PTable.ViewType viewTypeToBe = null;
        Scan scan = new Scan();
        StatementContext context = new StatementContext(this.statement, resolver, scan, new SequenceManager(this.statement));
        ParseNode whereNode = create.getWhereClause();
        String viewStatementToBe = null;
        byte[][] viewColumnConstantsToBe = null;
        BitSet isViewColumnReferencedToBe = null;
        HashSet<PColumn> pkColumnsInWhere = new HashSet<PColumn>();
        HashSet<PColumn> nonPkColumnsInWhere = new HashSet<PColumn>();
        byte[] rowKeyMatcher = ByteUtil.EMPTY_BYTE_ARRAY;
        List<ColumnDef> columnDefs = create.getColumnDefs();
        ArrayList<ColumnDef> overideColumnDefs = null;
        PrimaryKeyConstraint pkConstraint = create.getPrimaryKeyConstraint();
        for (int i = 0; i < columnDefs.size(); ++i) {
            ColumnDef columnDef = columnDefs.get(i);
            if (columnDef.getColumnDefName().getFamilyName() != null && columnDef.getColumnDefName().getFamilyName().contains("L#")) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNALLOWED_COLUMN_FAMILY).build().buildException();
            }
            if (columnDef.validateDefault(context, pkConstraint)) continue;
            if (overideColumnDefs == null) {
                overideColumnDefs = new ArrayList<ColumnDef>(columnDefs);
            }
            overideColumnDefs.set(i, new ColumnDef(columnDef, null));
        }
        if (overideColumnDefs != null) {
            create = new CreateTableStatement(create, overideColumnDefs);
        }
        CreateTableStatement finalCreate = create;
        if (type == PTableType.VIEW) {
            TableRef tableRef = resolver.getTables().get(0);
            int nColumns = tableRef.getTable().getColumns().size();
            isViewColumnReferencedToBe = new BitSet(nColumns);
            ColumnTrackingExpressionCompiler expressionCompiler = new ColumnTrackingExpressionCompiler(context, isViewColumnReferencedToBe);
            parentToBe = tableRef.getTable();
            if (parentToBe.getType() == PTableType.SYSTEM) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_VIEWS_ON_SYSTEM_TABLES).build().buildException();
            }
            viewTypeToBe = parentToBe.getViewType() == PTable.ViewType.MAPPED ? PTable.ViewType.MAPPED : PTable.ViewType.UPDATABLE;
            Expression where = null;
            if (whereNode == null) {
                if (parentToBe.getViewType() == PTable.ViewType.READ_ONLY) {
                    viewTypeToBe = PTable.ViewType.READ_ONLY;
                }
                if ((viewStatementToBe = parentToBe.getViewStatement()) != null) {
                    select = new SQLParser(viewStatementToBe).parseQuery();
                    whereNode = select.getWhere();
                    where = whereNode.accept(expressionCompiler);
                }
            } else {
                if ((whereNode = StatementNormalizer.normalize(whereNode, resolver)).isStateless()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WHERE_IS_CONSTANT).build().buildException();
                }
                if (parentToBe.getViewStatement() != null) {
                    select = new SQLParser(parentToBe.getViewStatement()).parseQuery().combine(whereNode);
                    whereNode = select.getWhere();
                }
                if ((where = whereNode.accept(expressionCompiler)) != null && !LiteralExpression.isTrue(where)) {
                    TableName baseTableName = create.getBaseTableName();
                    StringBuilder buf = new StringBuilder();
                    whereNode.toSQL(resolver, buf);
                    viewStatementToBe = QueryUtil.getViewStatement(baseTableName.getSchemaName(), baseTableName.getTableName(), buf.toString());
                }
                if (viewTypeToBe != PTable.ViewType.MAPPED) {
                    viewColumnConstantsToBe = new byte[nColumns][];
                    ViewWhereExpressionVisitor visitor = new ViewWhereExpressionVisitor(parentToBe, viewColumnConstantsToBe);
                    where.accept(visitor);
                    viewTypeToBe = visitor.isUpdatable() ? PTable.ViewType.UPDATABLE : PTable.ViewType.READ_ONLY;
                    boolean updatableViewRestrictionEnabled = connection.getQueryServices().getProps().getBoolean("phoenix.updatable.view.restriction.enabled", false);
                    if (viewTypeToBe == PTable.ViewType.UPDATABLE && updatableViewRestrictionEnabled) {
                        ViewWhereExpressionValidatorVisitor validatorVisitor = new ViewWhereExpressionValidatorVisitor(parentToBe, pkColumnsInWhere, nonPkColumnsInWhere);
                        where.accept(validatorVisitor);
                        if (!(connection.getQueryServices() instanceof ConnectionlessQueryServicesImpl)) {
                            try {
                                viewTypeToBe = this.setViewTypeToBe(connection, parentToBe, pkColumnsInWhere, nonPkColumnsInWhere);
                                LOGGER.info("VIEW type is set to {}. View Statement: {}, View Name: {}, Parent Table/View Name: {}", new Object[]{viewTypeToBe, viewStatementToBe, create.getTableName(), parentToBe.getName()});
                            }
                            catch (IOException e) {
                                throw new SQLException(e);
                            }
                        }
                    }
                    if (viewTypeToBe != PTable.ViewType.UPDATABLE) {
                        viewColumnConstantsToBe = null;
                    }
                }
            }
            if (viewTypeToBe == PTable.ViewType.MAPPED && parentToBe.getPKColumns().isEmpty()) {
                this.validateCreateViewCompilation(connection, parentToBe, columnDefs, pkConstraint);
            } else if (where != null && viewTypeToBe == PTable.ViewType.UPDATABLE) {
                rowKeyMatcher = WhereOptimizer.getRowKeyMatcher(context, create.getTableName(), parentToBe, where);
            }
            this.verifyIfAnyParentHasIndexesAndViewExtendsPk(parentToBe, columnDefs, pkConstraint);
        }
        PTable.ViewType viewType = viewTypeToBe;
        String viewStatement = viewStatementToBe;
        byte[][] viewColumnConstants = viewColumnConstantsToBe;
        BitSet isViewColumnReferenced = isViewColumnReferencedToBe;
        List<ParseNode> splitNodes = create.getSplitNodes();
        byte[][] splits = new byte[splitNodes.size()][];
        ImmutableBytesWritable ptr = context.getTempPtr();
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(context);
        for (int i = 0; i < splits.length; ++i) {
            Expression expression;
            ParseNode node = splitNodes.get(i);
            if (node instanceof BindParseNode) {
                context.getBindManager().addParamMetaData((BindParseNode)node, VARBINARY_DATUM);
            }
            if (!node.isStateless() || !(expression = node.accept(expressionCompiler)).evaluate(null, ptr)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.SPLIT_POINT_NOT_CONSTANT).setMessage("Node: " + node).build().buildException();
            }
            splits[i] = ByteUtil.copyKeyBytesIfNecessary(ptr);
        }
        MetaDataClient client = new MetaDataClient(connection);
        PTable parent = parentToBe;
        return new CreateTableMutationPlan(context, client, finalCreate, splits, parent, viewStatement, viewType, rowKeyMatcher, viewColumnConstants, isViewColumnReferenced, connection);
    }

    private PTable.ViewType setViewTypeToBe(PhoenixConnection connection, PTable parentToBe, Set<PColumn> pkColumnsInWhere, Set<PColumn> nonPkColumnsInWhere) throws IOException, SQLException {
        if (!nonPkColumnsInWhere.isEmpty()) {
            LOGGER.info("Setting the view type as READ_ONLY because the view statement contains non-PK columns: {}", nonPkColumnsInWhere);
            return PTable.ViewType.READ_ONLY;
        }
        if (pkColumnsInWhere.isEmpty()) {
            return PTable.ViewType.UPDATABLE;
        }
        ArrayList<Integer> tablePkPositions = new ArrayList<Integer>();
        ArrayList<Integer> viewPkPositions = new ArrayList<Integer>();
        List<PColumn> tablePkColumns = parentToBe.getPKColumns();
        tablePkColumns.forEach(tablePkColumn -> tablePkPositions.add(tablePkColumn.getPosition()));
        pkColumnsInWhere.forEach(pkColumn -> viewPkPositions.add(pkColumn.getPosition()));
        Collections.sort(viewPkPositions);
        int tablePkStartIdx = 0;
        if (parentToBe.isMultiTenant()) {
            ++tablePkStartIdx;
        }
        if (parentToBe.getBucketNum() != null) {
            ++tablePkStartIdx;
        }
        if (!Objects.equals(viewPkPositions.get(0), tablePkPositions.get(tablePkStartIdx))) {
            LOGGER.info("Setting the view type as READ_ONLY because the view statement WHERE clause does not start from the first PK column (ignore the prefix PKs if the parent table is multi-tenant and/or salted). View PK Columns: {}, Table PK Columns: {}", pkColumnsInWhere, tablePkColumns);
            return PTable.ViewType.READ_ONLY;
        }
        if (!this.isPkColumnsInOrder(viewPkPositions, tablePkPositions, tablePkStartIdx)) {
            LOGGER.info("Setting the view type as READ_ONLY because the PK columns is not in the order they are defined. View PK Columns: {}, Table PK Columns: {}", pkColumnsInWhere, tablePkColumns);
            return PTable.ViewType.READ_ONLY;
        }
        byte[] parentTenantIdInBytes = parentToBe.getTenantId() != null ? parentToBe.getTenantId().getBytes() : null;
        byte[] parentSchemaNameInBytes = parentToBe.getSchemaName() != null ? parentToBe.getSchemaName().getBytes() : null;
        ConnectionQueryServices queryServices = connection.getQueryServices();
        Configuration config = queryServices.getConfiguration();
        byte[] systemChildLinkTable = SchemaUtil.isNamespaceMappingEnabled(null, config) ? PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAMESPACE_BYTES : PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES;
        try (Table childLinkTable = queryServices.getTable(systemChildLinkTable);){
            List legitimateSiblingViewList = (List)ViewUtil.findAllDescendantViews(childLinkTable, config, parentTenantIdInBytes, parentSchemaNameInBytes, parentToBe.getTableName().getBytes(), Long.MAX_VALUE, true, false).getFirst();
            if (!legitimateSiblingViewList.isEmpty()) {
                PTable siblingView = (PTable)legitimateSiblingViewList.get(0);
                Expression siblingViewWhere = this.getWhereFromView(connection, siblingView);
                HashSet<PColumn> siblingViewPkColsInWhere = new HashSet<PColumn>();
                if (siblingViewWhere != null) {
                    ViewWhereExpressionValidatorVisitor siblingViewValidatorVisitor = new ViewWhereExpressionValidatorVisitor(parentToBe, siblingViewPkColsInWhere, null);
                    siblingViewWhere.accept(siblingViewValidatorVisitor);
                }
                if (!pkColumnsInWhere.equals(siblingViewPkColsInWhere)) {
                    LOGGER.info("Setting the view type as READ_ONLY because its set of PK columns is different from its sibling view {}'s. View PK Columns: {}, Sibling View PK Columns: {}", new Object[]{siblingView.getName(), pkColumnsInWhere, siblingViewPkColsInWhere});
                    PTable.ViewType viewType = PTable.ViewType.READ_ONLY;
                    return viewType;
                }
            }
        }
        return PTable.ViewType.UPDATABLE;
    }

    private Expression getWhereFromView(PhoenixConnection connection, PTable view) throws SQLException {
        String viewStatement = view.getViewStatement();
        if (viewStatement == null) {
            return null;
        }
        SelectStatement select = new SQLParser(viewStatement).parseQuery();
        ColumnResolver resolver = FromCompiler.getResolverForQuery(select, connection);
        StatementContext context = new StatementContext(new PhoenixStatement(connection), resolver);
        BitSet isViewColumnReferencedToBe = new BitSet(view.getColumns().size());
        ColumnTrackingExpressionCompiler expressionCompiler = new ColumnTrackingExpressionCompiler(context, isViewColumnReferencedToBe);
        ParseNode whereNode = select.getWhere();
        return whereNode.accept(expressionCompiler);
    }

    private boolean isPkColumnsInOrder(List<Integer> viewPkPositions, List<Integer> tablePkPositions, int tablePkStartIdx) {
        for (int i = 1; i < viewPkPositions.size(); ++i) {
            if (Objects.equals(viewPkPositions.get(i), tablePkPositions.get(tablePkStartIdx + i))) continue;
            return false;
        }
        return true;
    }

    private void verifyIfAnyParentHasIndexesAndViewExtendsPk(PTable parentToBe, List<ColumnDef> columnDefs, PrimaryKeyConstraint pkConstraint) throws SQLException {
        if (this.viewExtendsParentPk(columnDefs, pkConstraint)) {
            PTable table = parentToBe;
            while (table != null) {
                if (table.getIndexes().size() > 0) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES).build().buildException();
                }
                if (table.getType() != PTableType.VIEW) {
                    return;
                }
                String schemaName = table.getParentSchemaName().getString();
                String tableName = table.getParentTableName().getString();
                try {
                    table = this.statement.getConnection().getTable(SchemaUtil.getTableName(schemaName, tableName));
                }
                catch (TableNotFoundException e) {
                    table = null;
                }
            }
        }
    }

    private void validateCreateViewCompilation(PhoenixConnection connection, PTable parentToBe, List<ColumnDef> columnDefs, PrimaryKeyConstraint pkConstraint) throws SQLException {
        boolean isPKMissed = true;
        if (pkConstraint.getColumnNames().size() > 0) {
            isPKMissed = false;
        } else {
            for (ColumnDef columnDef : columnDefs) {
                if (!columnDef.isPK()) continue;
                isPKMissed = false;
                break;
            }
        }
        PName fullTableName = SchemaUtil.getPhysicalHBaseTableName(parentToBe.getSchemaName(), parentToBe.getTableName(), parentToBe.isNamespaceMapped());
        try {
            Table ignored = connection.getQueryServices().getTableIfExists(fullTableName.getBytes());
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        if (isPKMissed) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_MISSING).build().buildException();
        }
    }

    private boolean viewExtendsParentPk(List<ColumnDef> columnDefs, PrimaryKeyConstraint pkConstraint) {
        if (pkConstraint.getColumnNames().size() > 0) {
            return true;
        }
        return columnDefs.stream().anyMatch(ColumnDef::isPK);
    }

    public static class ColumnTrackingExpressionCompiler
    extends ExpressionCompiler {
        private final BitSet isColumnReferenced;

        public ColumnTrackingExpressionCompiler(StatementContext context, BitSet isColumnReferenced) {
            super(context, true);
            this.isColumnReferenced = isColumnReferenced;
        }

        @Override
        protected ColumnRef resolveColumn(ColumnParseNode node) throws SQLException {
            ColumnRef ref = super.resolveColumn(node);
            this.isColumnReferenced.set(ref.getColumn().getPosition());
            return ref;
        }
    }

    public static class ViewWhereExpressionVisitor
    extends StatelessTraverseNoExpressionVisitor<Boolean> {
        private boolean isUpdatable = true;
        private final PTable table;
        private int position;
        private final byte[][] columnValues;
        private final ImmutableBytesWritable ptr = new ImmutableBytesWritable();

        public ViewWhereExpressionVisitor(PTable table, byte[][] columnValues) {
            this.table = table;
            this.columnValues = columnValues;
        }

        public boolean isUpdatable() {
            return this.isUpdatable;
        }

        @Override
        public Boolean defaultReturn(Expression node, List<Boolean> l) {
            this.isUpdatable = false;
            return null;
        }

        @Override
        public Iterator<Expression> visitEnter(AndExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Boolean visitLeave(AndExpression node, List<Boolean> l) {
            return l.isEmpty() ? null : Boolean.TRUE;
        }

        @Override
        public Iterator<Expression> visitEnter(ComparisonExpression node) {
            if (node.getFilterOp() == CompareOperator.EQUAL && node.getChildren().get(1).isStateless() && node.getChildren().get(1).getDeterminism() == Determinism.ALWAYS) {
                return Iterators.singletonIterator((Object)node.getChildren().get(0));
            }
            return super.visitEnter(node);
        }

        @Override
        public Boolean visitLeave(ComparisonExpression node, List<Boolean> l) {
            if (l.isEmpty()) {
                return null;
            }
            node.getChildren().get(1).evaluate(null, this.ptr);
            this.columnValues[this.position] = new byte[this.ptr.getLength() + 1];
            System.arraycopy(this.ptr.get(), this.ptr.getOffset(), this.columnValues[this.position], 0, this.ptr.getLength());
            return Boolean.TRUE;
        }

        @Override
        public Iterator<Expression> visitEnter(IsNullExpression node) {
            return node.isNegate() ? super.visitEnter(node) : node.getChildren().iterator();
        }

        @Override
        public Boolean visitLeave(IsNullExpression node, List<Boolean> l) {
            return l.isEmpty() ? null : Boolean.TRUE;
        }

        @Override
        public Boolean visit(RowKeyColumnExpression node) {
            this.position = this.table.getPKColumns().get(node.getPosition()).getPosition();
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(KeyValueColumnExpression node) {
            try {
                this.position = this.table.getColumnFamily(node.getColumnFamily()).getPColumnForColumnQualifier(node.getColumnQualifier()).getPosition();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(SingleCellColumnExpression node) {
            return this.visit(node.getKeyValueExpression());
        }
    }

    public static class ViewWhereExpressionValidatorVisitor
    extends StatelessTraverseNoExpressionVisitor<Boolean> {
        private boolean isUpdatable = true;
        private final PTable table;
        private final Set<PColumn> pkColumns;
        private final Set<PColumn> nonPKColumns;

        public ViewWhereExpressionValidatorVisitor(PTable table, Set<PColumn> pkColumns, Set<PColumn> nonPKColumns) {
            this.table = table;
            this.pkColumns = pkColumns;
            this.nonPKColumns = nonPKColumns;
        }

        public boolean isUpdatable() {
            return this.isUpdatable;
        }

        @Override
        public Boolean defaultReturn(Expression node, List<Boolean> l) {
            this.isUpdatable = false;
            return null;
        }

        @Override
        public Iterator<Expression> visitEnter(AndExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Boolean visitLeave(AndExpression node, List<Boolean> l) {
            return l.isEmpty() ? null : Boolean.TRUE;
        }

        @Override
        public Iterator<Expression> visitEnter(ComparisonExpression node) {
            if (node.getFilterOp() == CompareOperator.EQUAL && node.getChildren().get(1).isStateless() && node.getChildren().get(1).getDeterminism() == Determinism.ALWAYS) {
                return Iterators.singletonIterator((Object)node.getChildren().get(0));
            }
            return super.visitEnter(node);
        }

        @Override
        public Boolean visitLeave(ComparisonExpression node, List<Boolean> l) {
            return l.isEmpty() ? null : Boolean.TRUE;
        }

        @Override
        public Iterator<Expression> visitEnter(IsNullExpression node) {
            return node.isNegate() ? super.visitEnter(node) : node.getChildren().iterator();
        }

        @Override
        public Boolean visitLeave(IsNullExpression node, List<Boolean> l) {
            return l.isEmpty() ? null : Boolean.TRUE;
        }

        @Override
        public Boolean visit(RowKeyColumnExpression node) {
            this.pkColumns.add(this.table.getPKColumns().get(node.getPosition()));
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(KeyValueColumnExpression node) {
            try {
                if (this.nonPKColumns != null) {
                    this.nonPKColumns.add(this.table.getColumnFamily(node.getColumnFamily()).getPColumnForColumnQualifier(node.getColumnQualifier()));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(SingleCellColumnExpression node) {
            return this.visit(node.getKeyValueExpression());
        }
    }

    private class CreateTableMutationPlan
    extends BaseMutationPlan {
        private final MetaDataClient client;
        private final CreateTableStatement finalCreate;
        private final byte[][] splits;
        private final PTable parent;
        private final String viewStatement;
        private final PTable.ViewType viewType;
        private final byte[][] viewColumnConstants;
        private final BitSet isViewColumnReferenced;
        private final byte[] rowKeyMatcher;
        private final PhoenixConnection connection;

        private CreateTableMutationPlan(StatementContext context, MetaDataClient client, CreateTableStatement finalCreate, byte[][] splits, PTable parent, String viewStatement, PTable.ViewType viewType, byte[] rowKeyMatcher, byte[][] viewColumnConstants, BitSet isViewColumnReferenced, PhoenixConnection connection) {
            super(context, CreateTableCompiler.this.operation);
            this.client = client;
            this.finalCreate = finalCreate;
            this.splits = splits;
            this.parent = parent;
            this.viewStatement = viewStatement;
            this.viewType = viewType;
            this.rowKeyMatcher = rowKeyMatcher;
            this.viewColumnConstants = viewColumnConstants;
            this.isViewColumnReferenced = isViewColumnReferenced;
            this.connection = connection;
        }

        @Override
        public MutationState execute() throws SQLException {
            try {
                MutationState mutationState = this.client.createTable(this.finalCreate, this.splits, this.parent, this.viewStatement, this.viewType, MetaDataUtil.getViewIndexIdDataType(), this.rowKeyMatcher, this.viewColumnConstants, this.isViewColumnReferenced);
                return mutationState;
            }
            finally {
                if (this.client.getConnection() != this.connection) {
                    this.client.getConnection().close();
                }
            }
        }

        @Override
        public ExplainPlan getExplainPlan() throws SQLException {
            return new ExplainPlan(Collections.singletonList("CREATE TABLE"));
        }
    }

    private static class VarbinaryDatum
    implements PDatum {
        private VarbinaryDatum() {
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public PDataType getDataType() {
            return PVarbinary.INSTANCE;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    }
}

