/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.ServerMetadataCache;
import org.apache.phoenix.coprocessorclient.metrics.MetricsMetadataCachingSource;
import org.apache.phoenix.coprocessorclient.metrics.MetricsPhoenixCoprocessorSourceFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.cache.Cache;
import org.apache.phoenix.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMetadataCacheImpl
implements ServerMetadataCache {
    protected Configuration conf;
    protected final Cache<ImmutableBytesPtr, Long> lastDDLTimestampMap;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerMetadataCacheImpl.class);
    private static final String PHOENIX_COPROC_REGIONSERVER_CACHE_SIZE = "phoenix.coprocessor.regionserver.cache.size";
    private static final long DEFAULT_PHOENIX_COPROC_REGIONSERVER_CACHE_SIZE = 10000L;
    private static volatile ServerMetadataCacheImpl cacheInstance;
    private MetricsMetadataCachingSource metricsSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerMetadataCacheImpl getInstance(Configuration conf) {
        ServerMetadataCacheImpl result = cacheInstance;
        if (result != null) return result;
        Class<ServerMetadataCacheImpl> clazz = ServerMetadataCacheImpl.class;
        synchronized (ServerMetadataCacheImpl.class) {
            result = cacheInstance;
            if (result != null) return result;
            cacheInstance = result = new ServerMetadataCacheImpl(conf);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public ServerMetadataCacheImpl(Configuration conf) {
        this.conf = HBaseConfiguration.create((Configuration)conf);
        this.metricsSource = MetricsPhoenixCoprocessorSourceFactory.getInstance().getMetadataCachingSource();
        long maxSize = conf.getLong(PHOENIX_COPROC_REGIONSERVER_CACHE_SIZE, 10000L);
        this.lastDDLTimestampMap = CacheBuilder.newBuilder().removalListener(notification -> {
            String key = ((ImmutableBytesPtr)((Object)((Object)notification.getKey()))).toString();
            LOGGER.debug("Expiring " + key + " because of " + notification.getCause().name());
        }).maximumSize(maxSize).build();
    }

    @Override
    public long getLastDDLTimestampForTable(byte[] tenantID, byte[] schemaName, byte[] tableName) throws SQLException {
        PTable table;
        byte[] tableKey = SchemaUtil.getTableKey(tenantID, schemaName, tableName);
        ImmutableBytesPtr tableKeyPtr = new ImmutableBytesPtr(tableKey);
        Long lastDDLTimestamp = (Long)this.lastDDLTimestampMap.getIfPresent((Object)tableKeyPtr);
        if (lastDDLTimestamp != null) {
            this.metricsSource.incrementRegionServerMetadataCacheHitCount();
            LOGGER.trace("Retrieving last ddl timestamp value from cache for schema: {}, table: {}", (Object)Bytes.toString((byte[])schemaName), (Object)Bytes.toString((byte[])tableName));
            return lastDDLTimestamp;
        }
        this.metricsSource.incrementRegionServerMetadataCacheMissCount();
        String tenantIDStr = Bytes.toString((byte[])tenantID);
        if (tenantIDStr == null || tenantIDStr.isEmpty()) {
            tenantIDStr = null;
        }
        Properties properties = new Properties();
        if (tenantIDStr != null) {
            properties.setProperty("TenantId", tenantIDStr);
        }
        try (Connection connection = this.getConnection(properties);){
            table = connection.unwrap(PhoenixConnection.class).getTableFromServerNoCache(schemaName, tableName);
            this.lastDDLTimestampMap.put((Object)tableKeyPtr, (Object)table.getLastDDLTimestamp());
        }
        return table.getLastDDLTimestamp();
    }

    @Override
    public void invalidate(byte[] tenantID, byte[] schemaName, byte[] tableName) {
        LOGGER.info("Invalidating server metadata cache for tenantID: {}, schema: {},  table: {}", new Object[]{Bytes.toString((byte[])tenantID), Bytes.toString((byte[])schemaName), Bytes.toString((byte[])tableName)});
        byte[] tableKey = SchemaUtil.getTableKey(tenantID, schemaName, tableName);
        ImmutableBytesPtr tableKeyPtr = new ImmutableBytesPtr(tableKey);
        this.lastDDLTimestampMap.invalidate((Object)tableKeyPtr);
    }

    protected Connection getConnection(Properties properties) throws SQLException {
        return QueryUtil.getConnectionOnServer(properties, this.conf);
    }
}

