/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc.controller;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.ipc.controller.ServerToServerRpcController;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ServerToServerRpcControllerImpl
extends ServerRpcController
implements ServerToServerRpcController {
    private int priority;
    private static final List<String> SYSTEM_TABLE_NAMES = new ImmutableList.Builder().add((Object)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME).add((Object)PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME).add((Object)PhoenixDatabaseMetaData.SYSTEM_TASK_NAME).add((Object)SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, true).getNameAsString()).add((Object)SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, true).getNameAsString()).add((Object)SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_TASK_NAME_BYTES, true).getNameAsString()).build();

    public ServerToServerRpcControllerImpl(Configuration conf) {
        this.priority = IndexUtil.getServerSidePriority(conf);
    }

    @Override
    public void setPriority(TableName tn) {
        if (SYSTEM_TABLE_NAMES.contains(tn.getNameAsString())) {
            this.setPriority(this.priority);
        }
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

