/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc.controller;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.DelegatingHBaseRpcController;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

class MetadataRpcController
extends DelegatingHBaseRpcController {
    private int priority;
    private static final List<String> SYSTEM_TABLE_NAMES = new ImmutableList.Builder().add((Object)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME).add((Object)PhoenixDatabaseMetaData.SYSTEM_STATS_NAME).add((Object)PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME).add((Object)PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME).add((Object)PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME).add((Object)SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, true).getNameAsString()).add((Object)SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, true).getNameAsString()).add((Object)SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, true).getNameAsString()).add((Object)SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES, true).getNameAsString()).add((Object)SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, true).getNameAsString()).build();

    public MetadataRpcController(HBaseRpcController delegate, Configuration conf) {
        super(delegate);
        this.priority = IndexUtil.getMetadataPriority(conf);
    }

    public void setPriority(TableName tn) {
        if (SYSTEM_TABLE_NAMES.contains(tn.getNameAsString())) {
            this.setPriority(this.priority);
        } else {
            super.setPriority(tn);
        }
    }
}

