// $ANTLR 3.5.2 PhoenixSQL.g 2025-10-07 16:50:46

/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.parse;

///CLOVER:OFF
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.util.Pair;
import java.lang.Boolean;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.sql.SQLException;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PFunction.FunctionArgument;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.PTable.IndexType;
import org.apache.phoenix.schema.PTable.CDCChangeScope;
import org.apache.phoenix.schema.stats.StatisticsCollectionScope;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.parse.LikeParseNode.LikeType;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.parse.AddJarsStatement;
import org.apache.phoenix.parse.ExplainType;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
@SuppressWarnings("all")
public class PhoenixSQLParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ACTIVE", "ADD", "ALL", "ALTER", 
		"AND", "ANY", "ARRAY", "AS", "ASC", "ASTERISK", "ASYNC", "AT", "B", "BETWEEN", 
		"BIND_NAME", "BIN_DIGIT", "BIN_LITERAL", "BY", "CACHE", "CASCADE", "CASE", 
		"CAST", "CDC", "CHANGE", "CHAR", "CHAR_ESC", "CLOSE", "COLON", "COLUMN", 
		"COLUMNS", "COLUMN_QUALIFIER_COUNTER", "COMMA", "COMMENT_AND_HINT_END", 
		"COMMENT_START", "CONCAT", "CONSTANT", "CONSTRAINT", "CREATE", "CURRENT", 
		"CURSOR", "CYCLE", "DBL_QUOTE_CHAR", "DECIMAL", "DECLARE", "DEFAULT", 
		"DEFAULTVALUE", "DELETE", "DESC", "DIGIT", "DISABLE", "DISTINCT", "DIVIDE", 
		"DOT", "DOUBLE", "DOUBLE_EQ", "DOUBLE_QUOTE", "DROP", "DUPLICATE", "ELSE", 
		"ENCODED_QUALIFIER", "END", "EOL", "EQ", "EXECUTE", "EXISTS", "EXPLAIN", 
		"Exponent", "FALSE", "FETCH", "FIELDCHAR", "FIRST", "FOR", "FROM", "FULL", 
		"FUNCTION", "GRANT", "GROUP", "GT", "HAVING", "HEX_DIGIT", "HEX_LITERAL", 
		"HINT_START", "IF", "IGNORE", "ILIKE", "IMMUTABLE", "IN", "INCLUDE", "INCREMENT", 
		"INDEX", "INNER", "INTO", "IS", "JAR", "JARS", "JOIN", "KEY", "LAST", 
		"LATEST", "LCURLY", "LEFT", "LETTER", "LIKE", "LIMIT", "LIST", "LOCAL", 
		"LPAREN", "LSQUARE", "LT", "MAXVALUE", "MINUS", "MINVALUE", "ML_COMMENT", 
		"ML_HINT", "NAME", "NEXT", "NOEQ1", "NOEQ2", "NOT", "NOVERIFY", "NULL", 
		"NULLS", "NUMBER", "OFF", "OFFSET", "ON", "ONLY", "OPEN", "OR", "ORDER", 
		"OTHER", "OUTER", "OUTER_JOIN", "PERCENT", "PLUS", "POSINTEGER", "POST", 
		"PRE", "PRIMARY", "QUESTION", "RCURLY", "REBUILD", "REGIONS", "REPLACE", 
		"RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROW", "ROWS", "ROW_TIMESTAMP", 
		"RPAREN", "RSQUARE", "SAMPLING", "SCHEMA", "SCHEMAS", "SELECT", "SEMICOLON", 
		"SEQUENCE", "SESSION", "SET", "SHOW", "SL_COMMENT", "SL_COMMENT1", "SL_COMMENT2", 
		"SOME", "SPLIT", "START", "STATISTICS", "STRING_LITERAL", "TABLE", "TABLES", 
		"TABLESAMPLE", "TEMPORARY", "THEN", "TILDE", "TO", "TRACE", "TRUE", "UNCOVERED", 
		"UNION", "UNUSABLE", "UPDATE", "UPDATE_ONLY", "UPGRADE", "UPSERT", "USABLE", 
		"USE", "USING", "VALUE", "VALUES", "VIEW", "WHEN", "WHERE", "WITH", "WITHIN", 
		"WS", "X"
	};
	public static final int EOF=-1;
	public static final int ACTIVE=4;
	public static final int ADD=5;
	public static final int ALL=6;
	public static final int ALTER=7;
	public static final int AND=8;
	public static final int ANY=9;
	public static final int ARRAY=10;
	public static final int AS=11;
	public static final int ASC=12;
	public static final int ASTERISK=13;
	public static final int ASYNC=14;
	public static final int AT=15;
	public static final int B=16;
	public static final int BETWEEN=17;
	public static final int BIND_NAME=18;
	public static final int BIN_DIGIT=19;
	public static final int BIN_LITERAL=20;
	public static final int BY=21;
	public static final int CACHE=22;
	public static final int CASCADE=23;
	public static final int CASE=24;
	public static final int CAST=25;
	public static final int CDC=26;
	public static final int CHANGE=27;
	public static final int CHAR=28;
	public static final int CHAR_ESC=29;
	public static final int CLOSE=30;
	public static final int COLON=31;
	public static final int COLUMN=32;
	public static final int COLUMNS=33;
	public static final int COLUMN_QUALIFIER_COUNTER=34;
	public static final int COMMA=35;
	public static final int COMMENT_AND_HINT_END=36;
	public static final int COMMENT_START=37;
	public static final int CONCAT=38;
	public static final int CONSTANT=39;
	public static final int CONSTRAINT=40;
	public static final int CREATE=41;
	public static final int CURRENT=42;
	public static final int CURSOR=43;
	public static final int CYCLE=44;
	public static final int DBL_QUOTE_CHAR=45;
	public static final int DECIMAL=46;
	public static final int DECLARE=47;
	public static final int DEFAULT=48;
	public static final int DEFAULTVALUE=49;
	public static final int DELETE=50;
	public static final int DESC=51;
	public static final int DIGIT=52;
	public static final int DISABLE=53;
	public static final int DISTINCT=54;
	public static final int DIVIDE=55;
	public static final int DOT=56;
	public static final int DOUBLE=57;
	public static final int DOUBLE_EQ=58;
	public static final int DOUBLE_QUOTE=59;
	public static final int DROP=60;
	public static final int DUPLICATE=61;
	public static final int ELSE=62;
	public static final int ENCODED_QUALIFIER=63;
	public static final int END=64;
	public static final int EOL=65;
	public static final int EQ=66;
	public static final int EXECUTE=67;
	public static final int EXISTS=68;
	public static final int EXPLAIN=69;
	public static final int Exponent=70;
	public static final int FALSE=71;
	public static final int FETCH=72;
	public static final int FIELDCHAR=73;
	public static final int FIRST=74;
	public static final int FOR=75;
	public static final int FROM=76;
	public static final int FULL=77;
	public static final int FUNCTION=78;
	public static final int GRANT=79;
	public static final int GROUP=80;
	public static final int GT=81;
	public static final int HAVING=82;
	public static final int HEX_DIGIT=83;
	public static final int HEX_LITERAL=84;
	public static final int HINT_START=85;
	public static final int IF=86;
	public static final int IGNORE=87;
	public static final int ILIKE=88;
	public static final int IMMUTABLE=89;
	public static final int IN=90;
	public static final int INCLUDE=91;
	public static final int INCREMENT=92;
	public static final int INDEX=93;
	public static final int INNER=94;
	public static final int INTO=95;
	public static final int IS=96;
	public static final int JAR=97;
	public static final int JARS=98;
	public static final int JOIN=99;
	public static final int KEY=100;
	public static final int LAST=101;
	public static final int LATEST=102;
	public static final int LCURLY=103;
	public static final int LEFT=104;
	public static final int LETTER=105;
	public static final int LIKE=106;
	public static final int LIMIT=107;
	public static final int LIST=108;
	public static final int LOCAL=109;
	public static final int LPAREN=110;
	public static final int LSQUARE=111;
	public static final int LT=112;
	public static final int MAXVALUE=113;
	public static final int MINUS=114;
	public static final int MINVALUE=115;
	public static final int ML_COMMENT=116;
	public static final int ML_HINT=117;
	public static final int NAME=118;
	public static final int NEXT=119;
	public static final int NOEQ1=120;
	public static final int NOEQ2=121;
	public static final int NOT=122;
	public static final int NOVERIFY=123;
	public static final int NULL=124;
	public static final int NULLS=125;
	public static final int NUMBER=126;
	public static final int OFF=127;
	public static final int OFFSET=128;
	public static final int ON=129;
	public static final int ONLY=130;
	public static final int OPEN=131;
	public static final int OR=132;
	public static final int ORDER=133;
	public static final int OTHER=134;
	public static final int OUTER=135;
	public static final int OUTER_JOIN=136;
	public static final int PERCENT=137;
	public static final int PLUS=138;
	public static final int POSINTEGER=139;
	public static final int POST=140;
	public static final int PRE=141;
	public static final int PRIMARY=142;
	public static final int QUESTION=143;
	public static final int RCURLY=144;
	public static final int REBUILD=145;
	public static final int REGIONS=146;
	public static final int REPLACE=147;
	public static final int RETURNING=148;
	public static final int RETURNS=149;
	public static final int REVOKE=150;
	public static final int RIGHT=151;
	public static final int ROW=152;
	public static final int ROWS=153;
	public static final int ROW_TIMESTAMP=154;
	public static final int RPAREN=155;
	public static final int RSQUARE=156;
	public static final int SAMPLING=157;
	public static final int SCHEMA=158;
	public static final int SCHEMAS=159;
	public static final int SELECT=160;
	public static final int SEMICOLON=161;
	public static final int SEQUENCE=162;
	public static final int SESSION=163;
	public static final int SET=164;
	public static final int SHOW=165;
	public static final int SL_COMMENT=166;
	public static final int SL_COMMENT1=167;
	public static final int SL_COMMENT2=168;
	public static final int SOME=169;
	public static final int SPLIT=170;
	public static final int START=171;
	public static final int STATISTICS=172;
	public static final int STRING_LITERAL=173;
	public static final int TABLE=174;
	public static final int TABLES=175;
	public static final int TABLESAMPLE=176;
	public static final int TEMPORARY=177;
	public static final int THEN=178;
	public static final int TILDE=179;
	public static final int TO=180;
	public static final int TRACE=181;
	public static final int TRUE=182;
	public static final int UNCOVERED=183;
	public static final int UNION=184;
	public static final int UNUSABLE=185;
	public static final int UPDATE=186;
	public static final int UPDATE_ONLY=187;
	public static final int UPGRADE=188;
	public static final int UPSERT=189;
	public static final int USABLE=190;
	public static final int USE=191;
	public static final int USING=192;
	public static final int VALUE=193;
	public static final int VALUES=194;
	public static final int VIEW=195;
	public static final int WHEN=196;
	public static final int WHERE=197;
	public static final int WITH=198;
	public static final int WITHIN=199;
	public static final int WS=200;
	public static final int X=201;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public PhoenixSQLParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public PhoenixSQLParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return PhoenixSQLParser.tokenNames; }
	@Override public String getGrammarFileName() { return "PhoenixSQL.g"; }


	    
	    /**
	     * used to turn '?' binds into : binds.
	     */
	    private int anonBindNum;
	    private ParseNodeFactory factory;
	    private ParseContext.Stack contextStack = new ParseContext.Stack();
	    private Map<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);

	    public void setParseNodeFactory(ParseNodeFactory factory) {
	        this.factory = factory;
	    }
	    
	    public boolean isCountFunction(String field) {
	        return CountAggregateFunction.NORMALIZED_NAME.equals(SchemaUtil.normalizeIdentifier(field));
	    }
	     
	    public int line(Token t) {
	        return t.getLine();
	    }

	    public int column(Token t) {
	        return t.getCharPositionInLine() + 1;
	    }
	    
	    private void throwRecognitionException(Token t) throws RecognitionException {
	        RecognitionException e = new RecognitionException();
	        e.token = t;
	        e.line = t.getLine();
	        e.charPositionInLine = t.getCharPositionInLine();
	        e.input = input;
	        throw e;
	    }
	    
	    public int getBindCount() {
	        return anonBindNum;
	    }
	    
	    public void resetBindCount() {
	        anonBindNum = 0;
	    }

	    public String nextBind() {
	        return Integer.toString(++anonBindNum);
	    }
	    
	    public void updateBind(String namedBind){
	         int nBind = Integer.parseInt(namedBind);
	         if (nBind > anonBindNum) {
	             anonBindNum = nBind;
	         }
	    }

	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	        throws RecognitionException {
	        RecognitionException e = null;
	        // if next token is what we are looking for then "delete" this token
	        if (mismatchIsUnwantedToken(input, ttype)) {
	            e = new UnwantedTokenException(ttype, input);
	        } else if (mismatchIsMissingToken(input, follow)) {
	            Object inserted = getMissingSymbol(input, e, ttype, follow);
	            e = new MissingTokenException(ttype, input, inserted);
	        } else {
	            e = new MismatchedTokenException(ttype, input);
	        }
	        throw e;
	    }

	    public Object recoverFromMismatchedSet(IntStream input, RecognitionException e, BitSet follow)
	        throws RecognitionException
	    {
	        throw e;
	    }
	    
	    @Override
	    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
	        if (e instanceof MismatchedTokenException) {
	            MismatchedTokenException mte = (MismatchedTokenException)e;
	            String txt = mte.token.getText();
	            String p = mte.token.getType() == -1 ? "EOF" : PARAPHRASE[mte.token.getType()];
	            String expecting = (mte.expecting < PARAPHRASE.length && mte.expecting >= 0) ? PARAPHRASE[mte.expecting] : null;
	            if (expecting == null) {
	                return "unexpected token (" + line(mte.token) + "," + column(mte.token) + "): " + (txt != null ? txt : p);
	            } else {
	                return "expecting " + expecting +
	                    ", found '" + (txt != null ? txt : p) + "'";
	            }
	        } else if (e instanceof NoViableAltException) {
	            //NoViableAltException nvae = (NoViableAltException)e;
	            return "unexpected token: (" + line(e.token) + "," + column(e.token) + ")" + getTokenErrorDisplay(e.token);
	        }
	        return super.getErrorMessage(e, tokenNames);
	     }

	    public String getTokenErrorDisplay(int t) {
	        String ret = PARAPHRASE[t];
	        if (ret == null) ret = "<UNKNOWN>";
	        return ret;
	    }


	    private String[] PARAPHRASE = new String[getTokenNames().length];
	    {
	        PARAPHRASE[NAME] = "a field or entity name";
	        PARAPHRASE[NUMBER] = "a number";
	        PARAPHRASE[EQ] = "an equals sign";
	        PARAPHRASE[LT] = "a left angle bracket";
	        PARAPHRASE[GT] = "a right angle bracket";
	        PARAPHRASE[COMMA] = "a comma";
	        PARAPHRASE[LPAREN] = "a left parentheses";
	        PARAPHRASE[RPAREN] = "a right parentheses";
	        PARAPHRASE[SEMICOLON] = "a semi-colon";
	        PARAPHRASE[COLON] = "a colon";
	        PARAPHRASE[LSQUARE] = "left square bracket";
	        PARAPHRASE[RSQUARE] = "right square bracket";
	        PARAPHRASE[LCURLY] = "left curly bracket";
	        PARAPHRASE[RCURLY] = "right curly bracket";
	        PARAPHRASE[AT] = "at";
	        PARAPHRASE[MINUS] = "a subtraction";
	        PARAPHRASE[TILDE] = "a tilde";
	        PARAPHRASE[PLUS] = "an addition";
	        PARAPHRASE[ASTERISK] = "an asterisk";
	        PARAPHRASE[DIVIDE] = "a division";
	        PARAPHRASE[FIELDCHAR] = "a field character";
	        PARAPHRASE[LETTER] = "an ansi letter";
	        PARAPHRASE[POSINTEGER] = "a positive integer";
	        PARAPHRASE[DIGIT] = "a number from 0 to 9";
	    }



	// $ANTLR start "nextStatement"
	// PhoenixSQL.g:401:1: nextStatement returns [BindableStatement ret] : (s= oneStatement SEMICOLON | EOF );
	public final BindableStatement nextStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:402:5: (s= oneStatement SEMICOLON | EOF )
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( (LA1_0==ADD||LA1_0==ALTER||LA1_0==CLOSE||LA1_0==CREATE||LA1_0==DECLARE||LA1_0==DELETE||LA1_0==DROP||LA1_0==EXECUTE||LA1_0==EXPLAIN||LA1_0==FETCH||LA1_0==GRANT||LA1_0==LIST||LA1_0==OPEN||LA1_0==REVOKE||LA1_0==SELECT||LA1_0==SHOW||LA1_0==TRACE||LA1_0==UPDATE||LA1_0==UPSERT||LA1_0==USE) ) {
				alt1=1;
			}
			else if ( (LA1_0==EOF) ) {
				alt1=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 1, 0, input);
				throw nvae;
			}

			switch (alt1) {
				case 1 :
					// PhoenixSQL.g:402:8: s= oneStatement SEMICOLON
					{
					pushFollow(FOLLOW_oneStatement_in_nextStatement1411);
					s=oneStatement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					    		try {
					    			ret = s;
					    		} finally {
					    			udfParseNodes.clear();
					    		}
					    	}
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_nextStatement1415); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:409:8: EOF
					{
					match(input,EOF,FOLLOW_EOF_in_nextStatement1424); if (state.failed) return ret;
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "nextStatement"



	// $ANTLR start "statement"
	// PhoenixSQL.g:413:1: statement returns [BindableStatement ret] : s= oneStatement EOF ;
	public final BindableStatement statement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:414:5: (s= oneStatement EOF )
			// PhoenixSQL.g:414:9: s= oneStatement EOF
			{
			pushFollow(FOLLOW_oneStatement_in_statement1450);
			s=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			        		try {
			    			ret = s;
			    		} finally {
			    			udfParseNodes.clear();
			    		}
			    	}
			match(input,EOF,FOLLOW_EOF_in_statement1454); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "statement"



	// $ANTLR start "query"
	// PhoenixSQL.g:424:1: query returns [SelectStatement ret] : s= select_node EOF ;
	public final SelectStatement query() throws RecognitionException {
		SelectStatement ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:425:5: (s= select_node EOF )
			// PhoenixSQL.g:425:9: s= select_node EOF
			{
			pushFollow(FOLLOW_select_node_in_query1480);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EOF,FOLLOW_EOF_in_query1482); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =s;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "query"



	// $ANTLR start "oneStatement"
	// PhoenixSQL.g:429:1: oneStatement returns [BindableStatement ret] : (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= create_cdc_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= drop_cdc_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) ;
	public final BindableStatement oneStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:431:5: ( (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= create_cdc_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= drop_cdc_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) )
			// PhoenixSQL.g:431:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= create_cdc_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= drop_cdc_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			{
			// PhoenixSQL.g:431:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= create_cdc_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= drop_cdc_node |s= alter_index_node |s= alter_table_node |s= show_node |s= show_create_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= grant_permission_node |s= revoke_permission_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			int alt2=35;
			switch ( input.LA(1) ) {
			case SELECT:
				{
				alt2=1;
				}
				break;
			case UPSERT:
				{
				alt2=2;
				}
				break;
			case DELETE:
				{
				int LA2_3 = input.LA(2);
				if ( (LA2_3==JAR) ) {
					alt2=25;
				}
				else if ( (LA2_3==FROM||LA2_3==ML_HINT) ) {
					alt2=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CREATE:
				{
				switch ( input.LA(2) ) {
				case SCHEMA:
					{
					alt2=5;
					}
					break;
				case VIEW:
					{
					alt2=6;
					}
					break;
				case CDC:
					{
					alt2=8;
					}
					break;
				case SEQUENCE:
					{
					alt2=27;
					}
					break;
				case IMMUTABLE:
				case TABLE:
					{
					alt2=4;
					}
					break;
				case INDEX:
				case LOCAL:
				case UNCOVERED:
					{
					alt2=7;
					}
					break;
				case FUNCTION:
				case OR:
				case TEMPORARY:
					{
					alt2=21;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case OPEN:
				{
				alt2=9;
				}
				break;
			case CLOSE:
				{
				alt2=10;
				}
				break;
			case FETCH:
				{
				alt2=11;
				}
				break;
			case DECLARE:
				{
				alt2=12;
				}
				break;
			case DROP:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=14;
					}
					break;
				case CDC:
					{
					alt2=15;
					}
					break;
				case FUNCTION:
					{
					alt2=22;
					}
					break;
				case SEQUENCE:
					{
					alt2=30;
					}
					break;
				case SCHEMA:
					{
					alt2=31;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=13;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ALTER:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=16;
					}
					break;
				case SESSION:
					{
					alt2=26;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=17;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case SHOW:
				{
				int LA2_11 = input.LA(2);
				if ( (LA2_11==SCHEMAS||LA2_11==TABLES) ) {
					alt2=18;
				}
				else if ( (LA2_11==CREATE) ) {
					alt2=19;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case TRACE:
				{
				alt2=20;
				}
				break;
			case ADD:
				{
				alt2=23;
				}
				break;
			case LIST:
				{
				alt2=24;
				}
				break;
			case GRANT:
				{
				alt2=28;
				}
				break;
			case REVOKE:
				{
				alt2=29;
				}
				break;
			case USE:
				{
				alt2=32;
				}
				break;
			case UPDATE:
				{
				alt2=33;
				}
				break;
			case EXECUTE:
				{
				alt2=34;
				}
				break;
			case EXPLAIN:
				{
				alt2=35;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// PhoenixSQL.g:431:9: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_oneStatement1514);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:432:7: s= upsert_node
					{
					pushFollow(FOLLOW_upsert_node_in_oneStatement1524);
					s=upsert_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:433:9: s= delete_node
					{
					pushFollow(FOLLOW_delete_node_in_oneStatement1536);
					s=delete_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 4 :
					// PhoenixSQL.g:434:9: s= create_table_node
					{
					pushFollow(FOLLOW_create_table_node_in_oneStatement1548);
					s=create_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:435:9: s= create_schema_node
					{
					pushFollow(FOLLOW_create_schema_node_in_oneStatement1560);
					s=create_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 6 :
					// PhoenixSQL.g:436:9: s= create_view_node
					{
					pushFollow(FOLLOW_create_view_node_in_oneStatement1572);
					s=create_view_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 7 :
					// PhoenixSQL.g:437:9: s= create_index_node
					{
					pushFollow(FOLLOW_create_index_node_in_oneStatement1584);
					s=create_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 8 :
					// PhoenixSQL.g:438:9: s= create_cdc_node
					{
					pushFollow(FOLLOW_create_cdc_node_in_oneStatement1596);
					s=create_cdc_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 9 :
					// PhoenixSQL.g:439:9: s= cursor_open_node
					{
					pushFollow(FOLLOW_cursor_open_node_in_oneStatement1608);
					s=cursor_open_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 10 :
					// PhoenixSQL.g:440:9: s= cursor_close_node
					{
					pushFollow(FOLLOW_cursor_close_node_in_oneStatement1620);
					s=cursor_close_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 11 :
					// PhoenixSQL.g:441:9: s= cursor_fetch_node
					{
					pushFollow(FOLLOW_cursor_fetch_node_in_oneStatement1632);
					s=cursor_fetch_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 12 :
					// PhoenixSQL.g:442:9: s= declare_cursor_node
					{
					pushFollow(FOLLOW_declare_cursor_node_in_oneStatement1644);
					s=declare_cursor_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 13 :
					// PhoenixSQL.g:443:9: s= drop_table_node
					{
					pushFollow(FOLLOW_drop_table_node_in_oneStatement1656);
					s=drop_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 14 :
					// PhoenixSQL.g:444:9: s= drop_index_node
					{
					pushFollow(FOLLOW_drop_index_node_in_oneStatement1668);
					s=drop_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 15 :
					// PhoenixSQL.g:445:9: s= drop_cdc_node
					{
					pushFollow(FOLLOW_drop_cdc_node_in_oneStatement1680);
					s=drop_cdc_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 16 :
					// PhoenixSQL.g:446:9: s= alter_index_node
					{
					pushFollow(FOLLOW_alter_index_node_in_oneStatement1692);
					s=alter_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 17 :
					// PhoenixSQL.g:447:9: s= alter_table_node
					{
					pushFollow(FOLLOW_alter_table_node_in_oneStatement1704);
					s=alter_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 18 :
					// PhoenixSQL.g:448:9: s= show_node
					{
					pushFollow(FOLLOW_show_node_in_oneStatement1716);
					s=show_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 19 :
					// PhoenixSQL.g:449:9: s= show_create_table_node
					{
					pushFollow(FOLLOW_show_create_table_node_in_oneStatement1728);
					s=show_create_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 20 :
					// PhoenixSQL.g:450:9: s= trace_node
					{
					pushFollow(FOLLOW_trace_node_in_oneStatement1740);
					s=trace_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 21 :
					// PhoenixSQL.g:451:9: s= create_function_node
					{
					pushFollow(FOLLOW_create_function_node_in_oneStatement1752);
					s=create_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 22 :
					// PhoenixSQL.g:452:9: s= drop_function_node
					{
					pushFollow(FOLLOW_drop_function_node_in_oneStatement1764);
					s=drop_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 23 :
					// PhoenixSQL.g:453:9: s= add_jars_node
					{
					pushFollow(FOLLOW_add_jars_node_in_oneStatement1776);
					s=add_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 24 :
					// PhoenixSQL.g:454:9: s= list_jars_node
					{
					pushFollow(FOLLOW_list_jars_node_in_oneStatement1788);
					s=list_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 25 :
					// PhoenixSQL.g:455:9: s= delete_jar_node
					{
					pushFollow(FOLLOW_delete_jar_node_in_oneStatement1800);
					s=delete_jar_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 26 :
					// PhoenixSQL.g:456:9: s= alter_session_node
					{
					pushFollow(FOLLOW_alter_session_node_in_oneStatement1812);
					s=alter_session_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 27 :
					// PhoenixSQL.g:457:7: s= create_sequence_node
					{
					pushFollow(FOLLOW_create_sequence_node_in_oneStatement1822);
					s=create_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 28 :
					// PhoenixSQL.g:458:9: s= grant_permission_node
					{
					pushFollow(FOLLOW_grant_permission_node_in_oneStatement1834);
					s=grant_permission_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 29 :
					// PhoenixSQL.g:459:9: s= revoke_permission_node
					{
					pushFollow(FOLLOW_revoke_permission_node_in_oneStatement1846);
					s=revoke_permission_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 30 :
					// PhoenixSQL.g:460:7: s= drop_sequence_node
					{
					pushFollow(FOLLOW_drop_sequence_node_in_oneStatement1856);
					s=drop_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 31 :
					// PhoenixSQL.g:461:7: s= drop_schema_node
					{
					pushFollow(FOLLOW_drop_schema_node_in_oneStatement1866);
					s=drop_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 32 :
					// PhoenixSQL.g:462:7: s= use_schema_node
					{
					pushFollow(FOLLOW_use_schema_node_in_oneStatement1876);
					s=use_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 33 :
					// PhoenixSQL.g:463:9: s= update_statistics_node
					{
					pushFollow(FOLLOW_update_statistics_node_in_oneStatement1888);
					s=update_statistics_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 34 :
					// PhoenixSQL.g:464:9: s= execute_upgrade_node
					{
					pushFollow(FOLLOW_execute_upgrade_node_in_oneStatement1900);
					s=execute_upgrade_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 35 :
					// PhoenixSQL.g:465:9: s= explain_node
					{
					pushFollow(FOLLOW_explain_node_in_oneStatement1912);
					s=explain_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = s; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "oneStatement"



	// $ANTLR start "explain_node"
	// PhoenixSQL.g:469:1: explain_node returns [BindableStatement ret] : EXPLAIN (w= WITH )? (r= REGIONS )? q= oneStatement ;
	public final BindableStatement explain_node() throws RecognitionException {
		BindableStatement ret = null;


		Token w=null;
		Token r=null;
		BindableStatement q =null;

		try {
			// PhoenixSQL.g:470:5: ( EXPLAIN (w= WITH )? (r= REGIONS )? q= oneStatement )
			// PhoenixSQL.g:470:9: EXPLAIN (w= WITH )? (r= REGIONS )? q= oneStatement
			{
			match(input,EXPLAIN,FOLLOW_EXPLAIN_in_explain_node1945); if (state.failed) return ret;
			// PhoenixSQL.g:470:17: (w= WITH )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==WITH) ) {
				alt3=1;
			}
			switch (alt3) {
				case 1 :
					// PhoenixSQL.g:470:18: w= WITH
					{
					w=(Token)match(input,WITH,FOLLOW_WITH_in_explain_node1950); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:470:27: (r= REGIONS )?
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==REGIONS) ) {
				alt4=1;
			}
			switch (alt4) {
				case 1 :
					// PhoenixSQL.g:470:28: r= REGIONS
					{
					r=(Token)match(input,REGIONS,FOLLOW_REGIONS_in_explain_node1957); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_oneStatement_in_explain_node1963);
			q=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			        if ((w==null && r!=null) || (w!=null && r==null)) {
			            throw new RuntimeException("Valid usage: EXPLAIN {query} OR EXPLAIN WITH REGIONS {query}");
			        }
			        ret = (w==null && r==null) ? factory.explain(q, ExplainType.DEFAULT)
			         : factory.explain(q, ExplainType.WITH_REGIONS);
			     }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "explain_node"



	// $ANTLR start "create_table_node"
	// PhoenixSQL.g:481:1: create_table_node returns [CreateTableStatement ret] : CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (noverify= NOVERIFY )? (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ( COLUMN_QUALIFIER_COUNTER LPAREN cqc= initializiation_list RPAREN )? ;
	public final CreateTableStatement create_table_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token im=null;
		Token ex=null;
		Token noverify=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> s =null;
		Map<String, Integer> cqc =null;

		try {
			// PhoenixSQL.g:482:5: ( CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (noverify= NOVERIFY )? (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ( COLUMN_QUALIFIER_COUNTER LPAREN cqc= initializiation_list RPAREN )? )
			// PhoenixSQL.g:482:9: CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (noverify= NOVERIFY )? (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ( COLUMN_QUALIFIER_COUNTER LPAREN cqc= initializiation_list RPAREN )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_table_node1994); if (state.failed) return ret;
			// PhoenixSQL.g:482:16: (im= IMMUTABLE )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==IMMUTABLE) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// PhoenixSQL.g:482:17: im= IMMUTABLE
					{
					im=(Token)match(input,IMMUTABLE,FOLLOW_IMMUTABLE_in_create_table_node1999); if (state.failed) return ret;
					}
					break;

			}

			match(input,TABLE,FOLLOW_TABLE_in_create_table_node2003); if (state.failed) return ret;
			// PhoenixSQL.g:482:38: ( IF NOT ex= EXISTS )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==IF) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// PhoenixSQL.g:482:39: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_table_node2006); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_table_node2008); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_table_node2012); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_table_node2018);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:483:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )
			// PhoenixSQL.g:483:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_table_node2030); if (state.failed) return ret;
			pushFollow(FOLLOW_column_defs_in_create_table_node2034);
			c=column_defs();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:483:31: (pk= pk_constraint )?
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==COMMA||LA7_0==CONSTRAINT) ) {
				alt7=1;
			}
			switch (alt7) {
				case 1 :
					// PhoenixSQL.g:483:32: pk= pk_constraint
					{
					pushFollow(FOLLOW_pk_constraint_in_create_table_node2039);
					pk=pk_constraint();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,RPAREN,FOLLOW_RPAREN_in_create_table_node2043); if (state.failed) return ret;
			}

			// PhoenixSQL.g:484:9: (noverify= NOVERIFY )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==NOVERIFY) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// PhoenixSQL.g:484:10: noverify= NOVERIFY
					{
					noverify=(Token)match(input,NOVERIFY,FOLLOW_NOVERIFY_in_create_table_node2057); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:485:9: (p= fam_properties )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==NAME) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// PhoenixSQL.g:485:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_table_node2072);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:486:9: ( SPLIT ON s= value_expression_list )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==SPLIT) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// PhoenixSQL.g:486:10: SPLIT ON s= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_table_node2085); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_table_node2087); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_table_node2091);
					s=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:487:9: ( COLUMN_QUALIFIER_COUNTER LPAREN cqc= initializiation_list RPAREN )?
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==COLUMN_QUALIFIER_COUNTER) ) {
				alt11=1;
			}
			switch (alt11) {
				case 1 :
					// PhoenixSQL.g:487:10: COLUMN_QUALIFIER_COUNTER LPAREN cqc= initializiation_list RPAREN
					{
					match(input,COLUMN_QUALIFIER_COUNTER,FOLLOW_COLUMN_QUALIFIER_COUNTER_in_create_table_node2104); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_create_table_node2106); if (state.failed) return ret;
					pushFollow(FOLLOW_initializiation_list_in_create_table_node2110);
					cqc=initializiation_list();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_create_table_node2112); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createTable(t, p, c, pk, s, PTableType.TABLE, ex!=null, null, null, getBindCount(), im!=null ? true : null, cqc, noverify!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_table_node"



	// $ANTLR start "create_schema_node"
	// PhoenixSQL.g:492:1: create_schema_node returns [CreateSchemaStatement ret] : CREATE SCHEMA ( IF NOT ex= EXISTS )? s= identifier ;
	public final CreateSchemaStatement create_schema_node() throws RecognitionException {
		CreateSchemaStatement ret = null;


		Token ex=null;
		String s =null;

		try {
			// PhoenixSQL.g:493:5: ( CREATE SCHEMA ( IF NOT ex= EXISTS )? s= identifier )
			// PhoenixSQL.g:493:9: CREATE SCHEMA ( IF NOT ex= EXISTS )? s= identifier
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_schema_node2151); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_create_schema_node2153); if (state.failed) return ret;
			// PhoenixSQL.g:493:23: ( IF NOT ex= EXISTS )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==IF) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// PhoenixSQL.g:493:24: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_schema_node2156); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_schema_node2158); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_schema_node2162); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_create_schema_node2168);
			s=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.createSchema(s, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_schema_node"



	// $ANTLR start "grant_permission_node"
	// PhoenixSQL.g:498:1: grant_permission_node returns [ChangePermsStatement ret] : GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal ;
	public final ChangePermsStatement grant_permission_node() throws RecognitionException {
		ChangePermsStatement ret = null;


		Token s=null;
		Token g=null;
		LiteralParseNode p =null;
		TableName table =null;
		String schema =null;
		LiteralParseNode ug =null;

		try {
			// PhoenixSQL.g:499:5: ( GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal )
			// PhoenixSQL.g:499:9: GRANT p= literal ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? TO (g= GROUP )? ug= literal
			{
			match(input,GRANT,FOLLOW_GRANT_in_grant_permission_node2202); if (state.failed) return ret;
			pushFollow(FOLLOW_literal_in_grant_permission_node2206);
			p=literal();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:499:25: ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )?
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==ON) ) {
				alt15=1;
			}
			switch (alt15) {
				case 1 :
					// PhoenixSQL.g:499:26: ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					{
					match(input,ON,FOLLOW_ON_in_grant_permission_node2209); if (state.failed) return ret;
					// PhoenixSQL.g:499:29: ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					int alt14=2;
					int LA14_0 = input.LA(1);
					if ( (LA14_0==NAME||LA14_0==TABLE) ) {
						alt14=1;
					}
					else if ( (LA14_0==SCHEMA) ) {
						alt14=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 14, 0, input);
						throw nvae;
					}

					switch (alt14) {
						case 1 :
							// PhoenixSQL.g:499:30: ( TABLE )? table= table_name
							{
							// PhoenixSQL.g:499:30: ( TABLE )?
							int alt13=2;
							int LA13_0 = input.LA(1);
							if ( (LA13_0==TABLE) ) {
								alt13=1;
							}
							switch (alt13) {
								case 1 :
									// PhoenixSQL.g:499:31: TABLE
									{
									match(input,TABLE,FOLLOW_TABLE_in_grant_permission_node2213); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_table_name_in_grant_permission_node2219);
							table=table_name();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:499:58: s= SCHEMA schema= identifier
							{
							s=(Token)match(input,SCHEMA,FOLLOW_SCHEMA_in_grant_permission_node2225); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_grant_permission_node2229);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			match(input,TO,FOLLOW_TO_in_grant_permission_node2234); if (state.failed) return ret;
			// PhoenixSQL.g:499:91: (g= GROUP )?
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==GROUP) ) {
				alt16=1;
			}
			switch (alt16) {
				case 1 :
					// PhoenixSQL.g:499:92: g= GROUP
					{
					g=(Token)match(input,GROUP,FOLLOW_GROUP_in_grant_permission_node2239); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_literal_in_grant_permission_node2245);
			ug=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            String permsString = SchemaUtil.normalizeLiteral(p);
			            if (permsString != null && permsString.length() > 5) {
			                throw new RuntimeException("Permissions String length should be less than 5 characters");
			            }
			            ret = factory.changePermsStatement(permsString, s!=null, table, schema, g!=null, ug, Boolean.TRUE);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "grant_permission_node"



	// $ANTLR start "revoke_permission_node"
	// PhoenixSQL.g:510:1: revoke_permission_node returns [ChangePermsStatement ret] : REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal ;
	public final ChangePermsStatement revoke_permission_node() throws RecognitionException {
		ChangePermsStatement ret = null;


		Token s=null;
		Token g=null;
		LiteralParseNode p =null;
		TableName table =null;
		String schema =null;
		LiteralParseNode ug =null;

		try {
			// PhoenixSQL.g:511:5: ( REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal )
			// PhoenixSQL.g:511:9: REVOKE (p= literal )? ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )? FROM (g= GROUP )? ug= literal
			{
			match(input,REVOKE,FOLLOW_REVOKE_in_revoke_permission_node2279); if (state.failed) return ret;
			// PhoenixSQL.g:511:16: (p= literal )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==BIN_LITERAL||LA17_0==DECIMAL||LA17_0==DOUBLE||LA17_0==FALSE||LA17_0==HEX_LITERAL||LA17_0==NAME||LA17_0==NULL||LA17_0==NUMBER||LA17_0==STRING_LITERAL||LA17_0==TRUE) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// PhoenixSQL.g:511:17: p= literal
					{
					pushFollow(FOLLOW_literal_in_revoke_permission_node2284);
					p=literal();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:511:29: ( ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier ) )?
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==ON) ) {
				alt20=1;
			}
			switch (alt20) {
				case 1 :
					// PhoenixSQL.g:511:30: ON ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					{
					match(input,ON,FOLLOW_ON_in_revoke_permission_node2289); if (state.failed) return ret;
					// PhoenixSQL.g:511:33: ( ( TABLE )? table= table_name |s= SCHEMA schema= identifier )
					int alt19=2;
					int LA19_0 = input.LA(1);
					if ( (LA19_0==NAME||LA19_0==TABLE) ) {
						alt19=1;
					}
					else if ( (LA19_0==SCHEMA) ) {
						alt19=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 19, 0, input);
						throw nvae;
					}

					switch (alt19) {
						case 1 :
							// PhoenixSQL.g:511:34: ( TABLE )? table= table_name
							{
							// PhoenixSQL.g:511:34: ( TABLE )?
							int alt18=2;
							int LA18_0 = input.LA(1);
							if ( (LA18_0==TABLE) ) {
								alt18=1;
							}
							switch (alt18) {
								case 1 :
									// PhoenixSQL.g:511:35: TABLE
									{
									match(input,TABLE,FOLLOW_TABLE_in_revoke_permission_node2293); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_table_name_in_revoke_permission_node2299);
							table=table_name();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:511:62: s= SCHEMA schema= identifier
							{
							s=(Token)match(input,SCHEMA,FOLLOW_SCHEMA_in_revoke_permission_node2305); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_revoke_permission_node2309);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_revoke_permission_node2314); if (state.failed) return ret;
			// PhoenixSQL.g:511:97: (g= GROUP )?
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==GROUP) ) {
				alt21=1;
			}
			switch (alt21) {
				case 1 :
					// PhoenixSQL.g:511:98: g= GROUP
					{
					g=(Token)match(input,GROUP,FOLLOW_GROUP_in_revoke_permission_node2319); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_literal_in_revoke_permission_node2325);
			ug=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            String permsString = SchemaUtil.normalizeLiteral(p);
			            if (permsString != null && permsString.length() > 5) {
			                throw new RuntimeException("Permissions String length should be less than 5 characters");
			            }
			            ret = factory.changePermsStatement(permsString, s!=null, table, schema, g!=null, ug, Boolean.FALSE);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "revoke_permission_node"



	// $ANTLR start "show_node"
	// PhoenixSQL.g:522:1: show_node returns [ShowStatement ret] : ( SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )? | SHOW SCHEMAS ( LIKE pattern= string_literal )? );
	public final ShowStatement show_node() throws RecognitionException {
		ShowStatement ret = null;


		String schema =null;
		String pattern =null;

		try {
			// PhoenixSQL.g:523:5: ( SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )? | SHOW SCHEMAS ( LIKE pattern= string_literal )? )
			int alt25=2;
			int LA25_0 = input.LA(1);
			if ( (LA25_0==SHOW) ) {
				int LA25_1 = input.LA(2);
				if ( (LA25_1==TABLES) ) {
					alt25=1;
				}
				else if ( (LA25_1==SCHEMAS) ) {
					alt25=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 25, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 25, 0, input);
				throw nvae;
			}

			switch (alt25) {
				case 1 :
					// PhoenixSQL.g:523:9: SHOW TABLES ( IN schema= identifier )? ( LIKE pattern= string_literal )?
					{
					match(input,SHOW,FOLLOW_SHOW_in_show_node2359); if (state.failed) return ret;
					match(input,TABLES,FOLLOW_TABLES_in_show_node2361); if (state.failed) return ret;
					// PhoenixSQL.g:523:21: ( IN schema= identifier )?
					int alt22=2;
					int LA22_0 = input.LA(1);
					if ( (LA22_0==IN) ) {
						alt22=1;
					}
					switch (alt22) {
						case 1 :
							// PhoenixSQL.g:523:22: IN schema= identifier
							{
							match(input,IN,FOLLOW_IN_in_show_node2364); if (state.failed) return ret;
							pushFollow(FOLLOW_identifier_in_show_node2368);
							schema=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:523:45: ( LIKE pattern= string_literal )?
					int alt23=2;
					int LA23_0 = input.LA(1);
					if ( (LA23_0==LIKE) ) {
						alt23=1;
					}
					switch (alt23) {
						case 1 :
							// PhoenixSQL.g:523:46: LIKE pattern= string_literal
							{
							match(input,LIKE,FOLLOW_LIKE_in_show_node2373); if (state.failed) return ret;
							pushFollow(FOLLOW_string_literal_in_show_node2377);
							pattern=string_literal();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.showTablesStatement(schema, pattern); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:524:9: SHOW SCHEMAS ( LIKE pattern= string_literal )?
					{
					match(input,SHOW,FOLLOW_SHOW_in_show_node2391); if (state.failed) return ret;
					match(input,SCHEMAS,FOLLOW_SCHEMAS_in_show_node2393); if (state.failed) return ret;
					// PhoenixSQL.g:524:22: ( LIKE pattern= string_literal )?
					int alt24=2;
					int LA24_0 = input.LA(1);
					if ( (LA24_0==LIKE) ) {
						alt24=1;
					}
					switch (alt24) {
						case 1 :
							// PhoenixSQL.g:524:23: LIKE pattern= string_literal
							{
							match(input,LIKE,FOLLOW_LIKE_in_show_node2396); if (state.failed) return ret;
							pushFollow(FOLLOW_string_literal_in_show_node2400);
							pattern=string_literal();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.showSchemasStatement(pattern); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "show_node"



	// $ANTLR start "show_create_table_node"
	// PhoenixSQL.g:528:1: show_create_table_node returns [ShowCreateTable ret] : SHOW CREATE TABLE tablename= from_table_name ;
	public final ShowCreateTable show_create_table_node() throws RecognitionException {
		ShowCreateTable ret = null;


		TableName tablename =null;

		try {
			// PhoenixSQL.g:529:5: ( SHOW CREATE TABLE tablename= from_table_name )
			// PhoenixSQL.g:529:9: SHOW CREATE TABLE tablename= from_table_name
			{
			match(input,SHOW,FOLLOW_SHOW_in_show_create_table_node2428); if (state.failed) return ret;
			match(input,CREATE,FOLLOW_CREATE_in_show_create_table_node2430); if (state.failed) return ret;
			match(input,TABLE,FOLLOW_TABLE_in_show_create_table_node2432); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_show_create_table_node2436);
			tablename=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.showCreateTable(tablename); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "show_create_table_node"



	// $ANTLR start "create_view_node"
	// PhoenixSQL.g:533:1: create_view_node returns [CreateTableStatement ret] : CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? ;
	public final CreateTableStatement create_view_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		TableName bt =null;
		ParseNode w =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:534:5: ( CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? )
			// PhoenixSQL.g:534:9: CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_view_node2462); if (state.failed) return ret;
			match(input,VIEW,FOLLOW_VIEW_in_create_view_node2464); if (state.failed) return ret;
			// PhoenixSQL.g:534:21: ( IF NOT ex= EXISTS )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==IF) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// PhoenixSQL.g:534:22: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_view_node2467); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_view_node2469); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_view_node2473); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_view_node2479);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:535:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )?
			int alt28=2;
			int LA28_0 = input.LA(1);
			if ( (LA28_0==LPAREN) ) {
				alt28=1;
			}
			switch (alt28) {
				case 1 :
					// PhoenixSQL.g:535:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_view_node2491); if (state.failed) return ret;
					pushFollow(FOLLOW_column_defs_in_create_view_node2495);
					c=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:535:31: (pk= pk_constraint )?
					int alt27=2;
					int LA27_0 = input.LA(1);
					if ( (LA27_0==COMMA||LA27_0==CONSTRAINT) ) {
						alt27=1;
					}
					switch (alt27) {
						case 1 :
							// PhoenixSQL.g:535:32: pk= pk_constraint
							{
							pushFollow(FOLLOW_pk_constraint_in_create_view_node2500);
							pk=pk_constraint();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_create_view_node2504); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:536:9: ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )?
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==AS) ) {
				alt30=1;
			}
			switch (alt30) {
				case 1 :
					// PhoenixSQL.g:536:11: AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )?
					{
					match(input,AS,FOLLOW_AS_in_create_view_node2518); if (state.failed) return ret;
					match(input,SELECT,FOLLOW_SELECT_in_create_view_node2520); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_create_view_node2522); if (state.failed) return ret;
					match(input,FROM,FOLLOW_FROM_in_create_view_node2534); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_create_view_node2538);
					bt=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:538:11: ( WHERE w= expression )?
					int alt29=2;
					int LA29_0 = input.LA(1);
					if ( (LA29_0==WHERE) ) {
						alt29=1;
					}
					switch (alt29) {
						case 1 :
							// PhoenixSQL.g:538:12: WHERE w= expression
							{
							match(input,WHERE,FOLLOW_WHERE_in_create_view_node2551); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_create_view_node2555);
							w=expression();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			// PhoenixSQL.g:539:9: (p= fam_properties )?
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==NAME) ) {
				alt31=1;
			}
			switch (alt31) {
				case 1 :
					// PhoenixSQL.g:539:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_view_node2573);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createTable(t, p, c, pk, null, PTableType.VIEW, ex!=null, bt==null ? t : bt, w, getBindCount(), null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_view_node"



	// $ANTLR start "create_index_node"
	// PhoenixSQL.g:544:1: create_index_node returns [CreateIndexStatement ret] : CREATE (u= UNCOVERED )? (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) (in= INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? ( WHERE where= expression )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? ;
	public final CreateIndexStatement create_index_node() throws RecognitionException {
		CreateIndexStatement ret = null;


		Token u=null;
		Token l=null;
		Token ex=null;
		Token in=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		IndexKeyConstraint ik =null;
		List<ColumnName> icrefs =null;
		ParseNode where =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> v =null;

		try {
			// PhoenixSQL.g:545:5: ( CREATE (u= UNCOVERED )? (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) (in= INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? ( WHERE where= expression )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? )
			// PhoenixSQL.g:545:9: CREATE (u= UNCOVERED )? (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) (in= INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? ( WHERE where= expression )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_index_node2609); if (state.failed) return ret;
			// PhoenixSQL.g:545:17: (u= UNCOVERED )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==UNCOVERED) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// PhoenixSQL.g:545:17: u= UNCOVERED
					{
					u=(Token)match(input,UNCOVERED,FOLLOW_UNCOVERED_in_create_index_node2613); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:545:30: (l= LOCAL )?
			int alt33=2;
			int LA33_0 = input.LA(1);
			if ( (LA33_0==LOCAL) ) {
				alt33=1;
			}
			switch (alt33) {
				case 1 :
					// PhoenixSQL.g:545:30: l= LOCAL
					{
					l=(Token)match(input,LOCAL,FOLLOW_LOCAL_in_create_index_node2618); if (state.failed) return ret;
					}
					break;

			}

			match(input,INDEX,FOLLOW_INDEX_in_create_index_node2621); if (state.failed) return ret;
			// PhoenixSQL.g:545:44: ( IF NOT ex= EXISTS )?
			int alt34=2;
			int LA34_0 = input.LA(1);
			if ( (LA34_0==IF) ) {
				alt34=1;
			}
			switch (alt34) {
				case 1 :
					// PhoenixSQL.g:545:45: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_index_node2624); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_index_node2626); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_index_node2630); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_create_index_node2636);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_create_index_node2638); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_create_index_node2642);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:546:9: ( LPAREN ik= ik_constraint RPAREN )
			// PhoenixSQL.g:546:10: LPAREN ik= ik_constraint RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2653); if (state.failed) return ret;
			pushFollow(FOLLOW_ik_constraint_in_create_index_node2657);
			ik=ik_constraint();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2659); if (state.failed) return ret;
			}

			// PhoenixSQL.g:547:9: (in= INCLUDE ( LPAREN icrefs= column_names RPAREN ) )?
			int alt35=2;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==INCLUDE) ) {
				alt35=1;
			}
			switch (alt35) {
				case 1 :
					// PhoenixSQL.g:547:10: in= INCLUDE ( LPAREN icrefs= column_names RPAREN )
					{
					in=(Token)match(input,INCLUDE,FOLLOW_INCLUDE_in_create_index_node2673); if (state.failed) return ret;
					// PhoenixSQL.g:547:21: ( LPAREN icrefs= column_names RPAREN )
					// PhoenixSQL.g:547:22: LPAREN icrefs= column_names RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2676); if (state.failed) return ret;
					pushFollow(FOLLOW_column_names_in_create_index_node2680);
					icrefs=column_names();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2682); if (state.failed) return ret;
					}

					}
					break;

			}

			// PhoenixSQL.g:548:9: ( WHERE where= expression )?
			int alt36=2;
			int LA36_0 = input.LA(1);
			if ( (LA36_0==WHERE) ) {
				alt36=1;
			}
			switch (alt36) {
				case 1 :
					// PhoenixSQL.g:548:10: WHERE where= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_create_index_node2696); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_create_index_node2700);
					where=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:549:9: (async= ASYNC )?
			int alt37=2;
			int LA37_0 = input.LA(1);
			if ( (LA37_0==ASYNC) ) {
				alt37=1;
			}
			switch (alt37) {
				case 1 :
					// PhoenixSQL.g:549:10: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_create_index_node2715); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:550:9: (p= fam_properties )?
			int alt38=2;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==NAME) ) {
				alt38=1;
			}
			switch (alt38) {
				case 1 :
					// PhoenixSQL.g:550:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_index_node2730);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:551:9: ( SPLIT ON v= value_expression_list )?
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==SPLIT) ) {
				alt39=1;
			}
			switch (alt39) {
				case 1 :
					// PhoenixSQL.g:551:10: SPLIT ON v= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_index_node2743); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_index_node2745); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_index_node2749);
					v=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {
			            if (u !=null && in != null) {
			                throw new RuntimeException("UNCOVERED indexes cannot have the INCLUDE clause");
			            }
			            if (l !=null && u != null) {
			                throw new RuntimeException("UNCOVERED cannot be used with LOCAL");
			            }
			            if (l !=null && where != null) {
			                throw new RuntimeException("Partial local indexes are not supported");
			            }
			            ret = factory.createIndex(i, factory.namedTable(null,t), ik, icrefs, v, p, ex!=null,
			                    l==null ? (u==null ? IndexType.getDefault() : IndexType.UNCOVERED_GLOBAL) :
			                    IndexType.LOCAL, async != null, getBindCount(), new HashMap<String,
			                    UDFParseNode>(udfParseNodes), where);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_index_node"



	// $ANTLR start "create_cdc_node"
	// PhoenixSQL.g:569:1: create_cdc_node returns [CreateCDCStatement ret] : CREATE CDC ( IF NOT ex= EXISTS )? o= cdc_name ON t= from_table_name ( INCLUDE LPAREN v= cdc_change_scopes RPAREN )? (p= fam_properties )? ;
	public final CreateCDCStatement create_cdc_node() throws RecognitionException {
		CreateCDCStatement ret = null;


		Token ex=null;
		NamedNode o =null;
		TableName t =null;
		Set<CDCChangeScope> v =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:570:5: ( CREATE CDC ( IF NOT ex= EXISTS )? o= cdc_name ON t= from_table_name ( INCLUDE LPAREN v= cdc_change_scopes RPAREN )? (p= fam_properties )? )
			// PhoenixSQL.g:570:9: CREATE CDC ( IF NOT ex= EXISTS )? o= cdc_name ON t= from_table_name ( INCLUDE LPAREN v= cdc_change_scopes RPAREN )? (p= fam_properties )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_cdc_node2784); if (state.failed) return ret;
			match(input,CDC,FOLLOW_CDC_in_create_cdc_node2786); if (state.failed) return ret;
			// PhoenixSQL.g:570:20: ( IF NOT ex= EXISTS )?
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==IF) ) {
				alt40=1;
			}
			switch (alt40) {
				case 1 :
					// PhoenixSQL.g:570:21: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_cdc_node2789); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_cdc_node2791); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_cdc_node2795); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_cdc_name_in_create_cdc_node2801);
			o=cdc_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_create_cdc_node2803); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_create_cdc_node2807);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:571:9: ( INCLUDE LPAREN v= cdc_change_scopes RPAREN )?
			int alt41=2;
			int LA41_0 = input.LA(1);
			if ( (LA41_0==INCLUDE) ) {
				alt41=1;
			}
			switch (alt41) {
				case 1 :
					// PhoenixSQL.g:571:10: INCLUDE LPAREN v= cdc_change_scopes RPAREN
					{
					match(input,INCLUDE,FOLLOW_INCLUDE_in_create_cdc_node2818); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_create_cdc_node2820); if (state.failed) return ret;
					pushFollow(FOLLOW_cdc_change_scopes_in_create_cdc_node2824);
					v=cdc_change_scopes();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_create_cdc_node2826); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:572:9: (p= fam_properties )?
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==NAME) ) {
				alt42=1;
			}
			switch (alt42) {
				case 1 :
					// PhoenixSQL.g:572:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_cdc_node2841);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {
			            ret = factory.createCDC(o, t, v, p, ex != null, getBindCount());
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_cdc_node"



	// $ANTLR start "cdc_name"
	// PhoenixSQL.g:578:1: cdc_name returns [NamedNode ret] : name= identifier ;
	public final NamedNode cdc_name() throws RecognitionException {
		NamedNode ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:579:5: (name= identifier )
			// PhoenixSQL.g:579:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_cdc_name2878);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.cdcName(name); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cdc_name"



	// $ANTLR start "cdc_change_scopes"
	// PhoenixSQL.g:582:1: cdc_change_scopes returns [Set<CDCChangeScope> ret] : v= cdc_change_scope ( COMMA v= cdc_change_scope )* ;
	public final Set<CDCChangeScope> cdc_change_scopes() throws RecognitionException {
		Set<CDCChangeScope> ret = null;


		CDCChangeScope v =null;

		 ret = new HashSet<>(); 
		try {
			// PhoenixSQL.g:584:5: (v= cdc_change_scope ( COMMA v= cdc_change_scope )* )
			// PhoenixSQL.g:584:9: v= cdc_change_scope ( COMMA v= cdc_change_scope )*
			{
			pushFollow(FOLLOW_cdc_change_scope_in_cdc_change_scopes2910);
			v=cdc_change_scope();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(v); }
			// PhoenixSQL.g:584:45: ( COMMA v= cdc_change_scope )*
			loop43:
			while (true) {
				int alt43=2;
				int LA43_0 = input.LA(1);
				if ( (LA43_0==COMMA) ) {
					alt43=1;
				}

				switch (alt43) {
				case 1 :
					// PhoenixSQL.g:584:47: COMMA v= cdc_change_scope
					{
					match(input,COMMA,FOLLOW_COMMA_in_cdc_change_scopes2916); if (state.failed) return ret;
					pushFollow(FOLLOW_cdc_change_scope_in_cdc_change_scopes2920);
					v=cdc_change_scope();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret.add(v); }
					}
					break;

				default :
					break loop43;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cdc_change_scopes"



	// $ANTLR start "cdc_change_scope"
	// PhoenixSQL.g:587:1: cdc_change_scope returns [CDCChangeScope ret] : v= ( PRE | POST | CHANGE ) ;
	public final CDCChangeScope cdc_change_scope() throws RecognitionException {
		CDCChangeScope ret = null;


		Token v=null;

		try {
			// PhoenixSQL.g:588:5: (v= ( PRE | POST | CHANGE ) )
			// PhoenixSQL.g:588:9: v= ( PRE | POST | CHANGE )
			{
			v=input.LT(1);
			if ( input.LA(1)==CHANGE||(input.LA(1) >= POST && input.LA(1) <= PRE) ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			if ( state.backtracking==0 ) {
			            ret = CDCChangeScope.valueOf(v.getText().toUpperCase());
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cdc_change_scope"



	// $ANTLR start "create_sequence_node"
	// PhoenixSQL.g:595:1: create_sequence_node returns [CreateSequenceStatement ret] : CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? ;
	public final CreateSequenceStatement create_sequence_node() throws RecognitionException {
		CreateSequenceStatement ret = null;


		Token ex=null;
		Token cyc=null;
		TableName t =null;
		ParseNode s =null;
		ParseNode i =null;
		ParseNode min =null;
		ParseNode max =null;
		ParseNode c =null;

		try {
			// PhoenixSQL.g:596:5: ( CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? )
			// PhoenixSQL.g:596:9: CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_sequence_node2994); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_create_sequence_node2996); if (state.failed) return ret;
			// PhoenixSQL.g:596:26: ( IF NOT ex= EXISTS )?
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==IF) ) {
				alt44=1;
			}
			switch (alt44) {
				case 1 :
					// PhoenixSQL.g:596:27: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_sequence_node3000); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_sequence_node3002); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_sequence_node3006); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_sequence_node3012);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:597:9: ( START ( WITH )? s= value_expression )?
			int alt46=2;
			int LA46_0 = input.LA(1);
			if ( (LA46_0==START) ) {
				alt46=1;
			}
			switch (alt46) {
				case 1 :
					// PhoenixSQL.g:597:10: START ( WITH )? s= value_expression
					{
					match(input,START,FOLLOW_START_in_create_sequence_node3023); if (state.failed) return ret;
					// PhoenixSQL.g:597:16: ( WITH )?
					int alt45=2;
					int LA45_0 = input.LA(1);
					if ( (LA45_0==WITH) ) {
						alt45=1;
					}
					switch (alt45) {
						case 1 :
							// PhoenixSQL.g:597:16: WITH
							{
							match(input,WITH,FOLLOW_WITH_in_create_sequence_node3025); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node3030);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:598:9: ( INCREMENT ( BY )? i= value_expression )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==INCREMENT) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// PhoenixSQL.g:598:10: INCREMENT ( BY )? i= value_expression
					{
					match(input,INCREMENT,FOLLOW_INCREMENT_in_create_sequence_node3043); if (state.failed) return ret;
					// PhoenixSQL.g:598:20: ( BY )?
					int alt47=2;
					int LA47_0 = input.LA(1);
					if ( (LA47_0==BY) ) {
						alt47=1;
					}
					switch (alt47) {
						case 1 :
							// PhoenixSQL.g:598:20: BY
							{
							match(input,BY,FOLLOW_BY_in_create_sequence_node3045); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node3050);
					i=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:599:9: ( MINVALUE min= value_expression )?
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==MINVALUE) ) {
				alt49=1;
			}
			switch (alt49) {
				case 1 :
					// PhoenixSQL.g:599:10: MINVALUE min= value_expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_create_sequence_node3063); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node3067);
					min=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:600:9: ( MAXVALUE max= value_expression )?
			int alt50=2;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==MAXVALUE) ) {
				alt50=1;
			}
			switch (alt50) {
				case 1 :
					// PhoenixSQL.g:600:10: MAXVALUE max= value_expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_create_sequence_node3080); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node3084);
					max=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:601:9: (cyc= CYCLE )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==CYCLE) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// PhoenixSQL.g:601:10: cyc= CYCLE
					{
					cyc=(Token)match(input,CYCLE,FOLLOW_CYCLE_in_create_sequence_node3099); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:602:9: ( CACHE c= int_literal_or_bind )?
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==CACHE) ) {
				alt52=1;
			}
			switch (alt52) {
				case 1 :
					// PhoenixSQL.g:602:10: CACHE c= int_literal_or_bind
					{
					match(input,CACHE,FOLLOW_CACHE_in_create_sequence_node3113); if (state.failed) return ret;
					pushFollow(FOLLOW_int_literal_or_bind_in_create_sequence_node3117);
					c=int_literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createSequence(t, s, i, c, min, max, cyc!=null, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_sequence_node"



	// $ANTLR start "int_literal_or_bind"
	// PhoenixSQL.g:606:1: int_literal_or_bind returns [ParseNode ret] : (n= int_or_long_literal |b= bind_expression );
	public final ParseNode int_literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode n =null;
		BindParseNode b =null;

		try {
			// PhoenixSQL.g:607:5: (n= int_or_long_literal |b= bind_expression )
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==NUMBER) ) {
				alt53=1;
			}
			else if ( (LA53_0==BIND_NAME||LA53_0==QUESTION) ) {
				alt53=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 53, 0, input);
				throw nvae;
			}

			switch (alt53) {
				case 1 :
					// PhoenixSQL.g:607:7: n= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_int_literal_or_bind3148);
					n=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:608:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_int_literal_or_bind3160);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = b; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_literal_or_bind"



	// $ANTLR start "string_literal"
	// PhoenixSQL.g:612:1: string_literal returns [String ret] : s= STRING_LITERAL ;
	public final String string_literal() throws RecognitionException {
		String ret = null;


		Token s=null;

		try {
			// PhoenixSQL.g:613:5: (s= STRING_LITERAL )
			// PhoenixSQL.g:613:9: s= STRING_LITERAL
			{
			s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_string_literal3188); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = SchemaUtil.normalizeLiteral(factory.literal(s.getText())); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "string_literal"



	// $ANTLR start "drop_sequence_node"
	// PhoenixSQL.g:617:1: drop_sequence_node returns [DropSequenceStatement ret] : DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name ;
	public final DropSequenceStatement drop_sequence_node() throws RecognitionException {
		DropSequenceStatement ret = null;


		Token ex=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:618:5: ( DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name )
			// PhoenixSQL.g:618:9: DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_sequence_node3214); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_drop_sequence_node3216); if (state.failed) return ret;
			// PhoenixSQL.g:618:24: ( IF ex= EXISTS )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==IF) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// PhoenixSQL.g:618:25: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_sequence_node3220); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_sequence_node3224); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_sequence_node3230);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.dropSequence(t, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_sequence_node"



	// $ANTLR start "pk_constraint"
	// PhoenixSQL.g:622:1: pk_constraint returns [PrimaryKeyConstraint ret] : ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN ;
	public final PrimaryKeyConstraint pk_constraint() throws RecognitionException {
		PrimaryKeyConstraint ret = null;


		String n =null;
		List<ColumnDefInPkConstraint> cols =null;

		try {
			// PhoenixSQL.g:623:5: ( ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN )
			// PhoenixSQL.g:623:9: ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN
			{
			// PhoenixSQL.g:623:9: ( COMMA )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==COMMA) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// PhoenixSQL.g:623:9: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_pk_constraint3259); if (state.failed) return ret;
					}
					break;

			}

			match(input,CONSTRAINT,FOLLOW_CONSTRAINT_in_pk_constraint3262); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_pk_constraint3266);
			n=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,PRIMARY,FOLLOW_PRIMARY_in_pk_constraint3268); if (state.failed) return ret;
			match(input,KEY,FOLLOW_KEY_in_pk_constraint3270); if (state.failed) return ret;
			match(input,LPAREN,FOLLOW_LPAREN_in_pk_constraint3272); if (state.failed) return ret;
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint3276);
			cols=col_name_with_sort_order_rowtimestamp_list();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_pk_constraint3278); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.primaryKey(n,cols); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "pk_constraint"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp_list"
	// PhoenixSQL.g:626:1: col_name_with_sort_order_rowtimestamp_list returns [List<ColumnDefInPkConstraint> ret] : p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* ;
	public final List<ColumnDefInPkConstraint> col_name_with_sort_order_rowtimestamp_list() throws RecognitionException {
		List<ColumnDefInPkConstraint> ret = null;


		ColumnDefInPkConstraint p =null;

		ret = new ArrayList<ColumnDefInPkConstraint>(); 
		try {
			// PhoenixSQL.g:628:5: (p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* )
			// PhoenixSQL.g:628:9: p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			{
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list3309);
			p=col_name_with_sort_order_rowtimestamp();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:628:65: ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			loop56:
			while (true) {
				int alt56=2;
				int LA56_0 = input.LA(1);
				if ( (LA56_0==COMMA) ) {
					alt56=1;
				}

				switch (alt56) {
				case 1 :
					// PhoenixSQL.g:628:66: COMMA p= col_name_with_sort_order_rowtimestamp
					{
					match(input,COMMA,FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list3315); if (state.failed) return ret;
					pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list3321);
					p=col_name_with_sort_order_rowtimestamp();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop56;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp_list"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp"
	// PhoenixSQL.g:631:1: col_name_with_sort_order_rowtimestamp returns [ColumnDefInPkConstraint ret] : f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ;
	public final ColumnDefInPkConstraint col_name_with_sort_order_rowtimestamp() throws RecognitionException {
		ColumnDefInPkConstraint ret = null;


		Token order=null;
		Token rr=null;
		String f =null;

		try {
			// PhoenixSQL.g:632:5: (f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
			// PhoenixSQL.g:632:9: f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
			{
			pushFollow(FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp3348);
			f=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:632:22: (order= ASC |order= DESC )?
			int alt57=3;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==ASC) ) {
				alt57=1;
			}
			else if ( (LA57_0==DESC) ) {
				alt57=2;
			}
			switch (alt57) {
				case 1 :
					// PhoenixSQL.g:632:23: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp3353); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:632:33: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp3357); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:632:46: (rr= ROW_TIMESTAMP )?
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==ROW_TIMESTAMP) ) {
				alt58=1;
			}
			switch (alt58) {
				case 1 :
					// PhoenixSQL.g:632:47: rr= ROW_TIMESTAMP
					{
					rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp3364); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDefInPkConstraint(factory.columnName(f), order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()), rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp"



	// $ANTLR start "ik_constraint"
	// PhoenixSQL.g:636:1: ik_constraint returns [IndexKeyConstraint ret] : x= expression_with_sort_order_list ;
	public final IndexKeyConstraint ik_constraint() throws RecognitionException {
		IndexKeyConstraint ret = null;


		List<Pair<ParseNode, SortOrder>> x =null;

		try {
			// PhoenixSQL.g:637:5: (x= expression_with_sort_order_list )
			// PhoenixSQL.g:637:9: x= expression_with_sort_order_list
			{
			pushFollow(FOLLOW_expression_with_sort_order_list_in_ik_constraint3399);
			x=expression_with_sort_order_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexKey(x); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "ik_constraint"



	// $ANTLR start "expression_with_sort_order_list"
	// PhoenixSQL.g:640:1: expression_with_sort_order_list returns [List<Pair<ParseNode, SortOrder>> ret] : p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* ;
	public final List<Pair<ParseNode, SortOrder>> expression_with_sort_order_list() throws RecognitionException {
		List<Pair<ParseNode, SortOrder>> ret = null;


		Pair<ParseNode, SortOrder> p =null;

		ret = new ArrayList<Pair<ParseNode, SortOrder>>(); 
		try {
			// PhoenixSQL.g:642:5: (p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* )
			// PhoenixSQL.g:642:9: p= expression_with_sort_order ( COMMA p= expression_with_sort_order )*
			{
			pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list3426);
			p=expression_with_sort_order();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:642:54: ( COMMA p= expression_with_sort_order )*
			loop59:
			while (true) {
				int alt59=2;
				int LA59_0 = input.LA(1);
				if ( (LA59_0==COMMA) ) {
					alt59=1;
				}

				switch (alt59) {
				case 1 :
					// PhoenixSQL.g:642:55: COMMA p= expression_with_sort_order
					{
					match(input,COMMA,FOLLOW_COMMA_in_expression_with_sort_order_list3432); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list3438);
					p=expression_with_sort_order();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop59;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order_list"



	// $ANTLR start "expression_with_sort_order"
	// PhoenixSQL.g:645:1: expression_with_sort_order returns [Pair<ParseNode, SortOrder> ret] : (x= expression ) (order= ASC |order= DESC )? ;
	public final Pair<ParseNode, SortOrder> expression_with_sort_order() throws RecognitionException {
		Pair<ParseNode, SortOrder> ret = null;


		Token order=null;
		ParseNode x =null;

		try {
			// PhoenixSQL.g:646:5: ( (x= expression ) (order= ASC |order= DESC )? )
			// PhoenixSQL.g:646:9: (x= expression ) (order= ASC |order= DESC )?
			{
			// PhoenixSQL.g:646:9: (x= expression )
			// PhoenixSQL.g:646:10: x= expression
			{
			pushFollow(FOLLOW_expression_in_expression_with_sort_order3465);
			x=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:646:24: (order= ASC |order= DESC )?
			int alt60=3;
			int LA60_0 = input.LA(1);
			if ( (LA60_0==ASC) ) {
				alt60=1;
			}
			else if ( (LA60_0==DESC) ) {
				alt60=2;
			}
			switch (alt60) {
				case 1 :
					// PhoenixSQL.g:646:25: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_expression_with_sort_order3471); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:646:35: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_expression_with_sort_order3475); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = Pair.newPair(x, order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()));}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order"



	// $ANTLR start "fam_properties"
	// PhoenixSQL.g:649:1: fam_properties returns [ListMultimap<String,Pair<String,Object>> ret] : p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* ;
	public final ListMultimap<String,Pair<String,Object>> fam_properties() throws RecognitionException {
		ListMultimap<String,Pair<String,Object>> ret = null;


		PropertyName p =null;
		Object v =null;

		ret = ArrayListMultimap.<String,Pair<String,Object>>create(); 
		try {
			// PhoenixSQL.g:651:5: (p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:651:8: p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_fam_prop_name_in_fam_properties3503);
			p=fam_prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_fam_properties3505); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_fam_properties3509);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
			// PhoenixSQL.g:651:119: ( COMMA p= fam_prop_name EQ v= prop_value )*
			loop61:
			while (true) {
				int alt61=2;
				int LA61_0 = input.LA(1);
				if ( (LA61_0==COMMA) ) {
					alt61=1;
				}

				switch (alt61) {
				case 1 :
					// PhoenixSQL.g:651:120: COMMA p= fam_prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_fam_properties3515); if (state.failed) return ret;
					pushFollow(FOLLOW_fam_prop_name_in_fam_properties3519);
					p=fam_prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_fam_properties3521); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_fam_properties3525);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
					}
					break;

				default :
					break loop61;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_properties"



	// $ANTLR start "fam_prop_name"
	// PhoenixSQL.g:654:1: fam_prop_name returns [PropertyName ret] : (propName= identifier |familyName= identifier DOT propName= identifier );
	public final PropertyName fam_prop_name() throws RecognitionException {
		PropertyName ret = null;


		String propName =null;
		String familyName =null;

		try {
			// PhoenixSQL.g:655:5: (propName= identifier |familyName= identifier DOT propName= identifier )
			int alt62=2;
			int LA62_0 = input.LA(1);
			if ( (LA62_0==NAME) ) {
				int LA62_1 = input.LA(2);
				if ( (LA62_1==EQ) ) {
					alt62=1;
				}
				else if ( (LA62_1==DOT) ) {
					alt62=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 62, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 62, 0, input);
				throw nvae;
			}

			switch (alt62) {
				case 1 :
					// PhoenixSQL.g:655:9: propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name3555);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(propName); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:656:9: familyName= identifier DOT propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name3569);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_fam_prop_name3571); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_fam_prop_name3575);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(familyName, propName); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_prop_name"



	// $ANTLR start "prop_value"
	// PhoenixSQL.g:659:1: prop_value returns [Object ret] : (v= identifier |l= literal );
	public final Object prop_value() throws RecognitionException {
		Object ret = null;


		String v =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:660:5: (v= identifier |l= literal )
			int alt63=2;
			int LA63_0 = input.LA(1);
			if ( (LA63_0==NAME) ) {
				int LA63_1 = input.LA(2);
				if ( (LA63_1==EOF||LA63_1==CASCADE||(LA63_1 >= COLUMN_QUALIFIER_COUNTER && LA63_1 <= COMMA)||LA63_1==SEMICOLON||LA63_1==SPLIT) ) {
					alt63=1;
				}
				else if ( (LA63_1==STRING_LITERAL) ) {
					alt63=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 63, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA63_0==BIN_LITERAL||LA63_0==DECIMAL||LA63_0==DOUBLE||LA63_0==FALSE||LA63_0==HEX_LITERAL||LA63_0==NULL||LA63_0==NUMBER||LA63_0==STRING_LITERAL||LA63_0==TRUE) ) {
				alt63=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 63, 0, input);
				throw nvae;
			}

			switch (alt63) {
				case 1 :
					// PhoenixSQL.g:660:9: v= identifier
					{
					pushFollow(FOLLOW_identifier_in_prop_value3606);
					v=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = v; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:661:9: l= literal
					{
					pushFollow(FOLLOW_literal_in_prop_value3620);
					l=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = l.getValue(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_value"



	// $ANTLR start "column_name"
	// PhoenixSQL.g:664:1: column_name returns [ColumnName ret] : (field= identifier |family= identifier DOT field= identifier );
	public final ColumnName column_name() throws RecognitionException {
		ColumnName ret = null;


		String field =null;
		String family =null;

		try {
			// PhoenixSQL.g:665:5: (field= identifier |family= identifier DOT field= identifier )
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==NAME) ) {
				int LA64_1 = input.LA(2);
				if ( (LA64_1==EOF||LA64_1==COMMA||LA64_1==EQ||LA64_1==NAME||LA64_1==RPAREN||LA64_1==SEMICOLON) ) {
					alt64=1;
				}
				else if ( (LA64_1==DOT) ) {
					alt64=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 64, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 64, 0, input);
				throw nvae;
			}

			switch (alt64) {
				case 1 :
					// PhoenixSQL.g:665:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name3651);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:666:9: family= identifier DOT field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name3665);
					family=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_column_name3667); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_column_name3671);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(family, field); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_name"



	// $ANTLR start "column_names"
	// PhoenixSQL.g:669:1: column_names returns [List<ColumnName> ret] : v= column_name ( COMMA v= column_name )* ;
	public final List<ColumnName> column_names() throws RecognitionException {
		List<ColumnName> ret = null;


		ColumnName v =null;

		ret = new ArrayList<ColumnName>(); 
		try {
			// PhoenixSQL.g:671:5: (v= column_name ( COMMA v= column_name )* )
			// PhoenixSQL.g:671:8: v= column_name ( COMMA v= column_name )*
			{
			pushFollow(FOLLOW_column_name_in_column_names3703);
			v=column_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:671:40: ( COMMA v= column_name )*
			loop65:
			while (true) {
				int alt65=2;
				int LA65_0 = input.LA(1);
				if ( (LA65_0==COMMA) ) {
					alt65=1;
				}

				switch (alt65) {
				case 1 :
					// PhoenixSQL.g:671:41: COMMA v= column_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_names3709); if (state.failed) return ret;
					pushFollow(FOLLOW_column_name_in_column_names3715);
					v=column_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop65;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_names"



	// $ANTLR start "drop_table_node"
	// PhoenixSQL.g:676:1: drop_table_node returns [DropTableStatement ret] : DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? ;
	public final DropTableStatement drop_table_node() throws RecognitionException {
		DropTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token c=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:677:5: ( DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? )
			// PhoenixSQL.g:677:9: DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_table_node3742); if (state.failed) return ret;
			// PhoenixSQL.g:677:14: (v= VIEW | TABLE )
			int alt66=2;
			int LA66_0 = input.LA(1);
			if ( (LA66_0==VIEW) ) {
				alt66=1;
			}
			else if ( (LA66_0==TABLE) ) {
				alt66=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 66, 0, input);
				throw nvae;
			}

			switch (alt66) {
				case 1 :
					// PhoenixSQL.g:677:15: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_drop_table_node3747); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:677:24: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_drop_table_node3751); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:677:31: ( IF ex= EXISTS )?
			int alt67=2;
			int LA67_0 = input.LA(1);
			if ( (LA67_0==IF) ) {
				alt67=1;
			}
			switch (alt67) {
				case 1 :
					// PhoenixSQL.g:677:32: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_table_node3755); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_table_node3759); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_table_node3765);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:677:65: (c= CASCADE )?
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==CASCADE) ) {
				alt68=1;
			}
			switch (alt68) {
				case 1 :
					// PhoenixSQL.g:677:66: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_table_node3770); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropTable(t, v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_table_node"



	// $ANTLR start "drop_schema_node"
	// PhoenixSQL.g:681:1: drop_schema_node returns [DropSchemaStatement ret] : DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? ;
	public final DropSchemaStatement drop_schema_node() throws RecognitionException {
		DropSchemaStatement ret = null;


		Token ex=null;
		Token c=null;
		String s =null;

		try {
			// PhoenixSQL.g:682:5: ( DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? )
			// PhoenixSQL.g:682:9: DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_schema_node3805); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_drop_schema_node3807); if (state.failed) return ret;
			// PhoenixSQL.g:682:21: ( IF ex= EXISTS )?
			int alt69=2;
			int LA69_0 = input.LA(1);
			if ( (LA69_0==IF) ) {
				alt69=1;
			}
			switch (alt69) {
				case 1 :
					// PhoenixSQL.g:682:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_schema_node3810); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_schema_node3814); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_schema_node3820);
			s=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:682:50: (c= CASCADE )?
			int alt70=2;
			int LA70_0 = input.LA(1);
			if ( (LA70_0==CASCADE) ) {
				alt70=1;
			}
			switch (alt70) {
				case 1 :
					// PhoenixSQL.g:682:51: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_schema_node3825); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropSchema(s, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_schema_node"



	// $ANTLR start "drop_index_node"
	// PhoenixSQL.g:688:1: drop_index_node returns [DropIndexStatement ret] : DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ;
	public final DropIndexStatement drop_index_node() throws RecognitionException {
		DropIndexStatement ret = null;


		Token ex=null;
		NamedNode i =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:689:5: ( DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name )
			// PhoenixSQL.g:689:7: DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_index_node3860); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_drop_index_node3862); if (state.failed) return ret;
			// PhoenixSQL.g:689:18: ( IF ex= EXISTS )?
			int alt71=2;
			int LA71_0 = input.LA(1);
			if ( (LA71_0==IF) ) {
				alt71=1;
			}
			switch (alt71) {
				case 1 :
					// PhoenixSQL.g:689:19: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_index_node3865); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_index_node3869); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_drop_index_node3875);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_drop_index_node3877); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_drop_index_node3881);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropIndex(i, t, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_index_node"



	// $ANTLR start "drop_cdc_node"
	// PhoenixSQL.g:694:1: drop_cdc_node returns [DropCDCStatement ret] : DROP CDC ( IF ex= EXISTS )? o= cdc_name ON t= from_table_name ;
	public final DropCDCStatement drop_cdc_node() throws RecognitionException {
		DropCDCStatement ret = null;


		Token ex=null;
		NamedNode o =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:695:4: ( DROP CDC ( IF ex= EXISTS )? o= cdc_name ON t= from_table_name )
			// PhoenixSQL.g:695:6: DROP CDC ( IF ex= EXISTS )? o= cdc_name ON t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_cdc_node3910); if (state.failed) return ret;
			match(input,CDC,FOLLOW_CDC_in_drop_cdc_node3912); if (state.failed) return ret;
			// PhoenixSQL.g:695:15: ( IF ex= EXISTS )?
			int alt72=2;
			int LA72_0 = input.LA(1);
			if ( (LA72_0==IF) ) {
				alt72=1;
			}
			switch (alt72) {
				case 1 :
					// PhoenixSQL.g:695:16: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_cdc_node3915); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_cdc_node3919); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_cdc_name_in_drop_cdc_node3925);
			o=cdc_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_drop_cdc_node3927); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_drop_cdc_node3931);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropCDC(o, t, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_cdc_node"



	// $ANTLR start "alter_index_node"
	// PhoenixSQL.g:700:1: alter_index_node returns [AlterIndexStatement ret] : ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? ) ;
	public final AlterIndexStatement alter_index_node() throws RecognitionException {
		AlterIndexStatement ret = null;


		Token ex=null;
		Token isRebuildAll=null;
		Token s=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:701:5: ( ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? ) )
			// PhoenixSQL.g:701:7: ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_index_node3959); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_alter_index_node3961); if (state.failed) return ret;
			// PhoenixSQL.g:701:19: ( IF ex= EXISTS )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==IF) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// PhoenixSQL.g:701:20: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_alter_index_node3964); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_index_node3968); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_alter_index_node3974);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_alter_index_node3976); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_alter_index_node3980);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:702:7: ( (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )? )
			// PhoenixSQL.g:702:8: (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) ) (async= ASYNC )? ( ( ( SET )? ) p= fam_properties )?
			{
			// PhoenixSQL.g:702:8: (s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE ) )
			// PhoenixSQL.g:702:9: s= ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE )
			{
			// PhoenixSQL.g:702:11: ( USABLE | UNUSABLE | REBUILD (isRebuildAll= ALL )? | DISABLE | ACTIVE )
			int alt75=5;
			switch ( input.LA(1) ) {
			case USABLE:
				{
				alt75=1;
				}
				break;
			case UNUSABLE:
				{
				alt75=2;
				}
				break;
			case REBUILD:
				{
				alt75=3;
				}
				break;
			case DISABLE:
				{
				alt75=4;
				}
				break;
			case ACTIVE:
				{
				alt75=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 75, 0, input);
				throw nvae;
			}
			switch (alt75) {
				case 1 :
					// PhoenixSQL.g:702:12: USABLE
					{
					s=(Token)match(input,USABLE,FOLLOW_USABLE_in_alter_index_node3993); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:702:21: UNUSABLE
					{
					s=(Token)match(input,UNUSABLE,FOLLOW_UNUSABLE_in_alter_index_node3997); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:702:32: REBUILD (isRebuildAll= ALL )?
					{
					s=(Token)match(input,REBUILD,FOLLOW_REBUILD_in_alter_index_node4001); if (state.failed) return ret;
					// PhoenixSQL.g:702:40: (isRebuildAll= ALL )?
					int alt74=2;
					int LA74_0 = input.LA(1);
					if ( (LA74_0==ALL) ) {
						alt74=1;
					}
					switch (alt74) {
						case 1 :
							// PhoenixSQL.g:702:41: isRebuildAll= ALL
							{
							isRebuildAll=(Token)match(input,ALL,FOLLOW_ALL_in_alter_index_node4006); if (state.failed) return ret;
							}
							break;

					}

					}
					break;
				case 4 :
					// PhoenixSQL.g:702:62: DISABLE
					{
					s=(Token)match(input,DISABLE,FOLLOW_DISABLE_in_alter_index_node4012); if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:702:72: ACTIVE
					{
					s=(Token)match(input,ACTIVE,FOLLOW_ACTIVE_in_alter_index_node4016); if (state.failed) return ret;
					}
					break;

			}

			}

			// PhoenixSQL.g:702:81: (async= ASYNC )?
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==ASYNC) ) {
				alt76=1;
			}
			switch (alt76) {
				case 1 :
					// PhoenixSQL.g:702:82: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_alter_index_node4023); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:702:96: ( ( ( SET )? ) p= fam_properties )?
			int alt78=2;
			int LA78_0 = input.LA(1);
			if ( (LA78_0==NAME||LA78_0==SET) ) {
				alt78=1;
			}
			switch (alt78) {
				case 1 :
					// PhoenixSQL.g:702:97: ( ( SET )? ) p= fam_properties
					{
					// PhoenixSQL.g:702:97: ( ( SET )? )
					// PhoenixSQL.g:702:98: ( SET )?
					{
					// PhoenixSQL.g:702:98: ( SET )?
					int alt77=2;
					int LA77_0 = input.LA(1);
					if ( (LA77_0==SET) ) {
						alt77=1;
					}
					switch (alt77) {
						case 1 :
							// PhoenixSQL.g:702:98: SET
							{
							match(input,SET,FOLLOW_SET_in_alter_index_node4029); if (state.failed) return ret;
							}
							break;

					}

					}

					pushFollow(FOLLOW_fam_properties_in_alter_index_node4034);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			}

			if ( state.backtracking==0 ) {ret = factory.alterIndex(factory.namedTable(null, TableName.create(t.getSchemaName(), i.getName())), t.getTableName(), ex!=null, PIndexState.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), isRebuildAll!=null, async!=null, p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_index_node"



	// $ANTLR start "trace_node"
	// PhoenixSQL.g:707:1: trace_node returns [TraceStatement ret] : TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) ;
	public final TraceStatement trace_node() throws RecognitionException {
		TraceStatement ret = null;


		Token flag=null;
		LiteralParseNode s =null;

		try {
			// PhoenixSQL.g:708:5: ( TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) )
			// PhoenixSQL.g:708:9: TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			{
			match(input,TRACE,FOLLOW_TRACE_in_trace_node4069); if (state.failed) return ret;
			// PhoenixSQL.g:708:15: ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			int alt80=2;
			int LA80_0 = input.LA(1);
			if ( (LA80_0==ON) ) {
				alt80=1;
			}
			else if ( (LA80_0==OFF) ) {
				alt80=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 80, 0, input);
				throw nvae;
			}

			switch (alt80) {
				case 1 :
					// PhoenixSQL.g:708:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					{
					// PhoenixSQL.g:708:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					// PhoenixSQL.g:708:17: flag= ON ( WITH SAMPLING s= sampling_rate )?
					{
					flag=(Token)match(input,ON,FOLLOW_ON_in_trace_node4077); if (state.failed) return ret;
					// PhoenixSQL.g:708:28: ( WITH SAMPLING s= sampling_rate )?
					int alt79=2;
					int LA79_0 = input.LA(1);
					if ( (LA79_0==WITH) ) {
						alt79=1;
					}
					switch (alt79) {
						case 1 :
							// PhoenixSQL.g:708:30: WITH SAMPLING s= sampling_rate
							{
							match(input,WITH,FOLLOW_WITH_in_trace_node4082); if (state.failed) return ret;
							match(input,SAMPLING,FOLLOW_SAMPLING_in_trace_node4084); if (state.failed) return ret;
							pushFollow(FOLLOW_sampling_rate_in_trace_node4090);
							s=sampling_rate();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:708:67: flag= OFF
					{
					flag=(Token)match(input,OFF,FOLLOW_OFF_in_trace_node4101); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.trace(Tracing.isTraceOn(flag.getText()), s == null ? Tracing.isTraceOn(flag.getText()) ? 1.0 : 0.0 : (((BigDecimal)s.getValue())).doubleValue());}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "trace_node"



	// $ANTLR start "create_function_node"
	// PhoenixSQL.g:713:1: create_function_node returns [CreateFunctionStatement ret] : CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? ;
	public final CreateFunctionStatement create_function_node() throws RecognitionException {
		CreateFunctionStatement ret = null;


		Token replace=null;
		Token temp=null;
		String function =null;
		List<FunctionArgument> args =null;
		String r =null;
		LiteralParseNode className =null;
		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:714:5: ( CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? )
			// PhoenixSQL.g:714:9: CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_function_node4135); if (state.failed) return ret;
			// PhoenixSQL.g:714:16: ( OR replace= REPLACE )?
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==OR) ) {
				alt81=1;
			}
			switch (alt81) {
				case 1 :
					// PhoenixSQL.g:714:17: OR replace= REPLACE
					{
					match(input,OR,FOLLOW_OR_in_create_function_node4138); if (state.failed) return ret;
					replace=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_create_function_node4142); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:714:38: (temp= TEMPORARY )?
			int alt82=2;
			int LA82_0 = input.LA(1);
			if ( (LA82_0==TEMPORARY) ) {
				alt82=1;
			}
			switch (alt82) {
				case 1 :
					// PhoenixSQL.g:714:39: temp= TEMPORARY
					{
					temp=(Token)match(input,TEMPORARY,FOLLOW_TEMPORARY_in_create_function_node4149); if (state.failed) return ret;
					}
					break;

			}

			match(input,FUNCTION,FOLLOW_FUNCTION_in_create_function_node4153); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node4157);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:715:8: ( LPAREN args= zero_or_more_data_types RPAREN )
			// PhoenixSQL.g:715:9: LPAREN args= zero_or_more_data_types RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_function_node4168); if (state.failed) return ret;
			pushFollow(FOLLOW_zero_or_more_data_types_in_create_function_node4172);
			args=zero_or_more_data_types();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_function_node4174); if (state.failed) return ret;
			}

			match(input,RETURNS,FOLLOW_RETURNS_in_create_function_node4184); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node4188);
			r=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,AS,FOLLOW_AS_in_create_function_node4190); if (state.failed) return ret;
			// PhoenixSQL.g:716:32: (className= jar_path )
			// PhoenixSQL.g:716:33: className= jar_path
			{
			pushFollow(FOLLOW_jar_path_in_create_function_node4196);
			className=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:717:8: ( USING JAR (jarPath= jar_path ) )?
			int alt83=2;
			int LA83_0 = input.LA(1);
			if ( (LA83_0==USING) ) {
				alt83=1;
			}
			switch (alt83) {
				case 1 :
					// PhoenixSQL.g:717:9: USING JAR (jarPath= jar_path )
					{
					match(input,USING,FOLLOW_USING_in_create_function_node4207); if (state.failed) return ret;
					match(input,JAR,FOLLOW_JAR_in_create_function_node4209); if (state.failed) return ret;
					// PhoenixSQL.g:717:19: (jarPath= jar_path )
					// PhoenixSQL.g:717:20: jarPath= jar_path
					{
					pushFollow(FOLLOW_jar_path_in_create_function_node4216);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			            ret = factory.createFunction(new PFunction(SchemaUtil.normalizeIdentifier(function), args,r,(String)className.getValue(), jarPath == null ? null : (String)jarPath.getValue()), temp!=null, replace!=null);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_function_node"



	// $ANTLR start "jar_path"
	// PhoenixSQL.g:723:1: jar_path returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode jar_path() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:724:5: (l= literal )
			// PhoenixSQL.g:724:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_jar_path4253);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "jar_path"



	// $ANTLR start "drop_function_node"
	// PhoenixSQL.g:727:1: drop_function_node returns [DropFunctionStatement ret] : DROP FUNCTION ( IF ex= EXISTS )? function= identifier ;
	public final DropFunctionStatement drop_function_node() throws RecognitionException {
		DropFunctionStatement ret = null;


		Token ex=null;
		String function =null;

		try {
			// PhoenixSQL.g:728:5: ( DROP FUNCTION ( IF ex= EXISTS )? function= identifier )
			// PhoenixSQL.g:728:7: DROP FUNCTION ( IF ex= EXISTS )? function= identifier
			{
			match(input,DROP,FOLLOW_DROP_in_drop_function_node4276); if (state.failed) return ret;
			match(input,FUNCTION,FOLLOW_FUNCTION_in_drop_function_node4278); if (state.failed) return ret;
			// PhoenixSQL.g:728:21: ( IF ex= EXISTS )?
			int alt84=2;
			int LA84_0 = input.LA(1);
			if ( (LA84_0==IF) ) {
				alt84=1;
			}
			switch (alt84) {
				case 1 :
					// PhoenixSQL.g:728:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_function_node4281); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_function_node4285); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_function_node4291);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropFunction(SchemaUtil.normalizeIdentifier(function), ex!=null);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_function_node"



	// $ANTLR start "add_jars_node"
	// PhoenixSQL.g:731:1: add_jars_node returns [AddJarsStatement ret] : ADD JARS jarPaths= one_or_more_jarpaths ;
	public final AddJarsStatement add_jars_node() throws RecognitionException {
		AddJarsStatement ret = null;


		List<LiteralParseNode> jarPaths =null;

		try {
			// PhoenixSQL.g:732:5: ( ADD JARS jarPaths= one_or_more_jarpaths )
			// PhoenixSQL.g:732:7: ADD JARS jarPaths= one_or_more_jarpaths
			{
			match(input,ADD,FOLLOW_ADD_in_add_jars_node4314); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_add_jars_node4316); if (state.failed) return ret;
			pushFollow(FOLLOW_one_or_more_jarpaths_in_add_jars_node4322);
			jarPaths=one_or_more_jarpaths();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.addJars(jarPaths);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_jars_node"



	// $ANTLR start "list_jars_node"
	// PhoenixSQL.g:735:1: list_jars_node returns [ListJarsStatement ret] : LIST JARS ;
	public final ListJarsStatement list_jars_node() throws RecognitionException {
		ListJarsStatement ret = null;


		try {
			// PhoenixSQL.g:736:5: ( LIST JARS )
			// PhoenixSQL.g:736:7: LIST JARS
			{
			match(input,LIST,FOLLOW_LIST_in_list_jars_node4345); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_list_jars_node4347); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.listJars();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "list_jars_node"



	// $ANTLR start "delete_jar_node"
	// PhoenixSQL.g:739:1: delete_jar_node returns [DeleteJarStatement ret] : DELETE JAR jarPath= jar_path ;
	public final DeleteJarStatement delete_jar_node() throws RecognitionException {
		DeleteJarStatement ret = null;


		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:740:5: ( DELETE JAR jarPath= jar_path )
			// PhoenixSQL.g:740:7: DELETE JAR jarPath= jar_path
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_jar_node4370); if (state.failed) return ret;
			match(input,JAR,FOLLOW_JAR_in_delete_jar_node4372); if (state.failed) return ret;
			pushFollow(FOLLOW_jar_path_in_delete_jar_node4378);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.deleteJar(jarPath);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_jar_node"



	// $ANTLR start "alter_session_node"
	// PhoenixSQL.g:744:1: alter_session_node returns [AlterSessionStatement ret] : ALTER SESSION ( SET p= properties ) ;
	public final AlterSessionStatement alter_session_node() throws RecognitionException {
		AlterSessionStatement ret = null;


		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:745:5: ( ALTER SESSION ( SET p= properties ) )
			// PhoenixSQL.g:745:9: ALTER SESSION ( SET p= properties )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_session_node4404); if (state.failed) return ret;
			match(input,SESSION,FOLLOW_SESSION_in_alter_session_node4406); if (state.failed) return ret;
			// PhoenixSQL.g:745:23: ( SET p= properties )
			// PhoenixSQL.g:745:24: SET p= properties
			{
			match(input,SET,FOLLOW_SET_in_alter_session_node4409); if (state.failed) return ret;
			pushFollow(FOLLOW_properties_in_alter_session_node4413);
			p=properties();
			state._fsp--;
			if (state.failed) return ret;
			}

			if ( state.backtracking==0 ) {ret = factory.alterSession(p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_session_node"



	// $ANTLR start "alter_table_node"
	// PhoenixSQL.g:750:1: alter_table_node returns [AlterTableStatement ret] : ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) ) ;
	public final AlterTableStatement alter_table_node() throws RecognitionException {
		AlterTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token cas=null;
		Token all=null;
		TableName t =null;
		List<ColumnName> c =null;
		List<ColumnDef> d =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<NamedNode> list =null;

		try {
			// PhoenixSQL.g:751:5: ( ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) ) )
			// PhoenixSQL.g:751:9: ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_table_node4447); if (state.failed) return ret;
			// PhoenixSQL.g:751:15: ( TABLE |v= VIEW )
			int alt85=2;
			int LA85_0 = input.LA(1);
			if ( (LA85_0==TABLE) ) {
				alt85=1;
			}
			else if ( (LA85_0==VIEW) ) {
				alt85=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 85, 0, input);
				throw nvae;
			}

			switch (alt85) {
				case 1 :
					// PhoenixSQL.g:751:16: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_alter_table_node4450); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:751:24: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_alter_table_node4456); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_alter_table_node4461);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:752:9: ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )? | ( SET (p= fam_properties ) ) )
			int alt91=3;
			switch ( input.LA(1) ) {
			case DROP:
				{
				alt91=1;
				}
				break;
			case ADD:
				{
				alt91=2;
				}
				break;
			case SET:
				{
				alt91=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 91, 0, input);
				throw nvae;
			}
			switch (alt91) {
				case 1 :
					// PhoenixSQL.g:752:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					{
					// PhoenixSQL.g:752:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					// PhoenixSQL.g:752:12: DROP COLUMN ( IF ex= EXISTS )? c= column_names
					{
					match(input,DROP,FOLLOW_DROP_in_alter_table_node4474); if (state.failed) return ret;
					match(input,COLUMN,FOLLOW_COLUMN_in_alter_table_node4476); if (state.failed) return ret;
					// PhoenixSQL.g:752:24: ( IF ex= EXISTS )?
					int alt86=2;
					int LA86_0 = input.LA(1);
					if ( (LA86_0==IF) ) {
						alt86=1;
					}
					switch (alt86) {
						case 1 :
							// PhoenixSQL.g:752:25: IF ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node4479); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node4483); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_column_names_in_alter_table_node4489);
					c=column_names();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:752:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) (cas= CASCADE INDEX (list= indexes |all= ALL ) )?
					{
					// PhoenixSQL.g:752:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? )
					// PhoenixSQL.g:752:59: ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )?
					{
					match(input,ADD,FOLLOW_ADD_in_alter_table_node4495); if (state.failed) return ret;
					// PhoenixSQL.g:752:63: ( IF NOT ex= EXISTS )?
					int alt87=2;
					int LA87_0 = input.LA(1);
					if ( (LA87_0==IF) ) {
						alt87=1;
					}
					switch (alt87) {
						case 1 :
							// PhoenixSQL.g:752:64: IF NOT ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node4498); if (state.failed) return ret;
							match(input,NOT,FOLLOW_NOT_in_alter_table_node4500); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node4504); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:752:83: (d= column_defs )
					// PhoenixSQL.g:752:84: d= column_defs
					{
					pushFollow(FOLLOW_column_defs_in_alter_table_node4511);
					d=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					}

					// PhoenixSQL.g:752:99: (p= fam_properties )?
					int alt88=2;
					int LA88_0 = input.LA(1);
					if ( (LA88_0==NAME) ) {
						alt88=1;
					}
					switch (alt88) {
						case 1 :
							// PhoenixSQL.g:752:100: p= fam_properties
							{
							pushFollow(FOLLOW_fam_properties_in_alter_table_node4517);
							p=fam_properties();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					// PhoenixSQL.g:752:120: (cas= CASCADE INDEX (list= indexes |all= ALL ) )?
					int alt90=2;
					int LA90_0 = input.LA(1);
					if ( (LA90_0==CASCADE) ) {
						alt90=1;
					}
					switch (alt90) {
						case 1 :
							// PhoenixSQL.g:752:121: cas= CASCADE INDEX (list= indexes |all= ALL )
							{
							cas=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_alter_table_node4525); if (state.failed) return ret;
							match(input,INDEX,FOLLOW_INDEX_in_alter_table_node4527); if (state.failed) return ret;
							// PhoenixSQL.g:752:139: (list= indexes |all= ALL )
							int alt89=2;
							int LA89_0 = input.LA(1);
							if ( (LA89_0==NAME) ) {
								alt89=1;
							}
							else if ( (LA89_0==ALL) ) {
								alt89=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 89, 0, input);
								throw nvae;
							}

							switch (alt89) {
								case 1 :
									// PhoenixSQL.g:752:140: list= indexes
									{
									pushFollow(FOLLOW_indexes_in_alter_table_node4532);
									list=indexes();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:752:155: all= ALL
									{
									all=(Token)match(input,ALL,FOLLOW_ALL_in_alter_table_node4538); if (state.failed) return ret;
									}
									break;

							}

							}
							break;

					}

					}
					break;
				case 3 :
					// PhoenixSQL.g:752:168: ( SET (p= fam_properties ) )
					{
					// PhoenixSQL.g:752:168: ( SET (p= fam_properties ) )
					// PhoenixSQL.g:752:169: SET (p= fam_properties )
					{
					match(input,SET,FOLLOW_SET_in_alter_table_node4546); if (state.failed) return ret;
					// PhoenixSQL.g:752:173: (p= fam_properties )
					// PhoenixSQL.g:752:174: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_alter_table_node4551);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { PTableType tt = v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW; ret = ( c == null ? factory.addColumn(factory.namedTable(null,t), tt, d, ex!=null, p, cas!=null, (all == null ? list : null)) : factory.dropColumn(factory.namedTable(null,t), tt, c, ex!=null) ); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_table_node"



	// $ANTLR start "update_statistics_node"
	// PhoenixSQL.g:756:1: update_statistics_node returns [UpdateStatisticsStatement ret] : UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? ;
	public final UpdateStatisticsStatement update_statistics_node() throws RecognitionException {
		UpdateStatisticsStatement ret = null;


		Token s=null;
		TableName t =null;
		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:757:2: ( UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? )
			// PhoenixSQL.g:757:6: UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )?
			{
			match(input,UPDATE,FOLLOW_UPDATE_in_update_statistics_node4585); if (state.failed) return ret;
			match(input,STATISTICS,FOLLOW_STATISTICS_in_update_statistics_node4587); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_update_statistics_node4591);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:757:42: (s= INDEX |s= ALL |s= COLUMNS )?
			int alt92=4;
			switch ( input.LA(1) ) {
				case INDEX:
					{
					alt92=1;
					}
					break;
				case ALL:
					{
					alt92=2;
					}
					break;
				case COLUMNS:
					{
					alt92=3;
					}
					break;
			}
			switch (alt92) {
				case 1 :
					// PhoenixSQL.g:757:43: s= INDEX
					{
					s=(Token)match(input,INDEX,FOLLOW_INDEX_in_update_statistics_node4596); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:757:53: s= ALL
					{
					s=(Token)match(input,ALL,FOLLOW_ALL_in_update_statistics_node4602); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:757:61: s= COLUMNS
					{
					s=(Token)match(input,COLUMNS,FOLLOW_COLUMNS_in_update_statistics_node4608); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:757:73: ( SET (p= properties ) )?
			int alt93=2;
			int LA93_0 = input.LA(1);
			if ( (LA93_0==SET) ) {
				alt93=1;
			}
			switch (alt93) {
				case 1 :
					// PhoenixSQL.g:757:74: SET (p= properties )
					{
					match(input,SET,FOLLOW_SET_in_update_statistics_node4613); if (state.failed) return ret;
					// PhoenixSQL.g:757:78: (p= properties )
					// PhoenixSQL.g:757:79: p= properties
					{
					pushFollow(FOLLOW_properties_in_update_statistics_node4618);
					p=properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.updateStatistics(factory.namedTable(null, t), s == null ? StatisticsCollectionScope.getDefault() : StatisticsCollectionScope.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_statistics_node"



	// $ANTLR start "execute_upgrade_node"
	// PhoenixSQL.g:761:1: execute_upgrade_node returns [ExecuteUpgradeStatement ret] : EXECUTE UPGRADE ;
	public final ExecuteUpgradeStatement execute_upgrade_node() throws RecognitionException {
		ExecuteUpgradeStatement ret = null;


		try {
			// PhoenixSQL.g:762:2: ( EXECUTE UPGRADE )
			// PhoenixSQL.g:762:6: EXECUTE UPGRADE
			{
			match(input,EXECUTE,FOLLOW_EXECUTE_in_execute_upgrade_node4642); if (state.failed) return ret;
			match(input,UPGRADE,FOLLOW_UPGRADE_in_execute_upgrade_node4644); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.executeUpgrade();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "execute_upgrade_node"



	// $ANTLR start "prop_name"
	// PhoenixSQL.g:766:1: prop_name returns [String ret] : p= identifier ;
	public final String prop_name() throws RecognitionException {
		String ret = null;


		String p =null;

		try {
			// PhoenixSQL.g:767:5: (p= identifier )
			// PhoenixSQL.g:767:9: p= identifier
			{
			pushFollow(FOLLOW_identifier_in_prop_name4670);
			p=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = SchemaUtil.normalizeIdentifier(p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_name"



	// $ANTLR start "properties"
	// PhoenixSQL.g:770:1: properties returns [Map<String,Object> ret] : k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* ;
	public final Map<String,Object> properties() throws RecognitionException {
		Map<String,Object> ret = null;


		String k =null;
		Object v =null;

		ret = new HashMap<String,Object>(); 
		try {
			// PhoenixSQL.g:772:5: (k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:772:8: k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_prop_name_in_properties4704);
			k=prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_properties4706); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_properties4710);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(k,v);}
			// PhoenixSQL.g:772:54: ( COMMA k= prop_name EQ v= prop_value )*
			loop94:
			while (true) {
				int alt94=2;
				int LA94_0 = input.LA(1);
				if ( (LA94_0==COMMA) ) {
					alt94=1;
				}

				switch (alt94) {
				case 1 :
					// PhoenixSQL.g:772:55: COMMA k= prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_properties4716); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_name_in_properties4720);
					k=prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_properties4722); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_properties4726);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(k,v);}
					}
					break;

				default :
					break loop94;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "properties"



	// $ANTLR start "column_defs"
	// PhoenixSQL.g:775:1: column_defs returns [List<ColumnDef> ret] : v= column_def ( COMMA v= column_def )* ;
	public final List<ColumnDef> column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:777:5: (v= column_def ( COMMA v= column_def )* )
			// PhoenixSQL.g:777:8: v= column_def ( COMMA v= column_def )*
			{
			pushFollow(FOLLOW_column_def_in_column_defs4761);
			v=column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:777:39: ( COMMA v= column_def )*
			loop95:
			while (true) {
				int alt95=2;
				int LA95_0 = input.LA(1);
				if ( (LA95_0==COMMA) ) {
					int LA95_1 = input.LA(2);
					if ( (LA95_1==NAME) ) {
						alt95=1;
					}

				}

				switch (alt95) {
				case 1 :
					// PhoenixSQL.g:777:40: COMMA v= column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_defs4767); if (state.failed) return ret;
					pushFollow(FOLLOW_column_def_in_column_defs4773);
					v=column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop95;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_defs"



	// $ANTLR start "initializiation_list"
	// PhoenixSQL.g:780:1: initializiation_list returns [Map<String, Integer> ret] : k= STRING_LITERAL EQ v= NUMBER ( COMMA k= STRING_LITERAL EQ v= NUMBER )* ;
	public final Map<String, Integer> initializiation_list() throws RecognitionException {
		Map<String, Integer> ret = null;


		Token k=null;
		Token v=null;

		ret = new HashMap<String,Integer>(); 
		try {
			// PhoenixSQL.g:782:5: (k= STRING_LITERAL EQ v= NUMBER ( COMMA k= STRING_LITERAL EQ v= NUMBER )* )
			// PhoenixSQL.g:782:9: k= STRING_LITERAL EQ v= NUMBER ( COMMA k= STRING_LITERAL EQ v= NUMBER )*
			{
			k=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_initializiation_list4803); if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_initializiation_list4805); if (state.failed) return ret;
			v=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_initializiation_list4809); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(k.getText(), Integer.parseInt( v.getText() ));}
			// PhoenixSQL.g:783:9: ( COMMA k= STRING_LITERAL EQ v= NUMBER )*
			loop96:
			while (true) {
				int alt96=2;
				int LA96_0 = input.LA(1);
				if ( (LA96_0==COMMA) ) {
					alt96=1;
				}

				switch (alt96) {
				case 1 :
					// PhoenixSQL.g:783:10: COMMA k= STRING_LITERAL EQ v= NUMBER
					{
					match(input,COMMA,FOLLOW_COMMA_in_initializiation_list4822); if (state.failed) return ret;
					k=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_initializiation_list4826); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_initializiation_list4828); if (state.failed) return ret;
					v=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_initializiation_list4832); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(k.getText(), Integer.parseInt( v.getText() ));}
					}
					break;

				default :
					break loop96;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "initializiation_list"



	// $ANTLR start "indexes"
	// PhoenixSQL.g:786:1: indexes returns [List<NamedNode> ret] : v= index_name ( COMMA v= index_name )* ;
	public final List<NamedNode> indexes() throws RecognitionException {
		List<NamedNode> ret = null;


		NamedNode v =null;

		ret = new ArrayList<NamedNode>(); 
		try {
			// PhoenixSQL.g:788:5: (v= index_name ( COMMA v= index_name )* )
			// PhoenixSQL.g:788:8: v= index_name ( COMMA v= index_name )*
			{
			pushFollow(FOLLOW_index_name_in_indexes4867);
			v=index_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:788:39: ( COMMA v= index_name )*
			loop97:
			while (true) {
				int alt97=2;
				int LA97_0 = input.LA(1);
				if ( (LA97_0==COMMA) ) {
					alt97=1;
				}

				switch (alt97) {
				case 1 :
					// PhoenixSQL.g:788:40: COMMA v= index_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_indexes4873); if (state.failed) return ret;
					pushFollow(FOLLOW_index_name_in_indexes4879);
					v=index_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop97;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "indexes"



	// $ANTLR start "column_def"
	// PhoenixSQL.g:791:1: column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? ( (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ) | ( ENCODED_QUALIFIER eq= NUMBER ) )? ;
	public final ColumnDef column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token nn=null;
		Token n=null;
		Token pk=null;
		Token order=null;
		Token rr=null;
		Token eq=null;
		ColumnName c =null;
		String dt =null;
		ParseNode df =null;

		try {
			// PhoenixSQL.g:792:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? ( (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ) | ( ENCODED_QUALIFIER eq= NUMBER ) )? )
			// PhoenixSQL.g:792:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? ( (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ) | ( ENCODED_QUALIFIER eq= NUMBER ) )?
			{
			pushFollow(FOLLOW_column_name_in_column_def4905);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_column_def4909);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:792:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt99=2;
			int LA99_0 = input.LA(1);
			if ( (LA99_0==LPAREN) ) {
				alt99=1;
			}
			switch (alt99) {
				case 1 :
					// PhoenixSQL.g:792:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_column_def4912); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4916); if (state.failed) return ret;
					// PhoenixSQL.g:792:54: ( COMMA s= NUMBER )?
					int alt98=2;
					int LA98_0 = input.LA(1);
					if ( (LA98_0==COMMA) ) {
						alt98=1;
					}
					switch (alt98) {
						case 1 :
							// PhoenixSQL.g:792:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_column_def4919); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4923); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_column_def4927); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:792:83: (ar= ARRAY )?
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==ARRAY) ) {
				alt100=1;
			}
			switch (alt100) {
				case 1 :
					// PhoenixSQL.g:792:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_column_def4933); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:792:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt102=2;
			int LA102_0 = input.LA(1);
			if ( (LA102_0==LSQUARE) ) {
				alt102=1;
			}
			switch (alt102) {
				case 1 :
					// PhoenixSQL.g:792:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_column_def4939); if (state.failed) return ret;
					// PhoenixSQL.g:792:104: (a= NUMBER )?
					int alt101=2;
					int LA101_0 = input.LA(1);
					if ( (LA101_0==NUMBER) ) {
						alt101=1;
					}
					switch (alt101) {
						case 1 :
							// PhoenixSQL.g:792:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def4944); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_column_def4948); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:792:126: ( (nn= NOT )? n= NULL )?
			int alt104=2;
			int LA104_0 = input.LA(1);
			if ( (LA104_0==NOT||LA104_0==NULL) ) {
				alt104=1;
			}
			switch (alt104) {
				case 1 :
					// PhoenixSQL.g:792:127: (nn= NOT )? n= NULL
					{
					// PhoenixSQL.g:792:129: (nn= NOT )?
					int alt103=2;
					int LA103_0 = input.LA(1);
					if ( (LA103_0==NOT) ) {
						alt103=1;
					}
					switch (alt103) {
						case 1 :
							// PhoenixSQL.g:792:129: nn= NOT
							{
							nn=(Token)match(input,NOT,FOLLOW_NOT_in_column_def4955); if (state.failed) return ret;
							}
							break;

					}

					n=(Token)match(input,NULL,FOLLOW_NULL_in_column_def4960); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:792:144: ( DEFAULT df= expression )?
			int alt105=2;
			int LA105_0 = input.LA(1);
			if ( (LA105_0==DEFAULT) ) {
				alt105=1;
			}
			switch (alt105) {
				case 1 :
					// PhoenixSQL.g:792:145: DEFAULT df= expression
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_column_def4965); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_column_def4969);
					df=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:792:169: ( (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ) | ( ENCODED_QUALIFIER eq= NUMBER ) )?
			int alt108=3;
			int LA108_0 = input.LA(1);
			if ( (LA108_0==PRIMARY) ) {
				alt108=1;
			}
			else if ( (LA108_0==ENCODED_QUALIFIER) ) {
				alt108=2;
			}
			switch (alt108) {
				case 1 :
					// PhoenixSQL.g:792:170: (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
					{
					// PhoenixSQL.g:792:170: (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
					// PhoenixSQL.g:792:171: pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
					{
					pk=(Token)match(input,PRIMARY,FOLLOW_PRIMARY_in_column_def4977); if (state.failed) return ret;
					match(input,KEY,FOLLOW_KEY_in_column_def4979); if (state.failed) return ret;
					// PhoenixSQL.g:792:186: (order= ASC |order= DESC )?
					int alt106=3;
					int LA106_0 = input.LA(1);
					if ( (LA106_0==ASC) ) {
						alt106=1;
					}
					else if ( (LA106_0==DESC) ) {
						alt106=2;
					}
					switch (alt106) {
						case 1 :
							// PhoenixSQL.g:792:187: order= ASC
							{
							order=(Token)match(input,ASC,FOLLOW_ASC_in_column_def4984); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:792:197: order= DESC
							{
							order=(Token)match(input,DESC,FOLLOW_DESC_in_column_def4988); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:792:212: (rr= ROW_TIMESTAMP )?
					int alt107=2;
					int LA107_0 = input.LA(1);
					if ( (LA107_0==ROW_TIMESTAMP) ) {
						alt107=1;
					}
					switch (alt107) {
						case 1 :
							// PhoenixSQL.g:792:212: rr= ROW_TIMESTAMP
							{
							rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_column_def4994); if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:792:229: ( ENCODED_QUALIFIER eq= NUMBER )
					{
					// PhoenixSQL.g:792:229: ( ENCODED_QUALIFIER eq= NUMBER )
					// PhoenixSQL.g:792:230: ENCODED_QUALIFIER eq= NUMBER
					{
					match(input,ENCODED_QUALIFIER,FOLLOW_ENCODED_QUALIFIER_in_column_def4999); if (state.failed) return ret;
					eq=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def5003); if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDef(
			            c,
			            dt,
			            ar != null || lsq != null,
			            a == null ? null :  Integer.parseInt( a.getText() ),
			            nn!=null ? Boolean.FALSE : n!=null ? Boolean.TRUE : null,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            pk != null, 
			            order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()),
			            df == null ? null : df.toString(),
			            eq == null ? null : Integer.parseInt( eq.getText() ),
			            rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_def"



	// $ANTLR start "dyn_column_defs"
	// PhoenixSQL.g:808:1: dyn_column_defs returns [List<ColumnDef> ret] : v= dyn_column_def ( COMMA v= dyn_column_def )* ;
	public final List<ColumnDef> dyn_column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:810:5: (v= dyn_column_def ( COMMA v= dyn_column_def )* )
			// PhoenixSQL.g:810:8: v= dyn_column_def ( COMMA v= dyn_column_def )*
			{
			pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs5046);
			v=dyn_column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:810:43: ( COMMA v= dyn_column_def )*
			loop109:
			while (true) {
				int alt109=2;
				int LA109_0 = input.LA(1);
				if ( (LA109_0==COMMA) ) {
					alt109=1;
				}

				switch (alt109) {
				case 1 :
					// PhoenixSQL.g:810:44: COMMA v= dyn_column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_dyn_column_defs5052); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs5058);
					v=dyn_column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop109;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_defs"



	// $ANTLR start "dyn_column_def"
	// PhoenixSQL.g:813:1: dyn_column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ;
	public final ColumnDef dyn_column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:814:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )
			// PhoenixSQL.g:814:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_def5084);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_dyn_column_def5088);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:814:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt111=2;
			int LA111_0 = input.LA(1);
			if ( (LA111_0==LPAREN) ) {
				alt111=1;
			}
			switch (alt111) {
				case 1 :
					// PhoenixSQL.g:814:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_def5091); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def5095); if (state.failed) return ret;
					// PhoenixSQL.g:814:54: ( COMMA s= NUMBER )?
					int alt110=2;
					int LA110_0 = input.LA(1);
					if ( (LA110_0==COMMA) ) {
						alt110=1;
					}
					switch (alt110) {
						case 1 :
							// PhoenixSQL.g:814:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_dyn_column_def5098); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def5102); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_def5106); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:814:83: (ar= ARRAY )?
			int alt112=2;
			int LA112_0 = input.LA(1);
			if ( (LA112_0==ARRAY) ) {
				alt112=1;
			}
			switch (alt112) {
				case 1 :
					// PhoenixSQL.g:814:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_def5112); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:814:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==LSQUARE) ) {
				alt114=1;
			}
			switch (alt114) {
				case 1 :
					// PhoenixSQL.g:814:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_def5118); if (state.failed) return ret;
					// PhoenixSQL.g:814:104: (a= NUMBER )?
					int alt113=2;
					int LA113_0 = input.LA(1);
					if ( (LA113_0==NUMBER) ) {
						alt113=1;
					}
					switch (alt113) {
						case 1 :
							// PhoenixSQL.g:814:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def5123); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_def5127); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_def"



	// $ANTLR start "dyn_column_name_or_def"
	// PhoenixSQL.g:823:1: dyn_column_name_or_def returns [ColumnDef ret] : c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? ;
	public final ColumnDef dyn_column_name_or_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:824:5: (c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? )
			// PhoenixSQL.g:824:9: c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_name_or_def5164);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:824:23: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			int alt120=2;
			int LA120_0 = input.LA(1);
			if ( (LA120_0==NAME) ) {
				alt120=1;
			}
			switch (alt120) {
				case 1 :
					// PhoenixSQL.g:824:24: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					{
					pushFollow(FOLLOW_identifier_in_dyn_column_name_or_def5169);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:824:38: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
					int alt116=2;
					int LA116_0 = input.LA(1);
					if ( (LA116_0==LPAREN) ) {
						alt116=1;
					}
					switch (alt116) {
						case 1 :
							// PhoenixSQL.g:824:39: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_name_or_def5172); if (state.failed) return ret;
							l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def5176); if (state.failed) return ret;
							// PhoenixSQL.g:824:55: ( COMMA s= NUMBER )?
							int alt115=2;
							int LA115_0 = input.LA(1);
							if ( (LA115_0==COMMA) ) {
								alt115=1;
							}
							switch (alt115) {
								case 1 :
									// PhoenixSQL.g:824:56: COMMA s= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_dyn_column_name_or_def5179); if (state.failed) return ret;
									s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def5183); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_name_or_def5187); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:824:84: (ar= ARRAY )?
					int alt117=2;
					int LA117_0 = input.LA(1);
					if ( (LA117_0==ARRAY) ) {
						alt117=1;
					}
					switch (alt117) {
						case 1 :
							// PhoenixSQL.g:824:84: ar= ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_name_or_def5193); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:824:92: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					int alt119=2;
					int LA119_0 = input.LA(1);
					if ( (LA119_0==LSQUARE) ) {
						alt119=1;
					}
					switch (alt119) {
						case 1 :
							// PhoenixSQL.g:824:93: lsq= LSQUARE (a= NUMBER )? RSQUARE
							{
							lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_name_or_def5199); if (state.failed) return ret;
							// PhoenixSQL.g:824:105: (a= NUMBER )?
							int alt118=2;
							int LA118_0 = input.LA(1);
							if ( (LA118_0==NUMBER) ) {
								alt118=1;
							}
							switch (alt118) {
								case 1 :
									// PhoenixSQL.g:824:106: a= NUMBER
									{
									a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def5204); if (state.failed) return ret;
									}
									break;

							}

							match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_name_or_def5208); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_name_or_def"



	// $ANTLR start "subquery_expression"
	// PhoenixSQL.g:833:1: subquery_expression returns [ParseNode ret] : s= select_node ;
	public final ParseNode subquery_expression() throws RecognitionException {
		ParseNode ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:834:5: (s= select_node )
			// PhoenixSQL.g:834:8: s= select_node
			{
			pushFollow(FOLLOW_select_node_in_subquery_expression5248);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.subquery(s, false);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subquery_expression"



	// $ANTLR start "single_select"
	// PhoenixSQL.g:837:1: single_select returns [SelectStatement ret] : SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? ;
	public final SelectStatement single_select() throws RecognitionException {
		SelectStatement ret = null;


		Token d=null;
		HintNode h =null;
		List<AliasedNode> sel =null;
		TableNode from =null;
		ParseNode where =null;
		List<ParseNode> group =null;
		ParseNode having =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:839:5: ( SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? )
			// PhoenixSQL.g:839:9: SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )?
			{
			match(input,SELECT,FOLLOW_SELECT_in_single_select5281); if (state.failed) return ret;
			// PhoenixSQL.g:839:16: (h= hintClause )?
			int alt121=2;
			int LA121_0 = input.LA(1);
			if ( (LA121_0==ML_HINT) ) {
				alt121=1;
			}
			switch (alt121) {
				case 1 :
					// PhoenixSQL.g:839:17: h= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_single_select5286);
					h=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:840:9: (d= DISTINCT | ALL )?
			int alt122=3;
			int LA122_0 = input.LA(1);
			if ( (LA122_0==DISTINCT) ) {
				alt122=1;
			}
			else if ( (LA122_0==ALL) ) {
				alt122=2;
			}
			switch (alt122) {
				case 1 :
					// PhoenixSQL.g:840:10: d= DISTINCT
					{
					d=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_single_select5302); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:840:23: ALL
					{
					match(input,ALL,FOLLOW_ALL_in_single_select5306); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_select_list_in_single_select5312);
			sel=select_list();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:841:9: ( FROM from= parseFrom )?
			int alt123=2;
			int LA123_0 = input.LA(1);
			if ( (LA123_0==FROM) ) {
				alt123=1;
			}
			switch (alt123) {
				case 1 :
					// PhoenixSQL.g:841:10: FROM from= parseFrom
					{
					match(input,FROM,FOLLOW_FROM_in_single_select5323); if (state.failed) return ret;
					pushFollow(FOLLOW_parseFrom_in_single_select5327);
					from=parseFrom();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:842:9: ( WHERE where= expression )?
			int alt124=2;
			int LA124_0 = input.LA(1);
			if ( (LA124_0==WHERE) ) {
				alt124=1;
			}
			switch (alt124) {
				case 1 :
					// PhoenixSQL.g:842:10: WHERE where= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_single_select5340); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select5344);
					where=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:843:9: ( GROUP BY group= group_by )?
			int alt125=2;
			int LA125_0 = input.LA(1);
			if ( (LA125_0==GROUP) ) {
				alt125=1;
			}
			switch (alt125) {
				case 1 :
					// PhoenixSQL.g:843:10: GROUP BY group= group_by
					{
					match(input,GROUP,FOLLOW_GROUP_in_single_select5357); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_single_select5359); if (state.failed) return ret;
					pushFollow(FOLLOW_group_by_in_single_select5363);
					group=group_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:844:9: ( HAVING having= expression )?
			int alt126=2;
			int LA126_0 = input.LA(1);
			if ( (LA126_0==HAVING) ) {
				alt126=1;
			}
			switch (alt126) {
				case 1 :
					// PhoenixSQL.g:844:10: HAVING having= expression
					{
					match(input,HAVING,FOLLOW_HAVING_in_single_select5376); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select5380);
					having=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(from, h, d!=null, sel, where, group, having, null, null,null, getBindCount(), context.isAggregate(), context.hasSequences(), null, new HashMap<String,UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "single_select"



	// $ANTLR start "unioned_selects"
	// PhoenixSQL.g:849:1: unioned_selects returns [List<SelectStatement> ret] : s= single_select ( UNION ALL s= single_select )* ;
	public final List<SelectStatement> unioned_selects() throws RecognitionException {
		List<SelectStatement> ret = null;


		SelectStatement s =null;

		ret = new ArrayList<SelectStatement>();
		try {
			// PhoenixSQL.g:851:5: (s= single_select ( UNION ALL s= single_select )* )
			// PhoenixSQL.g:851:9: s= single_select ( UNION ALL s= single_select )*
			{
			pushFollow(FOLLOW_single_select_in_unioned_selects5424);
			s=single_select();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(s);}
			// PhoenixSQL.g:851:39: ( UNION ALL s= single_select )*
			loop127:
			while (true) {
				int alt127=2;
				int LA127_0 = input.LA(1);
				if ( (LA127_0==UNION) ) {
					alt127=1;
				}

				switch (alt127) {
				case 1 :
					// PhoenixSQL.g:851:40: UNION ALL s= single_select
					{
					match(input,UNION,FOLLOW_UNION_in_unioned_selects5429); if (state.failed) return ret;
					match(input,ALL,FOLLOW_ALL_in_unioned_selects5431); if (state.failed) return ret;
					pushFollow(FOLLOW_single_select_in_unioned_selects5435);
					s=single_select();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(s);}
					}
					break;

				default :
					break loop127;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "unioned_selects"



	// $ANTLR start "select_node"
	// PhoenixSQL.g:855:1: select_node returns [SelectStatement ret] : u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? ;
	public final SelectStatement select_node() throws RecognitionException {
		SelectStatement ret = null;


		List<SelectStatement> u =null;
		List<OrderByNode> order =null;
		LimitNode l =null;
		OffsetNode o =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:857:5: (u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? )
			// PhoenixSQL.g:857:9: u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			{
			pushFollow(FOLLOW_unioned_selects_in_select_node5473);
			u=unioned_selects();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:858:9: ( ORDER BY order= order_by )?
			int alt128=2;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==ORDER) ) {
				alt128=1;
			}
			switch (alt128) {
				case 1 :
					// PhoenixSQL.g:858:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_select_node5484); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_select_node5486); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_select_node5490);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:859:9: ( LIMIT l= limit )?
			int alt129=2;
			int LA129_0 = input.LA(1);
			if ( (LA129_0==LIMIT) ) {
				alt129=1;
			}
			switch (alt129) {
				case 1 :
					// PhoenixSQL.g:859:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_select_node5503); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_select_node5507);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:860:9: ( OFFSET o= offset )?
			int alt130=2;
			int LA130_0 = input.LA(1);
			if ( (LA130_0==OFFSET) ) {
				alt130=1;
			}
			switch (alt130) {
				case 1 :
					// PhoenixSQL.g:860:10: OFFSET o= offset
					{
					match(input,OFFSET,FOLLOW_OFFSET_in_select_node5520); if (state.failed) return ret;
					pushFollow(FOLLOW_offset_in_select_node5524);
					o=offset();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:861:9: ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			int alt132=2;
			int LA132_0 = input.LA(1);
			if ( (LA132_0==FETCH) ) {
				alt132=1;
			}
			switch (alt132) {
				case 1 :
					// PhoenixSQL.g:861:10: FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY
					{
					match(input,FETCH,FOLLOW_FETCH_in_select_node5537); if (state.failed) return ret;
					if ( input.LA(1)==FIRST||input.LA(1)==NEXT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// PhoenixSQL.g:861:31: (l= limit )?
					int alt131=2;
					int LA131_0 = input.LA(1);
					if ( (LA131_0==BIND_NAME||LA131_0==NUMBER||LA131_0==QUESTION) ) {
						alt131=1;
					}
					switch (alt131) {
						case 1 :
							// PhoenixSQL.g:861:32: l= limit
							{
							pushFollow(FOLLOW_limit_in_select_node5550);
							l=limit();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					match(input,ONLY,FOLLOW_ONLY_in_select_node5562); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(u, order, l, o, getBindCount(), context.isAggregate()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "select_node"



	// $ANTLR start "upsert_node"
	// PhoenixSQL.g:867:1: upsert_node returns [UpsertStatement ret] : UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | (upd= UPDATE pairs= update_column_pairs ) | (updo= UPDATE_ONLY upopairs= update_column_pairs ) ) )? ) |s= select_node ) rc= ( RETURNING ASTERISK )? ;
	public final UpsertStatement upsert_node() throws RecognitionException {
		UpsertStatement ret = null;


		Token ig=null;
		Token upd=null;
		Token updo=null;
		Token rc=null;
		HintNode hint =null;
		TableName t =null;
		Pair<List<ColumnDef>,List<ColumnName>> p =null;
		List<ParseNode> v =null;
		List<Pair<ColumnName,ParseNode>> pairs =null;
		List<Pair<ColumnName,ParseNode>> upopairs =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:868:5: ( UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | (upd= UPDATE pairs= update_column_pairs ) | (updo= UPDATE_ONLY upopairs= update_column_pairs ) ) )? ) |s= select_node ) rc= ( RETURNING ASTERISK )? )
			// PhoenixSQL.g:868:9: UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | (upd= UPDATE pairs= update_column_pairs ) | (updo= UPDATE_ONLY upopairs= update_column_pairs ) ) )? ) |s= select_node ) rc= ( RETURNING ASTERISK )?
			{
			match(input,UPSERT,FOLLOW_UPSERT_in_upsert_node5601); if (state.failed) return ret;
			// PhoenixSQL.g:868:16: (hint= hintClause )?
			int alt133=2;
			int LA133_0 = input.LA(1);
			if ( (LA133_0==ML_HINT) ) {
				alt133=1;
			}
			switch (alt133) {
				case 1 :
					// PhoenixSQL.g:868:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_upsert_node5606);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,INTO,FOLLOW_INTO_in_upsert_node5610); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_upsert_node5614);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:869:9: ( LPAREN p= upsert_column_refs RPAREN )?
			int alt134=2;
			int LA134_0 = input.LA(1);
			if ( (LA134_0==LPAREN) ) {
				alt134=1;
			}
			switch (alt134) {
				case 1 :
					// PhoenixSQL.g:869:10: LPAREN p= upsert_column_refs RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node5625); if (state.failed) return ret;
					pushFollow(FOLLOW_upsert_column_refs_in_upsert_node5629);
					p=upsert_column_refs();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node5631); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:870:9: ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | (upd= UPDATE pairs= update_column_pairs ) | (updo= UPDATE_ONLY upopairs= update_column_pairs ) ) )? ) |s= select_node )
			int alt137=2;
			int LA137_0 = input.LA(1);
			if ( (LA137_0==VALUES) ) {
				alt137=1;
			}
			else if ( (LA137_0==SELECT) ) {
				alt137=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 137, 0, input);
				throw nvae;
			}

			switch (alt137) {
				case 1 :
					// PhoenixSQL.g:870:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | (upd= UPDATE pairs= update_column_pairs ) | (updo= UPDATE_ONLY upopairs= update_column_pairs ) ) )? )
					{
					// PhoenixSQL.g:870:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | (upd= UPDATE pairs= update_column_pairs ) | (updo= UPDATE_ONLY upopairs= update_column_pairs ) ) )? )
					// PhoenixSQL.g:870:11: VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | (upd= UPDATE pairs= update_column_pairs ) | (updo= UPDATE_ONLY upopairs= update_column_pairs ) ) )?
					{
					match(input,VALUES,FOLLOW_VALUES_in_upsert_node5645); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node5647); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_upsert_node5651);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node5653); if (state.failed) return ret;
					// PhoenixSQL.g:870:58: ( ON DUPLICATE KEY (ig= IGNORE | (upd= UPDATE pairs= update_column_pairs ) | (updo= UPDATE_ONLY upopairs= update_column_pairs ) ) )?
					int alt136=2;
					int LA136_0 = input.LA(1);
					if ( (LA136_0==ON) ) {
						alt136=1;
					}
					switch (alt136) {
						case 1 :
							// PhoenixSQL.g:871:13: ON DUPLICATE KEY (ig= IGNORE | (upd= UPDATE pairs= update_column_pairs ) | (updo= UPDATE_ONLY upopairs= update_column_pairs ) )
							{
							match(input,ON,FOLLOW_ON_in_upsert_node5669); if (state.failed) return ret;
							match(input,DUPLICATE,FOLLOW_DUPLICATE_in_upsert_node5671); if (state.failed) return ret;
							match(input,KEY,FOLLOW_KEY_in_upsert_node5673); if (state.failed) return ret;
							// PhoenixSQL.g:871:30: (ig= IGNORE | (upd= UPDATE pairs= update_column_pairs ) | (updo= UPDATE_ONLY upopairs= update_column_pairs ) )
							int alt135=3;
							switch ( input.LA(1) ) {
							case IGNORE:
								{
								alt135=1;
								}
								break;
							case UPDATE:
								{
								alt135=2;
								}
								break;
							case UPDATE_ONLY:
								{
								alt135=3;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 135, 0, input);
								throw nvae;
							}
							switch (alt135) {
								case 1 :
									// PhoenixSQL.g:872:17: ig= IGNORE
									{
									ig=(Token)match(input,IGNORE,FOLLOW_IGNORE_in_upsert_node5695); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:873:17: (upd= UPDATE pairs= update_column_pairs )
									{
									// PhoenixSQL.g:873:17: (upd= UPDATE pairs= update_column_pairs )
									// PhoenixSQL.g:873:19: upd= UPDATE pairs= update_column_pairs
									{
									upd=(Token)match(input,UPDATE,FOLLOW_UPDATE_in_upsert_node5717); if (state.failed) return ret;
									pushFollow(FOLLOW_update_column_pairs_in_upsert_node5721);
									pairs=update_column_pairs();
									state._fsp--;
									if (state.failed) return ret;
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:874:17: (updo= UPDATE_ONLY upopairs= update_column_pairs )
									{
									// PhoenixSQL.g:874:17: (updo= UPDATE_ONLY upopairs= update_column_pairs )
									// PhoenixSQL.g:874:19: updo= UPDATE_ONLY upopairs= update_column_pairs
									{
									updo=(Token)match(input,UPDATE_ONLY,FOLLOW_UPDATE_ONLY_in_upsert_node5745); if (state.failed) return ret;
									pushFollow(FOLLOW_update_column_pairs_in_upsert_node5749);
									upopairs=update_column_pairs();
									state._fsp--;
									if (state.failed) return ret;
									}

									}
									break;

							}

							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:876:13: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_upsert_node5786);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:876:31: ( RETURNING ASTERISK )?
			int alt138=2;
			int LA138_0 = input.LA(1);
			if ( (LA138_0==RETURNING) ) {
				alt138=1;
			}
			switch (alt138) {
				case 1 :
					// PhoenixSQL.g:876:33: RETURNING ASTERISK
					{
					rc=(Token)match(input,RETURNING,FOLLOW_RETURNING_in_upsert_node5793); if (state.failed) return ret;
					rc=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_upsert_node5795); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.upsert(
			            factory.namedTable(null,t,p == null ? null : p.getFirst()), 
			            hint, p == null ? null : p.getSecond(), 
			            v, s, getBindCount(), 
			            new HashMap<String, UDFParseNode>(udfParseNodes),
			            ig != null ? Collections.<Pair<ColumnName,ParseNode>>emptyList() : pairs != null ? pairs
			             : upopairs != null ? upopairs : null,
			            ig != null ? UpsertStatement.OnDuplicateKeyType.IGNORE :
			            upd != null ? UpsertStatement.OnDuplicateKeyType.UPDATE :
			            updo != null ? UpsertStatement.OnDuplicateKeyType.UPDATE_ONLY
			             : UpsertStatement.OnDuplicateKeyType.NONE,
			            rc != null ? true : false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_node"



	// $ANTLR start "update_column_pairs"
	// PhoenixSQL.g:891:1: update_column_pairs returns [ List<Pair<ColumnName,ParseNode>> ret] : p= update_column_pair ( COMMA p= update_column_pair )* ;
	public final List<Pair<ColumnName,ParseNode>> update_column_pairs() throws RecognitionException {
		List<Pair<ColumnName,ParseNode>> ret = null;


		Pair<ColumnName,ParseNode> p =null;

		ret = new ArrayList<Pair<ColumnName,ParseNode>>(); 
		try {
			// PhoenixSQL.g:893:5: (p= update_column_pair ( COMMA p= update_column_pair )* )
			// PhoenixSQL.g:893:8: p= update_column_pair ( COMMA p= update_column_pair )*
			{
			pushFollow(FOLLOW_update_column_pair_in_update_column_pairs5838);
			p=update_column_pair();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(p); }
			// PhoenixSQL.g:894:8: ( COMMA p= update_column_pair )*
			loop139:
			while (true) {
				int alt139=2;
				int LA139_0 = input.LA(1);
				if ( (LA139_0==COMMA) ) {
					alt139=1;
				}

				switch (alt139) {
				case 1 :
					// PhoenixSQL.g:894:9: COMMA p= update_column_pair
					{
					match(input,COMMA,FOLLOW_COMMA_in_update_column_pairs5850); if (state.failed) return ret;
					pushFollow(FOLLOW_update_column_pair_in_update_column_pairs5854);
					p=update_column_pair();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret.add(p); }
					}
					break;

				default :
					break loop139;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pairs"



	// $ANTLR start "update_column_pair"
	// PhoenixSQL.g:897:1: update_column_pair returns [ Pair<ColumnName,ParseNode> ret ] : c= column_name EQ e= expression ;
	public final Pair<ColumnName,ParseNode> update_column_pair() throws RecognitionException {
		Pair<ColumnName,ParseNode> ret = null;


		ColumnName c =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:898:5: (c= column_name EQ e= expression )
			// PhoenixSQL.g:898:8: c= column_name EQ e= expression
			{
			pushFollow(FOLLOW_column_name_in_update_column_pair5879);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_update_column_pair5881); if (state.failed) return ret;
			pushFollow(FOLLOW_expression_in_update_column_pair5885);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = new Pair<ColumnName,ParseNode>(c,e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pair"



	// $ANTLR start "upsert_column_refs"
	// PhoenixSQL.g:902:1: upsert_column_refs returns [Pair<List<ColumnDef>,List<ColumnName>> ret] : d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* ;
	public final Pair<List<ColumnDef>,List<ColumnName>> upsert_column_refs() throws RecognitionException {
		Pair<List<ColumnDef>,List<ColumnName>> ret = null;


		ColumnDef d =null;

		ret = new Pair<List<ColumnDef>,List<ColumnName>>(new ArrayList<ColumnDef>(), new ArrayList<ColumnName>()); 
		try {
			// PhoenixSQL.g:904:5: (d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* )
			// PhoenixSQL.g:904:8: d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )*
			{
			pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5914);
			d=dyn_column_name_or_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
			// PhoenixSQL.g:905:8: ( COMMA d= dyn_column_name_or_def )*
			loop140:
			while (true) {
				int alt140=2;
				int LA140_0 = input.LA(1);
				if ( (LA140_0==COMMA) ) {
					alt140=1;
				}

				switch (alt140) {
				case 1 :
					// PhoenixSQL.g:905:9: COMMA d= dyn_column_name_or_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_upsert_column_refs5927); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5931);
					d=dyn_column_name_or_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
					}
					break;

				default :
					break loop140;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_column_refs"



	// $ANTLR start "declare_cursor_node"
	// PhoenixSQL.g:910:1: declare_cursor_node returns [DeclareCursorStatement ret] : DECLARE c= cursor_name CURSOR FOR s= select_node ;
	public final DeclareCursorStatement declare_cursor_node() throws RecognitionException {
		DeclareCursorStatement ret = null;


		CursorName c =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:911:5: ( DECLARE c= cursor_name CURSOR FOR s= select_node )
			// PhoenixSQL.g:911:10: DECLARE c= cursor_name CURSOR FOR s= select_node
			{
			match(input,DECLARE,FOLLOW_DECLARE_in_declare_cursor_node5959); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_declare_cursor_node5963);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,CURSOR,FOLLOW_CURSOR_in_declare_cursor_node5965); if (state.failed) return ret;
			match(input,FOR,FOLLOW_FOR_in_declare_cursor_node5967); if (state.failed) return ret;
			pushFollow(FOLLOW_select_node_in_declare_cursor_node5971);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.declareCursor(c, s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "declare_cursor_node"



	// $ANTLR start "cursor_open_node"
	// PhoenixSQL.g:915:1: cursor_open_node returns [OpenStatement ret] : OPEN c= cursor_name ;
	public final OpenStatement cursor_open_node() throws RecognitionException {
		OpenStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:916:5: ( OPEN c= cursor_name )
			// PhoenixSQL.g:916:10: OPEN c= cursor_name
			{
			match(input,OPEN,FOLLOW_OPEN_in_cursor_open_node6005); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_open_node6009);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.open(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_open_node"



	// $ANTLR start "cursor_close_node"
	// PhoenixSQL.g:919:1: cursor_close_node returns [CloseStatement ret] : CLOSE c= cursor_name ;
	public final CloseStatement cursor_close_node() throws RecognitionException {
		CloseStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:920:5: ( CLOSE c= cursor_name )
			// PhoenixSQL.g:920:10: CLOSE c= cursor_name
			{
			match(input,CLOSE,FOLLOW_CLOSE_in_cursor_close_node6036); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_close_node6040);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.close(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_close_node"



	// $ANTLR start "cursor_fetch_node"
	// PhoenixSQL.g:923:1: cursor_fetch_node returns [FetchStatement ret] : FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name ;
	public final FetchStatement cursor_fetch_node() throws RecognitionException {
		FetchStatement ret = null;


		Token a=null;
		CursorName c =null;

		try {
			// PhoenixSQL.g:924:5: ( FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name )
			// PhoenixSQL.g:924:10: FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name
			{
			match(input,FETCH,FOLLOW_FETCH_in_cursor_fetch_node6066); if (state.failed) return ret;
			match(input,NEXT,FOLLOW_NEXT_in_cursor_fetch_node6068); if (state.failed) return ret;
			// PhoenixSQL.g:924:21: (a= NUMBER )?
			int alt141=2;
			int LA141_0 = input.LA(1);
			if ( (LA141_0==NUMBER) ) {
				alt141=1;
			}
			switch (alt141) {
				case 1 :
					// PhoenixSQL.g:924:22: a= NUMBER
					{
					a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_cursor_fetch_node6073); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:924:33: ( ROW | ROWS )?
			int alt142=2;
			int LA142_0 = input.LA(1);
			if ( ((LA142_0 >= ROW && LA142_0 <= ROWS)) ) {
				alt142=1;
			}
			switch (alt142) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_cursor_fetch_node6084); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_fetch_node6088);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.fetch(c,true, a == null ? 1 :  Integer.parseInt( a.getText() )); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_fetch_node"



	// $ANTLR start "delete_node"
	// PhoenixSQL.g:928:1: delete_node returns [DeleteStatement ret] : DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? rc= ( RETURNING ASTERISK )? ;
	public final DeleteStatement delete_node() throws RecognitionException {
		DeleteStatement ret = null;


		Token rc=null;
		HintNode hint =null;
		TableName t =null;
		ParseNode v =null;
		List<OrderByNode> order =null;
		LimitNode l =null;

		try {
			// PhoenixSQL.g:929:5: ( DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? rc= ( RETURNING ASTERISK )? )
			// PhoenixSQL.g:929:9: DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? rc= ( RETURNING ASTERISK )?
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_node6114); if (state.failed) return ret;
			// PhoenixSQL.g:929:16: (hint= hintClause )?
			int alt143=2;
			int LA143_0 = input.LA(1);
			if ( (LA143_0==ML_HINT) ) {
				alt143=1;
			}
			switch (alt143) {
				case 1 :
					// PhoenixSQL.g:929:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_delete_node6119);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_delete_node6123); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_delete_node6127);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:930:9: ( WHERE v= expression )?
			int alt144=2;
			int LA144_0 = input.LA(1);
			if ( (LA144_0==WHERE) ) {
				alt144=1;
			}
			switch (alt144) {
				case 1 :
					// PhoenixSQL.g:930:10: WHERE v= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_delete_node6138); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_delete_node6142);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:931:9: ( ORDER BY order= order_by )?
			int alt145=2;
			int LA145_0 = input.LA(1);
			if ( (LA145_0==ORDER) ) {
				alt145=1;
			}
			switch (alt145) {
				case 1 :
					// PhoenixSQL.g:931:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_delete_node6155); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_delete_node6157); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_delete_node6161);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:932:9: ( LIMIT l= limit )?
			int alt146=2;
			int LA146_0 = input.LA(1);
			if ( (LA146_0==LIMIT) ) {
				alt146=1;
			}
			switch (alt146) {
				case 1 :
					// PhoenixSQL.g:932:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_delete_node6174); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_delete_node6178);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:933:12: ( RETURNING ASTERISK )?
			int alt147=2;
			int LA147_0 = input.LA(1);
			if ( (LA147_0==RETURNING) ) {
				alt147=1;
			}
			switch (alt147) {
				case 1 :
					// PhoenixSQL.g:933:13: RETURNING ASTERISK
					{
					rc=(Token)match(input,RETURNING,FOLLOW_RETURNING_in_delete_node6193); if (state.failed) return ret;
					rc=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_delete_node6195); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.delete(factory.namedTable(null,t), hint, v, order, l, getBindCount(), new
			        HashMap<String, UDFParseNode>(udfParseNodes), rc != null ? true : false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_node"



	// $ANTLR start "limit"
	// PhoenixSQL.g:938:1: limit returns [LimitNode ret] : (b= bind_expression |l= int_or_long_literal );
	public final LimitNode limit() throws RecognitionException {
		LimitNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:939:5: (b= bind_expression |l= int_or_long_literal )
			int alt148=2;
			int LA148_0 = input.LA(1);
			if ( (LA148_0==BIND_NAME||LA148_0==QUESTION) ) {
				alt148=1;
			}
			else if ( (LA148_0==NUMBER) ) {
				alt148=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 148, 0, input);
				throw nvae;
			}

			switch (alt148) {
				case 1 :
					// PhoenixSQL.g:939:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_limit6230);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(b); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:940:7: l= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_limit6242);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(l); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "limit"



	// $ANTLR start "offset"
	// PhoenixSQL.g:943:1: offset returns [OffsetNode ret] : (b= bind_expression ( ROW | ROWS )? |l= int_or_long_literal ( ROW | ROWS )? | LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN );
	public final OffsetNode offset() throws RecognitionException {
		OffsetNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;
		List<ParseNode> lhs =null;
		List<ParseNode> rhs =null;

		try {
			// PhoenixSQL.g:944:2: (b= bind_expression ( ROW | ROWS )? |l= int_or_long_literal ( ROW | ROWS )? | LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN )
			int alt151=3;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case QUESTION:
				{
				alt151=1;
				}
				break;
			case NUMBER:
				{
				alt151=2;
				}
				break;
			case LPAREN:
				{
				alt151=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 151, 0, input);
				throw nvae;
			}
			switch (alt151) {
				case 1 :
					// PhoenixSQL.g:944:4: b= bind_expression ( ROW | ROWS )?
					{
					pushFollow(FOLLOW_bind_expression_in_offset6268);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:944:22: ( ROW | ROWS )?
					int alt149=2;
					int LA149_0 = input.LA(1);
					if ( ((LA149_0 >= ROW && LA149_0 <= ROWS)) ) {
						alt149=1;
					}
					switch (alt149) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					if ( state.backtracking==0 ) {  try { ret = factory.offset(b); } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;
				case 2 :
					// PhoenixSQL.g:945:7: l= int_or_long_literal ( ROW | ROWS )?
					{
					pushFollow(FOLLOW_int_or_long_literal_in_offset6289);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:945:29: ( ROW | ROWS )?
					int alt150=2;
					int LA150_0 = input.LA(1);
					if ( ((LA150_0 >= ROW && LA150_0 <= ROWS)) ) {
						alt150=1;
					}
					switch (alt150) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					if ( state.backtracking==0 ) { try { ret = factory.offset(l); } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;
				case 3 :
					// PhoenixSQL.g:946:7: LPAREN lhs= one_or_more_expressions RPAREN EQ LPAREN rhs= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_offset6308); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_offset6312);
					lhs=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_offset6314); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_offset6316); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_offset6318); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_offset6322);
					rhs=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_offset6324); if (state.failed) return ret;
					if ( state.backtracking==0 ) { try { ret = factory.offset(factory.comparison(CompareOperator.EQUAL,factory.rowValueConstructor(lhs),factory.rowValueConstructor(rhs)));  } catch (SQLException e) { throw new RuntimeException(e); } }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "offset"



	// $ANTLR start "sampling_rate"
	// PhoenixSQL.g:949:1: sampling_rate returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode sampling_rate() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:950:5: (l= literal )
			// PhoenixSQL.g:950:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_sampling_rate6349);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "sampling_rate"



	// $ANTLR start "tableSampleNode"
	// PhoenixSQL.g:953:1: tableSampleNode returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode tableSampleNode() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:954:5: (l= literal )
			// PhoenixSQL.g:954:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_tableSampleNode6374);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "tableSampleNode"



	// $ANTLR start "hintClause"
	// PhoenixSQL.g:957:1: hintClause returns [HintNode ret] : c= ML_HINT ;
	public final HintNode hintClause() throws RecognitionException {
		HintNode ret = null;


		Token c=null;

		try {
			// PhoenixSQL.g:958:5: (c= ML_HINT )
			// PhoenixSQL.g:958:8: c= ML_HINT
			{
			c=(Token)match(input,ML_HINT,FOLLOW_ML_HINT_in_hintClause6400); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.hint(c.getText()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "hintClause"



	// $ANTLR start "select_list"
	// PhoenixSQL.g:962:1: select_list returns [List<AliasedNode> ret] : (n= selectable ( COMMA n= selectable )* | ASTERISK );
	public final List<AliasedNode> select_list() throws RecognitionException {
		List<AliasedNode> ret = null;


		AliasedNode n =null;

		ret = new ArrayList<AliasedNode>();
		try {
			// PhoenixSQL.g:964:5: (n= selectable ( COMMA n= selectable )* | ASTERISK )
			int alt153=2;
			int LA153_0 = input.LA(1);
			if ( (LA153_0==ARRAY||LA153_0==BIND_NAME||LA153_0==BIN_LITERAL||(LA153_0 >= CASE && LA153_0 <= CAST)||LA153_0==CURRENT||LA153_0==DECIMAL||LA153_0==DOUBLE||LA153_0==EXISTS||LA153_0==FALSE||LA153_0==HEX_LITERAL||LA153_0==LPAREN||LA153_0==MINUS||(LA153_0 >= NAME && LA153_0 <= NEXT)||LA153_0==NOT||LA153_0==NULL||LA153_0==NUMBER||LA153_0==QUESTION||LA153_0==STRING_LITERAL||LA153_0==TRUE) ) {
				alt153=1;
			}
			else if ( (LA153_0==ASTERISK) ) {
				alt153=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 153, 0, input);
				throw nvae;
			}

			switch (alt153) {
				case 1 :
					// PhoenixSQL.g:964:9: n= selectable ( COMMA n= selectable )*
					{
					pushFollow(FOLLOW_selectable_in_select_list6432);
					n=selectable();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(n);}
					// PhoenixSQL.g:964:36: ( COMMA n= selectable )*
					loop152:
					while (true) {
						int alt152=2;
						int LA152_0 = input.LA(1);
						if ( (LA152_0==COMMA) ) {
							alt152=1;
						}

						switch (alt152) {
						case 1 :
							// PhoenixSQL.g:964:37: COMMA n= selectable
							{
							match(input,COMMA,FOLLOW_COMMA_in_select_list6437); if (state.failed) return ret;
							pushFollow(FOLLOW_selectable_in_select_list6441);
							n=selectable();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret.add(n);}
							}
							break;

						default :
							break loop152;
						}
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:965:7: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_select_list6453); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = Collections.<AliasedNode>singletonList(factory.aliasedNode(null, factory.wildcard()));}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "select_list"



	// $ANTLR start "selectable"
	// PhoenixSQL.g:969:1: selectable returns [AliasedNode ret] : (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK );
	public final AliasedNode selectable() throws RecognitionException {
		AliasedNode ret = null;


		ParseNode field =null;
		String a =null;
		String familyName =null;
		String s =null;
		String t =null;

		try {
			// PhoenixSQL.g:970:5: (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK )
			int alt155=3;
			int LA155_0 = input.LA(1);
			if ( (LA155_0==ARRAY||LA155_0==BIND_NAME||LA155_0==BIN_LITERAL||(LA155_0 >= CASE && LA155_0 <= CAST)||LA155_0==CURRENT||LA155_0==DECIMAL||LA155_0==DOUBLE||LA155_0==EXISTS||LA155_0==FALSE||LA155_0==HEX_LITERAL||LA155_0==LPAREN||LA155_0==MINUS||LA155_0==NEXT||LA155_0==NOT||LA155_0==NULL||LA155_0==NUMBER||LA155_0==QUESTION||LA155_0==STRING_LITERAL||LA155_0==TRUE) ) {
				alt155=1;
			}
			else if ( (LA155_0==NAME) ) {
				int LA155_2 = input.LA(2);
				if ( (LA155_2==EOF||LA155_2==AND||LA155_2==AS||LA155_2==ASTERISK||LA155_2==BETWEEN||LA155_2==COMMA||LA155_2==CONCAT||LA155_2==DIVIDE||LA155_2==EQ||LA155_2==FETCH||LA155_2==FROM||(LA155_2 >= GROUP && LA155_2 <= HAVING)||LA155_2==ILIKE||LA155_2==IN||LA155_2==IS||(LA155_2 >= LIKE && LA155_2 <= LIMIT)||(LA155_2 >= LPAREN && LA155_2 <= LT)||LA155_2==MINUS||LA155_2==NAME||(LA155_2 >= NOEQ1 && LA155_2 <= NOT)||LA155_2==OFFSET||(LA155_2 >= OR && LA155_2 <= ORDER)||(LA155_2 >= PERCENT && LA155_2 <= PLUS)||LA155_2==RETURNING||LA155_2==RPAREN||LA155_2==SEMICOLON||LA155_2==STRING_LITERAL||LA155_2==UNION||LA155_2==WHERE) ) {
					alt155=1;
				}
				else if ( (LA155_2==DOT) ) {
					int LA155_3 = input.LA(3);
					if ( (LA155_3==ASTERISK) ) {
						alt155=2;
					}
					else if ( (LA155_3==NAME) ) {
						int LA155_5 = input.LA(4);
						if ( (LA155_5==EOF||LA155_5==AND||LA155_5==AS||LA155_5==ASTERISK||LA155_5==BETWEEN||LA155_5==COMMA||LA155_5==CONCAT||LA155_5==DIVIDE||LA155_5==EQ||LA155_5==FETCH||LA155_5==FROM||(LA155_5 >= GROUP && LA155_5 <= HAVING)||LA155_5==ILIKE||LA155_5==IN||LA155_5==IS||(LA155_5 >= LIKE && LA155_5 <= LIMIT)||(LA155_5 >= LSQUARE && LA155_5 <= LT)||LA155_5==MINUS||LA155_5==NAME||(LA155_5 >= NOEQ1 && LA155_5 <= NOT)||LA155_5==OFFSET||(LA155_5 >= OR && LA155_5 <= ORDER)||(LA155_5 >= PERCENT && LA155_5 <= PLUS)||LA155_5==RETURNING||LA155_5==RPAREN||LA155_5==SEMICOLON||LA155_5==UNION||LA155_5==WHERE) ) {
							alt155=1;
						}
						else if ( (LA155_5==DOT) ) {
							int LA155_6 = input.LA(5);
							if ( (LA155_6==ASTERISK) ) {
								alt155=3;
							}
							else if ( (LA155_6==NAME) ) {
								alt155=1;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 155, 6, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 155, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 155, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 155, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 155, 0, input);
				throw nvae;
			}

			switch (alt155) {
				case 1 :
					// PhoenixSQL.g:970:9: field= expression (a= parseAlias )?
					{
					pushFollow(FOLLOW_expression_in_selectable6482);
					field=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:970:26: (a= parseAlias )?
					int alt154=2;
					int LA154_0 = input.LA(1);
					if ( (LA154_0==AS||LA154_0==NAME) ) {
						alt154=1;
					}
					switch (alt154) {
						case 1 :
							// PhoenixSQL.g:970:27: a= parseAlias
							{
							pushFollow(FOLLOW_parseAlias_in_selectable6487);
							a=parseAlias();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.aliasedNode(a, field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:971:8: familyName= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable6502);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable6504); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable6506); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.family(familyName));}
					}
					break;
				case 3 :
					// PhoenixSQL.g:972:9: s= identifier DOT t= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable6521);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable6523); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_selectable6527);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable6529); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable6531); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.tableWildcard(factory.table(s, t))); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "selectable"



	// $ANTLR start "group_by"
	// PhoenixSQL.g:977:1: group_by returns [List<ParseNode> ret] : expr= expression ( COMMA expr= expression )* ;
	public final List<ParseNode> group_by() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode expr =null;

		ret = new ArrayList<ParseNode>();
		try {
			// PhoenixSQL.g:979:5: (expr= expression ( COMMA expr= expression )* )
			// PhoenixSQL.g:979:9: expr= expression ( COMMA expr= expression )*
			{
			pushFollow(FOLLOW_expression_in_group_by6564);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(expr); }
			// PhoenixSQL.g:980:9: ( COMMA expr= expression )*
			loop156:
			while (true) {
				int alt156=2;
				int LA156_0 = input.LA(1);
				if ( (LA156_0==COMMA) ) {
					alt156=1;
				}

				switch (alt156) {
				case 1 :
					// PhoenixSQL.g:980:10: COMMA expr= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_group_by6577); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_group_by6583);
					expr=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(expr); }
					}
					break;

				default :
					break loop156;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "group_by"



	// $ANTLR start "order_by"
	// PhoenixSQL.g:984:1: order_by returns [List<OrderByNode> ret] : field= parseOrderByField ( COMMA field= parseOrderByField )* ;
	public final List<OrderByNode> order_by() throws RecognitionException {
		List<OrderByNode> ret = null;


		OrderByNode field =null;

		ret = new ArrayList<OrderByNode>();
		try {
			// PhoenixSQL.g:986:5: (field= parseOrderByField ( COMMA field= parseOrderByField )* )
			// PhoenixSQL.g:986:9: field= parseOrderByField ( COMMA field= parseOrderByField )*
			{
			pushFollow(FOLLOW_parseOrderByField_in_order_by6617);
			field=parseOrderByField();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(field); }
			// PhoenixSQL.g:987:9: ( COMMA field= parseOrderByField )*
			loop157:
			while (true) {
				int alt157=2;
				int LA157_0 = input.LA(1);
				if ( (LA157_0==COMMA) ) {
					alt157=1;
				}

				switch (alt157) {
				case 1 :
					// PhoenixSQL.g:987:10: COMMA field= parseOrderByField
					{
					match(input,COMMA,FOLLOW_COMMA_in_order_by6630); if (state.failed) return ret;
					pushFollow(FOLLOW_parseOrderByField_in_order_by6636);
					field=parseOrderByField();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(field); }
					}
					break;

				default :
					break loop157;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "order_by"



	// $ANTLR start "parseOrderByField"
	// PhoenixSQL.g:991:1: parseOrderByField returns [OrderByNode ret] : (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? ;
	public final OrderByNode parseOrderByField() throws RecognitionException {
		OrderByNode ret = null;


		ParseNode expr =null;

		boolean isAscending = true; boolean nullsLast = false;
		try {
			// PhoenixSQL.g:993:5: ( (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? )
			// PhoenixSQL.g:993:9: (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )?
			{
			// PhoenixSQL.g:993:9: (expr= expression )
			// PhoenixSQL.g:993:10: expr= expression
			{
			pushFollow(FOLLOW_expression_in_parseOrderByField6673);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:994:9: ( ASC | DESC )?
			int alt158=3;
			int LA158_0 = input.LA(1);
			if ( (LA158_0==ASC) ) {
				alt158=1;
			}
			else if ( (LA158_0==DESC) ) {
				alt158=2;
			}
			switch (alt158) {
				case 1 :
					// PhoenixSQL.g:994:10: ASC
					{
					match(input,ASC,FOLLOW_ASC_in_parseOrderByField6685); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = true;}
					}
					break;
				case 2 :
					// PhoenixSQL.g:994:38: DESC
					{
					match(input,DESC,FOLLOW_DESC_in_parseOrderByField6691); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = false;}
					}
					break;

			}

			// PhoenixSQL.g:995:9: ( NULLS ( FIRST | LAST ) )?
			int alt160=2;
			int LA160_0 = input.LA(1);
			if ( (LA160_0==NULLS) ) {
				alt160=1;
			}
			switch (alt160) {
				case 1 :
					// PhoenixSQL.g:995:10: NULLS ( FIRST | LAST )
					{
					match(input,NULLS,FOLLOW_NULLS_in_parseOrderByField6706); if (state.failed) return ret;
					// PhoenixSQL.g:995:16: ( FIRST | LAST )
					int alt159=2;
					int LA159_0 = input.LA(1);
					if ( (LA159_0==FIRST) ) {
						alt159=1;
					}
					else if ( (LA159_0==LAST) ) {
						alt159=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 159, 0, input);
						throw nvae;
					}

					switch (alt159) {
						case 1 :
							// PhoenixSQL.g:995:17: FIRST
							{
							match(input,FIRST,FOLLOW_FIRST_in_parseOrderByField6709); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = false;}
							}
							break;
						case 2 :
							// PhoenixSQL.g:995:46: LAST
							{
							match(input,LAST,FOLLOW_LAST_in_parseOrderByField6715); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = true;}
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.orderBy(expr, nullsLast, isAscending); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseOrderByField"



	// $ANTLR start "parseFrom"
	// PhoenixSQL.g:999:1: parseFrom returns [TableNode ret] : t= table_list ;
	public final TableNode parseFrom() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;

		try {
			// PhoenixSQL.g:1000:5: (t= table_list )
			// PhoenixSQL.g:1000:9: t= table_list
			{
			pushFollow(FOLLOW_table_list_in_parseFrom6755);
			t=table_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseFrom"



	// $ANTLR start "table_list"
	// PhoenixSQL.g:1003:1: table_list returns [TableNode ret] : t= table_ref ( COMMA s= table_ref )* ;
	public final TableNode table_list() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		TableNode s =null;

		try {
			// PhoenixSQL.g:1004:5: (t= table_ref ( COMMA s= table_ref )* )
			// PhoenixSQL.g:1004:9: t= table_ref ( COMMA s= table_ref )*
			{
			pushFollow(FOLLOW_table_ref_in_table_list6786);
			t=table_ref();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			// PhoenixSQL.g:1004:33: ( COMMA s= table_ref )*
			loop161:
			while (true) {
				int alt161=2;
				int LA161_0 = input.LA(1);
				if ( (LA161_0==COMMA) ) {
					alt161=1;
				}

				switch (alt161) {
				case 1 :
					// PhoenixSQL.g:1004:34: COMMA s= table_ref
					{
					match(input,COMMA,FOLLOW_COMMA_in_table_list6791); if (state.failed) return ret;
					pushFollow(FOLLOW_table_ref_in_table_list6795);
					s=table_ref();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(JoinTableNode.JoinType.Inner, ret, s, null, false); }
					}
					break;

				default :
					break loop161;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_list"



	// $ANTLR start "table_ref"
	// PhoenixSQL.g:1007:1: table_ref returns [TableNode ret] : l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* ;
	public final TableNode table_ref() throws RecognitionException {
		TableNode ret = null;


		TableNode l =null;
		JoinTableNode.JoinType j =null;
		TableNode r =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:1008:2: (l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* )
			// PhoenixSQL.g:1008:4: l= table_factor (j= join_type JOIN r= table_factor ON e= expression )*
			{
			pushFollow(FOLLOW_table_factor_in_table_ref6819);
			l=table_factor();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			// PhoenixSQL.g:1008:33: (j= join_type JOIN r= table_factor ON e= expression )*
			loop162:
			while (true) {
				int alt162=2;
				int LA162_0 = input.LA(1);
				if ( (LA162_0==FULL||LA162_0==INNER||LA162_0==JOIN||LA162_0==LEFT||LA162_0==RIGHT) ) {
					alt162=1;
				}

				switch (alt162) {
				case 1 :
					// PhoenixSQL.g:1008:34: j= join_type JOIN r= table_factor ON e= expression
					{
					pushFollow(FOLLOW_join_type_in_table_ref6826);
					j=join_type();
					state._fsp--;
					if (state.failed) return ret;
					match(input,JOIN,FOLLOW_JOIN_in_table_ref6828); if (state.failed) return ret;
					pushFollow(FOLLOW_table_factor_in_table_ref6832);
					r=table_factor();
					state._fsp--;
					if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_table_ref6834); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_table_ref6838);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(j, ret, r, e, false); }
					}
					break;

				default :
					break loop162;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_ref"



	// $ANTLR start "table_factor"
	// PhoenixSQL.g:1011:1: table_factor returns [TableNode ret] : ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? );
	public final TableNode table_factor() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		String n =null;
		String alias =null;
		TableName f =null;
		List<ColumnDef> cdefs =null;
		LiteralParseNode tableSample =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:1012:5: ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? )
			int alt171=4;
			switch ( input.LA(1) ) {
			case LPAREN:
				{
				int LA171_1 = input.LA(2);
				if ( (LA171_1==BIND_NAME||LA171_1==LPAREN||LA171_1==NAME||LA171_1==QUESTION) ) {
					alt171=1;
				}
				else if ( (LA171_1==SELECT) ) {
					alt171=4;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 171, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case BIND_NAME:
			case QUESTION:
				{
				alt171=2;
				}
				break;
			case NAME:
				{
				alt171=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 171, 0, input);
				throw nvae;
			}
			switch (alt171) {
				case 1 :
					// PhoenixSQL.g:1012:9: LPAREN t= table_list RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6862); if (state.failed) return ret;
					pushFollow(FOLLOW_table_list_in_table_factor6866);
					t=table_list();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6868); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = t; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1013:9: n= bind_name ( ( AS )? alias= identifier )?
					{
					pushFollow(FOLLOW_bind_name_in_table_factor6882);
					n=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1013:21: ( ( AS )? alias= identifier )?
					int alt164=2;
					int LA164_0 = input.LA(1);
					if ( (LA164_0==AS||LA164_0==NAME) ) {
						alt164=1;
					}
					switch (alt164) {
						case 1 :
							// PhoenixSQL.g:1013:22: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:1013:22: ( AS )?
							int alt163=2;
							int LA163_0 = input.LA(1);
							if ( (LA163_0==AS) ) {
								alt163=1;
							}
							switch (alt163) {
								case 1 :
									// PhoenixSQL.g:1013:23: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6886); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6892);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.bindTable(alias, factory.table(null,n)); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1014:9: f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					{
					pushFollow(FOLLOW_from_table_name_in_table_factor6909);
					f=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1014:27: ( ( AS )? alias= identifier )?
					int alt166=2;
					int LA166_0 = input.LA(1);
					if ( (LA166_0==AS||LA166_0==NAME) ) {
						alt166=1;
					}
					switch (alt166) {
						case 1 :
							// PhoenixSQL.g:1014:28: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:1014:28: ( AS )?
							int alt165=2;
							int LA165_0 = input.LA(1);
							if ( (LA165_0==AS) ) {
								alt165=1;
							}
							switch (alt165) {
								case 1 :
									// PhoenixSQL.g:1014:29: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6913); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6919);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:1014:53: ( LPAREN cdefs= dyn_column_defs RPAREN )?
					int alt167=2;
					int LA167_0 = input.LA(1);
					if ( (LA167_0==LPAREN) ) {
						alt167=1;
					}
					switch (alt167) {
						case 1 :
							// PhoenixSQL.g:1014:54: LPAREN cdefs= dyn_column_defs RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6924); if (state.failed) return ret;
							pushFollow(FOLLOW_dyn_column_defs_in_table_factor6928);
							cdefs=dyn_column_defs();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6930); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:1014:92: ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					int alt168=2;
					int LA168_0 = input.LA(1);
					if ( (LA168_0==TABLESAMPLE) ) {
						alt168=1;
					}
					switch (alt168) {
						case 1 :
							// PhoenixSQL.g:1014:93: TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN
							{
							match(input,TABLESAMPLE,FOLLOW_TABLESAMPLE_in_table_factor6935); if (state.failed) return ret;
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6937); if (state.failed) return ret;
							pushFollow(FOLLOW_tableSampleNode_in_table_factor6941);
							tableSample=tableSampleNode();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6943); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.namedTable(alias,f,cdefs, tableSample);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:1015:9: LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )?
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor6957); if (state.failed) return ret;
					pushFollow(FOLLOW_select_node_in_table_factor6961);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor6963); if (state.failed) return ret;
					// PhoenixSQL.g:1015:37: ( ( AS )? alias= identifier )?
					int alt170=2;
					int LA170_0 = input.LA(1);
					if ( (LA170_0==AS||LA170_0==NAME) ) {
						alt170=1;
					}
					switch (alt170) {
						case 1 :
							// PhoenixSQL.g:1015:38: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:1015:38: ( AS )?
							int alt169=2;
							int LA169_0 = input.LA(1);
							if ( (LA169_0==AS) ) {
								alt169=1;
							}
							switch (alt169) {
								case 1 :
									// PhoenixSQL.g:1015:39: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor6967); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor6973);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.derivedTable(alias, s); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_factor"



	// $ANTLR start "join_type"
	// PhoenixSQL.g:1018:1: join_type returns [JoinTableNode.JoinType ret] : ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? );
	public final JoinTableNode.JoinType join_type() throws RecognitionException {
		JoinTableNode.JoinType ret = null;


		try {
			// PhoenixSQL.g:1019:5: ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? )
			int alt176=4;
			switch ( input.LA(1) ) {
			case INNER:
			case JOIN:
				{
				alt176=1;
				}
				break;
			case LEFT:
				{
				alt176=2;
				}
				break;
			case RIGHT:
				{
				alt176=3;
				}
				break;
			case FULL:
				{
				alt176=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 176, 0, input);
				throw nvae;
			}
			switch (alt176) {
				case 1 :
					// PhoenixSQL.g:1019:9: ( INNER )?
					{
					// PhoenixSQL.g:1019:9: ( INNER )?
					int alt172=2;
					int LA172_0 = input.LA(1);
					if ( (LA172_0==INNER) ) {
						alt172=1;
					}
					switch (alt172) {
						case 1 :
							// PhoenixSQL.g:1019:9: INNER
							{
							match(input,INNER,FOLLOW_INNER_in_join_type7000); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Inner; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1020:9: LEFT ( OUTER )?
					{
					match(input,LEFT,FOLLOW_LEFT_in_join_type7015); if (state.failed) return ret;
					// PhoenixSQL.g:1020:14: ( OUTER )?
					int alt173=2;
					int LA173_0 = input.LA(1);
					if ( (LA173_0==OUTER) ) {
						alt173=1;
					}
					switch (alt173) {
						case 1 :
							// PhoenixSQL.g:1020:14: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type7017); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Left; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1021:9: RIGHT ( OUTER )?
					{
					match(input,RIGHT,FOLLOW_RIGHT_in_join_type7032); if (state.failed) return ret;
					// PhoenixSQL.g:1021:15: ( OUTER )?
					int alt174=2;
					int LA174_0 = input.LA(1);
					if ( (LA174_0==OUTER) ) {
						alt174=1;
					}
					switch (alt174) {
						case 1 :
							// PhoenixSQL.g:1021:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type7034); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Right; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:1022:9: FULL ( OUTER )?
					{
					match(input,FULL,FOLLOW_FULL_in_join_type7048); if (state.failed) return ret;
					// PhoenixSQL.g:1022:15: ( OUTER )?
					int alt175=2;
					int LA175_0 = input.LA(1);
					if ( (LA175_0==OUTER) ) {
						alt175=1;
					}
					switch (alt175) {
						case 1 :
							// PhoenixSQL.g:1022:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type7051); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Full; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "join_type"



	// $ANTLR start "parseAlias"
	// PhoenixSQL.g:1025:1: parseAlias returns [String ret] : ( AS )? alias= parseNoReserved ;
	public final String parseAlias() throws RecognitionException {
		String ret = null;


		String alias =null;

		try {
			// PhoenixSQL.g:1026:5: ( ( AS )? alias= parseNoReserved )
			// PhoenixSQL.g:1026:9: ( AS )? alias= parseNoReserved
			{
			// PhoenixSQL.g:1026:9: ( AS )?
			int alt177=2;
			int LA177_0 = input.LA(1);
			if ( (LA177_0==AS) ) {
				alt177=1;
			}
			switch (alt177) {
				case 1 :
					// PhoenixSQL.g:1026:9: AS
					{
					match(input,AS,FOLLOW_AS_in_parseAlias7082); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_parseNoReserved_in_parseAlias7087);
			alias=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = alias; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseAlias"



	// $ANTLR start "expression"
	// PhoenixSQL.g:1030:1: expression returns [ParseNode ret] : e= or_expression ;
	public final ParseNode expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;

		try {
			// PhoenixSQL.g:1031:5: (e= or_expression )
			// PhoenixSQL.g:1031:9: e= or_expression
			{
			pushFollow(FOLLOW_or_expression_in_expression7115);
			e=or_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = e; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression"



	// $ANTLR start "or_expression"
	// PhoenixSQL.g:1035:1: or_expression returns [ParseNode ret] : i= and_expression ( OR i= and_expression )* ;
	public final ParseNode or_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:1037:5: (i= and_expression ( OR i= and_expression )* )
			// PhoenixSQL.g:1037:9: i= and_expression ( OR i= and_expression )*
			{
			pushFollow(FOLLOW_and_expression_in_or_expression7147);
			i=and_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:1037:38: ( OR i= and_expression )*
			loop178:
			while (true) {
				int alt178=2;
				int LA178_0 = input.LA(1);
				if ( (LA178_0==OR) ) {
					alt178=1;
				}

				switch (alt178) {
				case 1 :
					// PhoenixSQL.g:1037:39: OR i= and_expression
					{
					match(input,OR,FOLLOW_OR_in_or_expression7152); if (state.failed) return ret;
					pushFollow(FOLLOW_and_expression_in_or_expression7156);
					i=and_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop178;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.or(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "or_expression"



	// $ANTLR start "and_expression"
	// PhoenixSQL.g:1041:1: and_expression returns [ParseNode ret] : i= not_expression ( AND i= not_expression )* ;
	public final ParseNode and_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:1043:5: (i= not_expression ( AND i= not_expression )* )
			// PhoenixSQL.g:1043:9: i= not_expression ( AND i= not_expression )*
			{
			pushFollow(FOLLOW_not_expression_in_and_expression7192);
			i=not_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:1043:38: ( AND i= not_expression )*
			loop179:
			while (true) {
				int alt179=2;
				int LA179_0 = input.LA(1);
				if ( (LA179_0==AND) ) {
					alt179=1;
				}

				switch (alt179) {
				case 1 :
					// PhoenixSQL.g:1043:39: AND i= not_expression
					{
					match(input,AND,FOLLOW_AND_in_and_expression7197); if (state.failed) return ret;
					pushFollow(FOLLOW_not_expression_in_and_expression7201);
					i=not_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop179;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.and(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "and_expression"



	// $ANTLR start "not_expression"
	// PhoenixSQL.g:1047:1: not_expression returns [ParseNode ret] : ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN );
	public final ParseNode not_expression() throws RecognitionException {
		ParseNode ret = null;


		Token n=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:1048:5: ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN )
			int alt182=2;
			int LA182_0 = input.LA(1);
			if ( (LA182_0==NOT) ) {
				int LA182_1 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt182=1;
				}
				else if ( (true) ) {
					alt182=2;
				}

			}
			else if ( (LA182_0==MINUS) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==HEX_LITERAL) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==BIN_LITERAL) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==STRING_LITERAL) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==NUMBER) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==DECIMAL) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==DOUBLE) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==NULL) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==TRUE) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==FALSE) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==NAME) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==BIND_NAME) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==QUESTION) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==ARRAY) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==CASE) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==LPAREN) ) {
				int LA182_17 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt182=1;
				}
				else if ( (true) ) {
					alt182=2;
				}

			}
			else if ( (LA182_0==CAST) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==NEXT) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==CURRENT) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}
			else if ( (LA182_0==EXISTS) && (synpred1_PhoenixSQL())) {
				alt182=1;
			}

			switch (alt182) {
				case 1 :
					// PhoenixSQL.g:1048:9: ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression
					{
					// PhoenixSQL.g:1048:40: (n= NOT )?
					int alt180=2;
					int LA180_0 = input.LA(1);
					if ( (LA180_0==NOT) ) {
						alt180=1;
					}
					switch (alt180) {
						case 1 :
							// PhoenixSQL.g:1048:40: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression7243); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_boolean_expression_in_not_expression7248);
					e=boolean_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1049:9: (n= NOT )? LPAREN e= expression RPAREN
					{
					// PhoenixSQL.g:1049:10: (n= NOT )?
					int alt181=2;
					int LA181_0 = input.LA(1);
					if ( (LA181_0==NOT) ) {
						alt181=1;
					}
					switch (alt181) {
						case 1 :
							// PhoenixSQL.g:1049:10: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression7262); if (state.failed) return ret;
							}
							break;

					}

					match(input,LPAREN,FOLLOW_LPAREN_in_not_expression7265); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_not_expression7269);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_not_expression7271); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "not_expression"



	// $ANTLR start "comparison_op"
	// PhoenixSQL.g:1052:1: comparison_op returns [CompareOperator ret] : ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) );
	public final CompareOperator comparison_op() throws RecognitionException {
		CompareOperator ret = null;


		try {
			// PhoenixSQL.g:1053:2: ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) )
			int alt183=6;
			switch ( input.LA(1) ) {
			case EQ:
				{
				alt183=1;
				}
				break;
			case LT:
				{
				int LA183_2 = input.LA(2);
				if ( (LA183_2==EQ) ) {
					alt183=4;
				}
				else if ( (LA183_2==ALL||(LA183_2 >= ANY && LA183_2 <= ARRAY)||LA183_2==BIND_NAME||LA183_2==BIN_LITERAL||(LA183_2 >= CASE && LA183_2 <= CAST)||LA183_2==CURRENT||LA183_2==DECIMAL||LA183_2==DOUBLE||LA183_2==FALSE||LA183_2==HEX_LITERAL||LA183_2==LPAREN||LA183_2==MINUS||(LA183_2 >= NAME && LA183_2 <= NEXT)||LA183_2==NULL||LA183_2==NUMBER||LA183_2==QUESTION||LA183_2==STRING_LITERAL||LA183_2==TRUE) ) {
					alt183=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 183, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case GT:
				{
				int LA183_3 = input.LA(2);
				if ( (LA183_3==EQ) ) {
					alt183=5;
				}
				else if ( (LA183_3==ALL||(LA183_3 >= ANY && LA183_3 <= ARRAY)||LA183_3==BIND_NAME||LA183_3==BIN_LITERAL||(LA183_3 >= CASE && LA183_3 <= CAST)||LA183_3==CURRENT||LA183_3==DECIMAL||LA183_3==DOUBLE||LA183_3==FALSE||LA183_3==HEX_LITERAL||LA183_3==LPAREN||LA183_3==MINUS||(LA183_3 >= NAME && LA183_3 <= NEXT)||LA183_3==NULL||LA183_3==NUMBER||LA183_3==QUESTION||LA183_3==STRING_LITERAL||LA183_3==TRUE) ) {
					alt183=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 183, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NOEQ1:
			case NOEQ2:
				{
				alt183=6;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 183, 0, input);
				throw nvae;
			}
			switch (alt183) {
				case 1 :
					// PhoenixSQL.g:1053:4: EQ
					{
					match(input,EQ,FOLLOW_EQ_in_comparison_op7291); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.EQUAL; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1054:4: LT
					{
					match(input,LT,FOLLOW_LT_in_comparison_op7298); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.LESS; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1055:4: GT
					{
					match(input,GT,FOLLOW_GT_in_comparison_op7305); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.GREATER; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:1056:4: LT EQ
					{
					match(input,LT,FOLLOW_LT_in_comparison_op7312); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op7314); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.LESS_OR_EQUAL; }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1057:4: GT EQ
					{
					match(input,GT,FOLLOW_GT_in_comparison_op7321); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op7323); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.GREATER_OR_EQUAL; }
					}
					break;
				case 6 :
					// PhoenixSQL.g:1058:4: ( NOEQ1 | NOEQ2 )
					{
					if ( (input.LA(1) >= NOEQ1 && input.LA(1) <= NOEQ2) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if ( state.backtracking==0 ) { ret = CompareOperator.NOT_EQUAL; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "comparison_op"



	// $ANTLR start "boolean_expression"
	// PhoenixSQL.g:1061:1: boolean_expression returns [ParseNode ret] : (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN );
	public final ParseNode boolean_expression() throws RecognitionException {
		ParseNode ret = null;


		Token all=null;
		Token any=null;
		Token n=null;
		ParseNode l =null;
		CompareOperator op =null;
		ParseNode r =null;
		ParseNode r1 =null;
		ParseNode r2 =null;
		List<ParseNode> v =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:1062:5: (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN )
			int alt192=2;
			int LA192_0 = input.LA(1);
			if ( (LA192_0==ARRAY||LA192_0==BIND_NAME||LA192_0==BIN_LITERAL||(LA192_0 >= CASE && LA192_0 <= CAST)||LA192_0==CURRENT||LA192_0==DECIMAL||LA192_0==DOUBLE||LA192_0==FALSE||LA192_0==HEX_LITERAL||LA192_0==LPAREN||LA192_0==MINUS||(LA192_0 >= NAME && LA192_0 <= NEXT)||LA192_0==NULL||LA192_0==NUMBER||LA192_0==QUESTION||LA192_0==STRING_LITERAL||LA192_0==TRUE) ) {
				alt192=1;
			}
			else if ( (LA192_0==EXISTS) ) {
				alt192=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 192, 0, input);
				throw nvae;
			}

			switch (alt192) {
				case 1 :
					// PhoenixSQL.g:1062:9: l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					{
					pushFollow(FOLLOW_value_expression_in_boolean_expression7361);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1062:28: ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					int alt191=4;
					switch ( input.LA(1) ) {
					case EQ:
					case GT:
					case LT:
					case NOEQ1:
					case NOEQ2:
						{
						alt191=1;
						}
						break;
					case IS:
						{
						alt191=2;
						}
						break;
					case BETWEEN:
					case ILIKE:
					case IN:
					case LIKE:
					case NOT:
						{
						alt191=3;
						}
						break;
					case EOF:
					case AND:
					case AS:
					case ASC:
					case ASYNC:
					case CASCADE:
					case COMMA:
					case CONSTRAINT:
					case DESC:
					case ELSE:
					case ENCODED_QUALIFIER:
					case END:
					case FETCH:
					case FROM:
					case FULL:
					case GROUP:
					case HAVING:
					case INNER:
					case JOIN:
					case LEFT:
					case LIMIT:
					case MAXVALUE:
					case MINVALUE:
					case NAME:
					case NULLS:
					case OFFSET:
					case OR:
					case ORDER:
					case PRIMARY:
					case RETURNING:
					case RIGHT:
					case RPAREN:
					case RSQUARE:
					case SEMICOLON:
					case SPLIT:
					case THEN:
					case UNION:
					case WHEN:
					case WHERE:
						{
						alt191=4;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 191, 0, input);
						throw nvae;
					}
					switch (alt191) {
						case 1 :
							// PhoenixSQL.g:1062:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							{
							// PhoenixSQL.g:1062:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							// PhoenixSQL.g:1062:30: op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							{
							pushFollow(FOLLOW_comparison_op_in_boolean_expression7367);
							op=comparison_op();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:1062:47: (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							int alt186=4;
							switch ( input.LA(1) ) {
							case ARRAY:
							case BIND_NAME:
							case BIN_LITERAL:
							case CASE:
							case CAST:
							case CURRENT:
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case HEX_LITERAL:
							case MINUS:
							case NAME:
							case NEXT:
							case NULL:
							case NUMBER:
							case QUESTION:
							case STRING_LITERAL:
							case TRUE:
								{
								alt186=1;
								}
								break;
							case LPAREN:
								{
								int LA186_2 = input.LA(2);
								if ( (LA186_2==ARRAY||LA186_2==BIND_NAME||LA186_2==BIN_LITERAL||(LA186_2 >= CASE && LA186_2 <= CAST)||LA186_2==CURRENT||LA186_2==DECIMAL||LA186_2==DOUBLE||LA186_2==EXISTS||LA186_2==FALSE||LA186_2==HEX_LITERAL||LA186_2==LPAREN||LA186_2==MINUS||(LA186_2 >= NAME && LA186_2 <= NEXT)||LA186_2==NOT||LA186_2==NULL||LA186_2==NUMBER||LA186_2==QUESTION||LA186_2==STRING_LITERAL||LA186_2==TRUE) ) {
									alt186=1;
								}
								else if ( (LA186_2==SELECT) ) {
									alt186=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 186, 2, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ALL:
								{
								int LA186_3 = input.LA(2);
								if ( (LA186_3==LPAREN) ) {
									int LA186_6 = input.LA(3);
									if ( (LA186_6==ARRAY||LA186_6==BIND_NAME||LA186_6==BIN_LITERAL||(LA186_6 >= CASE && LA186_6 <= CAST)||LA186_6==CURRENT||LA186_6==DECIMAL||LA186_6==DOUBLE||LA186_6==FALSE||LA186_6==HEX_LITERAL||LA186_6==LPAREN||LA186_6==MINUS||(LA186_6 >= NAME && LA186_6 <= NEXT)||LA186_6==NULL||LA186_6==NUMBER||LA186_6==QUESTION||LA186_6==STRING_LITERAL||LA186_6==TRUE) ) {
										alt186=3;
									}
									else if ( (LA186_6==SELECT) ) {
										alt186=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 186, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 186, 3, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ANY:
								{
								int LA186_4 = input.LA(2);
								if ( (LA186_4==LPAREN) ) {
									int LA186_6 = input.LA(3);
									if ( (LA186_6==ARRAY||LA186_6==BIND_NAME||LA186_6==BIN_LITERAL||(LA186_6 >= CASE && LA186_6 <= CAST)||LA186_6==CURRENT||LA186_6==DECIMAL||LA186_6==DOUBLE||LA186_6==FALSE||LA186_6==HEX_LITERAL||LA186_6==LPAREN||LA186_6==MINUS||(LA186_6 >= NAME && LA186_6 <= NEXT)||LA186_6==NULL||LA186_6==NUMBER||LA186_6==QUESTION||LA186_6==STRING_LITERAL||LA186_6==TRUE) ) {
										alt186=3;
									}
									else if ( (LA186_6==SELECT) ) {
										alt186=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 186, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 186, 4, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 186, 0, input);
								throw nvae;
							}
							switch (alt186) {
								case 1 :
									// PhoenixSQL.g:1062:48: r= value_expression
									{
									pushFollow(FOLLOW_value_expression_in_boolean_expression7372);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:1062:69: ( LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:1062:69: ( LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:1062:70: LPAREN r= subquery_expression RPAREN
									{
									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7377); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression7381);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7383); if (state.failed) return ret;
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:1062:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									{
									// PhoenixSQL.g:1062:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									// PhoenixSQL.g:1062:110: (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN
									{
									// PhoenixSQL.g:1062:110: (all= ALL |any= ANY )
									int alt184=2;
									int LA184_0 = input.LA(1);
									if ( (LA184_0==ALL) ) {
										alt184=1;
									}
									else if ( (LA184_0==ANY) ) {
										alt184=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 184, 0, input);
										throw nvae;
									}

									switch (alt184) {
										case 1 :
											// PhoenixSQL.g:1062:111: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression7392); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:1062:121: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression7398); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7401); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression7405);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7407); if (state.failed) return ret;
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:1062:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:1062:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:1062:168: (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN
									{
									// PhoenixSQL.g:1062:168: (all= ALL |any= ANY )
									int alt185=2;
									int LA185_0 = input.LA(1);
									if ( (LA185_0==ALL) ) {
										alt185=1;
									}
									else if ( (LA185_0==ANY) ) {
										alt185=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 185, 0, input);
										throw nvae;
									}

									switch (alt185) {
										case 1 :
											// PhoenixSQL.g:1062:169: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression7417); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:1062:179: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression7423); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7426); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression7430);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7432); if (state.failed) return ret;
									}

									}
									break;

							}

							if ( state.backtracking==0 ) {ret = all != null ? factory.wrapInAll(op, l, r) : any != null ? factory.wrapInAny(op, l, r) : factory.comparison(op,l,r); }
							}

							}
							break;
						case 2 :
							// PhoenixSQL.g:1063:22: ( IS (n= NOT )? NULL )
							{
							// PhoenixSQL.g:1063:22: ( IS (n= NOT )? NULL )
							// PhoenixSQL.g:1063:23: IS (n= NOT )? NULL
							{
							match(input,IS,FOLLOW_IS_in_boolean_expression7462); if (state.failed) return ret;
							// PhoenixSQL.g:1063:27: (n= NOT )?
							int alt187=2;
							int LA187_0 = input.LA(1);
							if ( (LA187_0==NOT) ) {
								alt187=1;
							}
							switch (alt187) {
								case 1 :
									// PhoenixSQL.g:1063:27: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression7466); if (state.failed) return ret;
									}
									break;

							}

							match(input,NULL,FOLLOW_NULL_in_boolean_expression7469); if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret = factory.isNull(l,n!=null); }
							}

							}
							break;
						case 3 :
							// PhoenixSQL.g:1064:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							{
							// PhoenixSQL.g:1064:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							// PhoenixSQL.g:1064:24: (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							{
							// PhoenixSQL.g:1064:25: (n= NOT )?
							int alt188=2;
							int LA188_0 = input.LA(1);
							if ( (LA188_0==NOT) ) {
								alt188=1;
							}
							switch (alt188) {
								case 1 :
									// PhoenixSQL.g:1064:25: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression7500); if (state.failed) return ret;
									}
									break;

							}

							// PhoenixSQL.g:1064:31: ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							int alt190=4;
							switch ( input.LA(1) ) {
							case LIKE:
								{
								alt190=1;
								}
								break;
							case ILIKE:
								{
								alt190=2;
								}
								break;
							case BETWEEN:
								{
								alt190=3;
								}
								break;
							case IN:
								{
								alt190=4;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 190, 0, input);
								throw nvae;
							}
							switch (alt190) {
								case 1 :
									// PhoenixSQL.g:1064:32: ( LIKE r= value_expression )
									{
									// PhoenixSQL.g:1064:32: ( LIKE r= value_expression )
									// PhoenixSQL.g:1064:33: LIKE r= value_expression
									{
									match(input,LIKE,FOLLOW_LIKE_in_boolean_expression7505); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression7509);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_SENSITIVE); }
									}

									}
									break;
								case 2 :
									// PhoenixSQL.g:1065:32: ( ILIKE r= value_expression )
									{
									// PhoenixSQL.g:1065:32: ( ILIKE r= value_expression )
									// PhoenixSQL.g:1065:33: ILIKE r= value_expression
									{
									match(input,ILIKE,FOLLOW_ILIKE_in_boolean_expression7547); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression7551);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_INSENSITIVE); }
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:1066:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									{
									// PhoenixSQL.g:1066:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									// PhoenixSQL.g:1066:33: BETWEEN r1= value_expression AND r2= value_expression
									{
									match(input,BETWEEN,FOLLOW_BETWEEN_in_boolean_expression7589); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression7593);
									r1=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,AND,FOLLOW_AND_in_boolean_expression7595); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression7599);
									r2=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.between(l,r1,r2,n!=null); }
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:1067:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									{
									// PhoenixSQL.g:1067:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									// PhoenixSQL.g:1067:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									{
									// PhoenixSQL.g:1067:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									// PhoenixSQL.g:1067:34: IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									{
									match(input,IN,FOLLOW_IN_in_boolean_expression7638); if (state.failed) return ret;
									// PhoenixSQL.g:1067:37: ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									int alt189=3;
									int LA189_0 = input.LA(1);
									if ( (LA189_0==BIND_NAME||LA189_0==QUESTION) ) {
										alt189=1;
									}
									else if ( (LA189_0==LPAREN) ) {
										int LA189_2 = input.LA(2);
										if ( (LA189_2==SELECT) ) {
											alt189=2;
										}
										else if ( (LA189_2==ARRAY||LA189_2==BIND_NAME||LA189_2==BIN_LITERAL||(LA189_2 >= CASE && LA189_2 <= CAST)||LA189_2==CURRENT||LA189_2==DECIMAL||LA189_2==DOUBLE||LA189_2==EXISTS||LA189_2==FALSE||LA189_2==HEX_LITERAL||LA189_2==LPAREN||LA189_2==MINUS||(LA189_2 >= NAME && LA189_2 <= NEXT)||LA189_2==NOT||LA189_2==NULL||LA189_2==NUMBER||LA189_2==QUESTION||LA189_2==STRING_LITERAL||LA189_2==TRUE) ) {
											alt189=3;
										}

										else {
											if (state.backtracking>0) {state.failed=true; return ret;}
											int nvaeMark = input.mark();
											try {
												input.consume();
												NoViableAltException nvae =
													new NoViableAltException("", 189, 2, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 189, 0, input);
										throw nvae;
									}

									switch (alt189) {
										case 1 :
											// PhoenixSQL.g:1067:38: (r= bind_expression )
											{
											// PhoenixSQL.g:1067:38: (r= bind_expression )
											// PhoenixSQL.g:1067:39: r= bind_expression
											{
											pushFollow(FOLLOW_bind_expression_in_boolean_expression7644);
											r=bind_expression();
											state._fsp--;
											if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.inList(Arrays.asList(l,r),n!=null);}
											}

											}
											break;
										case 2 :
											// PhoenixSQL.g:1068:35: ( LPAREN r= subquery_expression RPAREN )
											{
											// PhoenixSQL.g:1068:35: ( LPAREN r= subquery_expression RPAREN )
											// PhoenixSQL.g:1068:36: LPAREN r= subquery_expression RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7685); if (state.failed) return ret;
											pushFollow(FOLLOW_subquery_expression_in_boolean_expression7689);
											r=subquery_expression();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7691); if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.in(l,r,n!=null,false);}
											}

											}
											break;
										case 3 :
											// PhoenixSQL.g:1069:35: ( LPAREN v= one_or_more_expressions RPAREN )
											{
											// PhoenixSQL.g:1069:35: ( LPAREN v= one_or_more_expressions RPAREN )
											// PhoenixSQL.g:1069:36: LPAREN v= one_or_more_expressions RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7732); if (state.failed) return ret;
											pushFollow(FOLLOW_one_or_more_expressions_in_boolean_expression7736);
											v=one_or_more_expressions();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7738); if (state.failed) return ret;
											if ( state.backtracking==0 ) {List<ParseNode> il = new ArrayList<ParseNode>(v.size() + 1); il.add(l); il.addAll(v); ret = factory.inList(il,n!=null);}
											}

											}
											break;

									}

									}

									}

									}
									break;

							}

							}

							}
							break;
						case 4 :
							// PhoenixSQL.g:1072:23: 
							{
							if ( state.backtracking==0 ) { ret = l; }
							}
							break;

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:1073:9: EXISTS LPAREN s= subquery_expression RPAREN
					{
					match(input,EXISTS,FOLLOW_EXISTS_in_boolean_expression7838); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression7840); if (state.failed) return ret;
					pushFollow(FOLLOW_subquery_expression_in_boolean_expression7844);
					s=subquery_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression7846); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.exists(s,false);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "boolean_expression"



	// $ANTLR start "bind_expression"
	// PhoenixSQL.g:1076:1: bind_expression returns [BindParseNode ret] : b= bind_name ;
	public final BindParseNode bind_expression() throws RecognitionException {
		BindParseNode ret = null;


		String b =null;

		try {
			// PhoenixSQL.g:1077:5: (b= bind_name )
			// PhoenixSQL.g:1077:9: b= bind_name
			{
			pushFollow(FOLLOW_bind_name_in_bind_expression7874);
			b=bind_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.bind(b); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_expression"



	// $ANTLR start "value_expression"
	// PhoenixSQL.g:1080:1: value_expression returns [ParseNode ret] : i= add_expression ;
	public final ParseNode value_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		try {
			// PhoenixSQL.g:1081:5: (i= add_expression )
			// PhoenixSQL.g:1081:9: i= add_expression
			{
			pushFollow(FOLLOW_add_expression_in_value_expression7905);
			i=add_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = i; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression"



	// $ANTLR start "add_expression"
	// PhoenixSQL.g:1084:1: add_expression returns [ParseNode ret] : i= subtract_expression ( PLUS i= subtract_expression )* ;
	public final ParseNode add_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:1086:5: (i= subtract_expression ( PLUS i= subtract_expression )* )
			// PhoenixSQL.g:1086:9: i= subtract_expression ( PLUS i= subtract_expression )*
			{
			pushFollow(FOLLOW_subtract_expression_in_add_expression7936);
			i=subtract_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:1086:43: ( PLUS i= subtract_expression )*
			loop193:
			while (true) {
				int alt193=2;
				int LA193_0 = input.LA(1);
				if ( (LA193_0==PLUS) ) {
					alt193=1;
				}

				switch (alt193) {
				case 1 :
					// PhoenixSQL.g:1086:44: PLUS i= subtract_expression
					{
					match(input,PLUS,FOLLOW_PLUS_in_add_expression7941); if (state.failed) return ret;
					pushFollow(FOLLOW_subtract_expression_in_add_expression7945);
					i=subtract_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop193;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.add(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_expression"



	// $ANTLR start "subtract_expression"
	// PhoenixSQL.g:1089:1: subtract_expression returns [ParseNode ret] : i= concat_expression ( MINUS i= concat_expression )* ;
	public final ParseNode subtract_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:1091:5: (i= concat_expression ( MINUS i= concat_expression )* )
			// PhoenixSQL.g:1091:9: i= concat_expression ( MINUS i= concat_expression )*
			{
			pushFollow(FOLLOW_concat_expression_in_subtract_expression7980);
			i=concat_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:1091:41: ( MINUS i= concat_expression )*
			loop194:
			while (true) {
				int alt194=2;
				int LA194_0 = input.LA(1);
				if ( (LA194_0==MINUS) ) {
					alt194=1;
				}

				switch (alt194) {
				case 1 :
					// PhoenixSQL.g:1091:42: MINUS i= concat_expression
					{
					match(input,MINUS,FOLLOW_MINUS_in_subtract_expression7985); if (state.failed) return ret;
					pushFollow(FOLLOW_concat_expression_in_subtract_expression7989);
					i=concat_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop194;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.subtract(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subtract_expression"



	// $ANTLR start "concat_expression"
	// PhoenixSQL.g:1094:1: concat_expression returns [ParseNode ret] : i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* ;
	public final ParseNode concat_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:1096:5: (i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* )
			// PhoenixSQL.g:1096:9: i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )*
			{
			pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression8024);
			i=multiply_divide_modulo_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:1096:57: ( CONCAT i= multiply_divide_modulo_expression )*
			loop195:
			while (true) {
				int alt195=2;
				int LA195_0 = input.LA(1);
				if ( (LA195_0==CONCAT) ) {
					alt195=1;
				}

				switch (alt195) {
				case 1 :
					// PhoenixSQL.g:1096:58: CONCAT i= multiply_divide_modulo_expression
					{
					match(input,CONCAT,FOLLOW_CONCAT_in_concat_expression8029); if (state.failed) return ret;
					pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression8033);
					i=multiply_divide_modulo_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop195;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.concat(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "concat_expression"



	// $ANTLR start "multiply_divide_modulo_expression"
	// PhoenixSQL.g:1099:1: multiply_divide_modulo_expression returns [ParseNode ret] : i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* ;
	public final ParseNode multiply_divide_modulo_expression() throws RecognitionException {
		ParseNode ret = null;


		Token op=null;
		ParseNode i =null;
		ParseNode rhs =null;

		ParseNode lhs = null; List<ParseNode> l;
		try {
			// PhoenixSQL.g:1101:5: (i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* )
			// PhoenixSQL.g:1101:9: i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			{
			pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression8068);
			i=negate_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {lhs = i;}
			// PhoenixSQL.g:1102:9: (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			loop196:
			while (true) {
				int alt196=2;
				int LA196_0 = input.LA(1);
				if ( (LA196_0==ASTERISK||LA196_0==DIVIDE||LA196_0==PERCENT) ) {
					alt196=1;
				}

				switch (alt196) {
				case 1 :
					// PhoenixSQL.g:1102:10: op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression
					{
					op=input.LT(1);
					if ( input.LA(1)==ASTERISK||input.LA(1)==DIVIDE||input.LA(1)==PERCENT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression8098);
					rhs=negate_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            l = Arrays.asList(lhs, rhs); 
					            // determine the expression type based on the operator found
					            lhs = op.getType() == ASTERISK ? factory.multiply(l)
					                : op.getType() == DIVIDE   ? factory.divide(l)
					                : factory.modulus(l);
					            }
					}
					break;

				default :
					break loop196;
				}
			}

			if ( state.backtracking==0 ) { ret = lhs; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "multiply_divide_modulo_expression"



	// $ANTLR start "use_schema_node"
	// PhoenixSQL.g:1113:1: use_schema_node returns [UseSchemaStatement ret] : USE ( DEFAULT |s= identifier ) ;
	public final UseSchemaStatement use_schema_node() throws RecognitionException {
		UseSchemaStatement ret = null;


		String s =null;

		try {
			// PhoenixSQL.g:1114:2: ( USE ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:1114:6: USE ( DEFAULT |s= identifier )
			{
			match(input,USE,FOLLOW_USE_in_use_schema_node8141); if (state.failed) return ret;
			// PhoenixSQL.g:1114:10: ( DEFAULT |s= identifier )
			int alt197=2;
			int LA197_0 = input.LA(1);
			if ( (LA197_0==DEFAULT) ) {
				alt197=1;
			}
			else if ( (LA197_0==NAME) ) {
				alt197=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 197, 0, input);
				throw nvae;
			}

			switch (alt197) {
				case 1 :
					// PhoenixSQL.g:1114:11: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_use_schema_node8144); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:1114:21: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_use_schema_node8150);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.useSchema(s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "use_schema_node"



	// $ANTLR start "negate_expression"
	// PhoenixSQL.g:1118:1: negate_expression returns [ParseNode ret] : (m= MINUS )? e= array_expression ;
	public final ParseNode negate_expression() throws RecognitionException {
		ParseNode ret = null;


		Token m=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:1119:5: ( (m= MINUS )? e= array_expression )
			// PhoenixSQL.g:1119:9: (m= MINUS )? e= array_expression
			{
			// PhoenixSQL.g:1119:10: (m= MINUS )?
			int alt198=2;
			int LA198_0 = input.LA(1);
			if ( (LA198_0==MINUS) ) {
				alt198=1;
			}
			switch (alt198) {
				case 1 :
					// PhoenixSQL.g:1119:10: m= MINUS
					{
					m=(Token)match(input,MINUS,FOLLOW_MINUS_in_negate_expression8186); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_array_expression_in_negate_expression8191);
			e=array_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = m==null ? e : factory.negate(e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "negate_expression"



	// $ANTLR start "array_expression"
	// PhoenixSQL.g:1123:1: array_expression returns [ParseNode ret] : e= term ( LSQUARE s= value_expression RSQUARE )? ;
	public final ParseNode array_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:1124:5: (e= term ( LSQUARE s= value_expression RSQUARE )? )
			// PhoenixSQL.g:1124:9: e= term ( LSQUARE s= value_expression RSQUARE )?
			{
			pushFollow(FOLLOW_term_in_array_expression8219);
			e=term();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1124:16: ( LSQUARE s= value_expression RSQUARE )?
			int alt199=2;
			int LA199_0 = input.LA(1);
			if ( (LA199_0==LSQUARE) ) {
				alt199=1;
			}
			switch (alt199) {
				case 1 :
					// PhoenixSQL.g:1124:17: LSQUARE s= value_expression RSQUARE
					{
					match(input,LSQUARE,FOLLOW_LSQUARE_in_array_expression8222); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_array_expression8226);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_array_expression8228); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { if (s == null) { ret = e; } else { ret = factory.arrayElemRef(Arrays.<ParseNode>asList(e,s)); } }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "array_expression"



	// $ANTLR start "term"
	// PhoenixSQL.g:1127:1: term returns [ParseNode ret] : (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name );
	public final ParseNode term() throws RecognitionException {
		ParseNode ret = null;


		Token ex=null;
		Token a=null;
		Token wg=null;
		Token t=null;
		Token length=null;
		Token scale=null;
		Token ar=null;
		Token n=null;
		ParseNode e =null;
		String field =null;
		List<ParseNode> v =null;
		TableName tableName =null;
		List<ParseNode> l =null;
		List<ParseNode> l2 =null;
		String dt =null;
		TableName s =null;
		ParseNode lorb =null;

		try {
			// PhoenixSQL.g:1128:5: (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name )
			int alt206=12;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case BIN_LITERAL:
			case DECIMAL:
			case DOUBLE:
			case FALSE:
			case HEX_LITERAL:
			case NULL:
			case NUMBER:
			case QUESTION:
			case STRING_LITERAL:
			case TRUE:
				{
				alt206=1;
				}
				break;
			case NAME:
				{
				switch ( input.LA(2) ) {
				case STRING_LITERAL:
					{
					alt206=1;
					}
					break;
				case EOF:
				case AND:
				case AS:
				case ASC:
				case ASTERISK:
				case ASYNC:
				case BETWEEN:
				case CACHE:
				case CASCADE:
				case COMMA:
				case CONCAT:
				case CONSTRAINT:
				case CYCLE:
				case DESC:
				case DIVIDE:
				case ELSE:
				case ENCODED_QUALIFIER:
				case END:
				case EQ:
				case FETCH:
				case FROM:
				case FULL:
				case GROUP:
				case GT:
				case HAVING:
				case ILIKE:
				case IN:
				case INCREMENT:
				case INNER:
				case IS:
				case JOIN:
				case LEFT:
				case LIKE:
				case LIMIT:
				case LSQUARE:
				case LT:
				case MAXVALUE:
				case MINUS:
				case MINVALUE:
				case NAME:
				case NOEQ1:
				case NOEQ2:
				case NOT:
				case NULLS:
				case OFFSET:
				case OR:
				case ORDER:
				case PERCENT:
				case PLUS:
				case PRIMARY:
				case RETURNING:
				case RIGHT:
				case RPAREN:
				case RSQUARE:
				case SEMICOLON:
				case SPLIT:
				case THEN:
				case UNION:
				case WHEN:
				case WHERE:
					{
					alt206=2;
					}
					break;
				case DOT:
					{
					alt206=4;
					}
					break;
				case LPAREN:
					{
					switch ( input.LA(3) ) {
					case ASTERISK:
						{
						alt206=6;
						}
						break;
					case DISTINCT:
						{
						alt206=7;
						}
						break;
					case ARRAY:
					case BIND_NAME:
					case BIN_LITERAL:
					case CASE:
					case CAST:
					case COMMA:
					case CURRENT:
					case DECIMAL:
					case DOUBLE:
					case EXISTS:
					case FALSE:
					case HEX_LITERAL:
					case LPAREN:
					case MINUS:
					case NAME:
					case NEXT:
					case NOT:
					case NULL:
					case NUMBER:
					case QUESTION:
					case RPAREN:
					case STRING_LITERAL:
					case TRUE:
						{
						alt206=5;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 206, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 206, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ARRAY:
				{
				alt206=3;
				}
				break;
			case CASE:
				{
				alt206=8;
				}
				break;
			case LPAREN:
				{
				alt206=9;
				}
				break;
			case CAST:
				{
				alt206=10;
				}
				break;
			case NEXT:
				{
				int LA206_7 = input.LA(2);
				if ( (LA206_7==VALUE) ) {
					alt206=11;
				}
				else if ( (LA206_7==BIND_NAME||LA206_7==BIN_LITERAL||LA206_7==DECIMAL||LA206_7==DOUBLE||LA206_7==FALSE||LA206_7==HEX_LITERAL||LA206_7==NAME||LA206_7==NULL||LA206_7==NUMBER||LA206_7==QUESTION||LA206_7==STRING_LITERAL||LA206_7==TRUE) ) {
					alt206=12;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 206, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CURRENT:
				{
				alt206=11;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 206, 0, input);
				throw nvae;
			}
			switch (alt206) {
				case 1 :
					// PhoenixSQL.g:1128:9: e= literal_or_bind
					{
					pushFollow(FOLLOW_literal_or_bind_in_term8261);
					e=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1129:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_term8275);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(null,field,field); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1130:9: ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE
					{
					ex=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term8289); if (state.failed) return ret;
					match(input,LSQUARE,FOLLOW_LSQUARE_in_term8291); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term8295);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_term8297); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.upsertStmtArrayNode(v);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:1131:9: tableName= table_name DOT field= identifier
					{
					pushFollow(FOLLOW_table_name_in_term8311);
					tableName=table_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_term8313); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term8317);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(tableName, field, field); }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1132:9: field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					{
					pushFollow(FOLLOW_identifier_in_term8331);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term8333); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term8337);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term8339); if (state.failed) return ret;
					// PhoenixSQL.g:1132:70: ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					int alt201=2;
					int LA201_0 = input.LA(1);
					if ( (LA201_0==WITHIN) ) {
						alt201=1;
					}
					switch (alt201) {
						case 1 :
							// PhoenixSQL.g:1132:71: WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN
							{
							wg=(Token)match(input,WITHIN,FOLLOW_WITHIN_in_term8344); if (state.failed) return ret;
							wg=(Token)match(input,GROUP,FOLLOW_GROUP_in_term8346); if (state.failed) return ret;
							wg=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_term8348); if (state.failed) return ret;
							wg=(Token)match(input,ORDER,FOLLOW_ORDER_in_term8350); if (state.failed) return ret;
							wg=(Token)match(input,BY,FOLLOW_BY_in_term8352); if (state.failed) return ret;
							pushFollow(FOLLOW_one_or_more_expressions_in_term8356);
							l2=one_or_more_expressions();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:1132:127: (a= ASC | DESC )
							int alt200=2;
							int LA200_0 = input.LA(1);
							if ( (LA200_0==ASC) ) {
								alt200=1;
							}
							else if ( (LA200_0==DESC) ) {
								alt200=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 200, 0, input);
								throw nvae;
							}

							switch (alt200) {
								case 1 :
									// PhoenixSQL.g:1132:128: a= ASC
									{
									a=(Token)match(input,ASC,FOLLOW_ASC_in_term8361); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:1132:136: DESC
									{
									wg=(Token)match(input,DESC,FOLLOW_DESC_in_term8365); if (state.failed) return ret;
									}
									break;

							}

							wg=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_term8368); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) {
					            FunctionParseNode f = wg==null ? factory.function(field, l) : factory.function(field,l,l2,a!=null);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 6 :
					// PhoenixSQL.g:1141:9: field= identifier LPAREN t= ASTERISK RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term8393);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term8395); if (state.failed) return ret;
					t=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_term8399); if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term8401); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            if (!isCountFunction(field)) {
					                throwRecognitionException(t);
					            }
					            FunctionParseNode f = factory.function(field, LiteralParseNode.STAR);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 7 :
					// PhoenixSQL.g:1153:9: field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term8425);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term8427); if (state.failed) return ret;
					t=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_term8431); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term8435);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term8437); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            FunctionParseNode f = factory.functionDistinct(field, l);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 8 :
					// PhoenixSQL.g:1162:9: e= case_statement
					{
					pushFollow(FOLLOW_case_statement_in_term8460);
					e=case_statement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 9 :
					// PhoenixSQL.g:1163:9: LPAREN l= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_term8472); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term8476);
					l=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term8478); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					    		if(l.size() == 1) {
					    			ret = l.get(0);
					    		}	
					    		else {
					    			ret = factory.rowValueConstructor(l);
					    		}	 
					    	}
					}
					break;
				case 10 :
					// PhoenixSQL.g:1172:9: CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN
					{
					match(input,CAST,FOLLOW_CAST_in_term8496); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term8498); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_term8502);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,AS,FOLLOW_AS_in_term8504); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term8508);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1172:51: ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )?
					int alt203=2;
					int LA203_0 = input.LA(1);
					if ( (LA203_0==LPAREN) ) {
						alt203=1;
					}
					switch (alt203) {
						case 1 :
							// PhoenixSQL.g:1172:52: LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_term8511); if (state.failed) return ret;
							length=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term8515); if (state.failed) return ret;
							// PhoenixSQL.g:1172:73: ( COMMA scale= NUMBER )?
							int alt202=2;
							int LA202_0 = input.LA(1);
							if ( (LA202_0==COMMA) ) {
								alt202=1;
							}
							switch (alt202) {
								case 1 :
									// PhoenixSQL.g:1172:74: COMMA scale= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_term8518); if (state.failed) return ret;
									scale=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term8522); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_term8526); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:1172:107: ( ARRAY | ( LSQUARE RSQUARE ) )?
					int alt204=3;
					int LA204_0 = input.LA(1);
					if ( (LA204_0==ARRAY) ) {
						alt204=1;
					}
					else if ( (LA204_0==LSQUARE) ) {
						alt204=2;
					}
					switch (alt204) {
						case 1 :
							// PhoenixSQL.g:1172:108: ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term8533); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1172:116: ( LSQUARE RSQUARE )
							{
							// PhoenixSQL.g:1172:116: ( LSQUARE RSQUARE )
							// PhoenixSQL.g:1172:117: LSQUARE RSQUARE
							{
							ar=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_term8538); if (state.failed) return ret;
							ar=(Token)match(input,RSQUARE,FOLLOW_RSQUARE_in_term8540); if (state.failed) return ret;
							}

							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_term8545); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.cast(e, dt,
					                     length == null ? null : Integer.parseInt(length.getText()),
					                     scale == null ? null : Integer.parseInt(scale.getText()),
					                     ar!=null);
					        }
					}
					break;
				case 11 :
					// PhoenixSQL.g:1178:9: (n= NEXT | CURRENT ) VALUE FOR s= from_table_name
					{
					// PhoenixSQL.g:1178:9: (n= NEXT | CURRENT )
					int alt205=2;
					int LA205_0 = input.LA(1);
					if ( (LA205_0==NEXT) ) {
						alt205=1;
					}
					else if ( (LA205_0==CURRENT) ) {
						alt205=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 205, 0, input);
						throw nvae;
					}

					switch (alt205) {
						case 1 :
							// PhoenixSQL.g:1178:10: n= NEXT
							{
							n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term8568); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1178:19: CURRENT
							{
							match(input,CURRENT,FOLLOW_CURRENT_in_term8572); if (state.failed) return ret;
							}
							break;

					}

					match(input,VALUE,FOLLOW_VALUE_in_term8575); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term8577); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term8581);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = n==null ? factory.currentValueFor(s) : factory.nextValueFor(s, null); }
					}
					break;
				case 12 :
					// PhoenixSQL.g:1181:9: (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name
					{
					// PhoenixSQL.g:1181:9: (n= NEXT )
					// PhoenixSQL.g:1181:10: n= NEXT
					{
					n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term8609); if (state.failed) return ret;
					}

					pushFollow(FOLLOW_literal_or_bind_in_term8614);
					lorb=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					match(input,VALUES,FOLLOW_VALUES_in_term8616); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term8618); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term8622);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = factory.nextValueFor(s, lorb); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "term"



	// $ANTLR start "one_or_more_expressions"
	// PhoenixSQL.g:1186:1: one_or_more_expressions returns [List<ParseNode> ret] : e= expression ( COMMA e= expression )* ;
	public final List<ParseNode> one_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1188:5: (e= expression ( COMMA e= expression )* )
			// PhoenixSQL.g:1188:8: e= expression ( COMMA e= expression )*
			{
			pushFollow(FOLLOW_expression_in_one_or_more_expressions8667);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1188:39: ( COMMA e= expression )*
			loop207:
			while (true) {
				int alt207=2;
				int LA207_0 = input.LA(1);
				if ( (LA207_0==COMMA) ) {
					alt207=1;
				}

				switch (alt207) {
				case 1 :
					// PhoenixSQL.g:1188:40: COMMA e= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_expressions8673); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_one_or_more_expressions8679);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop207;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_expressions"



	// $ANTLR start "one_or_more_jarpaths"
	// PhoenixSQL.g:1191:1: one_or_more_jarpaths returns [List<LiteralParseNode> ret] : jarPath= jar_path ( COMMA jarPath= jar_path )* ;
	public final List<LiteralParseNode> one_or_more_jarpaths() throws RecognitionException {
		List<LiteralParseNode> ret = null;


		LiteralParseNode jarPath =null;

		ret = new ArrayList<LiteralParseNode>(); 
		try {
			// PhoenixSQL.g:1193:5: (jarPath= jar_path ( COMMA jarPath= jar_path )* )
			// PhoenixSQL.g:1193:8: jarPath= jar_path ( COMMA jarPath= jar_path )*
			{
			pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths8710);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(jarPath);}
			// PhoenixSQL.g:1193:49: ( COMMA jarPath= jar_path )*
			loop208:
			while (true) {
				int alt208=2;
				int LA208_0 = input.LA(1);
				if ( (LA208_0==COMMA) ) {
					alt208=1;
				}

				switch (alt208) {
				case 1 :
					// PhoenixSQL.g:1193:50: COMMA jarPath= jar_path
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_jarpaths8716); if (state.failed) return ret;
					pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths8722);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(jarPath);}
					}
					break;

				default :
					break loop208;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_jarpaths"



	// $ANTLR start "zero_or_more_expressions"
	// PhoenixSQL.g:1196:1: zero_or_more_expressions returns [List<ParseNode> ret] : (v= expression )? ( COMMA v= expression )* ;
	public final List<ParseNode> zero_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode v =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1198:5: ( (v= expression )? ( COMMA v= expression )* )
			// PhoenixSQL.g:1198:8: (v= expression )? ( COMMA v= expression )*
			{
			// PhoenixSQL.g:1198:8: (v= expression )?
			int alt209=2;
			int LA209_0 = input.LA(1);
			if ( (LA209_0==ARRAY||LA209_0==BIND_NAME||LA209_0==BIN_LITERAL||(LA209_0 >= CASE && LA209_0 <= CAST)||LA209_0==CURRENT||LA209_0==DECIMAL||LA209_0==DOUBLE||LA209_0==EXISTS||LA209_0==FALSE||LA209_0==HEX_LITERAL||LA209_0==LPAREN||LA209_0==MINUS||(LA209_0 >= NAME && LA209_0 <= NEXT)||LA209_0==NOT||LA209_0==NULL||LA209_0==NUMBER||LA209_0==QUESTION||LA209_0==STRING_LITERAL||LA209_0==TRUE) ) {
				alt209=1;
			}
			switch (alt209) {
				case 1 :
					// PhoenixSQL.g:1198:9: v= expression
					{
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions8755);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

			}

			// PhoenixSQL.g:1198:42: ( COMMA v= expression )*
			loop210:
			while (true) {
				int alt210=2;
				int LA210_0 = input.LA(1);
				if ( (LA210_0==COMMA) ) {
					alt210=1;
				}

				switch (alt210) {
				case 1 :
					// PhoenixSQL.g:1198:43: COMMA v= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_expressions8763); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions8769);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop210;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_expressions"



	// $ANTLR start "zero_or_more_data_types"
	// PhoenixSQL.g:1201:1: zero_or_more_data_types returns [List<FunctionArgument> ret] : (fa= function_argument )? ( COMMA fa= function_argument )* ;
	public final List<FunctionArgument> zero_or_more_data_types() throws RecognitionException {
		List<FunctionArgument> ret = null;


		FunctionArgument fa =null;

		ret = new ArrayList<FunctionArgument>(); 
		try {
			// PhoenixSQL.g:1203:5: ( (fa= function_argument )? ( COMMA fa= function_argument )* )
			// PhoenixSQL.g:1203:7: (fa= function_argument )? ( COMMA fa= function_argument )*
			{
			// PhoenixSQL.g:1203:7: (fa= function_argument )?
			int alt211=2;
			int LA211_0 = input.LA(1);
			if ( (LA211_0==NAME) ) {
				alt211=1;
			}
			switch (alt211) {
				case 1 :
					// PhoenixSQL.g:1203:8: fa= function_argument
					{
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types8800);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

			}

			// PhoenixSQL.g:1203:49: ( COMMA fa= function_argument )*
			loop212:
			while (true) {
				int alt212=2;
				int LA212_0 = input.LA(1);
				if ( (LA212_0==COMMA) ) {
					alt212=1;
				}

				switch (alt212) {
				case 1 :
					// PhoenixSQL.g:1203:50: COMMA fa= function_argument
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_data_types8807); if (state.failed) return ret;
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types8813);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

				default :
					break loop212;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_data_types"



	// $ANTLR start "function_argument"
	// PhoenixSQL.g:1206:1: function_argument returns [FunctionArgument ret] : (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) ;
	public final FunctionArgument function_argument() throws RecognitionException {
		FunctionArgument ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token c=null;
		String dt =null;
		ParseNode dv =null;
		ParseNode minv =null;
		ParseNode maxv =null;

		try {
			// PhoenixSQL.g:1207:2: ( (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) )
			// PhoenixSQL.g:1207:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			{
			// PhoenixSQL.g:1207:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			// PhoenixSQL.g:1207:5: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )?
			{
			pushFollow(FOLLOW_identifier_in_function_argument8838);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1207:21: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt214=2;
			int LA214_0 = input.LA(1);
			if ( (LA214_0==LPAREN) ) {
				alt214=1;
			}
			switch (alt214) {
				case 1 :
					// PhoenixSQL.g:1207:22: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_function_argument8841); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8845); if (state.failed) return ret;
					// PhoenixSQL.g:1207:38: ( COMMA s= NUMBER )?
					int alt213=2;
					int LA213_0 = input.LA(1);
					if ( (LA213_0==COMMA) ) {
						alt213=1;
					}
					switch (alt213) {
						case 1 :
							// PhoenixSQL.g:1207:39: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_function_argument8848); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8852); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_function_argument8856); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1207:67: (ar= ARRAY )?
			int alt215=2;
			int LA215_0 = input.LA(1);
			if ( (LA215_0==ARRAY) ) {
				alt215=1;
			}
			switch (alt215) {
				case 1 :
					// PhoenixSQL.g:1207:67: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_function_argument8862); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1207:75: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt217=2;
			int LA217_0 = input.LA(1);
			if ( (LA217_0==LSQUARE) ) {
				alt217=1;
			}
			switch (alt217) {
				case 1 :
					// PhoenixSQL.g:1207:76: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_function_argument8868); if (state.failed) return ret;
					// PhoenixSQL.g:1207:88: (a= NUMBER )?
					int alt216=2;
					int LA216_0 = input.LA(1);
					if ( (LA216_0==NUMBER) ) {
						alt216=1;
					}
					switch (alt216) {
						case 1 :
							// PhoenixSQL.g:1207:89: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument8873); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_function_argument8877); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1207:110: (c= CONSTANT )?
			int alt218=2;
			int LA218_0 = input.LA(1);
			if ( (LA218_0==CONSTANT) ) {
				alt218=1;
			}
			switch (alt218) {
				case 1 :
					// PhoenixSQL.g:1207:111: c= CONSTANT
					{
					c=(Token)match(input,CONSTANT,FOLLOW_CONSTANT_in_function_argument8886); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1207:126: ( DEFAULTVALUE EQ dv= expression )?
			int alt219=2;
			int LA219_0 = input.LA(1);
			if ( (LA219_0==DEFAULTVALUE) ) {
				alt219=1;
			}
			switch (alt219) {
				case 1 :
					// PhoenixSQL.g:1207:127: DEFAULTVALUE EQ dv= expression
					{
					match(input,DEFAULTVALUE,FOLLOW_DEFAULTVALUE_in_function_argument8891); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8893); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8899);
					dv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1207:161: ( MINVALUE EQ minv= expression )?
			int alt220=2;
			int LA220_0 = input.LA(1);
			if ( (LA220_0==MINVALUE) ) {
				alt220=1;
			}
			switch (alt220) {
				case 1 :
					// PhoenixSQL.g:1207:162: MINVALUE EQ minv= expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_function_argument8904); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8906); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8912);
					minv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1207:195: ( MAXVALUE EQ maxv= expression )?
			int alt221=2;
			int LA221_0 = input.LA(1);
			if ( (LA221_0==MAXVALUE) ) {
				alt221=1;
			}
			switch (alt221) {
				case 1 :
					// PhoenixSQL.g:1207:196: MAXVALUE EQ maxv= expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_function_argument8918); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument8920); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument8926);
					maxv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = new FunctionArgument(dt,  ar != null || lsq != null, c!=null, 
			    dv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)dv).getValue()), 
			    minv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)minv).getValue()), 
			    maxv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)maxv).getValue()));}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "function_argument"



	// $ANTLR start "value_expression_list"
	// PhoenixSQL.g:1214:1: value_expression_list returns [List<ParseNode> ret] : LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN ;
	public final List<ParseNode> value_expression_list() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1216:5: ( LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN )
			// PhoenixSQL.g:1216:8: LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_value_expression_list8956); if (state.failed) return ret;
			pushFollow(FOLLOW_value_expression_in_value_expression_list8962);
			e=value_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1216:52: ( COMMA e= value_expression )*
			loop222:
			while (true) {
				int alt222=2;
				int LA222_0 = input.LA(1);
				if ( (LA222_0==COMMA) ) {
					alt222=1;
				}

				switch (alt222) {
				case 1 :
					// PhoenixSQL.g:1216:53: COMMA e= value_expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_value_expression_list8968); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_value_expression_list8974);
					e=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop222;
				}
			}

			match(input,RPAREN,FOLLOW_RPAREN_in_value_expression_list8981); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression_list"



	// $ANTLR start "index_name"
	// PhoenixSQL.g:1219:1: index_name returns [NamedNode ret] : name= identifier ;
	public final NamedNode index_name() throws RecognitionException {
		NamedNode ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1220:5: (name= identifier )
			// PhoenixSQL.g:1220:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_index_name9002);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexName(name); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "index_name"



	// $ANTLR start "cursor_name"
	// PhoenixSQL.g:1223:1: cursor_name returns [CursorName ret] : name= identifier ;
	public final CursorName cursor_name() throws RecognitionException {
		CursorName ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1224:5: (name= identifier )
			// PhoenixSQL.g:1224:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_cursor_name9029);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.cursorName(name);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_name"



	// $ANTLR start "table_name"
	// PhoenixSQL.g:1228:1: table_name returns [TableName ret] : (t= table_identifier |s= table_identifier DOT t= table_identifier );
	public final TableName table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1229:5: (t= table_identifier |s= table_identifier DOT t= table_identifier )
			int alt223=2;
			int LA223_0 = input.LA(1);
			if ( (LA223_0==NAME) ) {
				int LA223_1 = input.LA(2);
				if ( (LA223_1==FROM||LA223_1==TO) ) {
					alt223=1;
				}
				else if ( (LA223_1==DOT) ) {
					int LA223_3 = input.LA(3);
					if ( (LA223_3==NAME) ) {
						switch ( input.LA(4) ) {
						case EOF:
						case AND:
						case AS:
						case ASC:
						case ASTERISK:
						case ASYNC:
						case BETWEEN:
						case CACHE:
						case CASCADE:
						case COMMA:
						case CONCAT:
						case CONSTRAINT:
						case CYCLE:
						case DESC:
						case DIVIDE:
						case ELSE:
						case ENCODED_QUALIFIER:
						case END:
						case EQ:
						case FETCH:
						case FULL:
						case GROUP:
						case GT:
						case HAVING:
						case ILIKE:
						case IN:
						case INCREMENT:
						case INNER:
						case IS:
						case JOIN:
						case LEFT:
						case LIKE:
						case LIMIT:
						case LSQUARE:
						case LT:
						case MAXVALUE:
						case MINUS:
						case MINVALUE:
						case NAME:
						case NOEQ1:
						case NOEQ2:
						case NOT:
						case NULLS:
						case OFFSET:
						case OR:
						case ORDER:
						case PERCENT:
						case PLUS:
						case PRIMARY:
						case RETURNING:
						case RIGHT:
						case RPAREN:
						case RSQUARE:
						case SEMICOLON:
						case SPLIT:
						case THEN:
						case UNION:
						case WHEN:
						case WHERE:
							{
							alt223=1;
							}
							break;
						case FROM:
							{
							switch ( input.LA(5) ) {
							case BIND_NAME:
							case LPAREN:
							case QUESTION:
								{
								alt223=1;
								}
								break;
							case NAME:
								{
								int LA223_7 = input.LA(6);
								if ( (LA223_7==EOF||LA223_7==AS||LA223_7==COMMA||LA223_7==DOT||LA223_7==FETCH||LA223_7==FULL||LA223_7==GROUP||LA223_7==HAVING||LA223_7==INNER||LA223_7==JOIN||LA223_7==LEFT||LA223_7==LIMIT||LA223_7==LPAREN||LA223_7==NAME||LA223_7==OFFSET||LA223_7==ORDER||LA223_7==RETURNING||LA223_7==RIGHT||LA223_7==RPAREN||LA223_7==SEMICOLON||LA223_7==TABLESAMPLE||LA223_7==UNION||LA223_7==WHERE) ) {
									alt223=1;
								}
								else if ( (LA223_7==STRING_LITERAL) ) {
									alt223=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 223, 7, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case BIN_LITERAL:
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case GROUP:
							case HEX_LITERAL:
							case NULL:
							case NUMBER:
							case STRING_LITERAL:
							case TRUE:
								{
								alt223=2;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 223, 5, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}
							}
							break;
						case DOT:
						case TO:
							{
							alt223=2;
							}
							break;
						default:
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 223, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 223, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 223, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 223, 0, input);
				throw nvae;
			}

			switch (alt223) {
				case 1 :
					// PhoenixSQL.g:1229:9: t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_table_name9057);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1230:9: s= table_identifier DOT t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_table_name9071);
					s=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_table_name9073); if (state.failed) return ret;
					pushFollow(FOLLOW_table_identifier_in_table_name9077);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_name"



	// $ANTLR start "from_table_name"
	// PhoenixSQL.g:1234:1: from_table_name returns [TableName ret] : (t= table_identifier |s= table_identifier DOT t= table_identifier );
	public final TableName from_table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1235:5: (t= table_identifier |s= table_identifier DOT t= table_identifier )
			int alt224=2;
			int LA224_0 = input.LA(1);
			if ( (LA224_0==NAME) ) {
				int LA224_1 = input.LA(2);
				if ( (LA224_1==EOF||(LA224_1 >= ACTIVE && LA224_1 <= ALL)||LA224_1==AND||(LA224_1 >= AS && LA224_1 <= ASYNC)||LA224_1==BETWEEN||(LA224_1 >= CACHE && LA224_1 <= CASCADE)||LA224_1==COLUMNS||LA224_1==COMMA||LA224_1==CONCAT||LA224_1==CONSTRAINT||LA224_1==CYCLE||LA224_1==DESC||LA224_1==DISABLE||LA224_1==DIVIDE||LA224_1==DROP||(LA224_1 >= ELSE && LA224_1 <= END)||LA224_1==EQ||LA224_1==FETCH||(LA224_1 >= FROM && LA224_1 <= FULL)||(LA224_1 >= GROUP && LA224_1 <= HAVING)||LA224_1==ILIKE||(LA224_1 >= IN && LA224_1 <= INNER)||LA224_1==IS||LA224_1==JOIN||LA224_1==LEFT||(LA224_1 >= LIKE && LA224_1 <= LIMIT)||(LA224_1 >= LPAREN && LA224_1 <= MINVALUE)||LA224_1==NAME||(LA224_1 >= NOEQ1 && LA224_1 <= NOT)||LA224_1==NULLS||(LA224_1 >= OFFSET && LA224_1 <= ON)||(LA224_1 >= OR && LA224_1 <= ORDER)||(LA224_1 >= PERCENT && LA224_1 <= PLUS)||LA224_1==PRIMARY||LA224_1==REBUILD||LA224_1==RETURNING||LA224_1==RIGHT||(LA224_1 >= RPAREN && LA224_1 <= RSQUARE)||(LA224_1 >= SELECT && LA224_1 <= SEMICOLON)||LA224_1==SET||(LA224_1 >= SPLIT && LA224_1 <= START)||LA224_1==TABLESAMPLE||LA224_1==THEN||(LA224_1 >= UNION && LA224_1 <= UNUSABLE)||LA224_1==USABLE||LA224_1==VALUES||(LA224_1 >= WHEN && LA224_1 <= WHERE)) ) {
					alt224=1;
				}
				else if ( (LA224_1==DOT) ) {
					alt224=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 224, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 224, 0, input);
				throw nvae;
			}

			switch (alt224) {
				case 1 :
					// PhoenixSQL.g:1235:9: t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_from_table_name9105);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1236:9: s= table_identifier DOT t= table_identifier
					{
					pushFollow(FOLLOW_table_identifier_in_from_table_name9119);
					s=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_from_table_name9121); if (state.failed) return ret;
					pushFollow(FOLLOW_table_identifier_in_from_table_name9125);
					t=table_identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "from_table_name"



	// $ANTLR start "table_identifier"
	// PhoenixSQL.g:1239:1: table_identifier returns [String ret] : c= identifier ;
	public final String table_identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1240:5: (c= identifier )
			// PhoenixSQL.g:1240:9: c= identifier
			{
			pushFollow(FOLLOW_identifier_in_table_identifier9152);
			c=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			           if (c.contains(QueryConstants.NAMESPACE_SEPARATOR) ) { throw new RuntimeException("Table or schema name cannot contain colon"); }
			           ret = c;
			    }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_identifier"



	// $ANTLR start "literal_or_bind"
	// PhoenixSQL.g:1247:1: literal_or_bind returns [ParseNode ret] : (e= literal |b= bind_name );
	public final ParseNode literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode e =null;
		String b =null;

		try {
			// PhoenixSQL.g:1248:5: (e= literal |b= bind_name )
			int alt225=2;
			int LA225_0 = input.LA(1);
			if ( (LA225_0==BIN_LITERAL||LA225_0==DECIMAL||LA225_0==DOUBLE||LA225_0==FALSE||LA225_0==HEX_LITERAL||LA225_0==NAME||LA225_0==NULL||LA225_0==NUMBER||LA225_0==STRING_LITERAL||LA225_0==TRUE) ) {
				alt225=1;
			}
			else if ( (LA225_0==BIND_NAME||LA225_0==QUESTION) ) {
				alt225=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 225, 0, input);
				throw nvae;
			}

			switch (alt225) {
				case 1 :
					// PhoenixSQL.g:1248:9: e= literal
					{
					pushFollow(FOLLOW_literal_in_literal_or_bind9184);
					e=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1249:9: b= bind_name
					{
					pushFollow(FOLLOW_bind_name_in_literal_or_bind9198);
					b=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.bind(b); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal_or_bind"



	// $ANTLR start "literal"
	// PhoenixSQL.g:1253:1: literal returns [LiteralParseNode ret] : (h= hex_literal |b= bin_literal |s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL );
	public final LiteralParseNode literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token s=null;
		Token n=null;
		Token d=null;
		Token dbl=null;
		Token t=null;
		LiteralParseNode h =null;
		LiteralParseNode b =null;
		String dt =null;

		try {
			// PhoenixSQL.g:1254:5: (h= hex_literal |b= bin_literal |s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL )
			int alt226=10;
			switch ( input.LA(1) ) {
			case HEX_LITERAL:
				{
				alt226=1;
				}
				break;
			case BIN_LITERAL:
				{
				alt226=2;
				}
				break;
			case STRING_LITERAL:
				{
				alt226=3;
				}
				break;
			case NUMBER:
				{
				alt226=4;
				}
				break;
			case DECIMAL:
				{
				alt226=5;
				}
				break;
			case DOUBLE:
				{
				alt226=6;
				}
				break;
			case NULL:
				{
				alt226=7;
				}
				break;
			case TRUE:
				{
				alt226=8;
				}
				break;
			case FALSE:
				{
				alt226=9;
				}
				break;
			case NAME:
				{
				alt226=10;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 226, 0, input);
				throw nvae;
			}
			switch (alt226) {
				case 1 :
					// PhoenixSQL.g:1255:5: h= hex_literal
					{
					pushFollow(FOLLOW_hex_literal_in_literal9232);
					h=hex_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = h; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1256:9: b= bin_literal
					{
					pushFollow(FOLLOW_bin_literal_in_literal9246);
					b=bin_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = b; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1257:9: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal9260); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(s.getText()); 
					        }
					}
					break;
				case 4 :
					// PhoenixSQL.g:1260:9: n= NUMBER
					{
					n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_literal9274); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.wholeNumber(n.getText());
					        }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1263:9: d= DECIMAL
					{
					d=(Token)match(input,DECIMAL,FOLLOW_DECIMAL_in_literal9288); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.realNumber(d.getText());
					        }
					}
					break;
				case 6 :
					// PhoenixSQL.g:1266:9: dbl= DOUBLE
					{
					dbl=(Token)match(input,DOUBLE,FOLLOW_DOUBLE_in_literal9303); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(Double.valueOf(dbl.getText()));
					        }
					}
					break;
				case 7 :
					// PhoenixSQL.g:1269:9: NULL
					{
					match(input,NULL,FOLLOW_NULL_in_literal9316); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(null);}
					}
					break;
				case 8 :
					// PhoenixSQL.g:1270:9: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_literal9328); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.TRUE);}
					}
					break;
				case 9 :
					// PhoenixSQL.g:1271:9: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_literal9341); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.FALSE);}
					}
					break;
				case 10 :
					// PhoenixSQL.g:1272:9: dt= identifier t= STRING_LITERAL
					{
					pushFollow(FOLLOW_identifier_in_literal9355);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal9359); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					            try {
					                ret = factory.literal(t.getText(), dt);
					            } catch (SQLException e) {
					                throw new RuntimeException(e);
					            }
					        }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal"



	// $ANTLR start "int_or_long_literal"
	// PhoenixSQL.g:1281:1: int_or_long_literal returns [LiteralParseNode ret] : n= NUMBER ;
	public final LiteralParseNode int_or_long_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1282:5: (n= NUMBER )
			// PhoenixSQL.g:1282:9: n= NUMBER
			{
			n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_int_or_long_literal9386); if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            ret = factory.intOrLong(n.getText());
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_or_long_literal"



	// $ANTLR start "hex_literal"
	// PhoenixSQL.g:1287:1: hex_literal returns [LiteralParseNode ret] : (h= HEX_LITERAL (s= STRING_LITERAL )* ) ;
	public final LiteralParseNode hex_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token h=null;
		Token s=null;

		StringBuilder sb = new StringBuilder();
		try {
			// PhoenixSQL.g:1289:5: ( (h= HEX_LITERAL (s= STRING_LITERAL )* ) )
			// PhoenixSQL.g:1290:5: (h= HEX_LITERAL (s= STRING_LITERAL )* )
			{
			// PhoenixSQL.g:1290:5: (h= HEX_LITERAL (s= STRING_LITERAL )* )
			// PhoenixSQL.g:1291:5: h= HEX_LITERAL (s= STRING_LITERAL )*
			{
			h=(Token)match(input,HEX_LITERAL,FOLLOW_HEX_LITERAL_in_hex_literal9426); if (state.failed) return ret;
			if ( state.backtracking==0 ) { sb.append(h.getText()); }
			// PhoenixSQL.g:1292:5: (s= STRING_LITERAL )*
			loop227:
			while (true) {
				int alt227=2;
				int LA227_0 = input.LA(1);
				if ( (LA227_0==STRING_LITERAL) ) {
					alt227=1;
				}

				switch (alt227) {
				case 1 :
					// PhoenixSQL.g:1292:6: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_hex_literal9437); if (state.failed) return ret;
					if ( state.backtracking==0 ) { sb.append(factory.stringToHexLiteral(s.getText())); }
					}
					break;

				default :
					break loop227;
				}
			}

			}

			if ( state.backtracking==0 ) { ret = factory.hexLiteral(sb.toString()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "hex_literal"



	// $ANTLR start "bin_literal"
	// PhoenixSQL.g:1297:1: bin_literal returns [LiteralParseNode ret] : (b= BIN_LITERAL (s= STRING_LITERAL )* ) ;
	public final LiteralParseNode bin_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token b=null;
		Token s=null;

		StringBuilder sb = new StringBuilder();
		try {
			// PhoenixSQL.g:1299:5: ( (b= BIN_LITERAL (s= STRING_LITERAL )* ) )
			// PhoenixSQL.g:1300:5: (b= BIN_LITERAL (s= STRING_LITERAL )* )
			{
			// PhoenixSQL.g:1300:5: (b= BIN_LITERAL (s= STRING_LITERAL )* )
			// PhoenixSQL.g:1301:5: b= BIN_LITERAL (s= STRING_LITERAL )*
			{
			b=(Token)match(input,BIN_LITERAL,FOLLOW_BIN_LITERAL_in_bin_literal9492); if (state.failed) return ret;
			if ( state.backtracking==0 ) { sb.append(b.getText()); }
			// PhoenixSQL.g:1302:5: (s= STRING_LITERAL )*
			loop228:
			while (true) {
				int alt228=2;
				int LA228_0 = input.LA(1);
				if ( (LA228_0==STRING_LITERAL) ) {
					alt228=1;
				}

				switch (alt228) {
				case 1 :
					// PhoenixSQL.g:1302:6: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_bin_literal9503); if (state.failed) return ret;
					if ( state.backtracking==0 ) { sb.append(factory.stringToBinLiteral(s.getText())); }
					}
					break;

				default :
					break loop228;
				}
			}

			}

			if ( state.backtracking==0 ) { ret = factory.binLiteral(sb.toString()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bin_literal"



	// $ANTLR start "bind_name"
	// PhoenixSQL.g:1308:1: bind_name returns [String ret] : (n= BIND_NAME | QUESTION );
	public final String bind_name() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1309:5: (n= BIND_NAME | QUESTION )
			int alt229=2;
			int LA229_0 = input.LA(1);
			if ( (LA229_0==BIND_NAME) ) {
				alt229=1;
			}
			else if ( (LA229_0==QUESTION) ) {
				alt229=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 229, 0, input);
				throw nvae;
			}

			switch (alt229) {
				case 1 :
					// PhoenixSQL.g:1309:9: n= BIND_NAME
					{
					n=(Token)match(input,BIND_NAME,FOLLOW_BIND_NAME_in_bind_name9546); if (state.failed) return ret;
					if ( state.backtracking==0 ) { String bind = n.getText().substring(1); updateBind(bind); ret = bind; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1310:9: QUESTION
					{
					match(input,QUESTION,FOLLOW_QUESTION_in_bind_name9559); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = nextBind(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_name"



	// $ANTLR start "identifier"
	// PhoenixSQL.g:1314:1: identifier returns [String ret] : c= parseNoReserved ;
	public final String identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1315:5: (c= parseNoReserved )
			// PhoenixSQL.g:1315:9: c= parseNoReserved
			{
			pushFollow(FOLLOW_parseNoReserved_in_identifier9588);
			c=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = c; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "identifier"



	// $ANTLR start "parseNoReserved"
	// PhoenixSQL.g:1318:1: parseNoReserved returns [String ret] : n= NAME ;
	public final String parseNoReserved() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1319:5: (n= NAME )
			// PhoenixSQL.g:1319:9: n= NAME
			{
			n=(Token)match(input,NAME,FOLLOW_NAME_in_parseNoReserved9615); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = n.getText(); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseNoReserved"



	// $ANTLR start "case_statement"
	// PhoenixSQL.g:1322:1: case_statement returns [ParseNode ret] : ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END );
	public final ParseNode case_statement() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e1 =null;
		ParseNode e2 =null;
		ParseNode t =null;
		ParseNode el =null;
		ParseNode c =null;

		List<ParseNode> w = new ArrayList<ParseNode>(4);
		try {
			// PhoenixSQL.g:1324:5: ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END )
			int alt234=2;
			int LA234_0 = input.LA(1);
			if ( (LA234_0==CASE) ) {
				int LA234_1 = input.LA(2);
				if ( (LA234_1==ARRAY||LA234_1==BIND_NAME||LA234_1==BIN_LITERAL||(LA234_1 >= CASE && LA234_1 <= CAST)||LA234_1==CURRENT||LA234_1==DECIMAL||LA234_1==DOUBLE||LA234_1==EXISTS||LA234_1==FALSE||LA234_1==HEX_LITERAL||LA234_1==LPAREN||LA234_1==MINUS||(LA234_1 >= NAME && LA234_1 <= NEXT)||LA234_1==NOT||LA234_1==NULL||LA234_1==NUMBER||LA234_1==QUESTION||LA234_1==STRING_LITERAL||LA234_1==TRUE) ) {
					alt234=1;
				}
				else if ( (LA234_1==WHEN) ) {
					alt234=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 234, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 234, 0, input);
				throw nvae;
			}

			switch (alt234) {
				case 1 :
					// PhoenixSQL.g:1324:7: CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement9642); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_case_statement9646);
					e1=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1324:26: ( WHEN e2= expression THEN t= expression )+
					int cnt230=0;
					loop230:
					while (true) {
						int alt230=2;
						int LA230_0 = input.LA(1);
						if ( (LA230_0==WHEN) ) {
							alt230=1;
						}

						switch (alt230) {
						case 1 :
							// PhoenixSQL.g:1324:27: WHEN e2= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement9649); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9653);
							e2=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement9655); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9659);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(factory.equal(e1,e2));}
							}
							break;

						default :
							if ( cnt230 >= 1 ) break loop230;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(230, input);
							throw eee;
						}
						cnt230++;
					}

					// PhoenixSQL.g:1324:106: ( ELSE el= expression )?
					int alt231=2;
					int LA231_0 = input.LA(1);
					if ( (LA231_0==ELSE) ) {
						alt231=1;
					}
					switch (alt231) {
						case 1 :
							// PhoenixSQL.g:1324:107: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement9666); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9670);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement9676); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;
				case 2 :
					// PhoenixSQL.g:1325:7: CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement9686); if (state.failed) return ret;
					// PhoenixSQL.g:1325:12: ( WHEN c= expression THEN t= expression )+
					int cnt232=0;
					loop232:
					while (true) {
						int alt232=2;
						int LA232_0 = input.LA(1);
						if ( (LA232_0==WHEN) ) {
							alt232=1;
						}

						switch (alt232) {
						case 1 :
							// PhoenixSQL.g:1325:13: WHEN c= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement9689); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9693);
							c=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement9695); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9699);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(c);}
							}
							break;

						default :
							if ( cnt232 >= 1 ) break loop232;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(232, input);
							throw eee;
						}
						cnt232++;
					}

					// PhoenixSQL.g:1325:72: ( ELSE el= expression )?
					int alt233=2;
					int LA233_0 = input.LA(1);
					if ( (LA233_0==ELSE) ) {
						alt233=1;
					}
					switch (alt233) {
						case 1 :
							// PhoenixSQL.g:1325:73: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement9706); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement9710);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement9716); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "case_statement"

	// $ANTLR start synpred1_PhoenixSQL
	public final void synpred1_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:1048:9: ( ( NOT )? boolean_expression )
		// PhoenixSQL.g:1048:10: ( NOT )? boolean_expression
		{
		// PhoenixSQL.g:1048:10: ( NOT )?
		int alt235=2;
		int LA235_0 = input.LA(1);
		if ( (LA235_0==NOT) ) {
			alt235=1;
		}
		switch (alt235) {
			case 1 :
				// PhoenixSQL.g:1048:10: NOT
				{
				match(input,NOT,FOLLOW_NOT_in_synpred1_PhoenixSQL7232); if (state.failed) return;
				}
				break;

		}

		pushFollow(FOLLOW_boolean_expression_in_synpred1_PhoenixSQL7235);
		boolean_expression();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred1_PhoenixSQL

	// Delegated rules

	public final boolean synpred1_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}



	public static final BitSet FOLLOW_oneStatement_in_nextStatement1411 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_nextStatement1415 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EOF_in_nextStatement1424 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_oneStatement_in_statement1450 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_statement1454 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_query1480 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1482 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_oneStatement1514 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_upsert_node_in_oneStatement1524 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_node_in_oneStatement1536 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_table_node_in_oneStatement1548 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_schema_node_in_oneStatement1560 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_view_node_in_oneStatement1572 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_index_node_in_oneStatement1584 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_cdc_node_in_oneStatement1596 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_open_node_in_oneStatement1608 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_close_node_in_oneStatement1620 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_fetch_node_in_oneStatement1632 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_declare_cursor_node_in_oneStatement1644 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_table_node_in_oneStatement1656 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_index_node_in_oneStatement1668 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_cdc_node_in_oneStatement1680 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_index_node_in_oneStatement1692 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_table_node_in_oneStatement1704 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_show_node_in_oneStatement1716 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_show_create_table_node_in_oneStatement1728 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_trace_node_in_oneStatement1740 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_function_node_in_oneStatement1752 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_function_node_in_oneStatement1764 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_jars_node_in_oneStatement1776 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_jars_node_in_oneStatement1788 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_jar_node_in_oneStatement1800 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_session_node_in_oneStatement1812 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_sequence_node_in_oneStatement1822 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grant_permission_node_in_oneStatement1834 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revoke_permission_node_in_oneStatement1846 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_sequence_node_in_oneStatement1856 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_schema_node_in_oneStatement1866 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_use_schema_node_in_oneStatement1876 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_statistics_node_in_oneStatement1888 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_execute_upgrade_node_in_oneStatement1900 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_explain_node_in_oneStatement1912 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXPLAIN_in_explain_node1945 = new BitSet(new long[]{0x10048200400000A0L,0x0000100000008128L,0xA420002100440008L,0x0000000000000040L});
	public static final BitSet FOLLOW_WITH_in_explain_node1950 = new BitSet(new long[]{0x10048200400000A0L,0x0000100000008128L,0xA420002100440008L});
	public static final BitSet FOLLOW_REGIONS_in_explain_node1957 = new BitSet(new long[]{0x10048200400000A0L,0x0000100000008128L,0xA420002100400008L});
	public static final BitSet FOLLOW_oneStatement_in_explain_node1963 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_table_node1994 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_IMMUTABLE_in_create_table_node1999 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_TABLE_in_create_table_node2003 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_create_table_node2006 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_table_node2008 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_create_table_node2012 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_table_node2018 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_table_node2030 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_table_node2034 = new BitSet(new long[]{0x0000010800000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_pk_constraint_in_create_table_node2039 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_create_table_node2043 = new BitSet(new long[]{0x0000000400000002L,0x0840000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_NOVERIFY_in_create_table_node2057 = new BitSet(new long[]{0x0000000400000002L,0x0040000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_table_node2072 = new BitSet(new long[]{0x0000000400000002L,0x0000000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_SPLIT_in_create_table_node2085 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ON_in_create_table_node2087 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_table_node2091 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_COLUMN_QUALIFIER_COUNTER_in_create_table_node2104 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_table_node2106 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_initializiation_list_in_create_table_node2110 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_create_table_node2112 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_schema_node2151 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_SCHEMA_in_create_schema_node2153 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_create_schema_node2156 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_schema_node2158 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_create_schema_node2162 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_create_schema_node2168 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRANT_in_grant_permission_node2202 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_literal_in_grant_permission_node2206 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0010000000000002L});
	public static final BitSet FOLLOW_ON_in_grant_permission_node2209 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L,0x0000400040000000L});
	public static final BitSet FOLLOW_TABLE_in_grant_permission_node2213 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_table_name_in_grant_permission_node2219 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_SCHEMA_in_grant_permission_node2225 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_grant_permission_node2229 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_TO_in_grant_permission_node2234 = new BitSet(new long[]{0x0200400000100000L,0x5040000000110080L,0x0040200000000000L});
	public static final BitSet FOLLOW_GROUP_in_grant_permission_node2239 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_literal_in_grant_permission_node2245 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REVOKE_in_revoke_permission_node2279 = new BitSet(new long[]{0x0200400000100000L,0x5040000000101080L,0x0040200000000002L});
	public static final BitSet FOLLOW_literal_in_revoke_permission_node2284 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ON_in_revoke_permission_node2289 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L,0x0000400040000000L});
	public static final BitSet FOLLOW_TABLE_in_revoke_permission_node2293 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_table_name_in_revoke_permission_node2299 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_SCHEMA_in_revoke_permission_node2305 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_revoke_permission_node2309 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_FROM_in_revoke_permission_node2314 = new BitSet(new long[]{0x0200400000100000L,0x5040000000110080L,0x0040200000000000L});
	public static final BitSet FOLLOW_GROUP_in_revoke_permission_node2319 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_literal_in_revoke_permission_node2325 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_node2359 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_TABLES_in_show_node2361 = new BitSet(new long[]{0x0000000000000002L,0x0000040004000000L});
	public static final BitSet FOLLOW_IN_in_show_node2364 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_show_node2368 = new BitSet(new long[]{0x0000000000000002L,0x0000040000000000L});
	public static final BitSet FOLLOW_LIKE_in_show_node2373 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_string_literal_in_show_node2377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_node2391 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_SCHEMAS_in_show_node2393 = new BitSet(new long[]{0x0000000000000002L,0x0000040000000000L});
	public static final BitSet FOLLOW_LIKE_in_show_node2396 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_string_literal_in_show_node2400 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHOW_in_show_create_table_node2428 = new BitSet(new long[]{0x0000020000000000L});
	public static final BitSet FOLLOW_CREATE_in_show_create_table_node2430 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_TABLE_in_show_create_table_node2432 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_show_create_table_node2436 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_view_node2462 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_VIEW_in_create_view_node2464 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_create_view_node2467 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_view_node2469 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_create_view_node2473 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node2479 = new BitSet(new long[]{0x0000000000000802L,0x0040400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_view_node2491 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_view_node2495 = new BitSet(new long[]{0x0000010800000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_pk_constraint_in_create_view_node2500 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_create_view_node2504 = new BitSet(new long[]{0x0000000000000802L,0x0040000000000000L});
	public static final BitSet FOLLOW_AS_in_create_view_node2518 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_SELECT_in_create_view_node2520 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_create_view_node2522 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_FROM_in_create_view_node2534 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node2538 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_WHERE_in_create_view_node2551 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_create_view_node2555 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_view_node2573 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_index_node2609 = new BitSet(new long[]{0x0000000000000000L,0x0000200020000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_UNCOVERED_in_create_index_node2613 = new BitSet(new long[]{0x0000000000000000L,0x0000200020000000L});
	public static final BitSet FOLLOW_LOCAL_in_create_index_node2618 = new BitSet(new long[]{0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_INDEX_in_create_index_node2621 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_create_index_node2624 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_index_node2626 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_create_index_node2630 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_index_name_in_create_index_node2636 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ON_in_create_index_node2638 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_index_node2642 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2653 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_ik_constraint_in_create_index_node2657 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2659 = new BitSet(new long[]{0x0000000000004002L,0x0040000008000000L,0x0000040000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_INCLUDE_in_create_index_node2673 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2676 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_column_names_in_create_index_node2680 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2682 = new BitSet(new long[]{0x0000000000004002L,0x0040000000000000L,0x0000040000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_WHERE_in_create_index_node2696 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_create_index_node2700 = new BitSet(new long[]{0x0000000000004002L,0x0040000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_ASYNC_in_create_index_node2715 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_index_node2730 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_SPLIT_in_create_index_node2743 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ON_in_create_index_node2745 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_index_node2749 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_cdc_node2784 = new BitSet(new long[]{0x0000000004000000L});
	public static final BitSet FOLLOW_CDC_in_create_cdc_node2786 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_create_cdc_node2789 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_cdc_node2791 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_create_cdc_node2795 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_cdc_name_in_create_cdc_node2801 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ON_in_create_cdc_node2803 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_cdc_node2807 = new BitSet(new long[]{0x0000000000000002L,0x0040000008000000L});
	public static final BitSet FOLLOW_INCLUDE_in_create_cdc_node2818 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_cdc_node2820 = new BitSet(new long[]{0x0000000008000000L,0x0000000000000000L,0x0000000000003000L});
	public static final BitSet FOLLOW_cdc_change_scopes_in_create_cdc_node2824 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_create_cdc_node2826 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_cdc_node2841 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_cdc_name2878 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cdc_change_scope_in_cdc_change_scopes2910 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_cdc_change_scopes2916 = new BitSet(new long[]{0x0000000008000000L,0x0000000000000000L,0x0000000000003000L});
	public static final BitSet FOLLOW_cdc_change_scope_in_cdc_change_scopes2920 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_set_in_cdc_change_scope2950 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_sequence_node2994 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_SEQUENCE_in_create_sequence_node2996 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_create_sequence_node3000 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_NOT_in_create_sequence_node3002 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_create_sequence_node3006 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_sequence_node3012 = new BitSet(new long[]{0x0000100000400002L,0x000A000010000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_START_in_create_sequence_node3023 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L,0x0000000000000040L});
	public static final BitSet FOLLOW_WITH_in_create_sequence_node3025 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node3030 = new BitSet(new long[]{0x0000100000400002L,0x000A000010000000L});
	public static final BitSet FOLLOW_INCREMENT_in_create_sequence_node3043 = new BitSet(new long[]{0x0200440003340400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_BY_in_create_sequence_node3045 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node3050 = new BitSet(new long[]{0x0000100000400002L,0x000A000000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_create_sequence_node3063 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node3067 = new BitSet(new long[]{0x0000100000400002L,0x0002000000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_create_sequence_node3080 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node3084 = new BitSet(new long[]{0x0000100000400002L});
	public static final BitSet FOLLOW_CYCLE_in_create_sequence_node3099 = new BitSet(new long[]{0x0000000000400002L});
	public static final BitSet FOLLOW_CACHE_in_create_sequence_node3113 = new BitSet(new long[]{0x0000000000040000L,0x4000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_int_literal_or_bind_in_create_sequence_node3117 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_int_literal_or_bind3148 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_int_literal_or_bind3160 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_string_literal3188 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_sequence_node3214 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_SEQUENCE_in_drop_sequence_node3216 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_drop_sequence_node3220 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_drop_sequence_node3224 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_sequence_node3230 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pk_constraint3259 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_CONSTRAINT_in_pk_constraint3262 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_pk_constraint3266 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_PRIMARY_in_pk_constraint3268 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_KEY_in_pk_constraint3270 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_pk_constraint3272 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint3276 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_pk_constraint3278 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list3309 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list3315 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list3321 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp3348 = new BitSet(new long[]{0x0008000000001002L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp3353 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp3357 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp3364 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_list_in_ik_constraint3399 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list3426 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_expression_with_sort_order_list3432 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list3438 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_expression_in_expression_with_sort_order3465 = new BitSet(new long[]{0x0008000000001002L});
	public static final BitSet FOLLOW_ASC_in_expression_with_sort_order3471 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESC_in_expression_with_sort_order3475 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties3503 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_fam_properties3505 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties3509 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_fam_properties3515 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties3519 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_fam_properties3521 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties3525 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3555 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3569 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_DOT_in_fam_prop_name3571 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name3575 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_value3606 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_prop_value3620 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name3651 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name3665 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_DOT_in_column_name3667 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_column_name3671 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_column_names3703 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_column_names3709 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_column_name_in_column_names3715 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_DROP_in_drop_table_node3742 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_VIEW_in_drop_table_node3747 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_TABLE_in_drop_table_node3751 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_drop_table_node3755 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_drop_table_node3759 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_table_node3765 = new BitSet(new long[]{0x0000000000800002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_table_node3770 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_schema_node3805 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_SCHEMA_in_drop_schema_node3807 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_drop_schema_node3810 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_drop_schema_node3814 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_schema_node3820 = new BitSet(new long[]{0x0000000000800002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_schema_node3825 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_index_node3860 = new BitSet(new long[]{0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_INDEX_in_drop_index_node3862 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_drop_index_node3865 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_drop_index_node3869 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_index_name_in_drop_index_node3875 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ON_in_drop_index_node3877 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_index_node3881 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_cdc_node3910 = new BitSet(new long[]{0x0000000004000000L});
	public static final BitSet FOLLOW_CDC_in_drop_cdc_node3912 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_drop_cdc_node3915 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_drop_cdc_node3919 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_cdc_name_in_drop_cdc_node3925 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ON_in_drop_cdc_node3927 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_cdc_node3931 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_index_node3959 = new BitSet(new long[]{0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_INDEX_in_alter_index_node3961 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_alter_index_node3964 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_alter_index_node3968 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_index_name_in_alter_index_node3974 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ON_in_alter_index_node3976 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_index_node3980 = new BitSet(new long[]{0x0020000000000010L,0x0000000000000000L,0x4200000000020000L});
	public static final BitSet FOLLOW_USABLE_in_alter_index_node3993 = new BitSet(new long[]{0x0000000000004002L,0x0040000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_UNUSABLE_in_alter_index_node3997 = new BitSet(new long[]{0x0000000000004002L,0x0040000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_REBUILD_in_alter_index_node4001 = new BitSet(new long[]{0x0000000000004042L,0x0040000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_ALL_in_alter_index_node4006 = new BitSet(new long[]{0x0000000000004002L,0x0040000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_DISABLE_in_alter_index_node4012 = new BitSet(new long[]{0x0000000000004002L,0x0040000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_ACTIVE_in_alter_index_node4016 = new BitSet(new long[]{0x0000000000004002L,0x0040000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_ASYNC_in_alter_index_node4023 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_SET_in_alter_index_node4029 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_index_node4034 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRACE_in_trace_node4069 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ON_in_trace_node4077 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_WITH_in_trace_node4082 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_SAMPLING_in_trace_node4084 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_sampling_rate_in_trace_node4090 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OFF_in_trace_node4101 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_function_node4135 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L,0x0002000000000010L});
	public static final BitSet FOLLOW_OR_in_create_function_node4138 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_REPLACE_in_create_function_node4142 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L,0x0002000000000000L});
	public static final BitSet FOLLOW_TEMPORARY_in_create_function_node4149 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_FUNCTION_in_create_function_node4153 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node4157 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_function_node4168 = new BitSet(new long[]{0x0000000800000000L,0x0040000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_zero_or_more_data_types_in_create_function_node4172 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_create_function_node4174 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_RETURNS_in_create_function_node4184 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node4188 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_create_function_node4190 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node4196 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_USING_in_create_function_node4207 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_JAR_in_create_function_node4209 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node4216 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_jar_path4253 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_function_node4276 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_FUNCTION_in_drop_function_node4278 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_drop_function_node4281 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_drop_function_node4285 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_function_node4291 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_add_jars_node4314 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_JARS_in_add_jars_node4316 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_one_or_more_jarpaths_in_add_jars_node4322 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIST_in_list_jars_node4345 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_JARS_in_list_jars_node4347 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_jar_node4370 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_JAR_in_delete_jar_node4372 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_jar_path_in_delete_jar_node4378 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_session_node4404 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_SESSION_in_alter_session_node4406 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_SET_in_alter_session_node4409 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_properties_in_alter_session_node4413 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_table_node4447 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_TABLE_in_alter_table_node4450 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_VIEW_in_alter_table_node4456 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_table_node4461 = new BitSet(new long[]{0x1000000000000020L,0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_DROP_in_alter_table_node4474 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_COLUMN_in_alter_table_node4476 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node4479 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node4483 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_column_names_in_alter_table_node4489 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_alter_table_node4495 = new BitSet(new long[]{0x0000000000000000L,0x0040000000400000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node4498 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_NOT_in_alter_table_node4500 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node4504 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_column_defs_in_alter_table_node4511 = new BitSet(new long[]{0x0000000000800002L,0x0040000000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node4517 = new BitSet(new long[]{0x0000000000800002L});
	public static final BitSet FOLLOW_CASCADE_in_alter_table_node4525 = new BitSet(new long[]{0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_INDEX_in_alter_table_node4527 = new BitSet(new long[]{0x0000000000000040L,0x0040000000000000L});
	public static final BitSet FOLLOW_indexes_in_alter_table_node4532 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_alter_table_node4538 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_alter_table_node4546 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node4551 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_update_statistics_node4585 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_STATISTICS_in_update_statistics_node4587 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_update_statistics_node4591 = new BitSet(new long[]{0x0000000200000042L,0x0000000020000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_INDEX_in_update_statistics_node4596 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_ALL_in_update_statistics_node4602 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_COLUMNS_in_update_statistics_node4608 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_SET_in_update_statistics_node4613 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_properties_in_update_statistics_node4618 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXECUTE_in_execute_upgrade_node4642 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_UPGRADE_in_execute_upgrade_node4644 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_name4670 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prop_name_in_properties4704 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_properties4706 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_prop_value_in_properties4710 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_properties4716 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_prop_name_in_properties4720 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_properties4722 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_prop_value_in_properties4726 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_column_def_in_column_defs4761 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_column_defs4767 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_column_def_in_column_defs4773 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_initializiation_list4803 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_initializiation_list4805 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_initializiation_list4809 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_initializiation_list4822 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_initializiation_list4826 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_initializiation_list4828 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_initializiation_list4832 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_index_name_in_indexes4867 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_indexes4873 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_index_name_in_indexes4879 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_column_name_in_column_def4905 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_column_def4909 = new BitSet(new long[]{0x8001000000000402L,0x1400C00000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_LPAREN_in_column_def4912 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4916 = new BitSet(new long[]{0x0000000800000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_COMMA_in_column_def4919 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4923 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_column_def4927 = new BitSet(new long[]{0x8001000000000402L,0x1400800000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_ARRAY_in_column_def4933 = new BitSet(new long[]{0x8001000000000002L,0x1400800000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_LSQUARE_in_column_def4939 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def4944 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_RSQUARE_in_column_def4948 = new BitSet(new long[]{0x8001000000000002L,0x1400000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_NOT_in_column_def4955 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_NULL_in_column_def4960 = new BitSet(new long[]{0x8001000000000002L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_DEFAULT_in_column_def4965 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_column_def4969 = new BitSet(new long[]{0x8000000000000002L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_PRIMARY_in_column_def4977 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_KEY_in_column_def4979 = new BitSet(new long[]{0x0008000000001002L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_ASC_in_column_def4984 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_DESC_in_column_def4988 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_column_def4994 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ENCODED_QUALIFIER_in_column_def4999 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def5003 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs5046 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_defs5052 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs5058 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_def5084 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_def5088 = new BitSet(new long[]{0x0000000000000402L,0x0000C00000000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_def5091 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def5095 = new BitSet(new long[]{0x0000000800000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_def5098 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def5102 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_def5106 = new BitSet(new long[]{0x0000000000000402L,0x0000800000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_def5112 = new BitSet(new long[]{0x0000000000000002L,0x0000800000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_def5118 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def5123 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_def5127 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_name_or_def5164 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_name_or_def5169 = new BitSet(new long[]{0x0000000000000402L,0x0000C00000000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_name_or_def5172 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def5176 = new BitSet(new long[]{0x0000000800000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_name_or_def5179 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def5183 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_name_or_def5187 = new BitSet(new long[]{0x0000000000000402L,0x0000800000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_name_or_def5193 = new BitSet(new long[]{0x0000000000000002L,0x0000800000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_name_or_def5199 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def5204 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_name_or_def5208 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_subquery_expression5248 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_single_select5281 = new BitSet(new long[]{0x0240440003142440L,0x54E4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_hintClause_in_single_select5286 = new BitSet(new long[]{0x0240440003142440L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_DISTINCT_in_single_select5302 = new BitSet(new long[]{0x0200440003142400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_ALL_in_single_select5306 = new BitSet(new long[]{0x0200440003142400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_select_list_in_single_select5312 = new BitSet(new long[]{0x0000000000000002L,0x0000000000051000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_single_select5323 = new BitSet(new long[]{0x0000000000040000L,0x0040400000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_parseFrom_in_single_select5327 = new BitSet(new long[]{0x0000000000000002L,0x0000000000050000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_WHERE_in_single_select5340 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_single_select5344 = new BitSet(new long[]{0x0000000000000002L,0x0000000000050000L});
	public static final BitSet FOLLOW_GROUP_in_single_select5357 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_BY_in_single_select5359 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_group_by_in_single_select5363 = new BitSet(new long[]{0x0000000000000002L,0x0000000000040000L});
	public static final BitSet FOLLOW_HAVING_in_single_select5376 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_single_select5380 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects5424 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_UNION_in_unioned_selects5429 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_ALL_in_unioned_selects5431 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects5435 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_unioned_selects_in_select_node5473 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000100L,0x0000000000000021L});
	public static final BitSet FOLLOW_ORDER_in_select_node5484 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_BY_in_select_node5486 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_order_by_in_select_node5490 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000100L,0x0000000000000001L});
	public static final BitSet FOLLOW_LIMIT_in_select_node5503 = new BitSet(new long[]{0x0000000000040000L,0x4000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_limit_in_select_node5507 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000100L,0x0000000000000001L});
	public static final BitSet FOLLOW_OFFSET_in_select_node5520 = new BitSet(new long[]{0x0000000000040000L,0x4000400000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_offset_in_select_node5524 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000100L});
	public static final BitSet FOLLOW_FETCH_in_select_node5537 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000400L});
	public static final BitSet FOLLOW_set_in_select_node5539 = new BitSet(new long[]{0x0000000000040000L,0x4000000000000000L,0x0000000003008000L});
	public static final BitSet FOLLOW_limit_in_select_node5550 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000003000000L});
	public static final BitSet FOLLOW_set_in_select_node5554 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_ONLY_in_select_node5562 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPSERT_in_upsert_node5601 = new BitSet(new long[]{0x0000000000000000L,0x0020000080000000L});
	public static final BitSet FOLLOW_hintClause_in_upsert_node5606 = new BitSet(new long[]{0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_INTO_in_upsert_node5610 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_upsert_node5614 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L,0x0000000100000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node5625 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_upsert_column_refs_in_upsert_node5629 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node5631 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_VALUES_in_upsert_node5645 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node5647 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_upsert_node5651 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node5653 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100002L});
	public static final BitSet FOLLOW_ON_in_upsert_node5669 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_DUPLICATE_in_upsert_node5671 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_KEY_in_upsert_node5673 = new BitSet(new long[]{0x0000000000000000L,0x0000000000800000L,0x0C00000000000000L});
	public static final BitSet FOLLOW_IGNORE_in_upsert_node5695 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_UPDATE_in_upsert_node5717 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_update_column_pairs_in_upsert_node5721 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_UPDATE_ONLY_in_upsert_node5745 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_update_column_pairs_in_upsert_node5749 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_select_node_in_upsert_node5786 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_RETURNING_in_upsert_node5793 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_upsert_node5795 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs5838 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_update_column_pairs5850 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs5854 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_column_name_in_update_column_pair5879 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_update_column_pair5881 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_update_column_pair5885 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5914 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_upsert_column_refs5927 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs5931 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_DECLARE_in_declare_cursor_node5959 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_cursor_name_in_declare_cursor_node5963 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_CURSOR_in_declare_cursor_node5965 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_FOR_in_declare_cursor_node5967 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_select_node_in_declare_cursor_node5971 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_in_cursor_open_node6005 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_open_node6009 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_in_cursor_close_node6036 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_close_node6040 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FETCH_in_cursor_fetch_node6066 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_NEXT_in_cursor_fetch_node6068 = new BitSet(new long[]{0x0000000000000000L,0x4000000000001000L,0x0000000003000000L});
	public static final BitSet FOLLOW_NUMBER_in_cursor_fetch_node6073 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L,0x0000000003000000L});
	public static final BitSet FOLLOW_FROM_in_cursor_fetch_node6084 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_fetch_node6088 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_node6114 = new BitSet(new long[]{0x0000000000000000L,0x0020000000001000L});
	public static final BitSet FOLLOW_hintClause_in_delete_node6119 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_FROM_in_delete_node6123 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_delete_node6127 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L,0x0000000000100020L,0x0000000000000020L});
	public static final BitSet FOLLOW_WHERE_in_delete_node6138 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_delete_node6142 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L,0x0000000000100020L});
	public static final BitSet FOLLOW_ORDER_in_delete_node6155 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_BY_in_delete_node6157 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_order_by_in_delete_node6161 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_LIMIT_in_delete_node6174 = new BitSet(new long[]{0x0000000000040000L,0x4000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_limit_in_delete_node6178 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_RETURNING_in_delete_node6193 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_delete_node6195 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_limit6230 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_limit6242 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_offset6268 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000003000000L});
	public static final BitSet FOLLOW_int_or_long_literal_in_offset6289 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000003000000L});
	public static final BitSet FOLLOW_LPAREN_in_offset6308 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_offset6312 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_offset6314 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_offset6316 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_offset6318 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_offset6322 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_offset6324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_sampling_rate6349 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_tableSampleNode6374 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ML_HINT_in_hintClause6400 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectable_in_select_list6432 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_select_list6437 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_selectable_in_select_list6441 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_ASTERISK_in_select_list6453 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_selectable6482 = new BitSet(new long[]{0x0000000000000802L,0x0040000000000000L});
	public static final BitSet FOLLOW_parseAlias_in_selectable6487 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable6502 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable6504 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable6506 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable6521 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable6523 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_selectable6527 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable6529 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable6531 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_group_by6564 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_group_by6577 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_group_by6583 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by6617 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_order_by6630 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by6636 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_expression_in_parseOrderByField6673 = new BitSet(new long[]{0x0008000000001002L,0x2000000000000000L});
	public static final BitSet FOLLOW_ASC_in_parseOrderByField6685 = new BitSet(new long[]{0x0000000000000002L,0x2000000000000000L});
	public static final BitSet FOLLOW_DESC_in_parseOrderByField6691 = new BitSet(new long[]{0x0000000000000002L,0x2000000000000000L});
	public static final BitSet FOLLOW_NULLS_in_parseOrderByField6706 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000400L});
	public static final BitSet FOLLOW_FIRST_in_parseOrderByField6709 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LAST_in_parseOrderByField6715 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_list_in_parseFrom6755 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_ref_in_table_list6786 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_table_list6791 = new BitSet(new long[]{0x0000000000040000L,0x0040400000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_table_ref_in_table_list6795 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_table_factor_in_table_ref6819 = new BitSet(new long[]{0x0000000000000002L,0x0000010840002000L,0x0000000000800000L});
	public static final BitSet FOLLOW_join_type_in_table_ref6826 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_JOIN_in_table_ref6828 = new BitSet(new long[]{0x0000000000040000L,0x0040400000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_table_factor_in_table_ref6832 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_ON_in_table_ref6834 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_table_ref6838 = new BitSet(new long[]{0x0000000000000002L,0x0000010840002000L,0x0000000000800000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6862 = new BitSet(new long[]{0x0000000000040000L,0x0040400000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_table_list_in_table_factor6866 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6868 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_table_factor6882 = new BitSet(new long[]{0x0000000000000802L,0x0040000000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6886 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6892 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_from_table_name_in_table_factor6909 = new BitSet(new long[]{0x0000000000000802L,0x0040400000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6913 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6919 = new BitSet(new long[]{0x0000000000000002L,0x0000400000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6924 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_dyn_column_defs_in_table_factor6928 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6930 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_TABLESAMPLE_in_table_factor6935 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6937 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_tableSampleNode_in_table_factor6941 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6943 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor6957 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_select_node_in_table_factor6961 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor6963 = new BitSet(new long[]{0x0000000000000802L,0x0040000000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor6967 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor6973 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INNER_in_join_type7000 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEFT_in_join_type7015 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_OUTER_in_join_type7017 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHT_in_join_type7032 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_OUTER_in_join_type7034 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FULL_in_join_type7048 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_OUTER_in_join_type7051 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_parseAlias7082 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_parseNoReserved_in_parseAlias7087 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_or_expression_in_expression7115 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_and_expression_in_or_expression7147 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_OR_in_or_expression7152 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_and_expression_in_or_expression7156 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_not_expression_in_and_expression7192 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AND_in_and_expression7197 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_not_expression_in_and_expression7201 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_NOT_in_not_expression7243 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_boolean_expression_in_not_expression7248 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_not_expression7262 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_not_expression7265 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_not_expression7269 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_not_expression7271 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQ_in_comparison_op7291 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op7298 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op7305 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op7312 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_comparison_op7314 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op7321 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_comparison_op7323 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_comparison_op7330 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7361 = new BitSet(new long[]{0x0000000000020002L,0x0701040105020004L});
	public static final BitSet FOLLOW_comparison_op_in_boolean_expression7367 = new BitSet(new long[]{0x0200440003140640L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7372 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7377 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression7381 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7383 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression7392 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression7398 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7401 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7405 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7407 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression7417 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression7423 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7426 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression7430 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7432 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_boolean_expression7462 = new BitSet(new long[]{0x0000000000000000L,0x1400000000000000L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression7466 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_NULL_in_boolean_expression7469 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression7500 = new BitSet(new long[]{0x0000000000020000L,0x0000040005000000L});
	public static final BitSet FOLLOW_LIKE_in_boolean_expression7505 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7509 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ILIKE_in_boolean_expression7547 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7551 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BETWEEN_in_boolean_expression7589 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7593 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_AND_in_boolean_expression7595 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression7599 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_boolean_expression7638 = new BitSet(new long[]{0x0000000000040000L,0x0000400000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_bind_expression_in_boolean_expression7644 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7685 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression7689 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7691 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7732 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_boolean_expression7736 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7738 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXISTS_in_boolean_expression7838 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression7840 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression7844 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression7846 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_bind_expression7874 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_expression_in_value_expression7905 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression7936 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_PLUS_in_add_expression7941 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression7945 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression7980 = new BitSet(new long[]{0x0000000000000002L,0x0004000000000000L});
	public static final BitSet FOLLOW_MINUS_in_subtract_expression7985 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression7989 = new BitSet(new long[]{0x0000000000000002L,0x0004000000000000L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression8024 = new BitSet(new long[]{0x0000004000000002L});
	public static final BitSet FOLLOW_CONCAT_in_concat_expression8029 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression8033 = new BitSet(new long[]{0x0000004000000002L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression8068 = new BitSet(new long[]{0x0080000000002002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_set_in_multiply_divide_modulo_expression8084 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression8098 = new BitSet(new long[]{0x0080000000002002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_USE_in_use_schema_node8141 = new BitSet(new long[]{0x0001000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_use_schema_node8144 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_use_schema_node8150 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_negate_expression8186 = new BitSet(new long[]{0x0200440003140400L,0x50C0400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_array_expression_in_negate_expression8191 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_array_expression8219 = new BitSet(new long[]{0x0000000000000002L,0x0000800000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_array_expression8222 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_array_expression8226 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_RSQUARE_in_array_expression8228 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_or_bind_in_term8261 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term8275 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARRAY_in_term8289 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_term8291 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term8295 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_RSQUARE_in_term8297 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_name_in_term8311 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_DOT_in_term8313 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_term8317 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term8331 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term8333 = new BitSet(new long[]{0x0200440803140400L,0x54C4400000100090L,0x0040200008008000L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term8337 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_term8339 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_WITHIN_in_term8344 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_GROUP_in_term8346 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term8348 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_ORDER_in_term8350 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_BY_in_term8352 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term8356 = new BitSet(new long[]{0x0008000000001000L});
	public static final BitSet FOLLOW_ASC_in_term8361 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_DESC_in_term8365 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_term8368 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term8393 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term8395 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_term8399 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_term8401 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term8425 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term8427 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_term8431 = new BitSet(new long[]{0x0200440803140400L,0x54C4400000100090L,0x0040200008008000L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term8435 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_term8437 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_case_statement_in_term8460 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_term8472 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term8476 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_term8478 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CAST_in_term8496 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term8498 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_term8502 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_term8504 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_identifier_in_term8508 = new BitSet(new long[]{0x0000000000000400L,0x0000C00000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_LPAREN_in_term8511 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term8515 = new BitSet(new long[]{0x0000000800000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_COMMA_in_term8518 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term8522 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_term8526 = new BitSet(new long[]{0x0000000000000400L,0x0000800000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_ARRAY_in_term8533 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_LSQUARE_in_term8538 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_RSQUARE_in_term8540 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_term8545 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term8568 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_CURRENT_in_term8572 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_VALUE_in_term8575 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_FOR_in_term8577 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term8581 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term8609 = new BitSet(new long[]{0x0200400000140000L,0x5040000000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_literal_or_bind_in_term8614 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_VALUES_in_term8616 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_FOR_in_term8618 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term8622 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions8667 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_expressions8673 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions8679 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths8710 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_jarpaths8716 = new BitSet(new long[]{0x0200400000100000L,0x5040000000100080L,0x0040200000000000L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths8722 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions8755 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_expressions8763 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions8769 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types8800 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_data_types8807 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types8813 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_identifier_in_function_argument8838 = new BitSet(new long[]{0x0002008000000402L,0x000AC00000000000L});
	public static final BitSet FOLLOW_LPAREN_in_function_argument8841 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8845 = new BitSet(new long[]{0x0000000800000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_COMMA_in_function_argument8848 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8852 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_function_argument8856 = new BitSet(new long[]{0x0002008000000402L,0x000A800000000000L});
	public static final BitSet FOLLOW_ARRAY_in_function_argument8862 = new BitSet(new long[]{0x0002008000000002L,0x000A800000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_function_argument8868 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument8873 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_RSQUARE_in_function_argument8877 = new BitSet(new long[]{0x0002008000000002L,0x000A000000000000L});
	public static final BitSet FOLLOW_CONSTANT_in_function_argument8886 = new BitSet(new long[]{0x0002000000000002L,0x000A000000000000L});
	public static final BitSet FOLLOW_DEFAULTVALUE_in_function_argument8891 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_function_argument8893 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_function_argument8899 = new BitSet(new long[]{0x0000000000000002L,0x000A000000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_function_argument8904 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_function_argument8906 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_function_argument8912 = new BitSet(new long[]{0x0000000000000002L,0x0002000000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_function_argument8918 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_EQ_in_function_argument8920 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_function_argument8926 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_value_expression_list8956 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list8962 = new BitSet(new long[]{0x0000000800000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_COMMA_in_value_expression_list8968 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100080L,0x0040200000008000L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list8974 = new BitSet(new long[]{0x0000000800000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_RPAREN_in_value_expression_list8981 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_index_name9002 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_cursor_name9029 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_table_name9057 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_table_name9071 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_DOT_in_table_name9073 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_table_identifier_in_table_name9077 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name9105 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name9119 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_DOT_in_from_table_name9121 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_table_identifier_in_from_table_name9125 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_table_identifier9152 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_literal_or_bind9184 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_literal_or_bind9198 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_hex_literal_in_literal9232 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bin_literal_in_literal9246 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal9260 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_literal9274 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_literal9288 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_literal9303 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NULL_in_literal9316 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_literal9328 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_literal9341 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_literal9355 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal9359 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_int_or_long_literal9386 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HEX_LITERAL_in_hex_literal9426 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_hex_literal9437 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_BIN_LITERAL_in_bin_literal9492 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_bin_literal9503 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_BIND_NAME_in_bind_name9546 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_bind_name9559 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_parseNoReserved_in_identifier9588 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_parseNoReserved9615 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement9642 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_case_statement9646 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_WHEN_in_case_statement9649 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_case_statement9653 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement9655 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_case_statement9659 = new BitSet(new long[]{0x4000000000000000L,0x0000000000000001L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_ELSE_in_case_statement9666 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_case_statement9670 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_END_in_case_statement9676 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement9686 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_WHEN_in_case_statement9689 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_case_statement9693 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement9695 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_case_statement9699 = new BitSet(new long[]{0x4000000000000000L,0x0000000000000001L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_ELSE_in_case_statement9706 = new BitSet(new long[]{0x0200440003140400L,0x54C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_expression_in_case_statement9710 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_END_in_case_statement9716 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_synpred1_PhoenixSQL7232 = new BitSet(new long[]{0x0200440003140400L,0x50C4400000100090L,0x0040200000008000L});
	public static final BitSet FOLLOW_boolean_expression_in_synpred1_PhoenixSQL7235 = new BitSet(new long[]{0x0000000000000002L});
}
