// $ANTLR 3.5.2 PhoenixSQL.g 2025-10-07 16:50:46

/**
 * Copyright 2010 The Apache Software Foundation
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.parse;
///CLOVER:OFF


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

@SuppressWarnings("all")
public class PhoenixSQLLexer extends Lexer {
	public static final int EOF=-1;
	public static final int ACTIVE=4;
	public static final int ADD=5;
	public static final int ALL=6;
	public static final int ALTER=7;
	public static final int AND=8;
	public static final int ANY=9;
	public static final int ARRAY=10;
	public static final int AS=11;
	public static final int ASC=12;
	public static final int ASTERISK=13;
	public static final int ASYNC=14;
	public static final int AT=15;
	public static final int B=16;
	public static final int BETWEEN=17;
	public static final int BIND_NAME=18;
	public static final int BIN_DIGIT=19;
	public static final int BIN_LITERAL=20;
	public static final int BY=21;
	public static final int CACHE=22;
	public static final int CASCADE=23;
	public static final int CASE=24;
	public static final int CAST=25;
	public static final int CDC=26;
	public static final int CHANGE=27;
	public static final int CHAR=28;
	public static final int CHAR_ESC=29;
	public static final int CLOSE=30;
	public static final int COLON=31;
	public static final int COLUMN=32;
	public static final int COLUMNS=33;
	public static final int COLUMN_QUALIFIER_COUNTER=34;
	public static final int COMMA=35;
	public static final int COMMENT_AND_HINT_END=36;
	public static final int COMMENT_START=37;
	public static final int CONCAT=38;
	public static final int CONSTANT=39;
	public static final int CONSTRAINT=40;
	public static final int CREATE=41;
	public static final int CURRENT=42;
	public static final int CURSOR=43;
	public static final int CYCLE=44;
	public static final int DBL_QUOTE_CHAR=45;
	public static final int DECIMAL=46;
	public static final int DECLARE=47;
	public static final int DEFAULT=48;
	public static final int DEFAULTVALUE=49;
	public static final int DELETE=50;
	public static final int DESC=51;
	public static final int DIGIT=52;
	public static final int DISABLE=53;
	public static final int DISTINCT=54;
	public static final int DIVIDE=55;
	public static final int DOT=56;
	public static final int DOUBLE=57;
	public static final int DOUBLE_EQ=58;
	public static final int DOUBLE_QUOTE=59;
	public static final int DROP=60;
	public static final int DUPLICATE=61;
	public static final int ELSE=62;
	public static final int ENCODED_QUALIFIER=63;
	public static final int END=64;
	public static final int EOL=65;
	public static final int EQ=66;
	public static final int EXECUTE=67;
	public static final int EXISTS=68;
	public static final int EXPLAIN=69;
	public static final int Exponent=70;
	public static final int FALSE=71;
	public static final int FETCH=72;
	public static final int FIELDCHAR=73;
	public static final int FIRST=74;
	public static final int FOR=75;
	public static final int FROM=76;
	public static final int FULL=77;
	public static final int FUNCTION=78;
	public static final int GRANT=79;
	public static final int GROUP=80;
	public static final int GT=81;
	public static final int HAVING=82;
	public static final int HEX_DIGIT=83;
	public static final int HEX_LITERAL=84;
	public static final int HINT_START=85;
	public static final int IF=86;
	public static final int IGNORE=87;
	public static final int ILIKE=88;
	public static final int IMMUTABLE=89;
	public static final int IN=90;
	public static final int INCLUDE=91;
	public static final int INCREMENT=92;
	public static final int INDEX=93;
	public static final int INNER=94;
	public static final int INTO=95;
	public static final int IS=96;
	public static final int JAR=97;
	public static final int JARS=98;
	public static final int JOIN=99;
	public static final int KEY=100;
	public static final int LAST=101;
	public static final int LATEST=102;
	public static final int LCURLY=103;
	public static final int LEFT=104;
	public static final int LETTER=105;
	public static final int LIKE=106;
	public static final int LIMIT=107;
	public static final int LIST=108;
	public static final int LOCAL=109;
	public static final int LPAREN=110;
	public static final int LSQUARE=111;
	public static final int LT=112;
	public static final int MAXVALUE=113;
	public static final int MINUS=114;
	public static final int MINVALUE=115;
	public static final int ML_COMMENT=116;
	public static final int ML_HINT=117;
	public static final int NAME=118;
	public static final int NEXT=119;
	public static final int NOEQ1=120;
	public static final int NOEQ2=121;
	public static final int NOT=122;
	public static final int NOVERIFY=123;
	public static final int NULL=124;
	public static final int NULLS=125;
	public static final int NUMBER=126;
	public static final int OFF=127;
	public static final int OFFSET=128;
	public static final int ON=129;
	public static final int ONLY=130;
	public static final int OPEN=131;
	public static final int OR=132;
	public static final int ORDER=133;
	public static final int OTHER=134;
	public static final int OUTER=135;
	public static final int OUTER_JOIN=136;
	public static final int PERCENT=137;
	public static final int PLUS=138;
	public static final int POSINTEGER=139;
	public static final int POST=140;
	public static final int PRE=141;
	public static final int PRIMARY=142;
	public static final int QUESTION=143;
	public static final int RCURLY=144;
	public static final int REBUILD=145;
	public static final int REGIONS=146;
	public static final int REPLACE=147;
	public static final int RETURNING=148;
	public static final int RETURNS=149;
	public static final int REVOKE=150;
	public static final int RIGHT=151;
	public static final int ROW=152;
	public static final int ROWS=153;
	public static final int ROW_TIMESTAMP=154;
	public static final int RPAREN=155;
	public static final int RSQUARE=156;
	public static final int SAMPLING=157;
	public static final int SCHEMA=158;
	public static final int SCHEMAS=159;
	public static final int SELECT=160;
	public static final int SEMICOLON=161;
	public static final int SEQUENCE=162;
	public static final int SESSION=163;
	public static final int SET=164;
	public static final int SHOW=165;
	public static final int SL_COMMENT=166;
	public static final int SL_COMMENT1=167;
	public static final int SL_COMMENT2=168;
	public static final int SOME=169;
	public static final int SPLIT=170;
	public static final int START=171;
	public static final int STATISTICS=172;
	public static final int STRING_LITERAL=173;
	public static final int TABLE=174;
	public static final int TABLES=175;
	public static final int TABLESAMPLE=176;
	public static final int TEMPORARY=177;
	public static final int THEN=178;
	public static final int TILDE=179;
	public static final int TO=180;
	public static final int TRACE=181;
	public static final int TRUE=182;
	public static final int UNCOVERED=183;
	public static final int UNION=184;
	public static final int UNUSABLE=185;
	public static final int UPDATE=186;
	public static final int UPDATE_ONLY=187;
	public static final int UPGRADE=188;
	public static final int UPSERT=189;
	public static final int USABLE=190;
	public static final int USE=191;
	public static final int USING=192;
	public static final int VALUE=193;
	public static final int VALUES=194;
	public static final int VIEW=195;
	public static final int WHEN=196;
	public static final int WHERE=197;
	public static final int WITH=198;
	public static final int WITHIN=199;
	public static final int WS=200;
	public static final int X=201;




	// delegates
	// delegators
	public Lexer[] getDelegates() {
		return new Lexer[] {};
	}

	public PhoenixSQLLexer() {} 
	public PhoenixSQLLexer(CharStream input) {
		this(input, new RecognizerSharedState());
	}
	public PhoenixSQLLexer(CharStream input, RecognizerSharedState state) {
		super(input,state);
	}
	@Override public String getGrammarFileName() { return "PhoenixSQL.g"; }

	// $ANTLR start "ACTIVE"
	public final void mACTIVE() throws RecognitionException {
		try {
			int _type = ACTIVE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:29:8: ( 'active' )
			// PhoenixSQL.g:29:10: 'active'
			{
			match("active"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ACTIVE"

	// $ANTLR start "ADD"
	public final void mADD() throws RecognitionException {
		try {
			int _type = ADD;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:30:5: ( 'add' )
			// PhoenixSQL.g:30:7: 'add'
			{
			match("add"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ADD"

	// $ANTLR start "ALL"
	public final void mALL() throws RecognitionException {
		try {
			int _type = ALL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:31:5: ( 'all' )
			// PhoenixSQL.g:31:7: 'all'
			{
			match("all"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ALL"

	// $ANTLR start "ALTER"
	public final void mALTER() throws RecognitionException {
		try {
			int _type = ALTER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:32:7: ( 'alter' )
			// PhoenixSQL.g:32:9: 'alter'
			{
			match("alter"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ALTER"

	// $ANTLR start "AND"
	public final void mAND() throws RecognitionException {
		try {
			int _type = AND;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:33:5: ( 'and' )
			// PhoenixSQL.g:33:7: 'and'
			{
			match("and"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "AND"

	// $ANTLR start "ANY"
	public final void mANY() throws RecognitionException {
		try {
			int _type = ANY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:34:5: ( 'any' )
			// PhoenixSQL.g:34:7: 'any'
			{
			match("any"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ANY"

	// $ANTLR start "ARRAY"
	public final void mARRAY() throws RecognitionException {
		try {
			int _type = ARRAY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:35:7: ( 'array' )
			// PhoenixSQL.g:35:9: 'array'
			{
			match("array"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ARRAY"

	// $ANTLR start "AS"
	public final void mAS() throws RecognitionException {
		try {
			int _type = AS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:36:4: ( 'as' )
			// PhoenixSQL.g:36:6: 'as'
			{
			match("as"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "AS"

	// $ANTLR start "ASC"
	public final void mASC() throws RecognitionException {
		try {
			int _type = ASC;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:37:5: ( 'asc' )
			// PhoenixSQL.g:37:7: 'asc'
			{
			match("asc"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ASC"

	// $ANTLR start "ASYNC"
	public final void mASYNC() throws RecognitionException {
		try {
			int _type = ASYNC;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:38:7: ( 'async' )
			// PhoenixSQL.g:38:9: 'async'
			{
			match("async"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ASYNC"

	// $ANTLR start "BETWEEN"
	public final void mBETWEEN() throws RecognitionException {
		try {
			int _type = BETWEEN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:39:9: ( 'between' )
			// PhoenixSQL.g:39:11: 'between'
			{
			match("between"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "BETWEEN"

	// $ANTLR start "BY"
	public final void mBY() throws RecognitionException {
		try {
			int _type = BY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:40:4: ( 'by' )
			// PhoenixSQL.g:40:6: 'by'
			{
			match("by"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "BY"

	// $ANTLR start "CACHE"
	public final void mCACHE() throws RecognitionException {
		try {
			int _type = CACHE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:41:7: ( 'cache' )
			// PhoenixSQL.g:41:9: 'cache'
			{
			match("cache"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CACHE"

	// $ANTLR start "CASCADE"
	public final void mCASCADE() throws RecognitionException {
		try {
			int _type = CASCADE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:42:9: ( 'cascade' )
			// PhoenixSQL.g:42:11: 'cascade'
			{
			match("cascade"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CASCADE"

	// $ANTLR start "CASE"
	public final void mCASE() throws RecognitionException {
		try {
			int _type = CASE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:43:6: ( 'case' )
			// PhoenixSQL.g:43:8: 'case'
			{
			match("case"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CASE"

	// $ANTLR start "CAST"
	public final void mCAST() throws RecognitionException {
		try {
			int _type = CAST;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:44:6: ( 'cast' )
			// PhoenixSQL.g:44:8: 'cast'
			{
			match("cast"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CAST"

	// $ANTLR start "CDC"
	public final void mCDC() throws RecognitionException {
		try {
			int _type = CDC;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:45:5: ( 'cdc' )
			// PhoenixSQL.g:45:7: 'cdc'
			{
			match("cdc"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CDC"

	// $ANTLR start "CHANGE"
	public final void mCHANGE() throws RecognitionException {
		try {
			int _type = CHANGE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:46:8: ( 'change' )
			// PhoenixSQL.g:46:10: 'change'
			{
			match("change"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CHANGE"

	// $ANTLR start "CLOSE"
	public final void mCLOSE() throws RecognitionException {
		try {
			int _type = CLOSE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:47:7: ( 'close' )
			// PhoenixSQL.g:47:9: 'close'
			{
			match("close"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CLOSE"

	// $ANTLR start "COLUMN"
	public final void mCOLUMN() throws RecognitionException {
		try {
			int _type = COLUMN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:48:8: ( 'column' )
			// PhoenixSQL.g:48:10: 'column'
			{
			match("column"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COLUMN"

	// $ANTLR start "COLUMNS"
	public final void mCOLUMNS() throws RecognitionException {
		try {
			int _type = COLUMNS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:49:9: ( 'columns' )
			// PhoenixSQL.g:49:11: 'columns'
			{
			match("columns"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COLUMNS"

	// $ANTLR start "COLUMN_QUALIFIER_COUNTER"
	public final void mCOLUMN_QUALIFIER_COUNTER() throws RecognitionException {
		try {
			int _type = COLUMN_QUALIFIER_COUNTER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:50:26: ( 'column_qualifier_counter' )
			// PhoenixSQL.g:50:28: 'column_qualifier_counter'
			{
			match("column_qualifier_counter"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COLUMN_QUALIFIER_COUNTER"

	// $ANTLR start "CONSTANT"
	public final void mCONSTANT() throws RecognitionException {
		try {
			int _type = CONSTANT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:51:10: ( 'constant' )
			// PhoenixSQL.g:51:12: 'constant'
			{
			match("constant"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CONSTANT"

	// $ANTLR start "CONSTRAINT"
	public final void mCONSTRAINT() throws RecognitionException {
		try {
			int _type = CONSTRAINT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:52:12: ( 'constraint' )
			// PhoenixSQL.g:52:14: 'constraint'
			{
			match("constraint"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CONSTRAINT"

	// $ANTLR start "CREATE"
	public final void mCREATE() throws RecognitionException {
		try {
			int _type = CREATE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:53:8: ( 'create' )
			// PhoenixSQL.g:53:10: 'create'
			{
			match("create"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CREATE"

	// $ANTLR start "CURRENT"
	public final void mCURRENT() throws RecognitionException {
		try {
			int _type = CURRENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:54:9: ( 'current' )
			// PhoenixSQL.g:54:11: 'current'
			{
			match("current"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CURRENT"

	// $ANTLR start "CURSOR"
	public final void mCURSOR() throws RecognitionException {
		try {
			int _type = CURSOR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:55:8: ( 'cursor' )
			// PhoenixSQL.g:55:10: 'cursor'
			{
			match("cursor"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CURSOR"

	// $ANTLR start "CYCLE"
	public final void mCYCLE() throws RecognitionException {
		try {
			int _type = CYCLE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:56:7: ( 'cycle' )
			// PhoenixSQL.g:56:9: 'cycle'
			{
			match("cycle"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CYCLE"

	// $ANTLR start "DECLARE"
	public final void mDECLARE() throws RecognitionException {
		try {
			int _type = DECLARE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:57:9: ( 'declare' )
			// PhoenixSQL.g:57:11: 'declare'
			{
			match("declare"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DECLARE"

	// $ANTLR start "DEFAULT"
	public final void mDEFAULT() throws RecognitionException {
		try {
			int _type = DEFAULT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:58:9: ( 'default' )
			// PhoenixSQL.g:58:11: 'default'
			{
			match("default"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DEFAULT"

	// $ANTLR start "DEFAULTVALUE"
	public final void mDEFAULTVALUE() throws RecognitionException {
		try {
			int _type = DEFAULTVALUE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:59:14: ( 'defaultvalue' )
			// PhoenixSQL.g:59:16: 'defaultvalue'
			{
			match("defaultvalue"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DEFAULTVALUE"

	// $ANTLR start "DELETE"
	public final void mDELETE() throws RecognitionException {
		try {
			int _type = DELETE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:60:8: ( 'delete' )
			// PhoenixSQL.g:60:10: 'delete'
			{
			match("delete"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DELETE"

	// $ANTLR start "DESC"
	public final void mDESC() throws RecognitionException {
		try {
			int _type = DESC;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:61:6: ( 'desc' )
			// PhoenixSQL.g:61:8: 'desc'
			{
			match("desc"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DESC"

	// $ANTLR start "DISABLE"
	public final void mDISABLE() throws RecognitionException {
		try {
			int _type = DISABLE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:62:9: ( 'disable' )
			// PhoenixSQL.g:62:11: 'disable'
			{
			match("disable"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DISABLE"

	// $ANTLR start "DISTINCT"
	public final void mDISTINCT() throws RecognitionException {
		try {
			int _type = DISTINCT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:63:10: ( 'distinct' )
			// PhoenixSQL.g:63:12: 'distinct'
			{
			match("distinct"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DISTINCT"

	// $ANTLR start "DROP"
	public final void mDROP() throws RecognitionException {
		try {
			int _type = DROP;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:64:6: ( 'drop' )
			// PhoenixSQL.g:64:8: 'drop'
			{
			match("drop"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DROP"

	// $ANTLR start "DUPLICATE"
	public final void mDUPLICATE() throws RecognitionException {
		try {
			int _type = DUPLICATE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:65:11: ( 'duplicate' )
			// PhoenixSQL.g:65:13: 'duplicate'
			{
			match("duplicate"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DUPLICATE"

	// $ANTLR start "ELSE"
	public final void mELSE() throws RecognitionException {
		try {
			int _type = ELSE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:66:6: ( 'else' )
			// PhoenixSQL.g:66:8: 'else'
			{
			match("else"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ELSE"

	// $ANTLR start "ENCODED_QUALIFIER"
	public final void mENCODED_QUALIFIER() throws RecognitionException {
		try {
			int _type = ENCODED_QUALIFIER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:67:19: ( 'encoded_qualifier' )
			// PhoenixSQL.g:67:21: 'encoded_qualifier'
			{
			match("encoded_qualifier"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ENCODED_QUALIFIER"

	// $ANTLR start "END"
	public final void mEND() throws RecognitionException {
		try {
			int _type = END;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:68:5: ( 'end' )
			// PhoenixSQL.g:68:7: 'end'
			{
			match("end"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "END"

	// $ANTLR start "EXECUTE"
	public final void mEXECUTE() throws RecognitionException {
		try {
			int _type = EXECUTE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:69:9: ( 'execute' )
			// PhoenixSQL.g:69:11: 'execute'
			{
			match("execute"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EXECUTE"

	// $ANTLR start "EXISTS"
	public final void mEXISTS() throws RecognitionException {
		try {
			int _type = EXISTS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:70:8: ( 'exists' )
			// PhoenixSQL.g:70:10: 'exists'
			{
			match("exists"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EXISTS"

	// $ANTLR start "EXPLAIN"
	public final void mEXPLAIN() throws RecognitionException {
		try {
			int _type = EXPLAIN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:71:9: ( 'explain' )
			// PhoenixSQL.g:71:11: 'explain'
			{
			match("explain"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EXPLAIN"

	// $ANTLR start "FALSE"
	public final void mFALSE() throws RecognitionException {
		try {
			int _type = FALSE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:72:7: ( 'false' )
			// PhoenixSQL.g:72:9: 'false'
			{
			match("false"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FALSE"

	// $ANTLR start "FETCH"
	public final void mFETCH() throws RecognitionException {
		try {
			int _type = FETCH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:73:7: ( 'fetch' )
			// PhoenixSQL.g:73:9: 'fetch'
			{
			match("fetch"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FETCH"

	// $ANTLR start "FIRST"
	public final void mFIRST() throws RecognitionException {
		try {
			int _type = FIRST;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:74:7: ( 'first' )
			// PhoenixSQL.g:74:9: 'first'
			{
			match("first"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FIRST"

	// $ANTLR start "FOR"
	public final void mFOR() throws RecognitionException {
		try {
			int _type = FOR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:75:5: ( 'for' )
			// PhoenixSQL.g:75:7: 'for'
			{
			match("for"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FOR"

	// $ANTLR start "FROM"
	public final void mFROM() throws RecognitionException {
		try {
			int _type = FROM;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:76:6: ( 'from' )
			// PhoenixSQL.g:76:8: 'from'
			{
			match("from"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FROM"

	// $ANTLR start "FULL"
	public final void mFULL() throws RecognitionException {
		try {
			int _type = FULL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:77:6: ( 'full' )
			// PhoenixSQL.g:77:8: 'full'
			{
			match("full"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FULL"

	// $ANTLR start "FUNCTION"
	public final void mFUNCTION() throws RecognitionException {
		try {
			int _type = FUNCTION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:78:10: ( 'function' )
			// PhoenixSQL.g:78:12: 'function'
			{
			match("function"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FUNCTION"

	// $ANTLR start "GRANT"
	public final void mGRANT() throws RecognitionException {
		try {
			int _type = GRANT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:79:7: ( 'grant' )
			// PhoenixSQL.g:79:9: 'grant'
			{
			match("grant"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "GRANT"

	// $ANTLR start "GROUP"
	public final void mGROUP() throws RecognitionException {
		try {
			int _type = GROUP;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:80:7: ( 'group' )
			// PhoenixSQL.g:80:9: 'group'
			{
			match("group"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "GROUP"

	// $ANTLR start "HAVING"
	public final void mHAVING() throws RecognitionException {
		try {
			int _type = HAVING;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:81:8: ( 'having' )
			// PhoenixSQL.g:81:10: 'having'
			{
			match("having"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "HAVING"

	// $ANTLR start "IF"
	public final void mIF() throws RecognitionException {
		try {
			int _type = IF;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:82:4: ( 'if' )
			// PhoenixSQL.g:82:6: 'if'
			{
			match("if"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IF"

	// $ANTLR start "IGNORE"
	public final void mIGNORE() throws RecognitionException {
		try {
			int _type = IGNORE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:83:8: ( 'ignore' )
			// PhoenixSQL.g:83:10: 'ignore'
			{
			match("ignore"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IGNORE"

	// $ANTLR start "ILIKE"
	public final void mILIKE() throws RecognitionException {
		try {
			int _type = ILIKE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:84:7: ( 'ilike' )
			// PhoenixSQL.g:84:9: 'ilike'
			{
			match("ilike"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ILIKE"

	// $ANTLR start "IMMUTABLE"
	public final void mIMMUTABLE() throws RecognitionException {
		try {
			int _type = IMMUTABLE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:85:11: ( 'immutable' )
			// PhoenixSQL.g:85:13: 'immutable'
			{
			match("immutable"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IMMUTABLE"

	// $ANTLR start "IN"
	public final void mIN() throws RecognitionException {
		try {
			int _type = IN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:86:4: ( 'in' )
			// PhoenixSQL.g:86:6: 'in'
			{
			match("in"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IN"

	// $ANTLR start "INCLUDE"
	public final void mINCLUDE() throws RecognitionException {
		try {
			int _type = INCLUDE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:87:9: ( 'include' )
			// PhoenixSQL.g:87:11: 'include'
			{
			match("include"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INCLUDE"

	// $ANTLR start "INCREMENT"
	public final void mINCREMENT() throws RecognitionException {
		try {
			int _type = INCREMENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:88:11: ( 'increment' )
			// PhoenixSQL.g:88:13: 'increment'
			{
			match("increment"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INCREMENT"

	// $ANTLR start "INDEX"
	public final void mINDEX() throws RecognitionException {
		try {
			int _type = INDEX;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:89:7: ( 'index' )
			// PhoenixSQL.g:89:9: 'index'
			{
			match("index"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INDEX"

	// $ANTLR start "INNER"
	public final void mINNER() throws RecognitionException {
		try {
			int _type = INNER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:90:7: ( 'inner' )
			// PhoenixSQL.g:90:9: 'inner'
			{
			match("inner"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INNER"

	// $ANTLR start "INTO"
	public final void mINTO() throws RecognitionException {
		try {
			int _type = INTO;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:91:6: ( 'into' )
			// PhoenixSQL.g:91:8: 'into'
			{
			match("into"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INTO"

	// $ANTLR start "IS"
	public final void mIS() throws RecognitionException {
		try {
			int _type = IS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:92:4: ( 'is' )
			// PhoenixSQL.g:92:6: 'is'
			{
			match("is"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IS"

	// $ANTLR start "JAR"
	public final void mJAR() throws RecognitionException {
		try {
			int _type = JAR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:93:5: ( 'jar' )
			// PhoenixSQL.g:93:7: 'jar'
			{
			match("jar"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "JAR"

	// $ANTLR start "JARS"
	public final void mJARS() throws RecognitionException {
		try {
			int _type = JARS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:94:6: ( 'jars' )
			// PhoenixSQL.g:94:8: 'jars'
			{
			match("jars"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "JARS"

	// $ANTLR start "JOIN"
	public final void mJOIN() throws RecognitionException {
		try {
			int _type = JOIN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:95:6: ( 'join' )
			// PhoenixSQL.g:95:8: 'join'
			{
			match("join"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "JOIN"

	// $ANTLR start "KEY"
	public final void mKEY() throws RecognitionException {
		try {
			int _type = KEY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:96:5: ( 'key' )
			// PhoenixSQL.g:96:7: 'key'
			{
			match("key"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "KEY"

	// $ANTLR start "LAST"
	public final void mLAST() throws RecognitionException {
		try {
			int _type = LAST;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:97:6: ( 'last' )
			// PhoenixSQL.g:97:8: 'last'
			{
			match("last"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LAST"

	// $ANTLR start "LATEST"
	public final void mLATEST() throws RecognitionException {
		try {
			int _type = LATEST;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:98:8: ( 'latest' )
			// PhoenixSQL.g:98:10: 'latest'
			{
			match("latest"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LATEST"

	// $ANTLR start "LEFT"
	public final void mLEFT() throws RecognitionException {
		try {
			int _type = LEFT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:99:6: ( 'left' )
			// PhoenixSQL.g:99:8: 'left'
			{
			match("left"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LEFT"

	// $ANTLR start "LIKE"
	public final void mLIKE() throws RecognitionException {
		try {
			int _type = LIKE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:100:6: ( 'like' )
			// PhoenixSQL.g:100:8: 'like'
			{
			match("like"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LIKE"

	// $ANTLR start "LIMIT"
	public final void mLIMIT() throws RecognitionException {
		try {
			int _type = LIMIT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:101:7: ( 'limit' )
			// PhoenixSQL.g:101:9: 'limit'
			{
			match("limit"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LIMIT"

	// $ANTLR start "LIST"
	public final void mLIST() throws RecognitionException {
		try {
			int _type = LIST;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:102:6: ( 'list' )
			// PhoenixSQL.g:102:8: 'list'
			{
			match("list"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LIST"

	// $ANTLR start "LOCAL"
	public final void mLOCAL() throws RecognitionException {
		try {
			int _type = LOCAL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:103:7: ( 'local' )
			// PhoenixSQL.g:103:9: 'local'
			{
			match("local"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LOCAL"

	// $ANTLR start "MAXVALUE"
	public final void mMAXVALUE() throws RecognitionException {
		try {
			int _type = MAXVALUE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:104:10: ( 'maxvalue' )
			// PhoenixSQL.g:104:12: 'maxvalue'
			{
			match("maxvalue"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MAXVALUE"

	// $ANTLR start "MINVALUE"
	public final void mMINVALUE() throws RecognitionException {
		try {
			int _type = MINVALUE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:105:10: ( 'minvalue' )
			// PhoenixSQL.g:105:12: 'minvalue'
			{
			match("minvalue"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MINVALUE"

	// $ANTLR start "NEXT"
	public final void mNEXT() throws RecognitionException {
		try {
			int _type = NEXT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:106:6: ( 'next' )
			// PhoenixSQL.g:106:8: 'next'
			{
			match("next"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NEXT"

	// $ANTLR start "NOT"
	public final void mNOT() throws RecognitionException {
		try {
			int _type = NOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:107:5: ( 'not' )
			// PhoenixSQL.g:107:7: 'not'
			{
			match("not"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NOT"

	// $ANTLR start "NOVERIFY"
	public final void mNOVERIFY() throws RecognitionException {
		try {
			int _type = NOVERIFY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:108:10: ( 'noverify' )
			// PhoenixSQL.g:108:12: 'noverify'
			{
			match("noverify"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NOVERIFY"

	// $ANTLR start "NULL"
	public final void mNULL() throws RecognitionException {
		try {
			int _type = NULL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:109:6: ( 'null' )
			// PhoenixSQL.g:109:8: 'null'
			{
			match("null"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NULL"

	// $ANTLR start "NULLS"
	public final void mNULLS() throws RecognitionException {
		try {
			int _type = NULLS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:110:7: ( 'nulls' )
			// PhoenixSQL.g:110:9: 'nulls'
			{
			match("nulls"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NULLS"

	// $ANTLR start "OFF"
	public final void mOFF() throws RecognitionException {
		try {
			int _type = OFF;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:111:5: ( 'off' )
			// PhoenixSQL.g:111:7: 'off'
			{
			match("off"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OFF"

	// $ANTLR start "OFFSET"
	public final void mOFFSET() throws RecognitionException {
		try {
			int _type = OFFSET;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:112:8: ( 'offset' )
			// PhoenixSQL.g:112:10: 'offset'
			{
			match("offset"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OFFSET"

	// $ANTLR start "ON"
	public final void mON() throws RecognitionException {
		try {
			int _type = ON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:113:4: ( 'on' )
			// PhoenixSQL.g:113:6: 'on'
			{
			match("on"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ON"

	// $ANTLR start "ONLY"
	public final void mONLY() throws RecognitionException {
		try {
			int _type = ONLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:114:6: ( 'only' )
			// PhoenixSQL.g:114:8: 'only'
			{
			match("only"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ONLY"

	// $ANTLR start "OPEN"
	public final void mOPEN() throws RecognitionException {
		try {
			int _type = OPEN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:115:6: ( 'open' )
			// PhoenixSQL.g:115:8: 'open'
			{
			match("open"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OPEN"

	// $ANTLR start "OR"
	public final void mOR() throws RecognitionException {
		try {
			int _type = OR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:116:4: ( 'or' )
			// PhoenixSQL.g:116:6: 'or'
			{
			match("or"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OR"

	// $ANTLR start "ORDER"
	public final void mORDER() throws RecognitionException {
		try {
			int _type = ORDER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:117:7: ( 'order' )
			// PhoenixSQL.g:117:9: 'order'
			{
			match("order"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ORDER"

	// $ANTLR start "OUTER"
	public final void mOUTER() throws RecognitionException {
		try {
			int _type = OUTER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:118:7: ( 'outer' )
			// PhoenixSQL.g:118:9: 'outer'
			{
			match("outer"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OUTER"

	// $ANTLR start "POST"
	public final void mPOST() throws RecognitionException {
		try {
			int _type = POST;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:119:6: ( 'post' )
			// PhoenixSQL.g:119:8: 'post'
			{
			match("post"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "POST"

	// $ANTLR start "PRE"
	public final void mPRE() throws RecognitionException {
		try {
			int _type = PRE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:120:5: ( 'pre' )
			// PhoenixSQL.g:120:7: 'pre'
			{
			match("pre"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PRE"

	// $ANTLR start "PRIMARY"
	public final void mPRIMARY() throws RecognitionException {
		try {
			int _type = PRIMARY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:121:9: ( 'primary' )
			// PhoenixSQL.g:121:11: 'primary'
			{
			match("primary"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PRIMARY"

	// $ANTLR start "REBUILD"
	public final void mREBUILD() throws RecognitionException {
		try {
			int _type = REBUILD;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:122:9: ( 'rebuild' )
			// PhoenixSQL.g:122:11: 'rebuild'
			{
			match("rebuild"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "REBUILD"

	// $ANTLR start "REGIONS"
	public final void mREGIONS() throws RecognitionException {
		try {
			int _type = REGIONS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:123:9: ( 'regions' )
			// PhoenixSQL.g:123:11: 'regions'
			{
			match("regions"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "REGIONS"

	// $ANTLR start "REPLACE"
	public final void mREPLACE() throws RecognitionException {
		try {
			int _type = REPLACE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:124:9: ( 'replace' )
			// PhoenixSQL.g:124:11: 'replace'
			{
			match("replace"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "REPLACE"

	// $ANTLR start "RETURNING"
	public final void mRETURNING() throws RecognitionException {
		try {
			int _type = RETURNING;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:125:11: ( 'returning' )
			// PhoenixSQL.g:125:13: 'returning'
			{
			match("returning"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RETURNING"

	// $ANTLR start "RETURNS"
	public final void mRETURNS() throws RecognitionException {
		try {
			int _type = RETURNS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:126:9: ( 'returns' )
			// PhoenixSQL.g:126:11: 'returns'
			{
			match("returns"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RETURNS"

	// $ANTLR start "REVOKE"
	public final void mREVOKE() throws RecognitionException {
		try {
			int _type = REVOKE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:127:8: ( 'revoke' )
			// PhoenixSQL.g:127:10: 'revoke'
			{
			match("revoke"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "REVOKE"

	// $ANTLR start "RIGHT"
	public final void mRIGHT() throws RecognitionException {
		try {
			int _type = RIGHT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:128:7: ( 'right' )
			// PhoenixSQL.g:128:9: 'right'
			{
			match("right"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RIGHT"

	// $ANTLR start "ROW"
	public final void mROW() throws RecognitionException {
		try {
			int _type = ROW;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:129:5: ( 'row' )
			// PhoenixSQL.g:129:7: 'row'
			{
			match("row"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ROW"

	// $ANTLR start "ROWS"
	public final void mROWS() throws RecognitionException {
		try {
			int _type = ROWS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:130:6: ( 'rows' )
			// PhoenixSQL.g:130:8: 'rows'
			{
			match("rows"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ROWS"

	// $ANTLR start "ROW_TIMESTAMP"
	public final void mROW_TIMESTAMP() throws RecognitionException {
		try {
			int _type = ROW_TIMESTAMP;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:131:15: ( 'row_timestamp' )
			// PhoenixSQL.g:131:17: 'row_timestamp'
			{
			match("row_timestamp"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ROW_TIMESTAMP"

	// $ANTLR start "SAMPLING"
	public final void mSAMPLING() throws RecognitionException {
		try {
			int _type = SAMPLING;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:132:10: ( 'sampling' )
			// PhoenixSQL.g:132:12: 'sampling'
			{
			match("sampling"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SAMPLING"

	// $ANTLR start "SCHEMA"
	public final void mSCHEMA() throws RecognitionException {
		try {
			int _type = SCHEMA;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:133:8: ( 'schema' )
			// PhoenixSQL.g:133:10: 'schema'
			{
			match("schema"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SCHEMA"

	// $ANTLR start "SCHEMAS"
	public final void mSCHEMAS() throws RecognitionException {
		try {
			int _type = SCHEMAS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:134:9: ( 'schemas' )
			// PhoenixSQL.g:134:11: 'schemas'
			{
			match("schemas"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SCHEMAS"

	// $ANTLR start "SELECT"
	public final void mSELECT() throws RecognitionException {
		try {
			int _type = SELECT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:135:8: ( 'select' )
			// PhoenixSQL.g:135:10: 'select'
			{
			match("select"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SELECT"

	// $ANTLR start "SEQUENCE"
	public final void mSEQUENCE() throws RecognitionException {
		try {
			int _type = SEQUENCE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:136:10: ( 'sequence' )
			// PhoenixSQL.g:136:12: 'sequence'
			{
			match("sequence"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SEQUENCE"

	// $ANTLR start "SESSION"
	public final void mSESSION() throws RecognitionException {
		try {
			int _type = SESSION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:137:9: ( 'session' )
			// PhoenixSQL.g:137:11: 'session'
			{
			match("session"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SESSION"

	// $ANTLR start "SET"
	public final void mSET() throws RecognitionException {
		try {
			int _type = SET;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:138:5: ( 'set' )
			// PhoenixSQL.g:138:7: 'set'
			{
			match("set"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SET"

	// $ANTLR start "SHOW"
	public final void mSHOW() throws RecognitionException {
		try {
			int _type = SHOW;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:139:6: ( 'show' )
			// PhoenixSQL.g:139:8: 'show'
			{
			match("show"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SHOW"

	// $ANTLR start "SOME"
	public final void mSOME() throws RecognitionException {
		try {
			int _type = SOME;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:140:6: ( 'some' )
			// PhoenixSQL.g:140:8: 'some'
			{
			match("some"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SOME"

	// $ANTLR start "SPLIT"
	public final void mSPLIT() throws RecognitionException {
		try {
			int _type = SPLIT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:141:7: ( 'split' )
			// PhoenixSQL.g:141:9: 'split'
			{
			match("split"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SPLIT"

	// $ANTLR start "START"
	public final void mSTART() throws RecognitionException {
		try {
			int _type = START;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:142:7: ( 'start' )
			// PhoenixSQL.g:142:9: 'start'
			{
			match("start"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "START"

	// $ANTLR start "STATISTICS"
	public final void mSTATISTICS() throws RecognitionException {
		try {
			int _type = STATISTICS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:143:12: ( 'statistics' )
			// PhoenixSQL.g:143:14: 'statistics'
			{
			match("statistics"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STATISTICS"

	// $ANTLR start "TABLE"
	public final void mTABLE() throws RecognitionException {
		try {
			int _type = TABLE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:144:7: ( 'table' )
			// PhoenixSQL.g:144:9: 'table'
			{
			match("table"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TABLE"

	// $ANTLR start "TABLES"
	public final void mTABLES() throws RecognitionException {
		try {
			int _type = TABLES;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:145:8: ( 'tables' )
			// PhoenixSQL.g:145:10: 'tables'
			{
			match("tables"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TABLES"

	// $ANTLR start "TABLESAMPLE"
	public final void mTABLESAMPLE() throws RecognitionException {
		try {
			int _type = TABLESAMPLE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:146:13: ( 'tablesample' )
			// PhoenixSQL.g:146:15: 'tablesample'
			{
			match("tablesample"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TABLESAMPLE"

	// $ANTLR start "TEMPORARY"
	public final void mTEMPORARY() throws RecognitionException {
		try {
			int _type = TEMPORARY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:147:11: ( 'temporary' )
			// PhoenixSQL.g:147:13: 'temporary'
			{
			match("temporary"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TEMPORARY"

	// $ANTLR start "THEN"
	public final void mTHEN() throws RecognitionException {
		try {
			int _type = THEN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:148:6: ( 'then' )
			// PhoenixSQL.g:148:8: 'then'
			{
			match("then"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "THEN"

	// $ANTLR start "TO"
	public final void mTO() throws RecognitionException {
		try {
			int _type = TO;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:149:4: ( 'to' )
			// PhoenixSQL.g:149:6: 'to'
			{
			match("to"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TO"

	// $ANTLR start "TRACE"
	public final void mTRACE() throws RecognitionException {
		try {
			int _type = TRACE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:150:7: ( 'trace' )
			// PhoenixSQL.g:150:9: 'trace'
			{
			match("trace"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TRACE"

	// $ANTLR start "TRUE"
	public final void mTRUE() throws RecognitionException {
		try {
			int _type = TRUE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:151:6: ( 'true' )
			// PhoenixSQL.g:151:8: 'true'
			{
			match("true"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TRUE"

	// $ANTLR start "UNCOVERED"
	public final void mUNCOVERED() throws RecognitionException {
		try {
			int _type = UNCOVERED;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:152:11: ( 'uncovered' )
			// PhoenixSQL.g:152:13: 'uncovered'
			{
			match("uncovered"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UNCOVERED"

	// $ANTLR start "UNION"
	public final void mUNION() throws RecognitionException {
		try {
			int _type = UNION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:153:7: ( 'union' )
			// PhoenixSQL.g:153:9: 'union'
			{
			match("union"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UNION"

	// $ANTLR start "UNUSABLE"
	public final void mUNUSABLE() throws RecognitionException {
		try {
			int _type = UNUSABLE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:154:10: ( 'unusable' )
			// PhoenixSQL.g:154:12: 'unusable'
			{
			match("unusable"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UNUSABLE"

	// $ANTLR start "UPDATE"
	public final void mUPDATE() throws RecognitionException {
		try {
			int _type = UPDATE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:155:8: ( 'update' )
			// PhoenixSQL.g:155:10: 'update'
			{
			match("update"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UPDATE"

	// $ANTLR start "UPDATE_ONLY"
	public final void mUPDATE_ONLY() throws RecognitionException {
		try {
			int _type = UPDATE_ONLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:156:13: ( 'update_only' )
			// PhoenixSQL.g:156:15: 'update_only'
			{
			match("update_only"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UPDATE_ONLY"

	// $ANTLR start "UPGRADE"
	public final void mUPGRADE() throws RecognitionException {
		try {
			int _type = UPGRADE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:157:9: ( 'upgrade' )
			// PhoenixSQL.g:157:11: 'upgrade'
			{
			match("upgrade"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UPGRADE"

	// $ANTLR start "UPSERT"
	public final void mUPSERT() throws RecognitionException {
		try {
			int _type = UPSERT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:158:8: ( 'upsert' )
			// PhoenixSQL.g:158:10: 'upsert'
			{
			match("upsert"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UPSERT"

	// $ANTLR start "USABLE"
	public final void mUSABLE() throws RecognitionException {
		try {
			int _type = USABLE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:159:8: ( 'usable' )
			// PhoenixSQL.g:159:10: 'usable'
			{
			match("usable"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "USABLE"

	// $ANTLR start "USE"
	public final void mUSE() throws RecognitionException {
		try {
			int _type = USE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:160:5: ( 'use' )
			// PhoenixSQL.g:160:7: 'use'
			{
			match("use"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "USE"

	// $ANTLR start "USING"
	public final void mUSING() throws RecognitionException {
		try {
			int _type = USING;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:161:7: ( 'using' )
			// PhoenixSQL.g:161:9: 'using'
			{
			match("using"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "USING"

	// $ANTLR start "VALUE"
	public final void mVALUE() throws RecognitionException {
		try {
			int _type = VALUE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:162:7: ( 'value' )
			// PhoenixSQL.g:162:9: 'value'
			{
			match("value"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "VALUE"

	// $ANTLR start "VALUES"
	public final void mVALUES() throws RecognitionException {
		try {
			int _type = VALUES;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:163:8: ( 'values' )
			// PhoenixSQL.g:163:10: 'values'
			{
			match("values"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "VALUES"

	// $ANTLR start "VIEW"
	public final void mVIEW() throws RecognitionException {
		try {
			int _type = VIEW;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:164:6: ( 'view' )
			// PhoenixSQL.g:164:8: 'view'
			{
			match("view"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "VIEW"

	// $ANTLR start "WHEN"
	public final void mWHEN() throws RecognitionException {
		try {
			int _type = WHEN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:165:6: ( 'when' )
			// PhoenixSQL.g:165:8: 'when'
			{
			match("when"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "WHEN"

	// $ANTLR start "WHERE"
	public final void mWHERE() throws RecognitionException {
		try {
			int _type = WHERE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:166:7: ( 'where' )
			// PhoenixSQL.g:166:9: 'where'
			{
			match("where"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "WHERE"

	// $ANTLR start "WITH"
	public final void mWITH() throws RecognitionException {
		try {
			int _type = WITH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:167:6: ( 'with' )
			// PhoenixSQL.g:167:8: 'with'
			{
			match("with"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "WITH"

	// $ANTLR start "WITHIN"
	public final void mWITHIN() throws RecognitionException {
		try {
			int _type = WITHIN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:168:8: ( 'within' )
			// PhoenixSQL.g:168:10: 'within'
			{
			match("within"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "WITHIN"

	// $ANTLR start "HINT_START"
	public final void mHINT_START() throws RecognitionException {
		try {
			int _type = HINT_START;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1331:11: ( '/*+' )
			// PhoenixSQL.g:1331:13: '/*+'
			{
			match("/*+"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "HINT_START"

	// $ANTLR start "COMMENT_START"
	public final void mCOMMENT_START() throws RecognitionException {
		try {
			int _type = COMMENT_START;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1332:14: ( '/*' )
			// PhoenixSQL.g:1332:16: '/*'
			{
			match("/*"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COMMENT_START"

	// $ANTLR start "COMMENT_AND_HINT_END"
	public final void mCOMMENT_AND_HINT_END() throws RecognitionException {
		try {
			int _type = COMMENT_AND_HINT_END;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1333:21: ( '*/' )
			// PhoenixSQL.g:1333:23: '*/'
			{
			match("*/"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COMMENT_AND_HINT_END"

	// $ANTLR start "SL_COMMENT1"
	public final void mSL_COMMENT1() throws RecognitionException {
		try {
			int _type = SL_COMMENT1;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1334:12: ( '//' )
			// PhoenixSQL.g:1334:14: '//'
			{
			match("//"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SL_COMMENT1"

	// $ANTLR start "SL_COMMENT2"
	public final void mSL_COMMENT2() throws RecognitionException {
		try {
			int _type = SL_COMMENT2;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1335:12: ( '--' )
			// PhoenixSQL.g:1335:14: '--'
			{
			match("--"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SL_COMMENT2"

	// $ANTLR start "BIND_NAME"
	public final void mBIND_NAME() throws RecognitionException {
		try {
			int _type = BIND_NAME;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1339:5: ( COLON ( DIGIT )+ )
			// PhoenixSQL.g:1339:7: COLON ( DIGIT )+
			{
			mCOLON(); if (state.failed) return;

			// PhoenixSQL.g:1339:13: ( DIGIT )+
			int cnt1=0;
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( ((LA1_0 >= '0' && LA1_0 <= '9')) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt1 >= 1 ) break loop1;
					if (state.backtracking>0) {state.failed=true; return;}
					EarlyExitException eee = new EarlyExitException(1, input);
					throw eee;
				}
				cnt1++;
			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "BIND_NAME"

	// $ANTLR start "HEX_LITERAL"
	public final void mHEX_LITERAL() throws RecognitionException {
		try {
			int _type = HEX_LITERAL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken d=null;

			 StringBuilder sb = new StringBuilder();
			// PhoenixSQL.g:1344:5: ( X ( ( FIELDCHAR )=> ( FIELDCHAR )+ | ( '\\'' )=> '\\'' ( ' ' )* (d= HEX_DIGIT ( ' ' )* )* '\\'' )? )
			// PhoenixSQL.g:1345:5: X ( ( FIELDCHAR )=> ( FIELDCHAR )+ | ( '\\'' )=> '\\'' ( ' ' )* (d= HEX_DIGIT ( ' ' )* )* '\\'' )?
			{
			mX(); if (state.failed) return;

			if ( state.backtracking==0 ) { _type = NAME;}
			// PhoenixSQL.g:1346:5: ( ( FIELDCHAR )=> ( FIELDCHAR )+ | ( '\\'' )=> '\\'' ( ' ' )* (d= HEX_DIGIT ( ' ' )* )* '\\'' )?
			int alt6=3;
			int LA6_0 = input.LA(1);
			if ( ((LA6_0 >= '0' && LA6_0 <= '9')||(LA6_0 >= 'A' && LA6_0 <= 'Z')||LA6_0=='_'||(LA6_0 >= 'a' && LA6_0 <= 'z')||(LA6_0 >= '\u0080' && LA6_0 <= '\u2001')||(LA6_0 >= '\u2003' && LA6_0 <= '\uFFFE')) && (synpred1_PhoenixSQL())) {
				alt6=1;
			}
			else if ( (LA6_0=='\'') && (synpred2_PhoenixSQL())) {
				alt6=2;
			}
			switch (alt6) {
				case 1 :
					// PhoenixSQL.g:1347:5: ( FIELDCHAR )=> ( FIELDCHAR )+
					{
					// PhoenixSQL.g:1347:20: ( FIELDCHAR )+
					int cnt2=0;
					loop2:
					while (true) {
						int alt2=2;
						int LA2_0 = input.LA(1);
						if ( ((LA2_0 >= '0' && LA2_0 <= '9')||(LA2_0 >= 'A' && LA2_0 <= 'Z')||LA2_0=='_'||(LA2_0 >= 'a' && LA2_0 <= 'z')||(LA2_0 >= '\u0080' && LA2_0 <= '\u2001')||(LA2_0 >= '\u2003' && LA2_0 <= '\uFFFE')) ) {
							alt2=1;
						}

						switch (alt2) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\u2001')||(input.LA(1) >= '\u2003' && input.LA(1) <= '\uFFFE') ) {
								input.consume();
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

						default :
							if ( cnt2 >= 1 ) break loop2;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(2, input);
							throw eee;
						}
						cnt2++;
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:1348:7: ( '\\'' )=> '\\'' ( ' ' )* (d= HEX_DIGIT ( ' ' )* )* '\\''
					{
					match('\''); if (state.failed) return;
					// PhoenixSQL.g:1348:22: ( ' ' )*
					loop3:
					while (true) {
						int alt3=2;
						int LA3_0 = input.LA(1);
						if ( (LA3_0==' ') ) {
							alt3=1;
						}

						switch (alt3) {
						case 1 :
							// PhoenixSQL.g:1348:22: ' '
							{
							match(' '); if (state.failed) return;
							}
							break;

						default :
							break loop3;
						}
					}

					// PhoenixSQL.g:1348:27: (d= HEX_DIGIT ( ' ' )* )*
					loop5:
					while (true) {
						int alt5=2;
						int LA5_0 = input.LA(1);
						if ( ((LA5_0 >= '0' && LA5_0 <= '9')||(LA5_0 >= 'A' && LA5_0 <= 'F')||(LA5_0 >= 'a' && LA5_0 <= 'f')) ) {
							alt5=1;
						}

						switch (alt5) {
						case 1 :
							// PhoenixSQL.g:1348:29: d= HEX_DIGIT ( ' ' )*
							{
							int dStart1253 = getCharIndex();
							int dStartLine1253 = getLine();
							int dStartCharPos1253 = getCharPositionInLine();
							mHEX_DIGIT(); if (state.failed) return;
							d = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, dStart1253, getCharIndex()-1);
							d.setLine(dStartLine1253);
							d.setCharPositionInLine(dStartCharPos1253);

							if ( state.backtracking==0 ) { sb.append(d.getText()); }
							// PhoenixSQL.g:1348:69: ( ' ' )*
							loop4:
							while (true) {
								int alt4=2;
								int LA4_0 = input.LA(1);
								if ( (LA4_0==' ') ) {
									alt4=1;
								}

								switch (alt4) {
								case 1 :
									// PhoenixSQL.g:1348:69: ' '
									{
									match(' '); if (state.failed) return;
									}
									break;

								default :
									break loop4;
								}
							}

							}
							break;

						default :
							break loop5;
						}
					}

					match('\''); if (state.failed) return;
					if ( state.backtracking==0 ) { _type=HEX_LITERAL; }
					}
					break;

			}

			if ( state.backtracking==0 ) { if (_type == HEX_LITERAL) { setText(sb.toString()); } }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "HEX_LITERAL"

	// $ANTLR start "BIN_LITERAL"
	public final void mBIN_LITERAL() throws RecognitionException {
		try {
			int _type = BIN_LITERAL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken d=null;

			 StringBuilder sb = new StringBuilder();
			// PhoenixSQL.g:1355:5: ( B ( ( FIELDCHAR )=> ( FIELDCHAR )+ | ( '\\'' )=> '\\'' ( ' ' )* (d= BIN_DIGIT ( ' ' )* )* '\\'' )? )
			// PhoenixSQL.g:1356:5: B ( ( FIELDCHAR )=> ( FIELDCHAR )+ | ( '\\'' )=> '\\'' ( ' ' )* (d= BIN_DIGIT ( ' ' )* )* '\\'' )?
			{
			mB(); if (state.failed) return;

			if ( state.backtracking==0 ) { _type = NAME;}
			// PhoenixSQL.g:1357:5: ( ( FIELDCHAR )=> ( FIELDCHAR )+ | ( '\\'' )=> '\\'' ( ' ' )* (d= BIN_DIGIT ( ' ' )* )* '\\'' )?
			int alt11=3;
			int LA11_0 = input.LA(1);
			if ( ((LA11_0 >= '0' && LA11_0 <= '9')||(LA11_0 >= 'A' && LA11_0 <= 'Z')||LA11_0=='_'||(LA11_0 >= 'a' && LA11_0 <= 'z')||(LA11_0 >= '\u0080' && LA11_0 <= '\u2001')||(LA11_0 >= '\u2003' && LA11_0 <= '\uFFFE')) && (synpred3_PhoenixSQL())) {
				alt11=1;
			}
			else if ( (LA11_0=='\'') && (synpred4_PhoenixSQL())) {
				alt11=2;
			}
			switch (alt11) {
				case 1 :
					// PhoenixSQL.g:1358:5: ( FIELDCHAR )=> ( FIELDCHAR )+
					{
					// PhoenixSQL.g:1358:20: ( FIELDCHAR )+
					int cnt7=0;
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( ((LA7_0 >= '0' && LA7_0 <= '9')||(LA7_0 >= 'A' && LA7_0 <= 'Z')||LA7_0=='_'||(LA7_0 >= 'a' && LA7_0 <= 'z')||(LA7_0 >= '\u0080' && LA7_0 <= '\u2001')||(LA7_0 >= '\u2003' && LA7_0 <= '\uFFFE')) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\u2001')||(input.LA(1) >= '\u2003' && input.LA(1) <= '\uFFFE') ) {
								input.consume();
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

						default :
							if ( cnt7 >= 1 ) break loop7;
							if (state.backtracking>0) {state.failed=true; return;}
							EarlyExitException eee = new EarlyExitException(7, input);
							throw eee;
						}
						cnt7++;
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:1359:7: ( '\\'' )=> '\\'' ( ' ' )* (d= BIN_DIGIT ( ' ' )* )* '\\''
					{
					match('\''); if (state.failed) return;
					// PhoenixSQL.g:1359:23: ( ' ' )*
					loop8:
					while (true) {
						int alt8=2;
						int LA8_0 = input.LA(1);
						if ( (LA8_0==' ') ) {
							alt8=1;
						}

						switch (alt8) {
						case 1 :
							// PhoenixSQL.g:1359:23: ' '
							{
							match(' '); if (state.failed) return;
							}
							break;

						default :
							break loop8;
						}
					}

					// PhoenixSQL.g:1359:28: (d= BIN_DIGIT ( ' ' )* )*
					loop10:
					while (true) {
						int alt10=2;
						int LA10_0 = input.LA(1);
						if ( ((LA10_0 >= '0' && LA10_0 <= '1')) ) {
							alt10=1;
						}

						switch (alt10) {
						case 1 :
							// PhoenixSQL.g:1359:30: d= BIN_DIGIT ( ' ' )*
							{
							int dStart1347 = getCharIndex();
							int dStartLine1347 = getLine();
							int dStartCharPos1347 = getCharPositionInLine();
							mBIN_DIGIT(); if (state.failed) return;
							d = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, dStart1347, getCharIndex()-1);
							d.setLine(dStartLine1347);
							d.setCharPositionInLine(dStartCharPos1347);

							if ( state.backtracking==0 ) { sb.append(d.getText()); }
							// PhoenixSQL.g:1359:70: ( ' ' )*
							loop9:
							while (true) {
								int alt9=2;
								int LA9_0 = input.LA(1);
								if ( (LA9_0==' ') ) {
									alt9=1;
								}

								switch (alt9) {
								case 1 :
									// PhoenixSQL.g:1359:70: ' '
									{
									match(' '); if (state.failed) return;
									}
									break;

								default :
									break loop9;
								}
							}

							}
							break;

						default :
							break loop10;
						}
					}

					match('\''); if (state.failed) return;
					if ( state.backtracking==0 ) { _type=BIN_LITERAL; }
					}
					break;

			}

			if ( state.backtracking==0 ) { if (_type == BIN_LITERAL) { setText(sb.toString()); } }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "BIN_LITERAL"

	// $ANTLR start "NAME"
	public final void mNAME() throws RecognitionException {
		try {
			int _type = NAME;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1365:5: ( LETTER ( FIELDCHAR )* | '\\\"' ( DBL_QUOTE_CHAR )* '\\\"' )
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( ((LA14_0 >= 'A' && LA14_0 <= 'Z')||(LA14_0 >= 'a' && LA14_0 <= 'z')) ) {
				alt14=1;
			}
			else if ( (LA14_0=='\"') ) {
				alt14=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 14, 0, input);
				throw nvae;
			}

			switch (alt14) {
				case 1 :
					// PhoenixSQL.g:1365:10: LETTER ( FIELDCHAR )*
					{
					mLETTER(); if (state.failed) return;

					// PhoenixSQL.g:1365:17: ( FIELDCHAR )*
					loop12:
					while (true) {
						int alt12=2;
						int LA12_0 = input.LA(1);
						if ( ((LA12_0 >= '0' && LA12_0 <= '9')||(LA12_0 >= 'A' && LA12_0 <= 'Z')||LA12_0=='_'||(LA12_0 >= 'a' && LA12_0 <= 'z')||(LA12_0 >= '\u0080' && LA12_0 <= '\u2001')||(LA12_0 >= '\u2003' && LA12_0 <= '\uFFFE')) ) {
							alt12=1;
						}

						switch (alt12) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\u2001')||(input.LA(1) >= '\u2003' && input.LA(1) <= '\uFFFE') ) {
								input.consume();
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

						default :
							break loop12;
						}
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:1366:10: '\\\"' ( DBL_QUOTE_CHAR )* '\\\"'
					{
					match('\"'); if (state.failed) return;
					// PhoenixSQL.g:1366:15: ( DBL_QUOTE_CHAR )*
					loop13:
					while (true) {
						int alt13=2;
						int LA13_0 = input.LA(1);
						if ( ((LA13_0 >= '\u0000' && LA13_0 <= '!')||(LA13_0 >= '#' && LA13_0 <= '\uFFFF')) ) {
							alt13=1;
						}

						switch (alt13) {
						case 1 :
							// PhoenixSQL.g:1366:16: DBL_QUOTE_CHAR
							{
							mDBL_QUOTE_CHAR(); if (state.failed) return;

							}
							break;

						default :
							break loop13;
						}
					}

					match('\"'); if (state.failed) return;
					}
					break;

			}
			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NAME"

	// $ANTLR start "NUMBER"
	public final void mNUMBER() throws RecognitionException {
		try {
			int _type = NUMBER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1371:5: ( POSINTEGER )
			// PhoenixSQL.g:1371:9: POSINTEGER
			{
			mPOSINTEGER(); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NUMBER"

	// $ANTLR start "DECIMAL"
	public final void mDECIMAL() throws RecognitionException {
		try {
			int _type = DECIMAL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1375:2: ( ( POSINTEGER )? '.' POSINTEGER )
			// PhoenixSQL.g:1375:4: ( POSINTEGER )? '.' POSINTEGER
			{
			// PhoenixSQL.g:1375:4: ( POSINTEGER )?
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( ((LA15_0 >= '0' && LA15_0 <= '9')) ) {
				alt15=1;
			}
			switch (alt15) {
				case 1 :
					// PhoenixSQL.g:1375:4: POSINTEGER
					{
					mPOSINTEGER(); if (state.failed) return;

					}
					break;

			}

			match('.'); if (state.failed) return;
			mPOSINTEGER(); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DECIMAL"

	// $ANTLR start "DOUBLE"
	public final void mDOUBLE() throws RecognitionException {
		try {
			int _type = DOUBLE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1379:5: ( '.' POSINTEGER Exponent | POSINTEGER '.' Exponent | POSINTEGER ( '.' ( POSINTEGER ( Exponent )? )? | Exponent ) )
			int alt19=3;
			alt19 = dfa19.predict(input);
			switch (alt19) {
				case 1 :
					// PhoenixSQL.g:1379:9: '.' POSINTEGER Exponent
					{
					match('.'); if (state.failed) return;
					mPOSINTEGER(); if (state.failed) return;

					mExponent(); if (state.failed) return;

					}
					break;
				case 2 :
					// PhoenixSQL.g:1380:9: POSINTEGER '.' Exponent
					{
					mPOSINTEGER(); if (state.failed) return;

					match('.'); if (state.failed) return;
					mExponent(); if (state.failed) return;

					}
					break;
				case 3 :
					// PhoenixSQL.g:1381:9: POSINTEGER ( '.' ( POSINTEGER ( Exponent )? )? | Exponent )
					{
					mPOSINTEGER(); if (state.failed) return;

					// PhoenixSQL.g:1381:20: ( '.' ( POSINTEGER ( Exponent )? )? | Exponent )
					int alt18=2;
					int LA18_0 = input.LA(1);
					if ( (LA18_0=='.') ) {
						alt18=1;
					}
					else if ( (LA18_0=='E'||LA18_0=='e') ) {
						alt18=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 18, 0, input);
						throw nvae;
					}

					switch (alt18) {
						case 1 :
							// PhoenixSQL.g:1381:21: '.' ( POSINTEGER ( Exponent )? )?
							{
							match('.'); if (state.failed) return;
							// PhoenixSQL.g:1381:25: ( POSINTEGER ( Exponent )? )?
							int alt17=2;
							int LA17_0 = input.LA(1);
							if ( ((LA17_0 >= '0' && LA17_0 <= '9')) ) {
								alt17=1;
							}
							switch (alt17) {
								case 1 :
									// PhoenixSQL.g:1381:26: POSINTEGER ( Exponent )?
									{
									mPOSINTEGER(); if (state.failed) return;

									// PhoenixSQL.g:1381:37: ( Exponent )?
									int alt16=2;
									int LA16_0 = input.LA(1);
									if ( (LA16_0=='E'||LA16_0=='e') ) {
										alt16=1;
									}
									switch (alt16) {
										case 1 :
											// PhoenixSQL.g:1381:38: Exponent
											{
											mExponent(); if (state.failed) return;

											}
											break;

									}

									}
									break;

							}

							}
							break;
						case 2 :
							// PhoenixSQL.g:1381:53: Exponent
							{
							mExponent(); if (state.failed) return;

							}
							break;

					}

					}
					break;

			}
			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOUBLE"

	// $ANTLR start "Exponent"
	public final void mExponent() throws RecognitionException {
		try {
			int _type = Exponent;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1385:5: ( ( 'e' | 'E' ) ( PLUS | MINUS )? POSINTEGER )
			// PhoenixSQL.g:1385:10: ( 'e' | 'E' ) ( PLUS | MINUS )? POSINTEGER
			{
			if ( input.LA(1)=='E'||input.LA(1)=='e' ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			// PhoenixSQL.g:1385:22: ( PLUS | MINUS )?
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0=='+'||LA20_0=='-') ) {
				alt20=1;
			}
			switch (alt20) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( input.LA(1)=='+'||input.LA(1)=='-' ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

			}

			mPOSINTEGER(); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "Exponent"

	// $ANTLR start "DOUBLE_QUOTE"
	public final void mDOUBLE_QUOTE() throws RecognitionException {
		try {
			int _type = DOUBLE_QUOTE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1389:5: ( '\"' )
			// PhoenixSQL.g:1389:9: '\"'
			{
			match('\"'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOUBLE_QUOTE"

	// $ANTLR start "EQ"
	public final void mEQ() throws RecognitionException {
		try {
			int _type = EQ;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1393:5: ( '=' )
			// PhoenixSQL.g:1393:9: '='
			{
			match('='); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EQ"

	// $ANTLR start "LT"
	public final void mLT() throws RecognitionException {
		try {
			int _type = LT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1397:5: ( '<' )
			// PhoenixSQL.g:1397:9: '<'
			{
			match('<'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LT"

	// $ANTLR start "GT"
	public final void mGT() throws RecognitionException {
		try {
			int _type = GT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1401:5: ( '>' )
			// PhoenixSQL.g:1401:9: '>'
			{
			match('>'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "GT"

	// $ANTLR start "DOUBLE_EQ"
	public final void mDOUBLE_EQ() throws RecognitionException {
		try {
			int _type = DOUBLE_EQ;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1405:5: ( '=' '=' )
			// PhoenixSQL.g:1405:9: '=' '='
			{
			match('='); if (state.failed) return;
			match('='); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOUBLE_EQ"

	// $ANTLR start "NOEQ1"
	public final void mNOEQ1() throws RecognitionException {
		try {
			int _type = NOEQ1;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1409:5: ( '!' '=' )
			// PhoenixSQL.g:1409:9: '!' '='
			{
			match('!'); if (state.failed) return;
			match('='); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NOEQ1"

	// $ANTLR start "NOEQ2"
	public final void mNOEQ2() throws RecognitionException {
		try {
			int _type = NOEQ2;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1413:5: ( '<' '>' )
			// PhoenixSQL.g:1413:9: '<' '>'
			{
			match('<'); if (state.failed) return;
			match('>'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NOEQ2"

	// $ANTLR start "CONCAT"
	public final void mCONCAT() throws RecognitionException {
		try {
			int _type = CONCAT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1417:5: ( '|' '|' )
			// PhoenixSQL.g:1417:9: '|' '|'
			{
			match('|'); if (state.failed) return;
			match('|'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CONCAT"

	// $ANTLR start "COMMA"
	public final void mCOMMA() throws RecognitionException {
		try {
			int _type = COMMA;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1421:5: ( ',' )
			// PhoenixSQL.g:1421:9: ','
			{
			match(','); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COMMA"

	// $ANTLR start "LPAREN"
	public final void mLPAREN() throws RecognitionException {
		try {
			int _type = LPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1425:5: ( '(' )
			// PhoenixSQL.g:1425:9: '('
			{
			match('('); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LPAREN"

	// $ANTLR start "RPAREN"
	public final void mRPAREN() throws RecognitionException {
		try {
			int _type = RPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1429:5: ( ')' )
			// PhoenixSQL.g:1429:9: ')'
			{
			match(')'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RPAREN"

	// $ANTLR start "SEMICOLON"
	public final void mSEMICOLON() throws RecognitionException {
		try {
			int _type = SEMICOLON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1433:5: ( ';' )
			// PhoenixSQL.g:1433:9: ';'
			{
			match(';'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SEMICOLON"

	// $ANTLR start "COLON"
	public final void mCOLON() throws RecognitionException {
		try {
			int _type = COLON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1437:5: ( ':' )
			// PhoenixSQL.g:1437:9: ':'
			{
			match(':'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COLON"

	// $ANTLR start "QUESTION"
	public final void mQUESTION() throws RecognitionException {
		try {
			int _type = QUESTION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1441:5: ( '?' )
			// PhoenixSQL.g:1441:9: '?'
			{
			match('?'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "QUESTION"

	// $ANTLR start "LSQUARE"
	public final void mLSQUARE() throws RecognitionException {
		try {
			int _type = LSQUARE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1445:5: ( '[' )
			// PhoenixSQL.g:1445:9: '['
			{
			match('['); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LSQUARE"

	// $ANTLR start "RSQUARE"
	public final void mRSQUARE() throws RecognitionException {
		try {
			int _type = RSQUARE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1449:5: ( ']' )
			// PhoenixSQL.g:1449:9: ']'
			{
			match(']'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RSQUARE"

	// $ANTLR start "LCURLY"
	public final void mLCURLY() throws RecognitionException {
		try {
			int _type = LCURLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1453:5: ( '{' )
			// PhoenixSQL.g:1453:9: '{'
			{
			match('{'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LCURLY"

	// $ANTLR start "RCURLY"
	public final void mRCURLY() throws RecognitionException {
		try {
			int _type = RCURLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1457:5: ( '}' )
			// PhoenixSQL.g:1457:9: '}'
			{
			match('}'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RCURLY"

	// $ANTLR start "AT"
	public final void mAT() throws RecognitionException {
		try {
			int _type = AT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1461:5: ( '@' )
			// PhoenixSQL.g:1461:9: '@'
			{
			match('@'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "AT"

	// $ANTLR start "TILDE"
	public final void mTILDE() throws RecognitionException {
		try {
			int _type = TILDE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1465:5: ( '~' )
			// PhoenixSQL.g:1465:9: '~'
			{
			match('~'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TILDE"

	// $ANTLR start "PLUS"
	public final void mPLUS() throws RecognitionException {
		try {
			int _type = PLUS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1469:5: ( '+' )
			// PhoenixSQL.g:1469:9: '+'
			{
			match('+'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PLUS"

	// $ANTLR start "MINUS"
	public final void mMINUS() throws RecognitionException {
		try {
			int _type = MINUS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1473:5: ( '-' )
			// PhoenixSQL.g:1473:9: '-'
			{
			match('-'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MINUS"

	// $ANTLR start "ASTERISK"
	public final void mASTERISK() throws RecognitionException {
		try {
			int _type = ASTERISK;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1477:5: ( '*' )
			// PhoenixSQL.g:1477:9: '*'
			{
			match('*'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ASTERISK"

	// $ANTLR start "DIVIDE"
	public final void mDIVIDE() throws RecognitionException {
		try {
			int _type = DIVIDE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1481:5: ( '/' )
			// PhoenixSQL.g:1481:9: '/'
			{
			match('/'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DIVIDE"

	// $ANTLR start "PERCENT"
	public final void mPERCENT() throws RecognitionException {
		try {
			int _type = PERCENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1485:5: ( '%' )
			// PhoenixSQL.g:1485:9: '%'
			{
			match('%'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PERCENT"

	// $ANTLR start "OUTER_JOIN"
	public final void mOUTER_JOIN() throws RecognitionException {
		try {
			int _type = OUTER_JOIN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1489:5: ( '(' '+' ')' )
			// PhoenixSQL.g:1489:7: '(' '+' ')'
			{
			match('('); if (state.failed) return;
			match('+'); if (state.failed) return;
			match(')'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OUTER_JOIN"

	// $ANTLR start "FIELDCHAR"
	public final void mFIELDCHAR() throws RecognitionException {
		try {
			// PhoenixSQL.g:1495:5: ( LETTER | DIGIT | '_' | '\\u0080' .. '\\u2001' | '\\u2003' .. '\\ufffe' )
			// PhoenixSQL.g:
			{
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\u2001')||(input.LA(1) >= '\u2003' && input.LA(1) <= '\uFFFE') ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FIELDCHAR"

	// $ANTLR start "LETTER"
	public final void mLETTER() throws RecognitionException {
		try {
			// PhoenixSQL.g:1505:5: ( 'a' .. 'z' | 'A' .. 'Z' )
			// PhoenixSQL.g:
			{
			if ( (input.LA(1) >= 'A' && input.LA(1) <= 'Z')||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LETTER"

	// $ANTLR start "POSINTEGER"
	public final void mPOSINTEGER() throws RecognitionException {
		try {
			// PhoenixSQL.g:1511:5: ( ( DIGIT )+ )
			// PhoenixSQL.g:1511:9: ( DIGIT )+
			{
			// PhoenixSQL.g:1511:9: ( DIGIT )+
			int cnt21=0;
			loop21:
			while (true) {
				int alt21=2;
				int LA21_0 = input.LA(1);
				if ( ((LA21_0 >= '0' && LA21_0 <= '9')) ) {
					alt21=1;
				}

				switch (alt21) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt21 >= 1 ) break loop21;
					if (state.backtracking>0) {state.failed=true; return;}
					EarlyExitException eee = new EarlyExitException(21, input);
					throw eee;
				}
				cnt21++;
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "POSINTEGER"

	// $ANTLR start "DIGIT"
	public final void mDIGIT() throws RecognitionException {
		try {
			// PhoenixSQL.g:1516:5: ( '0' .. '9' )
			// PhoenixSQL.g:
			{
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DIGIT"

	// $ANTLR start "HEX_DIGIT"
	public final void mHEX_DIGIT() throws RecognitionException {
		try {
			// PhoenixSQL.g:1521:5: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )
			// PhoenixSQL.g:
			{
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "HEX_DIGIT"

	// $ANTLR start "BIN_DIGIT"
	public final void mBIN_DIGIT() throws RecognitionException {
		try {
			// PhoenixSQL.g:1526:5: ( ( '0' | '1' ) )
			// PhoenixSQL.g:
			{
			if ( (input.LA(1) >= '0' && input.LA(1) <= '1') ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "BIN_DIGIT"

	// $ANTLR start "STRING_LITERAL"
	public final void mSTRING_LITERAL() throws RecognitionException {
		try {
			int _type = STRING_LITERAL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken t=null;

			 StringBuilder sb = new StringBuilder(); 
			// PhoenixSQL.g:1531:5: ( '\\'' (t= CHAR |t= CHAR_ESC )* '\\'' )
			// PhoenixSQL.g:1531:9: '\\'' (t= CHAR |t= CHAR_ESC )* '\\''
			{
			match('\''); if (state.failed) return;
			// PhoenixSQL.g:1532:5: (t= CHAR |t= CHAR_ESC )*
			loop22:
			while (true) {
				int alt22=3;
				int LA22_0 = input.LA(1);
				if ( (LA22_0=='\'') ) {
					int LA22_1 = input.LA(2);
					if ( (LA22_1=='\'') ) {
						alt22=2;
					}

				}
				else if ( ((LA22_0 >= '\u0000' && LA22_0 <= '&')||(LA22_0 >= '(' && LA22_0 <= '[')||(LA22_0 >= ']' && LA22_0 <= '\uFFFF')) ) {
					alt22=1;
				}
				else if ( (LA22_0=='\\') ) {
					alt22=2;
				}

				switch (alt22) {
				case 1 :
					// PhoenixSQL.g:1532:7: t= CHAR
					{
					int tStart2266 = getCharIndex();
					int tStartLine2266 = getLine();
					int tStartCharPos2266 = getCharPositionInLine();
					mCHAR(); if (state.failed) return;
					t = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, tStart2266, getCharIndex()-1);
					t.setLine(tStartLine2266);
					t.setCharPositionInLine(tStartCharPos2266);

					if ( state.backtracking==0 ) { sb.append(t.getText()); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1533:7: t= CHAR_ESC
					{
					int tStart2279 = getCharIndex();
					int tStartLine2279 = getLine();
					int tStartCharPos2279 = getCharPositionInLine();
					mCHAR_ESC(); if (state.failed) return;
					t = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, tStart2279, getCharIndex()-1);
					t.setLine(tStartLine2279);
					t.setCharPositionInLine(tStartCharPos2279);

					if ( state.backtracking==0 ) { sb.append(getText()); }
					}
					break;

				default :
					break loop22;
				}
			}

			match('\''); if (state.failed) return;
			if ( state.backtracking==0 ) { setText(sb.toString()); }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STRING_LITERAL"

	// $ANTLR start "CHAR"
	public final void mCHAR() throws RecognitionException {
		try {
			// PhoenixSQL.g:1540:5: ( (~ ( '\\'' | '\\\\' ) ) )
			// PhoenixSQL.g:
			{
			if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '\uFFFF') ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CHAR"

	// $ANTLR start "DBL_QUOTE_CHAR"
	public final void mDBL_QUOTE_CHAR() throws RecognitionException {
		try {
			// PhoenixSQL.g:1545:5: ( (~ ( '\\\"' ) )+ )
			// PhoenixSQL.g:1545:9: (~ ( '\\\"' ) )+
			{
			// PhoenixSQL.g:1545:9: (~ ( '\\\"' ) )+
			int cnt23=0;
			loop23:
			while (true) {
				int alt23=2;
				int LA23_0 = input.LA(1);
				if ( ((LA23_0 >= '\u0000' && LA23_0 <= '!')||(LA23_0 >= '#' && LA23_0 <= '\uFFFF')) ) {
					alt23=1;
				}

				switch (alt23) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '\uFFFF') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt23 >= 1 ) break loop23;
					if (state.backtracking>0) {state.failed=true; return;}
					EarlyExitException eee = new EarlyExitException(23, input);
					throw eee;
				}
				cnt23++;
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DBL_QUOTE_CHAR"

	// $ANTLR start "X"
	public final void mX() throws RecognitionException {
		try {
			// PhoenixSQL.g:1550:5: ( ( 'X' | 'x' ) )
			// PhoenixSQL.g:
			{
			if ( input.LA(1)=='X'||input.LA(1)=='x' ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "X"

	// $ANTLR start "B"
	public final void mB() throws RecognitionException {
		try {
			// PhoenixSQL.g:1555:5: ( ( 'B' | 'b' ) )
			// PhoenixSQL.g:
			{
			if ( input.LA(1)=='B'||input.LA(1)=='b' ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "B"

	// $ANTLR start "CHAR_ESC"
	public final void mCHAR_ESC() throws RecognitionException {
		try {
			// PhoenixSQL.g:1561:5: ( '\\\\' ( 'n' | 'r' | 't' | 'b' | 'f' | '\\\"' | '\\'' | '\\\\' | '_' | '%' |) | '\\'\\'' )
			int alt25=2;
			int LA25_0 = input.LA(1);
			if ( (LA25_0=='\\') ) {
				alt25=1;
			}
			else if ( (LA25_0=='\'') ) {
				alt25=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 25, 0, input);
				throw nvae;
			}

			switch (alt25) {
				case 1 :
					// PhoenixSQL.g:1561:9: '\\\\' ( 'n' | 'r' | 't' | 'b' | 'f' | '\\\"' | '\\'' | '\\\\' | '_' | '%' |)
					{
					match('\\'); if (state.failed) return;
					// PhoenixSQL.g:1562:9: ( 'n' | 'r' | 't' | 'b' | 'f' | '\\\"' | '\\'' | '\\\\' | '_' | '%' |)
					int alt24=11;
					switch ( input.LA(1) ) {
					case 'n':
						{
						alt24=1;
						}
						break;
					case 'r':
						{
						alt24=2;
						}
						break;
					case 't':
						{
						alt24=3;
						}
						break;
					case 'b':
						{
						alt24=4;
						}
						break;
					case 'f':
						{
						alt24=5;
						}
						break;
					case '\"':
						{
						alt24=6;
						}
						break;
					case '\'':
						{
						alt24=7;
						}
						break;
					case '\\':
						{
						alt24=8;
						}
						break;
					case '_':
						{
						alt24=9;
						}
						break;
					case '%':
						{
						alt24=10;
						}
						break;
					default:
						alt24=11;
					}
					switch (alt24) {
						case 1 :
							// PhoenixSQL.g:1562:11: 'n'
							{
							match('n'); if (state.failed) return;
							if ( state.backtracking==0 ) { setText("\n"); }
							}
							break;
						case 2 :
							// PhoenixSQL.g:1563:11: 'r'
							{
							match('r'); if (state.failed) return;
							if ( state.backtracking==0 ) { setText("\r"); }
							}
							break;
						case 3 :
							// PhoenixSQL.g:1564:11: 't'
							{
							match('t'); if (state.failed) return;
							if ( state.backtracking==0 ) { setText("\t"); }
							}
							break;
						case 4 :
							// PhoenixSQL.g:1565:11: 'b'
							{
							match('b'); if (state.failed) return;
							if ( state.backtracking==0 ) { setText("\b"); }
							}
							break;
						case 5 :
							// PhoenixSQL.g:1566:11: 'f'
							{
							match('f'); if (state.failed) return;
							if ( state.backtracking==0 ) { setText("\f"); }
							}
							break;
						case 6 :
							// PhoenixSQL.g:1567:11: '\\\"'
							{
							match('\"'); if (state.failed) return;
							if ( state.backtracking==0 ) { setText("\""); }
							}
							break;
						case 7 :
							// PhoenixSQL.g:1568:11: '\\''
							{
							match('\''); if (state.failed) return;
							if ( state.backtracking==0 ) { setText("\'"); }
							}
							break;
						case 8 :
							// PhoenixSQL.g:1569:11: '\\\\'
							{
							match('\\'); if (state.failed) return;
							if ( state.backtracking==0 ) { setText("\\"); }
							}
							break;
						case 9 :
							// PhoenixSQL.g:1570:11: '_'
							{
							match('_'); if (state.failed) return;
							if ( state.backtracking==0 ) { setText("\\_"); }
							}
							break;
						case 10 :
							// PhoenixSQL.g:1571:11: '%'
							{
							match('%'); if (state.failed) return;
							if ( state.backtracking==0 ) { setText("\\%"); }
							}
							break;
						case 11 :
							// PhoenixSQL.g:1572:17: 
							{
							if ( state.backtracking==0 ) { setText("\\"); }
							}
							break;

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:1574:9: '\\'\\''
					{
					match("''"); if (state.failed) return;

					if ( state.backtracking==0 ) { setText("\'"); }
					}
					break;

			}
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CHAR_ESC"

	// $ANTLR start "WS"
	public final void mWS() throws RecognitionException {
		try {
			int _type = WS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1578:5: ( ( ' ' | '\\t' | '\\u2002' ) )
			// PhoenixSQL.g:1578:9: ( ' ' | '\\t' | '\\u2002' )
			{
			if ( input.LA(1)=='\t'||input.LA(1)==' '||input.LA(1)=='\u2002' ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			if ( state.backtracking==0 ) { _channel=HIDDEN; }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "WS"

	// $ANTLR start "EOL"
	public final void mEOL() throws RecognitionException {
		try {
			int _type = EOL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1582:5: ( ( '\\r' | '\\n' ) )
			// PhoenixSQL.g:1582:8: ( '\\r' | '\\n' )
			{
			if ( input.LA(1)=='\n'||input.LA(1)=='\r' ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			if ( state.backtracking==0 ) { skip(); }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EOL"

	// $ANTLR start "ML_HINT"
	public final void mML_HINT() throws RecognitionException {
		try {
			int _type = ML_HINT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken h=null;
			int t;

			 StringBuilder sb = new StringBuilder(); 
			// PhoenixSQL.g:1589:5: (h= HINT_START ( options {greedy=false; } :t= . )* COMMENT_AND_HINT_END )
			// PhoenixSQL.g:1589:7: h= HINT_START ( options {greedy=false; } :t= . )* COMMENT_AND_HINT_END
			{
			int hStart2704 = getCharIndex();
			int hStartLine2704 = getLine();
			int hStartCharPos2704 = getCharPositionInLine();
			mHINT_START(); if (state.failed) return;
			h = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, hStart2704, getCharIndex()-1);
			h.setLine(hStartLine2704);
			h.setCharPositionInLine(hStartCharPos2704);

			// PhoenixSQL.g:1589:20: ( options {greedy=false; } :t= . )*
			loop26:
			while (true) {
				int alt26=2;
				int LA26_0 = input.LA(1);
				if ( (LA26_0=='*') ) {
					int LA26_1 = input.LA(2);
					if ( (LA26_1=='/') ) {
						alt26=2;
					}
					else if ( ((LA26_1 >= '\u0000' && LA26_1 <= '.')||(LA26_1 >= '0' && LA26_1 <= '\uFFFF')) ) {
						alt26=1;
					}

				}
				else if ( ((LA26_0 >= '\u0000' && LA26_0 <= ')')||(LA26_0 >= '+' && LA26_0 <= '\uFFFF')) ) {
					alt26=1;
				}

				switch (alt26) {
				case 1 :
					// PhoenixSQL.g:1589:48: t= .
					{
					t = input.LA(1);
					matchAny(); if (state.failed) return;
					}
					break;

				default :
					break loop26;
				}
			}

			if ( state.backtracking==0 ) { sb.append(getText()); }
			mCOMMENT_AND_HINT_END(); if (state.failed) return;

			if ( state.backtracking==0 ) { setText(sb.substring(h.getText().length())); }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ML_HINT"

	// $ANTLR start "ML_COMMENT"
	public final void mML_COMMENT() throws RecognitionException {
		try {
			int _type = ML_COMMENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1594:5: ( COMMENT_START (~ PLUS ) ( options {greedy=false; } : . )* COMMENT_AND_HINT_END )
			// PhoenixSQL.g:1594:7: COMMENT_START (~ PLUS ) ( options {greedy=false; } : . )* COMMENT_AND_HINT_END
			{
			mCOMMENT_START(); if (state.failed) return;

			if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '*')||(input.LA(1) >= ',' && input.LA(1) <= '\uFFFF') ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			// PhoenixSQL.g:1594:29: ( options {greedy=false; } : . )*
			loop27:
			while (true) {
				int alt27=2;
				int LA27_0 = input.LA(1);
				if ( (LA27_0=='*') ) {
					int LA27_1 = input.LA(2);
					if ( (LA27_1=='/') ) {
						alt27=2;
					}
					else if ( ((LA27_1 >= '\u0000' && LA27_1 <= '.')||(LA27_1 >= '0' && LA27_1 <= '\uFFFF')) ) {
						alt27=1;
					}

				}
				else if ( ((LA27_0 >= '\u0000' && LA27_0 <= ')')||(LA27_0 >= '+' && LA27_0 <= '\uFFFF')) ) {
					alt27=1;
				}

				switch (alt27) {
				case 1 :
					// PhoenixSQL.g:1594:57: .
					{
					matchAny(); if (state.failed) return;
					}
					break;

				default :
					break loop27;
				}
			}

			mCOMMENT_AND_HINT_END(); if (state.failed) return;

			if ( state.backtracking==0 ) { skip(); }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ML_COMMENT"

	// $ANTLR start "SL_COMMENT"
	public final void mSL_COMMENT() throws RecognitionException {
		try {
			int _type = SL_COMMENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1599:5: ( ( SL_COMMENT1 | SL_COMMENT2 ) ( options {greedy=false; } : . )* EOL )
			// PhoenixSQL.g:1599:7: ( SL_COMMENT1 | SL_COMMENT2 ) ( options {greedy=false; } : . )* EOL
			{
			// PhoenixSQL.g:1599:7: ( SL_COMMENT1 | SL_COMMENT2 )
			int alt28=2;
			int LA28_0 = input.LA(1);
			if ( (LA28_0=='/') ) {
				alt28=1;
			}
			else if ( (LA28_0=='-') ) {
				alt28=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 28, 0, input);
				throw nvae;
			}

			switch (alt28) {
				case 1 :
					// PhoenixSQL.g:1599:8: SL_COMMENT1
					{
					mSL_COMMENT1(); if (state.failed) return;

					}
					break;
				case 2 :
					// PhoenixSQL.g:1599:22: SL_COMMENT2
					{
					mSL_COMMENT2(); if (state.failed) return;

					}
					break;

			}

			// PhoenixSQL.g:1599:35: ( options {greedy=false; } : . )*
			loop29:
			while (true) {
				int alt29=2;
				int LA29_0 = input.LA(1);
				if ( (LA29_0=='\n'||LA29_0=='\r') ) {
					alt29=2;
				}
				else if ( ((LA29_0 >= '\u0000' && LA29_0 <= '\t')||(LA29_0 >= '\u000B' && LA29_0 <= '\f')||(LA29_0 >= '\u000E' && LA29_0 <= '\uFFFF')) ) {
					alt29=1;
				}

				switch (alt29) {
				case 1 :
					// PhoenixSQL.g:1599:63: .
					{
					matchAny(); if (state.failed) return;
					}
					break;

				default :
					break loop29;
				}
			}

			mEOL(); if (state.failed) return;

			if ( state.backtracking==0 ) { skip(); }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SL_COMMENT"

	// $ANTLR start "DOT"
	public final void mDOT() throws RecognitionException {
		try {
			int _type = DOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1604:5: ( '.' )
			// PhoenixSQL.g:1604:7: '.'
			{
			match('.'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOT"

	// $ANTLR start "OTHER"
	public final void mOTHER() throws RecognitionException {
		try {
			int _type = OTHER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixSQL.g:1608:5: ( . )
			// PhoenixSQL.g:1608:7: .
			{
			matchAny(); if (state.failed) return;
			if ( state.backtracking==0 ) { if (true) // to prevent compile error
			              throw new RuntimeException("Unexpected char: '" + getText() + "'"); }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OTHER"

	@Override
	public void mTokens() throws RecognitionException {
		// PhoenixSQL.g:1:8: ( ACTIVE | ADD | ALL | ALTER | AND | ANY | ARRAY | AS | ASC | ASYNC | BETWEEN | BY | CACHE | CASCADE | CASE | CAST | CDC | CHANGE | CLOSE | COLUMN | COLUMNS | COLUMN_QUALIFIER_COUNTER | CONSTANT | CONSTRAINT | CREATE | CURRENT | CURSOR | CYCLE | DECLARE | DEFAULT | DEFAULTVALUE | DELETE | DESC | DISABLE | DISTINCT | DROP | DUPLICATE | ELSE | ENCODED_QUALIFIER | END | EXECUTE | EXISTS | EXPLAIN | FALSE | FETCH | FIRST | FOR | FROM | FULL | FUNCTION | GRANT | GROUP | HAVING | IF | IGNORE | ILIKE | IMMUTABLE | IN | INCLUDE | INCREMENT | INDEX | INNER | INTO | IS | JAR | JARS | JOIN | KEY | LAST | LATEST | LEFT | LIKE | LIMIT | LIST | LOCAL | MAXVALUE | MINVALUE | NEXT | NOT | NOVERIFY | NULL | NULLS | OFF | OFFSET | ON | ONLY | OPEN | OR | ORDER | OUTER | POST | PRE | PRIMARY | REBUILD | REGIONS | REPLACE | RETURNING | RETURNS | REVOKE | RIGHT | ROW | ROWS | ROW_TIMESTAMP | SAMPLING | SCHEMA | SCHEMAS | SELECT | SEQUENCE | SESSION | SET | SHOW | SOME | SPLIT | START | STATISTICS | TABLE | TABLES | TABLESAMPLE | TEMPORARY | THEN | TO | TRACE | TRUE | UNCOVERED | UNION | UNUSABLE | UPDATE | UPDATE_ONLY | UPGRADE | UPSERT | USABLE | USE | USING | VALUE | VALUES | VIEW | WHEN | WHERE | WITH | WITHIN | HINT_START | COMMENT_START | COMMENT_AND_HINT_END | SL_COMMENT1 | SL_COMMENT2 | BIND_NAME | HEX_LITERAL | BIN_LITERAL | NAME | NUMBER | DECIMAL | DOUBLE | Exponent | DOUBLE_QUOTE | EQ | LT | GT | DOUBLE_EQ | NOEQ1 | NOEQ2 | CONCAT | COMMA | LPAREN | RPAREN | SEMICOLON | COLON | QUESTION | LSQUARE | RSQUARE | LCURLY | RCURLY | AT | TILDE | PLUS | MINUS | ASTERISK | DIVIDE | PERCENT | OUTER_JOIN | STRING_LITERAL | WS | EOL | ML_HINT | ML_COMMENT | SL_COMMENT | DOT | OTHER )
		int alt30=187;
		alt30 = dfa30.predict(input);
		switch (alt30) {
			case 1 :
				// PhoenixSQL.g:1:10: ACTIVE
				{
				mACTIVE(); if (state.failed) return;

				}
				break;
			case 2 :
				// PhoenixSQL.g:1:17: ADD
				{
				mADD(); if (state.failed) return;

				}
				break;
			case 3 :
				// PhoenixSQL.g:1:21: ALL
				{
				mALL(); if (state.failed) return;

				}
				break;
			case 4 :
				// PhoenixSQL.g:1:25: ALTER
				{
				mALTER(); if (state.failed) return;

				}
				break;
			case 5 :
				// PhoenixSQL.g:1:31: AND
				{
				mAND(); if (state.failed) return;

				}
				break;
			case 6 :
				// PhoenixSQL.g:1:35: ANY
				{
				mANY(); if (state.failed) return;

				}
				break;
			case 7 :
				// PhoenixSQL.g:1:39: ARRAY
				{
				mARRAY(); if (state.failed) return;

				}
				break;
			case 8 :
				// PhoenixSQL.g:1:45: AS
				{
				mAS(); if (state.failed) return;

				}
				break;
			case 9 :
				// PhoenixSQL.g:1:48: ASC
				{
				mASC(); if (state.failed) return;

				}
				break;
			case 10 :
				// PhoenixSQL.g:1:52: ASYNC
				{
				mASYNC(); if (state.failed) return;

				}
				break;
			case 11 :
				// PhoenixSQL.g:1:58: BETWEEN
				{
				mBETWEEN(); if (state.failed) return;

				}
				break;
			case 12 :
				// PhoenixSQL.g:1:66: BY
				{
				mBY(); if (state.failed) return;

				}
				break;
			case 13 :
				// PhoenixSQL.g:1:69: CACHE
				{
				mCACHE(); if (state.failed) return;

				}
				break;
			case 14 :
				// PhoenixSQL.g:1:75: CASCADE
				{
				mCASCADE(); if (state.failed) return;

				}
				break;
			case 15 :
				// PhoenixSQL.g:1:83: CASE
				{
				mCASE(); if (state.failed) return;

				}
				break;
			case 16 :
				// PhoenixSQL.g:1:88: CAST
				{
				mCAST(); if (state.failed) return;

				}
				break;
			case 17 :
				// PhoenixSQL.g:1:93: CDC
				{
				mCDC(); if (state.failed) return;

				}
				break;
			case 18 :
				// PhoenixSQL.g:1:97: CHANGE
				{
				mCHANGE(); if (state.failed) return;

				}
				break;
			case 19 :
				// PhoenixSQL.g:1:104: CLOSE
				{
				mCLOSE(); if (state.failed) return;

				}
				break;
			case 20 :
				// PhoenixSQL.g:1:110: COLUMN
				{
				mCOLUMN(); if (state.failed) return;

				}
				break;
			case 21 :
				// PhoenixSQL.g:1:117: COLUMNS
				{
				mCOLUMNS(); if (state.failed) return;

				}
				break;
			case 22 :
				// PhoenixSQL.g:1:125: COLUMN_QUALIFIER_COUNTER
				{
				mCOLUMN_QUALIFIER_COUNTER(); if (state.failed) return;

				}
				break;
			case 23 :
				// PhoenixSQL.g:1:150: CONSTANT
				{
				mCONSTANT(); if (state.failed) return;

				}
				break;
			case 24 :
				// PhoenixSQL.g:1:159: CONSTRAINT
				{
				mCONSTRAINT(); if (state.failed) return;

				}
				break;
			case 25 :
				// PhoenixSQL.g:1:170: CREATE
				{
				mCREATE(); if (state.failed) return;

				}
				break;
			case 26 :
				// PhoenixSQL.g:1:177: CURRENT
				{
				mCURRENT(); if (state.failed) return;

				}
				break;
			case 27 :
				// PhoenixSQL.g:1:185: CURSOR
				{
				mCURSOR(); if (state.failed) return;

				}
				break;
			case 28 :
				// PhoenixSQL.g:1:192: CYCLE
				{
				mCYCLE(); if (state.failed) return;

				}
				break;
			case 29 :
				// PhoenixSQL.g:1:198: DECLARE
				{
				mDECLARE(); if (state.failed) return;

				}
				break;
			case 30 :
				// PhoenixSQL.g:1:206: DEFAULT
				{
				mDEFAULT(); if (state.failed) return;

				}
				break;
			case 31 :
				// PhoenixSQL.g:1:214: DEFAULTVALUE
				{
				mDEFAULTVALUE(); if (state.failed) return;

				}
				break;
			case 32 :
				// PhoenixSQL.g:1:227: DELETE
				{
				mDELETE(); if (state.failed) return;

				}
				break;
			case 33 :
				// PhoenixSQL.g:1:234: DESC
				{
				mDESC(); if (state.failed) return;

				}
				break;
			case 34 :
				// PhoenixSQL.g:1:239: DISABLE
				{
				mDISABLE(); if (state.failed) return;

				}
				break;
			case 35 :
				// PhoenixSQL.g:1:247: DISTINCT
				{
				mDISTINCT(); if (state.failed) return;

				}
				break;
			case 36 :
				// PhoenixSQL.g:1:256: DROP
				{
				mDROP(); if (state.failed) return;

				}
				break;
			case 37 :
				// PhoenixSQL.g:1:261: DUPLICATE
				{
				mDUPLICATE(); if (state.failed) return;

				}
				break;
			case 38 :
				// PhoenixSQL.g:1:271: ELSE
				{
				mELSE(); if (state.failed) return;

				}
				break;
			case 39 :
				// PhoenixSQL.g:1:276: ENCODED_QUALIFIER
				{
				mENCODED_QUALIFIER(); if (state.failed) return;

				}
				break;
			case 40 :
				// PhoenixSQL.g:1:294: END
				{
				mEND(); if (state.failed) return;

				}
				break;
			case 41 :
				// PhoenixSQL.g:1:298: EXECUTE
				{
				mEXECUTE(); if (state.failed) return;

				}
				break;
			case 42 :
				// PhoenixSQL.g:1:306: EXISTS
				{
				mEXISTS(); if (state.failed) return;

				}
				break;
			case 43 :
				// PhoenixSQL.g:1:313: EXPLAIN
				{
				mEXPLAIN(); if (state.failed) return;

				}
				break;
			case 44 :
				// PhoenixSQL.g:1:321: FALSE
				{
				mFALSE(); if (state.failed) return;

				}
				break;
			case 45 :
				// PhoenixSQL.g:1:327: FETCH
				{
				mFETCH(); if (state.failed) return;

				}
				break;
			case 46 :
				// PhoenixSQL.g:1:333: FIRST
				{
				mFIRST(); if (state.failed) return;

				}
				break;
			case 47 :
				// PhoenixSQL.g:1:339: FOR
				{
				mFOR(); if (state.failed) return;

				}
				break;
			case 48 :
				// PhoenixSQL.g:1:343: FROM
				{
				mFROM(); if (state.failed) return;

				}
				break;
			case 49 :
				// PhoenixSQL.g:1:348: FULL
				{
				mFULL(); if (state.failed) return;

				}
				break;
			case 50 :
				// PhoenixSQL.g:1:353: FUNCTION
				{
				mFUNCTION(); if (state.failed) return;

				}
				break;
			case 51 :
				// PhoenixSQL.g:1:362: GRANT
				{
				mGRANT(); if (state.failed) return;

				}
				break;
			case 52 :
				// PhoenixSQL.g:1:368: GROUP
				{
				mGROUP(); if (state.failed) return;

				}
				break;
			case 53 :
				// PhoenixSQL.g:1:374: HAVING
				{
				mHAVING(); if (state.failed) return;

				}
				break;
			case 54 :
				// PhoenixSQL.g:1:381: IF
				{
				mIF(); if (state.failed) return;

				}
				break;
			case 55 :
				// PhoenixSQL.g:1:384: IGNORE
				{
				mIGNORE(); if (state.failed) return;

				}
				break;
			case 56 :
				// PhoenixSQL.g:1:391: ILIKE
				{
				mILIKE(); if (state.failed) return;

				}
				break;
			case 57 :
				// PhoenixSQL.g:1:397: IMMUTABLE
				{
				mIMMUTABLE(); if (state.failed) return;

				}
				break;
			case 58 :
				// PhoenixSQL.g:1:407: IN
				{
				mIN(); if (state.failed) return;

				}
				break;
			case 59 :
				// PhoenixSQL.g:1:410: INCLUDE
				{
				mINCLUDE(); if (state.failed) return;

				}
				break;
			case 60 :
				// PhoenixSQL.g:1:418: INCREMENT
				{
				mINCREMENT(); if (state.failed) return;

				}
				break;
			case 61 :
				// PhoenixSQL.g:1:428: INDEX
				{
				mINDEX(); if (state.failed) return;

				}
				break;
			case 62 :
				// PhoenixSQL.g:1:434: INNER
				{
				mINNER(); if (state.failed) return;

				}
				break;
			case 63 :
				// PhoenixSQL.g:1:440: INTO
				{
				mINTO(); if (state.failed) return;

				}
				break;
			case 64 :
				// PhoenixSQL.g:1:445: IS
				{
				mIS(); if (state.failed) return;

				}
				break;
			case 65 :
				// PhoenixSQL.g:1:448: JAR
				{
				mJAR(); if (state.failed) return;

				}
				break;
			case 66 :
				// PhoenixSQL.g:1:452: JARS
				{
				mJARS(); if (state.failed) return;

				}
				break;
			case 67 :
				// PhoenixSQL.g:1:457: JOIN
				{
				mJOIN(); if (state.failed) return;

				}
				break;
			case 68 :
				// PhoenixSQL.g:1:462: KEY
				{
				mKEY(); if (state.failed) return;

				}
				break;
			case 69 :
				// PhoenixSQL.g:1:466: LAST
				{
				mLAST(); if (state.failed) return;

				}
				break;
			case 70 :
				// PhoenixSQL.g:1:471: LATEST
				{
				mLATEST(); if (state.failed) return;

				}
				break;
			case 71 :
				// PhoenixSQL.g:1:478: LEFT
				{
				mLEFT(); if (state.failed) return;

				}
				break;
			case 72 :
				// PhoenixSQL.g:1:483: LIKE
				{
				mLIKE(); if (state.failed) return;

				}
				break;
			case 73 :
				// PhoenixSQL.g:1:488: LIMIT
				{
				mLIMIT(); if (state.failed) return;

				}
				break;
			case 74 :
				// PhoenixSQL.g:1:494: LIST
				{
				mLIST(); if (state.failed) return;

				}
				break;
			case 75 :
				// PhoenixSQL.g:1:499: LOCAL
				{
				mLOCAL(); if (state.failed) return;

				}
				break;
			case 76 :
				// PhoenixSQL.g:1:505: MAXVALUE
				{
				mMAXVALUE(); if (state.failed) return;

				}
				break;
			case 77 :
				// PhoenixSQL.g:1:514: MINVALUE
				{
				mMINVALUE(); if (state.failed) return;

				}
				break;
			case 78 :
				// PhoenixSQL.g:1:523: NEXT
				{
				mNEXT(); if (state.failed) return;

				}
				break;
			case 79 :
				// PhoenixSQL.g:1:528: NOT
				{
				mNOT(); if (state.failed) return;

				}
				break;
			case 80 :
				// PhoenixSQL.g:1:532: NOVERIFY
				{
				mNOVERIFY(); if (state.failed) return;

				}
				break;
			case 81 :
				// PhoenixSQL.g:1:541: NULL
				{
				mNULL(); if (state.failed) return;

				}
				break;
			case 82 :
				// PhoenixSQL.g:1:546: NULLS
				{
				mNULLS(); if (state.failed) return;

				}
				break;
			case 83 :
				// PhoenixSQL.g:1:552: OFF
				{
				mOFF(); if (state.failed) return;

				}
				break;
			case 84 :
				// PhoenixSQL.g:1:556: OFFSET
				{
				mOFFSET(); if (state.failed) return;

				}
				break;
			case 85 :
				// PhoenixSQL.g:1:563: ON
				{
				mON(); if (state.failed) return;

				}
				break;
			case 86 :
				// PhoenixSQL.g:1:566: ONLY
				{
				mONLY(); if (state.failed) return;

				}
				break;
			case 87 :
				// PhoenixSQL.g:1:571: OPEN
				{
				mOPEN(); if (state.failed) return;

				}
				break;
			case 88 :
				// PhoenixSQL.g:1:576: OR
				{
				mOR(); if (state.failed) return;

				}
				break;
			case 89 :
				// PhoenixSQL.g:1:579: ORDER
				{
				mORDER(); if (state.failed) return;

				}
				break;
			case 90 :
				// PhoenixSQL.g:1:585: OUTER
				{
				mOUTER(); if (state.failed) return;

				}
				break;
			case 91 :
				// PhoenixSQL.g:1:591: POST
				{
				mPOST(); if (state.failed) return;

				}
				break;
			case 92 :
				// PhoenixSQL.g:1:596: PRE
				{
				mPRE(); if (state.failed) return;

				}
				break;
			case 93 :
				// PhoenixSQL.g:1:600: PRIMARY
				{
				mPRIMARY(); if (state.failed) return;

				}
				break;
			case 94 :
				// PhoenixSQL.g:1:608: REBUILD
				{
				mREBUILD(); if (state.failed) return;

				}
				break;
			case 95 :
				// PhoenixSQL.g:1:616: REGIONS
				{
				mREGIONS(); if (state.failed) return;

				}
				break;
			case 96 :
				// PhoenixSQL.g:1:624: REPLACE
				{
				mREPLACE(); if (state.failed) return;

				}
				break;
			case 97 :
				// PhoenixSQL.g:1:632: RETURNING
				{
				mRETURNING(); if (state.failed) return;

				}
				break;
			case 98 :
				// PhoenixSQL.g:1:642: RETURNS
				{
				mRETURNS(); if (state.failed) return;

				}
				break;
			case 99 :
				// PhoenixSQL.g:1:650: REVOKE
				{
				mREVOKE(); if (state.failed) return;

				}
				break;
			case 100 :
				// PhoenixSQL.g:1:657: RIGHT
				{
				mRIGHT(); if (state.failed) return;

				}
				break;
			case 101 :
				// PhoenixSQL.g:1:663: ROW
				{
				mROW(); if (state.failed) return;

				}
				break;
			case 102 :
				// PhoenixSQL.g:1:667: ROWS
				{
				mROWS(); if (state.failed) return;

				}
				break;
			case 103 :
				// PhoenixSQL.g:1:672: ROW_TIMESTAMP
				{
				mROW_TIMESTAMP(); if (state.failed) return;

				}
				break;
			case 104 :
				// PhoenixSQL.g:1:686: SAMPLING
				{
				mSAMPLING(); if (state.failed) return;

				}
				break;
			case 105 :
				// PhoenixSQL.g:1:695: SCHEMA
				{
				mSCHEMA(); if (state.failed) return;

				}
				break;
			case 106 :
				// PhoenixSQL.g:1:702: SCHEMAS
				{
				mSCHEMAS(); if (state.failed) return;

				}
				break;
			case 107 :
				// PhoenixSQL.g:1:710: SELECT
				{
				mSELECT(); if (state.failed) return;

				}
				break;
			case 108 :
				// PhoenixSQL.g:1:717: SEQUENCE
				{
				mSEQUENCE(); if (state.failed) return;

				}
				break;
			case 109 :
				// PhoenixSQL.g:1:726: SESSION
				{
				mSESSION(); if (state.failed) return;

				}
				break;
			case 110 :
				// PhoenixSQL.g:1:734: SET
				{
				mSET(); if (state.failed) return;

				}
				break;
			case 111 :
				// PhoenixSQL.g:1:738: SHOW
				{
				mSHOW(); if (state.failed) return;

				}
				break;
			case 112 :
				// PhoenixSQL.g:1:743: SOME
				{
				mSOME(); if (state.failed) return;

				}
				break;
			case 113 :
				// PhoenixSQL.g:1:748: SPLIT
				{
				mSPLIT(); if (state.failed) return;

				}
				break;
			case 114 :
				// PhoenixSQL.g:1:754: START
				{
				mSTART(); if (state.failed) return;

				}
				break;
			case 115 :
				// PhoenixSQL.g:1:760: STATISTICS
				{
				mSTATISTICS(); if (state.failed) return;

				}
				break;
			case 116 :
				// PhoenixSQL.g:1:771: TABLE
				{
				mTABLE(); if (state.failed) return;

				}
				break;
			case 117 :
				// PhoenixSQL.g:1:777: TABLES
				{
				mTABLES(); if (state.failed) return;

				}
				break;
			case 118 :
				// PhoenixSQL.g:1:784: TABLESAMPLE
				{
				mTABLESAMPLE(); if (state.failed) return;

				}
				break;
			case 119 :
				// PhoenixSQL.g:1:796: TEMPORARY
				{
				mTEMPORARY(); if (state.failed) return;

				}
				break;
			case 120 :
				// PhoenixSQL.g:1:806: THEN
				{
				mTHEN(); if (state.failed) return;

				}
				break;
			case 121 :
				// PhoenixSQL.g:1:811: TO
				{
				mTO(); if (state.failed) return;

				}
				break;
			case 122 :
				// PhoenixSQL.g:1:814: TRACE
				{
				mTRACE(); if (state.failed) return;

				}
				break;
			case 123 :
				// PhoenixSQL.g:1:820: TRUE
				{
				mTRUE(); if (state.failed) return;

				}
				break;
			case 124 :
				// PhoenixSQL.g:1:825: UNCOVERED
				{
				mUNCOVERED(); if (state.failed) return;

				}
				break;
			case 125 :
				// PhoenixSQL.g:1:835: UNION
				{
				mUNION(); if (state.failed) return;

				}
				break;
			case 126 :
				// PhoenixSQL.g:1:841: UNUSABLE
				{
				mUNUSABLE(); if (state.failed) return;

				}
				break;
			case 127 :
				// PhoenixSQL.g:1:850: UPDATE
				{
				mUPDATE(); if (state.failed) return;

				}
				break;
			case 128 :
				// PhoenixSQL.g:1:857: UPDATE_ONLY
				{
				mUPDATE_ONLY(); if (state.failed) return;

				}
				break;
			case 129 :
				// PhoenixSQL.g:1:869: UPGRADE
				{
				mUPGRADE(); if (state.failed) return;

				}
				break;
			case 130 :
				// PhoenixSQL.g:1:877: UPSERT
				{
				mUPSERT(); if (state.failed) return;

				}
				break;
			case 131 :
				// PhoenixSQL.g:1:884: USABLE
				{
				mUSABLE(); if (state.failed) return;

				}
				break;
			case 132 :
				// PhoenixSQL.g:1:891: USE
				{
				mUSE(); if (state.failed) return;

				}
				break;
			case 133 :
				// PhoenixSQL.g:1:895: USING
				{
				mUSING(); if (state.failed) return;

				}
				break;
			case 134 :
				// PhoenixSQL.g:1:901: VALUE
				{
				mVALUE(); if (state.failed) return;

				}
				break;
			case 135 :
				// PhoenixSQL.g:1:907: VALUES
				{
				mVALUES(); if (state.failed) return;

				}
				break;
			case 136 :
				// PhoenixSQL.g:1:914: VIEW
				{
				mVIEW(); if (state.failed) return;

				}
				break;
			case 137 :
				// PhoenixSQL.g:1:919: WHEN
				{
				mWHEN(); if (state.failed) return;

				}
				break;
			case 138 :
				// PhoenixSQL.g:1:924: WHERE
				{
				mWHERE(); if (state.failed) return;

				}
				break;
			case 139 :
				// PhoenixSQL.g:1:930: WITH
				{
				mWITH(); if (state.failed) return;

				}
				break;
			case 140 :
				// PhoenixSQL.g:1:935: WITHIN
				{
				mWITHIN(); if (state.failed) return;

				}
				break;
			case 141 :
				// PhoenixSQL.g:1:942: HINT_START
				{
				mHINT_START(); if (state.failed) return;

				}
				break;
			case 142 :
				// PhoenixSQL.g:1:953: COMMENT_START
				{
				mCOMMENT_START(); if (state.failed) return;

				}
				break;
			case 143 :
				// PhoenixSQL.g:1:967: COMMENT_AND_HINT_END
				{
				mCOMMENT_AND_HINT_END(); if (state.failed) return;

				}
				break;
			case 144 :
				// PhoenixSQL.g:1:988: SL_COMMENT1
				{
				mSL_COMMENT1(); if (state.failed) return;

				}
				break;
			case 145 :
				// PhoenixSQL.g:1:1000: SL_COMMENT2
				{
				mSL_COMMENT2(); if (state.failed) return;

				}
				break;
			case 146 :
				// PhoenixSQL.g:1:1012: BIND_NAME
				{
				mBIND_NAME(); if (state.failed) return;

				}
				break;
			case 147 :
				// PhoenixSQL.g:1:1022: HEX_LITERAL
				{
				mHEX_LITERAL(); if (state.failed) return;

				}
				break;
			case 148 :
				// PhoenixSQL.g:1:1034: BIN_LITERAL
				{
				mBIN_LITERAL(); if (state.failed) return;

				}
				break;
			case 149 :
				// PhoenixSQL.g:1:1046: NAME
				{
				mNAME(); if (state.failed) return;

				}
				break;
			case 150 :
				// PhoenixSQL.g:1:1051: NUMBER
				{
				mNUMBER(); if (state.failed) return;

				}
				break;
			case 151 :
				// PhoenixSQL.g:1:1058: DECIMAL
				{
				mDECIMAL(); if (state.failed) return;

				}
				break;
			case 152 :
				// PhoenixSQL.g:1:1066: DOUBLE
				{
				mDOUBLE(); if (state.failed) return;

				}
				break;
			case 153 :
				// PhoenixSQL.g:1:1073: Exponent
				{
				mExponent(); if (state.failed) return;

				}
				break;
			case 154 :
				// PhoenixSQL.g:1:1082: DOUBLE_QUOTE
				{
				mDOUBLE_QUOTE(); if (state.failed) return;

				}
				break;
			case 155 :
				// PhoenixSQL.g:1:1095: EQ
				{
				mEQ(); if (state.failed) return;

				}
				break;
			case 156 :
				// PhoenixSQL.g:1:1098: LT
				{
				mLT(); if (state.failed) return;

				}
				break;
			case 157 :
				// PhoenixSQL.g:1:1101: GT
				{
				mGT(); if (state.failed) return;

				}
				break;
			case 158 :
				// PhoenixSQL.g:1:1104: DOUBLE_EQ
				{
				mDOUBLE_EQ(); if (state.failed) return;

				}
				break;
			case 159 :
				// PhoenixSQL.g:1:1114: NOEQ1
				{
				mNOEQ1(); if (state.failed) return;

				}
				break;
			case 160 :
				// PhoenixSQL.g:1:1120: NOEQ2
				{
				mNOEQ2(); if (state.failed) return;

				}
				break;
			case 161 :
				// PhoenixSQL.g:1:1126: CONCAT
				{
				mCONCAT(); if (state.failed) return;

				}
				break;
			case 162 :
				// PhoenixSQL.g:1:1133: COMMA
				{
				mCOMMA(); if (state.failed) return;

				}
				break;
			case 163 :
				// PhoenixSQL.g:1:1139: LPAREN
				{
				mLPAREN(); if (state.failed) return;

				}
				break;
			case 164 :
				// PhoenixSQL.g:1:1146: RPAREN
				{
				mRPAREN(); if (state.failed) return;

				}
				break;
			case 165 :
				// PhoenixSQL.g:1:1153: SEMICOLON
				{
				mSEMICOLON(); if (state.failed) return;

				}
				break;
			case 166 :
				// PhoenixSQL.g:1:1163: COLON
				{
				mCOLON(); if (state.failed) return;

				}
				break;
			case 167 :
				// PhoenixSQL.g:1:1169: QUESTION
				{
				mQUESTION(); if (state.failed) return;

				}
				break;
			case 168 :
				// PhoenixSQL.g:1:1178: LSQUARE
				{
				mLSQUARE(); if (state.failed) return;

				}
				break;
			case 169 :
				// PhoenixSQL.g:1:1186: RSQUARE
				{
				mRSQUARE(); if (state.failed) return;

				}
				break;
			case 170 :
				// PhoenixSQL.g:1:1194: LCURLY
				{
				mLCURLY(); if (state.failed) return;

				}
				break;
			case 171 :
				// PhoenixSQL.g:1:1201: RCURLY
				{
				mRCURLY(); if (state.failed) return;

				}
				break;
			case 172 :
				// PhoenixSQL.g:1:1208: AT
				{
				mAT(); if (state.failed) return;

				}
				break;
			case 173 :
				// PhoenixSQL.g:1:1211: TILDE
				{
				mTILDE(); if (state.failed) return;

				}
				break;
			case 174 :
				// PhoenixSQL.g:1:1217: PLUS
				{
				mPLUS(); if (state.failed) return;

				}
				break;
			case 175 :
				// PhoenixSQL.g:1:1222: MINUS
				{
				mMINUS(); if (state.failed) return;

				}
				break;
			case 176 :
				// PhoenixSQL.g:1:1228: ASTERISK
				{
				mASTERISK(); if (state.failed) return;

				}
				break;
			case 177 :
				// PhoenixSQL.g:1:1237: DIVIDE
				{
				mDIVIDE(); if (state.failed) return;

				}
				break;
			case 178 :
				// PhoenixSQL.g:1:1244: PERCENT
				{
				mPERCENT(); if (state.failed) return;

				}
				break;
			case 179 :
				// PhoenixSQL.g:1:1252: OUTER_JOIN
				{
				mOUTER_JOIN(); if (state.failed) return;

				}
				break;
			case 180 :
				// PhoenixSQL.g:1:1263: STRING_LITERAL
				{
				mSTRING_LITERAL(); if (state.failed) return;

				}
				break;
			case 181 :
				// PhoenixSQL.g:1:1278: WS
				{
				mWS(); if (state.failed) return;

				}
				break;
			case 182 :
				// PhoenixSQL.g:1:1281: EOL
				{
				mEOL(); if (state.failed) return;

				}
				break;
			case 183 :
				// PhoenixSQL.g:1:1285: ML_HINT
				{
				mML_HINT(); if (state.failed) return;

				}
				break;
			case 184 :
				// PhoenixSQL.g:1:1293: ML_COMMENT
				{
				mML_COMMENT(); if (state.failed) return;

				}
				break;
			case 185 :
				// PhoenixSQL.g:1:1304: SL_COMMENT
				{
				mSL_COMMENT(); if (state.failed) return;

				}
				break;
			case 186 :
				// PhoenixSQL.g:1:1315: DOT
				{
				mDOT(); if (state.failed) return;

				}
				break;
			case 187 :
				// PhoenixSQL.g:1:1319: OTHER
				{
				mOTHER(); if (state.failed) return;

				}
				break;

		}
	}

	// $ANTLR start synpred1_PhoenixSQL
	public final void synpred1_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:1347:5: ( FIELDCHAR )
		// PhoenixSQL.g:
		{
		if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\u2001')||(input.LA(1) >= '\u2003' && input.LA(1) <= '\uFFFE') ) {
			input.consume();
			state.failed=false;
		}
		else {
			if (state.backtracking>0) {state.failed=true; return;}
			MismatchedSetException mse = new MismatchedSetException(null,input);
			recover(mse);
			throw mse;
		}
		}

	}
	// $ANTLR end synpred1_PhoenixSQL

	// $ANTLR start synpred2_PhoenixSQL
	public final void synpred2_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:1348:7: ( '\\'' )
		// PhoenixSQL.g:1348:8: '\\''
		{
		match('\''); if (state.failed) return;
		}

	}
	// $ANTLR end synpred2_PhoenixSQL

	// $ANTLR start synpred3_PhoenixSQL
	public final void synpred3_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:1358:5: ( FIELDCHAR )
		// PhoenixSQL.g:
		{
		if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\u2001')||(input.LA(1) >= '\u2003' && input.LA(1) <= '\uFFFE') ) {
			input.consume();
			state.failed=false;
		}
		else {
			if (state.backtracking>0) {state.failed=true; return;}
			MismatchedSetException mse = new MismatchedSetException(null,input);
			recover(mse);
			throw mse;
		}
		}

	}
	// $ANTLR end synpred3_PhoenixSQL

	// $ANTLR start synpred4_PhoenixSQL
	public final void synpred4_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:1359:7: ( '\\'' )
		// PhoenixSQL.g:1359:8: '\\''
		{
		match('\''); if (state.failed) return;
		}

	}
	// $ANTLR end synpred4_PhoenixSQL

	public final boolean synpred4_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred4_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred1_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred2_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred2_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred3_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred3_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}


	protected DFA19 dfa19 = new DFA19(this);
	protected DFA30 dfa30 = new DFA30(this);
	static final String DFA19_eotS =
		"\3\uffff\1\4\2\uffff";
	static final String DFA19_eofS =
		"\6\uffff";
	static final String DFA19_minS =
		"\1\56\1\uffff\1\56\1\105\2\uffff";
	static final String DFA19_maxS =
		"\1\71\1\uffff\2\145\2\uffff";
	static final String DFA19_acceptS =
		"\1\uffff\1\1\2\uffff\1\3\1\2";
	static final String DFA19_specialS =
		"\6\uffff}>";
	static final String[] DFA19_transitionS = {
			"\1\1\1\uffff\12\2",
			"",
			"\1\3\1\uffff\12\2\13\uffff\1\4\37\uffff\1\4",
			"\1\5\37\uffff\1\5",
			"",
			""
	};

	static final short[] DFA19_eot = DFA.unpackEncodedString(DFA19_eotS);
	static final short[] DFA19_eof = DFA.unpackEncodedString(DFA19_eofS);
	static final char[] DFA19_min = DFA.unpackEncodedStringToUnsignedChars(DFA19_minS);
	static final char[] DFA19_max = DFA.unpackEncodedStringToUnsignedChars(DFA19_maxS);
	static final short[] DFA19_accept = DFA.unpackEncodedString(DFA19_acceptS);
	static final short[] DFA19_special = DFA.unpackEncodedString(DFA19_specialS);
	static final short[][] DFA19_transition;

	static {
		int numStates = DFA19_transitionS.length;
		DFA19_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA19_transition[i] = DFA.unpackEncodedString(DFA19_transitionS[i]);
		}
	}

	protected class DFA19 extends DFA {

		public DFA19(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 19;
			this.eot = DFA19_eot;
			this.eof = DFA19_eof;
			this.min = DFA19_min;
			this.max = DFA19_max;
			this.accept = DFA19_accept;
			this.special = DFA19_special;
			this.transition = DFA19_transition;
		}
		@Override
		public String getDescription() {
			return "1378:1: DOUBLE : ( '.' POSINTEGER Exponent | POSINTEGER '.' Exponent | POSINTEGER ( '.' ( POSINTEGER ( Exponent )? )? | Exponent ) );";
		}
	}

	static final String DFA30_eotS =
		"\1\uffff\1\76\1\101\24\76\1\u008d\1\u008f\1\u0091\1\u0092\1\u0094\1\101"+
		"\1\76\1\u0096\1\u0097\1\u009c\1\uffff\1\u009e\1\u00a0\1\uffff\2\67\1\uffff"+
		"\1\u00a6\13\uffff\1\67\3\uffff\5\76\1\u00be\1\uffff\1\101\1\u00c0\1\uffff"+
		"\1\101\20\76\1\uffff\10\76\1\u00e2\3\76\1\u00ea\1\u00eb\15\76\1\u00fe"+
		"\1\76\1\u0101\20\76\1\u011a\10\76\1\u012b\1\u012d\3\uffff\1\u012f\4\uffff"+
		"\1\u0094\2\uffff\1\u0097\1\u009a\1\uffff\1\u0131\31\uffff\1\76\1\u0133"+
		"\1\u0134\1\76\1\u0136\1\u0137\1\76\1\u0139\1\76\1\uffff\1\101\1\uffff"+
		"\2\76\1\u0140\20\76\1\u0153\6\76\1\u015a\6\76\1\uffff\7\76\2\uffff\1\u016a"+
		"\1\76\1\u016c\12\76\1\u0177\2\76\1\u017b\1\76\1\uffff\2\76\1\uffff\2\76"+
		"\1\u0181\7\76\1\u018b\5\76\1\u0191\7\76\1\uffff\11\76\1\u01a3\5\76\1\u01aa"+
		"\5\uffff\1\u0131\1\uffff\1\76\2\uffff\1\76\2\uffff\1\76\1\uffff\1\76\1"+
		"\101\2\76\1\u01b3\1\u01b4\1\uffff\13\76\1\u01c0\2\76\1\u01c3\1\76\1\u01c5"+
		"\1\76\1\uffff\6\76\1\uffff\1\u01cd\1\u01ce\13\76\1\u01da\1\u01db\1\uffff"+
		"\1\u01dc\1\uffff\1\u01dd\1\76\1\u01df\1\u01e0\1\76\1\u01e2\3\76\1\u01e6"+
		"\1\uffff\1\76\1\u01e9\1\76\1\uffff\1\u01eb\1\u01ec\2\76\1\u01ef\1\uffff"+
		"\7\76\1\u01f7\1\76\1\uffff\5\76\1\uffff\1\u01fe\1\u01ff\5\76\1\u0205\1"+
		"\76\1\u0207\7\76\1\uffff\2\76\1\u0211\1\u0212\1\76\1\u0215\2\uffff\1\76"+
		"\1\u0217\1\u0218\1\u0219\1\101\1\u021b\1\76\2\uffff\1\76\1\u021e\5\76"+
		"\1\u0225\3\76\1\uffff\2\76\1\uffff\1\76\1\uffff\4\76\1\u0230\1\u0231\1"+
		"\u0232\2\uffff\1\76\1\u0234\1\u0235\2\76\1\u0238\3\76\1\u023c\1\u023d"+
		"\4\uffff\1\76\2\uffff\1\u023f\1\uffff\1\u0240\2\76\1\uffff\1\76\1\u0244"+
		"\1\uffff\1\76\2\uffff\1\u0246\1\u0247\1\uffff\6\76\1\u024e\1\uffff\6\76"+
		"\2\uffff\1\u0255\1\u0256\1\76\1\u0259\1\76\1\uffff\1\u025b\1\uffff\1\76"+
		"\1\u025d\5\76\1\u0263\1\u0265\2\uffff\1\u0266\1\76\1\uffff\1\u0268\3\uffff"+
		"\1\101\1\uffff\1\76\1\u026b\1\uffff\1\u026e\2\76\1\u0271\1\76\1\u0273"+
		"\1\uffff\2\76\1\u0276\5\76\1\u027c\1\76\3\uffff\1\76\2\uffff\1\u027f\1"+
		"\u0280\1\uffff\3\76\2\uffff\1\u0284\2\uffff\3\76\1\uffff\1\u0288\2\uffff"+
		"\5\76\1\u028f\1\uffff\2\76\1\u0293\1\u0294\2\76\2\uffff\1\76\1\u0299\1"+
		"\uffff\1\76\1\uffff\1\76\1\uffff\1\76\1\u029e\1\76\1\u02a0\1\u02a1\1\uffff"+
		"\1\u02a2\2\uffff\1\u02a3\1\uffff\1\u02a4\1\u02a5\1\uffff\1\u02a6\1\76"+
		"\1\uffff\2\76\1\uffff\1\u02aa\1\uffff\1\u02ab\1\u02ad\1\uffff\1\u02ae"+
		"\3\76\1\u02b2\1\uffff\1\u02b3\1\76\2\uffff\1\76\1\u02b6\1\76\1\uffff\3"+
		"\76\1\uffff\1\u02bb\1\u02bc\1\u02bd\1\u02be\1\76\1\u02c0\1\uffff\2\76"+
		"\1\u02c3\2\uffff\1\76\1\u02c5\2\76\1\uffff\4\76\1\uffff\1\u02cc\7\uffff"+
		"\1\76\1\u02ce\1\76\2\uffff\1\76\2\uffff\1\u02d1\2\76\2\uffff\1\u02d4\1"+
		"\76\1\uffff\1\76\1\u02d7\1\u02d8\1\u02d9\4\uffff\1\76\1\uffff\1\76\1\u02dc"+
		"\1\uffff\1\u02dd\1\uffff\4\76\1\u02e2\1\76\1\uffff\1\76\1\uffff\2\76\1"+
		"\uffff\1\u02e7\1\76\1\uffff\1\u02e9\1\u02ea\3\uffff\1\u02eb\1\76\2\uffff"+
		"\2\76\1\u02ef\1\u02f0\1\uffff\2\76\1\u02f3\1\76\1\uffff\1\76\3\uffff\1"+
		"\76\1\u02f7\1\76\2\uffff\2\76\1\uffff\3\76\1\uffff\1\u02fe\1\u02ff\1\76"+
		"\1\u0301\2\76\2\uffff\1\76\1\uffff\1\76\1\u0306\2\76\1\uffff\5\76\1\u030e"+
		"\1\76\1\uffff\5\76\1\u0315\1\uffff";
	static final String DFA30_eofS =
		"\u0316\uffff";
	static final String DFA30_minS =
		"\1\0\1\143\1\60\1\141\1\145\1\53\1\141\1\162\1\141\1\146\1\141\1\145\2"+
		"\141\1\145\1\146\1\157\1\145\2\141\1\156\1\141\1\150\1\52\1\57\1\55\3"+
		"\60\1\53\1\0\1\56\1\60\1\uffff\1\75\1\76\1\uffff\1\75\1\174\1\uffff\1"+
		"\53\13\uffff\1\0\3\uffff\1\164\1\144\1\154\1\144\1\162\1\60\1\uffff\2"+
		"\60\1\uffff\1\60\2\143\1\141\1\157\1\154\1\145\1\162\2\143\1\163\1\157"+
		"\1\160\1\163\1\143\1\145\1\60\1\uffff\1\154\1\164\2\162\1\157\1\154\1"+
		"\141\1\166\1\60\1\156\1\151\1\155\2\60\1\162\1\151\1\171\1\163\1\146\1"+
		"\153\1\143\1\170\1\156\1\170\1\164\1\154\1\146\1\60\1\145\1\60\1\164\1"+
		"\163\1\145\1\142\1\147\1\167\1\155\1\150\1\154\1\157\1\155\1\154\1\141"+
		"\1\142\1\155\1\145\1\60\1\141\1\143\1\144\1\141\1\154\2\145\1\164\2\0"+
		"\3\uffff\1\0\4\uffff\1\60\2\uffff\1\56\1\60\1\uffff\1\60\31\uffff\1\151"+
		"\2\60\1\145\2\60\1\141\1\60\1\156\1\uffff\1\60\1\uffff\1\150\1\143\1\60"+
		"\1\156\1\163\1\165\1\163\1\141\1\162\2\154\1\141\1\145\1\143\1\141\1\160"+
		"\1\154\1\145\1\157\1\60\1\143\1\163\1\154\1\163\1\143\1\163\1\60\1\155"+
		"\1\154\1\143\1\156\1\165\1\151\1\uffff\1\157\1\153\1\165\1\154\2\145\1"+
		"\157\2\uffff\1\60\1\156\1\60\1\164\1\145\1\164\1\145\1\151\1\164\1\141"+
		"\2\166\1\164\1\60\1\145\1\154\1\60\1\171\1\uffff\1\156\1\145\1\uffff\1"+
		"\145\1\164\1\60\1\155\1\165\1\151\1\154\1\165\1\157\1\150\1\60\1\160\2"+
		"\145\1\165\1\163\1\60\1\167\1\145\1\151\1\162\1\154\1\160\1\156\1\uffff"+
		"\1\143\1\145\2\157\1\163\1\141\1\162\1\145\1\142\1\60\1\156\1\165\1\167"+
		"\1\156\1\150\1\0\5\uffff\1\60\1\uffff\1\166\2\uffff\1\162\2\uffff\1\171"+
		"\1\uffff\1\143\1\60\1\145\1\141\2\60\1\uffff\1\147\1\145\1\155\2\164\1"+
		"\145\1\157\1\145\1\141\1\165\1\164\1\60\1\142\1\151\1\60\1\151\1\60\1"+
		"\144\1\uffff\1\165\1\164\1\141\1\145\1\150\1\164\1\uffff\2\60\2\164\1"+
		"\160\1\156\1\162\1\145\1\164\1\165\1\145\1\170\1\162\2\60\1\uffff\1\60"+
		"\1\uffff\1\60\1\163\2\60\1\164\1\60\1\154\2\141\1\60\1\uffff\1\162\1\60"+
		"\1\145\1\uffff\2\60\2\162\1\60\1\uffff\1\141\1\151\1\157\1\141\1\162\1"+
		"\153\1\164\1\60\1\164\1\uffff\1\154\1\155\1\143\1\145\1\151\1\uffff\2"+
		"\60\2\164\1\151\1\145\1\157\1\60\1\145\1\60\1\166\1\156\1\141\1\164\1"+
		"\141\1\162\1\154\1\uffff\1\147\1\145\2\60\1\145\1\60\2\uffff\1\145\5\60"+
		"\1\144\2\uffff\1\145\1\60\1\156\1\141\1\145\1\156\1\162\1\60\1\162\1\154"+
		"\1\145\1\uffff\1\154\1\156\1\uffff\1\143\1\uffff\1\145\1\164\1\163\1\151"+
		"\3\60\2\uffff\1\151\2\60\1\147\1\145\1\60\1\141\1\144\1\155\2\60\4\uffff"+
		"\1\164\2\uffff\1\60\1\uffff\1\60\2\154\1\uffff\1\151\1\60\1\uffff\1\164"+
		"\2\uffff\2\60\1\uffff\1\162\1\154\1\156\1\143\1\156\1\145\1\60\1\uffff"+
		"\2\151\1\141\1\164\1\156\1\157\2\uffff\2\60\1\163\1\60\1\162\1\uffff\1"+
		"\60\1\uffff\1\145\1\60\1\142\1\145\1\144\1\164\1\145\2\60\2\uffff\1\60"+
		"\1\156\1\uffff\1\60\3\uffff\1\60\1\uffff\1\145\1\60\1\uffff\1\60\1\156"+
		"\1\141\1\60\1\164\1\60\1\uffff\1\145\1\164\1\60\1\145\1\143\1\141\1\144"+
		"\1\145\1\60\1\156\3\uffff\1\157\2\uffff\2\60\1\uffff\1\142\2\145\2\uffff"+
		"\1\60\2\uffff\2\165\1\146\1\uffff\1\60\2\uffff\1\171\1\144\1\163\1\145"+
		"\1\151\1\60\1\uffff\1\155\1\156\2\60\1\143\1\156\2\uffff\1\164\1\60\1"+
		"\uffff\1\141\1\uffff\1\162\1\uffff\1\154\1\60\1\145\2\60\1\uffff\1\60"+
		"\2\uffff\1\60\1\uffff\2\60\1\uffff\1\60\1\161\1\uffff\1\164\1\151\1\uffff"+
		"\1\60\1\uffff\2\60\1\uffff\1\60\2\164\1\137\1\60\1\uffff\1\60\1\156\2"+
		"\uffff\1\154\1\60\1\156\1\uffff\2\145\1\171\1\uffff\4\60\1\156\1\60\1"+
		"\uffff\1\145\1\147\1\60\2\uffff\1\145\1\60\1\151\1\155\1\uffff\1\162\2"+
		"\145\1\157\1\uffff\1\60\7\uffff\1\165\1\60\1\156\2\uffff\1\141\2\uffff"+
		"\1\60\1\145\1\161\2\uffff\1\60\1\145\1\uffff\1\164\3\60\4\uffff\1\147"+
		"\1\uffff\1\163\1\60\1\uffff\1\60\1\uffff\1\143\1\160\1\171\1\144\1\60"+
		"\1\156\1\uffff\1\141\1\uffff\1\164\1\154\1\uffff\1\60\1\165\1\uffff\2"+
		"\60\3\uffff\1\60\1\164\2\uffff\1\163\1\154\2\60\1\uffff\2\154\1\60\1\165"+
		"\1\uffff\1\141\3\uffff\1\141\1\60\1\145\2\uffff\1\171\1\151\1\uffff\1"+
		"\145\1\154\1\155\1\uffff\2\60\1\146\1\60\1\151\1\160\2\uffff\1\151\1\uffff"+
		"\1\146\1\60\1\145\1\151\1\uffff\1\162\1\145\1\137\1\162\1\143\1\60\1\157"+
		"\1\uffff\1\165\1\156\1\164\1\145\1\162\1\60\1\uffff";
	static final String DFA30_maxS =
		"\1\uffff\1\163\1\ufffe\1\171\1\165\1\170\1\165\1\162\1\141\1\163\1\157"+
		"\1\145\1\157\1\151\2\165\1\162\1\157\1\164\1\162\1\163\2\151\2\57\1\55"+
		"\1\71\2\ufffe\1\71\1\uffff\1\145\1\71\1\uffff\1\75\1\76\1\uffff\1\75\1"+
		"\174\1\uffff\1\53\13\uffff\1\uffff\3\uffff\1\164\1\144\1\164\1\171\1\162"+
		"\1\ufffe\1\uffff\2\ufffe\1\uffff\1\ufffe\1\163\1\143\1\141\1\157\1\156"+
		"\1\145\1\162\1\143\2\163\1\157\1\160\1\163\1\144\1\160\1\71\1\uffff\1"+
		"\154\1\164\2\162\1\157\1\156\1\157\1\166\1\ufffe\1\156\1\151\1\155\2\ufffe"+
		"\1\162\1\151\1\171\1\164\1\146\1\163\1\143\1\170\1\156\1\170\1\166\1\154"+
		"\1\146\1\ufffe\1\145\1\ufffe\1\164\1\163\1\151\1\166\1\147\1\167\1\155"+
		"\1\150\1\164\1\157\1\155\1\154\1\141\1\142\1\155\1\145\1\ufffe\2\165\1"+
		"\163\1\151\1\154\2\145\1\164\2\uffff\3\uffff\1\uffff\4\uffff\1\ufffe\2"+
		"\uffff\1\145\1\71\1\uffff\1\145\31\uffff\1\151\2\ufffe\1\145\2\ufffe\1"+
		"\141\1\ufffe\1\156\1\uffff\1\ufffe\1\uffff\1\150\1\164\1\ufffe\1\156\1"+
		"\163\1\165\1\163\1\141\1\163\2\154\1\141\1\145\1\143\1\164\1\160\1\154"+
		"\1\145\1\157\1\ufffe\1\143\1\163\1\154\1\163\1\143\1\163\1\ufffe\1\155"+
		"\1\154\1\143\1\156\1\165\1\151\1\uffff\1\157\1\153\1\165\1\162\2\145\1"+
		"\157\2\uffff\1\ufffe\1\156\1\ufffe\1\164\1\145\1\164\1\145\1\151\1\164"+
		"\1\141\2\166\1\164\1\ufffe\1\145\1\154\1\ufffe\1\171\1\uffff\1\156\1\145"+
		"\1\uffff\1\145\1\164\1\ufffe\1\155\1\165\1\151\1\154\1\165\1\157\1\150"+
		"\1\ufffe\1\160\2\145\1\165\1\163\1\ufffe\1\167\1\145\1\151\1\164\1\154"+
		"\1\160\1\156\1\uffff\1\143\1\145\2\157\1\163\1\141\1\162\1\145\1\142\1"+
		"\ufffe\1\156\1\165\1\167\1\162\1\150\1\uffff\5\uffff\1\145\1\uffff\1\166"+
		"\2\uffff\1\162\2\uffff\1\171\1\uffff\1\143\1\ufffe\1\145\1\141\2\ufffe"+
		"\1\uffff\1\147\1\145\1\155\2\164\1\145\1\157\1\145\1\141\1\165\1\164\1"+
		"\ufffe\1\142\1\151\1\ufffe\1\151\1\ufffe\1\144\1\uffff\1\165\1\164\1\141"+
		"\1\145\1\150\1\164\1\uffff\2\ufffe\2\164\1\160\1\156\1\162\1\145\1\164"+
		"\1\165\1\145\1\170\1\162\2\ufffe\1\uffff\1\ufffe\1\uffff\1\ufffe\1\163"+
		"\2\ufffe\1\164\1\ufffe\1\154\2\141\1\ufffe\1\uffff\1\162\1\ufffe\1\145"+
		"\1\uffff\2\ufffe\2\162\1\ufffe\1\uffff\1\141\1\151\1\157\1\141\1\162\1"+
		"\153\1\164\1\ufffe\1\164\1\uffff\1\154\1\155\1\143\1\145\1\151\1\uffff"+
		"\2\ufffe\2\164\1\151\1\145\1\157\1\ufffe\1\145\1\ufffe\1\166\1\156\1\141"+
		"\1\164\1\141\1\162\1\154\1\uffff\1\147\1\145\2\ufffe\1\145\1\ufffe\2\uffff"+
		"\1\145\5\ufffe\1\144\2\uffff\1\145\1\ufffe\1\156\1\162\1\145\1\156\1\162"+
		"\1\ufffe\1\162\1\154\1\145\1\uffff\1\154\1\156\1\uffff\1\143\1\uffff\1"+
		"\145\1\164\1\163\1\151\3\ufffe\2\uffff\1\151\2\ufffe\1\147\1\145\1\ufffe"+
		"\1\141\1\144\1\155\2\ufffe\4\uffff\1\164\2\uffff\1\ufffe\1\uffff\1\ufffe"+
		"\2\154\1\uffff\1\151\1\ufffe\1\uffff\1\164\2\uffff\2\ufffe\1\uffff\1\162"+
		"\1\154\1\156\1\143\1\156\1\145\1\ufffe\1\uffff\2\151\1\141\1\164\1\156"+
		"\1\157\2\uffff\2\ufffe\1\163\1\ufffe\1\162\1\uffff\1\ufffe\1\uffff\1\145"+
		"\1\ufffe\1\142\1\145\1\144\1\164\1\145\2\ufffe\2\uffff\1\ufffe\1\156\1"+
		"\uffff\1\ufffe\3\uffff\1\ufffe\1\uffff\1\145\1\ufffe\1\uffff\1\ufffe\1"+
		"\156\1\141\1\ufffe\1\164\1\ufffe\1\uffff\1\145\1\164\1\ufffe\1\145\1\143"+
		"\1\141\1\144\1\145\1\ufffe\1\156\3\uffff\1\157\2\uffff\2\ufffe\1\uffff"+
		"\1\142\2\145\2\uffff\1\ufffe\2\uffff\2\165\1\146\1\uffff\1\ufffe\2\uffff"+
		"\1\171\1\144\1\163\1\145\1\163\1\ufffe\1\uffff\1\155\1\156\2\ufffe\1\143"+
		"\1\156\2\uffff\1\164\1\ufffe\1\uffff\1\141\1\uffff\1\162\1\uffff\1\154"+
		"\1\ufffe\1\145\2\ufffe\1\uffff\1\ufffe\2\uffff\1\ufffe\1\uffff\2\ufffe"+
		"\1\uffff\1\ufffe\1\161\1\uffff\1\164\1\151\1\uffff\1\ufffe\1\uffff\2\ufffe"+
		"\1\uffff\1\ufffe\2\164\1\137\1\ufffe\1\uffff\1\ufffe\1\156\2\uffff\1\154"+
		"\1\ufffe\1\156\1\uffff\2\145\1\171\1\uffff\4\ufffe\1\156\1\ufffe\1\uffff"+
		"\1\145\1\147\1\ufffe\2\uffff\1\145\1\ufffe\1\151\1\155\1\uffff\1\162\2"+
		"\145\1\157\1\uffff\1\ufffe\7\uffff\1\165\1\ufffe\1\156\2\uffff\1\141\2"+
		"\uffff\1\ufffe\1\145\1\161\2\uffff\1\ufffe\1\145\1\uffff\1\164\3\ufffe"+
		"\4\uffff\1\147\1\uffff\1\163\1\ufffe\1\uffff\1\ufffe\1\uffff\1\143\1\160"+
		"\1\171\1\144\1\ufffe\1\156\1\uffff\1\141\1\uffff\1\164\1\154\1\uffff\1"+
		"\ufffe\1\165\1\uffff\2\ufffe\3\uffff\1\ufffe\1\164\2\uffff\1\163\1\154"+
		"\2\ufffe\1\uffff\2\154\1\ufffe\1\165\1\uffff\1\141\3\uffff\1\141\1\ufffe"+
		"\1\145\2\uffff\1\171\1\151\1\uffff\1\145\1\154\1\155\1\uffff\2\ufffe\1"+
		"\146\1\ufffe\1\151\1\160\2\uffff\1\151\1\uffff\1\146\1\ufffe\1\145\1\151"+
		"\1\uffff\1\162\1\145\1\137\1\162\1\143\1\ufffe\1\157\1\uffff\1\165\1\156"+
		"\1\164\1\145\1\162\1\ufffe\1\uffff";
	static final String DFA30_acceptS =
		"\41\uffff\1\u0095\2\uffff\1\u009d\2\uffff\1\u00a2\1\uffff\1\u00a4\1\u00a5"+
		"\1\u00a7\1\u00a8\1\u00a9\1\u00aa\1\u00ab\1\u00ac\1\u00ad\1\u00ae\1\u00b2"+
		"\1\uffff\1\u00b5\1\u00b6\1\u00bb\6\uffff\1\u0095\2\uffff\1\u0094\21\uffff"+
		"\1\u0099\71\uffff\1\u00b1\1\u008f\1\u00b0\1\uffff\1\u00af\1\u00a6\1\u0092"+
		"\1\u0093\1\uffff\1\u009a\1\u0096\2\uffff\1\u0098\1\uffff\1\u00ba\1\u009e"+
		"\1\u009b\1\u00a0\1\u009c\1\u009d\1\u009f\1\u00a1\1\u00a2\1\u00b3\1\u00a3"+
		"\1\u00a4\1\u00a5\1\u00a7\1\u00a8\1\u00a9\1\u00aa\1\u00ab\1\u00ac\1\u00ad"+
		"\1\u00ae\1\u00b2\1\u00b4\1\u00b5\1\u00b6\11\uffff\1\10\1\uffff\1\14\41"+
		"\uffff\1\66\7\uffff\1\72\1\100\22\uffff\1\125\2\uffff\1\130\30\uffff\1"+
		"\171\20\uffff\1\u008e\1\u00b8\1\u0090\1\u00b9\1\u0091\1\uffff\1\u0097"+
		"\1\uffff\1\2\1\3\1\uffff\1\5\1\6\1\uffff\1\11\6\uffff\1\21\22\uffff\1"+
		"\50\6\uffff\1\57\17\uffff\1\101\1\uffff\1\104\12\uffff\1\117\3\uffff\1"+
		"\123\5\uffff\1\134\11\uffff\1\145\5\uffff\1\156\21\uffff\1\u0084\6\uffff"+
		"\1\u008d\1\u00b7\7\uffff\1\17\1\20\13\uffff\1\41\2\uffff\1\44\1\uffff"+
		"\1\46\7\uffff\1\60\1\61\13\uffff\1\77\1\102\1\103\1\105\1\uffff\1\107"+
		"\1\110\1\uffff\1\112\3\uffff\1\116\2\uffff\1\121\1\uffff\1\126\1\127\2"+
		"\uffff\1\133\7\uffff\1\146\6\uffff\1\157\1\160\5\uffff\1\170\1\uffff\1"+
		"\173\11\uffff\1\u0088\1\u0089\2\uffff\1\u008b\1\uffff\1\4\1\7\1\12\1\uffff"+
		"\1\15\2\uffff\1\23\6\uffff\1\34\12\uffff\1\54\1\55\1\56\1\uffff\1\63\1"+
		"\64\2\uffff\1\70\3\uffff\1\75\1\76\1\uffff\1\111\1\113\3\uffff\1\122\1"+
		"\uffff\1\131\1\132\6\uffff\1\144\6\uffff\1\161\1\162\2\uffff\1\164\1\uffff"+
		"\1\172\1\uffff\1\175\5\uffff\1\u0085\1\uffff\1\u0086\1\u008a\1\uffff\1"+
		"\1\2\uffff\1\22\2\uffff\1\24\2\uffff\1\31\1\uffff\1\33\2\uffff\1\40\5"+
		"\uffff\1\52\2\uffff\1\65\1\67\3\uffff\1\106\3\uffff\1\124\6\uffff\1\143"+
		"\3\uffff\1\151\1\153\4\uffff\1\165\4\uffff\1\177\1\uffff\1\u0082\1\u0083"+
		"\1\u0087\1\u008c\1\13\1\16\1\25\3\uffff\1\32\1\35\1\uffff\1\36\1\42\3"+
		"\uffff\1\51\1\53\2\uffff\1\73\4\uffff\1\135\1\136\1\137\1\140\1\uffff"+
		"\1\142\2\uffff\1\152\1\uffff\1\155\6\uffff\1\u0081\1\uffff\1\27\2\uffff"+
		"\1\43\2\uffff\1\62\2\uffff\1\114\1\115\1\120\2\uffff\1\150\1\154\4\uffff"+
		"\1\176\4\uffff\1\45\1\uffff\1\71\1\74\1\141\3\uffff\1\167\1\174\2\uffff"+
		"\1\30\3\uffff\1\163\6\uffff\1\166\1\u0080\1\uffff\1\37\4\uffff\1\147\7"+
		"\uffff\1\47\6\uffff\1\26";
	static final String DFA30_specialS =
		"\1\5\35\uffff\1\0\25\uffff\1\4\126\uffff\1\1\1\2\3\uffff\1\3\u0099\uffff"+
		"\1\6\u01eb\uffff}>";
	static final String[] DFA30_transitionS = {
			"\11\67\1\65\1\66\2\67\1\66\22\67\1\65\1\45\1\36\2\67\1\63\1\67\1\64\1"+
			"\50\1\51\1\30\1\62\1\47\1\31\1\40\1\27\12\37\1\32\1\52\1\43\1\42\1\44"+
			"\1\53\1\60\1\41\1\34\2\41\1\35\22\41\1\33\2\41\1\54\1\67\1\55\3\67\1"+
			"\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17\1"+
			"\20\1\41\1\21\1\22\1\23\1\24\1\25\1\26\1\33\2\41\1\56\1\46\1\57\1\61"+
			"\u1f83\67\1\65\udffd\67",
			"\1\70\1\71\7\uffff\1\72\1\uffff\1\73\3\uffff\1\74\1\75",
			"\12\102\7\uffff\32\102\4\uffff\1\102\1\uffff\4\102\1\77\23\102\1\100"+
			"\1\102\5\uffff\u1f82\102\1\uffff\udffc\102",
			"\1\103\2\uffff\1\104\3\uffff\1\105\3\uffff\1\106\2\uffff\1\107\2\uffff"+
			"\1\110\2\uffff\1\111\3\uffff\1\112",
			"\1\113\3\uffff\1\114\10\uffff\1\115\2\uffff\1\116",
			"\1\123\1\uffff\1\123\2\uffff\12\122\62\uffff\1\117\1\uffff\1\120\11"+
			"\uffff\1\121",
			"\1\124\3\uffff\1\125\3\uffff\1\126\5\uffff\1\127\2\uffff\1\130\2\uffff"+
			"\1\131",
			"\1\132",
			"\1\133",
			"\1\134\1\135\4\uffff\1\136\1\137\1\140\4\uffff\1\141",
			"\1\142\15\uffff\1\143",
			"\1\144",
			"\1\145\3\uffff\1\146\3\uffff\1\147\5\uffff\1\150",
			"\1\151\7\uffff\1\152",
			"\1\153\11\uffff\1\154\5\uffff\1\155",
			"\1\156\7\uffff\1\157\1\uffff\1\160\1\uffff\1\161\2\uffff\1\162",
			"\1\163\2\uffff\1\164",
			"\1\165\3\uffff\1\166\5\uffff\1\167",
			"\1\170\1\uffff\1\171\1\uffff\1\172\2\uffff\1\173\6\uffff\1\174\1\175"+
			"\3\uffff\1\176",
			"\1\177\3\uffff\1\u0080\2\uffff\1\u0081\6\uffff\1\u0082\2\uffff\1\u0083",
			"\1\u0084\1\uffff\1\u0085\2\uffff\1\u0086",
			"\1\u0087\7\uffff\1\u0088",
			"\1\u0089\1\u008a",
			"\1\u008b\4\uffff\1\u008c",
			"\1\u008e",
			"\1\u0090",
			"\12\u0093",
			"\12\u0095\7\uffff\32\u0095\4\uffff\1\u0095\1\uffff\32\u0095\5\uffff"+
			"\u1f82\u0095\1\uffff\udffc\u0095",
			"\12\102\7\uffff\32\102\4\uffff\1\102\1\uffff\32\102\5\uffff\u1f82\102"+
			"\1\uffff\udffc\102",
			"\1\123\1\uffff\1\123\2\uffff\12\122",
			"\0\76",
			"\1\u0099\1\uffff\12\u0098\13\uffff\1\u009a\37\uffff\1\u009a",
			"\12\u009b",
			"",
			"\1\u009d",
			"\1\u009f",
			"",
			"\1\u00a2",
			"\1\u00a3",
			"",
			"\1\u00a5",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\0\u00b2",
			"",
			"",
			"",
			"\1\u00b5",
			"\1\u00b6",
			"\1\u00b7\7\uffff\1\u00b8",
			"\1\u00b9\24\uffff\1\u00ba",
			"\1\u00bb",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\2\76\1\u00bc\25\76\1\u00bd"+
			"\1\76\5\uffff\u1f82\76\1\uffff\udffc\76",
			"",
			"\12\102\7\uffff\32\102\4\uffff\1\102\1\uffff\23\102\1\u00bf\6\102\5"+
			"\uffff\u1f82\102\1\uffff\udffc\102",
			"\12\102\7\uffff\32\102\4\uffff\1\102\1\uffff\32\102\5\uffff\u1f82\102"+
			"\1\uffff\udffc\102",
			"",
			"\12\102\7\uffff\32\102\4\uffff\1\102\1\uffff\32\102\5\uffff\u1f82\102"+
			"\1\uffff\udffc\102",
			"\1\u00c1\17\uffff\1\u00c2",
			"\1\u00c3",
			"\1\u00c4",
			"\1\u00c5",
			"\1\u00c6\1\uffff\1\u00c7",
			"\1\u00c8",
			"\1\u00c9",
			"\1\u00ca",
			"\1\u00cb\2\uffff\1\u00cc\5\uffff\1\u00cd\6\uffff\1\u00ce",
			"\1\u00cf",
			"\1\u00d0",
			"\1\u00d1",
			"\1\u00d2",
			"\1\u00d3\1\u00d4",
			"\1\u00d5\3\uffff\1\u00d6\6\uffff\1\u00d7",
			"\12\122",
			"",
			"\1\u00d8",
			"\1\u00d9",
			"\1\u00da",
			"\1\u00db",
			"\1\u00dc",
			"\1\u00dd\1\uffff\1\u00de",
			"\1\u00df\15\uffff\1\u00e0",
			"\1\u00e1",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u00e3",
			"\1\u00e4",
			"\1\u00e5",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\2\76\1\u00e6\1\u00e7\11\76"+
			"\1\u00e8\5\76\1\u00e9\6\76\5\uffff\u1f82\76\1\uffff\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u00ec",
			"\1\u00ed",
			"\1\u00ee",
			"\1\u00ef\1\u00f0",
			"\1\u00f1",
			"\1\u00f2\1\uffff\1\u00f3\5\uffff\1\u00f4",
			"\1\u00f5",
			"\1\u00f6",
			"\1\u00f7",
			"\1\u00f8",
			"\1\u00f9\1\uffff\1\u00fa",
			"\1\u00fb",
			"\1\u00fc",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\13\76\1\u00fd\16\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"\1\u00ff",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\3\76\1\u0100\26\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"\1\u0102",
			"\1\u0103",
			"\1\u0104\3\uffff\1\u0105",
			"\1\u0106\4\uffff\1\u0107\10\uffff\1\u0108\3\uffff\1\u0109\1\uffff\1"+
			"\u010a",
			"\1\u010b",
			"\1\u010c",
			"\1\u010d",
			"\1\u010e",
			"\1\u010f\4\uffff\1\u0110\1\uffff\1\u0111\1\u0112",
			"\1\u0113",
			"\1\u0114",
			"\1\u0115",
			"\1\u0116",
			"\1\u0117",
			"\1\u0118",
			"\1\u0119",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u011b\23\uffff\1\u011c",
			"\1\u011d\5\uffff\1\u011e\13\uffff\1\u011f",
			"\1\u0120\2\uffff\1\u0121\13\uffff\1\u0122",
			"\1\u0123\3\uffff\1\u0124\3\uffff\1\u0125",
			"\1\u0126",
			"\1\u0127",
			"\1\u0128",
			"\1\u0129",
			"\53\u012c\1\u012a\uffd4\u012c",
			"\0\u012e",
			"",
			"",
			"",
			"\0\u012e",
			"",
			"",
			"",
			"",
			"\12\u0095\7\uffff\32\u0095\4\uffff\1\u0095\1\uffff\32\u0095\5\uffff"+
			"\u1f82\u0095\1\uffff\udffc\u0095",
			"",
			"",
			"\1\u0099\1\uffff\12\u0098\13\uffff\1\u009a\37\uffff\1\u009a",
			"\12\u0130",
			"",
			"\12\u009b\13\uffff\1\u009a\37\uffff\1\u009a",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\u0132",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0135",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0138",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u013a",
			"",
			"\12\102\7\uffff\32\102\4\uffff\1\102\1\uffff\26\102\1\u013b\3\102\5"+
			"\uffff\u1f82\102\1\uffff\udffc\102",
			"",
			"\1\u013c",
			"\1\u013d\1\uffff\1\u013e\16\uffff\1\u013f",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0141",
			"\1\u0142",
			"\1\u0143",
			"\1\u0144",
			"\1\u0145",
			"\1\u0146\1\u0147",
			"\1\u0148",
			"\1\u0149",
			"\1\u014a",
			"\1\u014b",
			"\1\u014c",
			"\1\u014d\22\uffff\1\u014e",
			"\1\u014f",
			"\1\u0150",
			"\1\u0151",
			"\1\u0152",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0154",
			"\1\u0155",
			"\1\u0156",
			"\1\u0157",
			"\1\u0158",
			"\1\u0159",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u015b",
			"\1\u015c",
			"\1\u015d",
			"\1\u015e",
			"\1\u015f",
			"\1\u0160",
			"",
			"\1\u0161",
			"\1\u0162",
			"\1\u0163",
			"\1\u0164\5\uffff\1\u0165",
			"\1\u0166",
			"\1\u0167",
			"\1\u0168",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\22\76\1\u0169\7\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"\1\u016b",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u016d",
			"\1\u016e",
			"\1\u016f",
			"\1\u0170",
			"\1\u0171",
			"\1\u0172",
			"\1\u0173",
			"\1\u0174",
			"\1\u0175",
			"\1\u0176",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0178",
			"\1\u0179",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\22\76\1\u017a\7\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"\1\u017c",
			"",
			"\1\u017d",
			"\1\u017e",
			"",
			"\1\u017f",
			"\1\u0180",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0182",
			"\1\u0183",
			"\1\u0184",
			"\1\u0185",
			"\1\u0186",
			"\1\u0187",
			"\1\u0188",
			"\12\76\7\uffff\32\76\4\uffff\1\u018a\1\uffff\22\76\1\u0189\7\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"\1\u018c",
			"\1\u018d",
			"\1\u018e",
			"\1\u018f",
			"\1\u0190",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0192",
			"\1\u0193",
			"\1\u0194",
			"\1\u0195\1\uffff\1\u0196",
			"\1\u0197",
			"\1\u0198",
			"\1\u0199",
			"",
			"\1\u019a",
			"\1\u019b",
			"\1\u019c",
			"\1\u019d",
			"\1\u019e",
			"\1\u019f",
			"\1\u01a0",
			"\1\u01a1",
			"\1\u01a2",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u01a4",
			"\1\u01a5",
			"\1\u01a6",
			"\1\u01a7\3\uffff\1\u01a8",
			"\1\u01a9",
			"\0\u01ab",
			"",
			"",
			"",
			"",
			"",
			"\12\u0130\13\uffff\1\u009a\37\uffff\1\u009a",
			"",
			"\1\u01ac",
			"",
			"",
			"\1\u01ad",
			"",
			"",
			"\1\u01ae",
			"",
			"\1\u01af",
			"\12\102\7\uffff\32\102\4\uffff\1\102\1\uffff\4\102\1\u01b0\25\102\5"+
			"\uffff\u1f82\102\1\uffff\udffc\102",
			"\1\u01b1",
			"\1\u01b2",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u01b5",
			"\1\u01b6",
			"\1\u01b7",
			"\1\u01b8",
			"\1\u01b9",
			"\1\u01ba",
			"\1\u01bb",
			"\1\u01bc",
			"\1\u01bd",
			"\1\u01be",
			"\1\u01bf",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u01c1",
			"\1\u01c2",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u01c4",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u01c6",
			"",
			"\1\u01c7",
			"\1\u01c8",
			"\1\u01c9",
			"\1\u01ca",
			"\1\u01cb",
			"\1\u01cc",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u01cf",
			"\1\u01d0",
			"\1\u01d1",
			"\1\u01d2",
			"\1\u01d3",
			"\1\u01d4",
			"\1\u01d5",
			"\1\u01d6",
			"\1\u01d7",
			"\1\u01d8",
			"\1\u01d9",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u01de",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u01e1",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u01e3",
			"\1\u01e4",
			"\1\u01e5",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u01e7",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\22\76\1\u01e8\7\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"\1\u01ea",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u01ed",
			"\1\u01ee",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u01f0",
			"\1\u01f1",
			"\1\u01f2",
			"\1\u01f3",
			"\1\u01f4",
			"\1\u01f5",
			"\1\u01f6",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u01f8",
			"",
			"\1\u01f9",
			"\1\u01fa",
			"\1\u01fb",
			"\1\u01fc",
			"\1\u01fd",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0200",
			"\1\u0201",
			"\1\u0202",
			"\1\u0203",
			"\1\u0204",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0206",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0208",
			"\1\u0209",
			"\1\u020a",
			"\1\u020b",
			"\1\u020c",
			"\1\u020d",
			"\1\u020e",
			"",
			"\1\u020f",
			"\1\u0210",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0213",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\10\76\1\u0214\21\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"",
			"",
			"\1\u0216",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\102\7\uffff\32\102\4\uffff\1\102\1\uffff\4\102\1\u021a\25\102\5"+
			"\uffff\u1f82\102\1\uffff\udffc\102",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u021c",
			"",
			"",
			"\1\u021d",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u021f",
			"\1\u0220\20\uffff\1\u0221",
			"\1\u0222",
			"\1\u0223",
			"\1\u0224",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0226",
			"\1\u0227",
			"\1\u0228",
			"",
			"\1\u0229",
			"\1\u022a",
			"",
			"\1\u022b",
			"",
			"\1\u022c",
			"\1\u022d",
			"\1\u022e",
			"\1\u022f",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"",
			"\1\u0233",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0236",
			"\1\u0237",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0239",
			"\1\u023a",
			"\1\u023b",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"",
			"",
			"",
			"\1\u023e",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0241",
			"\1\u0242",
			"",
			"\1\u0243",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u0245",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u0248",
			"\1\u0249",
			"\1\u024a",
			"\1\u024b",
			"\1\u024c",
			"\1\u024d",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u024f",
			"\1\u0250",
			"\1\u0251",
			"\1\u0252",
			"\1\u0253",
			"\1\u0254",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0257",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\22\76\1\u0258\7\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"\1\u025a",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u025c",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u025e",
			"\1\u025f",
			"\1\u0260",
			"\1\u0261",
			"\1\u0262",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\22\76\1\u0264\7\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0267",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"",
			"",
			"\12\102\7\uffff\32\102\4\uffff\1\102\1\uffff\15\102\1\u0269\14\102\5"+
			"\uffff\u1f82\102\1\uffff\udffc\102",
			"",
			"\1\u026a",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\u026d\1\uffff\22\76\1\u026c\7\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"\1\u026f",
			"\1\u0270",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0272",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u0274",
			"\1\u0275",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0277",
			"\1\u0278",
			"\1\u0279",
			"\1\u027a",
			"\1\u027b",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u027d",
			"",
			"",
			"",
			"\1\u027e",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u0281",
			"\1\u0282",
			"\1\u0283",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"",
			"\1\u0285",
			"\1\u0286",
			"\1\u0287",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"",
			"\1\u0289",
			"\1\u028a",
			"\1\u028b",
			"\1\u028c",
			"\1\u028d\11\uffff\1\u028e",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u0290",
			"\1\u0291",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\22\76\1\u0292\7\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0295",
			"\1\u0296",
			"",
			"",
			"\1\u0297",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\1\u0298\31\76\5\uffff\u1f82"+
			"\76\1\uffff\udffc\76",
			"",
			"\1\u029a",
			"",
			"\1\u029b",
			"",
			"\1\u029c",
			"\12\76\7\uffff\32\76\4\uffff\1\u029d\1\uffff\32\76\5\uffff\u1f82\76"+
			"\1\uffff\udffc\76",
			"\1\u029f",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\12\102\7\uffff\32\102\4\uffff\1\102\1\uffff\32\102\5\uffff\u1f82\102"+
			"\1\uffff\udffc\102",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02a7",
			"",
			"\1\u02a8",
			"\1\u02a9",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\25\76\1\u02ac\4\76\5\uffff"+
			"\u1f82\76\1\uffff\udffc\76",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02af",
			"\1\u02b0",
			"\1\u02b1",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02b4",
			"",
			"",
			"\1\u02b5",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02b7",
			"",
			"\1\u02b8",
			"\1\u02b9",
			"\1\u02ba",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02bf",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u02c1",
			"\1\u02c2",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"",
			"\1\u02c4",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02c6",
			"\1\u02c7",
			"",
			"\1\u02c8",
			"\1\u02c9",
			"\1\u02ca",
			"\1\u02cb",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\u02cd",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02cf",
			"",
			"",
			"\1\u02d0",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02d2",
			"\1\u02d3",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02d5",
			"",
			"\1\u02d6",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"",
			"",
			"",
			"\1\u02da",
			"",
			"\1\u02db",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u02de",
			"\1\u02df",
			"\1\u02e0",
			"\1\u02e1",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02e3",
			"",
			"\1\u02e4",
			"",
			"\1\u02e5",
			"\1\u02e6",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02e8",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02ec",
			"",
			"",
			"\1\u02ed",
			"\1\u02ee",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"",
			"\1\u02f1",
			"\1\u02f2",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02f4",
			"",
			"\1\u02f5",
			"",
			"",
			"",
			"\1\u02f6",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u02f8",
			"",
			"",
			"\1\u02f9",
			"\1\u02fa",
			"",
			"\1\u02fb",
			"\1\u02fc",
			"\1\u02fd",
			"",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0300",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0302",
			"\1\u0303",
			"",
			"",
			"\1\u0304",
			"",
			"\1\u0305",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u0307",
			"\1\u0308",
			"",
			"\1\u0309",
			"\1\u030a",
			"\1\u030b",
			"\1\u030c",
			"\1\u030d",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			"\1\u030f",
			"",
			"\1\u0310",
			"\1\u0311",
			"\1\u0312",
			"\1\u0313",
			"\1\u0314",
			"\12\76\7\uffff\32\76\4\uffff\1\76\1\uffff\32\76\5\uffff\u1f82\76\1\uffff"+
			"\udffc\76",
			""
	};

	static final short[] DFA30_eot = DFA.unpackEncodedString(DFA30_eotS);
	static final short[] DFA30_eof = DFA.unpackEncodedString(DFA30_eofS);
	static final char[] DFA30_min = DFA.unpackEncodedStringToUnsignedChars(DFA30_minS);
	static final char[] DFA30_max = DFA.unpackEncodedStringToUnsignedChars(DFA30_maxS);
	static final short[] DFA30_accept = DFA.unpackEncodedString(DFA30_acceptS);
	static final short[] DFA30_special = DFA.unpackEncodedString(DFA30_specialS);
	static final short[][] DFA30_transition;

	static {
		int numStates = DFA30_transitionS.length;
		DFA30_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA30_transition[i] = DFA.unpackEncodedString(DFA30_transitionS[i]);
		}
	}

	protected class DFA30 extends DFA {

		public DFA30(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 30;
			this.eot = DFA30_eot;
			this.eof = DFA30_eof;
			this.min = DFA30_min;
			this.max = DFA30_max;
			this.accept = DFA30_accept;
			this.special = DFA30_special;
			this.transition = DFA30_transition;
		}
		@Override
		public String getDescription() {
			return "1:1: Tokens : ( ACTIVE | ADD | ALL | ALTER | AND | ANY | ARRAY | AS | ASC | ASYNC | BETWEEN | BY | CACHE | CASCADE | CASE | CAST | CDC | CHANGE | CLOSE | COLUMN | COLUMNS | COLUMN_QUALIFIER_COUNTER | CONSTANT | CONSTRAINT | CREATE | CURRENT | CURSOR | CYCLE | DECLARE | DEFAULT | DEFAULTVALUE | DELETE | DESC | DISABLE | DISTINCT | DROP | DUPLICATE | ELSE | ENCODED_QUALIFIER | END | EXECUTE | EXISTS | EXPLAIN | FALSE | FETCH | FIRST | FOR | FROM | FULL | FUNCTION | GRANT | GROUP | HAVING | IF | IGNORE | ILIKE | IMMUTABLE | IN | INCLUDE | INCREMENT | INDEX | INNER | INTO | IS | JAR | JARS | JOIN | KEY | LAST | LATEST | LEFT | LIKE | LIMIT | LIST | LOCAL | MAXVALUE | MINVALUE | NEXT | NOT | NOVERIFY | NULL | NULLS | OFF | OFFSET | ON | ONLY | OPEN | OR | ORDER | OUTER | POST | PRE | PRIMARY | REBUILD | REGIONS | REPLACE | RETURNING | RETURNS | REVOKE | RIGHT | ROW | ROWS | ROW_TIMESTAMP | SAMPLING | SCHEMA | SCHEMAS | SELECT | SEQUENCE | SESSION | SET | SHOW | SOME | SPLIT | START | STATISTICS | TABLE | TABLES | TABLESAMPLE | TEMPORARY | THEN | TO | TRACE | TRUE | UNCOVERED | UNION | UNUSABLE | UPDATE | UPDATE_ONLY | UPGRADE | UPSERT | USABLE | USE | USING | VALUE | VALUES | VIEW | WHEN | WHERE | WITH | WITHIN | HINT_START | COMMENT_START | COMMENT_AND_HINT_END | SL_COMMENT1 | SL_COMMENT2 | BIND_NAME | HEX_LITERAL | BIN_LITERAL | NAME | NUMBER | DECIMAL | DOUBLE | Exponent | DOUBLE_QUOTE | EQ | LT | GT | DOUBLE_EQ | NOEQ1 | NOEQ2 | CONCAT | COMMA | LPAREN | RPAREN | SEMICOLON | COLON | QUESTION | LSQUARE | RSQUARE | LCURLY | RCURLY | AT | TILDE | PLUS | MINUS | ASTERISK | DIVIDE | PERCENT | OUTER_JOIN | STRING_LITERAL | WS | EOL | ML_HINT | ML_COMMENT | SL_COMMENT | DOT | OTHER );";
		}
		@Override
		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			IntStream input = _input;
			int _s = s;
			switch ( s ) {
					case 0 : 
						int LA30_30 = input.LA(1);
						s = -1;
						if ( ((LA30_30 >= '\u0000' && LA30_30 <= '\uFFFF')) ) {s = 62;}
						else s = 150;
						if ( s>=0 ) return s;
						break;

					case 1 : 
						int LA30_139 = input.LA(1);
						s = -1;
						if ( (LA30_139=='+') ) {s = 298;}
						else if ( ((LA30_139 >= '\u0000' && LA30_139 <= '*')||(LA30_139 >= ',' && LA30_139 <= '\uFFFF')) ) {s = 300;}
						else s = 299;
						if ( s>=0 ) return s;
						break;

					case 2 : 
						int LA30_140 = input.LA(1);
						s = -1;
						if ( ((LA30_140 >= '\u0000' && LA30_140 <= '\uFFFF')) ) {s = 302;}
						else s = 301;
						if ( s>=0 ) return s;
						break;

					case 3 : 
						int LA30_144 = input.LA(1);
						s = -1;
						if ( ((LA30_144 >= '\u0000' && LA30_144 <= '\uFFFF')) ) {s = 302;}
						else s = 303;
						if ( s>=0 ) return s;
						break;

					case 4 : 
						int LA30_52 = input.LA(1);
						s = -1;
						if ( ((LA30_52 >= '\u0000' && LA30_52 <= '\uFFFF')) ) {s = 178;}
						else s = 55;
						if ( s>=0 ) return s;
						break;

					case 5 : 
						int LA30_0 = input.LA(1);
						s = -1;
						if ( (LA30_0=='a') ) {s = 1;}
						else if ( (LA30_0=='b') ) {s = 2;}
						else if ( (LA30_0=='c') ) {s = 3;}
						else if ( (LA30_0=='d') ) {s = 4;}
						else if ( (LA30_0=='e') ) {s = 5;}
						else if ( (LA30_0=='f') ) {s = 6;}
						else if ( (LA30_0=='g') ) {s = 7;}
						else if ( (LA30_0=='h') ) {s = 8;}
						else if ( (LA30_0=='i') ) {s = 9;}
						else if ( (LA30_0=='j') ) {s = 10;}
						else if ( (LA30_0=='k') ) {s = 11;}
						else if ( (LA30_0=='l') ) {s = 12;}
						else if ( (LA30_0=='m') ) {s = 13;}
						else if ( (LA30_0=='n') ) {s = 14;}
						else if ( (LA30_0=='o') ) {s = 15;}
						else if ( (LA30_0=='p') ) {s = 16;}
						else if ( (LA30_0=='r') ) {s = 17;}
						else if ( (LA30_0=='s') ) {s = 18;}
						else if ( (LA30_0=='t') ) {s = 19;}
						else if ( (LA30_0=='u') ) {s = 20;}
						else if ( (LA30_0=='v') ) {s = 21;}
						else if ( (LA30_0=='w') ) {s = 22;}
						else if ( (LA30_0=='/') ) {s = 23;}
						else if ( (LA30_0=='*') ) {s = 24;}
						else if ( (LA30_0=='-') ) {s = 25;}
						else if ( (LA30_0==':') ) {s = 26;}
						else if ( (LA30_0=='X'||LA30_0=='x') ) {s = 27;}
						else if ( (LA30_0=='B') ) {s = 28;}
						else if ( (LA30_0=='E') ) {s = 29;}
						else if ( (LA30_0=='\"') ) {s = 30;}
						else if ( ((LA30_0 >= '0' && LA30_0 <= '9')) ) {s = 31;}
						else if ( (LA30_0=='.') ) {s = 32;}
						else if ( (LA30_0=='A'||(LA30_0 >= 'C' && LA30_0 <= 'D')||(LA30_0 >= 'F' && LA30_0 <= 'W')||(LA30_0 >= 'Y' && LA30_0 <= 'Z')||LA30_0=='q'||(LA30_0 >= 'y' && LA30_0 <= 'z')) ) {s = 33;}
						else if ( (LA30_0=='=') ) {s = 34;}
						else if ( (LA30_0=='<') ) {s = 35;}
						else if ( (LA30_0=='>') ) {s = 36;}
						else if ( (LA30_0=='!') ) {s = 37;}
						else if ( (LA30_0=='|') ) {s = 38;}
						else if ( (LA30_0==',') ) {s = 39;}
						else if ( (LA30_0=='(') ) {s = 40;}
						else if ( (LA30_0==')') ) {s = 41;}
						else if ( (LA30_0==';') ) {s = 42;}
						else if ( (LA30_0=='?') ) {s = 43;}
						else if ( (LA30_0=='[') ) {s = 44;}
						else if ( (LA30_0==']') ) {s = 45;}
						else if ( (LA30_0=='{') ) {s = 46;}
						else if ( (LA30_0=='}') ) {s = 47;}
						else if ( (LA30_0=='@') ) {s = 48;}
						else if ( (LA30_0=='~') ) {s = 49;}
						else if ( (LA30_0=='+') ) {s = 50;}
						else if ( (LA30_0=='%') ) {s = 51;}
						else if ( (LA30_0=='\'') ) {s = 52;}
						else if ( (LA30_0=='\t'||LA30_0==' '||LA30_0=='\u2002') ) {s = 53;}
						else if ( (LA30_0=='\n'||LA30_0=='\r') ) {s = 54;}
						else if ( ((LA30_0 >= '\u0000' && LA30_0 <= '\b')||(LA30_0 >= '\u000B' && LA30_0 <= '\f')||(LA30_0 >= '\u000E' && LA30_0 <= '\u001F')||(LA30_0 >= '#' && LA30_0 <= '$')||LA30_0=='&'||LA30_0=='\\'||(LA30_0 >= '^' && LA30_0 <= '`')||(LA30_0 >= '\u007F' && LA30_0 <= '\u2001')||(LA30_0 >= '\u2003' && LA30_0 <= '\uFFFF')) ) {s = 55;}
						if ( s>=0 ) return s;
						break;

					case 6 : 
						int LA30_298 = input.LA(1);
						s = -1;
						if ( ((LA30_298 >= '\u0000' && LA30_298 <= '\uFFFF')) ) {s = 427;}
						else s = 426;
						if ( s>=0 ) return s;
						break;
			}
			if (state.backtracking>0) {state.failed=true; return -1;}
			NoViableAltException nvae =
				new NoViableAltException(getDescription(), 30, _s, input);
			error(nvae);
			throw nvae;
		}
	}

}
