// $ANTLR 3.5.2 PhoenixBsonExpression.g 2025-10-07 16:50:46

/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.parse;

///CLOVER:OFF
import org.apache.hadoop.hbase.CompareOperator;
import java.lang.Boolean;
import org.apache.phoenix.util.SchemaUtil;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
@SuppressWarnings("all")
public class PhoenixBsonExpressionParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "AND", "ASTERISK", "AT", "ATTR", 
		"ATTR_NOT", "ATTR_TYPE", "BEGINS_WITH", "BETWEEN", "BIND_VALUE", "BIND_VALUE_CHARS", 
		"CHAR", "CHAR_ESC", "COLON", "COMMA", "CONCAT", "CONTAINS", "DECIMAL", 
		"DIGIT", "DIVIDE", "DOCUMENT_FIELD", "DOT", "DOUBLE", "DOUBLE_EQ", "DOUBLE_QUOTE", 
		"EOL", "EQ", "Exponent", "FALSE", "FIELD", "FIELD_NOT", "FIELD_TYPE", 
		"GT", "HASH", "HASH_DOCUMENT_FIELD", "IN", "IS", "LCURLY", "LETTER", "LPAREN", 
		"LSQUARE", "LT", "MINUS", "NOEQ1", "NOEQ2", "NOT", "NULL", "OR", "PERCENT", 
		"PLUS", "POSINTEGER", "QUESTION", "RCURLY", "RPAREN", "RSQUARE", "SEMICOLON", 
		"SIZE", "STRING_LITERAL", "TILDE", "TRUE", "UNDERSCORE", "WS"
	};
	public static final int EOF=-1;
	public static final int AND=4;
	public static final int ASTERISK=5;
	public static final int AT=6;
	public static final int ATTR=7;
	public static final int ATTR_NOT=8;
	public static final int ATTR_TYPE=9;
	public static final int BEGINS_WITH=10;
	public static final int BETWEEN=11;
	public static final int BIND_VALUE=12;
	public static final int BIND_VALUE_CHARS=13;
	public static final int CHAR=14;
	public static final int CHAR_ESC=15;
	public static final int COLON=16;
	public static final int COMMA=17;
	public static final int CONCAT=18;
	public static final int CONTAINS=19;
	public static final int DECIMAL=20;
	public static final int DIGIT=21;
	public static final int DIVIDE=22;
	public static final int DOCUMENT_FIELD=23;
	public static final int DOT=24;
	public static final int DOUBLE=25;
	public static final int DOUBLE_EQ=26;
	public static final int DOUBLE_QUOTE=27;
	public static final int EOL=28;
	public static final int EQ=29;
	public static final int Exponent=30;
	public static final int FALSE=31;
	public static final int FIELD=32;
	public static final int FIELD_NOT=33;
	public static final int FIELD_TYPE=34;
	public static final int GT=35;
	public static final int HASH=36;
	public static final int HASH_DOCUMENT_FIELD=37;
	public static final int IN=38;
	public static final int IS=39;
	public static final int LCURLY=40;
	public static final int LETTER=41;
	public static final int LPAREN=42;
	public static final int LSQUARE=43;
	public static final int LT=44;
	public static final int MINUS=45;
	public static final int NOEQ1=46;
	public static final int NOEQ2=47;
	public static final int NOT=48;
	public static final int NULL=49;
	public static final int OR=50;
	public static final int PERCENT=51;
	public static final int PLUS=52;
	public static final int POSINTEGER=53;
	public static final int QUESTION=54;
	public static final int RCURLY=55;
	public static final int RPAREN=56;
	public static final int RSQUARE=57;
	public static final int SEMICOLON=58;
	public static final int SIZE=59;
	public static final int STRING_LITERAL=60;
	public static final int TILDE=61;
	public static final int TRUE=62;
	public static final int UNDERSCORE=63;
	public static final int WS=64;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public PhoenixBsonExpressionParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public PhoenixBsonExpressionParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return PhoenixBsonExpressionParser.tokenNames; }
	@Override public String getGrammarFileName() { return "PhoenixBsonExpression.g"; }



	    private ParseNodeFactory factory;

	    public void setParseNodeFactory(ParseNodeFactory factory) {
	        this.factory = factory;
	    }

	    public int line(Token t) {
	        return t.getLine();
	    }

	    public int column(Token t) {
	        return t.getCharPositionInLine() + 1;
	    }

	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	        throws RecognitionException {
	        RecognitionException e = null;
	        // if next token is what we are looking for then "delete" this token
	        if (mismatchIsUnwantedToken(input, ttype)) {
	            e = new UnwantedTokenException(ttype, input);
	        } else if (mismatchIsMissingToken(input, follow)) {
	            Object inserted = getMissingSymbol(input, e, ttype, follow);
	            e = new MissingTokenException(ttype, input, inserted);
	        } else {
	            e = new MismatchedTokenException(ttype, input);
	        }
	        throw e;
	    }

	    public Object recoverFromMismatchedSet(IntStream input, RecognitionException e, BitSet follow)
	        throws RecognitionException
	    {
	        throw e;
	    }

	    @Override
	    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
	        if (e instanceof MismatchedTokenException) {
	            MismatchedTokenException mte = (MismatchedTokenException)e;
	            String txt = mte.token.getText();
	            String p = mte.token.getType() == -1 ? "EOF" : PARAPHRASE[mte.token.getType()];
	            String expecting = (mte.expecting < PARAPHRASE.length && mte.expecting >= 0) ? PARAPHRASE[mte.expecting] : null;
	            if (expecting == null) {
	                return "unexpected token (" + line(mte.token) + "," + column(mte.token) + "): " + (txt != null ? txt : p);
	            } else {
	                return "expecting " + expecting +
	                    ", found '" + (txt != null ? txt : p) + "'";
	            }
	        } else if (e instanceof NoViableAltException) {
	            //NoViableAltException nvae = (NoViableAltException)e;
	            return "unexpected token: (" + line(e.token) + "," + column(e.token) + ")" + getTokenErrorDisplay(e.token);
	        }
	        return super.getErrorMessage(e, tokenNames);
	     }

	    public String getTokenErrorDisplay(int t) {
	        String ret = PARAPHRASE[t];
	        if (ret == null) ret = "<UNKNOWN>";
	        return ret;
	    }


	    private String[] PARAPHRASE = new String[getTokenNames().length];
	    {
	        PARAPHRASE[POSINTEGER] = "a number";
	        PARAPHRASE[EQ] = "an equals sign";
	        PARAPHRASE[LT] = "a left angle bracket";
	        PARAPHRASE[GT] = "a right angle bracket";
	        PARAPHRASE[COMMA] = "a comma";
	        PARAPHRASE[LPAREN] = "a left parentheses";
	        PARAPHRASE[RPAREN] = "a right parentheses";
	        PARAPHRASE[SEMICOLON] = "a semi-colon";
	        PARAPHRASE[COLON] = "a colon";
	        PARAPHRASE[LSQUARE] = "left square bracket";
	        PARAPHRASE[RSQUARE] = "right square bracket";
	        PARAPHRASE[LCURLY] = "left curly bracket";
	        PARAPHRASE[RCURLY] = "right curly bracket";
	        PARAPHRASE[AT] = "at";
	        PARAPHRASE[MINUS] = "a subtraction";
	        PARAPHRASE[TILDE] = "a tilde";
	        PARAPHRASE[PLUS] = "an addition";
	        PARAPHRASE[ASTERISK] = "an asterisk";
	        PARAPHRASE[DIVIDE] = "a division";
	        PARAPHRASE[LETTER] = "an ansi letter";
	        PARAPHRASE[POSINTEGER] = "a positive integer";
	        PARAPHRASE[DIGIT] = "a number from 0 to 9";
	    }



	// $ANTLR start "string_literal"
	// PhoenixBsonExpression.g:198:1: string_literal returns [String ret] : s= STRING_LITERAL ;
	public final String string_literal() throws RecognitionException {
		String ret = null;


		Token s=null;

		try {
			// PhoenixBsonExpression.g:199:5: (s= STRING_LITERAL )
			// PhoenixBsonExpression.g:199:9: s= STRING_LITERAL
			{
			s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_string_literal254); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = SchemaUtil.normalizeLiteral(factory.literal(s.getText())); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "string_literal"



	// $ANTLR start "expression"
	// PhoenixBsonExpression.g:202:1: expression returns [ParseNode ret] : e= or_expression ;
	public final ParseNode expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;

		try {
			// PhoenixBsonExpression.g:203:5: (e= or_expression )
			// PhoenixBsonExpression.g:203:9: e= or_expression
			{
			pushFollow(FOLLOW_or_expression_in_expression281);
			e=or_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = e; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression"



	// $ANTLR start "or_expression"
	// PhoenixBsonExpression.g:206:1: or_expression returns [ParseNode ret] : i= and_expression ( OR i= and_expression )* ;
	public final ParseNode or_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixBsonExpression.g:208:5: (i= and_expression ( OR i= and_expression )* )
			// PhoenixBsonExpression.g:208:9: i= and_expression ( OR i= and_expression )*
			{
			pushFollow(FOLLOW_and_expression_in_or_expression312);
			i=and_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixBsonExpression.g:208:38: ( OR i= and_expression )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==OR) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// PhoenixBsonExpression.g:208:39: OR i= and_expression
					{
					match(input,OR,FOLLOW_OR_in_or_expression317); if (state.failed) return ret;
					pushFollow(FOLLOW_and_expression_in_or_expression321);
					i=and_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop1;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.or(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "or_expression"



	// $ANTLR start "and_expression"
	// PhoenixBsonExpression.g:211:1: and_expression returns [ParseNode ret] : i= not_expression ( AND i= not_expression )* ;
	public final ParseNode and_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixBsonExpression.g:213:5: (i= not_expression ( AND i= not_expression )* )
			// PhoenixBsonExpression.g:213:9: i= not_expression ( AND i= not_expression )*
			{
			pushFollow(FOLLOW_not_expression_in_and_expression356);
			i=not_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixBsonExpression.g:213:38: ( AND i= not_expression )*
			loop2:
			while (true) {
				int alt2=2;
				int LA2_0 = input.LA(1);
				if ( (LA2_0==AND) ) {
					alt2=1;
				}

				switch (alt2) {
				case 1 :
					// PhoenixBsonExpression.g:213:39: AND i= not_expression
					{
					match(input,AND,FOLLOW_AND_in_and_expression361); if (state.failed) return ret;
					pushFollow(FOLLOW_not_expression_in_and_expression365);
					i=not_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop2;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.and(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "and_expression"



	// $ANTLR start "not_expression"
	// PhoenixBsonExpression.g:216:1: not_expression returns [ParseNode ret] : ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN );
	public final ParseNode not_expression() throws RecognitionException {
		ParseNode ret = null;


		Token n=null;
		ParseNode e =null;

		try {
			// PhoenixBsonExpression.g:217:5: ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN )
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==NOT) ) {
				int LA5_1 = input.LA(2);
				if ( (synpred1_PhoenixBsonExpression()) ) {
					alt5=1;
				}
				else if ( (true) ) {
					alt5=2;
				}

			}
			else if ( (LA5_0==BIND_VALUE) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==DOCUMENT_FIELD) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==HASH_DOCUMENT_FIELD) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==STRING_LITERAL) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==POSINTEGER) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==DECIMAL) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==DOUBLE) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==NULL) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==TRUE) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==FALSE) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==SIZE) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==LPAREN) ) {
				int LA5_13 = input.LA(2);
				if ( (synpred1_PhoenixBsonExpression()) ) {
					alt5=1;
				}
				else if ( (true) ) {
					alt5=2;
				}

			}
			else if ( (LA5_0==ATTR||LA5_0==FIELD) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==ATTR_NOT||LA5_0==FIELD_NOT) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==BEGINS_WITH) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==CONTAINS) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}
			else if ( (LA5_0==ATTR_TYPE||LA5_0==FIELD_TYPE) && (synpred1_PhoenixBsonExpression())) {
				alt5=1;
			}

			switch (alt5) {
				case 1 :
					// PhoenixBsonExpression.g:217:9: ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression
					{
					// PhoenixBsonExpression.g:217:40: (n= NOT )?
					int alt3=2;
					int LA3_0 = input.LA(1);
					if ( (LA3_0==NOT) ) {
						alt3=1;
					}
					switch (alt3) {
						case 1 :
							// PhoenixBsonExpression.g:217:40: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression406); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_boolean_expression_in_not_expression411);
					e=boolean_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:218:9: (n= NOT )? LPAREN e= expression RPAREN
					{
					// PhoenixBsonExpression.g:218:10: (n= NOT )?
					int alt4=2;
					int LA4_0 = input.LA(1);
					if ( (LA4_0==NOT) ) {
						alt4=1;
					}
					switch (alt4) {
						case 1 :
							// PhoenixBsonExpression.g:218:10: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression425); if (state.failed) return ret;
							}
							break;

					}

					match(input,LPAREN,FOLLOW_LPAREN_in_not_expression428); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_not_expression432);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_not_expression434); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "not_expression"



	// $ANTLR start "comparison_op"
	// PhoenixBsonExpression.g:221:1: comparison_op returns [CompareOperator ret] : ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) );
	public final CompareOperator comparison_op() throws RecognitionException {
		CompareOperator ret = null;


		try {
			// PhoenixBsonExpression.g:222:2: ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) )
			int alt6=6;
			switch ( input.LA(1) ) {
			case EQ:
				{
				alt6=1;
				}
				break;
			case LT:
				{
				int LA6_2 = input.LA(2);
				if ( (LA6_2==EQ) ) {
					alt6=4;
				}
				else if ( (LA6_2==BIND_VALUE||LA6_2==DECIMAL||LA6_2==DOCUMENT_FIELD||LA6_2==DOUBLE||LA6_2==FALSE||LA6_2==HASH_DOCUMENT_FIELD||LA6_2==LPAREN||LA6_2==NULL||LA6_2==POSINTEGER||(LA6_2 >= SIZE && LA6_2 <= STRING_LITERAL)||LA6_2==TRUE) ) {
					alt6=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 6, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case GT:
				{
				int LA6_3 = input.LA(2);
				if ( (LA6_3==EQ) ) {
					alt6=5;
				}
				else if ( (LA6_3==BIND_VALUE||LA6_3==DECIMAL||LA6_3==DOCUMENT_FIELD||LA6_3==DOUBLE||LA6_3==FALSE||LA6_3==HASH_DOCUMENT_FIELD||LA6_3==LPAREN||LA6_3==NULL||LA6_3==POSINTEGER||(LA6_3 >= SIZE && LA6_3 <= STRING_LITERAL)||LA6_3==TRUE) ) {
					alt6=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 6, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NOEQ1:
			case NOEQ2:
				{
				alt6=6;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 6, 0, input);
				throw nvae;
			}
			switch (alt6) {
				case 1 :
					// PhoenixBsonExpression.g:222:4: EQ
					{
					match(input,EQ,FOLLOW_EQ_in_comparison_op454); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.EQUAL; }
					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:223:4: LT
					{
					match(input,LT,FOLLOW_LT_in_comparison_op461); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.LESS; }
					}
					break;
				case 3 :
					// PhoenixBsonExpression.g:224:4: GT
					{
					match(input,GT,FOLLOW_GT_in_comparison_op468); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.GREATER; }
					}
					break;
				case 4 :
					// PhoenixBsonExpression.g:225:4: LT EQ
					{
					match(input,LT,FOLLOW_LT_in_comparison_op475); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op477); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.LESS_OR_EQUAL; }
					}
					break;
				case 5 :
					// PhoenixBsonExpression.g:226:4: GT EQ
					{
					match(input,GT,FOLLOW_GT_in_comparison_op484); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op486); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOperator.GREATER_OR_EQUAL; }
					}
					break;
				case 6 :
					// PhoenixBsonExpression.g:227:4: ( NOEQ1 | NOEQ2 )
					{
					if ( (input.LA(1) >= NOEQ1 && input.LA(1) <= NOEQ2) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if ( state.backtracking==0 ) { ret = CompareOperator.NOT_EQUAL; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "comparison_op"



	// $ANTLR start "boolean_expression"
	// PhoenixBsonExpression.g:230:1: boolean_expression returns [ParseNode ret] : (l= value_expression ( (op= comparison_op (r= value_expression ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( BETWEEN r1= value_expression AND r2= value_expression ) | ( IN ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) |) | ( ATTR | FIELD ) ( LPAREN t= literal RPAREN ) | ( ATTR_NOT | FIELD_NOT ) ( LPAREN t= literal RPAREN ) | BEGINS_WITH ( LPAREN l= value_expression COMMA r= value_expression RPAREN ) | CONTAINS ( LPAREN l= value_expression COMMA r= value_expression RPAREN ) | ( FIELD_TYPE | ATTR_TYPE ) ( LPAREN l= value_expression COMMA r= value_expression RPAREN ) );
	public final ParseNode boolean_expression() throws RecognitionException {
		ParseNode ret = null;


		Token n=null;
		ParseNode l =null;
		CompareOperator op =null;
		ParseNode r =null;
		ParseNode r1 =null;
		ParseNode r2 =null;
		List<ParseNode> v =null;
		LiteralParseNode t =null;

		try {
			// PhoenixBsonExpression.g:231:5: (l= value_expression ( (op= comparison_op (r= value_expression ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( BETWEEN r1= value_expression AND r2= value_expression ) | ( IN ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) |) | ( ATTR | FIELD ) ( LPAREN t= literal RPAREN ) | ( ATTR_NOT | FIELD_NOT ) ( LPAREN t= literal RPAREN ) | BEGINS_WITH ( LPAREN l= value_expression COMMA r= value_expression RPAREN ) | CONTAINS ( LPAREN l= value_expression COMMA r= value_expression RPAREN ) | ( FIELD_TYPE | ATTR_TYPE ) ( LPAREN l= value_expression COMMA r= value_expression RPAREN ) )
			int alt11=6;
			switch ( input.LA(1) ) {
			case BIND_VALUE:
			case DECIMAL:
			case DOCUMENT_FIELD:
			case DOUBLE:
			case FALSE:
			case HASH_DOCUMENT_FIELD:
			case LPAREN:
			case NULL:
			case POSINTEGER:
			case SIZE:
			case STRING_LITERAL:
			case TRUE:
				{
				alt11=1;
				}
				break;
			case ATTR:
			case FIELD:
				{
				alt11=2;
				}
				break;
			case ATTR_NOT:
			case FIELD_NOT:
				{
				alt11=3;
				}
				break;
			case BEGINS_WITH:
				{
				alt11=4;
				}
				break;
			case CONTAINS:
				{
				alt11=5;
				}
				break;
			case ATTR_TYPE:
			case FIELD_TYPE:
				{
				alt11=6;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 11, 0, input);
				throw nvae;
			}
			switch (alt11) {
				case 1 :
					// PhoenixBsonExpression.g:231:9: l= value_expression ( (op= comparison_op (r= value_expression ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( BETWEEN r1= value_expression AND r2= value_expression ) | ( IN ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) |)
					{
					pushFollow(FOLLOW_value_expression_in_boolean_expression523);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixBsonExpression.g:231:28: ( (op= comparison_op (r= value_expression ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( BETWEEN r1= value_expression AND r2= value_expression ) | ( IN ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) |)
					int alt10=4;
					switch ( input.LA(1) ) {
					case EQ:
					case GT:
					case LT:
					case NOEQ1:
					case NOEQ2:
						{
						alt10=1;
						}
						break;
					case IS:
						{
						alt10=2;
						}
						break;
					case BETWEEN:
					case IN:
					case NOT:
						{
						alt10=3;
						}
						break;
					case EOF:
					case AND:
					case COMMA:
					case OR:
					case RPAREN:
						{
						alt10=4;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 10, 0, input);
						throw nvae;
					}
					switch (alt10) {
						case 1 :
							// PhoenixBsonExpression.g:231:29: (op= comparison_op (r= value_expression ) )
							{
							// PhoenixBsonExpression.g:231:29: (op= comparison_op (r= value_expression ) )
							// PhoenixBsonExpression.g:231:30: op= comparison_op (r= value_expression )
							{
							pushFollow(FOLLOW_comparison_op_in_boolean_expression529);
							op=comparison_op();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixBsonExpression.g:231:47: (r= value_expression )
							// PhoenixBsonExpression.g:231:48: r= value_expression
							{
							pushFollow(FOLLOW_value_expression_in_boolean_expression534);
							r=value_expression();
							state._fsp--;
							if (state.failed) return ret;
							}

							if ( state.backtracking==0 ) {ret = factory.comparison(op,l,r); }
							}

							}
							break;
						case 2 :
							// PhoenixBsonExpression.g:232:22: ( IS (n= NOT )? NULL )
							{
							// PhoenixBsonExpression.g:232:22: ( IS (n= NOT )? NULL )
							// PhoenixBsonExpression.g:232:23: IS (n= NOT )? NULL
							{
							match(input,IS,FOLLOW_IS_in_boolean_expression563); if (state.failed) return ret;
							// PhoenixBsonExpression.g:232:27: (n= NOT )?
							int alt7=2;
							int LA7_0 = input.LA(1);
							if ( (LA7_0==NOT) ) {
								alt7=1;
							}
							switch (alt7) {
								case 1 :
									// PhoenixBsonExpression.g:232:27: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression567); if (state.failed) return ret;
									}
									break;

							}

							match(input,NULL,FOLLOW_NULL_in_boolean_expression570); if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret = factory.isNull(l,n!=null); }
							}

							}
							break;
						case 3 :
							// PhoenixBsonExpression.g:233:22: ( (n= NOT )? ( ( BETWEEN r1= value_expression AND r2= value_expression ) | ( IN ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
							{
							// PhoenixBsonExpression.g:233:22: ( (n= NOT )? ( ( BETWEEN r1= value_expression AND r2= value_expression ) | ( IN ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
							// PhoenixBsonExpression.g:233:24: (n= NOT )? ( ( BETWEEN r1= value_expression AND r2= value_expression ) | ( IN ( LPAREN v= one_or_more_expressions RPAREN ) ) )
							{
							// PhoenixBsonExpression.g:233:25: (n= NOT )?
							int alt8=2;
							int LA8_0 = input.LA(1);
							if ( (LA8_0==NOT) ) {
								alt8=1;
							}
							switch (alt8) {
								case 1 :
									// PhoenixBsonExpression.g:233:25: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression601); if (state.failed) return ret;
									}
									break;

							}

							// PhoenixBsonExpression.g:233:31: ( ( BETWEEN r1= value_expression AND r2= value_expression ) | ( IN ( LPAREN v= one_or_more_expressions RPAREN ) ) )
							int alt9=2;
							int LA9_0 = input.LA(1);
							if ( (LA9_0==BETWEEN) ) {
								alt9=1;
							}
							else if ( (LA9_0==IN) ) {
								alt9=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 9, 0, input);
								throw nvae;
							}

							switch (alt9) {
								case 1 :
									// PhoenixBsonExpression.g:234:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									{
									// PhoenixBsonExpression.g:234:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									// PhoenixBsonExpression.g:234:33: BETWEEN r1= value_expression AND r2= value_expression
									{
									match(input,BETWEEN,FOLLOW_BETWEEN_in_boolean_expression638); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression642);
									r1=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,AND,FOLLOW_AND_in_boolean_expression644); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression648);
									r2=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.between(l,r1,r2,n!=null); }
									}

									}
									break;
								case 2 :
									// PhoenixBsonExpression.g:235:32: ( IN ( LPAREN v= one_or_more_expressions RPAREN ) )
									{
									// PhoenixBsonExpression.g:235:32: ( IN ( LPAREN v= one_or_more_expressions RPAREN ) )
									// PhoenixBsonExpression.g:235:33: IN ( LPAREN v= one_or_more_expressions RPAREN )
									{
									match(input,IN,FOLLOW_IN_in_boolean_expression686); if (state.failed) return ret;
									// PhoenixBsonExpression.g:235:36: ( LPAREN v= one_or_more_expressions RPAREN )
									// PhoenixBsonExpression.g:235:37: LPAREN v= one_or_more_expressions RPAREN
									{
									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression689); if (state.failed) return ret;
									pushFollow(FOLLOW_one_or_more_expressions_in_boolean_expression693);
									v=one_or_more_expressions();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression695); if (state.failed) return ret;
									if ( state.backtracking==0 ) {List<ParseNode> il = new ArrayList<ParseNode>(v.size() + 1); il.add(l); il.addAll(v); ret = factory.inList(il,n!=null);}
									}

									}

									}
									break;

							}

							}

							}
							break;
						case 4 :
							// PhoenixBsonExpression.g:237:22: 
							{
							if ( state.backtracking==0 ) { ret = l; }
							}
							break;

					}

					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:238:13: ( ATTR | FIELD ) ( LPAREN t= literal RPAREN )
					{
					if ( input.LA(1)==ATTR||input.LA(1)==FIELD ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// PhoenixBsonExpression.g:238:28: ( LPAREN t= literal RPAREN )
					// PhoenixBsonExpression.g:238:30: LPAREN t= literal RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression773); if (state.failed) return ret;
					pushFollow(FOLLOW_literal_in_boolean_expression777);
					t=literal();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression779); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.documentFieldExists(t, true); }
					}

					}
					break;
				case 3 :
					// PhoenixBsonExpression.g:239:13: ( ATTR_NOT | FIELD_NOT ) ( LPAREN t= literal RPAREN )
					{
					if ( input.LA(1)==ATTR_NOT||input.LA(1)==FIELD_NOT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// PhoenixBsonExpression.g:239:36: ( LPAREN t= literal RPAREN )
					// PhoenixBsonExpression.g:239:38: LPAREN t= literal RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression807); if (state.failed) return ret;
					pushFollow(FOLLOW_literal_in_boolean_expression811);
					t=literal();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression813); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.documentFieldExists(t, false); }
					}

					}
					break;
				case 4 :
					// PhoenixBsonExpression.g:240:13: BEGINS_WITH ( LPAREN l= value_expression COMMA r= value_expression RPAREN )
					{
					match(input,BEGINS_WITH,FOLLOW_BEGINS_WITH_in_boolean_expression831); if (state.failed) return ret;
					// PhoenixBsonExpression.g:240:25: ( LPAREN l= value_expression COMMA r= value_expression RPAREN )
					// PhoenixBsonExpression.g:240:27: LPAREN l= value_expression COMMA r= value_expression RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression835); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_boolean_expression839);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,COMMA,FOLLOW_COMMA_in_boolean_expression841); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_boolean_expression845);
					r=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression847); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.documentFieldBeginsWith(l, r); }
					}

					}
					break;
				case 5 :
					// PhoenixBsonExpression.g:242:13: CONTAINS ( LPAREN l= value_expression COMMA r= value_expression RPAREN )
					{
					match(input,CONTAINS,FOLLOW_CONTAINS_in_boolean_expression881); if (state.failed) return ret;
					// PhoenixBsonExpression.g:242:22: ( LPAREN l= value_expression COMMA r= value_expression RPAREN )
					// PhoenixBsonExpression.g:242:24: LPAREN l= value_expression COMMA r= value_expression RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression885); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_boolean_expression889);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,COMMA,FOLLOW_COMMA_in_boolean_expression891); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_boolean_expression895);
					r=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression897); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.documentFieldContains(l, r); }
					}

					}
					break;
				case 6 :
					// PhoenixBsonExpression.g:244:13: ( FIELD_TYPE | ATTR_TYPE ) ( LPAREN l= value_expression COMMA r= value_expression RPAREN )
					{
					if ( input.LA(1)==ATTR_TYPE||input.LA(1)==FIELD_TYPE ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// PhoenixBsonExpression.g:244:38: ( LPAREN l= value_expression COMMA r= value_expression RPAREN )
					// PhoenixBsonExpression.g:244:40: LPAREN l= value_expression COMMA r= value_expression RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression941); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_boolean_expression945);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,COMMA,FOLLOW_COMMA_in_boolean_expression947); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_boolean_expression951);
					r=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression953); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.documentFieldType(l, r); }
					}

					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "boolean_expression"



	// $ANTLR start "value_expression"
	// PhoenixBsonExpression.g:248:1: value_expression returns [ParseNode ret] : e= term ;
	public final ParseNode value_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;

		try {
			// PhoenixBsonExpression.g:249:5: (e= term )
			// PhoenixBsonExpression.g:249:9: e= term
			{
			pushFollow(FOLLOW_term_in_value_expression998);
			e=term();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = e; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression"



	// $ANTLR start "term"
	// PhoenixBsonExpression.g:252:1: term returns [ParseNode ret] : (e= literal_or_bind | SIZE LPAREN t= literal RPAREN | LPAREN l= one_or_more_expressions RPAREN );
	public final ParseNode term() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;
		LiteralParseNode t =null;
		List<ParseNode> l =null;

		try {
			// PhoenixBsonExpression.g:253:5: (e= literal_or_bind | SIZE LPAREN t= literal RPAREN | LPAREN l= one_or_more_expressions RPAREN )
			int alt12=3;
			switch ( input.LA(1) ) {
			case BIND_VALUE:
			case DECIMAL:
			case DOCUMENT_FIELD:
			case DOUBLE:
			case FALSE:
			case HASH_DOCUMENT_FIELD:
			case NULL:
			case POSINTEGER:
			case STRING_LITERAL:
			case TRUE:
				{
				alt12=1;
				}
				break;
			case SIZE:
				{
				alt12=2;
				}
				break;
			case LPAREN:
				{
				alt12=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}
			switch (alt12) {
				case 1 :
					// PhoenixBsonExpression.g:253:9: e= literal_or_bind
					{
					pushFollow(FOLLOW_literal_or_bind_in_term1026);
					e=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:254:9: SIZE LPAREN t= literal RPAREN
					{
					match(input,SIZE,FOLLOW_SIZE_in_term1038); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term1040); if (state.failed) return ret;
					pushFollow(FOLLOW_literal_in_term1044);
					t=literal();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term1046); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.documentFieldSize(t); }
					}
					break;
				case 3 :
					// PhoenixBsonExpression.g:255:9: LPAREN l= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_term1058); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term1062);
					l=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term1064); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					    		if(l.size() == 1) {
					    			ret = l.get(0);
					    		}
					    		else {
					    			ret = factory.rowValueConstructor(l);
					    		}
					    	}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "term"



	// $ANTLR start "one_or_more_expressions"
	// PhoenixBsonExpression.g:266:1: one_or_more_expressions returns [List<ParseNode> ret] : e= expression ( COMMA e= expression )* ;
	public final List<ParseNode> one_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixBsonExpression.g:268:5: (e= expression ( COMMA e= expression )* )
			// PhoenixBsonExpression.g:268:8: e= expression ( COMMA e= expression )*
			{
			pushFollow(FOLLOW_expression_in_one_or_more_expressions1101);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixBsonExpression.g:268:39: ( COMMA e= expression )*
			loop13:
			while (true) {
				int alt13=2;
				int LA13_0 = input.LA(1);
				if ( (LA13_0==COMMA) ) {
					alt13=1;
				}

				switch (alt13) {
				case 1 :
					// PhoenixBsonExpression.g:268:40: COMMA e= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_expressions1107); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_one_or_more_expressions1113);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop13;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_expressions"



	// $ANTLR start "zero_or_more_expressions"
	// PhoenixBsonExpression.g:271:1: zero_or_more_expressions returns [List<ParseNode> ret] : (v= expression )? ( COMMA v= expression )* ;
	public final List<ParseNode> zero_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode v =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixBsonExpression.g:273:5: ( (v= expression )? ( COMMA v= expression )* )
			// PhoenixBsonExpression.g:273:8: (v= expression )? ( COMMA v= expression )*
			{
			// PhoenixBsonExpression.g:273:8: (v= expression )?
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( ((LA14_0 >= ATTR && LA14_0 <= BEGINS_WITH)||LA14_0==BIND_VALUE||(LA14_0 >= CONTAINS && LA14_0 <= DECIMAL)||LA14_0==DOCUMENT_FIELD||LA14_0==DOUBLE||(LA14_0 >= FALSE && LA14_0 <= FIELD_TYPE)||LA14_0==HASH_DOCUMENT_FIELD||LA14_0==LPAREN||(LA14_0 >= NOT && LA14_0 <= NULL)||LA14_0==POSINTEGER||(LA14_0 >= SIZE && LA14_0 <= STRING_LITERAL)||LA14_0==TRUE) ) {
				alt14=1;
			}
			switch (alt14) {
				case 1 :
					// PhoenixBsonExpression.g:273:9: v= expression
					{
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions1145);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

			}

			// PhoenixBsonExpression.g:273:42: ( COMMA v= expression )*
			loop15:
			while (true) {
				int alt15=2;
				int LA15_0 = input.LA(1);
				if ( (LA15_0==COMMA) ) {
					alt15=1;
				}

				switch (alt15) {
				case 1 :
					// PhoenixBsonExpression.g:273:43: COMMA v= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_expressions1153); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions1159);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop15;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_expressions"



	// $ANTLR start "value_expression_list"
	// PhoenixBsonExpression.g:276:1: value_expression_list returns [List<ParseNode> ret] : LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN ;
	public final List<ParseNode> value_expression_list() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixBsonExpression.g:278:5: ( LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN )
			// PhoenixBsonExpression.g:278:8: LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_value_expression_list1186); if (state.failed) return ret;
			pushFollow(FOLLOW_value_expression_in_value_expression_list1192);
			e=value_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixBsonExpression.g:278:52: ( COMMA e= value_expression )*
			loop16:
			while (true) {
				int alt16=2;
				int LA16_0 = input.LA(1);
				if ( (LA16_0==COMMA) ) {
					alt16=1;
				}

				switch (alt16) {
				case 1 :
					// PhoenixBsonExpression.g:278:53: COMMA e= value_expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_value_expression_list1198); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_value_expression_list1204);
					e=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop16;
				}
			}

			match(input,RPAREN,FOLLOW_RPAREN_in_value_expression_list1211); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression_list"



	// $ANTLR start "literal_or_bind"
	// PhoenixBsonExpression.g:281:1: literal_or_bind returns [ParseNode ret] : e= literal ;
	public final ParseNode literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode e =null;

		try {
			// PhoenixBsonExpression.g:282:5: (e= literal )
			// PhoenixBsonExpression.g:282:9: e= literal
			{
			pushFollow(FOLLOW_literal_in_literal_or_bind1232);
			e=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = e; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal_or_bind"



	// $ANTLR start "literal"
	// PhoenixBsonExpression.g:285:1: literal returns [LiteralParseNode ret] : (f= BIND_VALUE |i= DOCUMENT_FIELD |j= HASH_DOCUMENT_FIELD |s= STRING_LITERAL |n= POSINTEGER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE );
	public final LiteralParseNode literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token f=null;
		Token i=null;
		Token j=null;
		Token s=null;
		Token n=null;
		Token d=null;
		Token dbl=null;

		try {
			// PhoenixBsonExpression.g:286:5: (f= BIND_VALUE |i= DOCUMENT_FIELD |j= HASH_DOCUMENT_FIELD |s= STRING_LITERAL |n= POSINTEGER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE )
			int alt17=10;
			switch ( input.LA(1) ) {
			case BIND_VALUE:
				{
				alt17=1;
				}
				break;
			case DOCUMENT_FIELD:
				{
				alt17=2;
				}
				break;
			case HASH_DOCUMENT_FIELD:
				{
				alt17=3;
				}
				break;
			case STRING_LITERAL:
				{
				alt17=4;
				}
				break;
			case POSINTEGER:
				{
				alt17=5;
				}
				break;
			case DECIMAL:
				{
				alt17=6;
				}
				break;
			case DOUBLE:
				{
				alt17=7;
				}
				break;
			case NULL:
				{
				alt17=8;
				}
				break;
			case TRUE:
				{
				alt17=9;
				}
				break;
			case FALSE:
				{
				alt17=10;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}
			switch (alt17) {
				case 1 :
					// PhoenixBsonExpression.g:287:9: f= BIND_VALUE
					{
					f=(Token)match(input,BIND_VALUE,FOLLOW_BIND_VALUE_in_literal1265); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(f.getText());
					        }
					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:290:9: i= DOCUMENT_FIELD
					{
					i=(Token)match(input,DOCUMENT_FIELD,FOLLOW_DOCUMENT_FIELD_in_literal1279); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(i.getText());
					        }
					}
					break;
				case 3 :
					// PhoenixBsonExpression.g:293:9: j= HASH_DOCUMENT_FIELD
					{
					j=(Token)match(input,HASH_DOCUMENT_FIELD,FOLLOW_HASH_DOCUMENT_FIELD_in_literal1293); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(j.getText());
					        }
					}
					break;
				case 4 :
					// PhoenixBsonExpression.g:296:9: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal1307); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(s.getText());
					        }
					}
					break;
				case 5 :
					// PhoenixBsonExpression.g:299:9: n= POSINTEGER
					{
					n=(Token)match(input,POSINTEGER,FOLLOW_POSINTEGER_in_literal1321); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.wholeNumber(n.getText());
					        }
					}
					break;
				case 6 :
					// PhoenixBsonExpression.g:302:9: d= DECIMAL
					{
					d=(Token)match(input,DECIMAL,FOLLOW_DECIMAL_in_literal1335); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.realNumber(d.getText());
					        }
					}
					break;
				case 7 :
					// PhoenixBsonExpression.g:305:9: dbl= DOUBLE
					{
					dbl=(Token)match(input,DOUBLE,FOLLOW_DOUBLE_in_literal1350); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(Double.valueOf(dbl.getText()));
					        }
					}
					break;
				case 8 :
					// PhoenixBsonExpression.g:308:9: NULL
					{
					match(input,NULL,FOLLOW_NULL_in_literal1363); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(null);}
					}
					break;
				case 9 :
					// PhoenixBsonExpression.g:309:9: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_literal1375); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.TRUE);}
					}
					break;
				case 10 :
					// PhoenixBsonExpression.g:310:9: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_literal1387); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.FALSE);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal"

	// $ANTLR start synpred1_PhoenixBsonExpression
	public final void synpred1_PhoenixBsonExpression_fragment() throws RecognitionException {
		// PhoenixBsonExpression.g:217:9: ( ( NOT )? boolean_expression )
		// PhoenixBsonExpression.g:217:10: ( NOT )? boolean_expression
		{
		// PhoenixBsonExpression.g:217:10: ( NOT )?
		int alt18=2;
		int LA18_0 = input.LA(1);
		if ( (LA18_0==NOT) ) {
			alt18=1;
		}
		switch (alt18) {
			case 1 :
				// PhoenixBsonExpression.g:217:10: NOT
				{
				match(input,NOT,FOLLOW_NOT_in_synpred1_PhoenixBsonExpression395); if (state.failed) return;
				}
				break;

		}

		pushFollow(FOLLOW_boolean_expression_in_synpred1_PhoenixBsonExpression398);
		boolean_expression();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred1_PhoenixBsonExpression

	// Delegated rules

	public final boolean synpred1_PhoenixBsonExpression() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_PhoenixBsonExpression_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}



	public static final BitSet FOLLOW_STRING_LITERAL_in_string_literal254 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_or_expression_in_expression281 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_and_expression_in_or_expression312 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_OR_in_or_expression317 = new BitSet(new long[]{0x5823042782981780L});
	public static final BitSet FOLLOW_and_expression_in_or_expression321 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_not_expression_in_and_expression356 = new BitSet(new long[]{0x0000000000000012L});
	public static final BitSet FOLLOW_AND_in_and_expression361 = new BitSet(new long[]{0x5823042782981780L});
	public static final BitSet FOLLOW_not_expression_in_and_expression365 = new BitSet(new long[]{0x0000000000000012L});
	public static final BitSet FOLLOW_NOT_in_not_expression406 = new BitSet(new long[]{0x5822042782981780L});
	public static final BitSet FOLLOW_boolean_expression_in_not_expression411 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_not_expression425 = new BitSet(new long[]{0x0000040000000000L});
	public static final BitSet FOLLOW_LPAREN_in_not_expression428 = new BitSet(new long[]{0x5823042782981780L});
	public static final BitSet FOLLOW_expression_in_not_expression432 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_not_expression434 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQ_in_comparison_op454 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op461 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op468 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op475 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op477 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op484 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op486 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_comparison_op493 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression523 = new BitSet(new long[]{0x0001D0C820000802L});
	public static final BitSet FOLLOW_comparison_op_in_boolean_expression529 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression534 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_boolean_expression563 = new BitSet(new long[]{0x0003000000000000L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression567 = new BitSet(new long[]{0x0002000000000000L});
	public static final BitSet FOLLOW_NULL_in_boolean_expression570 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression601 = new BitSet(new long[]{0x0000004000000800L});
	public static final BitSet FOLLOW_BETWEEN_in_boolean_expression638 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression642 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_AND_in_boolean_expression644 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression648 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_boolean_expression686 = new BitSet(new long[]{0x0000040000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression689 = new BitSet(new long[]{0x5823042782981780L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_boolean_expression693 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression695 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_boolean_expression763 = new BitSet(new long[]{0x0000040000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression773 = new BitSet(new long[]{0x5022002082901000L});
	public static final BitSet FOLLOW_literal_in_boolean_expression777 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression779 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_boolean_expression797 = new BitSet(new long[]{0x0000040000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression807 = new BitSet(new long[]{0x5022002082901000L});
	public static final BitSet FOLLOW_literal_in_boolean_expression811 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression813 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BEGINS_WITH_in_boolean_expression831 = new BitSet(new long[]{0x0000040000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression835 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression839 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COMMA_in_boolean_expression841 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression845 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression847 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONTAINS_in_boolean_expression881 = new BitSet(new long[]{0x0000040000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression885 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression889 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COMMA_in_boolean_expression891 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression895 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression897 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_boolean_expression931 = new BitSet(new long[]{0x0000040000000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression941 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression945 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COMMA_in_boolean_expression947 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression951 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression953 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_value_expression998 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_or_bind_in_term1026 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SIZE_in_term1038 = new BitSet(new long[]{0x0000040000000000L});
	public static final BitSet FOLLOW_LPAREN_in_term1040 = new BitSet(new long[]{0x5022002082901000L});
	public static final BitSet FOLLOW_literal_in_term1044 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_term1046 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_term1058 = new BitSet(new long[]{0x5823042782981780L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term1062 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_term1064 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions1101 = new BitSet(new long[]{0x0000000000020002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_expressions1107 = new BitSet(new long[]{0x5823042782981780L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions1113 = new BitSet(new long[]{0x0000000000020002L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions1145 = new BitSet(new long[]{0x0000000000020002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_expressions1153 = new BitSet(new long[]{0x5823042782981780L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions1159 = new BitSet(new long[]{0x0000000000020002L});
	public static final BitSet FOLLOW_LPAREN_in_value_expression_list1186 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list1192 = new BitSet(new long[]{0x0100000000020000L});
	public static final BitSet FOLLOW_COMMA_in_value_expression_list1198 = new BitSet(new long[]{0x5822042082901000L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list1204 = new BitSet(new long[]{0x0100000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_value_expression_list1211 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_literal_or_bind1232 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIND_VALUE_in_literal1265 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOCUMENT_FIELD_in_literal1279 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_DOCUMENT_FIELD_in_literal1293 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal1307 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_POSINTEGER_in_literal1321 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_literal1335 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_literal1350 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NULL_in_literal1363 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_literal1375 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_literal1387 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_synpred1_PhoenixBsonExpression395 = new BitSet(new long[]{0x5822042782981780L});
	public static final BitSet FOLLOW_boolean_expression_in_synpred1_PhoenixBsonExpression398 = new BitSet(new long[]{0x0000000000000002L});
}
