// $ANTLR 3.5.2 PhoenixBsonExpression.g 2025-10-07 16:50:46

/**
 * Copyright 2010 The Apache Software Foundation
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.parse;
///CLOVER:OFF


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class PhoenixBsonExpressionLexer extends Lexer {
	public static final int EOF=-1;
	public static final int AND=4;
	public static final int ASTERISK=5;
	public static final int AT=6;
	public static final int ATTR=7;
	public static final int ATTR_NOT=8;
	public static final int ATTR_TYPE=9;
	public static final int BEGINS_WITH=10;
	public static final int BETWEEN=11;
	public static final int BIND_VALUE=12;
	public static final int BIND_VALUE_CHARS=13;
	public static final int CHAR=14;
	public static final int CHAR_ESC=15;
	public static final int COLON=16;
	public static final int COMMA=17;
	public static final int CONCAT=18;
	public static final int CONTAINS=19;
	public static final int DECIMAL=20;
	public static final int DIGIT=21;
	public static final int DIVIDE=22;
	public static final int DOCUMENT_FIELD=23;
	public static final int DOT=24;
	public static final int DOUBLE=25;
	public static final int DOUBLE_EQ=26;
	public static final int DOUBLE_QUOTE=27;
	public static final int EOL=28;
	public static final int EQ=29;
	public static final int Exponent=30;
	public static final int FALSE=31;
	public static final int FIELD=32;
	public static final int FIELD_NOT=33;
	public static final int FIELD_TYPE=34;
	public static final int GT=35;
	public static final int HASH=36;
	public static final int HASH_DOCUMENT_FIELD=37;
	public static final int IN=38;
	public static final int IS=39;
	public static final int LCURLY=40;
	public static final int LETTER=41;
	public static final int LPAREN=42;
	public static final int LSQUARE=43;
	public static final int LT=44;
	public static final int MINUS=45;
	public static final int NOEQ1=46;
	public static final int NOEQ2=47;
	public static final int NOT=48;
	public static final int NULL=49;
	public static final int OR=50;
	public static final int PERCENT=51;
	public static final int PLUS=52;
	public static final int POSINTEGER=53;
	public static final int QUESTION=54;
	public static final int RCURLY=55;
	public static final int RPAREN=56;
	public static final int RSQUARE=57;
	public static final int SEMICOLON=58;
	public static final int SIZE=59;
	public static final int STRING_LITERAL=60;
	public static final int TILDE=61;
	public static final int TRUE=62;
	public static final int UNDERSCORE=63;
	public static final int WS=64;




	// delegates
	// delegators
	public Lexer[] getDelegates() {
		return new Lexer[] {};
	}

	public PhoenixBsonExpressionLexer() {} 
	public PhoenixBsonExpressionLexer(CharStream input) {
		this(input, new RecognizerSharedState());
	}
	public PhoenixBsonExpressionLexer(CharStream input, RecognizerSharedState state) {
		super(input,state);
	}
	@Override public String getGrammarFileName() { return "PhoenixBsonExpression.g"; }

	// $ANTLR start "AND"
	public final void mAND() throws RecognitionException {
		try {
			int _type = AND;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:29:5: ( 'and' )
			// PhoenixBsonExpression.g:29:7: 'and'
			{
			match("and"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "AND"

	// $ANTLR start "ATTR"
	public final void mATTR() throws RecognitionException {
		try {
			int _type = ATTR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:30:6: ( 'attribute_exists' )
			// PhoenixBsonExpression.g:30:8: 'attribute_exists'
			{
			match("attribute_exists"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ATTR"

	// $ANTLR start "ATTR_NOT"
	public final void mATTR_NOT() throws RecognitionException {
		try {
			int _type = ATTR_NOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:31:10: ( 'attribute_not_exists' )
			// PhoenixBsonExpression.g:31:12: 'attribute_not_exists'
			{
			match("attribute_not_exists"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ATTR_NOT"

	// $ANTLR start "ATTR_TYPE"
	public final void mATTR_TYPE() throws RecognitionException {
		try {
			int _type = ATTR_TYPE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:32:11: ( 'attribute_type' )
			// PhoenixBsonExpression.g:32:13: 'attribute_type'
			{
			match("attribute_type"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ATTR_TYPE"

	// $ANTLR start "BEGINS_WITH"
	public final void mBEGINS_WITH() throws RecognitionException {
		try {
			int _type = BEGINS_WITH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:33:13: ( 'begins_with' )
			// PhoenixBsonExpression.g:33:15: 'begins_with'
			{
			match("begins_with"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "BEGINS_WITH"

	// $ANTLR start "BETWEEN"
	public final void mBETWEEN() throws RecognitionException {
		try {
			int _type = BETWEEN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:34:9: ( 'between' )
			// PhoenixBsonExpression.g:34:11: 'between'
			{
			match("between"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "BETWEEN"

	// $ANTLR start "CONTAINS"
	public final void mCONTAINS() throws RecognitionException {
		try {
			int _type = CONTAINS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:35:10: ( 'contains' )
			// PhoenixBsonExpression.g:35:12: 'contains'
			{
			match("contains"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CONTAINS"

	// $ANTLR start "FALSE"
	public final void mFALSE() throws RecognitionException {
		try {
			int _type = FALSE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:36:7: ( 'false' )
			// PhoenixBsonExpression.g:36:9: 'false'
			{
			match("false"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FALSE"

	// $ANTLR start "FIELD"
	public final void mFIELD() throws RecognitionException {
		try {
			int _type = FIELD;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:37:7: ( 'field_exists' )
			// PhoenixBsonExpression.g:37:9: 'field_exists'
			{
			match("field_exists"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FIELD"

	// $ANTLR start "FIELD_NOT"
	public final void mFIELD_NOT() throws RecognitionException {
		try {
			int _type = FIELD_NOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:38:11: ( 'field_not_exists' )
			// PhoenixBsonExpression.g:38:13: 'field_not_exists'
			{
			match("field_not_exists"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FIELD_NOT"

	// $ANTLR start "FIELD_TYPE"
	public final void mFIELD_TYPE() throws RecognitionException {
		try {
			int _type = FIELD_TYPE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:39:12: ( 'field_type' )
			// PhoenixBsonExpression.g:39:14: 'field_type'
			{
			match("field_type"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FIELD_TYPE"

	// $ANTLR start "IN"
	public final void mIN() throws RecognitionException {
		try {
			int _type = IN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:40:4: ( 'in' )
			// PhoenixBsonExpression.g:40:6: 'in'
			{
			match("in"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IN"

	// $ANTLR start "IS"
	public final void mIS() throws RecognitionException {
		try {
			int _type = IS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:41:4: ( 'is' )
			// PhoenixBsonExpression.g:41:6: 'is'
			{
			match("is"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IS"

	// $ANTLR start "NOT"
	public final void mNOT() throws RecognitionException {
		try {
			int _type = NOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:42:5: ( 'not' )
			// PhoenixBsonExpression.g:42:7: 'not'
			{
			match("not"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NOT"

	// $ANTLR start "NULL"
	public final void mNULL() throws RecognitionException {
		try {
			int _type = NULL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:43:6: ( 'null' )
			// PhoenixBsonExpression.g:43:8: 'null'
			{
			match("null"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NULL"

	// $ANTLR start "OR"
	public final void mOR() throws RecognitionException {
		try {
			int _type = OR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:44:4: ( 'or' )
			// PhoenixBsonExpression.g:44:6: 'or'
			{
			match("or"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OR"

	// $ANTLR start "SIZE"
	public final void mSIZE() throws RecognitionException {
		try {
			int _type = SIZE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:45:6: ( 'size' )
			// PhoenixBsonExpression.g:45:8: 'size'
			{
			match("size"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SIZE"

	// $ANTLR start "TRUE"
	public final void mTRUE() throws RecognitionException {
		try {
			int _type = TRUE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:46:6: ( 'true' )
			// PhoenixBsonExpression.g:46:8: 'true'
			{
			match("true"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TRUE"

	// $ANTLR start "DECIMAL"
	public final void mDECIMAL() throws RecognitionException {
		try {
			int _type = DECIMAL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:317:2: ( ( POSINTEGER )? '.' POSINTEGER )
			// PhoenixBsonExpression.g:317:4: ( POSINTEGER )? '.' POSINTEGER
			{
			// PhoenixBsonExpression.g:317:4: ( POSINTEGER )?
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( ((LA1_0 >= '0' && LA1_0 <= '9')) ) {
				alt1=1;
			}
			switch (alt1) {
				case 1 :
					// PhoenixBsonExpression.g:317:4: POSINTEGER
					{
					mPOSINTEGER(); 

					}
					break;

			}

			match('.'); 
			mPOSINTEGER(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DECIMAL"

	// $ANTLR start "DOUBLE"
	public final void mDOUBLE() throws RecognitionException {
		try {
			int _type = DOUBLE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:321:5: ( '.' POSINTEGER Exponent | POSINTEGER '.' Exponent | POSINTEGER ( '.' ( POSINTEGER ( Exponent )? )? | Exponent ) )
			int alt5=3;
			alt5 = dfa5.predict(input);
			switch (alt5) {
				case 1 :
					// PhoenixBsonExpression.g:321:9: '.' POSINTEGER Exponent
					{
					match('.'); 
					mPOSINTEGER(); 

					mExponent(); 

					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:322:9: POSINTEGER '.' Exponent
					{
					mPOSINTEGER(); 

					match('.'); 
					mExponent(); 

					}
					break;
				case 3 :
					// PhoenixBsonExpression.g:323:9: POSINTEGER ( '.' ( POSINTEGER ( Exponent )? )? | Exponent )
					{
					mPOSINTEGER(); 

					// PhoenixBsonExpression.g:323:20: ( '.' ( POSINTEGER ( Exponent )? )? | Exponent )
					int alt4=2;
					int LA4_0 = input.LA(1);
					if ( (LA4_0=='.') ) {
						alt4=1;
					}
					else if ( (LA4_0=='E'||LA4_0=='e') ) {
						alt4=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 4, 0, input);
						throw nvae;
					}

					switch (alt4) {
						case 1 :
							// PhoenixBsonExpression.g:323:21: '.' ( POSINTEGER ( Exponent )? )?
							{
							match('.'); 
							// PhoenixBsonExpression.g:323:25: ( POSINTEGER ( Exponent )? )?
							int alt3=2;
							int LA3_0 = input.LA(1);
							if ( ((LA3_0 >= '0' && LA3_0 <= '9')) ) {
								alt3=1;
							}
							switch (alt3) {
								case 1 :
									// PhoenixBsonExpression.g:323:26: POSINTEGER ( Exponent )?
									{
									mPOSINTEGER(); 

									// PhoenixBsonExpression.g:323:37: ( Exponent )?
									int alt2=2;
									int LA2_0 = input.LA(1);
									if ( (LA2_0=='E'||LA2_0=='e') ) {
										alt2=1;
									}
									switch (alt2) {
										case 1 :
											// PhoenixBsonExpression.g:323:38: Exponent
											{
											mExponent(); 

											}
											break;

									}

									}
									break;

							}

							}
							break;
						case 2 :
							// PhoenixBsonExpression.g:323:53: Exponent
							{
							mExponent(); 

							}
							break;

					}

					}
					break;

			}
			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOUBLE"

	// $ANTLR start "Exponent"
	public final void mExponent() throws RecognitionException {
		try {
			int _type = Exponent;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:327:5: ( ( 'e' | 'E' ) ( PLUS | MINUS )? POSINTEGER )
			// PhoenixBsonExpression.g:327:10: ( 'e' | 'E' ) ( PLUS | MINUS )? POSINTEGER
			{
			if ( input.LA(1)=='E'||input.LA(1)=='e' ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			// PhoenixBsonExpression.g:327:22: ( PLUS | MINUS )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0=='+'||LA6_0=='-') ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// PhoenixBsonExpression.g:
					{
					if ( input.LA(1)=='+'||input.LA(1)=='-' ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

			}

			mPOSINTEGER(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "Exponent"

	// $ANTLR start "DOUBLE_QUOTE"
	public final void mDOUBLE_QUOTE() throws RecognitionException {
		try {
			int _type = DOUBLE_QUOTE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:331:5: ( '\"' )
			// PhoenixBsonExpression.g:331:9: '\"'
			{
			match('\"'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOUBLE_QUOTE"

	// $ANTLR start "EQ"
	public final void mEQ() throws RecognitionException {
		try {
			int _type = EQ;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:335:5: ( '=' )
			// PhoenixBsonExpression.g:335:9: '='
			{
			match('='); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EQ"

	// $ANTLR start "LT"
	public final void mLT() throws RecognitionException {
		try {
			int _type = LT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:339:5: ( '<' )
			// PhoenixBsonExpression.g:339:9: '<'
			{
			match('<'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LT"

	// $ANTLR start "GT"
	public final void mGT() throws RecognitionException {
		try {
			int _type = GT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:343:5: ( '>' )
			// PhoenixBsonExpression.g:343:9: '>'
			{
			match('>'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "GT"

	// $ANTLR start "DOUBLE_EQ"
	public final void mDOUBLE_EQ() throws RecognitionException {
		try {
			int _type = DOUBLE_EQ;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:347:5: ( '=' '=' )
			// PhoenixBsonExpression.g:347:9: '=' '='
			{
			match('='); 
			match('='); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOUBLE_EQ"

	// $ANTLR start "NOEQ1"
	public final void mNOEQ1() throws RecognitionException {
		try {
			int _type = NOEQ1;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:351:5: ( '!' '=' )
			// PhoenixBsonExpression.g:351:9: '!' '='
			{
			match('!'); 
			match('='); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NOEQ1"

	// $ANTLR start "NOEQ2"
	public final void mNOEQ2() throws RecognitionException {
		try {
			int _type = NOEQ2;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:355:5: ( '<' '>' )
			// PhoenixBsonExpression.g:355:9: '<' '>'
			{
			match('<'); 
			match('>'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NOEQ2"

	// $ANTLR start "CONCAT"
	public final void mCONCAT() throws RecognitionException {
		try {
			int _type = CONCAT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:359:5: ( '|' '|' )
			// PhoenixBsonExpression.g:359:9: '|' '|'
			{
			match('|'); 
			match('|'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CONCAT"

	// $ANTLR start "COMMA"
	public final void mCOMMA() throws RecognitionException {
		try {
			int _type = COMMA;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:363:5: ( ',' )
			// PhoenixBsonExpression.g:363:9: ','
			{
			match(','); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COMMA"

	// $ANTLR start "LPAREN"
	public final void mLPAREN() throws RecognitionException {
		try {
			int _type = LPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:367:5: ( '(' )
			// PhoenixBsonExpression.g:367:9: '('
			{
			match('('); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LPAREN"

	// $ANTLR start "RPAREN"
	public final void mRPAREN() throws RecognitionException {
		try {
			int _type = RPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:371:5: ( ')' )
			// PhoenixBsonExpression.g:371:9: ')'
			{
			match(')'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RPAREN"

	// $ANTLR start "SEMICOLON"
	public final void mSEMICOLON() throws RecognitionException {
		try {
			int _type = SEMICOLON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:375:5: ( ';' )
			// PhoenixBsonExpression.g:375:9: ';'
			{
			match(';'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SEMICOLON"

	// $ANTLR start "COLON"
	public final void mCOLON() throws RecognitionException {
		try {
			int _type = COLON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:379:5: ( ':' )
			// PhoenixBsonExpression.g:379:9: ':'
			{
			match(':'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COLON"

	// $ANTLR start "QUESTION"
	public final void mQUESTION() throws RecognitionException {
		try {
			int _type = QUESTION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:383:5: ( '?' )
			// PhoenixBsonExpression.g:383:9: '?'
			{
			match('?'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "QUESTION"

	// $ANTLR start "LSQUARE"
	public final void mLSQUARE() throws RecognitionException {
		try {
			int _type = LSQUARE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:387:5: ( '[' )
			// PhoenixBsonExpression.g:387:9: '['
			{
			match('['); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LSQUARE"

	// $ANTLR start "RSQUARE"
	public final void mRSQUARE() throws RecognitionException {
		try {
			int _type = RSQUARE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:391:5: ( ']' )
			// PhoenixBsonExpression.g:391:9: ']'
			{
			match(']'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RSQUARE"

	// $ANTLR start "LCURLY"
	public final void mLCURLY() throws RecognitionException {
		try {
			int _type = LCURLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:395:5: ( '{' )
			// PhoenixBsonExpression.g:395:9: '{'
			{
			match('{'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LCURLY"

	// $ANTLR start "RCURLY"
	public final void mRCURLY() throws RecognitionException {
		try {
			int _type = RCURLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:399:5: ( '}' )
			// PhoenixBsonExpression.g:399:9: '}'
			{
			match('}'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RCURLY"

	// $ANTLR start "AT"
	public final void mAT() throws RecognitionException {
		try {
			int _type = AT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:403:5: ( '@' )
			// PhoenixBsonExpression.g:403:9: '@'
			{
			match('@'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "AT"

	// $ANTLR start "TILDE"
	public final void mTILDE() throws RecognitionException {
		try {
			int _type = TILDE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:407:5: ( '~' )
			// PhoenixBsonExpression.g:407:9: '~'
			{
			match('~'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TILDE"

	// $ANTLR start "PLUS"
	public final void mPLUS() throws RecognitionException {
		try {
			int _type = PLUS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:411:5: ( '+' )
			// PhoenixBsonExpression.g:411:9: '+'
			{
			match('+'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PLUS"

	// $ANTLR start "MINUS"
	public final void mMINUS() throws RecognitionException {
		try {
			int _type = MINUS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:415:5: ( '-' )
			// PhoenixBsonExpression.g:415:9: '-'
			{
			match('-'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MINUS"

	// $ANTLR start "ASTERISK"
	public final void mASTERISK() throws RecognitionException {
		try {
			int _type = ASTERISK;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:419:5: ( '*' )
			// PhoenixBsonExpression.g:419:9: '*'
			{
			match('*'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ASTERISK"

	// $ANTLR start "DIVIDE"
	public final void mDIVIDE() throws RecognitionException {
		try {
			int _type = DIVIDE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:423:5: ( '/' )
			// PhoenixBsonExpression.g:423:9: '/'
			{
			match('/'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DIVIDE"

	// $ANTLR start "DOT"
	public final void mDOT() throws RecognitionException {
		try {
			int _type = DOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:427:5: ( '.' )
			// PhoenixBsonExpression.g:427:9: '.'
			{
			match('.'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOT"

	// $ANTLR start "PERCENT"
	public final void mPERCENT() throws RecognitionException {
		try {
			int _type = PERCENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:431:5: ( '%' )
			// PhoenixBsonExpression.g:431:9: '%'
			{
			match('%'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PERCENT"

	// $ANTLR start "UNDERSCORE"
	public final void mUNDERSCORE() throws RecognitionException {
		try {
			int _type = UNDERSCORE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:435:5: ( '_' )
			// PhoenixBsonExpression.g:435:9: '_'
			{
			match('_'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UNDERSCORE"

	// $ANTLR start "HASH"
	public final void mHASH() throws RecognitionException {
		try {
			int _type = HASH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:439:5: ( '#' )
			// PhoenixBsonExpression.g:439:9: '#'
			{
			match('#'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "HASH"

	// $ANTLR start "BIND_VALUE"
	public final void mBIND_VALUE() throws RecognitionException {
		try {
			int _type = BIND_VALUE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken t=null;

			 StringBuilder sb = new StringBuilder(); 
			// PhoenixBsonExpression.g:445:5: ( ( COLON | '$' ) (t= BIND_VALUE_CHARS )+ )
			// PhoenixBsonExpression.g:445:9: ( COLON | '$' ) (t= BIND_VALUE_CHARS )+
			{
			// PhoenixBsonExpression.g:445:9: ( COLON | '$' )
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==':') ) {
				alt7=1;
			}
			else if ( (LA7_0=='$') ) {
				alt7=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 7, 0, input);
				throw nvae;
			}

			switch (alt7) {
				case 1 :
					// PhoenixBsonExpression.g:445:11: COLON
					{
					mCOLON(); 

					 sb.append(":"); 
					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:445:39: '$'
					{
					match('$'); 
					 sb.append("$"); 
					}
					break;

			}

			// PhoenixBsonExpression.g:446:5: (t= BIND_VALUE_CHARS )+
			int cnt8=0;
			loop8:
			while (true) {
				int alt8=2;
				int LA8_0 = input.LA(1);
				if ( (LA8_0=='-'||(LA8_0 >= '0' && LA8_0 <= '9')||(LA8_0 >= 'A' && LA8_0 <= 'Z')||LA8_0=='_'||(LA8_0 >= 'a' && LA8_0 <= 'z')) ) {
					alt8=1;
				}

				switch (alt8) {
				case 1 :
					// PhoenixBsonExpression.g:446:7: t= BIND_VALUE_CHARS
					{
					int tStart825 = getCharIndex();
					int tStartLine825 = getLine();
					int tStartCharPos825 = getCharPositionInLine();
					mBIND_VALUE_CHARS(); 
					t = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, tStart825, getCharIndex()-1);
					t.setLine(tStartLine825);
					t.setCharPositionInLine(tStartCharPos825);

					 sb.append(t.getText()); 
					}
					break;

				default :
					if ( cnt8 >= 1 ) break loop8;
					EarlyExitException eee = new EarlyExitException(8, input);
					throw eee;
				}
				cnt8++;
			}

			 setText(sb.toString()); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "BIND_VALUE"

	// $ANTLR start "HASH_DOCUMENT_FIELD"
	public final void mHASH_DOCUMENT_FIELD() throws RecognitionException {
		try {
			int _type = HASH_DOCUMENT_FIELD;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken a=null;
			CommonToken h=null;
			CommonToken t=null;

			 StringBuilder sb = new StringBuilder(); 
			// PhoenixBsonExpression.g:452:5: ( (a= HASH ) (h= HASH |t= DOCUMENT_FIELD )+ )
			// PhoenixBsonExpression.g:452:9: (a= HASH ) (h= HASH |t= DOCUMENT_FIELD )+
			{
			// PhoenixBsonExpression.g:452:9: (a= HASH )
			// PhoenixBsonExpression.g:452:11: a= HASH
			{
			int aStart862 = getCharIndex();
			int aStartLine862 = getLine();
			int aStartCharPos862 = getCharPositionInLine();
			mHASH(); 
			a = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, aStart862, getCharIndex()-1);
			a.setLine(aStartLine862);
			a.setCharPositionInLine(aStartCharPos862);

			 sb.append(a.getText()); 
			}

			// PhoenixBsonExpression.g:453:9: (h= HASH |t= DOCUMENT_FIELD )+
			int cnt9=0;
			loop9:
			while (true) {
				int alt9=3;
				int LA9_0 = input.LA(1);
				if ( (LA9_0=='#') ) {
					alt9=1;
				}
				else if ( ((LA9_0 >= '-' && LA9_0 <= '.')||(LA9_0 >= '0' && LA9_0 <= '9')||(LA9_0 >= 'A' && LA9_0 <= '[')||LA9_0==']'||LA9_0=='_'||(LA9_0 >= 'a' && LA9_0 <= 'z')) ) {
					alt9=2;
				}

				switch (alt9) {
				case 1 :
					// PhoenixBsonExpression.g:453:11: h= HASH
					{
					int hStart880 = getCharIndex();
					int hStartLine880 = getLine();
					int hStartCharPos880 = getCharPositionInLine();
					mHASH(); 
					h = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, hStart880, getCharIndex()-1);
					h.setLine(hStartLine880);
					h.setCharPositionInLine(hStartCharPos880);

					 sb.append(h.getText()); 
					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:454:11: t= DOCUMENT_FIELD
					{
					int tStart896 = getCharIndex();
					int tStartLine896 = getLine();
					int tStartCharPos896 = getCharPositionInLine();
					mDOCUMENT_FIELD(); 
					t = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, tStart896, getCharIndex()-1);
					t.setLine(tStartLine896);
					t.setCharPositionInLine(tStartCharPos896);

					 sb.append(t.getText()); 
					}
					break;

				default :
					if ( cnt9 >= 1 ) break loop9;
					EarlyExitException eee = new EarlyExitException(9, input);
					throw eee;
				}
				cnt9++;
			}

			 setText(sb.toString()); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "HASH_DOCUMENT_FIELD"

	// $ANTLR start "DOCUMENT_FIELD"
	public final void mDOCUMENT_FIELD() throws RecognitionException {
		try {
			int _type = DOCUMENT_FIELD;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken v1=null;
			CommonToken v2=null;
			CommonToken v3=null;
			CommonToken v4=null;
			CommonToken v5=null;
			CommonToken v6=null;
			CommonToken v8=null;

			 StringBuilder sb = new StringBuilder(); 
			// PhoenixBsonExpression.g:461:5: ( (v1= LETTER |v2= DIGIT |v3= UNDERSCORE |v4= LSQUARE |v5= RSQUARE |v6= DOT |v8= MINUS )+ )
			// PhoenixBsonExpression.g:461:9: (v1= LETTER |v2= DIGIT |v3= UNDERSCORE |v4= LSQUARE |v5= RSQUARE |v6= DOT |v8= MINUS )+
			{
			// PhoenixBsonExpression.g:461:9: (v1= LETTER |v2= DIGIT |v3= UNDERSCORE |v4= LSQUARE |v5= RSQUARE |v6= DOT |v8= MINUS )+
			int cnt10=0;
			loop10:
			while (true) {
				int alt10=8;
				switch ( input.LA(1) ) {
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case 'a':
				case 'b':
				case 'c':
				case 'd':
				case 'e':
				case 'f':
				case 'g':
				case 'h':
				case 'i':
				case 'j':
				case 'k':
				case 'l':
				case 'm':
				case 'n':
				case 'o':
				case 'p':
				case 'q':
				case 'r':
				case 's':
				case 't':
				case 'u':
				case 'v':
				case 'w':
				case 'x':
				case 'y':
				case 'z':
					{
					alt10=1;
					}
					break;
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					{
					alt10=2;
					}
					break;
				case '_':
					{
					alt10=3;
					}
					break;
				case '[':
					{
					alt10=4;
					}
					break;
				case ']':
					{
					alt10=5;
					}
					break;
				case '.':
					{
					alt10=6;
					}
					break;
				case '-':
					{
					alt10=7;
					}
					break;
				}
				switch (alt10) {
				case 1 :
					// PhoenixBsonExpression.g:461:10: v1= LETTER
					{
					int v1Start940 = getCharIndex();
					int v1StartLine940 = getLine();
					int v1StartCharPos940 = getCharPositionInLine();
					mLETTER(); 
					v1 = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, v1Start940, getCharIndex()-1);
					v1.setLine(v1StartLine940);
					v1.setCharPositionInLine(v1StartCharPos940);

					 sb.append(v1.getText()); 
					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:462:11: v2= DIGIT
					{
					int v2Start956 = getCharIndex();
					int v2StartLine956 = getLine();
					int v2StartCharPos956 = getCharPositionInLine();
					mDIGIT(); 
					v2 = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, v2Start956, getCharIndex()-1);
					v2.setLine(v2StartLine956);
					v2.setCharPositionInLine(v2StartCharPos956);

					 sb.append(v2.getText()); 
					}
					break;
				case 3 :
					// PhoenixBsonExpression.g:463:11: v3= UNDERSCORE
					{
					int v3Start972 = getCharIndex();
					int v3StartLine972 = getLine();
					int v3StartCharPos972 = getCharPositionInLine();
					mUNDERSCORE(); 
					v3 = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, v3Start972, getCharIndex()-1);
					v3.setLine(v3StartLine972);
					v3.setCharPositionInLine(v3StartCharPos972);

					 sb.append(v3.getText()); 
					}
					break;
				case 4 :
					// PhoenixBsonExpression.g:464:11: v4= LSQUARE
					{
					int v4Start988 = getCharIndex();
					int v4StartLine988 = getLine();
					int v4StartCharPos988 = getCharPositionInLine();
					mLSQUARE(); 
					v4 = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, v4Start988, getCharIndex()-1);
					v4.setLine(v4StartLine988);
					v4.setCharPositionInLine(v4StartCharPos988);

					 sb.append(v4.getText()); 
					}
					break;
				case 5 :
					// PhoenixBsonExpression.g:465:11: v5= RSQUARE
					{
					int v5Start1004 = getCharIndex();
					int v5StartLine1004 = getLine();
					int v5StartCharPos1004 = getCharPositionInLine();
					mRSQUARE(); 
					v5 = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, v5Start1004, getCharIndex()-1);
					v5.setLine(v5StartLine1004);
					v5.setCharPositionInLine(v5StartCharPos1004);

					 sb.append(v5.getText()); 
					}
					break;
				case 6 :
					// PhoenixBsonExpression.g:466:11: v6= DOT
					{
					int v6Start1020 = getCharIndex();
					int v6StartLine1020 = getLine();
					int v6StartCharPos1020 = getCharPositionInLine();
					mDOT(); 
					v6 = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, v6Start1020, getCharIndex()-1);
					v6.setLine(v6StartLine1020);
					v6.setCharPositionInLine(v6StartCharPos1020);

					 sb.append(v6.getText()); 
					}
					break;
				case 7 :
					// PhoenixBsonExpression.g:467:11: v8= MINUS
					{
					int v8Start1036 = getCharIndex();
					int v8StartLine1036 = getLine();
					int v8StartCharPos1036 = getCharPositionInLine();
					mMINUS(); 
					v8 = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, v8Start1036, getCharIndex()-1);
					v8.setLine(v8StartLine1036);
					v8.setCharPositionInLine(v8StartCharPos1036);

					 sb.append(v8.getText()); 
					}
					break;

				default :
					if ( cnt10 >= 1 ) break loop10;
					EarlyExitException eee = new EarlyExitException(10, input);
					throw eee;
				}
				cnt10++;
			}

			 setText(sb.toString()); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOCUMENT_FIELD"

	// $ANTLR start "BIND_VALUE_CHARS"
	public final void mBIND_VALUE_CHARS() throws RecognitionException {
		try {
			// PhoenixBsonExpression.g:475:5: ( ( LETTER | DIGIT | '_' | '-' ) )
			// PhoenixBsonExpression.g:
			{
			if ( input.LA(1)=='-'||(input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "BIND_VALUE_CHARS"

	// $ANTLR start "LETTER"
	public final void mLETTER() throws RecognitionException {
		try {
			// PhoenixBsonExpression.g:482:5: ( 'a' .. 'z' | 'A' .. 'Z' )
			// PhoenixBsonExpression.g:
			{
			if ( (input.LA(1) >= 'A' && input.LA(1) <= 'Z')||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LETTER"

	// $ANTLR start "POSINTEGER"
	public final void mPOSINTEGER() throws RecognitionException {
		try {
			// PhoenixBsonExpression.g:488:5: ( ( DIGIT )+ )
			// PhoenixBsonExpression.g:488:9: ( DIGIT )+
			{
			// PhoenixBsonExpression.g:488:9: ( DIGIT )+
			int cnt11=0;
			loop11:
			while (true) {
				int alt11=2;
				int LA11_0 = input.LA(1);
				if ( ((LA11_0 >= '0' && LA11_0 <= '9')) ) {
					alt11=1;
				}

				switch (alt11) {
				case 1 :
					// PhoenixBsonExpression.g:
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt11 >= 1 ) break loop11;
					EarlyExitException eee = new EarlyExitException(11, input);
					throw eee;
				}
				cnt11++;
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "POSINTEGER"

	// $ANTLR start "DIGIT"
	public final void mDIGIT() throws RecognitionException {
		try {
			// PhoenixBsonExpression.g:493:5: ( '0' .. '9' )
			// PhoenixBsonExpression.g:
			{
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DIGIT"

	// $ANTLR start "STRING_LITERAL"
	public final void mSTRING_LITERAL() throws RecognitionException {
		try {
			int _type = STRING_LITERAL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken t=null;

			 StringBuilder sb = new StringBuilder(); 
			// PhoenixBsonExpression.g:498:5: ( '\\'' (t= CHAR |t= CHAR_ESC )* '\\'' )
			// PhoenixBsonExpression.g:498:9: '\\'' (t= CHAR |t= CHAR_ESC )* '\\''
			{
			match('\''); 
			// PhoenixBsonExpression.g:499:5: (t= CHAR |t= CHAR_ESC )*
			loop12:
			while (true) {
				int alt12=3;
				int LA12_0 = input.LA(1);
				if ( (LA12_0=='\'') ) {
					int LA12_1 = input.LA(2);
					if ( (LA12_1=='\'') ) {
						alt12=2;
					}

				}
				else if ( ((LA12_0 >= '\u0000' && LA12_0 <= '&')||(LA12_0 >= '(' && LA12_0 <= '[')||(LA12_0 >= ']' && LA12_0 <= '\uFFFF')) ) {
					alt12=1;
				}
				else if ( (LA12_0=='\\') ) {
					alt12=2;
				}

				switch (alt12) {
				case 1 :
					// PhoenixBsonExpression.g:499:7: t= CHAR
					{
					int tStart1205 = getCharIndex();
					int tStartLine1205 = getLine();
					int tStartCharPos1205 = getCharPositionInLine();
					mCHAR(); 
					t = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, tStart1205, getCharIndex()-1);
					t.setLine(tStartLine1205);
					t.setCharPositionInLine(tStartCharPos1205);

					 sb.append(t.getText()); 
					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:500:7: t= CHAR_ESC
					{
					int tStart1217 = getCharIndex();
					int tStartLine1217 = getLine();
					int tStartCharPos1217 = getCharPositionInLine();
					mCHAR_ESC(); 
					t = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, tStart1217, getCharIndex()-1);
					t.setLine(tStartLine1217);
					t.setCharPositionInLine(tStartCharPos1217);

					 sb.append(getText()); 
					}
					break;

				default :
					break loop12;
				}
			}

			match('\''); 
			 setText(sb.toString()); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STRING_LITERAL"

	// $ANTLR start "CHAR"
	public final void mCHAR() throws RecognitionException {
		try {
			// PhoenixBsonExpression.g:507:5: ( (~ ( '\\'' | '\\\\' ) ) )
			// PhoenixBsonExpression.g:
			{
			if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '\uFFFF') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CHAR"

	// $ANTLR start "CHAR_ESC"
	public final void mCHAR_ESC() throws RecognitionException {
		try {
			// PhoenixBsonExpression.g:513:5: ( '\\\\' ( 'n' | 'r' | 't' | 'b' | 'f' | '\\\"' | '\\'' | '\\\\' | '_' | '%' |) | '\\'\\'' )
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( (LA14_0=='\\') ) {
				alt14=1;
			}
			else if ( (LA14_0=='\'') ) {
				alt14=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 14, 0, input);
				throw nvae;
			}

			switch (alt14) {
				case 1 :
					// PhoenixBsonExpression.g:513:9: '\\\\' ( 'n' | 'r' | 't' | 'b' | 'f' | '\\\"' | '\\'' | '\\\\' | '_' | '%' |)
					{
					match('\\'); 
					// PhoenixBsonExpression.g:514:9: ( 'n' | 'r' | 't' | 'b' | 'f' | '\\\"' | '\\'' | '\\\\' | '_' | '%' |)
					int alt13=11;
					switch ( input.LA(1) ) {
					case 'n':
						{
						alt13=1;
						}
						break;
					case 'r':
						{
						alt13=2;
						}
						break;
					case 't':
						{
						alt13=3;
						}
						break;
					case 'b':
						{
						alt13=4;
						}
						break;
					case 'f':
						{
						alt13=5;
						}
						break;
					case '\"':
						{
						alt13=6;
						}
						break;
					case '\'':
						{
						alt13=7;
						}
						break;
					case '\\':
						{
						alt13=8;
						}
						break;
					case '_':
						{
						alt13=9;
						}
						break;
					case '%':
						{
						alt13=10;
						}
						break;
					default:
						alt13=11;
					}
					switch (alt13) {
						case 1 :
							// PhoenixBsonExpression.g:514:11: 'n'
							{
							match('n'); 
							 setText("\n"); 
							}
							break;
						case 2 :
							// PhoenixBsonExpression.g:515:11: 'r'
							{
							match('r'); 
							 setText("\r"); 
							}
							break;
						case 3 :
							// PhoenixBsonExpression.g:516:11: 't'
							{
							match('t'); 
							 setText("\t"); 
							}
							break;
						case 4 :
							// PhoenixBsonExpression.g:517:11: 'b'
							{
							match('b'); 
							 setText("\b"); 
							}
							break;
						case 5 :
							// PhoenixBsonExpression.g:518:11: 'f'
							{
							match('f'); 
							 setText("\f"); 
							}
							break;
						case 6 :
							// PhoenixBsonExpression.g:519:11: '\\\"'
							{
							match('\"'); 
							 setText("\""); 
							}
							break;
						case 7 :
							// PhoenixBsonExpression.g:520:11: '\\''
							{
							match('\''); 
							 setText("\'"); 
							}
							break;
						case 8 :
							// PhoenixBsonExpression.g:521:11: '\\\\'
							{
							match('\\'); 
							 setText("\\"); 
							}
							break;
						case 9 :
							// PhoenixBsonExpression.g:522:11: '_'
							{
							match('_'); 
							 setText("\\_"); 
							}
							break;
						case 10 :
							// PhoenixBsonExpression.g:523:11: '%'
							{
							match('%'); 
							 setText("\\%"); 
							}
							break;
						case 11 :
							// PhoenixBsonExpression.g:524:17: 
							{
							 setText("\\"); 
							}
							break;

					}

					}
					break;
				case 2 :
					// PhoenixBsonExpression.g:526:9: '\\'\\''
					{
					match("''"); 

					 setText("\'"); 
					}
					break;

			}
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CHAR_ESC"

	// $ANTLR start "WS"
	public final void mWS() throws RecognitionException {
		try {
			int _type = WS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:529:5: ( ( ' ' | '\\t' | '\\u2002' ) )
			// PhoenixBsonExpression.g:529:9: ( ' ' | '\\t' | '\\u2002' )
			{
			if ( input.LA(1)=='\t'||input.LA(1)==' '||input.LA(1)=='\u2002' ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			 _channel=HIDDEN; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "WS"

	// $ANTLR start "EOL"
	public final void mEOL() throws RecognitionException {
		try {
			int _type = EOL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// PhoenixBsonExpression.g:533:5: ( ( '\\r' | '\\n' ) )
			// PhoenixBsonExpression.g:533:8: ( '\\r' | '\\n' )
			{
			if ( input.LA(1)=='\n'||input.LA(1)=='\r' ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			 skip(); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EOL"

	@Override
	public void mTokens() throws RecognitionException {
		// PhoenixBsonExpression.g:1:8: ( AND | ATTR | ATTR_NOT | ATTR_TYPE | BEGINS_WITH | BETWEEN | CONTAINS | FALSE | FIELD | FIELD_NOT | FIELD_TYPE | IN | IS | NOT | NULL | OR | SIZE | TRUE | DECIMAL | DOUBLE | Exponent | DOUBLE_QUOTE | EQ | LT | GT | DOUBLE_EQ | NOEQ1 | NOEQ2 | CONCAT | COMMA | LPAREN | RPAREN | SEMICOLON | COLON | QUESTION | LSQUARE | RSQUARE | LCURLY | RCURLY | AT | TILDE | PLUS | MINUS | ASTERISK | DIVIDE | DOT | PERCENT | UNDERSCORE | HASH | BIND_VALUE | HASH_DOCUMENT_FIELD | DOCUMENT_FIELD | STRING_LITERAL | WS | EOL )
		int alt15=55;
		alt15 = dfa15.predict(input);
		switch (alt15) {
			case 1 :
				// PhoenixBsonExpression.g:1:10: AND
				{
				mAND(); 

				}
				break;
			case 2 :
				// PhoenixBsonExpression.g:1:14: ATTR
				{
				mATTR(); 

				}
				break;
			case 3 :
				// PhoenixBsonExpression.g:1:19: ATTR_NOT
				{
				mATTR_NOT(); 

				}
				break;
			case 4 :
				// PhoenixBsonExpression.g:1:28: ATTR_TYPE
				{
				mATTR_TYPE(); 

				}
				break;
			case 5 :
				// PhoenixBsonExpression.g:1:38: BEGINS_WITH
				{
				mBEGINS_WITH(); 

				}
				break;
			case 6 :
				// PhoenixBsonExpression.g:1:50: BETWEEN
				{
				mBETWEEN(); 

				}
				break;
			case 7 :
				// PhoenixBsonExpression.g:1:58: CONTAINS
				{
				mCONTAINS(); 

				}
				break;
			case 8 :
				// PhoenixBsonExpression.g:1:67: FALSE
				{
				mFALSE(); 

				}
				break;
			case 9 :
				// PhoenixBsonExpression.g:1:73: FIELD
				{
				mFIELD(); 

				}
				break;
			case 10 :
				// PhoenixBsonExpression.g:1:79: FIELD_NOT
				{
				mFIELD_NOT(); 

				}
				break;
			case 11 :
				// PhoenixBsonExpression.g:1:89: FIELD_TYPE
				{
				mFIELD_TYPE(); 

				}
				break;
			case 12 :
				// PhoenixBsonExpression.g:1:100: IN
				{
				mIN(); 

				}
				break;
			case 13 :
				// PhoenixBsonExpression.g:1:103: IS
				{
				mIS(); 

				}
				break;
			case 14 :
				// PhoenixBsonExpression.g:1:106: NOT
				{
				mNOT(); 

				}
				break;
			case 15 :
				// PhoenixBsonExpression.g:1:110: NULL
				{
				mNULL(); 

				}
				break;
			case 16 :
				// PhoenixBsonExpression.g:1:115: OR
				{
				mOR(); 

				}
				break;
			case 17 :
				// PhoenixBsonExpression.g:1:118: SIZE
				{
				mSIZE(); 

				}
				break;
			case 18 :
				// PhoenixBsonExpression.g:1:123: TRUE
				{
				mTRUE(); 

				}
				break;
			case 19 :
				// PhoenixBsonExpression.g:1:128: DECIMAL
				{
				mDECIMAL(); 

				}
				break;
			case 20 :
				// PhoenixBsonExpression.g:1:136: DOUBLE
				{
				mDOUBLE(); 

				}
				break;
			case 21 :
				// PhoenixBsonExpression.g:1:143: Exponent
				{
				mExponent(); 

				}
				break;
			case 22 :
				// PhoenixBsonExpression.g:1:152: DOUBLE_QUOTE
				{
				mDOUBLE_QUOTE(); 

				}
				break;
			case 23 :
				// PhoenixBsonExpression.g:1:165: EQ
				{
				mEQ(); 

				}
				break;
			case 24 :
				// PhoenixBsonExpression.g:1:168: LT
				{
				mLT(); 

				}
				break;
			case 25 :
				// PhoenixBsonExpression.g:1:171: GT
				{
				mGT(); 

				}
				break;
			case 26 :
				// PhoenixBsonExpression.g:1:174: DOUBLE_EQ
				{
				mDOUBLE_EQ(); 

				}
				break;
			case 27 :
				// PhoenixBsonExpression.g:1:184: NOEQ1
				{
				mNOEQ1(); 

				}
				break;
			case 28 :
				// PhoenixBsonExpression.g:1:190: NOEQ2
				{
				mNOEQ2(); 

				}
				break;
			case 29 :
				// PhoenixBsonExpression.g:1:196: CONCAT
				{
				mCONCAT(); 

				}
				break;
			case 30 :
				// PhoenixBsonExpression.g:1:203: COMMA
				{
				mCOMMA(); 

				}
				break;
			case 31 :
				// PhoenixBsonExpression.g:1:209: LPAREN
				{
				mLPAREN(); 

				}
				break;
			case 32 :
				// PhoenixBsonExpression.g:1:216: RPAREN
				{
				mRPAREN(); 

				}
				break;
			case 33 :
				// PhoenixBsonExpression.g:1:223: SEMICOLON
				{
				mSEMICOLON(); 

				}
				break;
			case 34 :
				// PhoenixBsonExpression.g:1:233: COLON
				{
				mCOLON(); 

				}
				break;
			case 35 :
				// PhoenixBsonExpression.g:1:239: QUESTION
				{
				mQUESTION(); 

				}
				break;
			case 36 :
				// PhoenixBsonExpression.g:1:248: LSQUARE
				{
				mLSQUARE(); 

				}
				break;
			case 37 :
				// PhoenixBsonExpression.g:1:256: RSQUARE
				{
				mRSQUARE(); 

				}
				break;
			case 38 :
				// PhoenixBsonExpression.g:1:264: LCURLY
				{
				mLCURLY(); 

				}
				break;
			case 39 :
				// PhoenixBsonExpression.g:1:271: RCURLY
				{
				mRCURLY(); 

				}
				break;
			case 40 :
				// PhoenixBsonExpression.g:1:278: AT
				{
				mAT(); 

				}
				break;
			case 41 :
				// PhoenixBsonExpression.g:1:281: TILDE
				{
				mTILDE(); 

				}
				break;
			case 42 :
				// PhoenixBsonExpression.g:1:287: PLUS
				{
				mPLUS(); 

				}
				break;
			case 43 :
				// PhoenixBsonExpression.g:1:292: MINUS
				{
				mMINUS(); 

				}
				break;
			case 44 :
				// PhoenixBsonExpression.g:1:298: ASTERISK
				{
				mASTERISK(); 

				}
				break;
			case 45 :
				// PhoenixBsonExpression.g:1:307: DIVIDE
				{
				mDIVIDE(); 

				}
				break;
			case 46 :
				// PhoenixBsonExpression.g:1:314: DOT
				{
				mDOT(); 

				}
				break;
			case 47 :
				// PhoenixBsonExpression.g:1:318: PERCENT
				{
				mPERCENT(); 

				}
				break;
			case 48 :
				// PhoenixBsonExpression.g:1:326: UNDERSCORE
				{
				mUNDERSCORE(); 

				}
				break;
			case 49 :
				// PhoenixBsonExpression.g:1:337: HASH
				{
				mHASH(); 

				}
				break;
			case 50 :
				// PhoenixBsonExpression.g:1:342: BIND_VALUE
				{
				mBIND_VALUE(); 

				}
				break;
			case 51 :
				// PhoenixBsonExpression.g:1:353: HASH_DOCUMENT_FIELD
				{
				mHASH_DOCUMENT_FIELD(); 

				}
				break;
			case 52 :
				// PhoenixBsonExpression.g:1:373: DOCUMENT_FIELD
				{
				mDOCUMENT_FIELD(); 

				}
				break;
			case 53 :
				// PhoenixBsonExpression.g:1:388: STRING_LITERAL
				{
				mSTRING_LITERAL(); 

				}
				break;
			case 54 :
				// PhoenixBsonExpression.g:1:403: WS
				{
				mWS(); 

				}
				break;
			case 55 :
				// PhoenixBsonExpression.g:1:406: EOL
				{
				mEOL(); 

				}
				break;

		}
	}


	protected DFA5 dfa5 = new DFA5(this);
	protected DFA15 dfa15 = new DFA15(this);
	static final String DFA5_eotS =
		"\3\uffff\1\4\2\uffff";
	static final String DFA5_eofS =
		"\6\uffff";
	static final String DFA5_minS =
		"\1\56\1\uffff\1\56\1\105\2\uffff";
	static final String DFA5_maxS =
		"\1\71\1\uffff\2\145\2\uffff";
	static final String DFA5_acceptS =
		"\1\uffff\1\1\2\uffff\1\3\1\2";
	static final String DFA5_specialS =
		"\6\uffff}>";
	static final String[] DFA5_transitionS = {
			"\1\1\1\uffff\12\2",
			"",
			"\1\3\1\uffff\12\2\13\uffff\1\4\37\uffff\1\4",
			"\1\5\37\uffff\1\5",
			"",
			""
	};

	static final short[] DFA5_eot = DFA.unpackEncodedString(DFA5_eotS);
	static final short[] DFA5_eof = DFA.unpackEncodedString(DFA5_eofS);
	static final char[] DFA5_min = DFA.unpackEncodedStringToUnsignedChars(DFA5_minS);
	static final char[] DFA5_max = DFA.unpackEncodedStringToUnsignedChars(DFA5_maxS);
	static final short[] DFA5_accept = DFA.unpackEncodedString(DFA5_acceptS);
	static final short[] DFA5_special = DFA.unpackEncodedString(DFA5_specialS);
	static final short[][] DFA5_transition;

	static {
		int numStates = DFA5_transitionS.length;
		DFA5_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA5_transition[i] = DFA.unpackEncodedString(DFA5_transitionS[i]);
		}
	}

	protected class DFA5 extends DFA {

		public DFA5(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 5;
			this.eot = DFA5_eot;
			this.eof = DFA5_eof;
			this.min = DFA5_min;
			this.max = DFA5_max;
			this.accept = DFA5_accept;
			this.special = DFA5_special;
			this.transition = DFA5_transition;
		}
		@Override
		public String getDescription() {
			return "320:1: DOUBLE : ( '.' POSINTEGER Exponent | POSINTEGER '.' Exponent | POSINTEGER ( '.' ( POSINTEGER ( Exponent )? )? | Exponent ) );";
		}
	}

	static final String DFA15_eotS =
		"\1\uffff\12\47\1\73\1\47\1\uffff\1\100\1\102\7\uffff\1\103\1\uffff\1\104"+
		"\1\105\5\uffff\1\106\3\uffff\1\107\1\110\5\uffff\6\47\1\121\1\122\2\47"+
		"\1\125\2\47\1\132\1\47\1\135\1\uffff\1\47\1\76\14\uffff\1\137\6\47\2\uffff"+
		"\1\146\1\47\1\uffff\2\47\1\135\1\47\1\uffff\1\47\1\132\1\uffff\1\47\1"+
		"\uffff\6\47\1\uffff\1\165\1\166\1\167\2\47\1\132\1\47\1\132\4\47\1\176"+
		"\1\47\3\uffff\1\47\1\132\4\47\1\uffff\3\47\1\u0089\6\47\1\uffff\1\u0090"+
		"\5\47\1\uffff\7\47\1\u009f\3\47\1\u00a3\2\47\1\uffff\3\47\1\uffff\1\u00a9"+
		"\4\47\1\uffff\3\47\1\u00b1\3\47\1\uffff\1\47\1\u00b6\1\47\1\u00b8\1\uffff"+
		"\1\47\1\uffff\2\47\1\u00bc\1\uffff";
	static final String DFA15_eofS =
		"\u00bd\uffff";
	static final String DFA15_minS =
		"\1\11\1\156\1\145\1\157\1\141\1\156\1\157\1\162\1\151\1\162\1\56\1\55"+
		"\1\53\1\uffff\1\75\1\76\7\uffff\1\55\1\uffff\2\55\5\uffff\1\55\3\uffff"+
		"\1\55\1\43\5\uffff\1\144\1\164\1\147\1\156\1\154\1\145\2\55\1\164\1\154"+
		"\1\55\1\172\1\165\1\55\1\53\1\55\1\uffff\1\60\1\55\14\uffff\1\55\1\162"+
		"\1\151\1\167\1\164\1\163\1\154\2\uffff\1\55\1\154\1\uffff\2\145\1\55\1"+
		"\53\1\uffff\1\60\1\55\1\uffff\1\53\1\uffff\1\151\1\156\1\145\1\141\1\145"+
		"\1\144\1\uffff\3\55\1\53\1\60\1\55\1\60\1\55\1\142\1\163\1\145\1\151\1"+
		"\55\1\137\3\uffff\1\60\1\55\1\165\1\137\2\156\1\uffff\1\145\1\164\1\167"+
		"\1\55\1\163\1\170\1\157\1\171\1\145\1\151\1\uffff\1\55\1\151\1\164\1\160"+
		"\1\137\1\164\1\uffff\1\163\1\137\2\145\1\150\1\164\1\145\1\55\1\170\1"+
		"\157\1\171\1\55\1\163\1\170\1\uffff\1\151\1\164\1\160\1\uffff\1\55\1\151"+
		"\1\163\1\137\1\145\1\uffff\1\163\1\164\1\145\1\55\1\164\1\163\1\170\1"+
		"\uffff\1\163\1\55\1\151\1\55\1\uffff\1\163\1\uffff\1\164\1\163\1\55\1"+
		"\uffff";
	static final String DFA15_maxS =
		"\1\u2002\1\164\1\145\1\157\1\151\1\163\1\165\1\162\1\151\1\162\1\145\1"+
		"\172\1\71\1\uffff\1\75\1\76\7\uffff\1\172\1\uffff\2\172\5\uffff\1\172"+
		"\3\uffff\2\172\5\uffff\1\144\2\164\1\156\1\154\1\145\2\172\1\164\1\154"+
		"\2\172\1\165\1\172\1\71\1\172\1\uffff\1\71\1\172\14\uffff\1\172\1\162"+
		"\1\151\1\167\1\164\1\163\1\154\2\uffff\1\172\1\154\1\uffff\2\145\1\172"+
		"\1\71\1\uffff\1\71\1\172\1\uffff\1\71\1\uffff\1\151\1\156\1\145\1\141"+
		"\1\145\1\144\1\uffff\3\172\2\71\1\172\1\71\1\172\1\142\1\163\1\145\1\151"+
		"\1\172\1\137\3\uffff\1\71\1\172\1\165\1\137\2\156\1\uffff\2\164\1\167"+
		"\1\172\1\163\1\170\1\157\1\171\1\145\1\151\1\uffff\1\172\1\151\1\164\1"+
		"\160\1\137\1\164\1\uffff\1\163\1\137\1\145\1\164\1\150\1\164\1\145\1\172"+
		"\1\170\1\157\1\171\1\172\1\163\1\170\1\uffff\1\151\1\164\1\160\1\uffff"+
		"\1\172\1\151\1\163\1\137\1\145\1\uffff\1\163\1\164\1\145\1\172\1\164\1"+
		"\163\1\170\1\uffff\1\163\1\172\1\151\1\172\1\uffff\1\163\1\uffff\1\164"+
		"\1\163\1\172\1\uffff";
	static final String DFA15_acceptS =
		"\15\uffff\1\26\2\uffff\1\31\1\33\1\35\1\36\1\37\1\40\1\41\1\uffff\1\43"+
		"\2\uffff\1\46\1\47\1\50\1\51\1\52\1\uffff\1\54\1\55\1\57\2\uffff\1\62"+
		"\1\64\1\65\1\66\1\67\20\uffff\1\56\2\uffff\1\25\1\32\1\27\1\34\1\30\1"+
		"\42\1\44\1\45\1\53\1\60\1\61\1\63\7\uffff\1\14\1\15\2\uffff\1\20\4\uffff"+
		"\1\24\2\uffff\1\23\1\uffff\1\1\6\uffff\1\16\16\uffff\1\17\1\21\1\22\6"+
		"\uffff\1\10\12\uffff\1\6\6\uffff\1\7\16\uffff\1\13\3\uffff\1\5\5\uffff"+
		"\1\11\7\uffff\1\4\4\uffff\1\2\1\uffff\1\12\3\uffff\1\3";
	static final String DFA15_specialS =
		"\u00bd\uffff}>";
	static final String[] DFA15_transitionS = {
			"\1\51\1\52\2\uffff\1\52\22\uffff\1\51\1\21\1\15\1\45\1\46\1\43\1\uffff"+
			"\1\50\1\24\1\25\1\41\1\37\1\23\1\40\1\13\1\42\12\12\1\27\1\26\1\17\1"+
			"\16\1\20\1\30\1\35\4\47\1\14\25\47\1\31\1\uffff\1\32\1\uffff\1\44\1\uffff"+
			"\1\1\1\2\1\3\1\47\1\14\1\4\2\47\1\5\4\47\1\6\1\7\3\47\1\10\1\11\6\47"+
			"\1\33\1\22\1\34\1\36\u1f83\uffff\1\51",
			"\1\53\5\uffff\1\54",
			"\1\55",
			"\1\56",
			"\1\57\7\uffff\1\60",
			"\1\61\4\uffff\1\62",
			"\1\63\5\uffff\1\64",
			"\1\65",
			"\1\66",
			"\1\67",
			"\1\70\1\uffff\12\12\13\uffff\1\71\37\uffff\1\71",
			"\2\47\1\uffff\12\72\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\76\1\uffff\1\74\2\uffff\12\75",
			"",
			"\1\77",
			"\1\101",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\46\2\uffff\12\46\7\uffff\32\46\4\uffff\1\46\1\uffff\32\46",
			"",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"",
			"",
			"",
			"",
			"",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"",
			"",
			"",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\111\11\uffff\2\111\1\uffff\12\111\7\uffff\33\111\1\uffff\1\111\1"+
			"\uffff\1\111\1\uffff\32\111",
			"",
			"",
			"",
			"",
			"",
			"\1\112",
			"\1\113",
			"\1\114\14\uffff\1\115",
			"\1\116",
			"\1\117",
			"\1\120",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\123",
			"\1\124",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\126",
			"\1\127",
			"\2\47\1\uffff\12\130\7\uffff\4\47\1\131\26\47\1\uffff\1\47\1\uffff\1"+
			"\47\1\uffff\4\47\1\131\25\47",
			"\1\132\1\uffff\1\133\2\uffff\12\134",
			"\2\47\1\uffff\12\72\7\uffff\4\47\1\136\26\47\1\uffff\1\47\1\uffff\1"+
			"\47\1\uffff\4\47\1\136\25\47",
			"",
			"\12\75",
			"\2\47\1\uffff\12\75\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\140",
			"\1\141",
			"\1\142",
			"\1\143",
			"\1\144",
			"\1\145",
			"",
			"",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\147",
			"",
			"\1\150",
			"\1\151",
			"\2\47\1\uffff\12\130\7\uffff\4\47\1\152\26\47\1\uffff\1\47\1\uffff\1"+
			"\47\1\uffff\4\47\1\152\25\47",
			"\1\132\1\uffff\1\153\2\uffff\12\154",
			"",
			"\12\134",
			"\2\47\1\uffff\12\134\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"",
			"\1\132\1\uffff\1\155\2\uffff\12\156",
			"",
			"\1\157",
			"\1\160",
			"\1\161",
			"\1\162",
			"\1\163",
			"\1\164",
			"",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\132\1\uffff\1\170\2\uffff\12\171",
			"\12\154",
			"\2\47\1\uffff\12\154\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\12\156",
			"\2\47\1\uffff\12\156\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\172",
			"\1\173",
			"\1\174",
			"\1\175",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\177",
			"",
			"",
			"",
			"\12\171",
			"\2\47\1\uffff\12\171\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\u0080",
			"\1\u0081",
			"\1\u0082",
			"\1\u0083",
			"",
			"\1\u0084\10\uffff\1\u0085\5\uffff\1\u0086",
			"\1\u0087",
			"\1\u0088",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\u008a",
			"\1\u008b",
			"\1\u008c",
			"\1\u008d",
			"\1\u008e",
			"\1\u008f",
			"",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\u0091",
			"\1\u0092",
			"\1\u0093",
			"\1\u0094",
			"\1\u0095",
			"",
			"\1\u0096",
			"\1\u0097",
			"\1\u0098",
			"\1\u0099\10\uffff\1\u009a\5\uffff\1\u009b",
			"\1\u009c",
			"\1\u009d",
			"\1\u009e",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\u00a0",
			"\1\u00a1",
			"\1\u00a2",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\u00a4",
			"\1\u00a5",
			"",
			"\1\u00a6",
			"\1\u00a7",
			"\1\u00a8",
			"",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\u00aa",
			"\1\u00ab",
			"\1\u00ac",
			"\1\u00ad",
			"",
			"\1\u00ae",
			"\1\u00af",
			"\1\u00b0",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\u00b2",
			"\1\u00b3",
			"\1\u00b4",
			"",
			"\1\u00b5",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"\1\u00b7",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			"",
			"\1\u00b9",
			"",
			"\1\u00ba",
			"\1\u00bb",
			"\2\47\1\uffff\12\47\7\uffff\33\47\1\uffff\1\47\1\uffff\1\47\1\uffff"+
			"\32\47",
			""
	};

	static final short[] DFA15_eot = DFA.unpackEncodedString(DFA15_eotS);
	static final short[] DFA15_eof = DFA.unpackEncodedString(DFA15_eofS);
	static final char[] DFA15_min = DFA.unpackEncodedStringToUnsignedChars(DFA15_minS);
	static final char[] DFA15_max = DFA.unpackEncodedStringToUnsignedChars(DFA15_maxS);
	static final short[] DFA15_accept = DFA.unpackEncodedString(DFA15_acceptS);
	static final short[] DFA15_special = DFA.unpackEncodedString(DFA15_specialS);
	static final short[][] DFA15_transition;

	static {
		int numStates = DFA15_transitionS.length;
		DFA15_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA15_transition[i] = DFA.unpackEncodedString(DFA15_transitionS[i]);
		}
	}

	protected class DFA15 extends DFA {

		public DFA15(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 15;
			this.eot = DFA15_eot;
			this.eof = DFA15_eof;
			this.min = DFA15_min;
			this.max = DFA15_max;
			this.accept = DFA15_accept;
			this.special = DFA15_special;
			this.transition = DFA15_transition;
		}
		@Override
		public String getDescription() {
			return "1:1: Tokens : ( AND | ATTR | ATTR_NOT | ATTR_TYPE | BEGINS_WITH | BETWEEN | CONTAINS | FALSE | FIELD | FIELD_NOT | FIELD_TYPE | IN | IS | NOT | NULL | OR | SIZE | TRUE | DECIMAL | DOUBLE | Exponent | DOUBLE_QUOTE | EQ | LT | GT | DOUBLE_EQ | NOEQ1 | NOEQ2 | CONCAT | COMMA | LPAREN | RPAREN | SEMICOLON | COLON | QUESTION | LSQUARE | RSQUARE | LCURLY | RCURLY | AT | TILDE | PLUS | MINUS | ASTERISK | DIVIDE | DOT | PERCENT | UNDERSCORE | HASH | BIND_VALUE | HASH_DOCUMENT_FIELD | DOCUMENT_FIELD | STRING_LITERAL | WS | EOL );";
		}
	}

}
