/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.apache.parquet.Exceptions;
import org.apache.parquet.Preconditions;
import org.apache.parquet.util.DynConstructors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynMethods {
    private static final Logger LOG = LoggerFactory.getLogger(DynMethods.class);

    private static class MakeAccessible
    implements PrivilegedAction<Void> {
        private Method hidden;

        public MakeAccessible(Method hidden) {
            this.hidden = hidden;
        }

        @Override
        public Void run() {
            this.hidden.setAccessible(true);
            return null;
        }
    }

    public static class Builder {
        private final String name;
        private ClassLoader loader = Thread.currentThread().getContextClassLoader();
        private UnboundMethod method = null;

        public Builder(String methodName) {
            this.name = methodName;
        }

        public Builder loader(ClassLoader loader) {
            this.loader = loader;
            return this;
        }

        public Builder orNoop() {
            if (this.method == null) {
                this.method = UnboundMethod.NOOP;
            }
            return this;
        }

        public Builder impl(String className, String methodName, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                Class<?> targetClass = Class.forName(className, true, this.loader);
                this.impl(targetClass, methodName, argClasses);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("failed to load class {}", (Object)className, (Object)e);
            }
            return this;
        }

        public Builder impl(String className, Class<?> ... argClasses) {
            this.impl(className, this.name, argClasses);
            return this;
        }

        public Builder impl(Class<?> targetClass, String methodName, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                this.method = new UnboundMethod(targetClass.getMethod(methodName, argClasses), this.name);
            }
            catch (NoSuchMethodException e) {
                LOG.debug("failed to load method {} from class {}", new Object[]{methodName, targetClass, e});
            }
            return this;
        }

        public Builder impl(Class<?> targetClass, Class<?> ... argClasses) {
            this.impl(targetClass, this.name, argClasses);
            return this;
        }

        public Builder ctorImpl(Class<?> targetClass, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                this.method = new DynConstructors.Builder().impl(targetClass, argClasses).buildChecked();
            }
            catch (NoSuchMethodException e) {
                LOG.debug("failed to load constructor arity {} from class {}", new Object[]{argClasses.length, targetClass, e});
            }
            return this;
        }

        public Builder ctorImpl(String className, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                this.method = new DynConstructors.Builder().impl(className, argClasses).buildChecked();
            }
            catch (NoSuchMethodException e) {
                LOG.debug("failed to load constructor arity {} from class {}", new Object[]{argClasses.length, className, e});
            }
            return this;
        }

        public Builder hiddenImpl(String className, String methodName, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                Class<?> targetClass = Class.forName(className, true, this.loader);
                this.hiddenImpl(targetClass, methodName, argClasses);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("failed to load class {}", (Object)className, (Object)e);
            }
            return this;
        }

        public Builder hiddenImpl(String className, Class<?> ... argClasses) {
            this.hiddenImpl(className, this.name, argClasses);
            return this;
        }

        public Builder hiddenImpl(Class<?> targetClass, String methodName, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                Method hidden = targetClass.getDeclaredMethod(methodName, argClasses);
                AccessController.doPrivileged(new MakeAccessible(hidden));
                this.method = new UnboundMethod(hidden, this.name);
            }
            catch (NoSuchMethodException | SecurityException e) {
                LOG.debug("failed to load method {} from class {}", new Object[]{methodName, targetClass, e});
            }
            return this;
        }

        public Builder hiddenImpl(Class<?> targetClass, Class<?> ... argClasses) {
            this.hiddenImpl(targetClass, this.name, argClasses);
            return this;
        }

        public UnboundMethod buildChecked() throws NoSuchMethodException {
            if (this.method != null) {
                return this.method;
            }
            throw new NoSuchMethodException("Cannot find method: " + this.name);
        }

        public UnboundMethod build() {
            if (this.method != null) {
                return this.method;
            }
            throw new RuntimeException("Cannot find method: " + this.name);
        }

        public BoundMethod buildChecked(Object receiver) throws NoSuchMethodException {
            return this.buildChecked().bind(receiver);
        }

        public BoundMethod build(Object receiver) {
            return this.build().bind(receiver);
        }

        public StaticMethod buildStaticChecked() throws NoSuchMethodException {
            return this.buildChecked().asStatic();
        }

        public StaticMethod buildStatic() {
            return this.build().asStatic();
        }
    }

    public static class StaticMethod {
        private final UnboundMethod method;

        private StaticMethod(UnboundMethod method) {
            this.method = method;
        }

        public <R> R invokeChecked(Object ... args) throws Exception {
            return this.method.invokeChecked(null, args);
        }

        public <R> R invoke(Object ... args) {
            return this.method.invoke(null, args);
        }
    }

    public static class BoundMethod {
        private final UnboundMethod method;
        private final Object receiver;

        private BoundMethod(UnboundMethod method, Object receiver) {
            this.method = method;
            this.receiver = receiver;
        }

        public <R> R invokeChecked(Object ... args) throws Exception {
            return this.method.invokeChecked(this.receiver, args);
        }

        public <R> R invoke(Object ... args) {
            return this.method.invoke(this.receiver, args);
        }
    }

    public static class UnboundMethod {
        private final Method method;
        private final String name;
        private final int argLength;
        private static UnboundMethod NOOP = new UnboundMethod(null, "NOOP"){

            @Override
            public <R> R invokeChecked(Object target, Object ... args) throws Exception {
                return null;
            }

            @Override
            public BoundMethod bind(Object receiver) {
                return new BoundMethod(this, receiver);
            }

            @Override
            public StaticMethod asStatic() {
                return new StaticMethod(this);
            }

            @Override
            public boolean isStatic() {
                return true;
            }

            @Override
            public String toString() {
                return "DynMethods.UnboundMethod(NOOP)";
            }
        };

        UnboundMethod(Method method, String name) {
            this.method = method;
            this.name = name;
            this.argLength = method == null || method.isVarArgs() ? -1 : method.getParameterTypes().length;
        }

        public <R> R invokeChecked(Object target, Object ... args) throws Exception {
            try {
                if (this.argLength < 0) {
                    return (R)this.method.invoke(target, args);
                }
                return (R)this.method.invoke(target, Arrays.copyOfRange(args, 0, this.argLength));
            }
            catch (InvocationTargetException e) {
                Exceptions.throwIfInstance(e.getCause(), Exception.class);
                Exceptions.throwIfInstance(e.getCause(), RuntimeException.class);
                throw new RuntimeException(e.getCause());
            }
        }

        public <R> R invoke(Object target, Object ... args) {
            try {
                return this.invokeChecked(target, args);
            }
            catch (Exception e) {
                Exceptions.throwIfInstance(e, RuntimeException.class);
                throw new RuntimeException(e);
            }
        }

        public BoundMethod bind(Object receiver) {
            Preconditions.checkState(!this.isStatic(), "Cannot bind static method " + this.method.toGenericString());
            Preconditions.checkArgument(this.method.getDeclaringClass().isAssignableFrom(receiver.getClass()), "Cannot bind " + this.method.toGenericString() + " to instance of " + receiver.getClass());
            return new BoundMethod(this, receiver);
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.method.getModifiers());
        }

        public boolean isNoop() {
            return this == NOOP;
        }

        public StaticMethod asStatic() {
            Preconditions.checkState(this.isStatic(), "Method is not static");
            return new StaticMethod(this);
        }

        public String toString() {
            return "DynMethods.UnboundMethod(name=" + this.name + " method=" + this.method.toGenericString() + ")";
        }
    }
}

