/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.format;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.format.BloomFilterHeader;
import org.apache.parquet.format.ColumnIndex;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.EncryptionAlgorithm;
import org.apache.parquet.format.FileCryptoMetaData;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.InterningProtocol;
import org.apache.parquet.format.KeyValue;
import org.apache.parquet.format.MetadataValidator;
import org.apache.parquet.format.OffsetIndex;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.event.Consumers;
import org.apache.parquet.format.event.EventBasedThriftReader;
import org.apache.parquet.format.event.TypedConsumer;
import shaded.parquet.org.apache.thrift.TBase;
import shaded.parquet.org.apache.thrift.TException;
import shaded.parquet.org.apache.thrift.protocol.TCompactProtocol;
import shaded.parquet.org.apache.thrift.protocol.TProtocol;
import shaded.parquet.org.apache.thrift.transport.TIOStreamTransport;
import shaded.parquet.org.apache.thrift.transport.TMemoryBuffer;
import shaded.parquet.org.apache.thrift.transport.TTransportException;

public class Util {
    private static final int INIT_MEM_ALLOC_ENCR_BUFFER = 100;

    public static void writeColumnIndex(ColumnIndex columnIndex, OutputStream to) throws IOException {
        Util.writeColumnIndex(columnIndex, to, null, null);
    }

    public static void writeColumnIndex(ColumnIndex columnIndex, OutputStream to, BlockCipher.Encryptor encryptor, byte[] AAD) throws IOException {
        Util.write(columnIndex, to, encryptor, AAD);
    }

    public static ColumnIndex readColumnIndex(InputStream from) throws IOException {
        return Util.readColumnIndex(from, null, null);
    }

    public static ColumnIndex readColumnIndex(InputStream from, BlockCipher.Decryptor decryptor, byte[] AAD) throws IOException {
        return Util.read(from, new ColumnIndex(), decryptor, AAD);
    }

    public static void writeOffsetIndex(OffsetIndex offsetIndex, OutputStream to) throws IOException {
        Util.writeOffsetIndex(offsetIndex, to, null, null);
    }

    public static void writeOffsetIndex(OffsetIndex offsetIndex, OutputStream to, BlockCipher.Encryptor encryptor, byte[] AAD) throws IOException {
        Util.write(offsetIndex, to, encryptor, AAD);
    }

    public static OffsetIndex readOffsetIndex(InputStream from) throws IOException {
        return Util.readOffsetIndex(from, null, null);
    }

    public static OffsetIndex readOffsetIndex(InputStream from, BlockCipher.Decryptor decryptor, byte[] AAD) throws IOException {
        return Util.read(from, new OffsetIndex(), decryptor, AAD);
    }

    public static BloomFilterHeader readBloomFilterHeader(InputStream from) throws IOException {
        return Util.readBloomFilterHeader(from, null, null);
    }

    public static void writeBloomFilterHeader(BloomFilterHeader header, OutputStream out) throws IOException {
        Util.writeBloomFilterHeader(header, out, null, null);
    }

    public static BloomFilterHeader readBloomFilterHeader(InputStream from, BlockCipher.Decryptor decryptor, byte[] AAD) throws IOException {
        return Util.read(from, new BloomFilterHeader(), decryptor, AAD);
    }

    public static void writeBloomFilterHeader(BloomFilterHeader header, OutputStream out, BlockCipher.Encryptor encryptor, byte[] AAD) throws IOException {
        Util.write(header, out, encryptor, AAD);
    }

    public static void writePageHeader(PageHeader pageHeader, OutputStream to) throws IOException {
        Util.writePageHeader(pageHeader, to, null, null);
    }

    public static void writePageHeader(PageHeader pageHeader, OutputStream to, BlockCipher.Encryptor encryptor, byte[] AAD) throws IOException {
        Util.write(pageHeader, to, encryptor, AAD);
    }

    public static PageHeader readPageHeader(InputStream from) throws IOException {
        return MetadataValidator.validate(Util.readPageHeader(from, null, null));
    }

    public static PageHeader readPageHeader(InputStream from, BlockCipher.Decryptor decryptor, byte[] AAD) throws IOException {
        return Util.read(from, new PageHeader(), decryptor, AAD);
    }

    public static void writeFileMetaData(FileMetaData fileMetadata, OutputStream to) throws IOException {
        Util.writeFileMetaData(fileMetadata, to, null, null);
    }

    public static void writeFileMetaData(FileMetaData fileMetadata, OutputStream to, BlockCipher.Encryptor encryptor, byte[] AAD) throws IOException {
        Util.write(fileMetadata, to, encryptor, AAD);
    }

    public static FileMetaData readFileMetaData(InputStream from) throws IOException {
        return Util.readFileMetaData(from, null, null);
    }

    public static FileMetaData readFileMetaData(InputStream from, BlockCipher.Decryptor decryptor, byte[] AAD) throws IOException {
        return Util.read(from, new FileMetaData(), decryptor, AAD);
    }

    public static void writeColumnMetaData(ColumnMetaData columnMetaData, OutputStream to, BlockCipher.Encryptor encryptor, byte[] AAD) throws IOException {
        Util.write(columnMetaData, to, encryptor, AAD);
    }

    public static ColumnMetaData readColumnMetaData(InputStream from, BlockCipher.Decryptor decryptor, byte[] AAD) throws IOException {
        return Util.read(from, new ColumnMetaData(), decryptor, AAD);
    }

    public static FileMetaData readFileMetaData(InputStream from, boolean skipRowGroups) throws IOException {
        return Util.readFileMetaData(from, skipRowGroups, (BlockCipher.Decryptor)null, (byte[])null);
    }

    public static FileMetaData readFileMetaData(InputStream from, boolean skipRowGroups, BlockCipher.Decryptor decryptor, byte[] AAD) throws IOException {
        FileMetaData md = new FileMetaData();
        if (skipRowGroups) {
            Util.readFileMetaData(from, new DefaultFileMetaDataConsumer(md), skipRowGroups, decryptor, AAD);
        } else {
            Util.read(from, md, decryptor, AAD);
        }
        return md;
    }

    public static void writeFileCryptoMetaData(FileCryptoMetaData cryptoMetadata, OutputStream to) throws IOException {
        Util.write(cryptoMetadata, to, null, null);
    }

    public static FileCryptoMetaData readFileCryptoMetaData(InputStream from) throws IOException {
        return Util.read(from, new FileCryptoMetaData(), null, null);
    }

    public static void readFileMetaData(InputStream from, FileMetaDataConsumer consumer) throws IOException {
        Util.readFileMetaData(from, consumer, null, null);
    }

    public static void readFileMetaData(InputStream from, FileMetaDataConsumer consumer, BlockCipher.Decryptor decryptor, byte[] AAD) throws IOException {
        Util.readFileMetaData(from, consumer, false, decryptor, AAD);
    }

    public static void readFileMetaData(InputStream from, FileMetaDataConsumer consumer, boolean skipRowGroups) throws IOException {
        Util.readFileMetaData(from, consumer, skipRowGroups, null, null);
    }

    public static void readFileMetaData(InputStream input, final FileMetaDataConsumer consumer, boolean skipRowGroups, BlockCipher.Decryptor decryptor, byte[] AAD) throws IOException {
        try {
            InputStream from;
            Consumers.DelegatingFieldConsumer eventConsumer = Consumers.fieldConsumer().onField(FileMetaData._Fields.VERSION, new TypedConsumer.I32Consumer(){

                @Override
                public void consume(int value) {
                    consumer.setVersion(value);
                }
            }).onField(FileMetaData._Fields.SCHEMA, Consumers.listOf(SchemaElement.class, new Consumers.Consumer<List<SchemaElement>>(){

                @Override
                public void consume(List<SchemaElement> schema) {
                    consumer.setSchema(schema);
                }
            })).onField(FileMetaData._Fields.NUM_ROWS, new TypedConsumer.I64Consumer(){

                @Override
                public void consume(long value) {
                    consumer.setNumRows(value);
                }
            }).onField(FileMetaData._Fields.KEY_VALUE_METADATA, Consumers.listElementsOf(Consumers.struct(KeyValue.class, new Consumers.Consumer<KeyValue>(){

                @Override
                public void consume(KeyValue kv) {
                    consumer.addKeyValueMetaData(kv);
                }
            }))).onField(FileMetaData._Fields.CREATED_BY, new TypedConsumer.StringConsumer(){

                @Override
                public void consume(String value) {
                    consumer.setCreatedBy(value);
                }
            }).onField(FileMetaData._Fields.ENCRYPTION_ALGORITHM, Consumers.struct(EncryptionAlgorithm.class, new Consumers.Consumer<EncryptionAlgorithm>(){

                @Override
                public void consume(EncryptionAlgorithm encryptionAlgorithm) {
                    consumer.setEncryptionAlgorithm(encryptionAlgorithm);
                }
            })).onField(FileMetaData._Fields.FOOTER_SIGNING_KEY_METADATA, new TypedConsumer.StringConsumer(){

                @Override
                public void consume(String value) {
                    byte[] keyMetadata = value.getBytes(StandardCharsets.UTF_8);
                    consumer.setFooterSigningKeyMetadata(keyMetadata);
                }
            });
            if (!skipRowGroups) {
                eventConsumer = eventConsumer.onField(FileMetaData._Fields.ROW_GROUPS, Consumers.listElementsOf(Consumers.struct(RowGroup.class, new Consumers.Consumer<RowGroup>(){

                    @Override
                    public void consume(RowGroup rowGroup) {
                        consumer.addRowGroup(rowGroup);
                    }
                })));
            }
            if (null == decryptor) {
                from = input;
            } else {
                byte[] plainText = decryptor.decrypt(input, AAD);
                from = new ByteArrayInputStream(plainText);
            }
            new EventBasedThriftReader(Util.protocol(from)).readStruct(eventConsumer);
        }
        catch (TException e) {
            throw new IOException("can not read FileMetaData: " + e.getMessage(), e);
        }
    }

    private static TProtocol protocol(OutputStream to) throws TTransportException {
        return Util.protocol(new TIOStreamTransport(to));
    }

    private static TProtocol protocol(InputStream from) throws TTransportException {
        return Util.protocol(new TIOStreamTransport(from));
    }

    private static InterningProtocol protocol(TIOStreamTransport t) {
        return new InterningProtocol(new TCompactProtocol(t));
    }

    private static <T extends TBase<?, ?>> T read(InputStream input, T tbase, BlockCipher.Decryptor decryptor, byte[] AAD) throws IOException {
        InputStream from;
        if (null == decryptor) {
            from = input;
        } else {
            byte[] plainText = decryptor.decrypt(input, AAD);
            from = new ByteArrayInputStream(plainText);
        }
        try {
            tbase.read(Util.protocol(from));
            return tbase;
        }
        catch (TException e) {
            throw new IOException("can not read " + tbase.getClass() + ": " + e.getMessage(), e);
        }
    }

    private static void write(TBase<?, ?> tbase, OutputStream to, BlockCipher.Encryptor encryptor, byte[] AAD) throws IOException {
        if (null == encryptor) {
            try {
                tbase.write(Util.protocol(to));
                return;
            }
            catch (TException e) {
                throw new IOException("can not write " + tbase, e);
            }
        }
        try (TMemoryBuffer thriftMemoryBuffer = new TMemoryBuffer(100);){
            tbase.write(new InterningProtocol(new TCompactProtocol(thriftMemoryBuffer)));
            byte[] encryptedBuffer = encryptor.encrypt(thriftMemoryBuffer.getArray(), AAD);
            to.write(encryptedBuffer);
        }
        catch (TException e) {
            throw new IOException("can not write " + tbase, e);
        }
    }

    public static final class DefaultFileMetaDataConsumer
    extends FileMetaDataConsumer {
        private final FileMetaData md;

        public DefaultFileMetaDataConsumer(FileMetaData md) {
            this.md = md;
        }

        @Override
        public void setVersion(int version) {
            this.md.setVersion(version);
        }

        @Override
        public void setSchema(List<SchemaElement> schema) {
            this.md.setSchema(schema);
        }

        @Override
        public void setNumRows(long numRows) {
            this.md.setNum_rows(numRows);
        }

        @Override
        public void setCreatedBy(String createdBy) {
            this.md.setCreated_by(createdBy);
        }

        @Override
        public void addRowGroup(RowGroup rowGroup) {
            this.md.addToRow_groups(rowGroup);
        }

        @Override
        public void addKeyValueMetaData(KeyValue kv) {
            this.md.addToKey_value_metadata(kv);
        }

        @Override
        public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.md.setEncryption_algorithm(encryptionAlgorithm);
        }

        @Override
        public void setFooterSigningKeyMetadata(byte[] footerSigningKeyMetadata) {
            this.md.setFooter_signing_key_metadata(footerSigningKeyMetadata);
        }
    }

    public static abstract class FileMetaDataConsumer {
        public abstract void setVersion(int var1);

        public abstract void setSchema(List<SchemaElement> var1);

        public abstract void setNumRows(long var1);

        public abstract void addRowGroup(RowGroup var1);

        public abstract void addKeyValueMetaData(KeyValue var1);

        public abstract void setCreatedBy(String var1);

        public abstract void setEncryptionAlgorithm(EncryptionAlgorithm var1);

        public abstract void setFooterSigningKeyMetadata(byte[] var1);
    }
}

