/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Collections;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.statistics.TruncateSimpleColStatsCollector;
import org.apache.paimon.table.SpecialFields;

public class StatsCollectorFactories {
    public static SimpleColStatsCollector.Factory[] createStatsFactories(String statsMode, CoreOptions options, List<String> fields) {
        return StatsCollectorFactories.createStatsFactories(statsMode, options, fields, Collections.emptyList());
    }

    public static SimpleColStatsCollector.Factory[] createStatsFactories(String statsMode, CoreOptions coreOptions, List<String> fields, List<String> keyNames) {
        Options options = coreOptions.toConfiguration();
        SimpleColStatsCollector.Factory[] modes = new SimpleColStatsCollector.Factory[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            String fieldMode = StatsCollectorFactories.fieldMode(options, field);
            modes[i] = fieldMode != null ? SimpleColStatsCollector.from(fieldMode) : (SpecialFields.isSystemField(field) || keyNames.contains("_KEY_" + field) ? () -> new TruncateSimpleColStatsCollector(128) : SimpleColStatsCollector.from(statsMode));
        }
        return modes;
    }

    public static SimpleColStatsCollector.Factory[] createStatsFactoriesForAvro(String statsMode, CoreOptions coreOptions, List<String> fields) {
        Options options = coreOptions.toConfiguration();
        SimpleColStatsCollector.Factory[] modes = new SimpleColStatsCollector.Factory[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            String fieldMode = StatsCollectorFactories.fieldMode(options, field);
            modes[i] = fieldMode != null ? SimpleColStatsCollector.from(fieldMode) : SimpleColStatsCollector.from(statsMode);
        }
        return modes;
    }

    private static String fieldMode(Options options, String field) {
        return options.get(ConfigOptions.key(String.format("%s.%s.%s", "fields", field, "stats-mode")).stringType().noDefaultValue());
    }
}

