/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.fileindex.FileIndexPredicate;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.operation.BucketSelectConverter;
import org.apache.paimon.operation.ManifestsReader;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.SimpleStatsEvolution;
import org.apache.paimon.stats.SimpleStatsEvolutions;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class AppendOnlyFileStoreScan
extends AbstractFileStoreScan {
    private final BucketSelectConverter bucketSelectConverter;
    private final SimpleStatsEvolutions simpleStatsEvolutions;
    private final boolean fileIndexReadEnabled;
    private Predicate filter;
    private final Map<Long, Predicate> dataFilterMapping = new HashMap<Long, Predicate>();

    public AppendOnlyFileStoreScan(ManifestsReader manifestsReader, BucketSelectConverter bucketSelectConverter, SnapshotManager snapshotManager, SchemaManager schemaManager, TableSchema schema, ManifestFile.Factory manifestFileFactory, Integer scanManifestParallelism, boolean fileIndexReadEnabled) {
        super(manifestsReader, snapshotManager, schemaManager, schema, manifestFileFactory, scanManifestParallelism);
        this.bucketSelectConverter = bucketSelectConverter;
        this.simpleStatsEvolutions = new SimpleStatsEvolutions(sid -> this.scanTableSchema((long)sid).fields(), schema.id());
        this.fileIndexReadEnabled = fileIndexReadEnabled;
    }

    public AppendOnlyFileStoreScan withFilter(Predicate predicate) {
        this.filter = predicate;
        this.bucketSelectConverter.convert(predicate).ifPresent(this::withTotalAwareBucketFilter);
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        if (this.filter == null) {
            return true;
        }
        SimpleStatsEvolution evolution = this.simpleStatsEvolutions.getOrCreate(entry.file().schemaId());
        SimpleStatsEvolution.Result stats = evolution.evolution(entry.file().valueStats(), entry.file().rowCount(), entry.file().valueStatsCols());
        return this.filter.test(entry.file().rowCount(), stats.minValues(), stats.maxValues(), stats.nullCounts()) && (!this.fileIndexReadEnabled || this.testFileIndex(entry.file().embeddedIndex(), entry));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testFileIndex(@Nullable byte[] embeddedIndexBytes, ManifestEntry entry) {
        if (embeddedIndexBytes == null) {
            return true;
        }
        RowType dataRowType = this.scanTableSchema(entry.file().schemaId()).logicalRowType();
        Predicate dataPredicate = this.dataFilterMapping.computeIfAbsent(entry.file().schemaId(), id -> this.simpleStatsEvolutions.tryDevolveFilter(entry.file().schemaId(), this.filter));
        try (FileIndexPredicate predicate = new FileIndexPredicate(embeddedIndexBytes, dataRowType);){
            boolean bl = predicate.evaluate(dataPredicate).remain();
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception happens while checking predicate.", e);
        }
    }
}

