/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.compact.CompactUnit;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.RecordLevelExpire;
import org.apache.paimon.mergetree.LevelSortedRun;

public interface CompactStrategy {
    public Optional<CompactUnit> pick(int var1, List<LevelSortedRun> var2);

    public static Optional<CompactUnit> pickFullCompaction(int numLevels, List<LevelSortedRun> runs, @Nullable RecordLevelExpire recordLevelExpire) {
        int maxLevel = numLevels - 1;
        if (runs.isEmpty()) {
            return Optional.empty();
        }
        if (runs.size() == 1 && runs.get(0).level() == maxLevel) {
            if (recordLevelExpire == null) {
                return Optional.empty();
            }
            ArrayList<DataFileMeta> filesContainExpireRecords = new ArrayList<DataFileMeta>();
            for (DataFileMeta file : runs.get(0).run().files()) {
                if (!recordLevelExpire.isExpireFile(file)) continue;
                filesContainExpireRecords.add(file);
            }
            return Optional.of(CompactUnit.fromFiles(maxLevel, filesContainExpireRecords));
        }
        return Optional.of(CompactUnit.fromLevelRuns(maxLevel, runs));
    }
}

