/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.hive.objectinspector.WriteableObjectInspector;

public class PaimonTimestampObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements TimestampObjectInspector,
WriteableObjectInspector {
    public PaimonTimestampObjectInspector() {
        super(TypeInfoFactory.timestampTypeInfo);
    }

    public Timestamp getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        org.apache.paimon.data.Timestamp timestamp = (org.apache.paimon.data.Timestamp)o;
        long millis = timestamp.getMillisecond();
        int nanos = (int)(millis % 1000L * 1000000L) + timestamp.getNanoOfMillisecond();
        return Timestamp.ofEpochMilli((long)millis, (int)nanos);
    }

    public TimestampWritableV2 getPrimitiveWritableObject(Object o) {
        Timestamp ts = this.getPrimitiveJavaObject(o);
        return ts == null ? null : new TimestampWritableV2(ts);
    }

    public Object copyObject(Object o) {
        if (o instanceof org.apache.paimon.data.Timestamp) {
            return o;
        }
        if (o instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)o;
            return timestamp.clone();
        }
        return o;
    }

    @Override
    public org.apache.paimon.data.Timestamp convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            long epochMilli = ((Timestamp)value).toEpochMilli();
            int nanos = ((Timestamp)value).getNanos();
            int nanoOfMillisecond = nanos % 1000000;
            return org.apache.paimon.data.Timestamp.fromEpochMillis(epochMilli, nanoOfMillisecond);
        }
        return null;
    }
}

