/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.hive.objectinspector.PaimonObjectInspectorFactory;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.InternalRowUtils;

public class PaimonInternalRowObjectInspector
extends StructObjectInspector {
    private final List<PaimonStructField> structFields = new ArrayList<PaimonStructField>();
    private final Map<String, PaimonStructField> structFieldMap = new HashMap<String, PaimonStructField>();
    private final String typeName;

    public PaimonInternalRowObjectInspector(List<String> fieldNames, List<DataType> fieldTypes, List<String> fieldComments) {
        StringBuilder typeNameBuilder = new StringBuilder("struct<");
        for (int i = 0; i < fieldNames.size(); ++i) {
            String name = fieldNames.get(i);
            DataType logicalType = fieldTypes.get(i);
            PaimonStructField structField = new PaimonStructField(name, PaimonObjectInspectorFactory.create(logicalType), i, InternalRowUtils.createNullCheckingFieldGetter(logicalType, i), fieldComments.get(i));
            this.structFields.add(structField);
            this.structFieldMap.put(name, structField);
            if (i > 0) {
                typeNameBuilder.append(",");
            }
            typeNameBuilder.append(name).append(":").append(HiveTypeUtils.toTypeInfo(logicalType).getTypeName());
        }
        typeNameBuilder.append(">");
        this.typeName = typeNameBuilder.toString();
    }

    public List<? extends StructField> getAllStructFieldRefs() {
        return this.structFields;
    }

    public StructField getStructFieldRef(String name) {
        return this.structFieldMap.get(name);
    }

    public Object getStructFieldData(Object o, StructField structField) {
        InternalRow internalRow = (InternalRow)o;
        return ((PaimonStructField)structField).fieldGetter.getFieldOrNull(internalRow);
    }

    public List<Object> getStructFieldsDataAsList(Object o) {
        InternalRow internalRow = (InternalRow)o;
        return this.structFields.stream().map(f -> ((PaimonStructField)f).fieldGetter.getFieldOrNull(internalRow)).collect(Collectors.toList());
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    private static class PaimonStructField
    implements StructField {
        private final String name;
        private final ObjectInspector objectInspector;
        private final int idx;
        private final InternalRow.FieldGetter fieldGetter;
        private final String comment;

        private PaimonStructField(String name, ObjectInspector objectInspector, int idx, InternalRow.FieldGetter fieldGetter, String comment) {
            this.name = name;
            this.objectInspector = objectInspector;
            this.idx = idx;
            this.fieldGetter = fieldGetter;
            this.comment = comment;
        }

        public String getFieldName() {
            return this.name;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.objectInspector;
        }

        public int getFieldID() {
            return this.idx;
        }

        public String getFieldComment() {
            return this.comment;
        }
    }
}

