/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.paimon.hive.HiveDeserializer;
import org.apache.paimon.hive.HiveSchema;
import org.apache.paimon.hive.RowDataContainer;
import org.apache.paimon.hive.objectinspector.PaimonInternalRowObjectInspector;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.JsonSerdeUtil;

public class PaimonSerDe
extends AbstractSerDe {
    private PaimonInternalRowObjectInspector inspector;
    private HiveSchema tableSchema;
    private final RowDataContainer rowData = new RowDataContainer();
    private final Map<ObjectInspector, HiveDeserializer> deserializers = Maps.newHashMapWithExpectedSize(1);

    public void initialize(@Nullable Configuration configuration, Properties properties) throws SerDeException {
        String dataFieldStr = properties.getProperty("paimon.table.fields");
        if (dataFieldStr != null) {
            List<DataField> dataFields = JsonSerdeUtil.fromJson(dataFieldStr, new TypeReference<List<DataField>>(){});
            this.tableSchema = new HiveSchema(new RowType(dataFields));
        } else {
            this.tableSchema = HiveSchema.extract(configuration, properties);
        }
        this.inspector = new PaimonInternalRowObjectInspector(this.tableSchema.fieldNames(), this.tableSchema.fieldTypes(), this.tableSchema.fieldComments());
    }

    public Class<? extends Writable> getSerializedClass() {
        return RowDataContainer.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        HiveDeserializer deserializer = this.deserializers.get(objectInspector);
        if (deserializer == null) {
            deserializer = new HiveDeserializer.Builder().schema(this.tableSchema).sourceInspector((StructObjectInspector)objectInspector).writerInspector(this.inspector).build();
            this.deserializers.put(objectInspector, deserializer);
        }
        this.rowData.set(deserializer.deserialize(o));
        return this.rowData;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        return ((RowDataContainer)writable).get();
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }
}

