/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.paimon.factories.Factory;
import org.apache.paimon.factories.FactoryException;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FactoryUtil.class);
    private static final Cache<ClassLoader, List<Factory>> FACTORIES = Caffeine.newBuilder().softValues().maximumSize(100L).executor(Runnable::run).build();

    public static <T extends Factory> T discoverFactory(ClassLoader classLoader, Class<T> factoryClass, String identifier) {
        List<Factory> factories = FactoryUtil.getFactories(classLoader);
        List foundFactories = factories.stream().filter(f -> factoryClass.isAssignableFrom(f.getClass())).collect(Collectors.toList());
        if (foundFactories.isEmpty()) {
            throw new FactoryException(String.format("Could not find any factories that implement '%s' in the classpath.", factoryClass.getName()));
        }
        List matchingFactories = foundFactories.stream().filter(f -> f.identifier().equals(identifier)).collect(Collectors.toList());
        if (matchingFactories.isEmpty()) {
            throw new FactoryException(String.format("Could not find any factory for identifier '%s' that implements '%s' in the classpath.\n\nAvailable factory identifiers are:\n\n%s", identifier, factoryClass.getName(), foundFactories.stream().map(Factory::identifier).collect(Collectors.joining("\n"))));
        }
        if (matchingFactories.size() > 1) {
            throw new FactoryException(String.format("Multiple factories for identifier '%s' that implement '%s' found in the classpath.\n\nAmbiguous factory classes are:\n\n%s", identifier, factoryClass.getName(), matchingFactories.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        return (T)((Factory)matchingFactories.get(0));
    }

    public static <T extends Factory> List<String> discoverIdentifiers(ClassLoader classLoader, Class<T> factoryClass) {
        List<Factory> factories = FactoryUtil.getFactories(classLoader);
        return factories.stream().filter(f -> factoryClass.isAssignableFrom(f.getClass())).map(Factory::identifier).collect(Collectors.toList());
    }

    private static List<Factory> getFactories(ClassLoader classLoader) {
        return FACTORIES.get(classLoader, s -> FactoryUtil.discoverFactories(classLoader, Factory.class));
    }

    public static <T> List<T> discoverFactories(ClassLoader classLoader, Class<T> klass) {
        Iterator<T> serviceLoaderIterator = ServiceLoader.load(klass, classLoader).iterator();
        ArrayList<T> loadResults = new ArrayList<T>();
        while (true) {
            try {
                while (serviceLoaderIterator.hasNext()) {
                    loadResults.add(serviceLoaderIterator.next());
                }
            }
            catch (Throwable t) {
                if (t instanceof NoClassDefFoundError) {
                    LOG.debug("NoClassDefFoundError when loading a {}. This is expected when trying to load factory but no implementation is loaded.", (Object)Factory.class.getCanonicalName(), (Object)t);
                    continue;
                }
                throw new RuntimeException("Unexpected error when trying to load service provider.", t);
            }
            break;
        }
        return loadResults;
    }
}

