/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorIndexFileWriter;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFile;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.Preconditions;

public class DeletionVectorsIndexFile
extends IndexFile {
    public static final String DELETION_VECTORS_INDEX = "DELETION_VECTORS";
    public static final byte VERSION_ID_V1 = 1;
    private final MemorySize targetSizePerIndexFile;

    public DeletionVectorsIndexFile(FileIO fileIO, PathFactory pathFactory, MemorySize targetSizePerIndexFile) {
        super(fileIO, pathFactory);
        this.targetSizePerIndexFile = targetSizePerIndexFile;
    }

    public Map<String, DeletionVector> readAllDeletionVectors(IndexFileMeta fileMeta) {
        LinkedHashMap<String, DeletionVectorMeta> deletionVectorMetas = fileMeta.deletionVectorMetas();
        Preconditions.checkNotNull(deletionVectorMetas);
        String indexFileName = fileMeta.fileName();
        HashMap<String, DeletionVector> deletionVectors = new HashMap<String, DeletionVector>();
        Path filePath = this.pathFactory.toPath(indexFileName);
        try (SeekableInputStream inputStream2 = this.fileIO.newInputStream(filePath);){
            this.checkVersion(inputStream2);
            DataInputStream dataInputStream = new DataInputStream(inputStream2);
            for (DeletionVectorMeta deletionVectorMeta : deletionVectorMetas.values()) {
                deletionVectors.put(deletionVectorMeta.dataFileName(), this.readDeletionVector(dataInputStream, deletionVectorMeta.length()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read deletion vectors from file: " + filePath + ", deletionVectorMetas: " + deletionVectorMetas, e);
        }
        return deletionVectors;
    }

    public Map<String, DeletionVector> readAllDeletionVectors(List<IndexFileMeta> indexFiles) {
        HashMap<String, DeletionVector> deletionVectors = new HashMap<String, DeletionVector>();
        indexFiles.forEach(indexFile -> deletionVectors.putAll(this.readAllDeletionVectors((IndexFileMeta)indexFile)));
        return deletionVectors;
    }

    public Map<String, DeletionVector> readDeletionVector(Map<String, DeletionFile> dataFileToDeletionFiles) {
        HashMap<String, DeletionVector> deletionVectors = new HashMap<String, DeletionVector>();
        if (dataFileToDeletionFiles.isEmpty()) {
            return deletionVectors;
        }
        String indexFile = dataFileToDeletionFiles.values().stream().findAny().get().path();
        try (SeekableInputStream inputStream2 = this.fileIO.newInputStream(new Path(indexFile));){
            this.checkVersion(inputStream2);
            for (String dataFile : dataFileToDeletionFiles.keySet()) {
                DeletionFile deletionFile = dataFileToDeletionFiles.get(dataFile);
                Preconditions.checkArgument(deletionFile.path().equals(indexFile));
                inputStream2.seek(deletionFile.offset());
                DataInputStream dataInputStream = new DataInputStream(inputStream2);
                deletionVectors.put(dataFile, this.readDeletionVector(dataInputStream, (int)deletionFile.length()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read deletion vector from file: " + indexFile, e);
        }
        return deletionVectors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeletionVector readDeletionVector(DeletionFile deletionFile) {
        String indexFile = deletionFile.path();
        try (SeekableInputStream inputStream2 = this.fileIO.newInputStream(new Path(indexFile));){
            this.checkVersion(inputStream2);
            Preconditions.checkArgument(deletionFile.path().equals(indexFile));
            inputStream2.seek(deletionFile.offset());
            DataInputStream dataInputStream = new DataInputStream(inputStream2);
            DeletionVector deletionVector = this.readDeletionVector(dataInputStream, (int)deletionFile.length());
            return deletionVector;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read deletion vector from file: " + indexFile, e);
        }
    }

    public List<IndexFileMeta> write(Map<String, DeletionVector> input) {
        try {
            DeletionVectorIndexFileWriter writer = new DeletionVectorIndexFileWriter(this.fileIO, this.pathFactory, this.targetSizePerIndexFile);
            return writer.write(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write deletion vectors.", e);
        }
    }

    private void checkVersion(InputStream in) throws IOException {
        int version = in.read();
        if (version != 1) {
            throw new RuntimeException("Version not match, actual version: " + version + ", expert version: " + 1);
        }
    }

    private DeletionVector readDeletionVector(DataInputStream inputStream2, int size) {
        try {
            int actualSize = inputStream2.readInt();
            if (actualSize != size) {
                throw new RuntimeException("Size not match, actual size: " + actualSize + ", expected size: " + size);
            }
            byte[] bytes = new byte[size];
            inputStream2.readFully(bytes);
            int checkSum = DeletionVectorsIndexFile.calculateChecksum(bytes);
            int actualCheckSum = inputStream2.readInt();
            if (actualCheckSum != checkSum) {
                throw new RuntimeException("Checksum not match, actual checksum: " + actualCheckSum + ", expected checksum: " + checkSum);
            }
            return DeletionVector.deserializeFromBytes(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read deletion vector", e);
        }
    }

    public static int calculateChecksum(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.update(bytes);
        return (int)crc.getValue();
    }
}

