/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.List;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.SnapshotCommit;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.utils.SnapshotManager;

public class CatalogSnapshotCommit
implements SnapshotCommit {
    private final Catalog catalog;
    private final Identifier identifier;

    public CatalogSnapshotCommit(Catalog catalog, Identifier identifier) {
        this.catalog = catalog;
        this.identifier = identifier;
    }

    @Override
    public boolean commit(Snapshot snapshot, String branch, List<PartitionStatistics> statistics) throws Exception {
        Identifier newIdentifier = new Identifier(this.identifier.getDatabaseName(), this.identifier.getTableName(), branch);
        return this.catalog.commitSnapshot(newIdentifier, snapshot, statistics);
    }

    @Override
    public void close() throws Exception {
        this.catalog.close();
    }

    public static class Factory
    implements SnapshotCommit.Factory {
        private static final long serialVersionUID = 1L;
        private final CatalogLoader catalogLoader;

        public Factory(CatalogLoader catalogLoader) {
            this.catalogLoader = catalogLoader;
        }

        @Override
        public SnapshotCommit create(Identifier identifier, SnapshotManager snapshotManager) {
            return new CatalogSnapshotCommit(this.catalogLoader.load(), identifier);
        }
    }
}

