/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.RenamingSnapshotCommit;
import org.apache.paimon.catalog.SnapshotCommit;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.DeletionVectorsIndexFile;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.iceberg.IcebergCommitCallback;
import org.apache.paimon.iceberg.IcebergOptions;
import org.apache.paimon.index.HashIndexFile;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.IndexManifestFile;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.metastore.AddPartitionCommitCallback;
import org.apache.paimon.metastore.AddPartitionTagCallback;
import org.apache.paimon.metastore.TagPreviewCommitCallback;
import org.apache.paimon.operation.ChangelogDeletion;
import org.apache.paimon.operation.FileStoreCommitImpl;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.operation.ManifestsReader;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.operation.SnapshotDeletion;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.partition.PartitionExpireStrategy;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.service.ServiceManager;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.stats.StatsFile;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.PartitionHandler;
import org.apache.paimon.table.sink.CallbackUtils;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.tag.SuccessFileTagCallback;
import org.apache.paimon.tag.TagAutoManager;
import org.apache.paimon.tag.TagPreview;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

abstract class AbstractFileStore<T>
implements FileStore<T> {
    protected final FileIO fileIO;
    protected final SchemaManager schemaManager;
    protected final TableSchema schema;
    protected final String tableName;
    protected final CoreOptions options;
    protected final RowType partitionType;
    protected final CatalogEnvironment catalogEnvironment;
    @Nullable
    private final SegmentsCache<Path> writeManifestCache;
    @Nullable
    private SegmentsCache<Path> readManifestCache;
    @Nullable
    private Cache<Path, Snapshot> snapshotCache;

    protected AbstractFileStore(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, String tableName, CoreOptions options, RowType partitionType, CatalogEnvironment catalogEnvironment) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schema = schema;
        this.tableName = tableName;
        this.options = options;
        this.partitionType = partitionType;
        this.catalogEnvironment = catalogEnvironment;
        this.writeManifestCache = SegmentsCache.create(options.pageSize(), options.writeManifestCache(), Long.MAX_VALUE);
    }

    @Override
    public FileStorePathFactory pathFactory() {
        return this.pathFactory(this.options, this.options.fileFormatString());
    }

    protected FileStorePathFactory pathFactory(CoreOptions options, String format) {
        return new FileStorePathFactory(options.path(), this.partitionType, options.partitionDefaultName(), format, options.dataFilePrefix(), options.changelogFilePrefix(), options.legacyPartitionName(), options.fileSuffixIncludeCompression(), options.fileCompression(), options.dataFilePathDirectory(), this.createExternalPaths());
    }

    private List<Path> createExternalPaths() {
        String externalPaths = this.options.dataFileExternalPaths();
        CoreOptions.ExternalPathStrategy strategy = this.options.externalPathStrategy();
        if (externalPaths == null || externalPaths.isEmpty() || strategy == CoreOptions.ExternalPathStrategy.NONE) {
            return Collections.emptyList();
        }
        String specificFS = this.options.externalSpecificFS();
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String pathString : externalPaths.split(",")) {
            Path path = new Path(pathString.trim());
            String scheme = path.toUri().getScheme();
            if (scheme == null) {
                throw new IllegalArgumentException("scheme should not be null: " + path);
            }
            if (strategy == CoreOptions.ExternalPathStrategy.SPECIFIC_FS) {
                Preconditions.checkArgument(specificFS != null, "External path specificFS should not be null when strategy is specificFS.");
                if (!scheme.equalsIgnoreCase(specificFS)) continue;
                paths.add(path);
                continue;
            }
            paths.add(path);
        }
        Preconditions.checkArgument(!paths.isEmpty(), "External paths should not be empty");
        return paths;
    }

    @Override
    public SnapshotManager snapshotManager() {
        return new SnapshotManager(this.fileIO, this.options.path(), this.options.branch(), this.catalogEnvironment.snapshotLoader(), this.snapshotCache);
    }

    @Override
    public ChangelogManager changelogManager() {
        return new ChangelogManager(this.fileIO, this.options.path(), this.options.branch());
    }

    @Override
    public ManifestFile.Factory manifestFileFactory() {
        return this.manifestFileFactory(false);
    }

    protected ManifestFile.Factory manifestFileFactory(boolean forWrite) {
        return new ManifestFile.Factory(this.fileIO, this.schemaManager, this.partitionType, this.options.manifestFormat(), this.options.manifestCompression(), this.pathFactory(), this.options.manifestTargetSize().getBytes(), forWrite ? this.writeManifestCache : this.readManifestCache);
    }

    @Override
    public ManifestList.Factory manifestListFactory() {
        return this.manifestListFactory(false);
    }

    protected ManifestList.Factory manifestListFactory(boolean forWrite) {
        return new ManifestList.Factory(this.fileIO, this.options.manifestFormat(), this.options.manifestCompression(), this.pathFactory(), forWrite ? this.writeManifestCache : this.readManifestCache);
    }

    @Override
    public IndexManifestFile.Factory indexManifestFileFactory() {
        return new IndexManifestFile.Factory(this.fileIO, this.options.manifestFormat(), this.options.manifestCompression(), this.pathFactory(), this.readManifestCache);
    }

    @Override
    public IndexFileHandler newIndexFileHandler() {
        return new IndexFileHandler(this.snapshotManager(), this.pathFactory().indexFileFactory(), this.indexManifestFileFactory().create(), new HashIndexFile(this.fileIO, this.pathFactory().indexFileFactory()), new DeletionVectorsIndexFile(this.fileIO, this.pathFactory().indexFileFactory(), this.bucketMode() == BucketMode.BUCKET_UNAWARE ? this.options.deletionVectorIndexFileTargetSize() : MemorySize.ofBytes(Long.MAX_VALUE)));
    }

    @Override
    public StatsFileHandler newStatsFileHandler() {
        return new StatsFileHandler(this.snapshotManager(), this.schemaManager, new StatsFile(this.fileIO, this.pathFactory().statsFileFactory()));
    }

    protected ManifestsReader newManifestsReader(boolean forWrite) {
        return new ManifestsReader(this.partitionType, this.options.partitionDefaultName(), this.snapshotManager(), this.manifestListFactory(forWrite));
    }

    @Override
    public RowType partitionType() {
        return this.partitionType;
    }

    @Override
    public CoreOptions options() {
        return this.options;
    }

    @Override
    public boolean mergeSchema(RowType rowType, boolean allowExplicitCast) {
        return this.schemaManager.mergeSchema(rowType, allowExplicitCast);
    }

    protected abstract FileStoreScan newScan(ScanType var1);

    @Override
    public FileStoreCommitImpl newCommit(String commitUser, FileStoreTable table) {
        SnapshotManager snapshotManager = this.snapshotManager();
        SnapshotCommit snapshotCommit = this.catalogEnvironment.snapshotCommit(snapshotManager);
        if (snapshotCommit == null) {
            snapshotCommit = new RenamingSnapshotCommit(snapshotManager, Lock.empty());
        }
        return new FileStoreCommitImpl(snapshotCommit, this.fileIO, this.schemaManager, this.tableName, commitUser, this.partitionType, this.options, this.options.partitionDefaultName(), this.pathFactory(), snapshotManager, this.manifestFileFactory(), this.manifestListFactory(), this.indexManifestFileFactory(), this.newScan(ScanType.FOR_COMMIT), this.options.bucket(), this.options.manifestTargetSize(), this.options.manifestFullCompactionThresholdSize(), this.options.manifestMergeMinCount(), this.partitionType.getFieldCount() > 0 && this.options.dynamicPartitionOverwrite(), this.newKeyComparator(), this.options.branch(), this.newStatsFileHandler(), this.bucketMode(), this.options.scanManifestParallelism(), this.createCommitCallbacks(commitUser, table), this.options.commitMaxRetries(), this.options.commitTimeout());
    }

    @Override
    public SnapshotDeletion newSnapshotDeletion() {
        return new SnapshotDeletion(this.fileIO, this.pathFactory(), this.manifestFileFactory().create(), this.manifestListFactory().create(), this.newIndexFileHandler(), this.newStatsFileHandler(), this.options.changelogProducer() != CoreOptions.ChangelogProducer.NONE, this.options.cleanEmptyDirectories(), this.options.deleteFileThreadNum());
    }

    @Override
    public ChangelogDeletion newChangelogDeletion() {
        return new ChangelogDeletion(this.fileIO, this.pathFactory(), this.manifestFileFactory().create(), this.manifestListFactory().create(), this.newIndexFileHandler(), this.newStatsFileHandler(), this.options.cleanEmptyDirectories(), this.options.deleteFileThreadNum());
    }

    @Override
    public TagManager newTagManager() {
        return new TagManager(this.fileIO, this.options.path());
    }

    @Override
    public TagDeletion newTagDeletion() {
        return new TagDeletion(this.fileIO, this.pathFactory(), this.manifestFileFactory().create(), this.manifestListFactory().create(), this.newIndexFileHandler(), this.newStatsFileHandler(), this.options.cleanEmptyDirectories(), this.options.deleteFileThreadNum());
    }

    public abstract Comparator<InternalRow> newKeyComparator();

    private List<CommitCallback> createCommitCallbacks(String commitUser, FileStoreTable table) {
        PartitionHandler partitionHandler;
        PartitionHandler partitionHandler2;
        ArrayList<CommitCallback> callbacks = new ArrayList<CommitCallback>(CallbackUtils.loadCommitCallbacks(this.options));
        if (this.options.partitionedTableInMetastore() && !this.schema.partitionKeys().isEmpty() && (partitionHandler2 = this.catalogEnvironment.partitionHandler()) != null) {
            InternalRowPartitionComputer partitionComputer = new InternalRowPartitionComputer(this.options.partitionDefaultName(), this.schema.logicalPartitionType(), this.schema.partitionKeys().toArray(new String[0]), this.options.legacyPartitionName());
            callbacks.add(new AddPartitionCommitCallback(partitionHandler2, partitionComputer));
        }
        TagPreview tagPreview = TagPreview.create(this.options);
        if (this.options.tagToPartitionField() != null && tagPreview != null && this.schema.partitionKeys().isEmpty() && (partitionHandler = this.catalogEnvironment.partitionHandler()) != null) {
            TagPreviewCommitCallback callback = new TagPreviewCommitCallback(new AddPartitionTagCallback(partitionHandler, this.options.tagToPartitionField()), tagPreview);
            callbacks.add(callback);
        }
        if (this.options.toConfiguration().get(IcebergOptions.METADATA_ICEBERG_STORAGE) != IcebergOptions.StorageType.DISABLED) {
            callbacks.add(new IcebergCommitCallback(table, commitUser));
        }
        return callbacks;
    }

    @Override
    @Nullable
    public PartitionExpire newPartitionExpire(String commitUser, FileStoreTable table) {
        Duration partitionExpireTime = this.options.partitionExpireTime();
        if (partitionExpireTime == null || this.partitionType().getFieldCount() == 0) {
            return null;
        }
        return this.newPartitionExpire(commitUser, table, partitionExpireTime, this.options.partitionExpireCheckInterval(), PartitionExpireStrategy.createPartitionExpireStrategy(this.options, this.partitionType()));
    }

    @Override
    public PartitionExpire newPartitionExpire(String commitUser, FileStoreTable table, Duration expirationTime, Duration checkInterval, PartitionExpireStrategy expireStrategy) {
        PartitionHandler partitionHandler = null;
        if (this.options.partitionedTableInMetastore()) {
            partitionHandler = this.catalogEnvironment.partitionHandler();
        }
        return new PartitionExpire(expirationTime, checkInterval, expireStrategy, this.newScan(ScanType.FOR_COMMIT), this.newCommit(commitUser, table), partitionHandler, this.options.endInputCheckPartitionExpire(), this.options.partitionExpireMaxNum());
    }

    @Override
    public TagAutoManager newTagCreationManager() {
        return TagAutoManager.create(this.options, this.snapshotManager(), this.newTagManager(), this.newTagDeletion(), this.createTagCallbacks());
    }

    @Override
    public List<TagCallback> createTagCallbacks() {
        PartitionHandler partitionHandler;
        ArrayList<TagCallback> callbacks = new ArrayList<TagCallback>(CallbackUtils.loadTagCallbacks(this.options));
        String partitionField = this.options.tagToPartitionField();
        if (partitionField != null && (partitionHandler = this.catalogEnvironment.partitionHandler()) != null) {
            callbacks.add(new AddPartitionTagCallback(partitionHandler, partitionField));
        }
        if (this.options.tagCreateSuccessFile()) {
            callbacks.add(new SuccessFileTagCallback(this.fileIO, this.newTagManager().tagDirectory()));
        }
        return callbacks;
    }

    @Override
    public ServiceManager newServiceManager() {
        return new ServiceManager(this.fileIO, this.options.path());
    }

    @Override
    public void setManifestCache(SegmentsCache<Path> manifestCache) {
        this.readManifestCache = manifestCache;
    }

    @Override
    public void setSnapshotCache(Cache<Path, Snapshot> cache) {
        this.snapshotCache = cache;
    }

    protected static enum ScanType {
        FOR_READ,
        FOR_WRITE,
        FOR_COMMIT;

    }
}

