/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.operation.metrics.CacheMetrics;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.ObjectsCache;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.SimpleFileReader;

public class ObjectsFile<T>
implements SimpleFileReader<T> {
    protected final FileIO fileIO;
    protected final ObjectSerializer<T> serializer;
    protected final FormatReaderFactory readerFactory;
    protected final FormatWriterFactory writerFactory;
    protected final String compression;
    protected final PathFactory pathFactory;
    @Nullable
    private final ObjectsCache<Path, T> cache;

    public ObjectsFile(FileIO fileIO, ObjectSerializer<T> serializer, RowType formatType, FormatReaderFactory readerFactory, FormatWriterFactory writerFactory, String compression, PathFactory pathFactory, @Nullable SegmentsCache<Path> cache) {
        this.fileIO = fileIO;
        this.serializer = serializer;
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.compression = compression;
        this.pathFactory = pathFactory;
        this.cache = cache == null ? null : new ObjectsCache<Path, T>(cache, serializer, formatType, this::fileSize, this::createIterator);
    }

    public ObjectsFile<T> withCacheMetrics(@Nullable CacheMetrics cacheMetrics) {
        if (this.cache != null) {
            this.cache.withCacheMetrics(cacheMetrics);
        }
        return this;
    }

    public FileIO fileIO() {
        return this.fileIO;
    }

    public long fileSize(String fileName) {
        try {
            return this.fileIO.getFileSize(this.pathFactory.toPath(fileName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public List<T> read(String fileName) {
        return this.read(fileName, null);
    }

    public List<T> read(String fileName, @Nullable Long fileSize) {
        return this.read(fileName, fileSize, (Filter<InternalRow>)Filter.alwaysTrue(), (Filter<InternalRow>)Filter.alwaysTrue(), Filter.alwaysTrue());
    }

    public List<T> readWithIOException(String fileName) throws IOException {
        return this.readWithIOException(fileName, null);
    }

    public List<T> readWithIOException(String fileName, @Nullable Long fileSize) throws IOException {
        return this.readWithIOException(fileName, fileSize, (Filter<InternalRow>)Filter.alwaysTrue(), (Filter<InternalRow>)Filter.alwaysTrue(), Filter.alwaysTrue());
    }

    public boolean exists(String fileName) {
        try {
            return this.fileIO.exists(this.pathFactory.toPath(fileName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<T> read(String fileName, @Nullable Long fileSize, Filter<InternalRow> loadFilter, Filter<InternalRow> readFilter, Filter<T> readTFilter) {
        try {
            return this.readWithIOException(fileName, fileSize, loadFilter, readFilter, readTFilter);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + fileName, e);
        }
    }

    private List<T> readWithIOException(String fileName, @Nullable Long fileSize, Filter<InternalRow> loadFilter, Filter<InternalRow> readFilter, Filter<T> readTFilter) throws IOException {
        Path path = this.pathFactory.toPath(fileName);
        if (this.cache != null) {
            return this.cache.read(path, fileSize, loadFilter, readFilter, readTFilter);
        }
        return ObjectsFile.readFromIterator(this.createIterator(path, fileSize), this.serializer, readFilter, readTFilter);
    }

    public String writeWithoutRolling(Collection<T> records) {
        return (String)this.writeWithoutRolling(records.iterator()).getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<String, Long> writeWithoutRolling(Iterator<T> records) {
        Path path = this.pathFactory.newPath();
        try {
            long pos;
            PositionOutputStream out = this.fileIO.newOutputStream(path, false);
            try (FormatWriter writer = this.writerFactory.create(out, this.compression);){
                while (records.hasNext()) {
                    writer.addElement(this.serializer.toRow(records.next()));
                }
            }
            finally {
                pos = out.getPos();
                out.close();
            }
            return Pair.of((Object)path.getName(), (Object)pos);
        }
        catch (Throwable e) {
            this.fileIO.deleteQuietly(path);
            throw new RuntimeException("Exception occurs when writing records to " + path + ". Clean up.", e);
        }
    }

    private CloseableIterator<InternalRow> createIterator(Path file, @Nullable Long fileSize) throws IOException {
        return FileUtils.createFormatReader(this.fileIO, this.readerFactory, file, fileSize).toCloseableIterator();
    }

    private long fileSize(Path file) throws IOException {
        try {
            return this.fileIO.getFileSize(file);
        }
        catch (IOException e) {
            FileUtils.checkExists(this.fileIO, file);
            throw e;
        }
    }

    public void delete(String fileName) {
        this.fileIO.deleteQuietly(this.pathFactory.toPath(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <V> List<V> readFromIterator(CloseableIterator<InternalRow> inputIterator, ObjectSerializer<V> serializer, Filter<InternalRow> readFilter, Filter<V> readVFilter) {
        try (CloseableIterator<InternalRow> iterator2 = inputIterator;){
            ArrayList<V> result = new ArrayList<V>();
            while (iterator2.hasNext()) {
                V v;
                InternalRow row = (InternalRow)iterator2.next();
                if (!readFilter.test((Object)row) || !readVFilter.test(v = serializer.fromRow(row))) continue;
                result.add(v);
            }
            ArrayList<V> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

