/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.reader.PackChangelogReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.system.AuditLogTable;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;

public class BinlogTable
extends AuditLogTable {
    public static final String BINLOG = "binlog";
    private final FileStoreTable wrapped;

    public BinlogTable(FileStoreTable wrapped) {
        super(wrapped);
        this.wrapped = wrapped;
    }

    @Override
    public String name() {
        return this.wrapped.name() + "$" + BINLOG;
    }

    @Override
    public RowType rowType() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(SpecialFields.ROW_KIND);
        for (DataField field : this.wrapped.rowType().getFields()) {
            fields.add(field.newType((DataType)new ArrayType(field.type().nullable())));
        }
        return new RowType(fields);
    }

    @Override
    public InnerTableRead newRead() {
        return new BinlogRead(this.wrapped.newRead());
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new BinlogTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions));
    }

    private class BinlogRead
    extends AuditLogTable.AuditLogRead {
        private BinlogRead(InnerTableRead dataRead) {
            super(dataRead);
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            ArrayList<DataField> fields = new ArrayList<DataField>();
            for (DataField field : readType.getFields()) {
                if (field.name().equals(SpecialFields.ROW_KIND.name())) {
                    fields.add(field);
                    continue;
                }
                fields.add(field.newType(((ArrayType)field.type()).getElementType()));
            }
            return super.withReadType(readType.copy(fields));
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            DataSplit dataSplit = (DataSplit)split;
            InternalRow.FieldGetter[] fieldGetters = BinlogTable.this.wrapped.rowType().fieldGetters();
            if (dataSplit.isStreaming()) {
                return new PackChangelogReader(this.dataRead.createReader(split), (row1, row2) -> new AuditLogTable.AuditLogRow(this.readProjection, this.convertToArray((InternalRow)row1, (InternalRow)row2, fieldGetters)), BinlogTable.this.wrapped.rowType());
            }
            return this.dataRead.createReader(split).transform(row -> new AuditLogTable.AuditLogRow(this.readProjection, this.convertToArray((InternalRow)row, null, fieldGetters)));
        }

        private InternalRow convertToArray(InternalRow row1, @Nullable InternalRow row2, InternalRow.FieldGetter[] fieldGetters) {
            GenericRow row = new GenericRow(row1.getFieldCount());
            for (int i = 0; i < row1.getFieldCount(); ++i) {
                Object o1 = fieldGetters[i].getFieldOrNull(row1);
                if (row2 != null) {
                    Object o2 = fieldGetters[i].getFieldOrNull(row2);
                    row.setField(i, (Object)new GenericArray(new Object[]{o1, o2}));
                    continue;
                }
                row.setField(i, (Object)new GenericArray(new Object[]{o1}));
            }
            if (row2 == null) {
                row.setRowKind(row1.getRowKind());
            } else {
                row.setRowKind(row2.getRowKind());
            }
            return row;
        }
    }
}

