/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.FunctionWithException;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.SnapshotNotExistException;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTravelUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TimeTravelUtil.class);
    private static final String[] SCAN_KEYS = new String[]{CoreOptions.SCAN_SNAPSHOT_ID.key(), CoreOptions.SCAN_TAG_NAME.key(), CoreOptions.SCAN_WATERMARK.key(), CoreOptions.SCAN_TIMESTAMP_MILLIS.key()};

    public static Snapshot resolveSnapshot(FileStoreTable table) {
        return TimeTravelUtil.resolveSnapshotFromOptions(table.coreOptions(), table.snapshotManager());
    }

    public static Snapshot resolveSnapshotFromOptions(CoreOptions options, SnapshotManager snapshotManager) {
        ArrayList<String> scanHandleKey = new ArrayList<String>(1);
        for (String key : SCAN_KEYS) {
            if (!options.toConfiguration().containsKey(key)) continue;
            scanHandleKey.add(key);
        }
        if (scanHandleKey.size() == 0) {
            return snapshotManager.latestSnapshot();
        }
        Preconditions.checkArgument((scanHandleKey.size() == 1 ? 1 : 0) != 0, (Object)String.format("Only one of the following parameters may be set : [%s, %s, %s, %s]", CoreOptions.SCAN_SNAPSHOT_ID.key(), CoreOptions.SCAN_TAG_NAME.key(), CoreOptions.SCAN_WATERMARK.key(), CoreOptions.SCAN_TIMESTAMP_MILLIS.key()));
        String key = (String)scanHandleKey.get(0);
        Snapshot snapshot = null;
        if (key.equals(CoreOptions.SCAN_SNAPSHOT_ID.key())) {
            snapshot = TimeTravelUtil.resolveSnapshotBySnapshotId(snapshotManager, options);
        } else if (key.equals(CoreOptions.SCAN_WATERMARK.key())) {
            snapshot = TimeTravelUtil.resolveSnapshotByWatermark(snapshotManager, options);
        } else if (key.equals(CoreOptions.SCAN_TIMESTAMP_MILLIS.key())) {
            snapshot = TimeTravelUtil.resolveSnapshotByTimestamp(snapshotManager, options);
        } else if (key.equals(CoreOptions.SCAN_TAG_NAME.key())) {
            snapshot = TimeTravelUtil.resolveSnapshotByTagName(snapshotManager, options);
        }
        if (snapshot == null) {
            snapshot = snapshotManager.latestSnapshot();
        }
        return snapshot;
    }

    private static Snapshot resolveSnapshotBySnapshotId(SnapshotManager snapshotManager, CoreOptions options) {
        Long snapshotId = options.scanSnapshotId();
        if (snapshotId != null) {
            if (!snapshotManager.snapshotExists(snapshotId)) {
                Long earliestSnapshotId = snapshotManager.earliestSnapshotId();
                Long latestSnapshotId = snapshotManager.latestSnapshotId();
                throw new SnapshotNotExistException(String.format("Specified parameter %s = %s is not exist, you can set it in range from %s to %s.", CoreOptions.SCAN_SNAPSHOT_ID.key(), snapshotId, earliestSnapshotId, latestSnapshotId));
            }
            return snapshotManager.snapshot(snapshotId);
        }
        return null;
    }

    private static Snapshot resolveSnapshotByTimestamp(SnapshotManager snapshotManager, CoreOptions options) {
        Long timestamp = options.scanTimestampMills();
        return snapshotManager.earlierOrEqualTimeMills(timestamp);
    }

    private static Snapshot resolveSnapshotByWatermark(SnapshotManager snapshotManager, CoreOptions options) {
        Long watermark = options.scanWatermark();
        return snapshotManager.laterOrEqualWatermark(watermark);
    }

    private static Snapshot resolveSnapshotByTagName(SnapshotManager snapshotManager, CoreOptions options) {
        String tagName = options.scanTagName();
        TagManager tagManager = new TagManager(snapshotManager.fileIO(), snapshotManager.tablePath());
        return tagManager.getOrThrow(tagName).trimToSnapshot();
    }

    @Nullable
    public static Long earlierThanTimeMills(SnapshotManager snapshotManager, ChangelogManager changelogManager, long timestampMills, boolean startFromChangelog, boolean returnNullIfTooEarly) {
        Long latest = snapshotManager.latestSnapshotId();
        if (latest == null) {
            return null;
        }
        Snapshot earliestSnapshot = TimeTravelUtil.earliestSnapshot(snapshotManager, changelogManager, startFromChangelog, latest);
        if (earliestSnapshot == null) {
            return latest - 1L;
        }
        if (earliestSnapshot.timeMillis() >= timestampMills) {
            return returnNullIfTooEarly ? null : Long.valueOf(earliestSnapshot.id() - 1L);
        }
        long earliest = earliestSnapshot.id();
        while (earliest < latest) {
            Snapshot snapshot;
            long mid = (earliest + latest + 1L) / 2L;
            Snapshot snapshot2 = snapshot = startFromChangelog ? TimeTravelUtil.changelogOrSnapshot(snapshotManager, changelogManager, mid) : snapshotManager.snapshot(mid);
            if (snapshot.timeMillis() < timestampMills) {
                earliest = mid;
                continue;
            }
            latest = mid - 1L;
        }
        return earliest;
    }

    @Nullable
    private static Snapshot earliestSnapshot(SnapshotManager snapshotManager, ChangelogManager changelogManager, boolean includeChangelog, @Nullable Long stopSnapshotId) {
        Long snapshotId = null;
        if (includeChangelog) {
            snapshotId = changelogManager.earliestLongLivedChangelogId();
        }
        if (snapshotId == null) {
            snapshotId = snapshotManager.earliestSnapshotId();
        }
        if (snapshotId == null) {
            return null;
        }
        if (stopSnapshotId == null) {
            stopSnapshotId = snapshotId + 3L;
        }
        FunctionWithException snapshotFunction = includeChangelog ? s -> TimeTravelUtil.tryGetChangelogOrSnapshot(snapshotManager, changelogManager, s) : snapshotManager::tryGetSnapshot;
        while (true) {
            try {
                return (Snapshot)snapshotFunction.apply((Object)snapshotId);
            }
            catch (FileNotFoundException e) {
                Long l = snapshotId;
                Long l2 = snapshotId = Long.valueOf(snapshotId + 1L);
                if (snapshotId > stopSnapshotId) {
                    return null;
                }
                LOG.warn("The earliest snapshot or changelog was once identified but disappeared. It might have been expired by other jobs operating on this table. Searching for the second earliest snapshot or changelog instead. ");
                continue;
            }
            break;
        }
    }

    private static Snapshot tryGetChangelogOrSnapshot(SnapshotManager snapshotManager, ChangelogManager changelogManager, long snapshotId) throws FileNotFoundException {
        if (changelogManager.longLivedChangelogExists(snapshotId)) {
            return changelogManager.tryGetChangelog(snapshotId);
        }
        return snapshotManager.tryGetSnapshot(snapshotId);
    }

    private static Snapshot changelogOrSnapshot(SnapshotManager snapshotManager, ChangelogManager changelogManager, long snapshotId) {
        if (changelogManager.longLivedChangelogExists(snapshotId)) {
            return changelogManager.changelog(snapshotId);
        }
        return snapshotManager.snapshot(snapshotId);
    }

    public static void checkRescaleBucketForIncrementalDiffQuery(SchemaManager schemaManager, Snapshot start, Snapshot end) {
        int endBucketNumber;
        int startBucketNumber;
        if (start.schemaId() != end.schemaId() && (startBucketNumber = TimeTravelUtil.bucketNumber(schemaManager, start.schemaId())) != (endBucketNumber = TimeTravelUtil.bucketNumber(schemaManager, end.schemaId()))) {
            throw new InconsistentTagBucketException(start.id(), end.id(), String.format("The bucket number of two snapshots are different (%s, %s), which is not supported in incremental diff query.", startBucketNumber, endBucketNumber));
        }
    }

    private static int bucketNumber(SchemaManager schemaManager, long schemaId) {
        TableSchema schema = schemaManager.schema(schemaId);
        return CoreOptions.fromMap(schema.options()).bucket();
    }

    public static class InconsistentTagBucketException
    extends RuntimeException {
        private final long startSnapshotId;
        private final long endSnapshotId;

        public InconsistentTagBucketException(long startSnapshotId, long endSnapshotId, String message) {
            super(message);
            this.startSnapshotId = startSnapshotId;
            this.endSnapshotId = endSnapshotId;
        }

        public long startSnapshotId() {
            return this.startSnapshotId;
        }

        public long endSnapshotId() {
            return this.endSnapshotId;
        }
    }
}

