/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.FollowUpScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangelogFollowUpScanner
implements FollowUpScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ChangelogFollowUpScanner.class);

    @Override
    public boolean shouldScanSnapshot(Snapshot snapshot) {
        if (snapshot.changelogManifestList() != null) {
            return true;
        }
        LOG.debug("Next snapshot id {} has no changelog, check next one.", (Object)snapshot.id());
        return false;
    }

    @Override
    public SnapshotReader.Plan scan(Snapshot snapshot, SnapshotReader snapshotReader) {
        return snapshotReader.withMode(ScanMode.CHANGELOG).withSnapshot(snapshot).read();
    }
}

