/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.query;

import java.io.IOException;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueFileStore;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.RowCompactedSerializer;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.lookup.LookupStoreFactory;
import org.apache.paimon.mergetree.Levels;
import org.apache.paimon.mergetree.LookupFile;
import org.apache.paimon.mergetree.LookupLevels;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.query.TableQuery;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.IOFunction;
import org.apache.paimon.utils.KeyComparatorSupplier;
import org.apache.paimon.utils.Preconditions;

public class LocalTableQuery
implements TableQuery {
    private final Map<BinaryRow, Map<Integer, LookupLevels<KeyValue>>> tableView;
    private final CoreOptions options;
    private final Supplier<Comparator<InternalRow>> keyComparatorSupplier;
    private final KeyValueFileReaderFactory.Builder readerFactoryBuilder;
    private final LookupStoreFactory lookupStoreFactory;
    private final int startLevel;
    private IOManager ioManager;
    @Nullable
    private Cache<String, LookupFile> lookupFileCache;
    private final RowType rowType;
    private final RowType partitionType;
    @Nullable
    private Filter<InternalRow> cacheRowFilter;

    public LocalTableQuery(FileStoreTable table) {
        this.options = table.coreOptions();
        this.tableView = new HashMap<BinaryRow, Map<Integer, LookupLevels<KeyValue>>>();
        FileStore<?> tableStore = table.store();
        if (!(tableStore instanceof KeyValueFileStore)) {
            throw new UnsupportedOperationException("Table Query only supports table with primary key.");
        }
        KeyValueFileStore store = (KeyValueFileStore)tableStore;
        this.readerFactoryBuilder = store.newReaderFactoryBuilder();
        this.rowType = table.schema().logicalRowType();
        this.partitionType = table.schema().logicalPartitionType();
        RowType keyType = this.readerFactoryBuilder.keyType();
        this.keyComparatorSupplier = new KeyComparatorSupplier(this.readerFactoryBuilder.keyType());
        this.lookupStoreFactory = LookupStoreFactory.create((CoreOptions)this.options, (CacheManager)new CacheManager(this.options.lookupCacheMaxMemory(), this.options.lookupCacheHighPrioPoolRatio()), (Comparator)new RowCompactedSerializer(keyType).createSliceComparator());
        if (this.options.needLookup()) {
            this.startLevel = 1;
        } else {
            if (this.options.sequenceField().size() > 0) {
                throw new UnsupportedOperationException("Not support sequence field definition, but is: " + this.options.sequenceField());
            }
            if (this.options.mergeEngine() != CoreOptions.MergeEngine.DEDUPLICATE) {
                throw new UnsupportedOperationException("Only support deduplicate merge engine, but is: " + this.options.mergeEngine());
            }
            this.startLevel = 0;
        }
    }

    public void refreshFiles(BinaryRow partition, int bucket, List<DataFileMeta> beforeFiles, List<DataFileMeta> dataFiles) {
        LookupLevels lookupLevels = (LookupLevels)this.tableView.computeIfAbsent(partition, k -> new HashMap()).get(bucket);
        if (lookupLevels == null) {
            Preconditions.checkArgument((boolean)beforeFiles.isEmpty(), (Object)"The before file should be empty for the initial phase.");
            this.newLookupLevels(partition, bucket, dataFiles);
        } else {
            lookupLevels.getLevels().update(beforeFiles, dataFiles);
        }
    }

    private void newLookupLevels(BinaryRow partition, int bucket, List<DataFileMeta> dataFiles) {
        Levels levels = new Levels(this.keyComparatorSupplier.get(), dataFiles, this.options.numLevels());
        KeyValueFileReaderFactory factory2 = this.readerFactoryBuilder.build(partition, bucket, DeletionVector.emptyFactory());
        Options options = this.options.toConfiguration();
        if (this.lookupFileCache == null) {
            this.lookupFileCache = LookupFile.createCache((Duration)options.get(CoreOptions.LOOKUP_CACHE_FILE_RETENTION), (MemorySize)options.get(CoreOptions.LOOKUP_CACHE_MAX_DISK_SIZE));
        }
        LookupLevels<KeyValue> lookupLevels = new LookupLevels<KeyValue>(levels, this.keyComparatorSupplier.get(), this.readerFactoryBuilder.keyType(), new LookupLevels.KeyValueProcessor(this.readerFactoryBuilder.readValueType()), (IOFunction<DataFileMeta, RecordReader<KeyValue>>)((IOFunction)file -> {
            RecordReader reader = factory2.createRecordReader((DataFileMeta)file);
            if (this.cacheRowFilter != null) {
                reader = reader.filter(keyValue -> this.cacheRowFilter.test((Object)keyValue.value()));
            }
            return reader;
        }), file -> ((IOManager)Preconditions.checkNotNull((Object)this.ioManager, (String)"IOManager is required.")).createChannel(LookupFile.localFilePrefix(this.partitionType, partition, bucket, file)).getPathFile(), this.lookupStoreFactory, LookupStoreFactory.bfGenerator((Options)options), this.lookupFileCache);
        this.tableView.computeIfAbsent(partition, k -> new HashMap()).put(bucket, lookupLevels);
    }

    @Override
    @Nullable
    public synchronized InternalRow lookup(BinaryRow partition, int bucket, InternalRow key) throws IOException {
        Map<Integer, LookupLevels<KeyValue>> buckets = this.tableView.get(partition);
        if (buckets == null || buckets.isEmpty()) {
            return null;
        }
        LookupLevels<KeyValue> lookupLevels = buckets.get(bucket);
        if (lookupLevels == null) {
            return null;
        }
        KeyValue kv = lookupLevels.lookup(key, this.startLevel);
        if (kv == null || kv.valueKind().isRetract()) {
            return null;
        }
        return kv.value();
    }

    @Override
    public LocalTableQuery withValueProjection(int[] projection) {
        this.readerFactoryBuilder.withReadValueType(this.rowType.project(projection));
        return this;
    }

    public LocalTableQuery withIOManager(IOManager ioManager) {
        this.ioManager = ioManager;
        return this;
    }

    public LocalTableQuery withCacheRowFilter(Filter<InternalRow> cacheRowFilter) {
        this.cacheRowFilter = cacheRowFilter;
        return this;
    }

    @Override
    public InternalRowSerializer createValueSerializer() {
        return InternalSerializers.create((RowType)this.readerFactoryBuilder.readValueType());
    }

    @Override
    public void close() throws IOException {
        for (Map.Entry<BinaryRow, Map<Integer, LookupLevels<KeyValue>>> buckets : this.tableView.entrySet()) {
            for (Map.Entry<Integer, LookupLevels<KeyValue>> bucket : buckets.getValue().entrySet()) {
                bucket.getValue().close();
            }
        }
        if (this.lookupFileCache != null) {
            this.lookupFileCache.invalidateAll();
        }
        this.tableView.clear();
    }
}

