/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.object;

import java.util.Optional;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.RemoteIterator;
import org.apache.paimon.table.object.ObjectTable;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.apache.paimon.table.sink.BatchWriteBuilder;

public class ObjectRefresh {
    private static final long COMMIT_BATCH_SIZE = 10000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long refresh(ObjectTable table) throws Exception {
        long totalObjs = 0L;
        BatchWriteBuilder writeBuilder = table.underlyingTable().newBatchWriteBuilder().withOverwrite();
        try (RemoteIterator objIter = table.objectFileIO().listFilesIterative(new Path(table.objectLocation()), true);){
            while (objIter.hasNext()) {
                BatchTableWrite write;
                block36: {
                    write = writeBuilder.newWrite();
                    Throwable throwable = null;
                    try {
                        try (BatchTableCommit commit = writeBuilder.newCommit();){
                            int i = 0;
                            while ((long)i < 10000L && objIter.hasNext()) {
                                ++totalObjs;
                                write.write(ObjectRefresh.toRow((FileStatus)objIter.next()));
                                ++i;
                            }
                            commit.commit(write.prepareCommit());
                        }
                        if (write == null) continue;
                        if (throwable == null) break block36;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (write == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    write.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            write.close();
                            throw throwable3;
                        }
                    }
                    try {
                        write.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                write.close();
            }
            return totalObjs;
        }
    }

    private static InternalRow toRow(FileStatus file) {
        return ObjectRefresh.toRow(file.getPath().toString(), file.getPath().getParent().toString(), file.getPath().getName(), file.getLen(), Timestamp.fromEpochMillis((long)file.getModificationTime()), Timestamp.fromEpochMillis((long)file.getAccessTime()), file.getOwner(), file.getGeneration(), file.getContentType(), file.getStorageClass(), file.getMd5Hash(), Optional.ofNullable(file.getMetadataModificationTime()).map(Timestamp::fromEpochMillis).orElse(null), Optional.ofNullable(file.getMetadata()).map(GenericMap::new).orElse(null));
    }

    public static GenericRow toRow(Object ... values2) {
        GenericRow row = new GenericRow(values2.length);
        for (int i = 0; i < values2.length; ++i) {
            Object value = values2[i];
            if (value instanceof String) {
                value = BinaryString.fromString((String)((String)value));
            }
            row.setField(i, value);
        }
        return row;
    }
}

