/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Changelog;
import org.apache.paimon.Snapshot;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.manifest.ExpireFileEntry;
import org.apache.paimon.operation.ChangelogDeletion;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.table.ExpireSnapshotsImpl;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireChangelogImpl
implements ExpireSnapshots {
    public static final Logger LOG = LoggerFactory.getLogger(ExpireChangelogImpl.class);
    private final SnapshotManager snapshotManager;
    private final ChangelogManager changelogManager;
    private final ConsumerManager consumerManager;
    private final ChangelogDeletion changelogDeletion;
    private final TagManager tagManager;
    private ExpireConfig expireConfig;

    public ExpireChangelogImpl(SnapshotManager snapshotManager, ChangelogManager changelogManager, TagManager tagManager, ChangelogDeletion changelogDeletion) {
        this.snapshotManager = snapshotManager;
        this.changelogManager = changelogManager;
        this.tagManager = tagManager;
        this.consumerManager = new ConsumerManager(snapshotManager.fileIO(), snapshotManager.tablePath(), snapshotManager.branch());
        this.changelogDeletion = changelogDeletion;
        this.expireConfig = ExpireConfig.builder().build();
    }

    @Override
    public ExpireSnapshots config(ExpireConfig expireConfig) {
        this.expireConfig = expireConfig;
        return this;
    }

    @Override
    public int expire() {
        int retainMax = this.expireConfig.getChangelogRetainMax();
        int retainMin = this.expireConfig.getChangelogRetainMin();
        int maxDeletes = this.expireConfig.getChangelogMaxDeletes();
        long olderThanMills = System.currentTimeMillis() - this.expireConfig.getChangelogTimeRetain().toMillis();
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return 0;
        }
        Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
        if (earliestSnapshotId == null) {
            return 0;
        }
        Long latestChangelogId = this.changelogManager.latestLongLivedChangelogId();
        if (latestChangelogId == null) {
            return 0;
        }
        Long earliestChangelogId = this.changelogManager.earliestLongLivedChangelogId();
        if (earliestChangelogId == null) {
            return 0;
        }
        Preconditions.checkArgument((retainMax >= retainMin ? 1 : 0) != 0, (Object)"retainMax must greater than retainMin.");
        long min = Math.max(latestSnapshotId - (long)retainMax + 1L, earliestChangelogId);
        long maxExclusive = latestSnapshotId - (long)retainMin + 1L;
        maxExclusive = Math.min(maxExclusive, this.consumerManager.minNextSnapshot().orElse(Long.MAX_VALUE));
        maxExclusive = Math.min(maxExclusive, earliestChangelogId + (long)maxDeletes);
        maxExclusive = Math.min(maxExclusive, latestChangelogId);
        for (long id = min; id <= maxExclusive; ++id) {
            if (!this.changelogManager.longLivedChangelogExists(id) || olderThanMills > this.changelogManager.longLivedChangelog(id).timeMillis()) continue;
            return this.expireUntil(earliestChangelogId, id);
        }
        return this.expireUntil(earliestChangelogId, maxExclusive);
    }

    public int expireUntil(long earliestId, long endExclusiveId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Changelog expire range is [" + earliestId + ", " + endExclusiveId + ")");
        }
        List<Snapshot> taggedSnapshots = this.tagManager.taggedSnapshots();
        List<Snapshot> skippingSnapshots = ExpireSnapshotsImpl.findSkippingTags(taggedSnapshots, earliestId, endExclusiveId);
        skippingSnapshots.add(this.changelogManager.changelog(endExclusiveId));
        Set<String> manifestSkippSet = this.changelogDeletion.manifestSkippingSet(skippingSnapshots);
        for (long id = earliestId; id < endExclusiveId; ++id) {
            Predicate<ExpireFileEntry> skipper;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete changelog files from changelog #" + id);
            }
            Changelog changelog = this.changelogManager.longLivedChangelog(id);
            try {
                skipper = this.changelogDeletion.createDataFileSkipperForTags(taggedSnapshots, id);
            }
            catch (Exception e) {
                LOG.info(String.format("Skip cleaning data files of changelog '%s' due to failed to build skipping set.", id), (Throwable)e);
                continue;
            }
            this.changelogDeletion.cleanUnusedDataFiles(changelog, skipper);
            this.changelogDeletion.cleanUnusedManifests(changelog, manifestSkippSet);
            this.changelogManager.fileIO().deleteQuietly(this.changelogManager.longLivedChangelogPath(id));
        }
        this.changelogDeletion.cleanEmptyDirectories();
        this.writeEarliestHintFile(endExclusiveId);
        return (int)(endExclusiveId - earliestId);
    }

    public void expireAll() {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return;
        }
        Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
        if (earliestSnapshotId == null) {
            return;
        }
        Long latestChangelogId = this.changelogManager.latestLongLivedChangelogId();
        if (latestChangelogId == null) {
            return;
        }
        Long earliestChangelogId = this.changelogManager.earliestLongLivedChangelogId();
        if (earliestChangelogId == null) {
            return;
        }
        LOG.info("Read earliest and latest changelog for expire all. earliestChangelogId is {}, latestChangelogId is {}", (Object)earliestChangelogId, (Object)latestChangelogId);
        List<Snapshot> taggedSnapshots = this.tagManager.taggedSnapshots();
        Preconditions.checkArgument((latestChangelogId < earliestSnapshotId ? 1 : 0) != 0, (Object)"latest changelog id should be less than earliest snapshot id.please check your table!");
        List<Snapshot> skippingSnapshots = ExpireSnapshotsImpl.findSkippingTags(taggedSnapshots, earliestChangelogId, earliestSnapshotId);
        skippingSnapshots.add(this.snapshotManager.snapshot(earliestSnapshotId));
        Set<String> manifestSkippSet = this.changelogDeletion.manifestSkippingSet(skippingSnapshots);
        for (long id = earliestChangelogId.longValue(); id <= latestChangelogId; ++id) {
            Predicate<ExpireFileEntry> skipper;
            Changelog changelog;
            LOG.info("Ready to delete changelog files from changelog #" + id);
            try {
                changelog = this.changelogManager.tryGetChangelog(id);
            }
            catch (FileNotFoundException e) {
                LOG.info("fail to get changelog #" + id);
                continue;
            }
            try {
                skipper = this.changelogDeletion.createDataFileSkipperForTags(taggedSnapshots, id);
            }
            catch (Exception e) {
                LOG.info(String.format("Skip cleaning data files of changelog '%s' due to failed to build skipping set.", id), (Throwable)e);
                continue;
            }
            this.changelogDeletion.cleanUnusedDataFiles(changelog, skipper);
            this.changelogDeletion.cleanUnusedManifests(changelog, manifestSkippSet);
            this.changelogManager.fileIO().deleteQuietly(this.changelogManager.longLivedChangelogPath(id));
        }
        try {
            this.changelogManager.deleteEarliestHint();
            this.changelogManager.deleteLatestHint();
        }
        catch (Exception e) {
            LOG.error("delete changelog hint file error.", (Throwable)e);
        }
        this.changelogDeletion.cleanEmptyDirectories();
    }

    private void writeEarliestHintFile(long earliest) {
        try {
            this.changelogManager.commitLongLivedChangelogEarliestHint(earliest);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

