/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.CompressOptions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.AbstractRowDataSerializer;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.disk.ChannelWithMeta;
import org.apache.paimon.disk.ChannelWriterOutputView;
import org.apache.paimon.disk.FileChannelUtil;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.memory.HeapMemorySegmentPool;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.sort.BinaryExternalMerger;
import org.apache.paimon.sort.BinaryInMemorySortBuffer;
import org.apache.paimon.sort.BinaryMergeIterator;
import org.apache.paimon.sort.QuickSort;
import org.apache.paimon.sort.SortBuffer;
import org.apache.paimon.sort.SpillChannelManager;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.MutableObjectIterator;

public class BinaryExternalSortBuffer
implements SortBuffer {
    private final BinaryRowSerializer serializer;
    private final BinaryInMemorySortBuffer inMemorySortBuffer;
    private final IOManager ioManager;
    private final SpillChannelManager channelManager;
    private final int maxNumFileHandles;
    private final BlockCompressionFactory compressionCodecFactory;
    private final int compressionBlockSize;
    private final BinaryExternalMerger merger;
    private final FileIOChannel.Enumerator enumerator;
    private final List<ChannelWithMeta> spillChannelIDs;
    private final MemorySize maxDiskSize;
    private int numRecords = 0;

    public BinaryExternalSortBuffer(BinaryRowSerializer serializer, RecordComparator comparator, int pageSize, BinaryInMemorySortBuffer inMemorySortBuffer, IOManager ioManager, int maxNumFileHandles, CompressOptions compression, MemorySize maxDiskSize) {
        this.serializer = serializer;
        this.inMemorySortBuffer = inMemorySortBuffer;
        this.ioManager = ioManager;
        this.channelManager = new SpillChannelManager();
        this.maxNumFileHandles = maxNumFileHandles;
        this.compressionCodecFactory = BlockCompressionFactory.create((CompressOptions)compression);
        this.compressionBlockSize = (int)MemorySize.parse((String)"64 kb").getBytes();
        this.maxDiskSize = maxDiskSize;
        this.merger = new BinaryExternalMerger(ioManager, pageSize, maxNumFileHandles, this.channelManager, serializer.duplicate(), comparator, this.compressionCodecFactory, this.compressionBlockSize);
        this.enumerator = ioManager.createChannelEnumerator();
        this.spillChannelIDs = new ArrayList<ChannelWithMeta>();
    }

    public static BinaryExternalSortBuffer create(IOManager ioManager, RowType rowType, int[] keyFields, long bufferSize, int pageSize, int maxNumFileHandles, CompressOptions compression, MemorySize maxDiskSize, boolean sequenceOrder) {
        return BinaryExternalSortBuffer.create(ioManager, rowType, keyFields, (MemorySegmentPool)new HeapMemorySegmentPool(bufferSize, pageSize), maxNumFileHandles, compression, maxDiskSize, sequenceOrder);
    }

    public static BinaryExternalSortBuffer create(IOManager ioManager, RowType rowType, int[] keyFields, MemorySegmentPool pool, int maxNumFileHandles, CompressOptions compression, MemorySize maxDiskSize, boolean sequenceOrder) {
        RecordComparator comparator = CodeGenUtils.newRecordComparator(rowType.getFieldTypes(), keyFields, sequenceOrder);
        BinaryInMemorySortBuffer sortBuffer = BinaryInMemorySortBuffer.createBuffer(CodeGenUtils.newNormalizedKeyComputer(rowType.getFieldTypes(), keyFields), (AbstractRowDataSerializer<InternalRow>)new InternalRowSerializer(rowType), comparator, pool);
        return new BinaryExternalSortBuffer(new BinaryRowSerializer(rowType.getFieldCount()), comparator, pool.pageSize(), sortBuffer, ioManager, maxNumFileHandles, compression, maxDiskSize);
    }

    @Override
    public int size() {
        return this.numRecords;
    }

    @Override
    public void clear() {
        this.numRecords = 0;
        this.inMemorySortBuffer.clear();
        this.spillChannelIDs.clear();
        this.channelManager.reset();
    }

    @Override
    public long getOccupancy() {
        return this.inMemorySortBuffer.getOccupancy();
    }

    @Override
    public boolean flushMemory() throws IOException {
        boolean isFull;
        boolean bl = isFull = this.getDiskUsage() >= this.maxDiskSize.getBytes();
        if (isFull) {
            return false;
        }
        this.spill();
        return true;
    }

    private long getDiskUsage() {
        long bytes = 0L;
        for (ChannelWithMeta spillChannelID : this.spillChannelIDs) {
            bytes += spillChannelID.getNumBytes();
        }
        return bytes;
    }

    @VisibleForTesting
    public void write(MutableObjectIterator<BinaryRow> iterator2) throws IOException {
        BinaryRow row = this.serializer.createInstance();
        while ((row = iterator2.next(row)) != null) {
            this.write((InternalRow)row);
        }
    }

    @Override
    public boolean write(InternalRow record) throws IOException {
        while (true) {
            boolean success;
            if (success = this.inMemorySortBuffer.write(record)) {
                ++this.numRecords;
                return true;
            }
            if (this.inMemorySortBuffer.isEmpty()) {
                throw new IOException("The record exceeds the maximum size of a sort buffer.");
            }
            this.spill();
            if (this.spillChannelIDs.size() < this.maxNumFileHandles) continue;
            List<ChannelWithMeta> merged = this.merger.mergeChannelList(this.spillChannelIDs);
            this.spillChannelIDs.clear();
            this.spillChannelIDs.addAll(merged);
        }
    }

    @Override
    public final MutableObjectIterator<BinaryRow> sortedIterator() throws IOException {
        if (this.spillChannelIDs.isEmpty()) {
            return this.inMemorySortBuffer.sortedIterator();
        }
        return this.spilledIterator();
    }

    private MutableObjectIterator<BinaryRow> spilledIterator() throws IOException {
        this.spill();
        ArrayList<FileIOChannel> openChannels = new ArrayList<FileIOChannel>();
        final BinaryMergeIterator iterator2 = this.merger.getMergingIterator(this.spillChannelIDs, openChannels);
        this.channelManager.addOpenChannels(openChannels);
        return new MutableObjectIterator<BinaryRow>(){

            @Override
            public BinaryRow next(BinaryRow reuse) throws IOException {
                return this.next();
            }

            @Override
            public BinaryRow next() throws IOException {
                BinaryRow row = (BinaryRow)iterator2.next();
                return row == null ? null : row.copy();
            }
        };
    }

    private void spill() throws IOException {
        int blockCount;
        if (this.inMemorySortBuffer.isEmpty()) {
            return;
        }
        FileIOChannel.ID channel = this.enumerator.next();
        this.channelManager.addChannel(channel);
        ChannelWriterOutputView output = null;
        try {
            output = FileChannelUtil.createOutputView(this.ioManager, channel, this.compressionCodecFactory, this.compressionBlockSize);
            new QuickSort().sort(this.inMemorySortBuffer);
            this.inMemorySortBuffer.writeToOutput(output);
            output.close();
            blockCount = output.getBlockCount();
        }
        catch (IOException e) {
            if (output != null) {
                output.close();
                output.getChannel().deleteChannel();
            }
            throw e;
        }
        this.spillChannelIDs.add(new ChannelWithMeta(channel, blockCount, output.getWriteBytes()));
        this.inMemorySortBuffer.clear();
    }
}

