/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypeJsonParser;
import org.apache.paimon.utils.JsonDeserializer;
import org.apache.paimon.utils.JsonSerializer;

public class SchemaSerializer
implements JsonSerializer<TableSchema>,
JsonDeserializer<TableSchema> {
    public static final SchemaSerializer INSTANCE = new SchemaSerializer();

    @Override
    public void serialize(TableSchema tableSchema, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField("version", tableSchema.version());
        generator.writeNumberField("id", tableSchema.id());
        generator.writeArrayFieldStart("fields");
        for (DataField dataField : tableSchema.fields()) {
            dataField.serializeJson(generator);
        }
        generator.writeEndArray();
        generator.writeNumberField("highestFieldId", tableSchema.highestFieldId());
        generator.writeArrayFieldStart("partitionKeys");
        for (String string : tableSchema.partitionKeys()) {
            generator.writeString(string);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart("primaryKeys");
        for (String string : tableSchema.primaryKeys()) {
            generator.writeString(string);
        }
        generator.writeEndArray();
        generator.writeObjectFieldStart("options");
        for (Map.Entry entry : tableSchema.options().entrySet()) {
            generator.writeStringField((String)entry.getKey(), (String)entry.getValue());
        }
        generator.writeEndObject();
        if (tableSchema.comment() != null) {
            generator.writeStringField("comment", tableSchema.comment());
        }
        generator.writeNumberField("timeMillis", tableSchema.timeMillis());
        generator.writeEndObject();
    }

    @Override
    public TableSchema deserialize(JsonNode node) {
        JsonNode versionNode = node.get("version");
        int version = versionNode == null ? 1 : versionNode.asInt();
        int id = node.get("id").asInt();
        Iterator fieldJsons = node.get("fields").elements();
        ArrayList<DataField> fields = new ArrayList<DataField>();
        while (fieldJsons.hasNext()) {
            fields.add(DataTypeJsonParser.parseDataField((JsonNode)((JsonNode)fieldJsons.next())));
        }
        int highestFieldId = node.get("highestFieldId").asInt();
        Iterator partitionJsons = node.get("partitionKeys").elements();
        ArrayList<String> partitionKeys = new ArrayList<String>();
        while (partitionJsons.hasNext()) {
            partitionKeys.add(((JsonNode)partitionJsons.next()).asText());
        }
        Iterator primaryJsons = node.get("primaryKeys").elements();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        while (primaryJsons.hasNext()) {
            primaryKeys.add(((JsonNode)primaryJsons.next()).asText());
        }
        JsonNode optionsJson = node.get("options");
        HashMap<String, String> options = new HashMap<String, String>();
        Iterator optionsKeys = optionsJson.fieldNames();
        while (optionsKeys.hasNext()) {
            String key = (String)optionsKeys.next();
            options.put(key, optionsJson.get(key).asText());
        }
        if (version <= 1 && !options.containsKey(CoreOptions.BUCKET.key())) {
            options.put(CoreOptions.BUCKET.key(), "1");
        }
        if (version <= 2 && !options.containsKey(CoreOptions.FILE_FORMAT.key())) {
            options.put(CoreOptions.FILE_FORMAT.key(), "orc");
        }
        JsonNode commentNode = node.get("comment");
        String comment = null;
        if (commentNode != null) {
            comment = commentNode.asText();
        }
        long timeMillis = node.get("timeMillis") == null ? 0L : node.get("timeMillis").asLong();
        return new TableSchema(version, id, fields, highestFieldId, partitionKeys, primaryKeys, options, comment, timeMillis);
    }
}

