/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.paimon.rest.RESTObjectMapper;
import org.apache.paimon.rest.auth.DLFToken;
import org.apache.paimon.rest.auth.DLFTokenLoader;
import org.apache.paimon.utils.FileIOUtils;

public class DLFLocalFileTokenLoader
implements DLFTokenLoader {
    private static final long[] READ_TOKEN_FILE_BACKOFF_WAIT_TIME_MILLIS = new long[]{1000L, 3000L, 5000L};
    private final String tokenFilePath;

    public DLFLocalFileTokenLoader(String tokenFilePath) {
        this.tokenFilePath = tokenFilePath;
    }

    @Override
    public DLFToken loadToken() {
        return DLFLocalFileTokenLoader.readToken(this.tokenFilePath, 0);
    }

    protected static DLFToken readToken(String tokenFilePath, int retryTimes) {
        try {
            File tokenFile = new File(tokenFilePath);
            if (tokenFile.exists()) {
                String tokenStr = FileIOUtils.readFileUtf8((File)tokenFile);
                return (DLFToken)RESTObjectMapper.OBJECT_MAPPER.readValue(tokenStr, DLFToken.class);
            }
            if (retryTimes < READ_TOKEN_FILE_BACKOFF_WAIT_TIME_MILLIS.length - 1) {
                Thread.sleep(READ_TOKEN_FILE_BACKOFF_WAIT_TIME_MILLIS[retryTimes]);
                return DLFLocalFileTokenLoader.readToken(tokenFilePath, retryTimes + 1);
            }
            throw new FileNotFoundException(tokenFilePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

