/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.auth.AuthProvider;
import org.apache.paimon.rest.auth.AuthProviderEnum;
import org.apache.paimon.rest.auth.AuthProviderFactory;
import org.apache.paimon.rest.auth.DLFAuthProvider;
import org.apache.paimon.rest.auth.DLFTokenLoader;
import org.apache.paimon.rest.auth.DLFTokenLoaderFactory;

public class DLFAuthProviderFactory
implements AuthProviderFactory {
    public String identifier() {
        return AuthProviderEnum.DLF.identifier();
    }

    @Override
    public AuthProvider create(Options options) {
        String region = options.getOptional(RESTCatalogOptions.DLF_REGION).orElseGet(() -> DLFAuthProviderFactory.parseRegionFromUri((String)options.get(RESTCatalogOptions.URI)));
        if (options.getOptional(RESTCatalogOptions.DLF_TOKEN_LOADER).isPresent()) {
            DLFTokenLoader dlfTokenLoader = DLFTokenLoaderFactory.createDLFTokenLoader((String)options.get(RESTCatalogOptions.DLF_TOKEN_LOADER), options);
            long tokenRefreshInMills = ((Duration)options.get(RESTCatalogOptions.TOKEN_REFRESH_TIME)).toMillis();
            return DLFAuthProvider.buildRefreshToken(dlfTokenLoader, tokenRefreshInMills, region);
        }
        if (options.getOptional(RESTCatalogOptions.DLF_TOKEN_PATH).isPresent()) {
            DLFTokenLoader dlfTokenLoader = DLFTokenLoaderFactory.createDLFTokenLoader("local_file", options);
            long tokenRefreshInMills = ((Duration)options.get(RESTCatalogOptions.TOKEN_REFRESH_TIME)).toMillis();
            return DLFAuthProvider.buildRefreshToken(dlfTokenLoader, tokenRefreshInMills, region);
        }
        if (options.getOptional(RESTCatalogOptions.DLF_ACCESS_KEY_ID).isPresent() && options.getOptional(RESTCatalogOptions.DLF_ACCESS_KEY_SECRET).isPresent()) {
            return DLFAuthProvider.buildAKToken((String)options.get(RESTCatalogOptions.DLF_ACCESS_KEY_ID), (String)options.get(RESTCatalogOptions.DLF_ACCESS_KEY_SECRET), (String)options.get(RESTCatalogOptions.DLF_SECURITY_TOKEN), region);
        }
        throw new IllegalArgumentException("DLF token path or AK must be set for DLF Auth.");
    }

    protected static String parseRegionFromUri(String uri) {
        try {
            String regex = "(?:pre-)?([a-z]+-[a-z]+(?:-\\d+)?)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(uri);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("Could not get region from conf or uri, please check your config.");
    }
}

