/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.auth.AuthProvider;
import org.apache.paimon.rest.auth.AuthProviderFactory;
import org.apache.paimon.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthSession {
    static final int REFRESH_NUM_RETRIES = 5;
    static final long MIN_REFRESH_WAIT_MILLIS = 10L;
    static final long MAX_REFRESH_WINDOW_MILLIS = 300000L;
    private static final Logger LOG = LoggerFactory.getLogger(AuthSession.class);
    private final AuthProvider authProvider;

    public AuthSession(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    public static AuthSession fromRefreshAuthProvider(ScheduledExecutorService executor, AuthProvider authProvider) {
        boolean refreshSuccessful;
        AuthSession session = new AuthSession(authProvider);
        long startTimeMillis = System.currentTimeMillis();
        Optional<Long> expiresAtMillisOpt = authProvider.expiresAtMillis();
        if (expiresAtMillisOpt.isPresent() && expiresAtMillisOpt.get() <= startTimeMillis && (refreshSuccessful = session.refresh().booleanValue())) {
            expiresAtMillisOpt = session.authProvider.expiresAtMillis();
        }
        if (null != executor && expiresAtMillisOpt.isPresent()) {
            AuthSession.scheduleTokenRefresh(executor, session, expiresAtMillisOpt.get());
        }
        return session;
    }

    public AuthProvider getAuthProvider() {
        if (this.authProvider.keepRefreshed() && this.authProvider.willSoonExpire()) {
            this.refresh();
        }
        return this.authProvider;
    }

    public Boolean refresh() {
        if (this.authProvider.keepRefreshed() && this.authProvider.tokenRefreshInMills().isPresent()) {
            return this.authProvider.refresh();
        }
        return false;
    }

    @VisibleForTesting
    static void scheduleTokenRefresh(ScheduledExecutorService executor, AuthSession session, long expiresAtMillis) {
        AuthSession.scheduleTokenRefresh(executor, session, expiresAtMillis, 0);
    }

    @VisibleForTesting
    static long getTimeToWaitByExpiresInMills(long expiresInMillis) {
        long refreshWindowMillis = Math.min(expiresInMillis, 300000L);
        long waitIntervalMillis = expiresInMillis - refreshWindowMillis;
        return Math.max(waitIntervalMillis, 10L);
    }

    private static void scheduleTokenRefresh(ScheduledExecutorService executor, AuthSession session, long expiresAtMillis, int retryTimes) {
        if (retryTimes < 5) {
            long expiresInMillis = expiresAtMillis - System.currentTimeMillis();
            long timeToWait = AuthSession.getTimeToWaitByExpiresInMills(expiresInMillis);
            executor.schedule(() -> AuthSession.doRefresh(executor, session, expiresAtMillis, retryTimes), timeToWait, TimeUnit.MILLISECONDS);
        } else {
            LOG.warn("Failed to refresh token after {} retries.", (Object)5);
        }
    }

    private static void doRefresh(ScheduledExecutorService executor, AuthSession session, long expiresAtMillis, int retryTimes) {
        long refreshStartTime = System.currentTimeMillis();
        boolean isSuccessful = session.refresh();
        if (isSuccessful) {
            AuthSession.scheduleTokenRefresh(executor, session, refreshStartTime + session.authProvider.tokenRefreshInMills().get(), 0);
        } else {
            AuthSession.scheduleTokenRefresh(executor, session, expiresAtMillis, retryTimes + 1);
        }
    }

    public static AuthSession createAuthSession(Options options, ScheduledExecutorService refreshExecutor) {
        String tokenProvider = (String)options.get(RESTCatalogOptions.TOKEN_PROVIDER);
        if (StringUtils.isEmpty((CharSequence)tokenProvider)) {
            throw new IllegalArgumentException("token.provider is not set.");
        }
        AuthProvider authProvider = AuthProviderFactory.createAuthProvider(tokenProvider, options);
        if (authProvider.keepRefreshed()) {
            return AuthSession.fromRefreshAuthProvider(refreshExecutor, authProvider);
        }
        return new AuthSession(authProvider);
    }
}

