/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.options.Options;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.utils.Preconditions;

public class RESTUtil {
    public static Map<String, String> extractPrefixMap(Options options, String prefix) {
        return RESTUtil.extractPrefixMap(options.toMap(), prefix);
    }

    public static Map<String, String> extractPrefixMap(Map<String, String> properties, String prefix) {
        Preconditions.checkNotNull(properties, (String)"Invalid properties map: null");
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().startsWith(prefix)) continue;
            result.put(entry.getKey().substring(prefix.length()), properties.get(entry.getKey()));
        }
        return result;
    }

    public static Map<String, String> merge(Map<String, String> targets, Map<String, String> updates) {
        if (targets == null) {
            targets = Maps.newHashMap();
        }
        if (updates == null) {
            updates = Maps.newHashMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : targets.entrySet()) {
            if (updates.containsKey(entry.getKey())) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        updates.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    public static String encodeString(String toEncode) {
        Preconditions.checkArgument((toEncode != null ? 1 : 0) != 0, (Object)"Invalid string to encode: null");
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(String.format("Failed to URL encode '%s': UTF-8 encoding is not supported", toEncode), e);
        }
    }

    public static String decodeString(String encoded) {
        Preconditions.checkArgument((encoded != null ? 1 : 0) != 0, (Object)"Invalid string to decode: null");
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(String.format("Failed to URL decode '%s': UTF-8 encoding is not supported", encoded), e);
        }
    }
}

