/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.PagedList;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogUtils;
import org.apache.paimon.catalog.Database;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.catalog.TableMetadata;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileIOLoader;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.rest.HttpClient;
import org.apache.paimon.rest.RESTCatalogLoader;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.RESTClient;
import org.apache.paimon.rest.RESTTokenFileIO;
import org.apache.paimon.rest.RESTUtil;
import org.apache.paimon.rest.ResourcePaths;
import org.apache.paimon.rest.auth.AuthSession;
import org.apache.paimon.rest.auth.RESTAuthFunction;
import org.apache.paimon.rest.auth.RESTAuthParameter;
import org.apache.paimon.rest.exceptions.AlreadyExistsException;
import org.apache.paimon.rest.exceptions.BadRequestException;
import org.apache.paimon.rest.exceptions.ForbiddenException;
import org.apache.paimon.rest.exceptions.NoSuchResourceException;
import org.apache.paimon.rest.exceptions.NotImplementedException;
import org.apache.paimon.rest.exceptions.ServiceFailureException;
import org.apache.paimon.rest.requests.AlterDatabaseRequest;
import org.apache.paimon.rest.requests.AlterTableRequest;
import org.apache.paimon.rest.requests.AlterViewRequest;
import org.apache.paimon.rest.requests.CommitTableRequest;
import org.apache.paimon.rest.requests.CreateBranchRequest;
import org.apache.paimon.rest.requests.CreateDatabaseRequest;
import org.apache.paimon.rest.requests.CreateTableRequest;
import org.apache.paimon.rest.requests.CreateViewRequest;
import org.apache.paimon.rest.requests.ForwardBranchRequest;
import org.apache.paimon.rest.requests.MarkDonePartitionsRequest;
import org.apache.paimon.rest.requests.RenameTableRequest;
import org.apache.paimon.rest.requests.RollbackTableRequest;
import org.apache.paimon.rest.responses.AlterDatabaseResponse;
import org.apache.paimon.rest.responses.CommitTableResponse;
import org.apache.paimon.rest.responses.ConfigResponse;
import org.apache.paimon.rest.responses.GetDatabaseResponse;
import org.apache.paimon.rest.responses.GetTableResponse;
import org.apache.paimon.rest.responses.GetTableSnapshotResponse;
import org.apache.paimon.rest.responses.GetTableTokenResponse;
import org.apache.paimon.rest.responses.GetViewResponse;
import org.apache.paimon.rest.responses.ListBranchesResponse;
import org.apache.paimon.rest.responses.ListDatabasesResponse;
import org.apache.paimon.rest.responses.ListPartitionsResponse;
import org.apache.paimon.rest.responses.ListTableDetailsResponse;
import org.apache.paimon.rest.responses.ListTablesResponse;
import org.apache.paimon.rest.responses.ListViewDetailsResponse;
import org.apache.paimon.rest.responses.ListViewsResponse;
import org.apache.paimon.rest.responses.PagedResponse;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.table.Instant;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.TableSnapshot;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.system.SystemTableLoader;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.ThreadPoolUtils;
import org.apache.paimon.view.View;
import org.apache.paimon.view.ViewChange;
import org.apache.paimon.view.ViewImpl;
import org.apache.paimon.view.ViewSchema;

public class RESTCatalog
implements Catalog {
    public static final String HEADER_PREFIX = "header.";
    public static final String MAX_RESULTS = "maxResults";
    public static final String PAGE_TOKEN = "pageToken";
    public static final String QUERY_PARAMETER_WAREHOUSE_KEY = "warehouse";
    private final RESTClient client;
    private final ResourcePaths resourcePaths;
    private final CatalogContext context;
    private final boolean dataTokenEnabled;
    private final RESTAuthFunction restAuthFunction;
    private volatile ScheduledExecutorService refreshExecutor = null;

    public RESTCatalog(CatalogContext context) {
        this(context, true);
    }

    public RESTCatalog(CatalogContext context, boolean configRequired) {
        this.client = new HttpClient((String)context.options().get(RESTCatalogOptions.URI));
        AuthSession catalogAuth = AuthSession.createAuthSession(context.options(), this.tokenRefreshExecutor());
        Options options = context.options();
        Map<String, String> baseHeaders = Collections.emptyMap();
        if (configRequired) {
            String warehouse = (String)options.get(CatalogOptions.WAREHOUSE);
            ImmutableMap queryParams = StringUtils.isNotEmpty((CharSequence)warehouse) ? ImmutableMap.of((Object)QUERY_PARAMETER_WAREHOUSE_KEY, (Object)RESTUtil.encodeString(warehouse)) : ImmutableMap.of();
            baseHeaders = RESTUtil.extractPrefixMap(context.options(), HEADER_PREFIX);
            options = new Options(this.client.get(ResourcePaths.config(), (Map<String, String>)queryParams, ConfigResponse.class, new RESTAuthFunction(Collections.emptyMap(), catalogAuth)).merge(context.options().toMap()));
            baseHeaders.putAll(RESTUtil.extractPrefixMap(options, HEADER_PREFIX));
        }
        this.restAuthFunction = new RESTAuthFunction(baseHeaders, catalogAuth);
        this.context = context = CatalogContext.create((Options)options, (FileIOLoader)context.preferIO(), (FileIOLoader)context.fallbackIO());
        this.resourcePaths = ResourcePaths.forCatalogProperties(options);
        this.dataTokenEnabled = (Boolean)options.get(RESTTokenFileIO.DATA_TOKEN_ENABLED);
    }

    @Override
    public Map<String, String> options() {
        return this.context.options().toMap();
    }

    @Override
    public RESTCatalogLoader catalogLoader() {
        return new RESTCatalogLoader(this.context);
    }

    @Override
    public List<String> listDatabases() {
        return this.listDataFromPageApi(queryParams -> this.client.get(this.resourcePaths.databases(), (Map<String, String>)queryParams, ListDatabasesResponse.class, this.restAuthFunction));
    }

    @Override
    public PagedList<String> listDatabasesPaged(@Nullable Integer maxResults, @Nullable String pageToken) {
        ListDatabasesResponse response = this.client.get(this.resourcePaths.databases(), this.buildPagedQueryParams(maxResults, pageToken), ListDatabasesResponse.class, this.restAuthFunction);
        List<String> databases = response.getDatabases();
        if (databases == null) {
            return new PagedList(Collections.emptyList(), null);
        }
        return new PagedList(databases, response.getNextPageToken());
    }

    @Override
    public void createDatabase(String name, boolean ignoreIfExists, Map<String, String> properties) throws Catalog.DatabaseAlreadyExistException {
        CatalogUtils.checkNotSystemDatabase(name);
        CreateDatabaseRequest request = new CreateDatabaseRequest(name, properties);
        try {
            this.client.post(this.resourcePaths.databases(), request, this.restAuthFunction);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new Catalog.DatabaseAlreadyExistException(name);
            }
        }
        catch (ForbiddenException e) {
            throw new Catalog.DatabaseNoPermissionException(name, e);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Database getDatabase(String name) throws Catalog.DatabaseNotExistException {
        if (CatalogUtils.isSystemDatabase(name)) {
            return Database.of(name);
        }
        try {
            GetDatabaseResponse response = this.client.get(this.resourcePaths.database(name), GetDatabaseResponse.class, this.restAuthFunction);
            HashMap<String, String> options = new HashMap<String, String>(response.getOptions());
            options.put("location", response.getLocation());
            response.putAuditOptionsTo(options);
            return new Database.DatabaseImpl(name, options, (String)options.get("comment"));
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(name);
        }
        catch (ForbiddenException e) {
            throw new Catalog.DatabaseNoPermissionException(name, e);
        }
    }

    @Override
    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws Catalog.DatabaseNotExistException, Catalog.DatabaseNotEmptyException {
        CatalogUtils.checkNotSystemDatabase(name);
        try {
            if (!cascade && !this.listTables(name).isEmpty()) {
                throw new Catalog.DatabaseNotEmptyException(name);
            }
            this.client.delete(this.resourcePaths.database(name), this.restAuthFunction);
        }
        catch (Catalog.DatabaseNotExistException | NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.DatabaseNotExistException(name);
            }
        }
        catch (ForbiddenException e) {
            throw new Catalog.DatabaseNoPermissionException(name, e);
        }
    }

    @Override
    public void alterDatabase(String name, List<PropertyChange> changes, boolean ignoreIfNotExists) throws Catalog.DatabaseNotExistException {
        CatalogUtils.checkNotSystemDatabase(name);
        try {
            Pair<Map<String, String>, Set<String>> setPropertiesToRemoveKeys = PropertyChange.getSetPropertiesToRemoveKeys(changes);
            Map updateProperties = (Map)setPropertiesToRemoveKeys.getLeft();
            Set removeKeys = (Set)setPropertiesToRemoveKeys.getRight();
            AlterDatabaseRequest request = new AlterDatabaseRequest(new ArrayList<String>(removeKeys), updateProperties);
            this.client.post(this.resourcePaths.database(name), request, AlterDatabaseResponse.class, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.DatabaseNotExistException(name);
            }
        }
        catch (ForbiddenException e) {
            throw new Catalog.DatabaseNoPermissionException(name, e);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public List<String> listTables(String databaseName) throws Catalog.DatabaseNotExistException {
        try {
            if (CatalogUtils.isSystemDatabase(databaseName)) {
                return SystemTableLoader.loadGlobalTableNames();
            }
            return this.listDataFromPageApi(queryParams -> this.client.get(this.resourcePaths.tables(databaseName), (Map<String, String>)queryParams, ListTablesResponse.class, this.restAuthFunction));
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
    }

    @Override
    public PagedList<String> listTablesPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken) throws Catalog.DatabaseNotExistException {
        try {
            ListTablesResponse response = this.client.get(this.resourcePaths.tables(databaseName), this.buildPagedQueryParams(maxResults, pageToken), ListTablesResponse.class, this.restAuthFunction);
            List<String> tables = response.getTables();
            if (tables == null) {
                return new PagedList(Collections.emptyList(), null);
            }
            return new PagedList(tables, response.getNextPageToken());
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
    }

    @Override
    public PagedList<Table> listTableDetailsPaged(String db, @Nullable Integer maxResults, @Nullable String pageToken) throws Catalog.DatabaseNotExistException {
        try {
            ListTableDetailsResponse response = this.client.get(this.resourcePaths.tableDetails(db), this.buildPagedQueryParams(maxResults, pageToken), ListTableDetailsResponse.class, this.restAuthFunction);
            List<GetTableResponse> tables = response.getTableDetails();
            if (tables == null) {
                return new PagedList(Collections.emptyList(), null);
            }
            return new PagedList(tables.stream().map(t -> this.toTable(db, (GetTableResponse)t)).collect(Collectors.toList()), response.getNextPageToken());
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(db);
        }
    }

    @Override
    public Table getTable(Identifier identifier) throws Catalog.TableNotExistException {
        return CatalogUtils.loadTable(this, identifier, path -> this.fileIOForData((Path)path, identifier), this::fileIOFromOptions, this::loadTableMetadata, null, null);
    }

    @Override
    public Optional<TableSnapshot> loadSnapshot(Identifier identifier) throws Catalog.TableNotExistException {
        GetTableSnapshotResponse response;
        try {
            response = this.client.get(this.resourcePaths.tableSnapshot(identifier.getDatabaseName(), identifier.getObjectName()), GetTableSnapshotResponse.class, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            if (StringUtils.equals((CharSequence)e.resourceType(), (CharSequence)"SNAPSHOT")) {
                return Optional.empty();
            }
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        return Optional.of(response.getSnapshot());
    }

    @Override
    public boolean supportsListObjectsPaged() {
        return true;
    }

    @Override
    public boolean supportsVersionManagement() {
        return true;
    }

    @Override
    public boolean commitSnapshot(Identifier identifier, Snapshot snapshot, List<PartitionStatistics> statistics) throws Catalog.TableNotExistException {
        CommitTableResponse response;
        CommitTableRequest request = new CommitTableRequest(snapshot, statistics);
        try {
            response = this.client.post(this.resourcePaths.commitTable(identifier.getDatabaseName(), identifier.getObjectName()), request, CommitTableResponse.class, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return response.isSuccess();
    }

    @Override
    public void rollbackTo(Identifier identifier, Instant instant) throws Catalog.TableNotExistException {
        RollbackTableRequest request = new RollbackTableRequest(instant);
        try {
            this.client.post(this.resourcePaths.rollbackTable(identifier.getDatabaseName(), identifier.getObjectName()), request, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            if (StringUtils.equals((CharSequence)e.resourceType(), (CharSequence)"SNAPSHOT")) {
                throw new IllegalArgumentException(String.format("Rollback snapshot '%s' doesn't exist.", e.resourceName()));
            }
            if (StringUtils.equals((CharSequence)e.resourceType(), (CharSequence)"TAG")) {
                throw new IllegalArgumentException(String.format("Rollback tag '%s' doesn't exist.", e.resourceName()));
            }
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    private TableMetadata loadTableMetadata(Identifier identifier) throws Catalog.TableNotExistException {
        GetTableResponse response;
        try {
            Identifier loadTableIdentifier = identifier.isSystemTable() ? new Identifier(identifier.getDatabaseName(), identifier.getTableName(), identifier.getBranchName()) : identifier;
            response = this.client.get(this.resourcePaths.table(loadTableIdentifier.getDatabaseName(), loadTableIdentifier.getObjectName()), GetTableResponse.class, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        return this.toTableMetadata(identifier.getDatabaseName(), response);
    }

    private TableMetadata toTableMetadata(String db, GetTableResponse response) {
        TableSchema schema = TableSchema.create(response.getSchemaId(), response.getSchema());
        HashMap<String, String> options = new HashMap<String, String>(schema.options());
        options.put(CoreOptions.PATH.key(), response.getPath());
        response.putAuditOptionsTo(options);
        Identifier identifier = Identifier.create(db, response.getName());
        if (identifier.getBranchName() != null) {
            options.put(CoreOptions.BRANCH.key(), identifier.getBranchName());
        }
        return new TableMetadata(schema.copy(options), response.isExternal(), response.getId());
    }

    private Table toTable(String db, GetTableResponse response) {
        Identifier identifier = Identifier.create(db, response.getName());
        try {
            return CatalogUtils.loadTable(this, identifier, path -> this.fileIOForData((Path)path, identifier), this::fileIOFromOptions, i -> this.toTableMetadata(db, response), null, null);
        }
        catch (Catalog.TableNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createTable(Identifier identifier, Schema schema, boolean ignoreIfExists) throws Catalog.TableAlreadyExistException, Catalog.DatabaseNotExistException {
        try {
            CatalogUtils.checkNotBranch(identifier, "createTable");
            CatalogUtils.checkNotSystemTable(identifier, "createTable");
            CatalogUtils.validateAutoCreateClose(schema.options());
            CreateTableRequest request = new CreateTableRequest(identifier, schema);
            this.client.post(this.resourcePaths.tables(identifier.getDatabaseName()), request, this.restAuthFunction);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new Catalog.TableAlreadyExistException(identifier);
            }
        }
        catch (NotImplementedException e) {
            throw new RuntimeException(new UnsupportedOperationException(e.getMessage()));
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(identifier.getDatabaseName());
        }
        catch (BadRequestException e) {
            throw new RuntimeException(new IllegalArgumentException(e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void renameTable(Identifier fromTable, Identifier toTable, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.TableAlreadyExistException {
        CatalogUtils.checkNotBranch(fromTable, "renameTable");
        CatalogUtils.checkNotBranch(toTable, "renameTable");
        CatalogUtils.checkNotSystemTable(fromTable, "renameTable");
        CatalogUtils.checkNotSystemTable(toTable, "renameTable");
        try {
            RenameTableRequest request = new RenameTableRequest(fromTable, toTable);
            this.client.post(this.resourcePaths.renameTable(), request, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.TableNotExistException(fromTable);
            }
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(fromTable, (Throwable)e);
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.TableAlreadyExistException(toTable);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void alterTable(Identifier identifier, List<SchemaChange> changes, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        CatalogUtils.checkNotSystemTable(identifier, "alterTable");
        try {
            AlterTableRequest request = new AlterTableRequest(changes);
            this.client.post(this.resourcePaths.table(identifier.getDatabaseName(), identifier.getObjectName()), request, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                if (StringUtils.equals((CharSequence)e.resourceType(), (CharSequence)"TABLE")) {
                    throw new Catalog.TableNotExistException(identifier);
                }
                if (StringUtils.equals((CharSequence)e.resourceType(), (CharSequence)"COLUMN")) {
                    throw new Catalog.ColumnNotExistException(identifier, e.resourceName());
                }
            }
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.ColumnAlreadyExistException(identifier, e.resourceName());
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (ServiceFailureException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (NotImplementedException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        catch (BadRequestException e) {
            throw new RuntimeException(new IllegalArgumentException(e.getMessage()));
        }
    }

    @Override
    public void dropTable(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        CatalogUtils.checkNotBranch(identifier, "dropTable");
        CatalogUtils.checkNotSystemTable(identifier, "dropTable");
        try {
            this.client.delete(this.resourcePaths.table(identifier.getDatabaseName(), identifier.getObjectName()), this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.TableNotExistException(identifier);
            }
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public void markDonePartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
        try {
            MarkDonePartitionsRequest request = new MarkDonePartitionsRequest(partitions);
            this.client.post(this.resourcePaths.markDonePartitions(identifier.getDatabaseName(), identifier.getObjectName()), request, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
    }

    @Override
    public List<Partition> listPartitions(Identifier identifier) throws Catalog.TableNotExistException {
        try {
            return this.listDataFromPageApi(queryParams -> this.client.get(this.resourcePaths.partitions(identifier.getDatabaseName(), identifier.getObjectName()), (Map<String, String>)queryParams, ListPartitionsResponse.class, this.restAuthFunction));
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (NotImplementedException e) {
            return CatalogUtils.listPartitionsFromFileSystem(this.getTable(identifier));
        }
    }

    @Override
    public PagedList<Partition> listPartitionsPaged(Identifier identifier, @Nullable Integer maxResults, @Nullable String pageToken) throws Catalog.TableNotExistException {
        try {
            ListPartitionsResponse response = this.client.get(this.resourcePaths.partitions(identifier.getDatabaseName(), identifier.getObjectName()), this.buildPagedQueryParams(maxResults, pageToken), ListPartitionsResponse.class, this.restAuthFunction);
            List<Partition> partitions = response.getPartitions();
            if (partitions == null) {
                return new PagedList(Collections.emptyList(), null);
            }
            return new PagedList(partitions, response.getNextPageToken());
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (NotImplementedException e) {
            return new PagedList(CatalogUtils.listPartitionsFromFileSystem(this.getTable(identifier)), null);
        }
    }

    @Override
    public void createBranch(Identifier identifier, String branch, @Nullable String fromTag) throws Catalog.TableNotExistException, Catalog.BranchAlreadyExistException, Catalog.TagNotExistException {
        try {
            CreateBranchRequest request = new CreateBranchRequest(branch, fromTag);
            this.client.post(this.resourcePaths.branches(identifier.getDatabaseName(), identifier.getObjectName()), request, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            if (StringUtils.equals((CharSequence)e.resourceType(), (CharSequence)"TABLE")) {
                throw new Catalog.TableNotExistException(identifier, (Throwable)e);
            }
            if (StringUtils.equals((CharSequence)e.resourceType(), (CharSequence)"TAG")) {
                throw new Catalog.TagNotExistException(identifier, fromTag, e);
            }
            throw e;
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.BranchAlreadyExistException(identifier, branch, e);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void dropBranch(Identifier identifier, String branch) throws Catalog.BranchNotExistException {
        try {
            this.client.delete(this.resourcePaths.branch(identifier.getDatabaseName(), identifier.getObjectName(), branch), this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.BranchNotExistException(identifier, branch, e);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public void fastForward(Identifier identifier, String branch) throws Catalog.BranchNotExistException {
        try {
            ForwardBranchRequest request = new ForwardBranchRequest();
            this.client.post(this.resourcePaths.forwardBranch(identifier.getDatabaseName(), identifier.getObjectName(), branch), request, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.BranchNotExistException(identifier, branch, e);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public List<String> listBranches(Identifier identifier) throws Catalog.TableNotExistException {
        try {
            ListBranchesResponse response = this.client.get(this.resourcePaths.branches(identifier.getDatabaseName(), identifier.getObjectName()), ListBranchesResponse.class, this.restAuthFunction);
            if (response.branches() == null) {
                return Collections.emptyList();
            }
            return response.branches();
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
    }

    @Override
    public void createPartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
    }

    @Override
    public void dropPartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
        Table table = this.getTable(identifier);
        try (BatchTableCommit commit = table.newBatchWriteBuilder().newCommit();){
            commit.truncatePartitions(partitions);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void alterPartitions(Identifier identifier, List<PartitionStatistics> partitions) throws Catalog.TableNotExistException {
    }

    @Override
    public View getView(Identifier identifier) throws Catalog.ViewNotExistException {
        try {
            GetViewResponse response = this.client.get(this.resourcePaths.view(identifier.getDatabaseName(), identifier.getObjectName()), GetViewResponse.class, this.restAuthFunction);
            return this.toView(identifier.getDatabaseName(), response);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.ViewNotExistException(identifier);
        }
    }

    @Override
    public void dropView(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException {
        block2: {
            try {
                this.client.delete(this.resourcePaths.view(identifier.getDatabaseName(), identifier.getObjectName()), this.restAuthFunction);
            }
            catch (NoSuchResourceException e) {
                if (ignoreIfNotExists) break block2;
                throw new Catalog.ViewNotExistException(identifier);
            }
        }
    }

    @Override
    public void createView(Identifier identifier, View view, boolean ignoreIfExists) throws Catalog.ViewAlreadyExistException, Catalog.DatabaseNotExistException {
        try {
            ViewSchema schema = new ViewSchema(view.rowType().getFields(), view.query(), view.dialects(), view.comment().orElse(null), view.options());
            CreateViewRequest request = new CreateViewRequest(identifier, schema);
            this.client.post(this.resourcePaths.views(identifier.getDatabaseName()), request, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(identifier.getDatabaseName());
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new Catalog.ViewAlreadyExistException(identifier);
            }
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public List<String> listViews(String databaseName) throws Catalog.DatabaseNotExistException {
        try {
            return this.listDataFromPageApi(queryParams -> this.client.get(this.resourcePaths.views(databaseName), (Map<String, String>)queryParams, ListViewsResponse.class, this.restAuthFunction));
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
    }

    @Override
    public PagedList<String> listViewsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken) throws Catalog.DatabaseNotExistException {
        try {
            ListViewsResponse response = this.client.get(this.resourcePaths.views(databaseName), this.buildPagedQueryParams(maxResults, pageToken), ListViewsResponse.class, this.restAuthFunction);
            List<String> views = response.getViews();
            if (views == null) {
                return new PagedList(Collections.emptyList(), null);
            }
            return new PagedList(views, response.getNextPageToken());
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
    }

    @Override
    public PagedList<View> listViewDetailsPaged(String db, @Nullable Integer maxResults, @Nullable String pageToken) throws Catalog.DatabaseNotExistException {
        try {
            ListViewDetailsResponse response = this.client.get(this.resourcePaths.viewDetails(db), this.buildPagedQueryParams(maxResults, pageToken), ListViewDetailsResponse.class, this.restAuthFunction);
            List<GetViewResponse> views = response.getViewDetails();
            if (views == null) {
                return new PagedList(Collections.emptyList(), null);
            }
            return new PagedList(views.stream().map(v -> this.toView(db, (GetViewResponse)v)).collect(Collectors.toList()), response.getNextPageToken());
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.DatabaseNotExistException(db);
        }
    }

    private ViewImpl toView(String db, GetViewResponse response) {
        ViewSchema schema = response.getSchema();
        HashMap<String, String> options = new HashMap<String, String>(schema.options());
        response.putAuditOptionsTo(options);
        return new ViewImpl(Identifier.create(db, response.getName()), schema.fields(), schema.query(), schema.dialects(), schema.comment(), options);
    }

    @Override
    public void renameView(Identifier fromView, Identifier toView, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException, Catalog.ViewAlreadyExistException {
        try {
            RenameTableRequest request = new RenameTableRequest(fromView, toView);
            this.client.post(this.resourcePaths.renameView(), request, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            if (!ignoreIfNotExists) {
                throw new Catalog.ViewNotExistException(fromView);
            }
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.ViewAlreadyExistException(toView);
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void alterView(Identifier identifier, List<ViewChange> viewChanges, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException, Catalog.DialectAlreadyExistException, Catalog.DialectNotExistException {
        try {
            AlterViewRequest request = new AlterViewRequest(viewChanges);
            this.client.post(this.resourcePaths.view(identifier.getDatabaseName(), identifier.getObjectName()), request, this.restAuthFunction);
        }
        catch (AlreadyExistsException e) {
            throw new Catalog.DialectAlreadyExistException(identifier, e.resourceName());
        }
        catch (NoSuchResourceException e) {
            if (StringUtils.equals((CharSequence)e.resourceType(), (CharSequence)"DIALECT")) {
                throw new Catalog.DialectNotExistException(identifier, e.resourceName());
            }
            if (!ignoreIfNotExists) {
                throw new Catalog.ViewNotExistException(identifier);
            }
        }
        catch (BadRequestException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public boolean caseSensitive() {
        return this.context.options().getOptional(CatalogOptions.CASE_SENSITIVE).orElse(true);
    }

    @Override
    public void close() throws Exception {
        if (this.refreshExecutor != null) {
            this.refreshExecutor.shutdownNow();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    @VisibleForTesting
    Map<String, String> headers(RESTAuthParameter restAuthParameter) {
        return this.restAuthFunction.apply(restAuthParameter);
    }

    protected GetTableTokenResponse loadTableToken(Identifier identifier) throws Catalog.TableNotExistException {
        GetTableTokenResponse response;
        try {
            response = this.client.get(this.resourcePaths.tableToken(identifier.getDatabaseName(), identifier.getObjectName()), GetTableTokenResponse.class, this.restAuthFunction);
        }
        catch (NoSuchResourceException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (ForbiddenException e) {
            throw new Catalog.TableNoPermissionException(identifier, (Throwable)e);
        }
        return response;
    }

    protected <T> List<T> listDataFromPageApi(Function<Map<String, String>, PagedResponse<T>> pageApi) {
        PagedResponse<T> response;
        ArrayList<T> results = new ArrayList<T>();
        HashMap queryParams = Maps.newHashMap();
        String pageToken = null;
        do {
            if (pageToken != null) {
                queryParams.put(PAGE_TOKEN, pageToken);
            }
            response = pageApi.apply(queryParams);
            pageToken = response.getNextPageToken();
            if (response.data() == null) continue;
            results.addAll(response.data());
        } while (pageToken != null && response.data() != null && !response.data().isEmpty() && StringUtils.isNotEmpty((CharSequence)pageToken));
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService tokenRefreshExecutor() {
        if (this.refreshExecutor == null) {
            RESTCatalog rESTCatalog = this;
            synchronized (rESTCatalog) {
                if (this.refreshExecutor == null) {
                    this.refreshExecutor = ThreadPoolUtils.createScheduledThreadPool((int)1, (String)"token-refresh-thread");
                }
            }
        }
        return this.refreshExecutor;
    }

    private FileIO fileIOForData(Path path, Identifier identifier) {
        return this.dataTokenEnabled ? new RESTTokenFileIO(this.catalogLoader(), this, identifier, path) : this.fileIOFromOptions(path);
    }

    private FileIO fileIOFromOptions(Path path) {
        try {
            return FileIO.get((Path)path, (CatalogContext)this.context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<String, String> buildPagedQueryParams(@Nullable Integer maxResults, @Nullable String pageToken) {
        HashMap queryParams = Maps.newHashMap();
        if (Objects.nonNull(maxResults) && maxResults > 0) {
            queryParams.put(MAX_RESULTS, maxResults.toString());
        }
        if (Objects.nonNull(pageToken)) {
            queryParams.put(PAGE_TOKEN, pageToken);
        }
        return queryParams;
    }
}

