/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.postpone;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.KeyValue;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.RecordWriter;

public class PostponeBucketWriter
implements RecordWriter<KeyValue> {
    private final KeyValueFileWriterFactory writerFactory;
    private RollingFileWriter<KeyValue, DataFileMeta> writer;

    public PostponeBucketWriter(KeyValueFileWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
        this.writer = null;
    }

    @Override
    public void write(KeyValue record) throws Exception {
        if (this.writer == null) {
            this.writer = this.writerFactory.createRollingMergeTreeFileWriter(0, FileSource.APPEND);
        }
        this.writer.write(record);
    }

    @Override
    public void compact(boolean fullCompaction) throws Exception {
    }

    @Override
    public void addNewFiles(List<DataFileMeta> files) {
    }

    @Override
    public Collection<DataFileMeta> dataFiles() {
        return Collections.emptyList();
    }

    @Override
    public long maxSequenceNumber() {
        return 0L;
    }

    @Override
    public CommitIncrement prepareCommit(boolean waitCompaction) throws Exception {
        Object newFiles = Collections.emptyList();
        if (this.writer != null) {
            this.writer.close();
            newFiles = this.writer.result();
            this.writer = null;
        }
        return new CommitIncrement(new DataIncrement((List<DataFileMeta>)newFiles, Collections.emptyList(), Collections.emptyList()), CompactIncrement.emptyIncrement(), null);
    }

    @Override
    public boolean compactNotCompleted() {
        return false;
    }

    @Override
    public void sync() throws Exception {
    }

    @Override
    public void withInsertOnly(boolean insertOnly) {
    }

    @Override
    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.abort();
            this.writer = null;
        }
    }
}

