/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition.actions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.partition.actions.HttpReportMarkDoneException;
import org.apache.paimon.partition.actions.PartitionMarkDoneAction;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.paimon.shade.okhttp3.ConnectionSpec;
import org.apache.paimon.shade.okhttp3.Dispatcher;
import org.apache.paimon.shade.okhttp3.Headers;
import org.apache.paimon.shade.okhttp3.MediaType;
import org.apache.paimon.shade.okhttp3.OkHttpClient;
import org.apache.paimon.shade.okhttp3.Request;
import org.apache.paimon.shade.okhttp3.RequestBody;
import org.apache.paimon.shade.okhttp3.Response;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.ThreadPoolUtils;

public class HttpReportMarkDoneAction
implements PartitionMarkDoneAction {
    private OkHttpClient client;
    private String url;
    private ObjectMapper mapper;
    private static final MediaType MEDIA_TYPE = MediaType.parse("application/json");
    private String tableName;
    private String location;
    private String params;
    private static final String RESPONSE_SUCCESS = "SUCCESS";
    private static final String THREAD_NAME = "PAIMON-HTTP-REPORT-MARK-DONE-ACTION-THREAD";

    @Override
    public void open(FileStoreTable fileStoreTable, CoreOptions options) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)options.httpReportMarkDoneActionUrl()) ? 1 : 0) != 0, (Object)String.format("Parameter %s must be non-empty when you use `http-report` partition mark done action.", CoreOptions.PARTITION_MARK_DONE_ACTION_URL.key()));
        this.params = options.httpReportMarkDoneActionParams();
        this.url = options.httpReportMarkDoneActionUrl();
        this.tableName = fileStoreTable.fullName();
        this.location = fileStoreTable.location().toString();
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().dispatcher(new Dispatcher(ThreadPoolUtils.createCachedThreadPool((int)1, (String)THREAD_NAME, new SynchronousQueue()))).retryOnConnectionFailure(true).connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT)).connectTimeout(options.httpReportMarkDoneActionTimeout()).readTimeout(options.httpReportMarkDoneActionTimeout());
        this.client = builder.build();
    }

    @Override
    public void markDone(String partition) throws Exception {
        HttpReportMarkDoneResponse response = this.post(new HttpReportMarkDoneRequest(this.params, this.tableName, this.location, partition), Collections.emptyMap());
        Preconditions.checkState((boolean)this.reportIsSuccess(response), (Object)String.format("The http-report action's response attribute `result` should be 'SUCCESS' but is '%s'.", response.getResult()));
    }

    private boolean reportIsSuccess(HttpReportMarkDoneResponse response) {
        return response != null && RESPONSE_SUCCESS.equalsIgnoreCase(response.getResult());
    }

    @Override
    public void close() throws IOException {
        try {
            this.client.dispatcher().cancelAll();
            this.client.connectionPool().evictAll();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpReportMarkDoneResponse post(HttpReportMarkDoneRequest body, Map<String, String> headers) throws IOException {
        RequestBody requestBody = RequestBody.create(this.mapper.writeValueAsBytes((Object)body), MEDIA_TYPE);
        Request request = new Request.Builder().url(this.url).post(requestBody).headers(Headers.of(headers)).build();
        try (Response response = this.client.newCall(request).execute();){
            String responseBodyStr;
            String string = responseBodyStr = response.body() != null ? response.body().string() : null;
            if (!response.isSuccessful() || StringUtils.isNullOrWhitespaceOnly((String)responseBodyStr)) {
                String string2;
                if (response.isSuccessful()) {
                    string2 = "ResponseBody is null or empty.";
                    throw new HttpReportMarkDoneException(string2);
                }
                string2 = String.format("Response is not successful, response is %s", response);
                throw new HttpReportMarkDoneException(string2);
            }
            HttpReportMarkDoneResponse httpReportMarkDoneResponse = (HttpReportMarkDoneResponse)this.mapper.readValue(responseBodyStr, HttpReportMarkDoneResponse.class);
            return httpReportMarkDoneResponse;
        }
        catch (HttpReportMarkDoneException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpReportMarkDoneException(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @VisibleForTesting
    public static class HttpReportMarkDoneResponse {
        private static final String RESULT = "result";
        @JsonProperty(value="result")
        private final String result;

        public HttpReportMarkDoneResponse(@JsonProperty(value="result") String result) {
            this.result = result;
        }

        @JsonGetter(value="result")
        public String getResult() {
            return this.result;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @VisibleForTesting
    public static class HttpReportMarkDoneRequest {
        private static final String MARK_DONE_PARTITION = "partition";
        private static final String TABLE = "table";
        private static final String PATH = "path";
        private static final String PARAMS = "params";
        @JsonProperty(value="partition")
        private final String partition;
        @JsonProperty(value="table")
        private final String table;
        @JsonProperty(value="path")
        private final String path;
        @JsonProperty(value="params")
        private final String params;

        @JsonCreator
        public HttpReportMarkDoneRequest(@JsonProperty(value="params") String params, @JsonProperty(value="table") String table, @JsonProperty(value="path") String path, @JsonProperty(value="partition") String partition) {
            this.params = params;
            this.table = table;
            this.path = path;
            this.partition = partition;
        }

        @JsonGetter(value="partition")
        public String getPartition() {
            return this.partition;
        }

        @JsonGetter(value="table")
        public String getTable() {
            return this.table;
        }

        @JsonGetter(value="path")
        public String getPath() {
            return this.path;
        }

        @JsonGetter(value="params")
        public String getParams() {
            return this.params;
        }
    }
}

