/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.SnapshotCommit;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.IndexManifestFile;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.manifest.SimpleFileEntry;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.ManifestFileMerger;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.operation.metrics.CommitMetrics;
import org.apache.paimon.operation.metrics.CommitStats;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.DataFilePathFactories;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreCommitImpl
implements FileStoreCommit {
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreCommitImpl.class);
    private final SnapshotCommit snapshotCommit;
    private final FileIO fileIO;
    private final SchemaManager schemaManager;
    private final String tableName;
    private final String commitUser;
    private final RowType partitionType;
    private final String partitionDefaultName;
    private final FileStorePathFactory pathFactory;
    private final SnapshotManager snapshotManager;
    private final ManifestFile manifestFile;
    private final ManifestList manifestList;
    private final IndexManifestFile indexManifestFile;
    private final FileStoreScan scan;
    private final int numBucket;
    private final MemorySize manifestTargetSize;
    private final MemorySize manifestFullCompactionSize;
    private final int manifestMergeMinCount;
    private final boolean dynamicPartitionOverwrite;
    @Nullable
    private final Comparator<InternalRow> keyComparator;
    private final String branchName;
    @Nullable
    private final Integer manifestReadParallelism;
    private final List<CommitCallback> commitCallbacks;
    private final StatsFileHandler statsFileHandler;
    private final BucketMode bucketMode;
    private final long commitTimeout;
    private final int commitMaxRetries;
    private final InternalRowPartitionComputer partitionComputer;
    private boolean ignoreEmptyCommit;
    private CommitMetrics commitMetrics;
    @Nullable
    private PartitionExpire partitionExpire;

    public FileStoreCommitImpl(SnapshotCommit snapshotCommit, FileIO fileIO, SchemaManager schemaManager, String tableName, String commitUser, RowType partitionType, CoreOptions options, String partitionDefaultName, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, IndexManifestFile.Factory indexManifestFileFactory, FileStoreScan scan, int numBucket, MemorySize manifestTargetSize, MemorySize manifestFullCompactionSize, int manifestMergeMinCount, boolean dynamicPartitionOverwrite, @Nullable Comparator<InternalRow> keyComparator, String branchName, StatsFileHandler statsFileHandler, BucketMode bucketMode, @Nullable Integer manifestReadParallelism, List<CommitCallback> commitCallbacks, int commitMaxRetries, long commitTimeout) {
        this.snapshotCommit = snapshotCommit;
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.tableName = tableName;
        this.commitUser = commitUser;
        this.partitionType = partitionType;
        this.partitionDefaultName = partitionDefaultName;
        this.pathFactory = pathFactory;
        this.snapshotManager = snapshotManager;
        this.manifestFile = manifestFileFactory.create();
        this.manifestList = manifestListFactory.create();
        this.indexManifestFile = indexManifestFileFactory.create();
        this.scan = scan;
        if (options.manifestDeleteFileDropStats()) {
            this.scan.dropStats();
        }
        this.numBucket = numBucket;
        this.manifestTargetSize = manifestTargetSize;
        this.manifestFullCompactionSize = manifestFullCompactionSize;
        this.manifestMergeMinCount = manifestMergeMinCount;
        this.dynamicPartitionOverwrite = dynamicPartitionOverwrite;
        this.keyComparator = keyComparator;
        this.branchName = branchName;
        this.manifestReadParallelism = manifestReadParallelism;
        this.commitCallbacks = commitCallbacks;
        this.commitMaxRetries = commitMaxRetries;
        this.commitTimeout = commitTimeout;
        this.partitionComputer = new InternalRowPartitionComputer(options.partitionDefaultName(), partitionType, partitionType.getFieldNames().toArray(new String[0]), options.legacyPartitionName());
        this.ignoreEmptyCommit = true;
        this.commitMetrics = null;
        this.statsFileHandler = statsFileHandler;
        this.bucketMode = bucketMode;
    }

    @Override
    public FileStoreCommit ignoreEmptyCommit(boolean ignoreEmptyCommit) {
        this.ignoreEmptyCommit = ignoreEmptyCommit;
        return this;
    }

    @Override
    public FileStoreCommit withPartitionExpire(PartitionExpire partitionExpire) {
        this.partitionExpire = partitionExpire;
        return this;
    }

    @Override
    public List<ManifestCommittable> filterCommitted(List<ManifestCommittable> committables) {
        if (committables.isEmpty()) {
            return committables;
        }
        for (int i = 1; i < committables.size(); ++i) {
            Preconditions.checkArgument((committables.get(i).identifier() > committables.get(i - 1).identifier() ? 1 : 0) != 0, (Object)"Committables must be sorted according to identifiers before filtering. This is unexpected.");
        }
        Optional<Snapshot> latestSnapshot = this.snapshotManager.latestSnapshotOfUser(this.commitUser);
        if (latestSnapshot.isPresent()) {
            ArrayList<ManifestCommittable> result = new ArrayList<ManifestCommittable>();
            for (ManifestCommittable committable : committables) {
                if (committable.identifier() > latestSnapshot.get().commitIdentifier()) {
                    result.add(committable);
                    continue;
                }
                this.commitCallbacks.forEach(callback -> callback.retry(committable));
            }
            return result;
        }
        return committables;
    }

    @Override
    public void commit(ManifestCommittable committable, Map<String, String> properties) {
        this.commit(committable, properties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(ManifestCommittable committable, Map<String, String> properties, boolean checkAppendFiles) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ready to commit\n{}", (Object)committable.toString());
        }
        long started = System.nanoTime();
        int generatedSnapshot = 0;
        int attempts = 0;
        Snapshot latestSnapshot = null;
        Long safeLatestSnapshotId = null;
        ArrayList<SimpleFileEntry> baseEntries = new ArrayList<SimpleFileEntry>();
        ArrayList<ManifestEntry> appendTableFiles = new ArrayList<ManifestEntry>();
        ArrayList<ManifestEntry> appendChangelog = new ArrayList<ManifestEntry>();
        ArrayList<ManifestEntry> compactTableFiles = new ArrayList<ManifestEntry>();
        ArrayList<ManifestEntry> compactChangelog = new ArrayList<ManifestEntry>();
        ArrayList<IndexManifestEntry> appendHashIndexFiles = new ArrayList<IndexManifestEntry>();
        ArrayList<IndexManifestEntry> compactDvIndexFiles = new ArrayList<IndexManifestEntry>();
        this.collectChanges(committable.fileCommittables(), appendTableFiles, appendChangelog, compactTableFiles, compactChangelog, appendHashIndexFiles, compactDvIndexFiles);
        try {
            List<SimpleFileEntry> appendSimpleEntries = SimpleFileEntry.from(appendTableFiles);
            if (!(this.ignoreEmptyCommit && appendTableFiles.isEmpty() && appendChangelog.isEmpty() && appendHashIndexFiles.isEmpty())) {
                latestSnapshot = this.snapshotManager.latestSnapshot();
                if (latestSnapshot != null && checkAppendFiles) {
                    baseEntries.addAll(this.readAllEntriesFromChangedPartitions(latestSnapshot, appendTableFiles, compactTableFiles));
                    this.noConflictsOrFail(latestSnapshot.commitUser(), baseEntries, appendSimpleEntries);
                    safeLatestSnapshotId = latestSnapshot.id();
                }
                attempts += this.tryCommit(appendTableFiles, appendChangelog, appendHashIndexFiles, committable.identifier(), committable.watermark(), committable.logOffsets(), Snapshot.CommitKind.APPEND, FileStoreCommitImpl.noConflictCheck(), null);
                ++generatedSnapshot;
            }
            if (!(compactTableFiles.isEmpty() && compactChangelog.isEmpty() && compactDvIndexFiles.isEmpty())) {
                if (safeLatestSnapshotId != null) {
                    baseEntries.addAll(appendSimpleEntries);
                    this.noConflictsOrFail(latestSnapshot.commitUser(), baseEntries, SimpleFileEntry.from(compactTableFiles));
                    safeLatestSnapshotId = safeLatestSnapshotId + 1L;
                }
                attempts += this.tryCommit(compactTableFiles, compactChangelog, compactDvIndexFiles, committable.identifier(), committable.watermark(), committable.logOffsets(), Snapshot.CommitKind.COMPACT, FileStoreCommitImpl.hasConflictChecked(safeLatestSnapshotId), null);
                ++generatedSnapshot;
            }
        }
        finally {
            long commitDuration = (System.nanoTime() - started) / 1000000L;
            if (this.commitMetrics != null) {
                this.reportCommit(appendTableFiles, appendChangelog, compactTableFiles, compactChangelog, commitDuration, generatedSnapshot, attempts);
            }
        }
    }

    private void reportCommit(List<ManifestEntry> appendTableFiles, List<ManifestEntry> appendChangelogFiles, List<ManifestEntry> compactTableFiles, List<ManifestEntry> compactChangelogFiles, long commitDuration, int generatedSnapshots, int attempts) {
        CommitStats commitStats = new CommitStats(appendTableFiles, appendChangelogFiles, compactTableFiles, compactChangelogFiles, commitDuration, generatedSnapshots, attempts);
        this.commitMetrics.reportCommit(commitStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overwrite(Map<String, String> partition, ManifestCommittable committable, Map<String, String> properties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ready to overwrite partition {}\nManifestCommittable: {}\nProperties: {}", new Object[]{partition, committable, properties});
        }
        long started = System.nanoTime();
        int generatedSnapshot = 0;
        int attempts = 0;
        ArrayList<ManifestEntry> appendTableFiles = new ArrayList<ManifestEntry>();
        ArrayList<ManifestEntry> appendChangelog = new ArrayList<ManifestEntry>();
        ArrayList<ManifestEntry> compactTableFiles = new ArrayList<ManifestEntry>();
        ArrayList<ManifestEntry> compactChangelog = new ArrayList<ManifestEntry>();
        ArrayList<IndexManifestEntry> appendHashIndexFiles = new ArrayList<IndexManifestEntry>();
        ArrayList<IndexManifestEntry> compactDvIndexFiles = new ArrayList<IndexManifestEntry>();
        this.collectChanges(committable.fileCommittables(), appendTableFiles, appendChangelog, compactTableFiles, compactChangelog, appendHashIndexFiles, compactDvIndexFiles);
        if (!appendChangelog.isEmpty() || !compactChangelog.isEmpty()) {
            StringBuilder warnMessage = new StringBuilder("Overwrite mode currently does not commit any changelog.\nPlease make sure that the partition you're overwriting is not being consumed by a streaming reader.\nIgnored changelog files are:\n");
            for (ManifestEntry entry : appendChangelog) {
                warnMessage.append("  * ").append(entry.toString()).append("\n");
            }
            for (ManifestEntry entry : compactChangelog) {
                warnMessage.append("  * ").append(entry.toString()).append("\n");
            }
            LOG.warn(warnMessage.toString());
        }
        try {
            boolean skipOverwrite = false;
            PartitionPredicate partitionFilter = null;
            if (this.dynamicPartitionOverwrite) {
                if (appendTableFiles.isEmpty()) {
                    skipOverwrite = true;
                } else {
                    Set<BinaryRow> partitions = appendTableFiles.stream().map(ManifestEntry::partition).collect(Collectors.toSet());
                    partitionFilter = PartitionPredicate.fromMultiple(this.partitionType, partitions);
                }
            } else {
                Predicate partitionPredicate = PartitionPredicate.createPartitionPredicate(partition, this.partitionType, this.partitionDefaultName);
                partitionFilter = PartitionPredicate.fromPredicate(this.partitionType, partitionPredicate);
                if (partitionFilter != null) {
                    for (ManifestEntry entry : appendTableFiles) {
                        if (partitionFilter.test(entry.partition())) continue;
                        throw new IllegalArgumentException("Trying to overwrite partition " + partition + ", but the changes in " + this.pathFactory.getPartitionString(entry.partition()) + " does not belong to this partition");
                    }
                }
            }
            if (!skipOverwrite) {
                attempts += this.tryOverwrite(partitionFilter, appendTableFiles, appendHashIndexFiles, committable.identifier(), committable.watermark(), committable.logOffsets());
                ++generatedSnapshot;
            }
            if (!compactTableFiles.isEmpty() || !compactDvIndexFiles.isEmpty()) {
                attempts += this.tryCommit(compactTableFiles, Collections.emptyList(), compactDvIndexFiles, committable.identifier(), committable.watermark(), committable.logOffsets(), Snapshot.CommitKind.COMPACT, FileStoreCommitImpl.mustConflictCheck(), null);
                ++generatedSnapshot;
            }
        }
        finally {
            long commitDuration = (System.nanoTime() - started) / 1000000L;
            if (this.commitMetrics != null) {
                this.reportCommit(appendTableFiles, Collections.emptyList(), compactTableFiles, Collections.emptyList(), commitDuration, generatedSnapshot, attempts);
            }
        }
    }

    @Override
    public void dropPartitions(List<Map<String, String>> partitions, long commitIdentifier) {
        PartitionPredicate partitionFilter;
        boolean fullMode;
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"Partitions list cannot be empty.");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ready to drop partitions {}", (Object)partitions.stream().map(Objects::toString).collect(Collectors.joining(",")));
        }
        if (fullMode = partitions.stream().allMatch(part -> part.size() == this.partitionType.getFieldCount())) {
            List<BinaryRow> binaryPartitions = PartitionPredicate.createBinaryPartitions(partitions, this.partitionType, this.partitionDefaultName);
            partitionFilter = PartitionPredicate.fromMultiple(this.partitionType, binaryPartitions);
        } else {
            Predicate predicate = partitions.stream().map(partition -> PartitionPredicate.createPartitionPredicate(partition, this.partitionType, this.partitionDefaultName)).reduce((xva$0, xva$1) -> PredicateBuilder.or((Predicate[])new Predicate[]{xva$0, xva$1})).orElseThrow(() -> new RuntimeException("Failed to get partition filter."));
            partitionFilter = PartitionPredicate.fromPredicate(this.partitionType, predicate);
        }
        this.tryOverwrite(partitionFilter, Collections.emptyList(), Collections.emptyList(), commitIdentifier, null, new HashMap<Integer, Long>());
    }

    @Override
    public void truncateTable(long commitIdentifier) {
        this.tryOverwrite(null, Collections.emptyList(), Collections.emptyList(), commitIdentifier, null, new HashMap<Integer, Long>());
    }

    @Override
    public void abort(List<CommitMessage> commitMessages) {
        DataFilePathFactories factories = new DataFilePathFactories(this.pathFactory);
        for (CommitMessage message : commitMessages) {
            DataFilePathFactory pathFactory = factories.get(message.partition(), message.bucket());
            CommitMessageImpl commitMessage = (CommitMessageImpl)message;
            ArrayList<DataFileMeta> toDelete = new ArrayList<DataFileMeta>();
            toDelete.addAll(commitMessage.newFilesIncrement().newFiles());
            toDelete.addAll(commitMessage.newFilesIncrement().changelogFiles());
            toDelete.addAll(commitMessage.compactIncrement().compactAfter());
            toDelete.addAll(commitMessage.compactIncrement().changelogFiles());
            for (DataFileMeta file : toDelete) {
                this.fileIO.deleteQuietly(pathFactory.toPath(file));
            }
        }
    }

    @Override
    public FileStoreCommit withMetrics(CommitMetrics metrics) {
        this.commitMetrics = metrics;
        return this;
    }

    @Override
    public void commitStatistics(Statistics stats, long commitIdentifier) {
        String statsFileName = this.statsFileHandler.writeStats(stats);
        this.tryCommit(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), commitIdentifier, null, Collections.emptyMap(), Snapshot.CommitKind.ANALYZE, FileStoreCommitImpl.noConflictCheck(), statsFileName);
    }

    @Override
    public FileStorePathFactory pathFactory() {
        return this.pathFactory;
    }

    @Override
    public FileIO fileIO() {
        return this.fileIO;
    }

    private void collectChanges(List<CommitMessage> commitMessages, List<ManifestEntry> appendTableFiles, List<ManifestEntry> appendChangelog, List<ManifestEntry> compactTableFiles, List<ManifestEntry> compactChangelog, List<IndexManifestEntry> appendHashIndexFiles, List<IndexManifestEntry> compactDvIndexFiles) {
        for (CommitMessage message : commitMessages) {
            CommitMessageImpl commitMessage = (CommitMessageImpl)message;
            commitMessage.newFilesIncrement().newFiles().forEach(m -> appendTableFiles.add(this.makeEntry(FileKind.ADD, commitMessage, (DataFileMeta)m)));
            commitMessage.newFilesIncrement().deletedFiles().forEach(m -> appendTableFiles.add(this.makeEntry(FileKind.DELETE, commitMessage, (DataFileMeta)m)));
            commitMessage.newFilesIncrement().changelogFiles().forEach(m -> appendChangelog.add(this.makeEntry(FileKind.ADD, commitMessage, (DataFileMeta)m)));
            commitMessage.compactIncrement().compactBefore().forEach(m -> compactTableFiles.add(this.makeEntry(FileKind.DELETE, commitMessage, (DataFileMeta)m)));
            commitMessage.compactIncrement().compactAfter().forEach(m -> compactTableFiles.add(this.makeEntry(FileKind.ADD, commitMessage, (DataFileMeta)m)));
            commitMessage.compactIncrement().changelogFiles().forEach(m -> compactChangelog.add(this.makeEntry(FileKind.ADD, commitMessage, (DataFileMeta)m)));
            commitMessage.indexIncrement().newIndexFiles().forEach(f -> {
                switch (f.indexType()) {
                    case "HASH": {
                        appendHashIndexFiles.add(new IndexManifestEntry(FileKind.ADD, commitMessage.partition(), commitMessage.bucket(), (IndexFileMeta)f));
                        break;
                    }
                    case "DELETION_VECTORS": {
                        compactDvIndexFiles.add(new IndexManifestEntry(FileKind.ADD, commitMessage.partition(), commitMessage.bucket(), (IndexFileMeta)f));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown index type: " + f.indexType());
                    }
                }
            });
            commitMessage.indexIncrement().deletedIndexFiles().forEach(f -> {
                if (!f.indexType().equals("DELETION_VECTORS")) {
                    throw new RuntimeException("This index type is not supported to delete: " + f.indexType());
                }
                compactDvIndexFiles.add(new IndexManifestEntry(FileKind.DELETE, commitMessage.partition(), commitMessage.bucket(), (IndexFileMeta)f));
            });
        }
    }

    private ManifestEntry makeEntry(FileKind kind, CommitMessage commitMessage, DataFileMeta file) {
        Integer totalBuckets = commitMessage.totalBuckets();
        if (totalBuckets == null) {
            totalBuckets = this.numBucket;
        }
        return new ManifestEntry(kind, commitMessage.partition(), commitMessage.bucket(), totalBuckets, file);
    }

    private int tryCommit(List<ManifestEntry> tableFiles, List<ManifestEntry> changelogFiles, List<IndexManifestEntry> indexFiles, long identifier, @Nullable Long watermark, Map<Integer, Long> logOffsets, Snapshot.CommitKind commitKind, ConflictCheck conflictCheck, @Nullable String statsFileName) {
        Snapshot latestSnapshot;
        CommitResult result;
        int retryCount = 0;
        RetryResult retryResult = null;
        long startMillis = System.currentTimeMillis();
        while (!(result = this.tryCommitOnce(retryResult, tableFiles, changelogFiles, indexFiles, identifier, watermark, logOffsets, commitKind, latestSnapshot = this.snapshotManager.latestSnapshot(), conflictCheck, statsFileName)).isSuccess()) {
            retryResult = (RetryResult)result;
            if (System.currentTimeMillis() - startMillis > this.commitTimeout || retryCount >= this.commitMaxRetries) {
                retryResult.cleanAll();
                throw new RuntimeException(String.format("Commit failed after %s millis with %s retries, there maybe exist commit conflicts between multiple jobs.", this.commitTimeout, retryCount));
            }
            ++retryCount;
        }
        return retryCount + 1;
    }

    private int tryOverwrite(@Nullable PartitionPredicate partitionFilter, List<ManifestEntry> changes, List<IndexManifestEntry> indexFiles, long identifier, @Nullable Long watermark, Map<Integer, Long> logOffsets) {
        Snapshot latestSnapshot = this.snapshotManager.latestSnapshot();
        ArrayList<ManifestEntry> changesWithOverwrite = new ArrayList<ManifestEntry>();
        ArrayList<IndexManifestEntry> indexChangesWithOverwrite = new ArrayList<IndexManifestEntry>();
        if (latestSnapshot != null) {
            this.scan.withSnapshot(latestSnapshot).withPartitionFilter(partitionFilter).withKind(ScanMode.ALL);
            if (this.numBucket != -2) {
                this.scan.withBucketFilter((Filter<Integer>)((Filter)bucket -> bucket >= 0));
            }
            List<ManifestEntry> currentEntries = this.scan.plan().files();
            for (ManifestEntry entry : currentEntries) {
                changesWithOverwrite.add(new ManifestEntry(FileKind.DELETE, entry.partition(), entry.bucket(), entry.totalBuckets(), entry.file()));
            }
            if (latestSnapshot.indexManifest() != null) {
                List entries = this.indexManifestFile.read(latestSnapshot.indexManifest());
                for (IndexManifestEntry entry : entries) {
                    if (partitionFilter != null && !partitionFilter.test(entry.partition())) continue;
                    indexChangesWithOverwrite.add(entry.toDeleteEntry());
                }
            }
        }
        changesWithOverwrite.addAll(changes);
        indexChangesWithOverwrite.addAll(indexFiles);
        return this.tryCommit(changesWithOverwrite, Collections.emptyList(), indexChangesWithOverwrite, identifier, watermark, logOffsets, Snapshot.CommitKind.OVERWRITE, FileStoreCommitImpl.mustConflictCheck(), null);
    }

    @VisibleForTesting
    CommitResult tryCommitOnce(@Nullable RetryResult retryResult, List<ManifestEntry> deltaFiles, List<ManifestEntry> changelogFiles, List<IndexManifestEntry> indexFiles, long identifier, @Nullable Long watermark, Map<Integer, Long> logOffsets, Snapshot.CommitKind commitKind, @Nullable Snapshot latestSnapshot, ConflictCheck conflictCheck, @Nullable String newStatsFileName) {
        Snapshot newSnapshot;
        ArrayList<PartitionEntry> deltaStatistics;
        long newSnapshotId;
        long startMillis = System.currentTimeMillis();
        long l = newSnapshotId = latestSnapshot == null ? 1L : latestSnapshot.id() + 1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ready to commit table files to snapshot {}", (Object)newSnapshotId);
            for (ManifestEntry entry : deltaFiles) {
                LOG.debug("  * {}", (Object)entry);
            }
            LOG.debug("Ready to commit changelog to snapshot {}", (Object)newSnapshotId);
            for (ManifestEntry entry : changelogFiles) {
                LOG.debug("  * {}", (Object)entry);
            }
        }
        ArrayList<SimpleFileEntry> baseDataFiles = new ArrayList();
        if (latestSnapshot != null && conflictCheck.shouldCheck(latestSnapshot.id())) {
            try {
                List<BinaryRow> changedPartitions = deltaFiles.stream().map(ManifestEntry::partition).distinct().collect(Collectors.toList());
                if (retryResult != null && retryResult.latestSnapshot != null) {
                    baseDataFiles = new ArrayList(retryResult.baseDataFiles);
                    List<SimpleFileEntry> incremental = this.readIncrementalChanges(retryResult.latestSnapshot, latestSnapshot, changedPartitions);
                    if (!incremental.isEmpty()) {
                        baseDataFiles.addAll(incremental);
                        baseDataFiles = new ArrayList<SimpleFileEntry>(FileEntry.mergeEntries(baseDataFiles));
                    }
                } else {
                    baseDataFiles = this.readAllEntriesFromChangedPartitions(latestSnapshot, changedPartitions);
                }
                this.noConflictsOrFail(latestSnapshot.commitUser(), baseDataFiles, SimpleFileEntry.from(deltaFiles));
            }
            catch (Exception e) {
                if (retryResult != null) {
                    retryResult.cleanAll();
                }
                throw e;
            }
        }
        Pair<String, Long> baseManifestList = null;
        Pair<String, Long> deltaManifestList = null;
        Pair<String, Long> changelogManifestList = null;
        String oldIndexManifest = null;
        String indexManifest = null;
        List<ManifestFileMeta> mergeBeforeManifests = new ArrayList<ManifestFileMeta>();
        List<ManifestFileMeta> mergeAfterManifests = new ArrayList<ManifestFileMeta>();
        try {
            Optional<Statistics> previousStatistic;
            long previousTotalRecordCount = 0L;
            Long currentWatermark = watermark;
            if (latestSnapshot != null) {
                Long latestWatermark;
                previousTotalRecordCount = this.scan.totalRecordCount(latestSnapshot);
                mergeBeforeManifests = this.manifestList.readDataManifests(latestSnapshot);
                Map<Integer, Long> latestLogOffsets = latestSnapshot.logOffsets();
                if (latestLogOffsets != null) {
                    latestLogOffsets.forEach(logOffsets::putIfAbsent);
                }
                if ((latestWatermark = latestSnapshot.watermark()) != null) {
                    currentWatermark = currentWatermark == null ? latestWatermark : Math.max(currentWatermark, latestWatermark);
                }
                oldIndexManifest = latestSnapshot.indexManifest();
            }
            mergeAfterManifests = ManifestFileMerger.merge(mergeBeforeManifests, this.manifestFile, this.manifestTargetSize.getBytes(), this.manifestMergeMinCount, this.manifestFullCompactionSize.getBytes(), this.partitionType, this.manifestReadParallelism);
            baseManifestList = this.manifestList.write(mergeAfterManifests);
            long deltaRecordCount = ManifestEntry.recordCountAdd(deltaFiles) - ManifestEntry.recordCountDelete(deltaFiles);
            long totalRecordCount = previousTotalRecordCount + deltaRecordCount;
            boolean rewriteIndexManifest = true;
            if (retryResult != null) {
                deltaStatistics = retryResult.deltaStatistics;
                deltaManifestList = retryResult.deltaManifestList;
                changelogManifestList = retryResult.changelogManifestList;
                if (Objects.equals(oldIndexManifest, retryResult.oldIndexManifest)) {
                    rewriteIndexManifest = false;
                    indexManifest = retryResult.newIndexManifest;
                    LOG.info("Reusing index manifest {} for retry.", (Object)indexManifest);
                } else {
                    this.cleanIndexManifest(retryResult.oldIndexManifest, retryResult.newIndexManifest);
                }
            } else {
                deltaStatistics = new ArrayList<PartitionEntry>(PartitionEntry.merge(deltaFiles));
                deltaManifestList = this.manifestList.write(this.manifestFile.write(deltaFiles));
                if (!changelogFiles.isEmpty()) {
                    changelogManifestList = this.manifestList.write(this.manifestFile.write(changelogFiles));
                }
            }
            if (rewriteIndexManifest) {
                indexManifest = this.indexManifestFile.writeIndexFiles(oldIndexManifest, indexFiles, this.bucketMode);
            }
            long latestSchemaId = this.schemaManager.latest().get().id();
            String statsFileName = null;
            if (newStatsFileName != null) {
                statsFileName = newStatsFileName;
            } else if (latestSnapshot != null && (previousStatistic = this.statsFileHandler.readStats(latestSnapshot)).isPresent()) {
                if (previousStatistic.get().schemaId() != latestSchemaId) {
                    LOG.warn("Schema changed, stats will not be inherited");
                } else {
                    statsFileName = latestSnapshot.statistics();
                }
            }
            newSnapshot = new Snapshot(newSnapshotId, latestSchemaId, (String)baseManifestList.getLeft(), (Long)baseManifestList.getRight(), (String)deltaManifestList.getKey(), (Long)deltaManifestList.getRight(), changelogManifestList == null ? null : (String)changelogManifestList.getKey(), changelogManifestList == null ? null : (Long)changelogManifestList.getRight(), indexManifest, this.commitUser, identifier, commitKind, System.currentTimeMillis(), logOffsets, totalRecordCount, deltaRecordCount, ManifestEntry.recordCount(changelogFiles), currentWatermark, statsFileName);
        }
        catch (Throwable e) {
            if (retryResult != null) {
                retryResult.cleanAll();
            }
            this.cleanUpReuseTmpManifests(deltaManifestList, changelogManifestList, oldIndexManifest, indexManifest);
            this.cleanUpNoReuseTmpManifests(baseManifestList, mergeBeforeManifests, mergeAfterManifests);
            throw new RuntimeException(String.format("Exception occurs when preparing snapshot #%d by user %s with hash %s and kind %s. Clean up.", newSnapshotId, this.commitUser, identifier, commitKind.name()), e);
        }
        if (this.commitSnapshotImpl(newSnapshot, deltaStatistics)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Successfully commit snapshot #%d by user %s with identifier %s and kind %s.", newSnapshotId, this.commitUser, identifier, commitKind.name()));
            }
            this.commitCallbacks.forEach(callback -> callback.call(deltaFiles, newSnapshot));
            return new SuccessResult();
        }
        long commitTime = (System.currentTimeMillis() - startMillis) / 1000L;
        LOG.warn(String.format("Atomic commit failed for snapshot #%d by user %s with identifier %s and kind %s after %s seconds. Clean up and try again.", newSnapshotId, this.commitUser, identifier, commitKind.name(), commitTime));
        this.cleanUpNoReuseTmpManifests(baseManifestList, mergeBeforeManifests, mergeAfterManifests);
        return new RetryResult(deltaStatistics, deltaManifestList, changelogManifestList, oldIndexManifest, indexManifest, latestSnapshot, baseDataFiles);
    }

    @Override
    public void compactManifest() {
        int retryCount = 0;
        ManifestCompactResult retryResult = null;
        long startMillis = System.currentTimeMillis();
        while (!(retryResult = this.compactManifest(retryResult)).isSuccess()) {
            if (System.currentTimeMillis() - startMillis > this.commitTimeout || retryCount >= this.commitMaxRetries) {
                retryResult.cleanAll();
                throw new RuntimeException(String.format("Commit failed after %s millis with %s retries, there maybe exist commit conflicts between multiple jobs.", this.commitTimeout, retryCount));
            }
            ++retryCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private ManifestCompactResult compactManifest(@Nullable ManifestCompactResult lastResult) {
        List<ManifestFileMeta> mergeAfterManifests;
        Snapshot latestSnapshot = this.snapshotManager.latestSnapshot();
        if (latestSnapshot == null) {
            return new SuccessManifestCompactResult();
        }
        List<ManifestFileMeta> mergeBeforeManifests = this.manifestList.readDataManifests(latestSnapshot);
        if (lastResult != null) {
            List oldMergeBeforeManifests = lastResult.mergeBeforeManifests;
            List oldMergeAfterManifests = lastResult.mergeAfterManifests;
            Set retryMergeBefore = oldMergeBeforeManifests.stream().map(ManifestFileMeta::fileName).collect(Collectors.toSet());
            List manifestsFromOther = mergeBeforeManifests.stream().filter(m -> !retryMergeBefore.remove(m.fileName())).collect(Collectors.toList());
            if (!retryMergeBefore.isEmpty()) {
                lastResult.cleanAll();
                return new SuccessManifestCompactResult();
            }
            mergeAfterManifests = new ArrayList<ManifestFileMeta>(oldMergeAfterManifests);
            mergeAfterManifests.addAll(manifestsFromOther);
        } else {
            mergeAfterManifests = ManifestFileMerger.merge(mergeBeforeManifests, this.manifestFile, this.manifestTargetSize.getBytes(), 1, 1L, this.partitionType, this.manifestReadParallelism);
            if (new HashSet<ManifestFileMeta>(mergeBeforeManifests).equals(new HashSet<ManifestFileMeta>(mergeAfterManifests))) {
                return new SuccessManifestCompactResult();
            }
        }
        Pair<String, Long> baseManifestList = this.manifestList.write(mergeAfterManifests);
        Pair<String, Long> deltaManifestList = this.manifestList.write(Collections.emptyList());
        Snapshot newSnapshot = new Snapshot(latestSnapshot.id() + 1L, latestSnapshot.schemaId(), (String)baseManifestList.getLeft(), (Long)baseManifestList.getRight(), (String)deltaManifestList.getLeft(), (Long)deltaManifestList.getRight(), null, null, latestSnapshot.indexManifest(), this.commitUser, Long.MAX_VALUE, Snapshot.CommitKind.COMPACT, System.currentTimeMillis(), latestSnapshot.logOffsets(), latestSnapshot.totalRecordCount(), 0L, 0L, latestSnapshot.watermark(), latestSnapshot.statistics());
        if (!this.commitSnapshotImpl(newSnapshot, Collections.emptyList())) {
            return new ManifestCompactResult(baseManifestList, deltaManifestList, mergeBeforeManifests, mergeAfterManifests);
        }
        return new SuccessManifestCompactResult();
    }

    private boolean commitSnapshotImpl(Snapshot newSnapshot, List<PartitionEntry> deltaStatistics) {
        try {
            ArrayList<PartitionStatistics> statistics = new ArrayList<PartitionStatistics>(deltaStatistics.size());
            for (PartitionEntry entry : deltaStatistics) {
                statistics.add(entry.toPartitionStatistics(this.partitionComputer));
            }
            return this.snapshotCommit.commit(newSnapshot, this.branchName, statistics);
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Exception occurs when committing snapshot #%d by user %s with identifier %s and kind %s. Cannot clean up because we can't determine the success.", newSnapshot.id(), this.commitUser, newSnapshot.commitIdentifier(), newSnapshot.commitKind().name()), e);
        }
    }

    private List<SimpleFileEntry> readIncrementalChanges(Snapshot from, Snapshot to, List<BinaryRow> changedPartitions) {
        ArrayList<SimpleFileEntry> entries = new ArrayList<SimpleFileEntry>();
        for (long i = from.id() + 1L; i <= to.id(); ++i) {
            List<SimpleFileEntry> delta = this.scan.withSnapshot(i).withKind(ScanMode.DELTA).withPartitionFilter(changedPartitions).readSimpleEntries();
            entries.addAll(delta);
        }
        return entries;
    }

    @SafeVarargs
    private final List<SimpleFileEntry> readAllEntriesFromChangedPartitions(Snapshot snapshot, List<ManifestEntry> ... changes) {
        List<BinaryRow> changedPartitions = Arrays.stream(changes).flatMap(Collection::stream).map(ManifestEntry::partition).distinct().collect(Collectors.toList());
        return this.readAllEntriesFromChangedPartitions(snapshot, changedPartitions);
    }

    private List<SimpleFileEntry> readAllEntriesFromChangedPartitions(Snapshot snapshot, List<BinaryRow> changedPartitions) {
        try {
            return this.scan.withSnapshot(snapshot).withKind(ScanMode.ALL).withPartitionFilter(changedPartitions).readSimpleEntries();
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot read manifest entries from changed partitions.", e);
        }
    }

    private void noConflictsOrFail(String baseCommitUser, List<SimpleFileEntry> baseEntries, List<SimpleFileEntry> changes) {
        ArrayList<SimpleFileEntry> allEntries = new ArrayList<SimpleFileEntry>(baseEntries);
        allEntries.addAll(changes);
        Consumer<Throwable> conflictHandler = e -> {
            Pair<RuntimeException, RuntimeException> conflictException = this.createConflictException("File deletion conflicts detected! Give up committing.", baseCommitUser, baseEntries, changes, (Throwable)e, 50);
            LOG.warn("", (Throwable)conflictException.getLeft());
            throw (RuntimeException)conflictException.getRight();
        };
        Collection<SimpleFileEntry> mergedEntries = null;
        try {
            mergedEntries = FileEntry.mergeEntries(allEntries);
        }
        catch (Throwable e2) {
            conflictHandler.accept(e2);
        }
        this.assertNoDelete(mergedEntries, conflictHandler);
        if (this.keyComparator == null) {
            return;
        }
        HashMap<LevelIdentifier, List> levels = new HashMap<LevelIdentifier, List>();
        for (SimpleFileEntry entry : mergedEntries) {
            int level = entry.level();
            if (level < 1) continue;
            levels.computeIfAbsent(new LevelIdentifier(entry.partition(), entry.bucket(), level), lv -> new ArrayList()).add(entry);
        }
        for (List entries : levels.values()) {
            entries.sort((a, b) -> this.keyComparator.compare((InternalRow)a.minKey(), (InternalRow)b.minKey()));
            int i = 0;
            while (i + 1 < entries.size()) {
                SimpleFileEntry a2 = (SimpleFileEntry)entries.get(i);
                SimpleFileEntry b2 = (SimpleFileEntry)entries.get(i + 1);
                if (this.keyComparator.compare((InternalRow)a2.maxKey(), (InternalRow)b2.minKey()) >= 0) {
                    Pair<RuntimeException, RuntimeException> conflictException = this.createConflictException("LSM conflicts detected! Give up committing. Conflict files are:\n" + a2.identifier().toString(this.pathFactory) + "\n" + b2.identifier().toString(this.pathFactory), baseCommitUser, baseEntries, changes, null, 50);
                    LOG.warn("", (Throwable)conflictException.getLeft());
                    throw (RuntimeException)conflictException.getRight();
                }
                ++i;
            }
        }
    }

    private void assertNoDelete(Collection<SimpleFileEntry> mergedEntries, Consumer<Throwable> conflictHandler) {
        try {
            for (SimpleFileEntry entry : mergedEntries) {
                Preconditions.checkState((entry.kind() != FileKind.DELETE ? 1 : 0) != 0, (String)"Trying to delete file %s for table %s which is not previously added.", (Object[])new Object[]{entry.fileName(), this.tableName});
            }
        }
        catch (Throwable e) {
            if (this.partitionExpire != null && this.partitionExpire.isValueExpiration()) {
                HashSet<BinaryRow> deletedPartitions = new HashSet<BinaryRow>();
                for (SimpleFileEntry entry : mergedEntries) {
                    if (entry.kind() != FileKind.DELETE) continue;
                    deletedPartitions.add(entry.partition());
                }
                if (this.partitionExpire.isValueAllExpired(deletedPartitions)) {
                    List expiredPartitions = deletedPartitions.stream().map(partition -> InternalRowPartitionComputer.partToSimpleString((RowType)this.partitionType, (BinaryRow)partition, (String)"-", (int)200)).collect(Collectors.toList());
                    throw new RuntimeException("You are writing data to expired partitions, and you can filter this data to avoid job failover. Otherwise, continuous expired records will cause the job to failover restart continuously. Expired partitions are: " + expiredPartitions);
                }
            }
            conflictHandler.accept(e);
        }
    }

    private Pair<RuntimeException, RuntimeException> createConflictException(String message, String baseCommitUser, List<SimpleFileEntry> baseEntries, List<SimpleFileEntry> changes, Throwable cause, int maxEntry) {
        String possibleCauses = String.join((CharSequence)"\n", "Don't panic!", "Conflicts during commits are normal and this failure is intended to resolve the conflicts.", "Conflicts are mainly caused by the following scenarios:", "1. Multiple jobs are writing into the same partition at the same time, or you use STATEMENT SET to execute multiple INSERT statements into the same Paimon table.", "   You'll probably see different base commit user and current commit user below.", "   You can use https://paimon.apache.org/docs/master/maintenance/dedicated-compaction#dedicated-compaction-job to support multiple writing.", "2. You're recovering from an old savepoint, or you're creating multiple jobs from a savepoint.", "   The job will fail continuously in this scenario to protect metadata from corruption.", "   You can either recover from the latest savepoint, or you can revert the table to the snapshot corresponding to the old savepoint.");
        String commitUserString = "Base commit user is: " + baseCommitUser + "; Current commit user is: " + this.commitUser;
        String baseEntriesString = "Base entries are:\n" + baseEntries.stream().map(Object::toString).collect(Collectors.joining("\n"));
        String changesString = "Changes are:\n" + changes.stream().map(Object::toString).collect(Collectors.joining("\n"));
        RuntimeException fullException = new RuntimeException(message + "\n\n" + possibleCauses + "\n\n" + commitUserString + "\n\n" + baseEntriesString + "\n\n" + changesString, cause);
        if (baseEntries.size() > maxEntry || changes.size() > maxEntry) {
            baseEntriesString = "Base entries are:\n" + baseEntries.subList(0, Math.min(baseEntries.size(), maxEntry)).stream().map(Object::toString).collect(Collectors.joining("\n"));
            changesString = "Changes are:\n" + changes.subList(0, Math.min(changes.size(), maxEntry)).stream().map(Object::toString).collect(Collectors.joining("\n"));
            RuntimeException simplifiedException = new RuntimeException(message + "\n\n" + possibleCauses + "\n\n" + commitUserString + "\n\n" + baseEntriesString + "\n\n" + changesString + "\n\nThe entry list above are not fully displayed, please refer to taskmanager.log for more information.", cause);
            return Pair.of((Object)fullException, (Object)simplifiedException);
        }
        return Pair.of((Object)fullException, (Object)fullException);
    }

    private void cleanUpNoReuseTmpManifests(Pair<String, Long> baseManifestList, List<ManifestFileMeta> mergeBeforeManifests, List<ManifestFileMeta> mergeAfterManifests) {
        if (baseManifestList != null) {
            this.manifestList.delete((String)baseManifestList.getKey());
        }
        Set oldMetaSet = mergeBeforeManifests.stream().map(ManifestFileMeta::fileName).collect(Collectors.toSet());
        for (ManifestFileMeta suspect : mergeAfterManifests) {
            if (oldMetaSet.contains(suspect.fileName())) continue;
            this.manifestFile.delete(suspect.fileName());
        }
    }

    private void cleanUpReuseTmpManifests(Pair<String, Long> deltaManifestList, Pair<String, Long> changelogManifestList, String oldIndexManifest, String newIndexManifest) {
        if (deltaManifestList != null) {
            for (ManifestFileMeta manifest : this.manifestList.read((String)deltaManifestList.getKey())) {
                this.manifestFile.delete(manifest.fileName());
            }
            this.manifestList.delete((String)deltaManifestList.getKey());
        }
        if (changelogManifestList != null) {
            for (ManifestFileMeta manifest : this.manifestList.read((String)changelogManifestList.getKey())) {
                this.manifestFile.delete(manifest.fileName());
            }
            this.manifestList.delete((String)changelogManifestList.getKey());
        }
        this.cleanIndexManifest(oldIndexManifest, newIndexManifest);
    }

    private void cleanIndexManifest(String oldIndexManifest, String newIndexManifest) {
        if (newIndexManifest != null && !Objects.equals(oldIndexManifest, newIndexManifest)) {
            this.indexManifestFile.delete(newIndexManifest);
        }
    }

    @Override
    public void close() {
        for (CommitCallback callback : this.commitCallbacks) {
            IOUtils.closeQuietly((AutoCloseable)callback);
        }
        IOUtils.closeQuietly((AutoCloseable)this.snapshotCommit);
    }

    static ConflictCheck hasConflictChecked(@Nullable Long checkedLatestSnapshotId) {
        return latestSnapshot -> !Objects.equals(latestSnapshot, checkedLatestSnapshotId);
    }

    static ConflictCheck noConflictCheck() {
        return latestSnapshot -> false;
    }

    @VisibleForTesting
    static ConflictCheck mustConflictCheck() {
        return latestSnapshot -> true;
    }

    private class SuccessManifestCompactResult
    extends ManifestCompactResult {
        public SuccessManifestCompactResult() {
            super(null, null, null, null);
        }

        @Override
        public void cleanAll() {
        }

        @Override
        public boolean isSuccess() {
            return true;
        }
    }

    private class ManifestCompactResult
    implements CommitResult {
        private final Pair<String, Long> baseManifestList;
        private final Pair<String, Long> deltaManifestList;
        private final List<ManifestFileMeta> mergeBeforeManifests;
        private final List<ManifestFileMeta> mergeAfterManifests;

        public ManifestCompactResult(Pair<String, Long> baseManifestList, Pair<String, Long> deltaManifestList, List<ManifestFileMeta> mergeBeforeManifests, List<ManifestFileMeta> mergeAfterManifests) {
            this.baseManifestList = baseManifestList;
            this.deltaManifestList = deltaManifestList;
            this.mergeBeforeManifests = mergeBeforeManifests;
            this.mergeAfterManifests = mergeAfterManifests;
        }

        public void cleanAll() {
            FileStoreCommitImpl.this.manifestList.delete((String)this.deltaManifestList.getKey());
            FileStoreCommitImpl.this.cleanUpNoReuseTmpManifests((Pair<String, Long>)this.baseManifestList, this.mergeBeforeManifests, this.mergeAfterManifests);
        }

        @Override
        public boolean isSuccess() {
            return false;
        }
    }

    private class RetryResult
    implements CommitResult {
        private final List<PartitionEntry> deltaStatistics;
        private final Pair<String, Long> deltaManifestList;
        private final Pair<String, Long> changelogManifestList;
        private final String oldIndexManifest;
        private final String newIndexManifest;
        private final Snapshot latestSnapshot;
        private final List<SimpleFileEntry> baseDataFiles;

        private RetryResult(List<PartitionEntry> deltaStatistics, Pair<String, Long> deltaManifestList, Pair<String, Long> changelogManifestList, String oldIndexManifest, String newIndexManifest, Snapshot latestSnapshot, List<SimpleFileEntry> baseDataFiles) {
            this.deltaStatistics = deltaStatistics;
            this.deltaManifestList = deltaManifestList;
            this.changelogManifestList = changelogManifestList;
            this.oldIndexManifest = oldIndexManifest;
            this.newIndexManifest = newIndexManifest;
            this.latestSnapshot = latestSnapshot;
            this.baseDataFiles = baseDataFiles;
        }

        private void cleanAll() {
            FileStoreCommitImpl.this.cleanUpReuseTmpManifests((Pair<String, Long>)this.deltaManifestList, (Pair<String, Long>)this.changelogManifestList, this.oldIndexManifest, this.newIndexManifest);
        }

        @Override
        public boolean isSuccess() {
            return false;
        }
    }

    private static class SuccessResult
    implements CommitResult {
        private SuccessResult() {
        }

        @Override
        public boolean isSuccess() {
            return true;
        }
    }

    private static interface CommitResult {
        public boolean isSuccess();
    }

    static interface ConflictCheck {
        public boolean shouldCheck(long var1);
    }

    private static class LevelIdentifier {
        private final BinaryRow partition;
        private final int bucket;
        private final int level;

        private LevelIdentifier(BinaryRow partition, int bucket, int level) {
            this.partition = partition;
            this.bucket = bucket;
            this.level = level;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LevelIdentifier)) {
                return false;
            }
            LevelIdentifier that = (LevelIdentifier)o;
            return Objects.equals(this.partition, that.partition) && this.bucket == that.bucket && this.level == that.level;
        }

        public int hashCode() {
            return Objects.hash(this.partition, this.bucket, this.level);
        }
    }
}

